/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.util.Password;

public class VerifyCert {
    public void showCert(String certFile) {
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(certFile));
            Certificate cert = (Certificate)Certificate.getTemplate().decode(bis);
            CertificateInfo info = cert.getInfo();
            info.print(System.out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private void usage() {
        System.out.println("Usage: java org.mozilla.jss.tests.VerifyCert");
        System.out.println("\noptions:\n\n<dbdir> <passwd> <nicknameOfCertinDB> <OCSPResponderURL> <OCSPCertNickname>\n");
        System.out.println("<dbdir> <passwd> <DerEncodeCertFile> <OCSPResponderURL> <OCSPCertNickname>\n");
        System.out.println("Note: <OCSPResponderURL> and <OCSPCertNickname> are optional.\n But if used, both Url/nickname must be specified.");
    }

    public static void main(String[] args) {
        try {
            VerifyCert vc = new VerifyCert();
            if (args.length < 3) {
                vc.usage();
                return;
            }
            String dbdir = args[0];
            String password = args[1];
            String name = args[2];
            String ResponderURL = null;
            String ResponderNickname = null;
            if (args.length == 4 || args.length > 5) {
                vc.usage();
            } else if (args.length == 5) {
                ResponderURL = args[3];
                ResponderNickname = args[4];
            }
            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(dbdir);
            vals.PKIXVerify = true;
            vals.cooperate = true;
            vals.ocspCheckingEnabled = true;
            if (ResponderURL != null && ResponderNickname != null) {
                vals.ocspResponderCertNickname = ResponderNickname;
                vals.ocspResponderURL = ResponderURL;
            }
            CryptoManager.initialize(vals);
            CryptoManager cm = CryptoManager.getInstance();
            Password pwd = new Password(password.toCharArray());
            cm.setPasswordCallback(pwd);
            try {
                FileInputStream fin = new FileInputStream(name);
                byte[] pkg = new byte[fin.available()];
                fin.read(pkg);
                vc.showCert(name);
                vc.validateDerCert(pkg, cm);
            }
            catch (FileNotFoundException e) {
                vc.validateCertInDB(name, cm);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void validateDerCert(byte[] pkg, CryptoManager cm) {
        ArrayList<String> usageList = new ArrayList<String>();
        try {
            Iterator list = CryptoManager.CertUsage.getCertUsages();
            while (list.hasNext()) {
                CryptoManager.CertUsage certUsage = (CryptoManager.CertUsage)list.next();
                if (certUsage.equals(CryptoManager.CertUsage.UserCertImport) || certUsage.equals(CryptoManager.CertUsage.ProtectedObjectSigner) || certUsage.equals(CryptoManager.CertUsage.AnyCA) || !cm.isCertValid(pkg, true, certUsage)) continue;
                usageList.add(certUsage.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (usageList.isEmpty()) {
            System.out.println("The certificate is not valid.");
        } else {
            System.out.println("The certificate is valid for the following usages:\n");
            Iterator iterateUsage = usageList.iterator();
            while (iterateUsage.hasNext()) {
                System.out.println("                       " + iterateUsage.next());
            }
        }
    }

    public void validateCertInDB(String nickname, CryptoManager cm) {
        ArrayList<String> usageList = new ArrayList<String>();
        try {
            Iterator list = CryptoManager.CertUsage.getCertUsages();
            while (list.hasNext()) {
                CryptoManager.CertUsage certUsage = (CryptoManager.CertUsage)list.next();
                if (certUsage.equals(CryptoManager.CertUsage.UserCertImport) || certUsage.equals(CryptoManager.CertUsage.ProtectedObjectSigner) || certUsage.equals(CryptoManager.CertUsage.AnyCA) || !cm.isCertValid(nickname, true, certUsage)) continue;
                usageList.add(certUsage.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (usageList.isEmpty()) {
            System.out.println("The certificate is not valid.");
        } else {
            System.out.println("The certificate is valid for the following usages:\n");
            Iterator iterateUsage = usageList.iterator();
            while (iterateUsage.hasNext()) {
                System.out.println("                       " + iterateUsage.next());
            }
        }
    }
}

