/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Base64OutputStream;

public class Base64InputStream
extends FilterInputStream {
    private static final int WOULD_BLOCK = -2;
    private static int[] table;
    private int prev;
    private int savedPrev;
    private int state = 1;
    private int savedState;

    public Base64InputStream(InputStream in) {
        super(in);
    }

    public long skip(long n) throws IOException {
        long count;
        for (count = 0L; count < n && this.read() != -1; ++count) {
        }
        return count;
    }

    private int read(boolean block) throws IOException {
        int ret = 0;
        boolean done = false;
        block7: while (!done) {
            if (this.in.available() < 1 && !block) {
                return -2;
            }
            int cur = this.in.read();
            switch (this.state) {
                case 1: {
                    if (cur == -1) {
                        this.state = 5;
                        return -1;
                    }
                    if (cur == 61) {
                        this.state = 5;
                        throw new IOException("Invalid pad character");
                    }
                    if (table[cur] == -1) continue block7;
                    this.prev = cur;
                    this.state = 2;
                    continue block7;
                }
                case 2: {
                    if (cur == -1) {
                        this.state = 5;
                        throw new EOFException("Unexpected end-of-file");
                    }
                    if (cur == 61) {
                        this.state = 5;
                        throw new IOException("Invalid pad character");
                    }
                    if (table[cur] == -1) continue block7;
                    ret = table[this.prev] << 2 | (table[cur] & 0x30) >> 4;
                    this.prev = cur;
                    this.state = 3;
                    done = true;
                    continue block7;
                }
                case 3: {
                    if (cur == -1) {
                        this.state = 5;
                        throw new EOFException("Unexpected end-of-file");
                    }
                    if (cur == 61) {
                        this.state = 5;
                        return -1;
                    }
                    if (table[cur] == -1) continue block7;
                    ret = (table[this.prev] & 0xF) << 4 | (table[cur] & 0x3C) >> 2;
                    this.prev = cur;
                    this.state = 4;
                    done = true;
                    continue block7;
                }
                case 4: {
                    if (cur == -1) {
                        this.state = 5;
                        throw new EOFException("Unexpected end-of-file");
                    }
                    if (cur == 61) {
                        this.state = 5;
                        return -1;
                    }
                    if (table[cur] == -1) continue block7;
                    ret = (table[this.prev] & 3) << 6 | table[cur];
                    this.state = 1;
                    done = true;
                    continue block7;
                }
                case 5: {
                    return -1;
                }
            }
            Assert._assert(false);
        }
        return ret;
    }

    public int read() throws IOException {
        return this.read(true);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = 0;
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off is negative");
        }
        while (count < len) {
            int cur = this.read(count == 0);
            if (cur == -1) {
                if (count == 0) {
                    return -1;
                }
                return count;
            }
            if (cur == -2) {
                Assert._assert(count > 0);
                return count;
            }
            Assert._assert(cur >= 0 && cur <= 255);
            b[off + count++] = (byte)cur;
        }
        return count;
    }

    public int available() throws IOException {
        return 0;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.savedPrev = this.prev;
        this.savedState = this.state;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void reset() throws IOException {
        this.in.reset();
        this.prev = this.savedPrev;
        this.state = this.savedState;
    }

    public static void main(String[] args) throws Exception {
        int numread;
        String infile = args[0];
        String b64file = infile.concat(".b64");
        String newfile = infile.concat(".recov");
        FileInputStream fis = new FileInputStream(infile);
        ByteArrayOutputStream origStream = new ByteArrayOutputStream();
        ByteArrayOutputStream b64OStream = new ByteArrayOutputStream();
        Base64OutputStream b64Stream = new Base64OutputStream(new PrintStream(b64OStream), 18);
        byte[] data = new byte[1024];
        while ((numread = fis.read(data, 0, 1024)) != -1) {
            origStream.write(data, 0, numread);
            b64Stream.write(data, 0, numread);
        }
        b64Stream.close();
        origStream.close();
        Base64InputStream bis = new Base64InputStream(new ByteArrayInputStream(b64OStream.toByteArray()));
        ByteArrayOutputStream newStream = new ByteArrayOutputStream();
        while ((numread = bis.read(data, 0, 1024)) != -1) {
            newStream.write(data, 0, numread);
        }
        newStream.close();
        if (!Arrays.equals(origStream.toByteArray(), newStream.toByteArray())) {
            throw new Exception("Did not recover original data");
        }
    }

    static {
        int c;
        int i;
        table = new int[256];
        for (i = 0; i < 256; ++i) {
            Base64InputStream.table[i] = -1;
        }
        i = 0;
        for (c = 65; c <= 90; ++c) {
            Base64InputStream.table[c] = i++;
        }
        for (c = 97; c <= 122; ++c) {
            Base64InputStream.table[c] = i++;
        }
        for (c = 48; c <= 57; ++c) {
            Base64InputStream.table[c] = i++;
        }
        Base64InputStream.table[43] = 62;
        Base64InputStream.table[47] = 63;
    }
}

