/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import org.mozilla.jss.util.AssertionException;

public class Debug {
    public static final boolean DEBUG = true;
    public static final int OBNOXIOUS = 10;
    public static final int VERBOSE = 5;
    public static final int ERROR = 1;
    public static final int QUIET = 0;
    private static int mDebugLevel = 5;

    public static synchronized void trace(int level, String str) {
        if (level < 0) {
            throw new AssertionException("invalid debugging level " + level + " in trace");
        }
        if (level <= mDebugLevel) {
            System.out.println(Thread.currentThread().getName() + ": " + str);
            System.out.flush();
        }
    }

    public static synchronized void trace(String str) {
        Debug.trace(5, str);
    }

    public static synchronized void setLevel(int level) {
        if (level < 0) {
            throw new AssertionException("invalid debugging level set");
        }
        mDebugLevel = level;
        Debug.setNativeLevel(level);
    }

    private static native void setNativeLevel(int var0);

    public static synchronized int getLevel() {
        return mDebugLevel;
    }

    public static synchronized String getLevelStr() {
        switch (mDebugLevel) {
            case 0: {
                return "QUIET";
            }
            case 1: {
                return "ERROR";
            }
            case 5: {
                return "VERBOSE";
            }
            case 10: {
                return "OBNOXIOUS";
            }
        }
        return String.valueOf(mDebugLevel);
    }
}

