# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

e2e-intro-description = დაშიფრული ან ციფრულად ხელმოწერილი წერილის გასაგზავნად საჭიროა, გამართოთ დაშიფვრის საშუალება, OpenPGP ან S/MIME.
e2e-intro-description-more = მიუთითეთ პირადი გასაღები, რომ ჩაირთოს OpenPGP, ან პირადი სერტიფიკატი, რომ ჩაირთოს S/MIME. პირადი გასაღებისთვის ან სერტიფიკატისთვის უნდა ფლობდეთ შესაბამის საიდუმლო გასაღებს.
e2e-signing-description = ციფრული ხელმოწერა საშუალებას აძლევს მიმღებს დაადასტუროს, რომ წერილი ნამდვილად თქვენ გაუგზავნეთ და მისი შიგთავსი არავის შეუცვლია. დაშიფრული წერილები თავისთავად ხელმოწერილია.
e2e-sign-message =
    .label = დაუშიფრავის წერილის ხელმოწერა
    .accesskey = ხ
e2e-disable-enc =
    .label = დაშიფვრის გამორთვა ახალი წერილებისთვის
    .accesskey = მ
e2e-enable-enc =
    .label = დაშიფვრის ჩართვა ახალი წერილებისთვის
    .accesskey = ჩ
e2e-enable-description = დაშიფვრა შეგიძლიათ გამორთოთ ცალკეული წერილებისთვის.
e2e-advanced-section = გაფართოებული პარამეტრები
e2e-attach-key =
    .label = საჯარო გასაღების დართვა, ციფრული OpenPGP-ხელმოწერის დამატებისას
    .accesskey = p
e2e-encrypt-subject =
    .label = დაიშიფროს OpenPGP-წერილის თემა
    .accesskey = თ
e2e-encrypt-drafts =
    .label = გასაგზავნი წერილების დაშიფრულად შენახვა
    .accesskey = ხ
openpgp-key-created-label =
    .label = შექმნილი
openpgp-key-expiry-label =
    .label = ვადა
openpgp-key-id-label =
    .label = გასაღების ID
openpgp-cannot-change-expiry = ეს გასაღები რთული აგებულებისაა, მისი ვადის ცვლილება, არ არის მხარდაჭერილი.
openpgp-key-man-title =
    .title = OpenPGP-გასაღების მმართველი
openpgp-key-man-dialog-title = OpenPGP-გასაღების მმართველი
openpgp-key-man-generate =
    .label = გასაღებების ახალი წყვილი
    .accesskey = ღ
openpgp-key-man-gen-revoke =
    .label = გაუქმების სერტიფიკატი
    .accesskey = ქ
openpgp-key-man-ctx-gen-revoke-label =
    .label = შედგენა და შენახვა გაუქმების სერტიფიკატის
openpgp-key-man-file-menu =
    .label = ფაილი
    .accesskey = ფ
openpgp-key-man-edit-menu =
    .label = ჩასწორება
    .accesskey = ჩ
openpgp-key-man-view-menu =
    .label = ხედი
    .accesskey = ხ
openpgp-key-man-generate-menu =
    .label = შედგენა
    .accesskey = დ
openpgp-key-man-keyserver-menu =
    .label = გასაღებების სერვერი
    .accesskey = ღ
openpgp-key-man-import-public-from-file =
    .label = საჯარო გასაღებ(ებ)ის შეტანა ფაილიდან
    .accesskey = შ
openpgp-key-man-import-secret-from-file =
    .label = საიდუმლო გასაღებ(ებ)ის შეტანა ფაილიდან
openpgp-key-man-import-sig-from-file =
    .label = გაუქმებ(ებ)ის შეტანა ფაილიდან
openpgp-key-man-import-from-clipbrd =
    .label = გასაღებ(ებ)ის შეტანა აღებული ასლიდან
    .accesskey = შ
openpgp-key-man-import-from-url =
    .label = გასაღებ(ებ)ის შეტანა ბმულიდან
    .accesskey = უ
openpgp-key-man-export-to-file =
    .label = საჯარო გასაღებ(ებ)ის გატანა ფაილში
    .accesskey = ტ
openpgp-key-man-send-keys =
    .label = საჯარო გასაღებ(ებ)ის ელფოსტით გაგზავნა
    .accesskey = ზ
openpgp-key-man-backup-secret-keys =
    .label = საჯარო გასაღებ(ებ)ის მარქაფი ფაილში
    .accesskey = ფ
openpgp-key-man-discover-cmd =
    .label = გასაღებების მოძიება ინტერნეტში
    .accesskey = ძ
openpgp-key-man-discover-prompt = OpenPGP-გასაღებების ინტერნეტში მოსაძებნად სერვერებზე ან WKD-ოქმის მეშვეობით, შეიყვანეთ ელფოსტის მისამართი ან გასაღების ID.
openpgp-key-man-discover-progress = ეძებს…
openpgp-key-copy-key =
    .label = საჯარო გასაღების ასლი
    .accesskey = ლ
openpgp-key-export-key =
    .label = საჯარო გასაღების გატანა ფაილში
    .accesskey = ტ
openpgp-key-backup-key =
    .label = საიდუმლო გასაღების მარქაფი ფაილში
    .accesskey = ქ
openpgp-key-send-key =
    .label = საჯარო გასაღების ელფოსტით გაგზავნა
    .accesskey = ზ
# Variables:
# $count (Number) - Number of keys ids to copy.
openpgp-key-man-copy-key-ids =
    .label =
        { $count ->
            [one] გასაღები ID-ის ასლის აღება
           *[other] გასაღები ID-ების ასლის აღება
        }
    .accesskey = ღ
# Variables:
# $count (Number) - Number of fingerprints to copy.
openpgp-key-man-copy-fprs =
    .label =
        { $count ->
            [one] ანაბეჭდის ასლის აღება
           *[other] ანაბეჭდების ასლის აღება
        }
    .accesskey = ჭ
# Variables:
# $count (Number) - Number of public keys to copy.
openpgp-key-man-copy-to-clipboard =
    .label =
        { $count ->
            [one] საჯარო გასაღების ასლის აღება
           *[other] საჯარო გასაღებების ასლის აღება
        }
    .accesskey = ჯ
openpgp-key-man-ctx-expor-to-file-label =
    .label = გასაღებების გატანა ფაილში
openpgp-key-man-ctx-copy =
    .label = ასლი
    .accesskey = ლ
# Variables:
# $count (Number) - Number of fingerprints.
openpgp-key-man-ctx-copy-fprs =
    .label =
        { $count ->
            [one] ანაბეჭდი
           *[other] ანაბეჭდები
        }
    .accesskey = ჭ
# Variables:
# $count (Number) - Number of key ids.
openpgp-key-man-ctx-copy-key-ids =
    .label =
        { $count ->
            [one] გასაღები ID
           *[other] გასაღები ID-ები
        }
    .accesskey = ღ
# Variables:
# $count (Number) - Number of public keys.
openpgp-key-man-ctx-copy-public-keys =
    .label =
        { $count ->
            [one] საჯარო გასაღები
           *[other] საჯარო გასაღებები
        }
    .accesskey = ჯ
openpgp-key-man-close =
    .label = დახურვა
openpgp-key-man-reload =
    .label = გასაღების მარაგის განახლება
    .accesskey = ხ
openpgp-key-man-change-expiry =
    .label = ვადის შეცვლა
    .accesskey = ვ
openpgp-key-man-refresh-online =
    .label = განახლება ქსელიდან
    .accesskey = ნ
openpgp-key-man-ignored-ids =
    .label = ელფოსტის მისამართები
openpgp-key-man-del-key =
    .label = გასაღებ(ებ)ის წაშლა
    .accesskey = წ
openpgp-delete-key =
    .label = გასაღების წაშლა
    .accesskey = წ
openpgp-key-man-revoke-key =
    .label = გასაღების გაუქმება
    .accesskey = ქ
openpgp-key-man-key-props =
    .label = გასაღების თვისებები
    .accesskey = ღ
openpgp-key-man-key-more =
    .label = სხვა
    .accesskey = ს
openpgp-key-man-view-photo =
    .label = ფოტოს ID
    .accesskey = ფ
openpgp-key-man-ctx-view-photo-label =
    .label = ფოტოს ID-ის ჩვენება
openpgp-key-man-show-invalid-keys =
    .label = არამართებული გასაღებების ჩვენება
    .accesskey = ჩ
openpgp-key-man-show-others-keys =
    .label = სხვა ხალხის გასაღებების ჩვენება
    .accesskey = ხ
openpgp-key-man-user-id-label =
    .label = სახელი
openpgp-key-man-fingerprint-label =
    .label = ანაბეჭდი
openpgp-key-man-select-all =
    .label = ყველა გასაღების შერჩევა
    .accesskey = ყ
openpgp-key-man-empty-tree-tooltip =
    .label = შეიყვანეთ საძიებო ფრაზები ზედა ველში
openpgp-key-man-nothing-found-tooltip =
    .label = გასაღებები ვერ მოიძებნა თქვენი ფრაზით
openpgp-key-man-please-wait-tooltip =
    .label = გთხოვთ, მოითმინოთ გასაღებების ჩატვირთვამდე…
openpgp-key-man-filter-label =
    .placeholder = გასაღებების ძიება
openpgp-key-man-select-all-key =
    .key = A
openpgp-key-man-key-details-key =
    .key = I
openpgp-ign-addr-intro = თქვენ ეთანხმებით ამ გასაღების გამოყენებას ელფოსტის შერჩეული მისამართებისთვის:
openpgp-key-details-doc-title = გასაღების თვისებები
openpgp-key-details-signatures-tab =
    .label = სერტიფიკატები
openpgp-key-details-structure-tab =
    .label = აგებულება
openpgp-key-details-uid-certified-col =
    .label = მომხმარებლის ID / გამცემი
openpgp-key-details-key-id-label = გასაღების ID
openpgp-key-details-user-id3-label = გასაღების მფლობელის მოთხოვნა
openpgp-key-details-id-label =
    .label = ID
openpgp-key-details-key-type-label = სახეობა
openpgp-key-details-key-part-label =
    .label = გასაღების ნაწილი
openpgp-key-details-attr-ignored = ყურადღება: ამ გასაღებმა, შეიძლება არ იმუშაოს გამართულად, ვინაიდან მისი მახასიათებლების ნაწილი საფრთხის შემცველია და უგულებელყოფილი იქნება.
openpgp-key-details-attr-upgrade-sec = უნდა შეასწოროთ საფრთხის შემცველი მახასიათებლები.
openpgp-key-details-attr-upgrade-pub = უნდა სთხოვოთ ამ გასაღების მფლობელს, შეასწოროს საფრთხის შემცველი მახასიათებლები.
openpgp-key-details-upgrade-unsafe =
    .label = შეასწორეთ სახიფათო თვისებები
    .accesskey = ვ
openpgp-key-details-upgrade-ok = გასაღები წარმატებით განახლდა. უნდა გაუზიაროთ განახლებული საჯარო გასაღები დანარჩენებს.
openpgp-key-details-algorithm-label =
    .label = ალგორითმი
openpgp-key-details-size-label =
    .label = ზომა
openpgp-key-details-created-label =
    .label = შექმნილი
openpgp-key-details-created-header = შექმნილი
openpgp-key-details-expiry-label =
    .label = ვადა
openpgp-key-details-expiry-header = ვადა
openpgp-key-details-usage-label =
    .label = გამოყენება
openpgp-key-details-fingerprint-label = ანაბეჭდი
openpgp-key-details-legend-secret-missing = გასაღებებისთვის აღნიშვნით (!) არაა ხელმისაწვდომი საიდუმლო წყვილი.
openpgp-key-details-sel-action =
    .label = მოქმედების არჩევა…
    .accesskey = რ
openpgp-card-details-close-window-label =
    .buttonlabelaccept = დახურვა
openpgp-acceptance-label =
    .label = თქვენ მიერ დაშვება
openpgp-acceptance-rejected-label =
    .label = არა, ამ გასაღების უარყოფა.
openpgp-acceptance-undecided-label =
    .label = ჯერ არა, შეიძლება მოგვიანებით.
openpgp-acceptance-unverified-label =
    .label = დიახ, მაგრამ ჯერ დაუმოწმებელია, გასაღების მართებულობა.
openpgp-acceptance-verified-label =
    .label = დიახ, გადამოწმებულია პირადად, რომ ეს გასაღები, მართებული ანაბეჭდითაა.
key-accept-personal =
    ამ გასაღებისთვის, გაქვთ ორივე, საჯარო და საიდუმლო ნაწილი. შეგიძლიათ პირად გასაღებად გამოყენება.
    თუ ეს გასაღები ვინმე სხვისგან მიიღეთ, მაშინ არ გამოიყენოთ პირად გასაღებად.
openpgp-personal-no-label =
    .label = არა, არ მიეთითოს ჩემს პირად გასაღებად.
openpgp-personal-yes-label =
    .label = დიახ, მიეთითოს ჩემს პირად გასაღებად.
openpgp-copy-cmd-label =
    .label = ასლი

## e2e encryption settings

#   $identity (String) - the email address of the currently selected identity
openpgp-description-no-key = { -brand-short-name } არ ფლობს პირად OpenPGP-გასაღებს მისამართისთვის <b>{ $identity }</b>
#   $count (Number) - the number of configured keys associated with the current identity
#   $identity (String) - the email address of the currently selected identity
openpgp-description-has-keys =
    { $count ->
        [one] { -brand-short-name }-მა მონახა { $count } პირადი OpenPGP-გასაღები ანგარიშისთვის <b>{ $identity }</b>
       *[other] { -brand-short-name }-მა მონახა { $count } პირადი OpenPGP-გასაღები ანგარიშისთვის <b>{ $identity }</b>
    }
#   $key (String) - the currently selected OpenPGP key
openpgp-selection-status-have-key = მიმდინარე გამართვით, გამოიყენება გასაღების ID <b>{ $key }</b>
#   $key (String) - the currently selected OpenPGP key
openpgp-selection-status-error = მიმდინარე გამართვით, გამოიყენება გასაღების ID <b>{ $key }</b>, რომელიც ვადაგასულია.
openpgp-add-key-button =
    .label = გასაღების დამატება…
    .accesskey = დ
e2e-learn-more = ვრცლად
openpgp-keygen-success = OpenPGP-გასაღები შეიქმნა წარმატებით!
openpgp-keygen-import-success = OpenPGP-გასაღები გადმოტანილია წარმატებით!
openpgp-keygen-external-success = გარე GnuPG-გასაღების ID შენახულია!

## OpenPGP Key selection area

openpgp-radio-none =
    .label = არცერთი
openpgp-radio-none-desc = არ გამოიყენოს OpenPGP ამ მისამართისთვის.
openpgp-radio-key-not-usable = ეს გასაღები არ გამოდგება პირად გასაღებად, ვინაიდან საიდუმლო გასაღები აკლია!
openpgp-radio-key-not-accepted = ამ გასაღების გამოსაყენებლად პირად გასაღებად უნდა დაამოწმოთ!
openpgp-radio-key-not-found = ეს გასაღები ვერ მოიძებნა. თუ გსურთ მისი გამოყენება, შეიტანეთ { -brand-short-name }-ში.
#   $date (String) - the future expiration date of when the OpenPGP key will expire
openpgp-radio-key-expires = ვადა: { $date }
#   $date (String) - the past expiration date of when the OpenPGP key expired
openpgp-radio-key-expired = ვადაგასული: { $date }
openpgp-key-expires-within-6-months-icon =
    .title = გასაღების ვადა 6 თვეზე ნაკლებია
openpgp-key-has-expired-icon =
    .title = გასაღები ვადაგასულია
openpgp-key-expand-section =
    .tooltiptext = ვრცლად
openpgp-key-revoke-title = გასაღების გაუქმება
openpgp-key-edit-title = OpenPGP-გასაღების შეცვლა
openpgp-key-edit-date-title = ვადის გახანგრძლივება
openpgp-manager-description = გამოიყენეთ OpenPGP-გასაღების მმართველი  იმ ხალხის საჯარო გასაღებების სანახავად და სამართავად, ვისთანაც მიმოწერა გაქვთ, გარდა ამისა ყველა სხვა გასაღებისაც, რომელიც ზემოთა სიაში არაა.
openpgp-manager-button =
    .label = OpenPGP-გასაღების მმართველი
    .accesskey = ღ
openpgp-key-remove-external =
    .label = გარე გასაღების ID-ის მოცილება
    .accesskey = ც
key-external-label = გარე GnuPG-გასაღები

## Strings in keyDetailsDlg.xhtml

key-type-public = საჯარო გასაღები
key-type-primary = მთავარი გასაღები
key-type-subkey = ქვეგასაღები
key-type-pair = გასაღების წყვილი (საიდუმლო გასაღები და საჯარო გასაღები)
key-expiry-never = არასდროს
key-usage-encrypt = დაშიფვრა
key-usage-sign = ხელმოწერა
key-usage-certify = სერტიფიცირება
key-usage-authentication = დამოწმება
key-does-not-expire = გასაღები უვადოა
# Variables:
# $keyExpiry (String) - Date the key expired on.
key-expired-date = გასაღების ვადა იწურება { $keyExpiry }
key-expired-simple = გასაღები ვადაგასულია
key-revoked-simple = გასაღები გაუქმებულია
key-do-you-accept = გსურთ მიიღოთ ეს გასაღები ციფრული ხელმოწერებისა და დაშიფრული წერილების დასამოწმებლად?
# Variables:
# $addr (String) - Email address the key claims it belongs to.
key-verification = გადაამოწმეთ გასაღების ანაბეჭდი სხვა საურთიერთობო არხით ელფოსტის მიღმა, რომ დარწმუნდეთ მის ნამდვილობაში { $addr }.

## Strings enigmailMsgComposeOverlay.js

# Variables:
# $problem (String) - Error message from key usability check.
cannot-use-own-key-because = წერილი ვერ იგზავნება, ვინაიდან ხარვეზი აქვს თქვენს პირად გასაღებს. { $problem }
window-locked = შესადგენი ფანჯარა ჩაიკეტა; გაგზავნა გაუქმებულია

## Strings in keyserver.jsm

keyserver-error-aborted = შეწყვეტილი
keyserver-error-unknown = უცნობი შეცდომა წარმოიშვა
keyserver-error-server-error = გასაღებების სერვერი შეცდომას გადმოსცემს.
keyserver-error-import-error = ვერ მოხერხდა ჩამოტვირთული გასაღების შემოტანა.
keyserver-error-unavailable = გასაღებების სერვერი მიუწვდომელია.
keyserver-error-security-error = გასაღებების სერვერზე მხარდაუჭერელია დაშიფრული წვდომა.
keyserver-error-certificate-error = გასაღებების სერვერის სერტიფიკატი არამართებულია.
keyserver-error-unsupported = გასაღებების სერვერი მხარდაუჭერელია.

## Strings in mimeWkdHandler.jsm

wkd-message-body-req =
    თქვენი ელფოსტის მომწოდებელი ამუშავებს მოთხოვნას, საჯარო გასაღების OpenPGP ვებგასაღებების ცნობარში ასატვირთად.
    გთხოვთ, დაადასტუროთ, თქვენი საჯარო გასაღების გამოქვეყნება.
wkd-message-body-process =
    ეს ელფოსტა დაკავშირებულია ავტომატურად თქვენი საჯარო გასაღების OpenPGP ვებგასაღებების ცნობარში ატვირთვასთან.
    ხელით რამე მოქმედება აღარაა საჭირო.

## Strings in persistentCrypto.jsm

# Variables:
# $subject (String) - Subject of the message.
converter-decrypt-body-failed =
    ვერ იშიფრება წერილი თემით
    { $subject }.
    გსურთ, კვლავ შეიყვანოთ სხვა საიდუმლო ფრაზა, თუ გსურთ გამოტოვოთ ეს წერილი?

## Strings filters.jsm

filter-folder-required = აუცილებელია სასურველი საქაღალდის მითითება.
filter-decrypt-move-warn-experimental =
    გაფრთხილება – ფილტრის მოქმედება „სამუდამოდ გაშიფვრა“ შეიძლება იწვევდეს დაზიანებულ წერილს.
    დაჟინებით გირჩევთ, ჯერ სცადოთ ფილტრი „გაშიფრული ასლის შექმნა“, გამოცადოთ შედეგი დაკვირვებით და მხოლოდ იმ შემთხვევაში გადაწყვიტოთ ამ ფილტრის გამოყენება, თუ შედეგები დაგაკმაყოფილებთ.
filter-term-pgpencrypted-label = OpenPGP დაშიფრულია
filter-key-required = უნდა მიუთითოთ მიმღების გასაღები.
# Variables:
# $desc (String) - Email address to look for a key of.
filter-key-not-found = ვერე მოიძებნა დაშიფვრის გასაღები „{ $desc }“.
# Variables:
# $desc (String) - The ID of a secret key that is required to read the email after the user executes the current action.
filter-warn-key-not-secret =
    გაფრთხილება – ფილტრის მოქმედება „დაშიფვრა გასაღებზე“ ცვლის მიმღებებს.
    თუ არ გაქვთ საიდუმლო გასაღები „{ $desc }“ გასაღებისთვის, ვეღარ შეძლებთ წერილების წაკითხვას.

## Strings filtersWrapper.jsm

filter-decrypt-move-label = სამუდამოდ გაშიფვრა (OpenPGP)
filter-decrypt-copy-label = გაშიფრული ასლის შექმნა (OpenPGP)
filter-encrypt-label = დაშიფვრა გასაღებზე (OpenPGP)

## Strings in enigmailKeyImportInfo.js

import-info-title =
    .title = წარმატებით გადმოტანილია გასაღებები.
import-info-dialog-title = წარმატებით გადმოტანილია გასაღებები.
import-info-bits = ბიტი
import-info-created = შექმნილი
import-info-fpr = ანაბეჭდი
import-info-details = მონაცემების ნახვა და დაშვების მართვა
import-info-no-keys = არცერთი გასაღები არ გადმოტანილა.

## Strings in enigmailKeyManager.js

import-from-clip = გსურთ, გადმოიტანოთ რამდენიმე გასაღები აღებული ასლიდან?
import-from-url = საჯარო გასაღების ჩამოტვირთვა ამ ბმულიდან:
copy-to-clipbrd-failed = შერჩეული გასაღებ(ებ)ის ასლის აღება ვერ მოხერხდა.
copy-to-clipbrd-ok = გასაღებ(ებ)ის ასლი აღებულია
# Variables:
# $userId (String) - User id of the key.
delete-secret-key =
    ყურადღება: თქვენ აპირებთ წაშალოთ საიდუმლო გასაღები!
    
    თუ წაშლით საიდუმლო გასაღებს, ვეღარ შეძლებთ მისი მეშვეობით დაშიფრული წერილების გახსნას, ვეღარც მის გაუქმებას.
    
    ნამდვილად გსურთ წაიშალოს ორივე, საიდუმლო გასაღები და საჯარო გასაღები
    „{ $userId }“?
delete-mix =
    თუ წაშლით საიდუმლო გასაღებს, ვეღარ შეძლებთ მისი მეშვეობით დაშიფრული წერილების გახსნას, ვეღარც მის გაუქმებას.
    ნამდვილად გსურთ წაიშალოს ორივე, შერჩეული საიდუმლო და საჯარო გასაღებები?
# Variables:
# $userId (String) - User id of the key.
delete-pub-key =
    ნამდვილად გსურთ წაიშალოს საჯარო გასაღები
    „{ $userId }“?
delete-selected-pub-key = ნამდვილად გსურთ წაიშალოს საჯარო გასაღებები?
refresh-all-question = არ აგირჩევიათ გასაღები. გსურთ, გაახლდეს ყველა გასაღები?
key-man-button-export-sec-key = გატანა &საიდუმლო გასაღებების
key-man-button-export-pub-key = გატანა &საჯარო გასაღებების მხოლოდ
key-man-button-refresh-all = &განახლება ყველა გასაღების
key-man-loading-keys = გასაღებების ჩატვირთვა, გთხოვთ მოითმინოთ…
ascii-armor-file = ASCII-ით აღჭურვილი ფაილები (*.asc)
no-key-selected = უნდა შეარჩიოთ ერთი გასაღები მაინც, აღნიშნული მოქმედების შესასრულებლად
export-to-file = საჯარო გასაღების გატანა ფაილში
export-keypair-to-file = საჯარო და საიდუმლო გასაღების გატანა ფაილში
export-secret-key = გსურთ, დაერთოს საიდუმლო გასაღები შენახული OpenPGP-გასაღების ფაილში?
save-keys-ok = გასაღებები შეინახა წარმატებით.
save-keys-failed = გასაღებების შენახვა ვერ მოხერხდა
default-pub-key-filename = გამოტანილი-საჯარო-გასაღებები
default-pub-sec-key-filename = მარქაფი-საიდუმლო-გასაღებების
refresh-key-warn = ყურადღება: გასაღებების რაოდენობისა და კავშირის სიჩქარის შესაბამისად, ყველა გასაღების განახლება, შესაძლოა დროში გაიწელოს!
preview-failed = ვერ იკითხება საჯარო გასაღების ფაილი.
# Variables:
# $reason (String) - Error description.
general-error = შეცდომა: { $reason }
dlg-button-delete = &წაშლა

## Account settings export output

openpgp-export-public-success = <b>საჯარო გასაღები გატანილია წარმატებით!</b>
openpgp-export-public-fail = <b>ვერ ხერხდება შერჩეული საჯარო გასაღების გატანა!</b>
openpgp-export-secret-success = <b>საიდუმლო გასაღები გატანილია წარმატებით!</b>
openpgp-export-secret-fail = <b>ვერ ხერხდება შერჩეული საიდუმლო გასაღების გატანა!</b>

## Strings in keyObj.jsm
## Variables:
## $userId (String) - The name and/or email address that is mentioned in the key's information.
## $keyId (String) - Key id for the key entry.

key-ring-pub-key-revoked = გასაღები { $userId } (გასაღების ID { $keyId }) გაუქმებულია.
key-ring-pub-key-expired = გასაღები { $userId } (გასაღების ID { $keyId }) ვადაგასულია.
key-ring-no-secret-key = თქვენ არ გაქვთ საიდუმლო გასაღები { $userId }-ისთვის (გასაღების ID { $keyId }) თქვენს სიაში; ვერ გამოიყენებთ ამ გასაღებს ხელმოსაწერად.
key-ring-pub-key-not-for-signing = გასაღები { $userId } (გასაღების ID { $keyId }) არ გამოდგება ხელმოსაწერად.
key-ring-pub-key-not-for-encryption = გასაღები { $userId } (გასაღების ID { $keyId }) არ გამოდგება დასაშიფრად.
key-ring-sign-sub-keys-revoked = ყველა ხელმოსაწერი ქვეგასაღები გასაღებისა { $userId } (გასაღების ID { $keyId }) გაუქმებულია.
key-ring-sign-sub-keys-expired = ყველა ხელმოსაწერი ქვეგასაღები გასაღებისა { $userId } (გასაღების ID { $keyId }) ვადაგასულია.
key-ring-enc-sub-keys-revoked = ყველა დასაშიფრი ქვეგასაღები გასაღებისა { $userId } (გასაღების ID { $keyId }) გაუქმებულია.
key-ring-enc-sub-keys-expired = ყველა დასაშიფრი ქვეგასაღები გასაღებისა { $userId } (გასაღების ID { $keyId }) ვადაგასულია.

## Strings in gnupg-keylist.jsm

keyring-photo = ფოტო
user-att-photo = მომხმარებლის ნიშანი (JPEG-სურათი)

## Strings in key.jsm

already-revoked = ეს გასაღები, უკვე ვადაგასულია.
#   $identity (String) - the id and associated user identity of the key being revoked
revoke-key-question =
    თქვენ აპირებთ გააუქმოთ საიდუმლო გასაღები „{ $identity }“.
    
    ვეღარ შეძლებთ მისი მეშვეობით წერილების ხელმოწერას და როცა გავრცელდება, სხვები ვეღარ შეძლებენ მისი გამოყენებით დაშიფვრას. ძველი წერილების გაშიფვრა, კვლავ შეგეძლებათ.
    გსურთ, განაგრძოთ?
#   $keyId (String) - the id of the key being revoked
revoke-key-not-present =
    თქვენ არ გაქვთ გასაღები (0x{ $keyId }) რომელიც შეესაბამება გაუქმების სერტიფიკატს!
    თუ დაკარგეთ გასაღები, საჭიროა მისი გადმოტანა (მაგ. გასაღებების სერვერიდან) გაუქმების სერტიფიკატის გადმოტანამდე!
#   $keyId (String) - the id of the key being revoked
revoke-key-already-revoked = გასაღები 0x{ $keyId } უკვე ვადაგასულია.
key-man-button-revoke-key = გასაღების &გაუქმება
openpgp-key-revoke-success = გასაღები წარმატებით გაუქმდა.
after-revoke-info =
    გასაღები გაუქმებულია.
    გააზიარეთ ეს გასაღები კვლავ, ელფოსტის დაგზავნით, ან გასაღებების სერვერებზე ატვირთვით, რომ ეცნობოთ სხვებს, გასაღების გაუქმების შესახებ.
    როგორც კი სხვების პროგრამები შეიტყობს ამ გაუქმების შესახებ, შეწყდება ძველი გასაღების გამოყენება.
    თუ იყენებთ ახალ გასაღებს იმავე ელფოსტისთვის და აბამთ ახალ საჯარო გასაღებს ელფოსტის გაგზავნისას, მაშინ თქვენ მიერ გაუქმებული გასაღების შესახებ ცნობა ავტომატურად თან დაერთვება.

## Strings in keyRing.jsm & decryption.jsm

key-man-button-import = &გადმოტანა
delete-key-title = OpenPGP-გასაღების წაშლა
delete-external-key-title = გარე GnuPG-გასაღების მოცილება
delete-external-key-description = გსურთ, მოცილდეს გარე GnuPG-გასაღების ID?
key-in-use-title = ამჟამად გამოყენებული OpenPGP-გასაღები
delete-key-in-use-description = ვერ შესრულდება! შერჩეული გასაღები წასაშლელად ამჟამად გამოიყენება ამ ვინაობაზე. აირჩიეთ სხვა გასაღები, ან არცერთი, ან სცადეთ ხელახლა.
revoke-key-in-use-description = ვერ შესრულდება! შერჩეული გასაღები გასაუქმებლად, ამჟამად გამოიყენება ამ ვინაობაზე. აირჩიეთ სხვა გასაღები, ან არცერთი, ან სცადეთ ხელახლა.

## Strings used in errorHandling.jsm

# Variables:
# $keySpec (String) - Email address.
key-error-key-spec-not-found = ელფოსტის მისამართი „{ $keySpec }“ არ შეესაბამება გასაღებს, თქვენი კრებულიდან.
# $keySpec (String) - Key id.
key-error-key-id-not-found = გამართული გასაღების ID „{ $keySpec }“ ვერ მოიძებნა თქვენს კრებულში.
# $keySpec (String) - Key id.
key-error-not-accepted-as-personal = თქვენ არ დაგიდასტურებიათ, რომ გასაღები ID ნომრით „{ $keySpec }“, თქვენი პირადი გასაღებია.

## Strings used in enigmailKeyManager.js & windows.jsm

need-online = შერჩეული შესაძლებლობა არაა ხელმისაწვდომი კავშირგარეშედ. გთხოვთ, ხაზზე გახვიდეთ და სცადოთ ხელახლა.

## Strings used in keyRing.jsm & keyLookupHelper.jsm

no-key-found2 = ვერ მოიძებნა შესაბამისი გამოსადეგი გასაღები, ძიების მითითებული მოთხოვნით.
no-update-found = თქვენ უკვე გაქვთ გასაღებები, რომლებიც მოინახა ქსელიდან.

## Strings used in keyRing.jsm & GnuPGCryptoAPI.jsm

fail-key-extract = შეცდომა – გასაღების ამოღების ბრძანება ვერ შესრულდა

## Strings used in keyRing.jsm

fail-cancel = შეცდომა – გასაღების მიღება გააუქმა მომხმარებელმა
not-first-block = შეცდომა – პირველი OpenPGP-ჯგუფი არაა საჯარო გასაღებების ჯგუფი
import-key-confirm = გსურთ გადმოტანა წერილში ჩართული გასაღებ(ებ)ის?
fail-key-import = შეცდომა – გასაღების შეტანა ვერ მოხერხდა
# Variables:
# $output (String) - File that writing was attempted to.
file-write-failed = ვერ მოხერხდა ჩაწერა ფაილში { $output }
no-pgp-block = შეცდომა – ვერ მოიძებნა მართებულად აღჭურვილი OpenPGP-მონაცემების ჯგუფი
confirm-permissive-import = გადმოტანა ვერ მოხერხდა. გასაღები, რომლის შეტანასაც ცდილობთ, სავარაუდოდ დაზიანებულია ან იყენებს უცნობ მახასიათებლებს. გსურთ, სცადოთ მართებული ნაწილის შეტანა? შედეგად, შესაძლოა გადმოვიდეს არასრული ან გამოუსადეგარი გასაღებები.

## Strings used in trust.jsm

key-valid-unknown = უცნობი
key-valid-invalid = არასწორი
key-valid-disabled = გამორთული
key-valid-revoked = გაუქმებული
key-valid-expired = ვადაგასული
key-trust-untrusted = არასანდო
key-trust-marginal = შუალედური
key-trust-full = სანდო
key-trust-ultimate = უკიდურესი
key-trust-group = (ჯგუფი)

## Strings used in commonWorkflows.js

import-key-file = OpenPGP-გასაღების ფაილის შეტანა
import-rev-file = OpenPGP-გაუქმების ფაილის შეტანა
gnupg-file = GnuPG-ფაილები
import-keys-failed = გასაღებების შეტანა ვერ მოხერხდა
file-to-big-to-import = ფაილი ზედმეტად დიდია. გთხოვთ, არ შეიტანოთ გასაღებების დიდი კრებული ერთბაშად.

## Strings used in enigmailKeygen.js

save-revoke-cert-as = შექმნა და შენახვა გაუქმების სერტიფიკატის
revoke-cert-ok = გაუქმების სერთიფიკატი წარმატებით შეიქმნა. მისი გამოყენებით შეგიძლიათ გასაღებისთვის ძალმოსილების მოცილება. მაგ. იმ შემთხვევაში თუ დაკარგავთ საიდუმლო გასაღებს.
revoke-cert-failed = გაუქმების სერტიფიკატის შექმნა შეუძლებელია.
gen-going = გასაღების შედგენა უკვე მიმდინარეობს!
keygen-missing-user-name = სახელი არაა მითითებული ამ ანგარიშისთვის/ვინაობისთვის. გთხოვთ, შეიყვანოთ მნიშვნელობა ველში  „თქვენი სახელი“ ანგარიშის პარამეტრებიდან.
expiry-too-short = თქვენი გასაღების ვადა, ერთ დღეზე არანაკლები უნდა იყოს.
expiry-too-long = შეუძლებელია გასაღების შექმნა, 100 წელზე მეტი ვადით.
# Variables:
# $id (String) - Name and/or email address to generate keys for.
key-confirm = გსურთ შედგენა საჯარო და საიდუმლო გასაღების ანგარიშისთვის „{ $id }“?
key-man-button-generate-key = გასაღების &შედგენა
key-abort = შეწყდეს გასაღების შედგენა?
key-man-button-generate-key-abort = &შეწყდეს გასაღების შედგენა?
key-man-button-generate-key-continue = &გაგრძელდეს გასაღების შედგენა

## Strings used in enigmailMessengerOverlay.js

failed-decrypt = შეცდომა – გაშიფვრა ვერ მოხერხდა
fix-broken-exchange-msg-failed = ვერ მოხერხდა წერილის აღდგენა.
# Variables:
# $attachment (String) - File name of the signature file.
attachment-no-match-from-signature = არ შეესაბამება ხელმოწერის ფაილი „{ $attachment }“ დანართს
# Variables:
# $attachment (String) - File name of the attachment.
attachment-no-match-to-signature = არ შეესაბამება დანართი „{ $attachment }“ ხელმოწერის ფაილს
# Variables:
# $attachment (String) - File name of the attachment
signature-verified-ok = ხელმოწერა დანართისთვის { $attachment } დამოწმდა წარმატებით
# Variables:
# $attachment (String) - File name of the attachment
signature-verify-failed = ხელმოწერა დანართისთვის { $attachment } ვერ მოწმდება
decrypt-ok-no-sig =
    გაფრთხილება
    გაშიფრვა წარმატებით დასრულდა, მაგრამ ხელმოწერა ვერ დამოწმდა სწორად
msg-ovl-button-cont-anyway = &გაგრძელდეს მაინც
enig-content-note = *დანართები ამ წერილზე არც ხელმოწერილი და არც დაშიფრულია*

## Strings used in enigmailMsgComposeOverlay.js

msg-compose-button-send = წერილის &გაგზავნა
msg-compose-details-button-label = ვრცლად…
msg-compose-details-button-access-key = ვ
send-aborted = გაგზავნა შეწყდა.
# Variables:
# $key (String) - Key id.
key-not-trusted = გასაღები „{ $key }“ არასაკმარისი სანდოობისაა
# Variables:
# $key (String) - Key id.
key-not-found = გასაღები „{ $key }“ ვერ მოიძებნა
# Variables:
# $key (String) - Key id.
key-revoked = გასაღები „{ $key }“ გაუქმებულია
# Variables:
# $key (String) - Key id.
key-expired = გასაღები „{ $key }“ ვადაგასულია
msg-compose-internal-error = წარმოიშვა შიდა შეცდომა
keys-to-export = აირჩიეთ OpenPGP-გასაღებები ჩასმისთვის
msg-compose-partially-encrypted-inlinePGP =
    წერილი, რომლის პასუხსაც ცდილობთ, შეიცავს ორ, დაუშიფრავ და დაშიფრულ ნაწილს. თუ გამომგზავნს არ შეეძლო გაეშიფრა წერილის ზოგი ნაწილი, ამით შეიძლება გაამჟღავნოთ პირადი ინფორმაცია, რომ გამგზავნს თავად არ შეუძლია გაშიფვრა.
    გთხოვთ, მოაცილოთ ყველა დაციტირებული ტექსტი თქვენი პასუხიდან.
msg-compose-cannot-save-draft = შეცდომა წინასწარი შენახვისას
msg-compose-partially-encrypted-short = მოერიდეთ პირადი ინფორმაციის გამჟღავნებას – ნაწილობრივ დაშიფრული ელფოსტა.
quoted-printable-warn =
    თქვენ ჩართული გაქვთ „ციტირებულ-ამოსაბეჭდი“ დაშიფვრა გასაგზავნი წერილებისთვის. ამან შეიძლება გამოიწვიოს თქვენი გზავნილის არასწორად გაშიფვრა და/ან დამოწმება.
    გსურთ გამორთოთ „ციტირებულ-ამოსაბეჭდი“ წერილები ახლავე?
# Variables:
# $width (Number) - Number of characters per line.
minimal-line-wrapping =
    თქვენ გიყენიათ ხაზის გადატანა { $width } სიმბოლოზე. სწორი დაშიფვრის და/ან ხელმოწერისთვის, ეს მნიშვნელობა უნდა იყოს სულ მცირე 68.
    გსურთ, ხაზის გადატანის 68 სიმბოლო შეცვალოთ?
sending-news =
    დაშიფრული გაგზავნა შეწყვეტილია.
    ამ წერილის დაშიფვრა შეუძლებელია, რადგან მიმღებად მითითებულია ჯგუფი. გთხოვთ, ხელახლა გაგზავნოთ დაშიფვრის გარეშე.
send-to-news-warning =
    გაფრთხილება: თქვენ აპირებთ დაშიფრული ელფოსტის ჯგუფისთვის გაგზავნას.
    ეს უჩვეულოა, ვინაიდან მხოლოდ იმ შემთხვევაში ექნება აზრი, თუ ჯგუფის ყველა წევრს შეეძლება წერილის გაშიფვრა, ანუ გზავნილის დაშიფვრა საჭიროა ჯგუფის თითოეული მონაწილის გასაღებით. გთხოვთ, გაგზავნოთ ეს წერილი მხოლოდ იმ შემთხვევაში, თუ ზუსტად იცით, რასაც აკეთებთ.
    გსურთ, განაგრძოთ?
save-attachment-header = გაშიფრული დანართის შენახვა
possibly-pgp-mime = სავარაუდოდ PGP/MIME-დაშიფვრის ან ხელმოწერის მქონე გზავნილი; გამოიყენეთ „გაშიფვრა/დამოწმების“ შესაძლებლობა, გადასამოწმებლად
# Variables:
# $key (String) - Sender email address.
cannot-send-sig-because-no-own-key = შეუძლებელია ციფრულად ხელმოწერა ამ წერილის, ვინაიდან ჯერ არ გაქვთ გამართული გამჭოლი დაშიფვრა გასაღებისთვის <{ $key }>
# Variables:
# $key (String) - Sender email address.
cannot-send-enc-because-no-own-key = შეუძლებელია ამ წერილის დაშიფრულად გაგზავნა, ვინაიდან ჯერ არ გაქვთ გამართული გამჭოლი დაშიფვრა გასაღებისთვის <{ $key }>

## Strings used in decryption.jsm

# Variables:
# $key (String) - Newline separated list of a tab character then name and/or email address mentioned in the key followed by the key id in parenthesis.
do-import-multiple =
    გადმოვიდეს შემდეგი გასაღებები?
    { $key }
# Variables:
# $name (String) - Name and/or email address mentioned in the key.
# $id (String) - Key id of the key.
do-import-one = გადმოვიდეს { $name } ({ $id })?
cant-import = შეცდომა საჯარო გასაღების შემოტანისას
unverified-reply = წერილის ნაწილი (პასუხი) სავარაუდოდ შეცვლილია
key-in-message-body = გასაღები ნაპოვნია წერილის შიგთავსში. დაწკაპეთ „გასაღების შეტანა“ გასაღებების გადმოსატანად
sig-mismatch = შეცდომა – ხელმოწერის შეუსაბამობა
invalid-email = შეცდომა – არასწორი ელფოსტის მისამართ(ებ)ი
# Variables:
# $name (String) - File name of the attachment.
attachment-pgp-key =
    დანართი „{ $name }“ რომელსაც ხსნით, როგორც ჩანს, არის OpenPGP-გასაღების ფაილი.
    დააჭირეთ ღილაკს „გადმოტანა“, რომ შეიტანოთ შემცველი გასაღებები ან „ნახვას“, რომ იხილოთ ფაილის შიგთავსი ბრაუზერის ფანჯარაში
dlg-button-view = &ხედი

## Strings used in enigmailMsgHdrViewOverlay.js

decrypted-msg-with-format-error = გაშიფრული წერილი (აღდგენილი დაზიანებული PGP-სახის ელფოსტიდან, სავარაუდოდ ძველი გაცვლითი სერვერის გამო, შედეგად, შესაძლოა არ იყოს სრულყოფილი წასაკითხად)

## Strings used in encryption.jsm

not-required = შეცდომა – გაშიფვრა არაა მოთხოვნილა

## Strings used in windows.jsm

no-photo-available = ფოტო არაა ხელმისაწვდომი
# Variables:
# $photo (String) - Path of the photo in the key.
error-photo-path-not-readable = ფოტოს მდებარეობა „{ $photo }“ არ იკითხება
debug-log-title = OpenPGP გამართვის ჩანაწერები

## Strings used in dialog.jsm

# This string is followed by either repeat-suffix-singular if $count is 1 or else
# by repeat-suffix-plural.
# Variables:
# $count (Number) - Number of times the alert will repeat.
repeat-prefix = ეს ცნობა გამეორდება { $count }
repeat-suffix-singular = -ხელ კიდევ.
repeat-suffix-plural = -ჯერ კიდევ.
no-repeat = ეს ცნობა აღარ გამოჩნდება.
dlg-keep-setting = პასუხის დამახსოვრება, მომავალში შეკითხვის გარეშე
dlg-button-ok = &კარგი
dlg-button-close = &დახურვა
dlg-button-cancel = &გაუქმება
dlg-no-prompt = აღარ გამოჩნდეს ეს ფანჯარა
enig-prompt = OpenPGP მოთხოვნა
enig-confirm = OpenPGP დადასტურება
enig-alert = OpenPGP ცნობა
enig-info = OpenPGP მონაცემები

## Strings used in persistentCrypto.jsm

dlg-button-retry = &გამეორება
dlg-button-skip = &გამოტოვება

## Strings used in enigmailMsgBox.js

enig-alert-title =
    .title = OpenPGP ცნობა
