//@line 37 "/builds/tinderbox/thunderbird-trunk/Linux_2.4.18-14_Depend/mozilla/toolkit/mozapps/xpinstall/content/xpinstallConfirm.js"

var XPInstallConfirm = 
{ 
  _installCountdown: 2,
  _installCountdownInterval: -1,
  _param: null
};


XPInstallConfirm.init = function ()
{
  var bundle = document.getElementById("xpinstallConfirmStrings");
  
  this._param = window.arguments[0].QueryInterface(Components.interfaces.nsIDialogParamBlock);
  if (!this._param)
    close();
  
  this._param.SetInt(0, 1); // The default return value is "Cancel"
  
  var itemList = document.getElementById("itemList");
  
  var numItemsToInstall = this._param.GetInt(1);
  for (var i = 0; i < numItemsToInstall; ++i) {
    var installItem = document.createElement("installitem");
    itemList.appendChild(installItem);

    installItem.name = this._param.GetString(i);
    installItem.url = this._param.GetString(++i);
    var icon = this._param.GetString(++i);
    if (icon != "")
      installItem.icon = icon;
    var cert = this._param.GetString(++i);
    installItem.cert = cert || bundle.getString("Unsigned");
    installItem.signed = cert ? "true" : "false";
  }
  
  var introString = bundle.getString("itemWarningIntroSingle");
  if (numItemsToInstall > 4)
    introString = bundle.getFormattedString("itemWarningIntroMultiple", [numItemsToInstall / 4]);
  if (this._param.objects && this._param.objects.length)
    introString = this._param.objects.queryElementAt(0, Components.interfaces.nsISupportsString).data;
  var textNode = document.createTextNode(introString);
  var introNode = document.getElementById("itemWarningIntro");
  while (introNode.hasChildNodes())
    introNode.removeChild(introNode.firstChild);
  introNode.appendChild(textNode);
  
  var okButton = document.documentElement.getButton("accept");
  okButton.label = bundle.getFormattedString("installButtonDisabledLabel", [this._installCountdown]);
  okButton.disabled = true;
  okButton.focus();
  
  this._installCountdownInterval = setInterval("XPInstallConfirm.okButtonCountdown()", 1000);
}

XPInstallConfirm.okButtonCountdown = function ()
{
  var okButton = document.documentElement.getButton("accept");
  var bundle = document.getElementById("xpinstallConfirmStrings");
  if (this._installCountdown-- <= 1) {
    okButton.label = bundle.getString("installButtonLabel");
    okButton.disabled = false;
    clearInterval(this._installCountdownInterval);
  }
  else
    okButton.label = bundle.getFormattedString("installButtonDisabledLabel", [this._installCountdown]);
}
    
XPInstallConfirm.onOK = function ()
{
  this._param.SetInt(0, 0);
  return true;
}

XPInstallConfirm.onCancel = function ()
{
  this._param.SetInt(0, 1);
  return true;
}

