//@line 36 "/builds/tinderbox/thunderbird-trunk/Linux_2.4.18-14_Depend/mozilla/mail/components/preferences/general.js"

var gGeneralPane = {
  mPane: null,
  mMapiBundle: null,
  mBrandBundle: null,
  mSound: null,

  init: function ()
  {
    this.mPane = document.getElementById("paneGeneral");

    this.mBrandBundle = document.getElementById("brandBundle");
    this.mMapiBundle = document.getElementById("mapiBundle"); 

//@line 55 "/builds/tinderbox/thunderbird-trunk/Linux_2.4.18-14_Depend/mozilla/mail/components/preferences/general.js"

//@line 59 "/builds/tinderbox/thunderbird-trunk/Linux_2.4.18-14_Depend/mozilla/mail/components/preferences/general.js"

//@line 61 "/builds/tinderbox/thunderbird-trunk/Linux_2.4.18-14_Depend/mozilla/mail/components/preferences/general.js"
  // first check whether GNOME is available.  if it's not, hide the whole
  // default mail/news app section.
  var mapiReg;
  try {
    mapiReg = Components.classes["@mozilla.org/mapiregistry;1"].getService(Components.interfaces.nsIMapiRegistry);
  } catch (e) {}
  
  if (!mapiReg) 
    document.getElementById("defaultClientBox").hidden = true;
//@line 71 "/builds/tinderbox/thunderbird-trunk/Linux_2.4.18-14_Depend/mozilla/mail/components/preferences/general.js"
  },

//@line 120 "/builds/tinderbox/thunderbird-trunk/Linux_2.4.18-14_Depend/mozilla/mail/components/preferences/general.js"

//@line 122 "/builds/tinderbox/thunderbird-trunk/Linux_2.4.18-14_Depend/mozilla/mail/components/preferences/general.js"
  checkDefaultMailNow: function (isNews) 
  {
    var mapiReg = Components.classes["@mozilla.org/mapiregistry;1"]
                   .getService(Components.interfaces.nsIMapiRegistry);

    var brandShortName = this.mBrandBundle.getString("brandRealShortName");
    var promptTitle = this.mMapiBundle.getFormattedString("dialogTitle",
                                                    [brandShortName]);
    var promptMessage;
    var IPS = Components.interfaces.nsIPromptService;
    var prompt = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(IPS);

    var isDefault;
    var str;
    if (isNews) 
    {
      isDefault = mapiReg.isDefaultNewsClient;
      str = "News";
    } 
    else 
    {
      isDefault = mapiReg.isDefaultMailClient;
      str = "Mail";
    }

    if (!isDefault) 
    {
      promptMessage = this.mMapiBundle.getFormattedString("setDefault" + str,
                                                    [brandShortName]);

      var rv = prompt.confirmEx(window, promptTitle, promptMessage,
                                (IPS.BUTTON_TITLE_YES * IPS.BUTTON_POS_0) +
                                (IPS.BUTTON_TITLE_NO * IPS.BUTTON_POS_1),
                                null, null, null, null, { });
      if (rv == 0) 
      {
        if (isNews)
          mapiReg.isDefaultNewsClient = true;
        else
          mapiReg.isDefaultMailClient = true;
      }
    }
    else 
    {
      promptMessage = this.mMapiBundle.getFormattedString("alreadyDefault" + str,
                                                    [brandShortName]);

      prompt.alert(window, promptTitle, promptMessage);
    }
  },
//@line 173 "/builds/tinderbox/thunderbird-trunk/Linux_2.4.18-14_Depend/mozilla/mail/components/preferences/general.js"

  startPageCheck: function() 
  {
    document.getElementById("mailnewsStartPageUrl").disabled = !document.getElementById("mailnewsStartPageEnabled").checked;
  },
  
  setHomePageToDefaultPage: function ()
  {
    var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                                .getService(Components.interfaces.nsIPrefService);
    var pref = prefService.getDefaultBranch(null);
    var url = pref.getComplexValue("mailnews.start_page.url",
                                   Components.interfaces.nsIPrefLocalizedString).data;
    var startPageUrlField = document.getElementById("mailnewsStartPageUrl");
    startPageUrlField.value = url;
    
    this.mPane.userChangedValue(startPageUrlField);
  },

  showConnections: function ()
  {
    document.documentElement.openSubDialog("chrome://messenger/content/preferences/connection.xul",
                                           "", null);
  },

  showAdvancedSound: function()
  {
    document.documentElement
      .openSubDialog("chrome://messenger/content/preferences/notifications.xul",
                                           "", null);
  }
};
