//@line 41 "/builds/tinderbox/Tb-Mozilla1.8/Linux_2.4.18-14_Depend/mozilla/mail/base/content/contentAreaClick.js"

/*
 * - [ Dependencies ] ---------------------------------------------------------
 *  utilityOverlay.js:
 *    - gatherTextUnder
 */

  var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);
  
  /** 
   * extract the href from the link click event. 
   * We look for HTMLAnchorElement, HTMLAreaElement, HTMLLinkElement,
   * HTMLInputElement.form.action, and nested anchor tags.
   * 
   * @return href for the url being clicked
   */
  function hRefForClickEvent(event)
  {
    var target = event.target;
    var href;
    var isKeyPress = (event.type == "keypress");

    if (target instanceof HTMLAnchorElement ||
        target instanceof HTMLAreaElement   ||
        target instanceof HTMLLinkElement)
    {
      if (target.hasAttribute("href")) 
        href = target.href;
    }
    else if (target instanceof HTMLInputElement)
    {
      if (target.form && target.form.action)
        href = target.form.action;      
    }
    else 
    {
      // we may be nested inside of a link node
      linkNode = event.originalTarget;
      while (linkNode && !(linkNode instanceof HTMLAnchorElement))
        linkNode = linkNode.parentNode;
      
      if (linkNode)
        href = linkNode.href;
    }

    return href;
  }

  // Called whenever the user clicks in the content area,
  // except when left-clicking on links (special case)
  // should always return true for click to go through
  function contentAreaClick(event) 
  {
    var href = hRefForClickEvent(event);
    if (href) 
    {
      handleLinkClick(event, href, null);
      if (!event.button)  // left click only
        return gPhishingDetector.warnOnSuspiciousLinkClick(href); // let the phishing detector check the link
    }
    
    return true;
  }

  function openNewTabOrWindow(event, href, sendReferrer)
  {
    // always return false for stand alone mail (MOZ_THUNDERBIRD)
    // let someone else deal with it
    return false;
  }

  function getContentFrameURI(aFocusedWindow)
  {
    var contentFrame = isContentFrame(aFocusedWindow) ? aFocusedWindow : window.content;
    return contentFrame.location.href;
  }

  function handleLinkClick(event, href, linkNode)
  {
    // Make sure we are allowed to open this URL
    var focusedWindow = document.commandDispatcher.focusedWindow;
    var sourceURL = getContentFrameURI(focusedWindow);
    urlSecurityCheck(href, sourceURL);
    return false;
  }

  function middleMousePaste( event )
  {
    return false;
  }

  function makeURLAbsolute( base, url ) 
  {
    // Construct nsIURL.
    var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                  .getService(Components.interfaces.nsIIOService);
    var baseURI  = ioService.newURI(base, null, null);

    return ioService.newURI(baseURI.resolve(url), null, null).spec;
  }
