;; Test all the f32 comparison operators on major boundary values and all
;; special values.

(module
  (func $eq (param $x f32) (param $y f32) (result i32) (f32.eq (get_local $x) (get_local $y)))
  (func $ne (param $x f32) (param $y f32) (result i32) (f32.ne (get_local $x) (get_local $y)))
  (func $lt (param $x f32) (param $y f32) (result i32) (f32.lt (get_local $x) (get_local $y)))
  (func $le (param $x f32) (param $y f32) (result i32) (f32.le (get_local $x) (get_local $y)))
  (func $gt (param $x f32) (param $y f32) (result i32) (f32.gt (get_local $x) (get_local $y)))
  (func $ge (param $x f32) (param $y f32) (result i32) (f32.ge (get_local $x) (get_local $y)))

  (export "eq" $eq)
  (export "ne" $ne)
  (export "lt" $lt)
  (export "le" $le)
  (export "gt" $gt)
  (export "ge" $ge)
)

(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -infinity) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const infinity) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const -nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "eq" (f32.const nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x0p+0) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x0p+0) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-149) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-149) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-126) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-126) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p-1) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p-1) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1p+0) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1p+0) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -infinity) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const infinity) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const -nan) (f32.const nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const -nan)) (i32.const 1))
(assert_return (invoke "ne" (f32.const nan) (f32.const nan)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const infinity) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const infinity) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "lt" (f32.const infinity) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const infinity) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "lt" (f32.const infinity) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const infinity) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "lt" (f32.const infinity) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const infinity) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "lt" (f32.const infinity) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const infinity) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "lt" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "lt" (f32.const infinity) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const infinity) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "lt" (f32.const infinity) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const infinity) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -infinity) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const infinity) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const infinity) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const -nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "lt" (f32.const nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -infinity) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -infinity) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const infinity) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const infinity) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -infinity) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const -infinity) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "le" (f32.const infinity) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const infinity) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -infinity) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const -infinity) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "le" (f32.const infinity) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const infinity) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -infinity) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const -infinity) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "le" (f32.const infinity) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const infinity) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -infinity) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const -infinity) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "le" (f32.const infinity) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const infinity) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "le" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "le" (f32.const infinity) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const infinity) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -infinity) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const -infinity) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const infinity) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const infinity) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "le" (f32.const -infinity) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -infinity) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const infinity) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const infinity) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const -nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "le" (f32.const nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const infinity) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const infinity) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const infinity) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const infinity) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const infinity) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const infinity) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const infinity) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const infinity) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const infinity) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const infinity) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const infinity) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const infinity) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const infinity) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "gt" (f32.const infinity) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -infinity) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const infinity) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const infinity) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const -nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "gt" (f32.const nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x0p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-149) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-126) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p-1) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1p+0) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.921fb6p+2) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const 0x1.fffffep+127) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const infinity) (f32.const -0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const infinity) (f32.const 0x0p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const infinity) (f32.const -0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const infinity) (f32.const 0x1p-149)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const infinity) (f32.const -0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const infinity) (f32.const 0x1p-126)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const infinity) (f32.const -0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const infinity) (f32.const 0x1p-1)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const infinity) (f32.const -0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const infinity) (f32.const 0x1p+0)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const infinity) (f32.const -0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const infinity) (f32.const 0x1.921fb6p+2)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const infinity) (f32.const -0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const infinity) (f32.const 0x1.fffffep+127)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const infinity) (f32.const -infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const infinity) (f32.const infinity)) (i32.const 1))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -infinity) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const infinity) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const infinity) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x0p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1p-149)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1p-126)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1p-1)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1p+0)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1.921fb6p+2)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const 0x1.fffffep+127)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const infinity)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const -nan) (f32.const nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const -nan)) (i32.const 0))
(assert_return (invoke "ge" (f32.const nan) (f32.const nan)) (i32.const 0))
