/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const { ConsoleMessage } =
  require("devtools/client/webconsole/types");

const stubPreparedMessages = new Map();
const stubPackets = new Map();
stubPreparedMessages.set(`console.log('foobar', 'test')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924471,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "foobar",
    "test"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foobar\",\"test\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log(undefined)`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924479,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "undefined"
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"undefined\"}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.warn('danger, will robinson!')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924487,
  "type": "warn",
  "helperType": null,
  "level": "warn",
  "messageText": null,
  "parameters": [
    "danger, will robinson!"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"warn\",\"messageText\":null,\"parameters\":[\"danger, will robinson!\"],\"source\":\"console-api\",\"type\":\"warn\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log(NaN)`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924495,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "NaN"
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"NaN\"}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log(null)`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924501,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "null"
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"null\"}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log('鼬')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924506,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "鼬"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"鼬\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.clear()`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924512,
  "type": "clear",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "Console was cleared."
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"Console was cleared.\"],\"source\":\"console-api\",\"type\":\"clear\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.count('bar')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924515,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": "bar: 1",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"bar: 1\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.assert(false, {message: 'foobar'})`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924521,
  "type": "assert",
  "helperType": null,
  "level": "error",
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj30",
      "class": "Object",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 1,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "message": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "foobar"
          }
        },
        "ownSymbols": [],
        "ownPropertiesLength": 1,
        "ownSymbolsLength": 0,
        "safeGetterValues": {}
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"error\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj30\",\"class\":\"Object\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":1,\"preview\":{\"kind\":\"Object\",\"ownProperties\":{\"message\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"foobar\"}},\"ownSymbols\":[],\"ownPropertiesLength\":1,\"ownSymbolsLength\":0,\"safeGetterValues\":{}}}],\"source\":\"console-api\",\"type\":\"assert\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": [
    {
      "columnNumber": 27,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "triggerPacket",
      "lineNumber": 1
    }
  ],
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log('hello \nfrom \rthe \"string world!')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924528,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "hello \nfrom \rthe \"string world!"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"hello \\nfrom \\rthe \\\"string world!\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log('úṇĩçödê țĕșť')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924586,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "úṇĩçödê țĕșť"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"úṇĩçödê țĕșť\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.dirxml(window)`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924596,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj31",
      "class": "Window",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 830,
      "preview": {
        "kind": "ObjectWithURL",
        "url": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html"
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj31\",\"class\":\"Window\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":830,\"preview\":{\"kind\":\"ObjectWithURL\",\"url\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\"}}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log('myarray', ['red', 'green', 'blue'])`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924604,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "myarray",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj32",
      "class": "Array",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 4,
      "preview": {
        "kind": "ArrayLike",
        "length": 3,
        "items": [
          "red",
          "green",
          "blue"
        ]
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"myarray\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj32\",\"class\":\"Array\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":4,\"preview\":{\"kind\":\"ArrayLike\",\"length\":3,\"items\":[\"red\",\"green\",\"blue\"]}}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log('myregex', /a.b.c/)`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924610,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "myregex",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj33",
      "class": "RegExp",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 1,
      "displayString": "/a.b.c/"
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"myregex\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj33\",\"class\":\"RegExp\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":1,\"displayString\":\"/a.b.c/\"}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.table(['red', 'green', 'blue']);`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924612,
  "type": "table",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj34",
      "class": "Array",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 4,
      "preview": {
        "kind": "ArrayLike",
        "length": 3,
        "items": [
          "red",
          "green",
          "blue"
        ]
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj34\",\"class\":\"Array\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":4,\"preview\":{\"kind\":\"ArrayLike\",\"length\":3,\"items\":[\"red\",\"green\",\"blue\"]}}],\"source\":\"console-api\",\"type\":\"table\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log('myobject', {red: 'redValue', green: 'greenValue', blue: 'blueValue'});`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924614,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "myobject",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj35",
      "class": "Object",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 3,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "red": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "redValue"
          },
          "green": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "greenValue"
          },
          "blue": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "blueValue"
          }
        },
        "ownSymbols": [],
        "ownPropertiesLength": 3,
        "ownSymbolsLength": 0,
        "safeGetterValues": {}
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"myobject\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj35\",\"class\":\"Object\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":3,\"preview\":{\"kind\":\"Object\",\"ownProperties\":{\"red\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"redValue\"},\"green\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"greenValue\"},\"blue\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"blueValue\"}},\"ownSymbols\":[],\"ownPropertiesLength\":3,\"ownSymbolsLength\":0,\"safeGetterValues\":{}}}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.debug('debug message');`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924621,
  "type": "debug",
  "helperType": null,
  "level": "debug",
  "messageText": null,
  "parameters": [
    "debug message"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"debug\",\"messageText\":null,\"parameters\":[\"debug message\"],\"source\":\"console-api\",\"type\":\"debug\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.info('info message');`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924625,
  "type": "info",
  "helperType": null,
  "level": "info",
  "messageText": null,
  "parameters": [
    "info message"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"info\",\"messageText\":null,\"parameters\":[\"info message\"],\"source\":\"console-api\",\"type\":\"info\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.error('error message');`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924628,
  "type": "error",
  "helperType": null,
  "level": "error",
  "messageText": null,
  "parameters": [
    "error message"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"error\",\"messageText\":null,\"parameters\":[\"error message\"],\"source\":\"console-api\",\"type\":\"error\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": [
    {
      "columnNumber": 27,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "triggerPacket",
      "lineNumber": 1
    }
  ],
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log('mymap')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924631,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "mymap",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj36",
      "class": "Map",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 0,
      "preview": {
        "kind": "MapLike",
        "size": 2,
        "entries": [
          [
            "key1",
            "value1"
          ],
          [
            "key2",
            "value2"
          ]
        ]
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":5,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"mymap\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj36\",\"class\":\"Map\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":0,\"preview\":{\"kind\":\"MapLike\",\"size\":2,\"entries\":[[\"key1\",\"value1\"],[\"key2\",\"value2\"]]}}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 5,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log('myset')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924746,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "myset",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj37",
      "class": "Set",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 0,
      "preview": {
        "kind": "ArrayLike",
        "length": 2,
        "items": [
          "a",
          "b"
        ]
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"myset\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj37\",\"class\":\"Set\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":0,\"preview\":{\"kind\":\"ArrayLike\",\"length\":2,\"items\":[\"a\",\"b\"]}}],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.trace()`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924752,
  "type": "trace",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":3,\"column\":3},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[],\"source\":\"console-api\",\"type\":\"trace\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": [
    {
      "columnNumber": 3,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "testStacktraceFiltering",
      "lineNumber": 3
    },
    {
      "columnNumber": 3,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "foo",
      "lineNumber": 6
    },
    {
      "columnNumber": 1,
      "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
      "functionName": "triggerPacket",
      "lineNumber": 9
    }
  ],
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 3,
    "column": 3
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.time('bar')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924757,
  "type": "nullMessage",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"nullMessage\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`timerAlreadyExists`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924758,
  "type": "time",
  "helperType": null,
  "level": "warn",
  "messageText": "Timer “bar” already exists.",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":3,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"warn\",\"messageText\":\"Timer “bar” already exists.\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"time\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 3,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.timeLog('bar') - 1`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920999996,
  "type": "timeLog",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "bar: 1ms"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":4,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar: 1ms\"],\"source\":\"console-api\",\"type\":\"timeLog\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 4,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.timeLog('bar') - 2`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920999996,
  "type": "timeLog",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "bar: 1ms",
    "second call",
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj34",
      "class": "Object",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 1,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "state": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": 1
          }
        },
        "ownSymbols": [],
        "ownPropertiesLength": 1,
        "ownSymbolsLength": 0,
        "safeGetterValues": {}
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":5,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar: 1ms\",\"second call\",{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj34\",\"class\":\"Object\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":1,\"preview\":{\"kind\":\"Object\",\"ownProperties\":{\"state\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":1}},\"ownSymbols\":[],\"ownPropertiesLength\":1,\"ownSymbolsLength\":0,\"safeGetterValues\":{}}}],\"source\":\"console-api\",\"type\":\"timeLog\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 5,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.timeEnd('bar')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924759,
  "type": "timeEnd",
  "helperType": null,
  "level": "log",
  "messageText": "bar: 1.21ms",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":6,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"bar: 1.21ms\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"timeEnd\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 6,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`timeEnd.timerDoesntExist`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920999998,
  "type": "timeEnd",
  "helperType": null,
  "level": "warn",
  "messageText": "Timer “bar” doesn’t exist.",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":7,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"warn\",\"messageText\":\"Timer “bar” doesn’t exist.\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"timeEnd\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 7,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`timeLog.timerDoesntExist`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920999999,
  "type": "timeLog",
  "helperType": null,
  "level": "warn",
  "messageText": "Timer “bar” doesn’t exist.",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":8,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"warn\",\"messageText\":\"Timer “bar” doesn’t exist.\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"timeLog\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 8,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.table('bar')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924801,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "bar"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.table(['a', 'b', 'c'])`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924859,
  "type": "table",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj39",
      "class": "Array",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 4,
      "preview": {
        "kind": "ArrayLike",
        "length": 3,
        "items": [
          "a",
          "b",
          "c"
        ]
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj39\",\"class\":\"Array\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":4,\"preview\":{\"kind\":\"ArrayLike\",\"length\":3,\"items\":[\"a\",\"b\",\"c\"]}}],\"source\":\"console-api\",\"type\":\"table\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.group('bar')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924863,
  "type": "startGroup",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "bar"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar\"],\"source\":\"console-api\",\"type\":\"startGroup\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.groupEnd('bar')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924864,
  "type": "endGroup",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":3,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"endGroup\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 3,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.groupCollapsed('foo')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924870,
  "type": "startGroupCollapsed",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "foo"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\"],\"source\":\"console-api\",\"type\":\"startGroupCollapsed\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.groupEnd('foo')`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924871,
  "type": "endGroup",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":3,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"endGroup\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 3,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.group()`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924878,
  "type": "startGroup",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "<no group label>"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"<no group label>\"],\"source\":\"console-api\",\"type\":\"startGroup\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.groupEnd()`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924879,
  "type": "endGroup",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":3,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"endGroup\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 3,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log(%cfoobar)`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924883,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "foo",
    "bar"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\",\"bar\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[\"color:blue; font-size:1.3em; background:url('http://example.com/test'); position:absolute; top:10px; \",\"color:red; line-height: 1.5; background:url('http://example.com/test')\"],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [
    "color:blue; font-size:1.3em; background:url('http://example.com/test'); position:absolute; top:10px; ",
    "color:red; line-height: 1.5; background:url('http://example.com/test')"
  ],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.log("%cHello%c|%cWorld")`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1518681614352,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "Hello",
    "|",
    "World"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":3},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"Hello\",\"|\",\"World\"],\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[\"color:red\",\"\",\"color: blue\"],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 3
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [
    "color:red",
    "",
    "color: blue"
  ],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.group(%cfoo%cbar)`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924887,
  "type": "startGroup",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "foo",
    "bar"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\",\"bar\"],\"source\":\"console-api\",\"type\":\"startGroup\",\"userProvidedStyles\":[\"color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px\",\"color:red;background:url('http://example.com/test')\"],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [
    "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
    "color:red;background:url('http://example.com/test')"
  ],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.groupEnd(%cfoo%cbar)`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924887,
  "type": "endGroup",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":6,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"endGroup\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 6,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.groupCollapsed(%cfoo%cbaz)`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924892,
  "type": "startGroupCollapsed",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "foo",
    "baz"
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\",\"baz\"],\"source\":\"console-api\",\"type\":\"startGroupCollapsed\",\"userProvidedStyles\":[\"color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px\",\"color:red;background:url('http://example.com/test')\"],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [
    "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
    "color:red;background:url('http://example.com/test')"
  ],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.groupEnd(%cfoo%cbaz)`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924893,
  "type": "endGroup",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":6,\"column\":1},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"source\":\"console-api\",\"type\":\"endGroup\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 6,
    "column": 1
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.dir({C, M, Y, K})`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1502884924899,
  "type": "dir",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    {
      "type": "object",
      "actor": "server1.conn0.child1/obj36",
      "class": "Object",
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "ownPropertyLength": 4,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "cyan": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "C"
          },
          "magenta": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "M"
          },
          "yellow": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "Y"
          },
          "black": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "K"
          }
        },
        "ownSymbols": [],
        "ownPropertiesLength": 4,
        "ownSymbolsLength": 0,
        "safeGetterValues": {}
      }
    }
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":1,\"column\":27},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn0.child1/obj36\",\"class\":\"Object\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":4,\"preview\":{\"kind\":\"Object\",\"ownProperties\":{\"cyan\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"C\"},\"magenta\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"M\"},\"yellow\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"Y\"},\"black\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"K\"}},\"ownSymbols\":[],\"ownPropertiesLength\":4,\"ownSymbolsLength\":0,\"safeGetterValues\":{}}}],\"source\":\"console-api\",\"type\":\"dir\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 1,
    "column": 27
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.count | default: 1`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913333,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": "default: 1",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":2,\"column\":5},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"default: 1\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 2,
    "column": 5
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.count | default: 2`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913334,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": "default: 2",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":3,\"column\":5},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"default: 2\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 3,
    "column": 5
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.count | test counter: 1`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913334,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": "test counter: 1",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":4,\"column\":5},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"test counter: 1\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 4,
    "column": 5
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.count | test counter: 2`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913334,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": "test counter: 2",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":5,\"column\":5},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"test counter: 2\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 5,
    "column": 5
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.count | default: 3`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913334,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": "default: 3",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":6,\"column\":5},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"default: 3\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 6,
    "column": 5
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.count | clear`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913334,
  "type": "clear",
  "helperType": null,
  "level": "log",
  "messageText": null,
  "parameters": [
    "Console was cleared."
  ],
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":7,\"column\":5},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":null,\"parameters\":[\"Console was cleared.\"],\"source\":\"console-api\",\"type\":\"clear\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 7,
    "column": 5
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.count | default: 4`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913335,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": "default: 4",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":8,\"column\":5},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"default: 4\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 8,
    "column": 5
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.count | test counter: 3`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1511365913335,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": "test counter: 3",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":9,\"column\":5},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"test counter: 3\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 9,
    "column": 5
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.countReset | test counter: 0`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920412190,
  "type": "log",
  "helperType": null,
  "level": "log",
  "messageText": "test counter: 0",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":10,\"column\":5},\"groupId\":null,\"indent\":0,\"level\":\"log\",\"messageText\":\"test counter: 0\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 10,
    "column": 5
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPreparedMessages.set(`console.countReset | counterDoesntExist`, new ConsoleMessage({
  "id": "1",
  "allowRepeating": true,
  "source": "console-api",
  "timeStamp": 1526920412191,
  "type": "log",
  "helperType": null,
  "level": "warn",
  "messageText": "Counter “test counter” doesn’t exist.",
  "parameters": null,
  "repeatId": "{\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html\",\"line\":11,\"column\":5},\"groupId\":null,\"indent\":0,\"level\":\"warn\",\"messageText\":\"Counter “test counter” doesn’t exist.\",\"parameters\":null,\"source\":\"console-api\",\"type\":\"log\",\"userProvidedStyles\":[],\"private\":false}",
  "stacktrace": null,
  "frame": {
    "source": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "line": 11,
    "column": 5
  },
  "groupId": null,
  "exceptionDocURL": null,
  "userProvidedStyles": [],
  "notes": null,
  "indent": 0,
  "prefix": "",
  "private": false
}));

stubPackets.set(`console.log('foobar', 'test')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "foobar",
      "test"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924471,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.log(undefined)`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "undefined"
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924479,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.warn('danger, will robinson!')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "danger, will robinson!"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "warn",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924487,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.log(NaN)`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "NaN"
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924495,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.log(null)`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "null"
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924501,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.log('鼬')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "鼬"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924506,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.clear()`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "clear",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924512,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.count('bar')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 27,
    "counter": {
      "count": 1,
      "label": "bar"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924515,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.assert(false, {message: 'foobar'})`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj30",
        "class": "Object",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 1,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "message": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "foobar"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 1,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "assert",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924521,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 27,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 1
      }
    ],
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.log('hello \nfrom \rthe \"string world!')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "hello \nfrom \rthe \"string world!"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924528,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.log('úṇĩçödê țĕșť')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "úṇĩçödê țĕșť"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924586,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.dirxml(window)`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj31",
        "class": "Window",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 830,
        "preview": {
          "kind": "ObjectWithURL",
          "url": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html"
        }
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "dirxml",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924596,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.log('myarray', ['red', 'green', 'blue'])`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "myarray",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj32",
        "class": "Array",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 4,
        "preview": {
          "kind": "ArrayLike",
          "length": 3,
          "items": [
            "red",
            "green",
            "blue"
          ]
        }
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924604,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.log('myregex', /a.b.c/)`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "myregex",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj33",
        "class": "RegExp",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 1,
        "displayString": "/a.b.c/"
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924610,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.table(['red', 'green', 'blue']);`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj34",
        "class": "Array",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 4,
        "preview": {
          "kind": "ArrayLike",
          "length": 3,
          "items": [
            "red",
            "green",
            "blue"
          ]
        }
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924612,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.log('myobject', {red: 'redValue', green: 'greenValue', blue: 'blueValue'});`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "myobject",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj35",
        "class": "Object",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 3,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "red": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "redValue"
            },
            "green": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "greenValue"
            },
            "blue": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "blueValue"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 3,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924614,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.debug('debug message');`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "debug message"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "debug",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924621,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.info('info message');`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "info message"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "info",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924625,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.error('error message');`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "error message"
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "error",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924628,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 27,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 1
      }
    ],
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.log('mymap')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "mymap",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj36",
        "class": "Map",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 0,
        "preview": {
          "kind": "MapLike",
          "size": 2,
          "entries": [
            [
              "key1",
              "value1"
            ],
            [
              "key2",
              "value2"
            ]
          ]
        }
      }
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924631,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.log('myset')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "myset",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj37",
        "class": "Set",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 0,
        "preview": {
          "kind": "ArrayLike",
          "length": 2,
          "items": [
            "a",
            "b"
          ]
        }
      }
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924746,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.trace()`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 3,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "testStacktraceFiltering",
    "groupName": "",
    "level": "trace",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924752,
    "timer": null,
    "stacktrace": [
      {
        "columnNumber": 3,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "testStacktraceFiltering",
        "lineNumber": 3
      },
      {
        "columnNumber": 3,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "foo",
        "lineNumber": 6
      },
      {
        "columnNumber": 1,
        "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
        "functionName": "triggerPacket",
        "lineNumber": 9
      }
    ],
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.time('bar')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "time",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924757,
    "timer": {
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`timerAlreadyExists`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "time",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924758,
    "timer": {
      "error": "timerAlreadyExists",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.timeLog('bar') - 1`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 4,
    "prefix": "",
    "private": false,
    "timeStamp": 1526920999996,
    "timer": {
      "duration": 1,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.timeLog('bar') - 2`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar",
      "second call",
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj34",
        "class": "Object",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 1,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "state": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": 1
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 1,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "timeStamp": 1526920999996,
    "timer": {
      "duration": 1,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.timeEnd('bar')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924759,
    "timer": {
      "duration": 1.2149999999999181,
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`timeEnd.timerDoesntExist`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeEnd",
    "lineNumber": 7,
    "prefix": "",
    "private": false,
    "timeStamp": 1526920999998,
    "timer": {
      "error": "timerDoesntExist",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`timeLog.timerDoesntExist`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "timeLog",
    "lineNumber": 8,
    "prefix": "",
    "private": false,
    "timeStamp": 1526920999999,
    "timer": {
      "error": "timerDoesntExist",
      "name": "bar"
    },
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.table('bar')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924801,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.table(['a', 'b', 'c'])`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj39",
        "class": "Array",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 4,
        "preview": {
          "kind": "ArrayLike",
          "length": 3,
          "items": [
            "a",
            "b",
            "c"
          ]
        }
      }
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "table",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924859,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.group('bar')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "bar",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924863,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.groupEnd('bar')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "bar",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924864,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.groupCollapsed('foo')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "foo"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924870,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.groupEnd('foo')`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924871,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.group()`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "styles": [],
    "timeStamp": 1502884924878,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.groupEnd()`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "groupEnd",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924879,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.log(%cfoobar)`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "styles": [
      "color:blue; font-size:1.3em; background:url('http://example.com/test'); position:absolute; top:10px; ",
      "color:red; line-height: 1.5; background:url('http://example.com/test')"
    ],
    "timeStamp": 1502884924883,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.log("%cHello%c|%cWorld")`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "Hello",
      "|",
      "World"
    ],
    "columnNumber": 3,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "log",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "styles": [
      "color:red",
      "",
      "color: blue"
    ],
    "timeStamp": 1518681614352,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.group(%cfoo%cbar)`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "bar"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo bar",
    "level": "group",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "styles": [
      "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
      "color:red;background:url('http://example.com/test')"
    ],
    "timeStamp": 1502884924887,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.groupEnd(%cfoo%cbar)`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo bar",
    "level": "groupEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924887,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.groupCollapsed(%cfoo%cbaz)`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "foo",
      "baz"
    ],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo baz",
    "level": "groupCollapsed",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "styles": [
      "color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
      "color:red;background:url('http://example.com/test')"
    ],
    "timeStamp": 1502884924892,
    "timer": null,
    "workerType": "none",
    "category": "webdev"
  }
});

stubPackets.set(`console.groupEnd(%cfoo%cbaz)`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 1,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "foo baz",
    "level": "groupEnd",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924893,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.dir({C, M, Y, K})`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      {
        "type": "object",
        "actor": "server1.conn0.child1/obj36",
        "class": "Object",
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "ownPropertyLength": 4,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "cyan": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "C"
            },
            "magenta": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "M"
            },
            "yellow": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "Y"
            },
            "black": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": "K"
            }
          },
          "ownSymbols": [],
          "ownPropertiesLength": 4,
          "ownSymbolsLength": 0,
          "safeGetterValues": {}
        }
      }
    ],
    "columnNumber": 27,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "dir",
    "lineNumber": 1,
    "prefix": "",
    "private": false,
    "timeStamp": 1502884924899,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.count | default: 1`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "columnNumber": 5,
    "counter": {
      "count": 1,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 2,
    "prefix": "",
    "private": false,
    "timeStamp": 1511365913333,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.count | default: 2`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "columnNumber": 5,
    "counter": {
      "count": 2,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 3,
    "prefix": "",
    "private": false,
    "timeStamp": 1511365913334,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.count | test counter: 1`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "columnNumber": 5,
    "counter": {
      "count": 1,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 4,
    "prefix": "",
    "private": false,
    "timeStamp": 1511365913334,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.count | test counter: 2`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "columnNumber": 5,
    "counter": {
      "count": 2,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 5,
    "prefix": "",
    "private": false,
    "timeStamp": 1511365913334,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.count | default: 3`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "columnNumber": 5,
    "counter": {
      "count": 3,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 6,
    "prefix": "",
    "private": false,
    "timeStamp": 1511365913334,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.count | clear`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [],
    "columnNumber": 5,
    "counter": null,
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "clear",
    "lineNumber": 7,
    "prefix": "",
    "private": false,
    "timeStamp": 1511365913334,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.count | default: 4`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "default"
    ],
    "columnNumber": 5,
    "counter": {
      "count": 4,
      "label": "default"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 8,
    "prefix": "",
    "private": false,
    "timeStamp": 1511365913335,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.count | test counter: 3`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "columnNumber": 5,
    "counter": {
      "count": 3,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "count",
    "lineNumber": 9,
    "prefix": "",
    "private": false,
    "timeStamp": 1511365913335,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.countReset | test counter: 0`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "columnNumber": 5,
    "counter": {
      "count": 0,
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "countReset",
    "lineNumber": 10,
    "prefix": "",
    "private": false,
    "timeStamp": 1526920412190,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

stubPackets.set(`console.countReset | counterDoesntExist`, {
  "from": "server1.conn0.child1/consoleActor2",
  "type": "consoleAPICall",
  "message": {
    "addonId": "",
    "arguments": [
      "test counter"
    ],
    "columnNumber": 5,
    "counter": {
      "error": "counterDoesntExist",
      "label": "test counter"
    },
    "filename": "http://example.com/browser/devtools/client/webconsole/test/fixtures/stub-generators/test-console-api.html",
    "functionName": "triggerPacket",
    "groupName": "",
    "level": "countReset",
    "lineNumber": 11,
    "prefix": "",
    "private": false,
    "timeStamp": 1526920412191,
    "timer": null,
    "workerType": "none",
    "styles": [],
    "category": "webdev"
  }
});

module.exports = {
  stubPreparedMessages,
  stubPackets,
};
