<pre class='metadata'>
Title: CSS Masonry Layout Module
Shortname: css-grid-3
Status: LS
Work Status: Testing
Level: none
URL: https://drafts.csswg.org/css-grid-3/
Editor: Tab Atkins Jr., Google, http://www.xanthir.com/contact/, w3cid 42199
Editor: Elika J. Etemad / fantasai, Invited Expert, http://fantasai.inkedblade.net/contact, w3cid 35400
Editor: Mats Palmgren, Mozilla, mailto:mats@mozilla.com
Editor: Jen Simmons, Apple, http://jensimmons.com/
Abstract: This module introduces masonry layout as an additional layout mode for <a href="https://www.w3.org/TR/css-grid-2/">CSS Grid</a> containers.
WPT Path Prefix: css/css-grid/masonry/tentative/
Markup Shorthands: css yes
</pre>


<h2 id='intro'>
Introduction</h2>

<em>This section is not normative.</em>

Grid Layout is a layout model for CSS that has powerful abilities to control the sizing and positioning of boxes and their contents. Grid Layout is optimized for 2-dimensional layouts: those in which alignment of content is desired in both dimensions.

<figure>
	<img src="images/grid-layout.png"
	     alt="An example of grid layout:
	     two rows of items,
	     the first being four items &mdash; the last of which spans both rows,
	     and the second being two items &mdash; the first of which spans the first two columns &mdash; plus the spanned item from the first row.">
	<figcaption>Representative Grid layout example</figcaption>
</figure>

Although many layouts can be expressed with regular Grid Layout, restricting items into a grid in both axes also makes it impossible to express some common layouts on the Web.

This module defines a layout system that removes that restriction so that items can be placed into Grid-like tracks in just one of the axes, while stacking them one after another in the other axis.  Items are placed into the column (or row) with the most remaining space based on the layout size of the items placed so far.  This module also extends <a href="https://www.w3.org/TR/css-grid-2/">CSS Grid</a> with this new grid item placement strategy and <a href="https://drafts.csswg.org/css-align">CSS Box Alignment</a> with new alignment features.

<h3 id='background'>
Background and Motivation</h3>

Masonry layout is a common Web design pattern where a number of items — commonly images or short article summaries — are placed one by one into columns, in a way that loosely resembles stone masonry. Unlike <a href="https://drafts.csswg.org/css-multicol-1/">regular multi-column layout</a>, where items are placed vertically in the first column until they must spill over to the second column, masonry layout selects a column for each new item such that it is generally closer to the top of the layout than items placed later.

The Pinterest search results page exemplifies this layout:

<figure>
	<img src="images/pinterest.png"
	     alt="An example of masonry layout:
	     four columns of items,
	     each item is placed into the column with the smallest height so far.">
	<figcaption>Representative masonry layout example</figcaption>
</figure>


Here, each item has a different height (depending on the content and the width of the column), and inspecting the DOM reveals (as the visual content itself gives no indication of ordering) that each item has been placed into the column with the smallest height so far.

This layout superficially looks similar to multi-column layout; but it has the advantage that scrolling down will naturally lead to "later" items in the layout (that is, those less relevant in the search results).

It's not possible to achieve this layout using earlier CSS layout models, unless you know up-front how tall each item will be, or use JavaScript for content measurement or placement.

<h3 id="values">
Value Definitions</h3>

	This specification follows the <a href="https://www.w3.org/TR/CSS2/about.html#property-defs">CSS property definition conventions</a> from [[!CSS2]]
	using the <a href="https://www.w3.org/TR/css-values-3/#value-defs">value definition syntax</a> from [[!CSS-VALUES-3]].
	Value types not defined in this specification are defined in CSS Values &amp; Units [[!CSS-VALUES-3]].
	Combination with other CSS modules may expand the definitions of these value types.

	In addition to the property-specific values listed in their definitions,
	all properties defined in this specification
	also accept the <a>CSS-wide keywords</a> as their property value.
	For readability they have not been repeated explicitly.

<h2 id='masonry-layout'>
Masonry Layout</h2>


Masonry layout is supported for [=grid containers=] by specifying the value ''grid-template-columns/masonry'' for one of its axes.  This axis is called the <dfn>masonry axis</dfn>, and the other axis is called the <dfn>grid axis</dfn>.

<pre class='propdef partial'>
	Name: grid-template-columns, grid-template-rows
	New values: masonry
	Initial: none
	Applies to: [=grid containers=]
	Inherited: no
	Percentages: refer to corresponding dimension of the content area
	Computed value: the keyword ''grid-template-columns/none'' or the keyword ''grid-template-columns/masonry'' or a <a href="https://drafts.csswg.org/css-grid-2/#computed-track-list">computed track list</a>
	Animation type: see <a href="https://drafts.csswg.org/css-grid-2/#propdef-grid-template-columns">CSS Grid</a>
</pre>

This allows us to use the full power of <a href="https://www.w3.org/TR/css-grid-2/">CSS Grid</a> in the [=grid axis=].  Line names and track sizes can be specified and <a>grid items</a> can be placed into the tracks and span them using 'grid-column' / 'grid-row' as usual.  The <a href="https://drafts.csswg.org/css-align">CSS Box Alignment</a> properties work the same as in a regular [=grid container=] in this axis.  In the [=masonry axis=] however, items are laid out one after another using the [[#masonry-layout-algorithm]].

<div class="example">
Here's a masonry layout <a href="examples/pinterest-with-span.html">example</a> demonstrating placed and spanning items:

<figure>
	<img src="images/example-pinterest-with-span.png">
	<figcaption>Rendering of the example above.</figcaption>
</figure>
</div>

Subgrid <a>grid items</a> are supported, but subgridding only occurs in the [=grid container's=] [=grid axis=]; see [[#subgrids]] for details.

If ''grid-template-columns/masonry'' is specified for both ''grid-template-columns'' and ''grid-template-rows'', then the used value for ''grid-template-columns'' is ''grid-template-columns/none'', and thus the inline axis will be the [=grid axis=].

<a>Grid items</a> are formed and [=blockified=] exactly the same as in a regular [=grid container=].

All CSS properties work the same as in a regular [=grid container=] unless otherwise specified by this specification.  For example, ''order'' can be used to specify a different layout order for the items.

<h3 id="line-name-resolution">
Line Name Resolution</h3>

<a>Grid item</a> line name resolution works the same as if ''grid-template-columns/masonry'' were replaced with ''grid-template-columns/none'', i.e. line names are resolved <em>in both axes</em>.  The <a href="https://drafts.csswg.org/css-grid-2/#line-placement">line name resolution</a> works exactly is in <a href="https://www.w3.org/TR/css-grid-2/">CSS Grid</a>.

<h3 id="grid-item-placement">
Grid Item Placement</h3>

<a>Grid items</a> are placed using these steps:
<ol>
  <li>Place the items as if the [=masonry axis=] had ''grid-template-columns/none'' specified in that axis.
  <li>For any items that were placed at the first (hypothetical) implicit line in the [=masonry axis=] in step 1, those items keep their placement in both axes as their final placement. They will be laid out first in each [=grid axis=] track and their [=grid axis=] placement is considered definite henceforth. All other items ignore their placement from step 1.  Any item with with a specified definite placement in the [=masonry axis=] that doesn't result in it being placed at the first implicit line in the [=masonry axis=] will be treated as having 'auto'-placement in that axis.
  <li>Place items using the <a href="#masonry-layout-algorithm">Masonry layout algorithm</a> below.
</ol>

(The reason for step 1 above is to determine which items contribute to intrinsic track sizing in the [=grid axis=]; see [[#track-sizing]] below.)

<h3 id="track-sizing">
Grid Axis Track Sizing</h3>

Track sizing works the same as in <a href="https://drafts.csswg.org/css-grid-2/#algo-track-sizing">CSS Grid</a>, except that that the algorithm is run only with the subset of items that have a known [=grid axis=] placement.  This subset contains the items placed at the first implicit line in the [=masonry axis=] in <a href="#grid-item-placement">Grid Item Placement</a> above, plus the items that have a specified definite placement in the [=grid axis=], plus the items that span all [=grid axis=] tracks (which obviously will be placed at the first implicit line since there is no other way to place them).  Other items will be placed in the [=grid axis=] by the [[#masonry-layout-algorithm]] below and don't contribute to intrinsic track sizing (because that would create circular dependencies).

<h4 id="repeat-auto-fit">
repeat(auto-fit)</h3>

''grid-template-rows/repeat(auto-fit)'' behaves as ''grid-template-rows/repeat(auto-fill)'' when the other axis is a [=masonry axis=].  The reason for this is that ''grid-row/auto''-placed items depend on the layout size of their siblings.  Removing empty tracks after layout wouldn't be possible in most cases since it might affect any intrinsic track sizes.  Even if all track sizes are definite, the containing block size could change for grid-aligned absolutely-positioned descendants.  This makes ''grid-template-rows/repeat(auto-fit)'' impossible to support in a grid container with masonry layout.

<h3 id="masonry-layout-algorithm">
Masonry Layout Algorithm</h3>

Items are placed in <a href="https://drafts.csswg.org/css-flexbox-1/#order-modified-document-order">order-modifed document order</a>, but items with a definite placement are placed before items with an indefinite position (as in regular grid layout). For each of the tracks in the [=grid axis=], keep a <dfn>running position</dfn> initialized to zero. For each item placed at the first implicit line in the [=masonry axis=] in <a href="#grid-item-placement">Grid Item Placement</a> step 1 above:
<ol>
	<li>Position the item at the content edge of the grid container in the [=masonry axis=] and at its start track in the [=grid axis=].</li>
	<li>Calculate the size of the <a href="#containing-block">containing block</a> and then layout the item.  Then, calculate its resulting margin-box in the [=masonry axis=]. Set the [=running position=] of the [=grid axis=] tracks the item spans to the maximum of <code>margin-box-end + grid-gap</code> and the current [=running position=] of those tracks.</li>
</ol>

Note: This means that items with a definite placement at line 1 in the [=masonry axis=] by <a href="#grid-item-placement">Grid Item Placement</a> step 1 can be made to intentionally overlap.

The remaining items get their final placement using the following steps:
<ol>
	<li>If the item has an indefinite placement in the [=grid axis=], then resolve its definite placement in the [=grid axis=] using these substeps:
		<ol>
			<li>Starting at the first [=grid axis=] line in the implicit grid...</li>
			<li>Find the largest [=running position=] of the [=grid axis=] tracks that the item would span if it were placed at this line, and call this position <code>max_pos</code>.</li>
			<li>Increment the line number and repeat step 2 until the item would no longer fit inside the grid.</li>
			<li>Pick the line that resulted in the smallest <code>max_pos</code> as the item's definite placement in the [=grid axis=].</li>
		</ol>
	Otherwise, a definite placement in the [=grid axis=] is honored the same as in a regular grid.
	</li>
	<li>Position the item at its [=grid axis=] start track and the maximum of the [=running position=]s of the tracks it spans.
	<li>Calculate the size of the item's <a href="#containing-block">containing block</a> and then layout the item. Then calculate its resulting margin-box in the [=masonry axis=]. Set the [=running position=] of the [=grid axis=] tracks the item spans to <code>max_pos + margin-box-end + grid-gap</code>.
</ol>

<h3 id="masonry-auto-flow">
The ''masonry-auto-flow'' Property</h3>

The [[#masonry-layout-algorithm]] above can be modified in two ways, using the new 'masonry-auto-flow' property:

<pre class='propdef'>
	Name: masonry-auto-flow
	Value: [ pack | next ] || [definite-first | ordered ]
	Initial: pack
	Applies to: [=grid containers=] with masonry layout
	Inherited: no
	Percentages: n/a
	Computed value: specified keyword(s)
	Animation type: discrete
</pre>


First, picking definite items first for placement can be inhibited by specifying the ''masonry-auto-flow/ordered'' keyword so that a plain <a href="https://drafts.csswg.org/css-flexbox-1/#order-modified-document-order">order-modifed document order</a> is used instead.  Second, instead of placing the items in the track(s) with the most remaining space as described above we can place them one after another in the [=grid axis=] by specifying the ''masonry-auto-flow/next'' keyword, for <a href="examples/masonry-auto-flow-next.html">example</a>:

<div class="example">
```css
<style>
.grid {
  display: inline-grid;
  grid: masonry / repeat(3, 2ch);
  border: 1px solid;
  masonry-auto-flow: next;
}

item { background: silver }
item:nth-child(2n+1) {
  background: pink;
  height: 4em;
}
</style>
```
```html
<div class="grid">
  <item>1</item>
  <item>2</item>
  <item>3</item>
  <item>4</item>
</div>
```

<figure>
	<img src="images/grid-auto-flow-example-1.png">
	<figcaption>Rendering of the ''masonry-auto-flow: next'' example above.</figcaption>
</figure>

(Without ''masonry-auto-flow: next'', item 4 would be placed below item 2.)

</div>

<h2 id="containing-block">
Containing Block</h2>

The <a>containing block</a> for a <a>grid item</a> is formed by its <a>grid area</a> in the [=grid axis=] and the grid container's content-box in the [=masonry axis=].

<h2 id="#implicit-grid">
The Implicit Grid
</h2>
The [=implicit grid=] is formed in the same way as for a regular grid container.  However, it's only used in the [=grid axis=].  The flow axis specified by ''grid-auto-flow'' is ignored &mdash; items are always placed by filling the [=grid axis=] (though note that the ''grid-auto-flow'' property's ''grid-auto-flow/dense'' keyword does have an effect in determining which items end up at line 1 in the [=masonry axis=], in [[#grid-item-placement]] step 1).  ''direction:rtl'' reverses the grid if the inline-axis is the [=grid axis=] (as usual for a regular grid container) and it makes items flow from right to left if the inline-axis is the [=masonry axis=].


<div class="example">
Here's a simple <a href="examples/rtl-grid-axis.html">example</a> using ''direction: rtl'' in the [=grid axis=]:
```css
<style>
.grid {
  display: inline-grid;
  direction: rtl;
  grid: masonry / repeat(4, 2ch);
  border: 1px solid;
}

item { background: silver }
item:nth-child(2n+1) {
  background: pink;
  height: 4em;
}
</style>
```
```html
<div class="grid">
  <item>1</item>
  <item style="grid-column:span 2">2</item>
  <item>3</item>
  <item>4</item>
</div>
```

<figure>
	<img src="images/rtl-grid-axis.png">
	<figcaption>Rendering of the ''direction: rtl'' example above.</figcaption>
</figure>
</div>

<div class="example">
Here's a simple <a href="examples/rtl-masonry-axis.html">example</a> using ''direction: rtl'' in the [=masonry axis=]:
```css
<style>
.grid {
  display: inline-grid;
  direction: rtl;
  width: 10ch;
  column-gap: 1ch;
  grid: repeat(4, 2em) / masonry;
  border: 1px solid;
}

item { background: silver }
item:nth-child(2n+1) {
  background: pink;
  width: 4ch;
}
</style>
```
```html
<div class="grid">
  <item>1</item>
  <item style="grid-row:span 2">2</item>
  <item>3</item>
  <item>4</item>
</div>
```

<figure>
	<img src="images/rtl-masonry-axis.png">
	<figcaption>Rendering of the ''direction: rtl'' example above.</figcaption>
</figure>
</div>

<h2 id="intrinsic-sizes">
Sizing Grid Containers</h2>

<a href="https://drafts.csswg.org/css-grid-2/#intrinsic-sizes">Sizing Grid Containers</a> works the same as for regular [=grid containers=] but with the following addendum for the [=masonry axis=]: The <a>max-content size</a> (<a>min-content size</a>) of a grid container in the [=masonry axis=] is the largest distance between the [=grid container's=] content-box start edge and the maximum margin-box end of all the items, when sized under a <a>max-content constraint</a> (<a>min-content constraint</a>).

<div class="example">
Here's a simple <a href="examples/grid-intrinsic-sizing-example-1.html">example</a>:

```css
<style>
.grid {
  display: inline-grid;
  grid: masonry / 50px 100px auto;
  grid-gap: 10px;
  border: 1px solid;
}
item { background: silver; margin: 5px; }
</style>
```

```html
<div class="grid">
  <item style="border:10px solid">1</item>
  <item>2</item>
  <item>3</item>
  <item style="height:50px">4</item>
  <item>5</item>
  <item>6</item>
</div>
```

<figure>
	<img src="images/grid-intrinsic-sizing-example-1.png">
	<figcaption>Rendering of the grid container intrinsic sizing example above.</figcaption>
</figure>

</div>


<h2 id="alignment">
Alignment and Spacing</h2>

<a href="https://www.w3.org/TR/css-grid-2/#gutters">Gutters</a> are supported in both axes. In the [=masonry axis=], the gap is applied between the margin boxes of each pair of adjacent items.  Margins do not collapse in either axis.

In the [=grid axis=], <a href="https://drafts.csswg.org/css-grid-2/#alignment">alignment</a> works the same as in a regular [=grid container=].

In the [=masonry axis=], <a href="https://drafts.csswg.org/css-align/#content-distribution">content-distribution</a> is applied to the content as a whole, similarly to how it behaves in block containers.  More specifically, the <a>alignment subject</a> is the <dfn>masonry box</dfn>, which is the area between the content-box edge of the [=grid container=] and the margin-box end edge of the item that is the furthest away in the [=masonry axis=], as indicated by the dashed border here:

<figure>
	<img src="images/masonry-box.png">
	<figcaption>
		The extent of the [=masonry box=] is indicated by the dashed border.
		(Note that item 1 has a 5px bottom margin here.)
	</figcaption>
</figure>


Note that there is only ever one <a>alignment subject</a> for these properties in the [=masonry axis=], so the unique 'align-content' / 'justify-content' values boil down to ''align-content/start'', ''align-content/center'', ''align-content/end'', ''align-content/stretch'' and [=baseline alignment=]. (''align-content/normal'' behaves as ''align-content/stretch'' as usual for [=grid containers=]).  In the figure above, the [=grid container=] has ''align-content: start''; but if ''align-content'' were at its default ''normal'' value, then the [=masonry box=] would fill the [=grid container=]'s content box, due to being stretched.  Moreover: if the grid items overflowed the [=grid container=]'s content box in the masonry axis, then the masonry box would be larger than the [=grid container=]'s content box.

<h3 id="tracks-alignment">
The ''align-tracks'' and ''justify-tracks'' Properties
</h3>

This specification adds two new properties to align the items in the [=masonry axis=] for each individual [=grid axis=] track:

<pre class='propdef'>>
	Name: align-tracks
	Value: [normal | <<baseline-position>> | <<content-distribution>> | <<overflow-position>>? <<content-position>>]#
	Initial: normal
	Applies to: [=grid containers=] with masonry layout in their block axis
	Inherited: no
	Percentages: n/a
	Computed value: specified keyword(s)
	Animation type: discrete
</pre>

<pre class='propdef'>
	Name: justify-tracks
	Value: [normal | <<content-distribution>> | <<overflow-position>>? [ <<content-position>> | left | right ] ]#
	Initial: normal
	Applies to: [=grid containers=] with masonry layout in their inline axis
	Inherited: no
	Percentages: n/a
	Computed value: specified keyword(s)
	Animation type: discrete
</pre>

Note: These values are the same as for 'align-content' / 'justify-content', but here we accept multiple values in a comma-separated list.

Unlike 'align-content' / 'justify-content', ''align-tracks/normal'' behaves as ''align-tracks/start'' for these properties.  So the default rendering is the expected packed masonry layout as shown in the top left corner in the example below.  When multiple values are specified, the first track in the [=grid axis=] uses the first value, the second track uses the second value, etc.  If there are fewer values than tracks, then the last value is used for the remaining tracks.  If there are more values than tracks, then the remaining values have no effect on the rendering.

<div class="example">
     Here's a <a href="examples/align-tracks-example-1.html">testcase</a> that demonstrates a few 'align-tracks' alignment possibilities.

<figure>
	<img src="images/align-tracks-example-1.png">
	<figcaption>
		The rendering of the ''align-tracks'' example above.
	</figcaption>
</figure>
</div>

<h3 id="masonry-axis-stretch-alignment">
Stretch Alignment in the Masonry Axis</h3>

''align-tracks/stretch'' will stretch the items in the [=masonry axis=] for each track separately, to fill the grid container's content-box.  Any item can opt out from stretching by setting ''align-self'' / ''justify-self'' to something other than ''align-self/normal'' or ''align-self/stretch'' in the relevant axis.  A stretched item with an [=indefinite size=] in the [=masonry axis=] will stretch its content-box size, but only up to its [=max size=]. An item with a [=definite size=] and an ''margin/auto'' margin in the [=masonry axis=] will stretch by increasing ''margin/auto'' margin(s).  Otherwise, the item doesn't stretch.

<div class="example">
Here's a <a href="examples/align-tracks-example-2.html">testcase</a> that demonstrates stretching items in the [=masonry axis=].
<figure>
	<video src="images/align-tracks-example-2.webm" controls></video>
	<figcaption>
		Visualization of the ''align-tracks: stretch'' example above.
	</figcaption>
</figure>

Only the purple items have ''height/auto'' height, so they are the ones that may grow by default.  A few items worth noting: item 4 has ''max-height: 40px'' so it only grows up to that size and then the other items in its track picks up the remaining size. Item 16 opts out from resizing by setting ''align-self: end''. Item 18 has ''margin-block: auto'' so it's centered in its allotted space instead of growing. Item 20 has ''margin-top: auto'' so it's aligned to the end while its top-margin grows.
</div>

<div class="example">
Here's the corresponding <a href="examples/justify-tracks-example-1.html">testcase</a> with a masonry inline-axis instead.
<figure>
	<video src="images/justify-tracks-example-1.webm" controls></video>
	<figcaption>
		Visualization of the ''justify-tracks: stretch'' example above.
	</figcaption>
</figure>
</div>

<h3 id="masonry-axis-alignment">
Individual Track Alignment in the Masonry Axis</h3>

''align-tracks'' / ''justify-tracks'' values can be specified per track.

<div class="example">
Here's an <a href="examples/masonry-axis-alignment-1.html">example</a> to illustrate this. Note that this example's 'align-tracks' value intentionally has one value less than the number of tracks to illustrate that the remaining track(s) use the last value (i.e. the right-most track also uses ''align-tracks/space-evenly''). (''align-tracks/baseline'' values are also supported but excluded in this test, see [[#masonry-axis-baseline-alignment]] for a description how that works with examples.)
<figure>
	<img src="images/masonry-axis-alignment-1.png">
	<figcaption>
		Rendering of the ''align-tracks'' alignment example above.
	</figcaption>
</figure>
</div>

<h3 id="masonry-axis-baseline-alignment">
Baseline Alignment in the Masonry Axis</h3>

Item [=baseline alignment=] inside the [=grid axis=] tracks works as usual for a regular [=grid container=], and the grid container's baseline is determined the same as for a regular grid container in that axis.

[=Baseline alignment=] is supported also in the [=masonry axis=], on the first and last item in each track (but not on items "in the middle" of the track). Only tracks with the 'align-tracks' / 'justify-tracks' values ''align-tracks/start'', ''align-tracks/end'' or ''align-tracks/stretch'' support baseline alignment. There are four different sets of [=baseline-sharing groups=]:

<ol>
    <li>the first item in each ''align-tracks/start'' track + the first item in each ''align-tracks/stretch'' track
    <li>the last item in each ''align-tracks/start'' track
    <li>the first item in each ''align-tracks/end'' track
    <li>the last item in each ''align-tracks/end'' track + the last item in each ''align-tracks/stretch'' track
</ol>

Each of those sets can have a [=first baseline set=] and a [=last baseline set=], resulting in eight unique baseline sets in the [=masonry axis=].

ISSUE: specify how the grid container's first(last) baseline in the [=masonry axis=] is determined

<div class="example">
Here's an <a href="examples/masonry-axis-baseline-alignment-1.html">example</a> illustrating all eight possibilities.
(The example uses two separate [=grid containers=] to illustrate the first ("F") and last ("L") baseline sets to avoid cluttering the illustration, but it is possible to use all eight sets in the same container.)  The aligned baselines are indicated with red color.  Note that the tracks that are attached to the end side of the [=masonry box=] adjust the padding (or margin in the case of 'align-self') on the end side, whereas tracks attached to the start side adjust the start padding/margin. (only 'align-content' is used in this example, which adjusts the padding, since it's easier to see the baseline adjustment.  'align-self' can also be used, or a mix of the two, as usual.)
<figure>
	<img src="images/masonry-axis-baseline-alignment-1.png">
	<figcaption>
		The rendering of the example above.
	</figcaption>
</figure>
</div>


ISSUE: this needs more details about edge cases, caveat about misalignment in stretch, etc

Advisement: Authors are advised to be careful with using alignment values other than ''align-tracks/start'' when some items span more than one track, because it's easy to cause items to unintentionally overlap in this case.

ISSUE: maybe we can make stretch alignment (at least) smarter so that we avoid overlapping spanning items in a few more cases that would be useful to authors?

<h2 id="pagination">
Fragmentation</h2>

<h3 id="masonry-axis-pagination">
Fragmentation in the Masonry Axis</h3>

Each [=grid axis=] track is fragmented independently in the [=masonry axis=].  If a [=grid item=] is fragmented, or has a [=forced break=] before/after it, then the [=running position=] for the tracks that it spans in the [=grid axis=] are set to the size of the [=fragmentainer=] so that no further items will be placed in those tracks.  An item that is split into multiple fragments retains its placement in the [=grid axis=] for all its fragments.  A grid item that is pushed, however, is placed again by the next grid container fragment.  Placement continues until all items are placed or pushed to a new fragment.

<div class="example">
Here's an <a href="examples/fragmentation-block-axis-example.html">example</a> illustrating fragmentation of a grid with masonry layout in its block-axis. It renders like this:
<figure style="max-width:100%">
	<video style="max-width:100%" src="images/fragmentation-block-axis-example.webm" controls></video>
	<figcaption>
		Visualization of fragmentation in a block-axis masonry layout.
	</figcaption>
</figure>
</div>

<h3 id="grid-axis-pagination">
Fragmentation in the Grid Axis</h3>

Fragmentation in the [=grid axis=] with masonry layout in the other axis is also supported. In this case the fragmentation behaves more like in a regular [=grid container=]; however, there's a separate step to determine which [=grid-axis=] track each item is placed into, before fragmentation occurs.
<div class="example">
Here's an <a href="examples/fragmentation-inline-axis-example.html">example</a> illustrating fragmentation of a grid with masonry layout in its inline-axis. In this case the breaks occurs between the [=grid-axis=] rows.  It renders like this:
<figure style="max-width:100%">
	<video style="max-width:100%" src="images/fragmentation-inline-axis-example.webm" controls></video>
	<figcaption>
		Visualization of fragmentation in the block-axis with inline-axis masonry layout.
	</figcaption>
</figure>
</div>


<h2 id="subgrids">
Subgrids</h2>

Masonry layout is supported in [=subgrids=] (e.g. ''grid: subgrid / masonry''), and grids that use masonry can have subgrids as children.  However, only a parent grid axis can be subgridded in the normal sense.  A subgrid axis with a parent [=masonry axis=] will behave as ''grid/masonry'', unless the subgrid's other axis is also ''grid/masonry'' in which case it behaves as ''grid/none'' (because a [=grid container=] can only have one [=masonry axis=]). ''grid-column/auto''-placed subgrids don't inherit any line names from their parent grid, because that would make the placement of the subgrid's grid items dependent on layout results; but the subgrid's tracks are still aligned to the parent's tracks as usual.  Here's a subgrid <a href="examples/subgrid-example-1.html">example</a>:

<div class="example">
```css
<style>
.grid {
  display: inline-grid;
  grid: auto auto 100px / masonry;
  align-content: center;
  height: 300px;
  border: 1px solid;
}

.grid > * {
  margin: 5px;
  background: silver;
}
.grid > :nth-child(2n) {
  background: pink;
}

.grid subgrid {
  display: grid;
  grid: subgrid / subgrid;
  grid-row: 2 / span 2;
  grid-gap: 30px;
}
.grid subgrid > * { background: cyan; }
</style>
```
```html
<div class="grid">
  <item>1</item>
  <item>2</item>
  <item>3</item>
  <subgrid>
    <item style="height:100px">subgrid.1</item>
    <item>sub.2</item>
    <item>s.3</item>
  </subgrid>
  <item>4</item>
  <item>5</item>
  <item style="width: 80px">6</item>
  <item>7</item>
</div>
```

<figure>
	<img src="images/subgrid-example-1.png">
	<figcaption>
		The rendering of the subgrid example above.
	</figcaption>
</figure>

Note how the subgrid's first item ("subgrid.1") contributes to the intrinsic size of the 2nd row in the parent grid.  This is possible since the subgrid specified a definite placement so we know which tracks it will occupy.  Note also that trying to subgrid the parent's [=masonry axis=] results in the subgrid getting masonry layout in its inline-axis.
</div>


<h2 id="abspos">
Absolute Positioning</h2>


<a href="https://drafts.csswg.org/css-grid/#abspos-items">Grid-aligned absolute-positioned descendants</a> are supported.  In the [=masonry axis=], all [=grid positions=] except line 1 are treated as 'auto'. Line 1 in the [=masonry axis=] corresponds to the start of the [=masonry box=] (which is usually also the content-box start edge) and 'auto' uses the [=grid container=] padding edge as usual. The [=containing block=] is the extent of the tracks the item spans in the [=grid axis=] and the position of line 1 and the padding-box edge in the [=masonry axis=].

ISSUE: It might be useful to define a static position in the [=masonry axis=]. Maybe it could defined as the max (or min?) current [=running position=] of the [=grid-axis=] tracks at that point?  Or the end of the item before it?

ISSUE: It would also be useful to be able to align the [=masonry box=] end edge somehow, but for that we need a way to address the <a href="https://github.com/w3c/csswg-drafts/issues/2402">end line in an implicit grid</a>, or could we just use any non-auto line number other than 1 to indicate the end line given that we don't really have any lines in this axis other than line 1?

<h2 id="performance-notes">
Performance Notes</h2>

In general, masonry layout should have significantly better performance than the equivalent regular (2-axis) grid layout, particularly when the [=masonry axis=] is the block-axis since the intrinsic sizing of grid rows is typically quite expensive. Any intrinsic track sizing in the [=grid axis=] should be cheaper too, because, typically, only a subset of items contribute to the intrinsic sizing in a masonry layout, contrary to a 2-axis grid where all items spanning an intrinsically-sized track contribute. That said, ''justify/align-tracks: stretch'' specifically adds a cost proportionate to the number of items that are resized. (Note that ''align-tracks/stretch'' isn't the default value for these properties though.) Stretched items do a second layout with the new size (when it actually changed) so this can be costly if there are a huge amount of stretched items that each contains a lot of content. Especially nested stretched masonry layouts should be avoided unless they are small/trivial.

Advisement: This can be ameliorated by the author by opting out from the stretching on most items though, e.g. specifying ''justify/align-items:start'' and then opting in for just a few items with ''justify/align-self:stretch'' to let those items fill the [=masonry axis=]. Other 'justify-tracks' / 'align-tracks' values such as ''align-self/center'', ''align-self/end'' and '<<content-distribution>>' (other than ''align-self/stretch'') shouldn't be a problem though since they just reposition the items which is fast. (This performance analysis is from a Gecko perspective, but I suspect there's some truth to it for other layout engines as well.)


<h2 id="graceful-degradation">
Graceful Degradation</h2>

Typically, a masonry design can be expected to degrade quite nicely in a UA that supports Grid layout but not masonry layout if the 'grid'/'grid-template' shorthands are avoided and the longhands are used instead. e.g.
```css
  grid-template-rows: masonry; /* ignored by UAs that don't support it */
  grid-template-columns: 150px 100px 50px;
```

<div class="example">
Here's an <a href="examples/graceful-degradation-example.html">example</a> to illustrate this. It's a layout with three columns, but will have "more gaps" in the block-axis if the UA doesn't support masonry layout.  Here's what it looks like with Masonry support for comparison:

<figure>
	<video src="images/graceful-degradation-example.webm" controls></video>
	<figcaption>
		Rendering of the example in a UA with Masonry support.
	</figcaption>
</figure>
</div>


<h2 id="acknowledgements">
Acknowledgements</h2>

Thanks goes to Cameron McCormack who wrote a masonry layout explainer document (from which I lifted the Background chapter) and presented it to the CSSWG.  Thanks also to everyone who provided feedback on the <a href="https://github.com/w3c/csswg-drafts/issues/4650">initial proposal</a> for this feature.
