/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIExternalProtocolService.idl
 */

package org.mozilla.xpcom;

/**
 * The external protocol service is used for finding and launching
 * platform specific applications for particular protocols.
 *
 * You can ask the external protocol service if it has an external
 * handler for a given protocol scheme. And you can ask it to load 
 * the url using the default handler.
 */
public interface nsIExternalProtocolService extends nsISupports {

  String NS_IEXTERNALPROTOCOLSERVICE_IID =
    "{a49813a4-98b7-4bdb-998c-8bd9704af0c0}";

  /**
   * Check whether a handler for a specific protocol exists.
   * @param aProtocolScheme The scheme from a url: http, ftp, mailto, etc.
   * @return true if we have a handler and false otherwise.
   */
  boolean externalProtocolHandlerExists(String aProtocolScheme);

  /**
   * Check whether a handler for a specific protocol is "exposed" as a visible
   * feature of the current application.
   *
   * An exposed protocol handler is one that can be used in all contexts.  A
   * non-exposed protocol handler is one that can only be used internally by the
   * application.  For example, a non-exposed protocol would not be loaded by the
   * application in response to a link click or a X-remote openURL command.
   * Instead, it would be deferred to the system's external protocol handler.
   */
  boolean isExposedProtocol(String aProtocolScheme);

  /**
   * Used to load a url via an external protocol handler (if one exists)
   * @param aURL The url to load
   */
  void loadUrl(nsIURI aURL);

  /**
   * Used to load a URI via an external application. Might prompt the user for
   * permission to load the external application. Replaces loadUrl()
   *
   * @param aURI    The URI to load
   * @param aPrompt If null we grab one from windowwatcher if we need it
   */
  void loadURI(nsIURI aURI, nsIPrompt aPrompt);

  /**
   * Gets a human-readable description for the application responsible for
   * handling a specific protocol.
   *
   * @param aScheme The scheme to look up. For example, "mms".
   *
   * @throw NS_ERROR_NOT_IMPLEMENTED
   *        If getting descriptions for protocol helpers is not supported
   * @throw NS_ERROR_NOT_AVAILABLE
   *        If no protocol helper exists for this scheme, or if it is not
   *        possible to get a description for it.
   */
  String getApplicationDescription(String aScheme);

}