/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/toolkit/components/places/public/nsINavHistoryService.idl
 */

package org.mozilla.xpcom;

/**
 * Allows clients to observe what is happening to a result as it updates itself
 * according to history and bookmark system events. Register this observer on a
 * result using registerView
 *
 * @see nsINavHistoryResult for where this fits in
 */
public interface nsINavHistoryResultViewer extends nsISupports {

  String NS_INAVHISTORYRESULTVIEWER_IID =
    "{11032c23-a9fd-4918-bc8f-004726a748da}";

  /**
   * Called when 'item' is inserted into 'parent' at index 'newIndex'. The item
   * previously at index (if any) and everything below it will have been
   * shifted down by one. The item may be a container or a leaf.
   */
  void itemInserted(nsINavHistoryContainerResultNode parent, nsINavHistoryResultNode item, long newIndex);

  /**
   * Called whan 'item' is removed from 'parent' at 'oldIndex'. The item may be
   * a container or a leaf. This function will be called after the item has
   * been removed from its parent list, but before anything else (including
   * NULLing out the item's parent) has happened.
   */
  void itemRemoved(nsINavHistoryContainerResultNode parent, nsINavHistoryResultNode item, long oldIndex);

  /**
   * Called when an item has been changed and should be repainted. This only
   * refers to the specific item. If it is a container, getting this message
   * does not imply anything happened to the children. You'll get separate
   * messages for those. Also, this may be called for container nodes at times
   * when the result thinks it's possible that a twisty mey need to bw redrawn.
   */
  void itemChanged(nsINavHistoryResultNode item);

  /**
   * Called when an item is being replaced with another item at the exact
   * same position.
   */
  void itemReplaced(nsINavHistoryContainerResultNode parent, nsINavHistoryResultNode oldItem, nsINavHistoryResultNode newItem, long index);

  /**
   * Called after a container node went from closed to opened.
   */
  void containerOpened(nsINavHistoryContainerResultNode item);

  /**
   * Called after a container node went from opened to closed. This will be
   * called for the topmost container that is closing, and implies that any
   * child containers have closed as well.
   */
  void containerClosed(nsINavHistoryContainerResultNode item);

  /**
   * Called when something significant has happened within the container. The
   * contents of the container should be re-built.
   */
  void invalidateContainer(nsINavHistoryContainerResultNode item);

  /**
   * Called when something significant is changing that requires everything
   * to be recomputed. For example, changing sorting or changing collapse
   * duplicates can affect every row.
   */
  void invalidateAll();

  /**
   * This is called to indicate to the UI that the sort has changed to the
   * given mode. For trees, for example, this would update the column headers
   * to reflect the sorting. For many other types of views, this won't be
   * applicable.
   *
   * @param sortingMode  One of nsINavHistoryQueryOptions.SORT_BY_* that
   *                     indicates the new sorting mode.
   *
   * This only is expected to update the sorting UI. invalidateAll() will also
   * get called if the sorting changes to update everything.
   */
  void sortingChanged(long sortingMode);

  /**
   * Called by the result when this object is set using
   * nsINavHistoryResult.viewer. This will be set to NULL when the result
   * is being deallocated. This should not be set by other code.
   */
  nsINavHistoryResult getResult();

  /**
   * Called by the result when this object is set using
   * nsINavHistoryResult.viewer. This will be set to NULL when the result
   * is being deallocated. This should not be set by other code.
   */
  void setResult(nsINavHistoryResult aResult);

  /**
   * Adds the specified view observer to the view. In ownsWeak is false, then
   * the result will hold a strong reference to the observer. If ownsWeak is
   * true, then the observer must implement nsISupportsWeakReference, and the
   * result will hold a weak reference to the observer.
   */
  void addViewObserver(nsINavHistoryResultViewObserver observer, boolean ownsWeak);

  /**
   * Removes the specified view observer from this view. This observer must
   * have been previously registered using addViewObserver.
   */
  void removeViewObserver(nsINavHistoryResultViewObserver observer);

}