/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIEventQueueService.idl
 */

package org.mozilla.xpcom;

public interface nsIEventQueueService extends nsISupports {

  String NS_IEVENTQUEUESERVICE_IID =
    "{a6cf90dc-15b3-11d2-932e-00805f8add32}";

  /**
   * Creates and holds a native event queue for the current thread.
   * "Native" queues have an associated callback mechanism which is
   * automatically triggered when an event is posted. See plevent.c for 
   * details.
   * @return NS_OK on success, or a host of failure indications
   */
  void createThreadEventQueue();

  /**
   * Creates and hold a monitored event queue for the current thread.
   * "Monitored" queues have no callback processing mechanism.
   * @return NS_OK on success, or a host of failure indications
   */
  void createMonitoredThreadEventQueue();

  /**
   * Somewhat misnamed, this method releases the service's hold on the event
   * queue(s) for this thread. Subsequent attempts to access this thread's
   * queue (GetThreadEventQueue, for example) may fail, though the queue itself
   * will be destroyed only after all references to it are released and the
   * queue itself is no longer actively processing events.
   * @return nonsense.
   */
  void destroyThreadEventQueue();

  nsIEventQueue createFromIThread(nsIThread aThread, boolean aNative);

  nsIEventQueue pushThreadEventQueue();

  void popThreadEventQueue(nsIEventQueue aQueue);

  /**
   * Returns the appropriate special event queue, AddRef()ed.  Really
   * just a scriptable version of ResolveEventQueue.
   *
   * @arg aQueue    Either CURRENT_THREAD_EVENT_QUEUE or
   *                UI_THREAD_EVENT_QUEUE
   * @return        The requested nsIEventQueue, AddRef()ed
   * @exception NS_ERROR_NULL_POINTER   Zero pointer passed in for return value
   * @exception NS_ERROR_ILLEGAL_VALUE  Bogus constant passed in aQueue
   * @exception NS_ERROR_FAILURE        Error while calling 
   *                                    GetThreadEventQueue()
   */
  nsIEventQueue getSpecialEventQueue(int aQueue);

  int CURRENT_THREAD_EVENT_QUEUE = 0;

  int UI_THREAD_EVENT_QUEUE = 1;

}