/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * gfxIImageFrame.idl
 */

package org.mozilla.xpcom;

/**
 * gfxIImageFrame interface
 *
 * All x, y, width, height values are in pixels.
 *
 * @author Tim Rowley <tor@cs.brown.edu>
 * @author Stuart Parmenter <pavlov@netscape.com>
 * @version 0.1
 */
public interface gfxIImageFrame extends nsISupports {

  String GFXIIMAGEFRAME_IID =
    "{f6d00ee7-defc-4101-b2dc-e72cf4c37c3c}";

  /**
   * Create a new \a aWidth x \a aHeight sized image.
   *
   * @param aX The x-offset from the origin of the gfxIImageContainer parent.
   * @param aY The y-offset from the origin of the gfxIImageContainer parent.
   * @param aWidth The width of the image to create.
   * @param aHeight The height of the image to create.
   * @param aFormat the width of the image to create.
   *
   * @note The data in a new image is uninitialized.
   */
  void init(int aX, int aY, int aWidth, int aHeight, int aFormat, int aDepth);

  /**
   * TRUE by default.  When set to FALSE, you will no longer be able to make any modifications
   * to the data of the image.  Any attempts will fail.
   */
  boolean getMutable();

  /**
   * TRUE by default.  When set to FALSE, you will no longer be able to make any modifications
   * to the data of the image.  Any attempts will fail.
   */
  void setMutable(boolean aMutable);

  /**
   * The x-offset of the image.
   */
  int getX();

  /**
   * The y-offset of the image.
   */
  int getY();

  /**
   * The width of the image.
   */
  int getWidth();

  /**
   * The height of the image.
   */
  int getHeight();

  /**
   * The image data format the image was created with.
   * @see gfxIFormats
   */
  int getFormat();

  /**
   * returns whether the image requires the background to be painted
   */
  boolean getNeedsBackground();

  long getImageBytesPerRow();

  /**
   * returns the number of bytes allocated for the image
   */
  long getImageDataLength();

  void getImageData(short[][] bits, long[] length);

  /**
   * Sets \a length bytes of \a data in this object.
   * @param offset The offset from the first pixel in bytes.  To set
   *   data beginning with the first (top left) pixel in the image, \a offset
   *   should be 0; to set data beginning with, for example, the sixth pixel in
   *   the first row of a RGBA32 image, the offset should be 20.
   * @attension should we use PRUint32 instead?
   */
  void setImageData(short[] data, long length, int offset);

  /**
   * Lock image pixels before addressing the data directly
   */
  void lockImageData();

  /**
   * Unlock image pixels
   */
  void unlockImageData();

  long getAlphaBytesPerRow();

  /**
   * returns the number of bytes allocated for the alpha mask
   */
  long getAlphaDataLength();

  void getAlphaData(short[][] bits, long[] length);

  /**
   * Sets \a length bytes of \a data in this object.
   */
  void setAlphaData(short[] data, long length, int offset);

  /**
   * Lock alpha pixels before addressing the data directly
   */
  void lockAlphaData();

  /**
   * Unlock alpha pixels
   */
  void unlockAlphaData();

  /**
   * Blit this frame into another frame. Used for GIF animation compositing
   */
  void drawTo(gfxIImageFrame aDst, int aDX, int aDY, int aDWidth, int aDHeight);

  /**
   * Represents the number of milliseconds until the next frame should be displayed.
   * @note -1 means that this frame should be displayed forever.
   */
  int getTimeout();

  /**
   * Represents the number of milliseconds until the next frame should be displayed.
   * @note -1 means that this frame should be displayed forever.
   */
  void setTimeout(int aTimeout);

  int getFrameDisposalMethod();

  void setFrameDisposalMethod(int aFrameDisposalMethod);

  long getBackgroundColor();

  void setBackgroundColor(long aBackgroundColor);

}