/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/extensions/webservices/public/nsISOAPTransport.idl
 */

package org.mozilla.interfaces;

public interface nsISOAPTransport extends nsISupports {

  String NS_ISOAPTRANSPORT_IID =
    "{99ec6695-535f-11d4-9a58-000064657374}";

  /**
   * Send the specified message to the specified destination.
   * This will fail if synchronous calls are not supported or if there is any
   * failure in the actual message exchange.  Failure of the call itself will be
   * contained in the response.
   *
   * @param aCall Actual message to be sent.
   *
   * @param aResponse Message to be received.  Calling synchronously assumes that 
   *   exactly one response is expected.
   */
  void syncCall(nsISOAPCall aCall, nsISOAPResponse aResponse);

  /**
   * Send the specified message to the specified destination synchronously waiting 
   * for completion and any response.
   * This will fail if there is any failure in the setup of the message exchange.
   * Later errors will only be known through the response listener.  Failures of the
   * call itself will be contained in the response passed to the response listener.
   *
   * @param aCall Actual message to be sent.
   *
   * @param aListener Handler to be invoked (single threaded) as each response is 
   *  received and finally with null.  If specified as null, no responses are returned.
   *
   * @param response Message to receive response and be handled by listener.  May be 
   *   null if listener is null.
   */
  nsISOAPCallCompletion asyncCall(nsISOAPCall aCall, nsISOAPResponseListener aListener, nsISOAPResponse aResponse);

  /**
   * Add listener for unsolicited messages arriving on the transport.  Listeners
   *  are provided with the opportunity to accept and process messages.  Typically
   *  a listener will be a service dispatcher.  Listeners will be invoked in the
   *  reverse order of declaration, allowing more local service dispatchers to
   *  temporarily override permanent service dispatchers.  This will fail if the
   *  desired listener was already added to the transport with the specified
   *  capture flag or if the transport does not support incoming messages.
   *
   * @param aListener The listener to receive unsolicited messages from the
   *   transport.
   *
   * @param aCapture True if the listener should capture the message before
   *   later-declared services.
   */
  void addListener(nsISOAPTransportListener aListener, boolean aCapture);

  /**
   * Remove listener for unsolicited messages arriving on the transport.  This
   *  will fail if the specified listener was not added with the specified
   *  capture setting.
   *
   * @param aListener The listener to stop from receiving unsolicited messages 
   *  from the transport.
   *
   * @param aCapture True if the listener was added to capture the message before
   *   later-declared services (must be specified to remove, since a listener
   *   may be registered as both).
   */
  void removeListener(nsISOAPTransportListener aListener, boolean aCapture);

}