/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIPermissionManager.idl
 */

package org.mozilla.interfaces;

public interface nsIPermissionManager extends nsISupports {

  String NS_IPERMISSIONMANAGER_IID =
    "{4f6b5e00-0c36-11d5-a535-0010a401eb10}";

  /**
   * Predefined return values for the testPermission method and for
   * the permission param of the add method
   */
  long UNKNOWN_ACTION = 0L;

  long ALLOW_ACTION = 1L;

  long DENY_ACTION = 2L;

  /**
   * Add permission information for a given URI and permission type. This
   * operation will cause the type string to be registered if it does not
   * currently exist.
   *
   * @param uri         the uri to add the permission for
   * @param type        a case-sensitive ASCII string, identifying the consumer.
   *                    Consumers should choose this string to be unique, with
   *                    respect to other consumers. The number of unique type
   *                    identifiers may be limited.
   * @param permission  an integer from 1 to 15, representing the desired
   *                    action (e.g. allow or deny). The interpretation of
   *                    this number is up to the consumer, and may represent
   *                    different actions for different types. Consumers may
   *                    use one of the enumerated permission actions defined
   *                    above. 0 is reserved for UNKNOWN_ACTION, and shouldn't
   *                    be used.
   * @throws            NS_ERROR_FAILURE if there is no more room for adding
   *                    a new type
   */
  void add(nsIURI uri, String type, long permission);

  /**
   * Remove permission information for a given URI and permission type.
   * Note that this method takes a host string, not an nsIURI.
   *
   * @param host   the host to remove the permission for
   * @param type   a case-sensitive ASCII string, identifying the consumer. 
   *               The type must have been previously registered using the
   *               add() method.
   */
  void remove(String host, String type);

  /**
   * Clear permission information for all websites.
   */
  void removeAll();

  /**
   * Test whether a website has permission to perform the given action.
   * @param uri     the uri to be tested
   * @param type    a case-sensitive ASCII string, identifying the consumer
   * @param return  see add(), param permission. returns UNKNOWN_ACTION when
   *                there is no stored permission for this uri and / or type.
   */
  long testPermission(nsIURI uri, String type);

  /**
   * Allows enumeration of all stored permissions
   * @return an nsISimpleEnumerator interface that allows access to
   *         nsIPermission objects
   */
  nsISimpleEnumerator getEnumerator();

}