/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIBinaryOutputStream.idl
 */

package org.mozilla.interfaces;

/**
 * This interface allows writing of primitive data types (integers,
 * floating-point values, booleans, etc.) to a stream in a binary, untagged,
 * fixed-endianness format.  This might be used, for example, to implement
 * network protocols or to produce architecture-neutral binary disk files,
 * i.e. ones that can be read and written by both big-endian and little-endian
 * platforms.  Output is written in big-endian order (high-order byte first),
 * as this is traditional network order.
 *
 * @See nsIBinaryInputStream
 */
public interface nsIBinaryOutputStream extends nsIOutputStream {

  String NS_IBINARYOUTPUTSTREAM_IID =
    "{204ee610-8765-11d3-90cf-0040056a906e}";

  void setOutputStream(nsIOutputStream aOutputStream);

  void writeBoolean(boolean aBoolean);

  void write8(short aByte);

  void write16(int a16);

  void write32(long a32);

  void write64(double a64);

  void writeFloat(float aFloat);

  void writeDouble(double aDouble);

  /**
     * Write a NUL-terminated 8-bit char* string to a binary stream.
     */
  void writeStringZ(String aString);

  /**
     * Write a NUL-terminated 16-bit PRUnichar* string to a binary stream.
     */
  void writeWStringZ(String aString);

  /**
     * Write a NUL-terminated UTF8-encoded string to a binary stream, produced
     * from a NUL-terminated 16-bit PRUnichar* string argument.
     */
  void writeUtf8Z(String aString);

  /**
     * Write an opaque byte array to a binary stream.
     */
  void writeBytes(String aString, long aLength);

  /**
     * Write an opaque byte array to a binary stream.
     */
  void writeByteArray(short[] aBytes, long aLength);

}