/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIStyleSheetService.idl
 */

package org.mozilla.interfaces;

public interface nsIStyleSheetService extends nsISupports {

  String NS_ISTYLESHEETSERVICE_IID =
    "{41d979dc-ea03-4235-86ff-1e3c090c5630}";

  long AGENT_SHEET = 0L;

  long USER_SHEET = 1L;

  /**
   * Synchronously loads a style sheet from |sheetURI| and adds it to the list
   * of user or agent style sheets.
   *
   * A user sheet loaded via this API will come before userContent.css and
   * userChrome.css in the cascade (so the rules in it will have lower
   * precedence than rules in those sheets).
   *
   * An agent sheet loaded via this API will come after ua.css in the cascade
   * (so the rules in it will have higher precedence than rules in ua.css).
   *
   * The relative ordering of two user or two agent sheets loaded via
   * this API is undefined.
   */
  void loadAndRegisterSheet(nsIURI sheetURI, long type);

  /**
   * Returns true if a style sheet at |sheetURI| has previously been
   * added to the list of style sheets specified by |type|.
   */
  boolean sheetRegistered(nsIURI sheetURI, long type);

  /**
   * Remove the style sheet at |sheetURI| from the list of style
   * sheets specified by |type|.  All documents loaded after
   * this call will no longer use the style sheet.
   */
  void unregisterSheet(nsIURI sheetURI, long type);

}