/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsISOAPResponseListener.idl
 */

package org.mozilla.interfaces;

/**
 * This interface represents a response handler to be invoked whenever
 * a response of a particular call is received and when no more
 * responses are expected.
 */
public interface nsISOAPResponseListener extends nsISupports {

  String NS_ISOAPRESPONSELISTENER_IID =
    "{99ec6692-535f-11d4-9a58-000064657374}";

  /**
   * This method is invoked when we receive an asynchronous response to 
   * a SOAP message. The listener is registered as part of the original
   * asynchronous call invocation. 
   *
   * @param aResponse The decoded version of the response.  If an
   *   error occurred transmitting the response, the status field
   *   of the response will contain an error code.  The last call
   *   to the listener may contain a null response, which should
   *   only be interpreted as an error if your call expected more 
   *   results than it got.  If the service or the transport
   *   do not know whether to expect more results, then setting
   *   the last parameter true may only be possible after the
   *   last response has already been delivered.
   *
   * @param aLast True if this is the last call to the listener.
   *
   * @return True to make this the last call to the listener, even
   *   if last was not true.  Calls which expect a single response
   *   should return true upon receiving that response to avoid
   *   possibly recieving another callback with a null response
   *   indicating that the last response was already sent.
   */
  boolean handleResponse(nsISOAPResponse aResponse, nsISOAPCall aCall, long status, boolean aLast);

}