/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsISOAPServiceRegistry.idl
 */

package org.mozilla.interfaces;

/**
 * This interface represents a registry of SOAP services.
 * This registry receives transports to listen for messages
 *   and services to hand the messages to.  Service registries
 *   may be created as required.  Destroying a service registry
 *   stops the registry's action.  To temporarily register
 *   services, create a new registry.  For proper order of
 *   listening precedence, registries should be destroyed
 *   in reverse order.  Otherwise, a listening priority
 *   would be required.
 */
public interface nsISOAPServiceRegistry {

  String NS_ISOAPSERVICEREGISTRY_IID =
    "{9790d6bc-1dd1-11b2-afe0-bcb310c078bf}";

  /**
   * Process a configuration and add the resulting sources
   *   and services.  This will fail if errors occur during
   *   processing of the configuration.
   *
   * @param aConfiguration Root element of configuration XML.
   */
  boolean addConfiguration(nsIDOMElement aConfiguration);

  /**
   * Add a transport to be serviced by the registered services.
   *   This will fail if the specified source was already added
   *   with the same setting of the capture flag.
   *
   * @param aTransport string specifying the transport to supply
   *   messages for the service.
   *
   * @param aCapture True if capturing before later declarations
   */
  void addSource(String aTransport, boolean aCapture);

  /**
   * Add a service to service the registered transports.  This
   *   will fail if the specified service was already added.
   *
   * @param aService Service to be serviced.
   */
  void addService(nsISOAPService aService);

  /**
   * Registry identifying how to encode and decode
   *   messages containing specific types, automatically
   *   added to messages sent to services in this
   *   registry.
   */
  nsISOAPEncodingRegistry getEncodings();

  /**
   * Registry identifying how to encode and decode
   *   messages containing specific types, automatically
   *   added to messages sent to services in this
   *   registry.
   */
  void setEncodings(nsISOAPEncodingRegistry aEncodings);

}