/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/tinderbox/XR-Trunk/Darwin_8.8.4_Depend/mozilla/netwerk/cache/public/nsIOfflineCacheSession.idl
 */

package org.mozilla.interfaces;

public interface nsIOfflineCacheSession extends nsISupports {

  String NS_IOFFLINECACHESESSION_IID =
    "{e9581d9f-3c0c-4722-8d2b-3d18f8d41299}";

  /**
     * The offline cache is meant to reliably store resources for
     * offline use.  The expected semantics are:
     *
     * a) Once populated, the cache will not evict an application resource
     *    unless explicitly asked.
     *
     * b) Resources no longer in use by the application should be evicted.
     *
     * c) If the cache fills up, new entries should be rejected rather
     *    than throwing out old ones.
     *
     * The offline cache uses domains to concretely represent an
     * application.  It maintains a list of resources to be pinned for
     * each domain.  This list is separate from actual cache
     * population - the caller is still responsible for placing items
     * in the cache, and ownership can be declared without a
     * corresponding entry.
     *
     * A key can optionally be associated with a specific URI within
     * the domain.
     */
/**
     * Sets the resources owned by a given domain/URI pair.
     *
     * Setting a list will remove any resources previously owned by this
     * domain/URI pair.
     *
     * A key can be added while there is no associated entry.  When
     * an entry is created with this key, it will be owned by the
     * domain/URI pair.
     *
     * @param ownerDomain The domain that owns the resources.
     * @param ownerURI The specific URI that owns the resources.  This can
     *        be empty if no URI specifically owns the resources.
     * @param count The number of keys in keys.
     * @param keys The keys that the domain/URI pair own.  This can be empty
     *        to clear ownership for the domain/URI pair.
     */
  void setOwnedKeys(String ownerDomain, String ownerURI, long count, String[] keys);

  /**
     * Gets the list of resources owned by a given domain/URI pair.
     *
     * @param ownerDomain The domain that owns the resources.
     * @param ownerURI The specific URI that owns the resources.  This can
     *        be empty if no URI specifically owns the resources.
     * @param count The number of keys in keys.
     * @param keys The keys that the domain/URI pair own.
     */
  void getOwnedKeys(String ownerDomain, String ownerURI, long[] count, String[][] keys);

  /**
     * Adds an owned key to a domain/URI pair.
     *
     * A key can be added while there is no associated entry.  When
     * an entry is created with this key, it will be owned by the
     * domain/URI pair.
     *
     * @param ownerDomain The domain that owns the resources.
     * @param ownerURI The specific URI that owns the resources.  This can
     *        be empty if no URI specifically owns the resources.
     * @param key The key to add.
     */
  void addOwnedKey(String ownerDomain, String ownerURI, String key);

  /**
     * Removes an owned key from a domain/URI pair.
     *
     * If the key does not exist, an NS_ERROR_NOT_AVAILABLE exception
     * will be thrown.
     *
     * @param ownerDomain The domain that owns the resources.
     * @param ownerURI The specific URI that owns the resources.  This can
     *        be empty if no URI specifically owns the resources.
     * @param key The key to remove.
     */
  void removeOwnedKey(String ownerDomain, String ownerURI, String key);

  /**
     * Checks whether a key is owned by a given domain/URI pair.
     *
     * @param ownerDomain The domain that owns the resources.
     * @param ownerURI The specific URI that owns the resources.  This can
     *        be empty if no URI specifically owns the resources.
     * @param key The key to check
     */
  boolean keyIsOwned(String ownerDomain, String ownerURI, String key);

  /**
     * Remove all keys owned by a domain, including keys owned by
     * a specific URI.
     *
     * @param domain The domain for which keys should be removed.
     */
  void clearKeysOwnedByDomain(String ownerDomain);

  /**
     * Evict all entries that are not owned by a domain.
     */
  void evictUnownedEntries();

}