/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/tinderbox/XR-Trunk/Darwin_8.8.4_Depend/mozilla/extensions/webservices/public/nsISOAPMessage.idl
 */

package org.mozilla.interfaces;

/**
 * This interface controls all SOAP messages. It permits easy
 * construction of a message, typically through encoding of
 * parameters and certain properties settable on this interface
 * or through deserialization of a transport stream.  It
 * permits easy processing of a message typically through
 * decoding of parameters and certain properties available
 * on this interface.  It also encapsulates protocol information
 * interpreted by the transport.
 */
public interface nsISOAPMessage extends nsISupports {

  String NS_ISOAPMESSAGE_IID =
    "{3970815e-1dd2-11b2-a475-db4dac6826f1}";

  int VERSION_1_1 = 0;

  int VERSION_1_2 = 1;

  int VERSION_UNKNOWN = 65535;

  /**
   * The document which captures the message, if any.  A simple 
   * sending application passes parameters to the method
   * encodeSOAPParameters, which calls SOAP encoders 
   * to construct this document along with all contained elements.  
   *
   * But an application may create and set the message directly
   * instead of invoking encodeSOAPParameters to use encoders
   * or access and manipulate the message after it has been 
   * constructed by encodeSOAPParameters.  If the message has 
   * not been set, invoking a call will fail.  A message receiver 
   * may also use this accessor to get the document to avoid using 
   * decoders.
   */
  nsIDOMDocument getMessage();

  /**
   * The document which captures the message, if any.  A simple 
   * sending application passes parameters to the method
   * encodeSOAPParameters, which calls SOAP encoders 
   * to construct this document along with all contained elements.  
   *
   * But an application may create and set the message directly
   * instead of invoking encodeSOAPParameters to use encoders
   * or access and manipulate the message after it has been 
   * constructed by encodeSOAPParameters.  If the message has 
   * not been set, invoking a call will fail.  A message receiver 
   * may also use this accessor to get the document to avoid using 
   * decoders.
   */
  void setMessage(nsIDOMDocument aMessage);

  /**
   * A convenience attribute to obtain the DOM element representing the
   * SOAP envelope from the document.  DOM methods may be used to 
   * access, add, or modify attributes of the envelope.
   *
   * If the message attribute is null or is not a document containing
   * a root soap envelope element, then this will be null.
   */
  nsIDOMElement getEnvelope();

  /**
   * A convenience attribute to obtain the SOAP version number, if
   * it is known, from the envelope.
   *
   * If the message attribute is null or is not a document containing
   * a root soap envelope element, then this will be VERSION_UNKNOWN.
   */
  int getVersion();

  /**
   * A convenience attribute to obtain the DOM element representing the
   * SOAP header from the envelope.  DOM methods may be used to 
   * access, add, or modify attributes or elements of the header.
   *
   * If the envelope attribute is null or does not contain a SOAP header
   * element type, then this will be null.
   */
  nsIDOMElement getHeader();

  /**
   * A convenience attribute to obtain the DOM element representing the
   * SOAP body from the envelope.  DOM methods may be used to 
   * access, add, or modify attributes or elements of the body.
   *
   * If the envelope attribute is null or does not contain a SOAP body
   * element type, then this will be null.
   */
  nsIDOMElement getBody();

  /**
   * The name of the method being invoked. The methodName is set
   * during encoding as the tagname of the single child of body
   * of RPC-style messages.  When there is no encoded message
   * this will be null.  The value of this attribute for
   * document-style messages may be non-null but should be
   * ignored.  It is up to the application to know whether the
   * message is RPC-style or document style because the SOAP
   * specification makes it difficult to tell which way a
   * message was encoded.
   */
  String getMethodName();

  /**
   * The target object on which the method is being invoked. This URI
   * is set during encoding as the namespace to qualify the tagname 
   * of the single child of body of RPC-style messages.  When there
   * is no encoded message, this will be null.  The value of this
   * attribute for document-style messages may be non-null but should
   * be ignored.  It is up to the application to know whether the
   * message is RPC-style or document style because the SOAP
   * specification makes it difficult to tell which way a
   * message was encoded.
   */
  String getTargetObjectURI();

  /**
   * Encodes the specified parameters into this message, if
   * this message type supports it.
   *
   * @param aMethodName The name of the method being invoked
   * for rpc-style messages.  For document-style messages,
   * this must be null.
   *
   * @param aTargetObjectURI The name of the target object
   * for rpc-style messages.  For document-style messages,
   * this must be null.
   *
   * @param aHeaderBlockCount Number of header blocks in array to be
   *   encoded.  Must be 0 if header block array is null.
   *
   * @param aHeaderBlocks Array of header blocks to be encoded, which
   *   may be null if there are no header blocks.
   *
   * @param aParameterCount Number of parameters in array 
   *   to be encoded.  Must be 0 if parameter array is null.
   *
   * @param aParameters An array of parameters to be 
   *   encoded, which may null if there are no parameters.
   */
  void encode(int aVersion, String aMethodName, String aTargetObjectURI, long aHeaderBlockCount, nsISOAPHeaderBlock[] aHeaderBlocks, long aParameterCount, nsISOAPParameter[] aParameters);

  /**
   * Gathers the header blocks of a message so that they can be
   *   accessed by a recipient.
   *
   * @param aCount Integer to receive the length of the list
   *   of header blocks.
   *
   * @return Array of header blocks found in the message.
   */
  nsISOAPHeaderBlock[] getHeaderBlocks(long[] aCount);

  /**
   * Gathers the parameters of a message so that they can be
   *   accessed by a recipient.
   *
   * @param aDocumentStyle If true, then the parameters
   *   are looked for treating the message as a document 
   *   style message, otherwise it treated as an RPC-style 
   *   message.
   *
   * @param aCount Integer to receive the length of the list
   *   of parameters.
   *
   * @return Array of parameters found in the message.
   */
  nsISOAPParameter[] getParameters(boolean aDocumentStyle, long[] aCount);

  /**
   * The primary encoding of the message, which is established
   *   at the envelope and used unless overridden.  By default,
   *   this is the SOAP encoding, which may be locally modified
   *   or used to obtain alternative encodings, which may be
   *   locally modified, but it may be set to an encoding that
   *   is shared, or it may be set to null, in which case all
   *   non-literal header blocks and parameters must specify an
   *   encoding.
   */
  nsISOAPEncoding getEncoding();

  /**
   * The primary encoding of the message, which is established
   *   at the envelope and used unless overridden.  By default,
   *   this is the SOAP encoding, which may be locally modified
   *   or used to obtain alternative encodings, which may be
   *   locally modified, but it may be set to an encoding that
   *   is shared, or it may be set to null, in which case all
   *   non-literal header blocks and parameters must specify an
   *   encoding.
   */
  void setEncoding(nsISOAPEncoding aEncoding);

  /**
   * An optional URI that can be used to add a SOAPAction HTTP
   * header field. If this attribute is NULL (the default case),
   * no SOAPAction header will be added.
   */
  String getActionURI();

  /**
   * An optional URI that can be used to add a SOAPAction HTTP
   * header field. If this attribute is NULL (the default case),
   * no SOAPAction header will be added.
   */
  void setActionURI(String aActionURI);

}