/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/editor/composer/public/nsIEditingSession.idl
 */

package org.mozilla.interfaces;

public interface nsIEditingSession extends nsISupports {

  String NS_IEDITINGSESSION_IID =
    "{d39fd2b4-3978-45d2-a4be-ba448171b61b}";

  /**
   *  Error codes when we fail to create an editor
   *  is placed in attribute editorStatus
   */
  int eEditorOK = 0;

  int eEditorCreationInProgress = 1;

  int eEditorErrorCantEditMimeType = 2;

  int eEditorErrorFileNotFound = 3;

  int eEditorErrorCantEditFramesets = 8;

  int eEditorErrorUnknown = 9;

  /**
   *  Status after editor creation and document loading
   *  Value is one of the above error codes
   */
  long getEditorStatus();

  /**
   *  Make this window editable
   *  @param aWindow nsIDOMWindow, the window the embedder needs to make editable
   *  @param aEditorType string, "html" "htmlsimple" "text" "textsimple"
   */
  void makeWindowEditable(nsIDOMWindow window, String aEditorType, boolean doAfterUriLoad);

  /**
   *  Test whether a specific window has had its editable flag set; it may have an editor
   *  now, or will get one after the uri load.
   *  
   *  Use this, passing the content root window, to test if we've set up editing
   *  for this content.
   */
  boolean windowIsEditable(nsIDOMWindow window);

  /**
   *  Get the editor for this window. May return null
   */
  nsIEditor getEditorForWindow(nsIDOMWindow window);

  /** 
   *  Setup editor and related support objects
   */
  void setupEditorOnWindow(nsIDOMWindow window);

  /** 
   *   Destroy editor and related support objects
   */
  void tearDownEditorOnWindow(nsIDOMWindow window);

  void setEditorOnControllers(nsIDOMWindow aWindow, nsIEditor aEditor);

}