/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/profile/public/nsIProfileInternal.idl
 */

package org.mozilla.interfaces;

public interface nsIProfileInternal extends nsIProfile {

  String NS_IPROFILEINTERNAL_IID =
    "{2f977d42-5485-11d4-87e2-0010a4e75ef2}";

  int get4xProfileCount();

  /**
    * The following values are used with getProfileListX
    *
    * LIST_ONLY_NEW     - the list will contain only migrated profiles
    * LIST_ONLY_OLD     - the list will contain only un-migrated profiles
    * LIST_ALL          - the list will contain all profiles
    * LIST_FOR_IMPORT   - the list is generated from 4.x registry and contains
    *                     all the 4.x profiles
    *                     do not use this except from the import module
    * 
    */
  long LIST_ONLY_NEW = 1L;

  long LIST_ONLY_OLD = 2L;

  long LIST_ALL = 3L;

  long LIST_FOR_IMPORT = 4L;

  String[] getProfileListX(long which, long[] length);

  void migrateProfileInfo();

  void migrateAllProfiles();

  void migrateProfile(String profileName);

  void remigrateProfile(String profileName);

  void forgetCurrentProfile();

  void createDefaultProfile();

  /**
     * Returns the actual profile directory
     */
  nsIFile getProfileDir(String profileName);

  /**
     * Returns the path to a profile which can be shown to the user.
     * If the actual profile directory is salted, returns the unsalted parent.
     * This is the directory which will be deleted by deleteProfile(name, true).
     */
  String getProfilePath(String profileName);

  /**
     * Returns a profile directory of the importType. The path will point to 
     * the 4.x profile directory. Should be used only from the import module.
     */
  nsILocalFile getOriginalProfileDir(String profileName);

  /**
     * Returns the date on which a profile was last used.
     * value is in milliseconds since midnight Jan 1, 1970 GMT (same as nsIFile)
     */
  long getProfileLastModTime(String profileName);

  boolean getAutomigrate();

  void setAutomigrate(boolean aAutomigrate);

  nsIFile getDefaultProfileParentDir();

  String getFirstProfile();

  /**
     * Affects startup behavior when there are multiple profiles.
     *  If FALSE, the profile selection dialog will be shown.
     *  If TRUE, the last used profile will be chosen automatically.
     */
  boolean getStartWithLastUsedProfile();

  /**
     * Affects startup behavior when there are multiple profiles.
     *  If FALSE, the profile selection dialog will be shown.
     *  If TRUE, the last used profile will be chosen automatically.
     */
  void setStartWithLastUsedProfile(boolean aStartWithLastUsedProfile);

  void createNewProfileWithLocales(String profileName, String nativeProfileDir, String UILocale, String contentLocale, boolean useExistingDir);

  /**
    * The remaining methods are deprecated. DO NOT USE THEM.
    */
  boolean isCurrentProfileAvailable();

}