/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/accessible/public/nsIAccessibleTable.idl
 */

package org.mozilla.interfaces;

public interface nsIAccessibleTable extends nsISupports {

  String NS_IACCESSIBLETABLE_IID =
    "{a776fee4-c0b8-4872-9e1e-72017243383f}";

  nsIAccessible getCaption();

  void setCaption(nsIAccessible aCaption);

  String getSummary();

  void setSummary(String aSummary);

  int getColumns();

  nsIAccessibleTable getColumnHeader();

  int getRows();

  nsIAccessibleTable getRowHeader();

  /**
   * Returns the accessible object at the specified row and column in the table.
   * If both row and column index are valid then the corresponding accessible
   * object is returned that represents the requested cell regardless of whether
   * the cell is currently visible (on the screen).
   *
   * @param row - The row index for which to retrieve the cell.
   * @param column - The column index for which to retrieve the cell.
   */
  nsIAccessible cellRefAt(int row, int column);

  /**
      * get an index
      */
  int getIndexAt(int row, int column);

  int getColumnAtIndex(int index);

  int getRowAtIndex(int index);

  /**
   * Returns the number of columns occupied by the accessible object
   * at the specified row and column in the table. The result differs from 1
   * if the specified cell spans multiple columns.
   *
   * @param row - Row index of the accessible for which to return
   *              the column extent.
   * @param column - Column index of the accessible for which to return
   *                 the column extent.
   */
  int getColumnExtentAt(int row, int column);

  /**
   * Returns the number of rows occupied by the accessible oject
   * at the specified row and column in the table. The result differs from 1
   * if the specified cell spans multiple rows.
   *
   * @param row  - Row index of the accessible for which to return
   *               the column extent.
   * @param column - Column index of the accessible for which to return
   *                 the column extent.
   */
  int getRowExtentAt(int row, int column);

  /**
   * Returns the description text of the specified column in the table.
   * @param column - The index of the column for which to retrieve
   *                 the description.
   */
  String getColumnDescription(int column);

  /**
   * Returns the description text of the specified row in the table.
   * @param row - The index of the row for which to retrieve the description.
   */
  String getRowDescription(int row);

  /**
   * Returns a boolean value indicating whether the specified column is
   * completely selected.
   *
   * @param column  - Index of the column for which to determine whether it is
   *                   selected.
   */
  boolean isColumnSelected(int column);

  /**
   * Returns a boolean value indicating whether the specified row is completely
   * selected.
   *
   * @param row - Index of the row for which to determine whether it is
   *              selected.
   */
  boolean isRowSelected(int row);

  /**
   * Returns a boolean value indicating whether the specified cell is selected.
   *
   * @param row - Index of the row for the cell to determine whether it is
   *              selected.
   * @param column - Index of the column for the cell to determine whether it
   *                 is selected.
   */
  boolean isCellSelected(int row, int column);

  /**
   * Returns a list of column indexes currently selected.
   *
   * @param columnsSize - Length of array
   * @param columns - Array of indexes of selected columns
   */
  int[] getSelectedColumns(long[] columnsSize);

  /**
   * Returns a list of row indexes currently selected.
   *
   * @param rowsSize - Length of array
   * @param rows - Array of indexes of selected rows
   */
  int[] getSelectedRows(long[] rowsSize);

  /**
   * Selects a row and unselects all previously selected rows.
   *
   * @param row - Index of the row to be selected.
   */
  void selectRow(int row);

  /**
   * Selects a column and unselects all previously selected columns.
   *
   * @param column - Index of the column to be selected.
   */
  void selectColumn(int column);

  /**
   * Unselects one row, leaving other selected rows selected (if any).
   *
   * @param row  - Index of the row to be selected.
  */
  void unselectRow(int row);

  /**
   * Unselects one column, leaving other selected columns selected (if any).
   *
   * @param column - Index of the column to be selected.
   */
  void unselectColumn(int column);

  /**
   * Use heuristics to determine if table is most likely used for layout.
   */
  boolean isProbablyForLayout();

}