/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * d:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/netwerk/base/public/nsINetUtil.idl
 */

package org.mozilla.interfaces;

/**
 * nsINetUtil provides various network-related utility methods.
 */
public interface nsINetUtil extends nsISupports {

  String NS_INETUTIL_IID =
    "{7701f947-e4aa-431c-aec6-6bb304193460}";

  /**
   * Parse a content-type header and return the content type and
   * charset (if any).
   *
   * @param aTypeHeader the header string to parse
   * @param [out] aCharset the charset parameter specified in the
   *              header, if any.
   * @param [out] aHadCharset whether a charset was explicitly specified.
   * @return the MIME type specified in the header, in lower-case.
   */
  String parseContentType(String aTypeHeader, String[] aCharset, boolean[] aHadCharset);

  /** Escape every character with its %XX-escaped equivalent */
  long ESCAPE_ALL = 0L;

  /** Leave alphanumeric characters intact and %XX-escape all others */
  long ESCAPE_XALPHAS = 1L;

  /** Leave alphanumeric characters intact, convert spaces to '+',
      %XX-escape all others */
  long ESCAPE_XPALPHAS = 2L;

  /** Leave alphanumeric characters and forward slashes intact,
      %XX-escape all others */
  long ESCAPE_URL_PATH = 4L;

  /**
   * escape a string with %00-style escaping
   */
  String escapeString(String aString, long aEscapeType);

  /**
   * unescape a %00-style escaped string
   */
  String unescapeString(String aString);

  /**
   * Test whether the given URI's handler has the given protocol flags.
   *
   * @param aURI the URI in question
   * @param aFlags the flags we're testing for.
   *
   * @return whether the protocol handler for aURI has all the flags
   *         in aFlags.
   */
  boolean protocolHasFlags(nsIURI aURI, long aFlag);

  /**
   * Test whether the protocol handler for this URI or that for any of
   * its inner URIs has the given protocol flags.  This will QI aURI to
   * nsINestedURI and walk the nested URI chain.
   *
   * @param aURI the URI in question
   * @param aFlags the flags we're testing for.
   *
   * @return whether any of the protocol handlers involved have all the flags
   *         in aFlags.
   */
  boolean uRIChainHasFlags(nsIURI aURI, long aFlags);

  /**
   * Take aURI and produce an immutable version of it for the caller.  If aURI
   * is immutable this will be aURI itself; otherwise this will be a clone,
   * marked immutable if possible.  Passing null to this method is allowed; in
   * that case it will return null.
   */
  nsIURI toImmutableURI(nsIURI aURI);

}