/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * /builds/tinderbox/XR-Trunk/Linux_2.6.18-8.el5_Depend/mozilla/netwerk/dns/public/nsIIDNService.idl
 */

package org.mozilla.interfaces;

/**
 * nsIIDNService interface.
 *
 * IDN (Internationalized Domain Name) support. Provides facilities
 * for manipulating IDN hostnames according to the specification set
 * forth by the IETF.
 *
 * IDN effort:
 * http://www.ietf.org/html.characters/idn-charter.html
 * http://www.i-dns.net
 *
 * IDNA specification:
 * http://search.ietf.org/internet-drafts/draft-ietf-idn-idna-06.txt
 */
public interface nsIIDNService extends nsISupports {

  String NS_IIDNSERVICE_IID =
    "{7b67747e-a8c4-4832-80c7-39ebb0c11f94}";

  /**
     * Prepares the input hostname according to IDNA ToASCII operation,
     * the input hostname is assumed to be UTF8-encoded.
     */
  String convertUTF8toACE(String input);

  /**
     * This is the ToUnicode operation as specified in the IDNA proposal,
     * with an additional step to encode the result in UTF-8.
     * It takes an ACE-encoded hostname and performs ToUnicode to it, then
     * encodes the resulting string into UTF8.
     */
  String convertACEtoUTF8(String input);

  /**
     * Checks if the input string is ACE encoded or not.
     */
  boolean isACE(String input);

  /**
     * Performs the unicode normalization needed for hostnames in IDN,
     * for callers that want early normalization.
     */
  String normalize(String input);

}