/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * e:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/xpcom/io/nsIScriptableStreams.idl
 */

package org.mozilla.interfaces;

public interface nsIScriptableIOOutputStream extends nsISupports {

  String NS_ISCRIPTABLEIOOUTPUTSTREAM_IID =
    "{11fae7e6-df5b-4d80-b4c9-61849378364d}";

  /**
   * Called to initialize the stream.
   */
  void initWithStreams(nsIOutputStream aStream, nsIUnicharOutputStream aCharStream);

  /**
   * Write the string aString to the stream. For text streams, the string is
   * written in the expected character set. For other streams, the string is
   * interpreted as bytes, which means that characters above 255 are only
   * written using their low 8 bits.
   *
   * @param aString the string to write
   * @returns true if the entire string was written, false otherwise
   */
  boolean writeString(String aString);

  /**
   * Write a boolean to the stream. If the boolean is false, 0 is written,
   * and if the boolean is true, 1 is written.
   *
   * @param aBoolean the value to write
   */
  void writeBoolean(boolean aBoolean);

  /**
   * Write a single byte to the stream.
   *
   * @param aByte the value to write
   */
  void write8(short aByte);

  /**
   * Write a 16-bit integer to the stream as an unsigned big endian value.
   *
   * @param a16 the value to write
   */
  void write16(int a16);

  /**
   * Write a 32-bit integer to the stream as an unsigned big endian value.
   *
   * @param a32 the value to write
   */
  void write32(long a32);

  /**
   * Write a floating point value to the stream in 4 bytes.
   *
   * @param aFloat the value to write
   */
  void writeFloat(float aFloat);

  /**
   * Write a double floating point value to the stream in 8 bytes.
   *
   * @param aDouble the value to write
   */
  void writeDouble(double aDouble);

  /**
   * Write aCount values from the array aBytes to the stream.
   *
   * @param aBytes the array of write
   * @param aCount the number of bytes to write
   */
  void writeByteArray(byte[] aBytes, long aCount);

}