/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM e:/builds/tinderbox/XR-Trunk/WINNT_5.2_Depend/mozilla/security/manager/ssl/public/nsICertOverrideService.idl
 */

#ifndef __gen_nsICertOverrideService_h__
#define __gen_nsICertOverrideService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIArray; /* forward declaration */

class nsIX509Cert; /* forward declaration */

#define NS_CERTOVERRIDE_CONTRACTID "@mozilla.org/security/certoverride;1"

/* starting interface:    nsICertOverrideService */
#define NS_ICERTOVERRIDESERVICE_IID_STR "7e646227-485d-49c6-8e37-e2c62cb204e1"

#define NS_ICERTOVERRIDESERVICE_IID \
  {0x7e646227, 0x485d, 0x49c6, \
    { 0x8e, 0x37, 0xe2, 0xc6, 0x2c, 0xb2, 0x04, 0xe1 }}

/**
 * This represents the global list of triples
 *   {host:port, cert-fingerprint, allowed-overrides} 
 * that the user wants to accept without further warnings. 
 */
class NS_NO_VTABLE nsICertOverrideService : public nsISupports {
 public: 

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ICERTOVERRIDESERVICE_IID)

  /**
   *  Override Untrusted
   */
  enum { ERROR_UNTRUSTED = 1 };

  /**
   *  Override hostname Mismatch
   */
  enum { ERROR_MISMATCH = 2 };

  /**
   *  Override Time error
   */
  enum { ERROR_TIME = 4 };

  /**
   *  The given cert should always be accepted for the given hostname:port,
   *  regardless of errors verifying the cert.
   *  Host:Port is a primary key, only one entry per host:port can exist.
   *  The implementation will store a fingerprint of the cert.
   *  The implementation will decide which fingerprint alg is used.
   *
   *  @param aHostNameWithPort The host:port this mapping belongs to
   *  @param aCert The cert that should always be accepted
   *  @param aOverrideBits The errors we want to be overriden
   */
  /* void rememberValidityOverride (in AString aHostNameWithPort, in nsIX509Cert aCert, in PRUint32 aOverrideBits); */
  NS_IMETHOD RememberValidityOverride(const nsAString & aHostNameWithPort, nsIX509Cert *aCert, PRUint32 aOverrideBits) = 0;

  /**
   *  The given cert should always be accepted for the given hostname:port,
   *  regardless of errors verifying the cert.
   *  Host:Port is a primary key, only one entry per host:port can exist.
   *  The implementation will store a fingerprint of the cert.
   *  The implementation will decide which fingerprint alg is used.
   *
   *  @param aHostNameWithPort The host:port this mapping belongs to
   *  @param aCert The cert that should always be accepted
   *  @param aOverrideBits The errors that are currently overriden
   *  @return whether an override entry for aHostNameWithPort is currently on file
   *          that matches the given certificate
   */
  /* boolean hasMatchingOverride (in AString aHostNameWithPort, in nsIX509Cert aCert, out PRUint32 aOverrideBits); */
  NS_IMETHOD HasMatchingOverride(const nsAString & aHostNameWithPort, nsIX509Cert *aCert, PRUint32 *aOverrideBits, PRBool *_retval) = 0;

  /**
   *  Retrieve the stored override for the given hostname:port.
   *
   *  @param aHostNameWithPort The host:port whose entry should be tested
   *  @param aHashAlg On return value True, the fingerprint hash algorithm
   *                  as an OID value in dotted notation.
   *  @param aFingerprint On return value True, the stored fingerprint 
   *  @param aOverrideBits The errors that are currently overriden
   *  @return whether a matching override entry for aHostNameWithPort 
   *          and aFingerprint is currently on file
   */
  /* boolean getValidityOverride (in AString aHostNameWithPort, out ACString aHashAlg, out ACString aFingerprint, out PRUint32 aOverrideBits); */
  NS_IMETHOD GetValidityOverride(const nsAString & aHostNameWithPort, nsACString & aHashAlg, nsACString & aFingerprint, PRUint32 *aOverrideBits, PRBool *_retval) = 0;

  /**
   *  Remove a stored override for the given hostname:port.
   *
   *  @param aHostNameWithPort The host:port whose entry should be cleared.
   */
  /* void clearValidityOverride (in AString aHostNameWithPort); */
  NS_IMETHOD ClearValidityOverride(const nsAString & aHostNameWithPort) = 0;

  /**
   *  Obtain the full list of hostname:port for which overrides are stored.
   *
   *  @param aCount The number of host:port entries returned
   *  @param aHostsWithPortsArray The array of host:port entries returned
   */
  /* void getAllOverrideHostsWithPorts (out PRUint32 aCount, [array, size_is (aCount)] out wstring aHostsWithPortsArray); */
  NS_IMETHOD GetAllOverrideHostsWithPorts(PRUint32 *aCount, PRUnichar ***aHostsWithPortsArray) = 0;

  /**
   *  Is the given cert used in rules?
   *
   *  @param aCert The cert we're looking for
   *  @return how many override entries are currently on file
   *          for the given certificate
   */
  /* PRUint32 isCertUsedForOverrides (in nsIX509Cert aCert); */
  NS_IMETHOD IsCertUsedForOverrides(nsIX509Cert *aCert, PRUint32 *_retval) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsICertOverrideService, NS_ICERTOVERRIDESERVICE_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSICERTOVERRIDESERVICE \
  NS_IMETHOD RememberValidityOverride(const nsAString & aHostNameWithPort, nsIX509Cert *aCert, PRUint32 aOverrideBits); \
  NS_IMETHOD HasMatchingOverride(const nsAString & aHostNameWithPort, nsIX509Cert *aCert, PRUint32 *aOverrideBits, PRBool *_retval); \
  NS_IMETHOD GetValidityOverride(const nsAString & aHostNameWithPort, nsACString & aHashAlg, nsACString & aFingerprint, PRUint32 *aOverrideBits, PRBool *_retval); \
  NS_IMETHOD ClearValidityOverride(const nsAString & aHostNameWithPort); \
  NS_IMETHOD GetAllOverrideHostsWithPorts(PRUint32 *aCount, PRUnichar ***aHostsWithPortsArray); \
  NS_IMETHOD IsCertUsedForOverrides(nsIX509Cert *aCert, PRUint32 *_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSICERTOVERRIDESERVICE(_to) \
  NS_IMETHOD RememberValidityOverride(const nsAString & aHostNameWithPort, nsIX509Cert *aCert, PRUint32 aOverrideBits) { return _to RememberValidityOverride(aHostNameWithPort, aCert, aOverrideBits); } \
  NS_IMETHOD HasMatchingOverride(const nsAString & aHostNameWithPort, nsIX509Cert *aCert, PRUint32 *aOverrideBits, PRBool *_retval) { return _to HasMatchingOverride(aHostNameWithPort, aCert, aOverrideBits, _retval); } \
  NS_IMETHOD GetValidityOverride(const nsAString & aHostNameWithPort, nsACString & aHashAlg, nsACString & aFingerprint, PRUint32 *aOverrideBits, PRBool *_retval) { return _to GetValidityOverride(aHostNameWithPort, aHashAlg, aFingerprint, aOverrideBits, _retval); } \
  NS_IMETHOD ClearValidityOverride(const nsAString & aHostNameWithPort) { return _to ClearValidityOverride(aHostNameWithPort); } \
  NS_IMETHOD GetAllOverrideHostsWithPorts(PRUint32 *aCount, PRUnichar ***aHostsWithPortsArray) { return _to GetAllOverrideHostsWithPorts(aCount, aHostsWithPortsArray); } \
  NS_IMETHOD IsCertUsedForOverrides(nsIX509Cert *aCert, PRUint32 *_retval) { return _to IsCertUsedForOverrides(aCert, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSICERTOVERRIDESERVICE(_to) \
  NS_IMETHOD RememberValidityOverride(const nsAString & aHostNameWithPort, nsIX509Cert *aCert, PRUint32 aOverrideBits) { return !_to ? NS_ERROR_NULL_POINTER : _to->RememberValidityOverride(aHostNameWithPort, aCert, aOverrideBits); } \
  NS_IMETHOD HasMatchingOverride(const nsAString & aHostNameWithPort, nsIX509Cert *aCert, PRUint32 *aOverrideBits, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->HasMatchingOverride(aHostNameWithPort, aCert, aOverrideBits, _retval); } \
  NS_IMETHOD GetValidityOverride(const nsAString & aHostNameWithPort, nsACString & aHashAlg, nsACString & aFingerprint, PRUint32 *aOverrideBits, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetValidityOverride(aHostNameWithPort, aHashAlg, aFingerprint, aOverrideBits, _retval); } \
  NS_IMETHOD ClearValidityOverride(const nsAString & aHostNameWithPort) { return !_to ? NS_ERROR_NULL_POINTER : _to->ClearValidityOverride(aHostNameWithPort); } \
  NS_IMETHOD GetAllOverrideHostsWithPorts(PRUint32 *aCount, PRUnichar ***aHostsWithPortsArray) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllOverrideHostsWithPorts(aCount, aHostsWithPortsArray); } \
  NS_IMETHOD IsCertUsedForOverrides(nsIX509Cert *aCert, PRUint32 *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsCertUsedForOverrides(aCert, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsCertOverrideService : public nsICertOverrideService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSICERTOVERRIDESERVICE

  nsCertOverrideService();

private:
  ~nsCertOverrideService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsCertOverrideService, nsICertOverrideService)

nsCertOverrideService::nsCertOverrideService()
{
  /* member initializers and constructor code */
}

nsCertOverrideService::~nsCertOverrideService()
{
  /* destructor code */
}

/* void rememberValidityOverride (in AString aHostNameWithPort, in nsIX509Cert aCert, in PRUint32 aOverrideBits); */
NS_IMETHODIMP nsCertOverrideService::RememberValidityOverride(const nsAString & aHostNameWithPort, nsIX509Cert *aCert, PRUint32 aOverrideBits)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean hasMatchingOverride (in AString aHostNameWithPort, in nsIX509Cert aCert, out PRUint32 aOverrideBits); */
NS_IMETHODIMP nsCertOverrideService::HasMatchingOverride(const nsAString & aHostNameWithPort, nsIX509Cert *aCert, PRUint32 *aOverrideBits, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean getValidityOverride (in AString aHostNameWithPort, out ACString aHashAlg, out ACString aFingerprint, out PRUint32 aOverrideBits); */
NS_IMETHODIMP nsCertOverrideService::GetValidityOverride(const nsAString & aHostNameWithPort, nsACString & aHashAlg, nsACString & aFingerprint, PRUint32 *aOverrideBits, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void clearValidityOverride (in AString aHostNameWithPort); */
NS_IMETHODIMP nsCertOverrideService::ClearValidityOverride(const nsAString & aHostNameWithPort)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void getAllOverrideHostsWithPorts (out PRUint32 aCount, [array, size_is (aCount)] out wstring aHostsWithPortsArray); */
NS_IMETHODIMP nsCertOverrideService::GetAllOverrideHostsWithPorts(PRUint32 *aCount, PRUnichar ***aHostsWithPortsArray)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* PRUint32 isCertUsedForOverrides (in nsIX509Cert aCert); */
NS_IMETHODIMP nsCertOverrideService::IsCertUsedForOverrides(nsIX509Cert *aCert, PRUint32 *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsICertOverrideService_h__ */
