/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * nsIAccessibleEvent.idl
 */

package org.mozilla.interfaces;

/**
 * An interface for accessibility events listened to
 * by in-process accessibility clients, which can be used
 * to find out how to get accessibility and DOM interfaces for
 * the event and its target. To listen to in-process accessibility invents,
 * make your object an nsIObserver, and listen for accessible-event by 
 * using code something like this:
 *   nsCOMPtr<nsIObserverService> observerService = 
 *     do_GetService("@mozilla.org/observer-service;1", &rv);
 *   if (NS_SUCCEEDED(rv)) 
 *     rv = observerService->AddObserver(this, "accessible-event", PR_TRUE);
 *
 * @status UNDER_REVIEW
 */
public interface nsIAccessibleEvent extends nsISupports {

  String NS_IACCESSIBLEEVENT_IID =
    "{87f29033-c4a6-40a3-ac7a-3ba391f9992d}";

  /**
   * The type of event, based on the enumerated event values
   * defined in this interface.
   */
  long getEventType();

  /**
   * The nsIAccessible associated with the event.
   * May return null if no accessible is available
   */
  nsIAccessible getAccessible();

  /**
   * The nsIAccessibleDocument that the event target nsIAccessible
   * resides in. This can be used to get the DOM window,
   * the DOM document and the window handler, among other things.
   */
  nsIAccessibleDocument getAccessibleDocument();

  /**
   * The nsIDOMNode associated with the event
   * May return null if accessible for event has been shut down
   */
  nsIDOMNode getDOMNode();

  long EVENT_CREATE = 32768L;

  long EVENT_DESTROY = 32769L;

  long EVENT_SHOW = 32770L;

  long EVENT_HIDE = 32771L;

  long EVENT_REORDER = 32772L;

  long EVENT_FOCUS = 32773L;

  long EVENT_STATE_CHANGE = 32778L;

  long EVENT_LOCATION_CHANGE = 32779L;

  long EVENT_NAME_CHANGE = 32780L;

  long EVENT_DESCRIPTIONCHANGE = 32781L;

  long EVENT_VALUE_CHANGE = 32782L;

  long EVENT_PARENTCHANGE = 32783L;

  long EVENT_HELPCHANGE = 32784L;

  long EVENT_DEFACTIONCHANGE = 32785L;

  long EVENT_ACCELERATORCHANGE = 32786L;

  long EVENT_SELECTION = 32774L;

  long EVENT_SELECTION_ADD = 32775L;

  long EVENT_SELECTION_REMOVE = 32776L;

  long EVENT_SELECTION_WITHIN = 32777L;

  long EVENT_ALERT = 2L;

  long EVENT_FOREGROUND = 3L;

  long EVENT_MENUSTART = 4L;

  long EVENT_MENUEND = 5L;

  long EVENT_MENUPOPUPSTART = 6L;

  long EVENT_MENUPOPUPEND = 7L;

  long EVENT_CAPTURESTART = 8L;

  long EVENT_CAPTUREEND = 9L;

  long EVENT_MOVESIZESTART = 10L;

  long EVENT_MOVESIZEEND = 11L;

  long EVENT_CONTEXTHELPSTART = 12L;

  long EVENT_CONTEXTHELPEND = 13L;

  long EVENT_DRAGDROPSTART = 14L;

  long EVENT_DRAGDROPEND = 15L;

  long EVENT_DIALOGSTART = 16L;

  long EVENT_DIALOGEND = 17L;

  long EVENT_SCROLLINGSTART = 18L;

  long EVENT_SCROLLINGEND = 19L;

  long EVENT_MINIMIZESTART = 22L;

  long EVENT_MINIMIZEEND = 23L;

  long EVENT_ATK_PROPERTY_CHANGE = 256L;

  long EVENT_ATK_SELECTION_CHANGE = 257L;

  long EVENT_ATK_TEXT_CHANGE = 258L;

  long EVENT_ATK_TEXT_SELECTION_CHANGE = 259L;

  long EVENT_ATK_TEXT_CARET_MOVE = 260L;

  long EVENT_ATK_VISIBLE_DATA_CHANGE = 261L;

  long EVENT_ATK_TABLE_MODEL_CHANGE = 272L;

  long EVENT_ATK_TABLE_ROW_INSERT = 273L;

  long EVENT_ATK_TABLE_ROW_DELETE = 274L;

  long EVENT_ATK_TABLE_ROW_REORDER = 275L;

  long EVENT_ATK_TABLE_COLUMN_INSERT = 276L;

  long EVENT_ATK_TABLE_COLUMN_DELETE = 277L;

  long EVENT_ATK_TABLE_COLUMN_REORDER = 278L;

  long EVENT_ATK_LINK_SELECTED = 279L;

  long EVENT_ATK_WINDOW_ACTIVATE = 280L;

  long EVENT_ATK_WINDOW_CREATE = 281L;

  long EVENT_ATK_WINDOW_DEACTIVATE = 288L;

  long EVENT_ATK_WINDOW_DESTROY = 289L;

  long EVENT_ATK_WINDOW_MAXIMIZE = 290L;

  long EVENT_ATK_WINDOW_MINIMIZE = 291L;

  long EVENT_ATK_WINDOW_RESIZE = 292L;

  long EVENT_ATK_WINDOW_RESTORE = 293L;

}