/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM
 * e:/builds/moz2_slave/mozilla-central-win32-xulrunner/build/editor/idl/nsIEditorStyleSheets.idl
 */

package org.mozilla.interfaces;

public interface nsIEditorStyleSheets extends nsISupports {

  String NS_IEDITORSTYLESHEETS_IID =
    "{4805e682-49b9-11d3-9ce4-ed60bd6cb5bc}";

  /** Load and apply the style sheet, specified by aURL, to the
    * editor's document, replacing the last style sheet added (if any).
    * This is always asynchronous, and may cause network I/O.
    * 
    * @param aURL The style sheet to be loaded and applied.
    */
  void replaceStyleSheet(String aURL);

  /** Add the given style sheet to the editor's document,
    * on top of any that are already there.
    * This is always asynchronous, and may cause network I/O.
    *
    * @param aURL The style sheet to be loaded and applied.
    */
  void addStyleSheet(String aURL);

  /** Load and apply the override style sheet, specified by aURL, to the
    * editor's document, replacing the last override style sheet added (if any).
    * This is always synchronous, so aURL should be a local file with only
    * local @imports. This action is not undoable. It is not intended for
    * "user" style sheets, only for editor developers to add sheets to change
    * display behavior for editing (like showing special cursors) that will
    * not be affected by loading "document" style sheets with addStyleSheet or
    * especially replaceStyleSheet.
    * 
    * @param aURL The style sheet to be loaded and applied.
    */
  void replaceOverrideStyleSheet(String aURL);

  /** Load and apply an override style sheet, specified by aURL, to
    * the editor's document, on top of any that are already there.
    * This is always synchronous, so the same caveats about local files and no
    * non-local @import as replaceOverrideStyleSheet apply here, too.
    *
    * @param aURL The style sheet to be loaded and applied.
    */
  void addOverrideStyleSheet(String aURL);

  /** Remove the given style sheet from the editor's document
    * This is always synchronous
    *
    * @param aURL The style sheet to be removed
    */
  void removeStyleSheet(String aURL);

  /** Remove the given override style sheet from the editor's document
    * This is always synchronous
    *
    * @param aURL The style sheet to be removed.
    */
  void removeOverrideStyleSheet(String aURL);

  /** Enable or disable the given style sheet from the editor's document
    * This is always synchronous
    *
    * @param aURL  The style sheet to be enabled or disabled
    * @param aEnable true to enable, or false to disable the style sheet
    */
  void enableStyleSheet(String aURL, boolean aEnable);

}