/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_WebComponentsBinding_h__
#define mozilla_dom_WebComponentsBinding_h__

#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"

class XPCWrappedNativeScope;
namespace mozilla {
namespace dom {

class LifecycleCreatedCallback;

} // namespace dom
} // namespace mozilla


namespace mozilla {
namespace dom {

struct LifecycleCallbacks : public MainThreadDictionaryBase {
  LifecycleCallbacks() {}
  bool Init(JSContext* cx, JSObject* scopeObj, const JS::Value& val);
  bool ToObject(JSContext* cx, JSObject* parentObject, JS::Value *vp);

  bool Init(const nsAString& aJSON)
  {
    mozilla::Maybe<JSAutoRequest> ar;
    mozilla::Maybe<JSAutoCompartment> ac;
    jsval json = JSVAL_VOID;
    JSContext* cx = ParseJSON(aJSON, ar, ac, json);
    NS_ENSURE_TRUE(cx, false);
    return Init(cx, nullptr, json);
  }
  LifecycleCallbacks& AsMutable() const
  {
    return *const_cast<LifecycleCallbacks*>(this);
  }

  nsRefPtr<LifecycleCreatedCallback> mCreated;
private:
  // Disallow copy-construction
  LifecycleCallbacks(const LifecycleCallbacks&) MOZ_DELETE;
  static bool InitIds(JSContext* cx);
  static bool initedIds;
  static jsid created_id;
};
struct LifecycleCallbacksInitializer : public LifecycleCallbacks {
  LifecycleCallbacksInitializer() {
    // Safe to pass a null context if we pass a null value
    Init(nullptr, nullptr, JS::NullValue());
  }
};

struct ElementRegistrationOptions : public MainThreadDictionaryBase {
  ElementRegistrationOptions() {}
  bool Init(JSContext* cx, JSObject* scopeObj, const JS::Value& val);
  bool ToObject(JSContext* cx, JSObject* parentObject, JS::Value *vp);

  bool Init(const nsAString& aJSON)
  {
    mozilla::Maybe<JSAutoRequest> ar;
    mozilla::Maybe<JSAutoCompartment> ac;
    jsval json = JSVAL_VOID;
    JSContext* cx = ParseJSON(aJSON, ar, ac, json);
    NS_ENSURE_TRUE(cx, false);
    return Init(cx, nullptr, json);
  }
  ElementRegistrationOptions& AsMutable() const
  {
    return *const_cast<ElementRegistrationOptions*>(this);
  }

  LifecycleCallbacks mLifecycle;
  LazyRootedObject mPrototype;
private:
  // Disallow copy-construction
  ElementRegistrationOptions(const ElementRegistrationOptions&) MOZ_DELETE;
  static bool InitIds(JSContext* cx);
  static bool initedIds;
  static jsid lifecycle_id;
  static jsid prototype_id;
};
struct ElementRegistrationOptionsInitializer : public ElementRegistrationOptions {
  ElementRegistrationOptionsInitializer() {
    // Safe to pass a null context if we pass a null value
    Init(nullptr, nullptr, JS::NullValue());
  }
};

class LifecycleCreatedCallback : public CallbackFunction
{
public:
  inline LifecycleCreatedCallback(JSContext* cx, JSObject* aOwner, JSObject* aCallback, bool* aInited)
    : CallbackFunction(cx, aOwner, aCallback, aInited)
  {
  }

  explicit inline LifecycleCreatedCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  inline void
  Call(const T& thisObj, ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(mCallback, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    JSObject* thisObjJS = WrapCallThisObject(s.GetContext(), mCallback, thisObj);
    if (!thisObjJS) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetContext(), thisObjJS, aRv);
  }

  inline void
  Call(ErrorResult& aRv, ExceptionHandling aExceptionHandling = eReportExceptions)
  {
    CallSetup s(mCallback, aRv, aExceptionHandling);
    if (!s.GetContext()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    return Call(s.GetContext(), nullptr, aRv);
  }

private:
  void Call(JSContext* cx, JSObject* aThisObj, ErrorResult& aRv);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_WebComponentsBinding_h__
