/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_ContactsBinding_h__
#define mozilla_dom_ContactsBinding_h__

#include "ContactsBinding.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "jspubtd.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CallbackInterface.h"
#include "mozilla/dom/Date.h"
#include "mozilla/dom/Nullable.h"
#include "nsDOMEventTargetHelper.h"
#include "nsIDOMFile.h"
#include "nsWeakReference.h"

class JSObject;
class nsIDOMBlob;

namespace mozilla {
namespace dom {

class ContactAddress;
struct ContactAddressInit;
struct ContactAddressInitAtoms;
class ContactField;
struct ContactFieldInit;
struct ContactFieldInitAtoms;
struct ContactFindOptions;
struct ContactFindOptionsAtoms;
struct ContactFindSortOptions;
struct ContactFindSortOptionsAtoms;
class ContactManager;
struct ContactProperties;
struct ContactPropertiesAtoms;
class ContactTelField;
struct ContactTelFieldInit;
struct ContactTelFieldInitAtoms;
class DOMCursor;
class DOMRequest;
class EventHandlerNonNull;
class NativePropertyHooks;
class ProtoAndIfaceArray;
class mozContact;

} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {

struct ContactAddressInit : public MainThreadDictionaryBase
{
  Optional<nsString > mCountryName;
  Optional<nsString > mLocality;
  Optional<nsString > mPostalCode;
  Optional<Nullable<bool> > mPref;
  Optional<nsString > mRegion;
  Optional<nsString > mStreetAddress;
  Optional<Nullable<Sequence<nsString > > > mType;

  ContactAddressInit();

  explicit inline ContactAddressInit(const ContactAddressInit& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ContactAddressInit(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ContactAddressInitAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ContactAddressInit& aOther);
};

namespace dictionary_detail {
struct FastContactAddressInit : public ContactAddressInit
{
  inline FastContactAddressInit()
    : ContactAddressInit(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


struct ContactFieldInit : public MainThreadDictionaryBase
{
  Optional<Nullable<bool> > mPref;
  Optional<Nullable<Sequence<nsString > > > mType;
  Optional<nsString > mValue;

  ContactFieldInit();

  explicit inline ContactFieldInit(const ContactFieldInit& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ContactFieldInit(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ContactFieldInitAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ContactFieldInit& aOther);
};

namespace dictionary_detail {
struct FastContactFieldInit : public ContactFieldInit
{
  inline FastContactFieldInit()
    : ContactFieldInit(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


struct ContactFindSortOptions : public MainThreadDictionaryBase
{
  Optional<nsString > mSortBy;
  nsString mSortOrder;

  ContactFindSortOptions();

  explicit inline ContactFindSortOptions(const ContactFindSortOptions& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ContactFindSortOptions(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ContactFindSortOptionsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ContactFindSortOptions& aOther);
};

namespace dictionary_detail {
struct FastContactFindSortOptions : public ContactFindSortOptions
{
  inline FastContactFindSortOptions()
    : ContactFindSortOptions(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


struct ContactFindOptions : public ContactFindSortOptions
{
  Optional<JS::Value > mFilterBy;
  uint32_t mFilterLimit;
  Optional<nsString > mFilterOp;
  Optional<nsString > mFilterValue;

  ContactFindOptions();

protected:
  explicit inline ContactFindOptions(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  ContactFindOptions(const ContactFindOptions&) MOZ_DELETE;
  void operator=(const ContactFindOptions) MOZ_DELETE;

  static bool
  InitIds(JSContext* cx, ContactFindOptionsAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace dictionary_detail {
struct FastContactFindOptions : public ContactFindOptions
{
  inline FastContactFindOptions()
    : ContactFindOptions(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


struct ContactTelFieldInit : public ContactFieldInit
{
  Optional<nsString > mCarrier;

  ContactTelFieldInit();

  explicit inline ContactTelFieldInit(const ContactTelFieldInit& aOther)
  {
    *this = aOther;
  }

protected:
  explicit inline ContactTelFieldInit(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  static bool
  InitIds(JSContext* cx, ContactTelFieldInitAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  void
  operator=(const ContactTelFieldInit& aOther);
};

namespace dictionary_detail {
struct FastContactTelFieldInit : public ContactTelFieldInit
{
  inline FastContactTelFieldInit()
    : ContactTelFieldInit(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


struct ContactProperties : public MainThreadDictionaryBase
{
  Optional<Nullable<Sequence<nsString > > > mAdditionalName;
  Optional<Nullable<Sequence<ContactAddressInit > > > mAdr;
  Optional<Nullable<Date > > mAnniversary;
  Optional<Nullable<Date > > mBday;
  Optional<Nullable<Sequence<nsString > > > mCategory;
  Optional<Nullable<Sequence<ContactFieldInit > > > mEmail;
  Optional<Nullable<Sequence<nsString > > > mFamilyName;
  Optional<nsString > mGenderIdentity;
  Optional<Nullable<Sequence<nsString > > > mGivenName;
  Optional<Nullable<Sequence<nsString > > > mHonorificPrefix;
  Optional<Nullable<Sequence<nsString > > > mHonorificSuffix;
  Optional<Nullable<Sequence<ContactFieldInit > > > mImpp;
  Optional<Nullable<Sequence<nsString > > > mJobTitle;
  Optional<Nullable<Sequence<nsString > > > mKey;
  Optional<Nullable<Sequence<nsString > > > mName;
  Optional<Nullable<Sequence<nsString > > > mNickname;
  Optional<Nullable<Sequence<nsString > > > mNote;
  Optional<Nullable<Sequence<nsString > > > mOrg;
  Optional<Nullable<Sequence<nsRefPtr<nsIDOMBlob> > > > mPhoto;
  Optional<nsString > mSex;
  Optional<Nullable<Sequence<ContactTelFieldInit > > > mTel;
  Optional<Nullable<Sequence<ContactFieldInit > > > mUrl;

  ContactProperties();

protected:
  explicit inline ContactProperties(int )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

private:
  ContactProperties(const ContactProperties&) MOZ_DELETE;
  void operator=(const ContactProperties) MOZ_DELETE;

  static bool
  InitIds(JSContext* cx, ContactPropertiesAtoms* atomsCache);

public:
  bool
  Init(JSContext* cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value");

  bool
  Init(const nsAString& aJSON);

  bool
  ToObject(JSContext* cx, JS::Handle<JSObject*> parentObject, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);
};

namespace dictionary_detail {
struct FastContactProperties : public ContactProperties
{
  inline FastContactProperties()
    : ContactProperties(42)
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace dictionary_detail


namespace ContactAddressBinding {

  typedef mozilla::dom::ContactAddress NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::ContactAddress* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceArray& aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace ContactAddressBinding



namespace ContactFieldBinding {

  typedef mozilla::dom::ContactField NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::ContactField* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceArray& aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace ContactFieldBinding



namespace ContactManagerBinding {

  typedef mozilla::dom::ContactManager NativeType;

  JSObject*
  ConstructNavigatorObject(JSContext* aCx, JS::Handle<JSObject*> aObj);

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::ContactManager* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceArray& aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

} // namespace ContactManagerBinding



namespace ContactTelFieldBinding {

  typedef mozilla::dom::ContactTelField NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::ContactTelField* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceArray& aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace ContactTelFieldBinding



namespace mozContactBinding {

  typedef mozilla::dom::mozContact NativeType;

  // We declare this as an array so that retrieving a pointer to this
  // binding's property hooks only requires compile/link-time resolvable
  // address arithmetic.  Declaring it as a pointer instead would require
  // doing a run-time load to fetch a pointer to this binding's property
  // hooks.  And then structures which embedded a pointer to this structure
  // would require a run-time load for proper initialization, which would
  // then induce static constructors.  Lots of static constructors.
  extern const NativePropertyHooks sNativePropertyHooks[];
  JSObject*
  DefineDOMInterface(JSContext* aCx, JS::Handle<JSObject*> aGlobal, JS::Handle<jsid> id, bool aDefineOnGlobal);

  const JSClass*
  GetJSClass();

  JSObject*
  Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, mozilla::dom::mozContact* aObject, nsWrapperCache* aCache);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, JS::Handle<JSObject*> aScope, T* aObject)
  {
    return Wrap(aCx, aScope, aObject, aObject);
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceArray& aProtoAndIfaceArray, bool aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal);

  JS::Handle<JSObject*>
  GetConstructorObject(JSContext* aCx, JS::Handle<JSObject*> aGlobal, bool aDefineOnGlobal = true);

} // namespace mozContactBinding



class ContactAddressJSImpl : public CallbackInterface
{
public:
  explicit inline ContactAddressJSImpl(JSObject* aCallback)
    : CallbackInterface(aCallback)
  {
  }

  void Initialize(const Optional<Nullable<Sequence<nsString > > >& type, const Optional<nsAString >& streetAddress, const Optional<nsAString >& locality, const Optional<nsAString >& region, const Optional<nsAString >& postalCode, const Optional<nsAString >& countryName, const Optional<Nullable<bool > >& pref, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* ToJSON(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void __Init(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetStreetAddress(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetLocality(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRegion(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetPostalCode(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetCountryName(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<bool > GetPref(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetType(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetStreetAddress(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetLocality(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetRegion(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetPostalCode(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetCountryName(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetPref(const Nullable<bool >& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
};


class ContactAddress MOZ_FINAL : public nsSupportsWeakReference,
                                 public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(ContactAddress)

private:
  nsRefPtr<ContactAddressJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  ContactAddress(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  static already_AddRefed<ContactAddress> Constructor(const GlobalObject& global, JSContext* cx, ErrorResult& aRv);

  JSObject* GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetType(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetStreetAddress(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetStreetAddress(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetLocality(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetLocality(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetRegion(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetRegion(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetPostalCode(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetPostalCode(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetCountryName(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetCountryName(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<bool > GetPref(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetPref(const Nullable<bool >& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Initialize(const Optional<Nullable<Sequence<nsString > > >& type, const Optional<nsAString >& streetAddress, const Optional<nsAString >& locality, const Optional<nsAString >& region, const Optional<nsAString >& postalCode, const Optional<nsAString >& countryName, const Optional<Nullable<bool > >& pref, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* ToJSON(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class ContactFieldJSImpl : public CallbackInterface
{
public:
  explicit inline ContactFieldJSImpl(JSObject* aCallback)
    : CallbackInterface(aCallback)
  {
  }

  void Initialize(const Optional<Nullable<Sequence<nsString > > >& type, const Optional<nsAString >& value, const Optional<Nullable<bool > >& pref, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* ToJSON(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void __Init(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetValue(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<bool > GetPref(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetType(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetValue(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetPref(const Nullable<bool >& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
};


class ContactField : public nsSupportsWeakReference,
                     public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(ContactField)

private:
  nsRefPtr<ContactFieldJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  ContactField(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  virtual ~ContactField();

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  static already_AddRefed<ContactField> Constructor(const GlobalObject& global, JSContext* cx, ErrorResult& aRv);

  JSObject* GetType(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetType(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetValue(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetValue(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<bool > GetPref(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetPref(const Nullable<bool >& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Initialize(const Optional<Nullable<Sequence<nsString > > >& type, const Optional<nsAString >& value, const Optional<Nullable<bool > >& pref, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* ToJSON(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class ContactManagerJSImpl : public CallbackInterface
{
public:
  explicit inline ContactManagerJSImpl(JSObject* aCallback)
    : CallbackInterface(aCallback)
  {
  }

  already_AddRefed<DOMRequest> Find(const ContactFindOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMCursor> GetAll(const ContactFindSortOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> Clear(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> Save(mozilla::dom::mozContact& contact, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> Remove(mozilla::dom::mozContact& contact, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetRevision(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<DOMRequest> GetCount(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOncontactchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOncontactchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
};


class ContactManager MOZ_FINAL : public nsDOMEventTargetHelper
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(ContactManager, nsDOMEventTargetHelper)

private:
  nsRefPtr<ContactManagerJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  ContactManager(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DOMRequest> Find(const ContactFindOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DOMCursor> GetAll(const ContactFindSortOptions& options, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DOMRequest> Clear(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DOMRequest> Save(mozilla::dom::mozContact& contact, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DOMRequest> Remove(mozilla::dom::mozContact& contact, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DOMRequest> GetRevision(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  // Mark this as resultNotAddRefed to return raw pointers
  already_AddRefed<DOMRequest> GetCount(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  already_AddRefed<EventHandlerNonNull> GetOncontactchange(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOncontactchange(EventHandlerNonNull* arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class mozContactJSImpl : public CallbackInterface
{
public:
  explicit inline mozContactJSImpl(JSObject* aCallback)
    : CallbackInterface(aCallback)
  {
  }

  void SetMetadata(const nsAString& id, const Nullable<Date >& published, const Nullable<Date >& updated, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* ToJSON(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void __Init(const ContactProperties& properties, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetId(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<Date > GetPublished(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<Date > GetUpdated(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<Date > GetBday(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<Date > GetAnniversary(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetSex(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetGenderIdentity(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetPhoto(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetAdr(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetEmail(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetUrl(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetImpp(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetTel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetName(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetHonorificPrefix(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetGivenName(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetAdditionalName(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetFamilyName(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetHonorificSuffix(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetNickname(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetCategory(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetOrg(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetJobTitle(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetNote(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetKey(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetId(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetBday(const Nullable<Date >& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetAnniversary(const Nullable<Date >& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetSex(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetGenderIdentity(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetPhoto(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetAdr(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetEmail(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetUrl(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetImpp(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetTel(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetName(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetHonorificPrefix(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetGivenName(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetAdditionalName(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetFamilyName(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetHonorificSuffix(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetNickname(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetCategory(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetOrg(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetJobTitle(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetNote(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetKey(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
};


class mozContact MOZ_FINAL : public nsSupportsWeakReference,
                             public nsWrapperCache
{
public:
  NS_DECL_CYCLE_COLLECTING_ISUPPORTS
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS(mozContact)

private:
  nsRefPtr<mozContactJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  mozContact(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  static already_AddRefed<mozContact> Constructor(const GlobalObject& global, JSContext* cx, const ContactProperties& properties, ErrorResult& aRv);

  void GetId(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetId(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<Date > GetPublished(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  Nullable<Date > GetUpdated(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  Nullable<Date > GetBday(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetBday(const Nullable<Date >& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  Nullable<Date > GetAnniversary(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetAnniversary(const Nullable<Date >& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetSex(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetSex(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetGenderIdentity(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetGenderIdentity(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetPhoto(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetPhoto(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetAdr(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetAdr(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetEmail(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetEmail(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetUrl(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetUrl(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetImpp(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetImpp(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetTel(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetTel(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetName(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetName(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetHonorificPrefix(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetHonorificPrefix(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetGivenName(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetGivenName(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetAdditionalName(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetAdditionalName(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetFamilyName(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetFamilyName(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetHonorificSuffix(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetHonorificSuffix(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetNickname(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetNickname(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetCategory(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetCategory(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetOrg(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetOrg(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetJobTitle(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetJobTitle(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetNote(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetNote(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* GetKey(ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetKey(JS::Handle<JSObject*> arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetMetadata(const nsAString& id, const Nullable<Date >& published, const Nullable<Date >& updated, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* ToJSON(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


class ContactTelFieldJSImpl : public CallbackInterface
{
public:
  explicit inline ContactTelFieldJSImpl(JSObject* aCallback)
    : CallbackInterface(aCallback)
  {
  }

  void Initialize(const Optional<Nullable<Sequence<nsString > > >& type, const Optional<nsAString >& value, const Optional<nsAString >& carrier, const Optional<Nullable<bool > >& pref, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* ToJSON(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void __Init(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void GetCarrier(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void SetCarrier(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);
};


class ContactTelField MOZ_FINAL : public mozilla::dom::ContactField
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_CLASS_INHERITED(ContactTelField, mozilla::dom::ContactField)

private:
  nsRefPtr<ContactTelFieldJSImpl> mImpl;
  nsCOMPtr<nsISupports> mParent;

public:
  ContactTelField(JS::Handle<JSObject*> aJSImplObject, nsPIDOMWindow* aParent);

  nsISupports* GetParentObject() const;

  virtual JSObject* WrapObject(JSContext* aCx, JS::Handle<JSObject*> aScope) MOZ_OVERRIDE;

  static already_AddRefed<ContactTelField> Constructor(const GlobalObject& global, JSContext* cx, ErrorResult& aRv);

  void GetCarrier(nsString& retval, ErrorResult& aRv, JSCompartment* aCompartment = nullptr) const;

  void SetCarrier(const nsAString& arg, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  void Initialize(const Optional<Nullable<Sequence<nsString > > >& type, const Optional<nsAString >& value, const Optional<nsAString >& carrier, const Optional<Nullable<bool > >& pref, ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  JSObject* ToJSON(ErrorResult& aRv, JSCompartment* aCompartment = nullptr);

  static bool
  _Create(JSContext* cx, unsigned argc, JS::Value* vp);
};


} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_ContactsBinding_h__
