/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED - DO NOT EDIT */

#ifndef mozilla_dom_BlobEvent_h
#define mozilla_dom_BlobEvent_h

#include "mozilla/Attributes.h"
#include "mozilla/ErrorResult.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/BlobEventBinding.h"
#include "mozilla/dom/Event.h"

struct JSContext;
namespace mozilla {
namespace dom {

class BlobEvent : public Event
{
public:
  NS_DECL_ISUPPORTS_INHERITED
  NS_DECL_CYCLE_COLLECTION_SCRIPT_HOLDER_CLASS_INHERITED(BlobEvent, Event)
  virtual ~BlobEvent();
protected:
  BlobEvent(mozilla::dom::EventTarget* aOwner);

  nsRefPtr<nsIDOMBlob> mData;

public:
  virtual BlobEvent* AsBlobEvent();

  virtual JSObject* WrapObject(JSContext* aCx) MOZ_OVERRIDE;

  static already_AddRefed<BlobEvent> Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const BlobEventInit& aEventInitDict);


  static already_AddRefed<BlobEvent> Constructor(const GlobalObject& aGlobal, const nsAString& aType, const BlobEventInit& aEventInitDict, ErrorResult& aRv);

  nsIDOMBlob* GetData() const;
};

} // namespace dom
} // namespace mozilla

#endif // mozilla_dom_BlobEvent_h
