/*
 * Copyright 2013 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file is automatically generated

(function (global) {
  if (global.DataView)
    return;
  if (!global.ArrayBuffer)
    fail('ArrayBuffer not supported');
  if (!Object.defineProperties)
    fail('This module requires ECMAScript 5');
  var nativele = new Int8Array(new Int32Array([
      1
    ]).buffer)[0] === 1;
  var temp = new Uint8Array(8);
  global.DataView = function DataView(buffer, offset, length) {
    if (!(buffer instanceof ArrayBuffer))
      fail('Bad ArrayBuffer');
    offset = offset || 0;
    length = length || buffer.byteLength - offset;
    if (offset < 0 || length < 0 || offset + length > buffer.byteLength)
      fail('Illegal offset and/or length');
    Object.defineProperties(this, {
      buffer: {
        value: buffer,
        enumerable: false,
        writable: false,
        configurable: false
      },
      byteOffset: {
        value: offset,
        enumerable: false,
        writable: false,
        configurable: false
      },
      byteLength: {
        value: length,
        enumerable: false,
        writable: false,
        configurable: false
      },
      _bytes: {
        value: new Uint8Array(buffer, offset, length),
        enumerable: false,
        writable: false,
        configurable: false
      }
    });
  };
  global.DataView.prototype = {
    constructor: DataView,
    getInt8: function getInt8(offset) {
      return get(this, Int8Array, 1, offset);
    },
    getUint8: function getUint8(offset) {
      return get(this, Uint8Array, 1, offset);
    },
    getInt16: function getInt16(offset, le) {
      return get(this, Int16Array, 2, offset, le);
    },
    getUint16: function getUint16(offset, le) {
      return get(this, Uint16Array, 2, offset, le);
    },
    getInt32: function getInt32(offset, le) {
      return get(this, Int32Array, 4, offset, le);
    },
    getUint32: function getUint32(offset, le) {
      return get(this, Uint32Array, 4, offset, le);
    },
    getFloat32: function getFloat32(offset, le) {
      return get(this, Float32Array, 4, offset, le);
    },
    getFloat64: function getFloat32(offset, le) {
      return get(this, Float64Array, 8, offset, le);
    },
    setInt8: function setInt8(offset, value) {
      set(this, Int8Array, 1, offset, value);
    },
    setUint8: function setUint8(offset, value) {
      set(this, Uint8Array, 1, offset, value);
    },
    setInt16: function setInt16(offset, value, le) {
      set(this, Int16Array, 2, offset, value, le);
    },
    setUint16: function setUint16(offset, value, le) {
      set(this, Uint16Array, 2, offset, value, le);
    },
    setInt32: function setInt32(offset, value, le) {
      set(this, Int32Array, 4, offset, value, le);
    },
    setUint32: function setUint32(offset, value, le) {
      set(this, Uint32Array, 4, offset, value, le);
    },
    setFloat32: function setFloat32(offset, value, le) {
      set(this, Float32Array, 4, offset, value, le);
    },
    setFloat64: function setFloat64(offset, value, le) {
      set(this, Float64Array, 8, offset, value, le);
    }
  };
  function get(view, type, size, offset, le) {
    if (offset === undefined)
      fail('Missing required offset argument');
    if (offset < 0 || offset + size > view.byteLength)
      fail('Invalid index: ' + offset);
    if (size === 1 || !(!le) === nativele) {
      if ((view.byteOffset + offset) % size === 0)
        return new type(view.buffer, view.byteOffset + offset, 1)[0];
      else {
        for (var i = 0; i < size; i++)
          temp[i] = view._bytes[offset + i];
        return new type(temp.buffer)[0];
      }
    } else {
      for (var i = 0; i < size; i++)
        temp[size - i - 1] = view._bytes[offset + i];
      return new type(temp.buffer)[0];
    }
  }
  function set(view, type, size, offset, value, le) {
    if (offset === undefined)
      fail('Missing required offset argument');
    if (value === undefined)
      fail('Missing required value argument');
    if (offset < 0 || offset + size > view.byteLength)
      fail('Invalid index: ' + offset);
    if (size === 1 || !(!le) === nativele) {
      if ((view.byteOffset + offset) % size === 0) {
        new type(view.buffer, view.byteOffset + offset, 1)[0] = value;
      } else {
        new type(temp.buffer)[0] = value;
        for (var i = 0; i < size; i++)
          view._bytes[i + offset] = temp[i];
      }
    } else {
      new type(temp.buffer)[0] = value;
      for (var i = 0; i < size; i++)
        view._bytes[offset + i] = temp[size - 1 - i];
    }
  }
  function fail(msg) {
    throw new Error(msg);
  }
}(this));
(function (exports) {
  var ArgumentParser = function () {
      var Argument = function () {
          function argument(shortName, longName, type, options) {
            this.shortName = shortName;
            this.longName = longName;
            this.type = type;
            options = options || {};
            this.positional = options.positional;
            this.parseFn = options.parse;
            this.value = options.defaultValue;
          }
          argument.prototype.parse = function parse(value) {
            if (this.type === 'boolean') {
              true;
              this.value = value;
            } else if (this.type === 'number') {
              true;
              this.value = parseInt(value, 10);
            } else {
              this.value = value;
            }
            if (this.parseFn) {
              this.parseFn(this.value);
            }
          };
          return argument;
        }();
      function argumentParser() {
        this.args = [];
      }
      argumentParser.prototype.addArgument = function addArgument(shortName, longName, type, options) {
        var argument = new Argument(shortName, longName, type, options);
        this.args.push(argument);
        return argument;
      };
      argumentParser.prototype.addBoundOption = function addBoundOption(option) {
        var options = {
            parse: function (x) {
              option.value = x;
            }
          };
        this.args.push(new Argument(option.shortName, option.longName, option.type, options));
      };
      argumentParser.prototype.addBoundOptionSet = function addBoundOptionSet(optionSet) {
        var self = this;
        optionSet.options.forEach(function (x) {
          if (x instanceof OptionSet) {
            self.addBoundOptionSet(x);
          } else {
            true;
            self.addBoundOption(x);
          }
        });
      };
      argumentParser.prototype.getUsage = function getUsage() {
        var str = '';
        this.args.forEach(function (x) {
          if (!x.positional) {
            str += '[-' + x.shortName + '|--' + x.longName + (x.type === 'boolean' ? '' : ' ' + x.type[0].toUpperCase()) + ']';
          } else {
            str += x.longName;
          }
          str += ' ';
        });
        return str;
      };
      argumentParser.prototype.parse = function parse(args) {
        var nonPositionalArgumentMap = {};
        var positionalArgumentList = [];
        this.args.forEach(function (x) {
          if (x.positional) {
            positionalArgumentList.push(x);
          } else {
            nonPositionalArgumentMap['-' + x.shortName] = x;
            nonPositionalArgumentMap['--' + x.longName] = x;
          }
        });
        var leftoverArguments = [];
        while (args.length) {
          var argString = args.shift();
          var argument = null, value = argString;
          if (argString == '--') {
            leftoverArguments = leftoverArguments.concat(args);
            break;
          } else if (argString.slice(0, 1) == '-' || argString.slice(0, 2) == '--') {
            argument = nonPositionalArgumentMap[argString];
            true;
            if (argument.type !== 'boolean') {
              value = args.shift();
              true;
            } else {
              value = true;
            }
          } else if (positionalArgumentList.length) {
            argument = positionalArgumentList.shift();
          } else {
            leftoverArguments.push(value);
          }
          if (argument) {
            argument.parse(value);
          }
        }
        true;
        return leftoverArguments;
      };
      return argumentParser;
    }();
  var OptionSet = function () {
      function optionSet(name) {
        this.name = name;
        this.options = [];
      }
      optionSet.prototype.register = function register(option) {
        this.options.push(option);
        return option;
      };
      optionSet.prototype.trace = function trace(writer) {
        writer.enter(this.name + ' {');
        this.options.forEach(function (option) {
          option.trace(writer);
        });
        writer.leave('}');
      };
      return optionSet;
    }();
  var Option = function () {
      function option(shortName, longName, type, defaultValue, description) {
        this.longName = longName;
        this.shortName = shortName;
        this.type = type;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.description = description;
      }
      option.prototype.parse = function parse(value) {
        this.value = value;
      };
      option.prototype.trace = function trace(writer) {
        writer.writeLn(('-' + this.shortName + '|--' + this.longName).padRight(' ', 30) + ' = ' + this.type + ' ' + this.value + ' [' + this.defaultValue + ']' + ' (' + this.description + ')');
      };
      return option;
    }();
  exports.Option = Option;
  exports.OptionSet = OptionSet;
  exports.ArgumentParser = ArgumentParser;
}(typeof exports === 'undefined' ? options = {} : exports));
var Option = options.Option;
var OptionSet = options.OptionSet;
var coreOptions = new OptionSet('Core Options');
var create = Object.create;
var defineProperty = Object.defineProperty;
var keys = Object.keys;
var isArray = Array.isArray;
var fromCharCode = String.fromCharCode;
var logE = Math.log;
var max = Math.max;
var min = Math.min;
var pow = Math.pow;
var push = Array.prototype.push;
var slice = Array.prototype.slice;
var splice = Array.prototype.splice;
function fail(msg, context) {
  throw new Error((context ? context + ': ' : '') + msg);
}
function assert(cond, msg, context) {
  if (!cond)
    fail(msg, context);
}
function rgbaObjToStr(color) {
  return 'rgba(' + color.red + ',' + color.green + ',' + color.blue + ',' + color.alpha / 255 + ')';
}
function rgbIntAlphaToStr(color, alpha) {
  color |= 0;
  if (alpha >= 1) {
    var colorStr = color.toString(16);
    while (colorStr.length < 6) {
      colorStr = '0' + colorStr;
    }
    return '#' + colorStr;
  }
  var red = color >> 16 & 255;
  var green = color >> 8 & 255;
  var blue = color & 255;
  return 'rgba(' + red + ',' + green + ',' + blue + ',' + alpha + ')';
}
function argbUintToStr(argb) {
  return 'rgba(' + (argb >>> 16 & 255) + ',' + (argb >>> 8 & 255) + ',' + (argb & 255) + ',' + (argb >>> 24 & 255) / 255 + ')';
}
(function functionNameSupport() {
  if (eval('function t() {} t.name === \'t\'')) {
    return;
  }
  Object.defineProperty(Function.prototype, 'name', {
    get: function () {
      if (this.__name) {
        return this.__name;
      }
      var m = /function\s([^\(]+)/.exec(this.toString());
      var name = m && m[1] !== 'anonymous' ? m[1] : null;
      this.__name = name;
      return name;
    },
    configurable: true,
    enumerable: false
  });
}());
var randomStyleCache;
function randomStyle() {
  if (!randomStyleCache) {
    randomStyleCache = [];
    for (var i = 0; i < 50; i++) {
      randomStyleCache.push('#' + ('00000' + (Math.random() * (1 << 24) | 0).toString(16)).slice(-6));
    }
  }
  return randomStyleCache[Math.random() * randomStyleCache.length | 0];
}
var SWF_TAG_CODE_CSM_TEXT_SETTINGS = 74;
var SWF_TAG_CODE_DEFINE_BINARY_DATA = 87;
var SWF_TAG_CODE_DEFINE_BITS = 6;
var SWF_TAG_CODE_DEFINE_BITS_JPEG2 = 21;
var SWF_TAG_CODE_DEFINE_BITS_JPEG3 = 35;
var SWF_TAG_CODE_DEFINE_BITS_JPEG4 = 90;
var SWF_TAG_CODE_DEFINE_BITS_LOSSLESS = 20;
var SWF_TAG_CODE_DEFINE_BITS_LOSSLESS2 = 36;
var SWF_TAG_CODE_DEFINE_BUTTON = 7;
var SWF_TAG_CODE_DEFINE_BUTTON2 = 34;
var SWF_TAG_CODE_DEFINE_BUTTON_CXFORM = 23;
var SWF_TAG_CODE_DEFINE_BUTTON_SOUND = 17;
var SWF_TAG_CODE_DEFINE_EDIT_TEXT = 37;
var SWF_TAG_CODE_DEFINE_FONT = 10;
var SWF_TAG_CODE_DEFINE_FONT2 = 48;
var SWF_TAG_CODE_DEFINE_FONT3 = 75;
var SWF_TAG_CODE_DEFINE_FONT4 = 91;
var SWF_TAG_CODE_DEFINE_FONT_ALIGN_ZONES = 73;
var SWF_TAG_CODE_DEFINE_FONT_INFO = 13;
var SWF_TAG_CODE_DEFINE_FONT_INFO2 = 62;
var SWF_TAG_CODE_DEFINE_FONT_NAME = 88;
var SWF_TAG_CODE_DEFINE_MORPH_SHAPE = 46;
var SWF_TAG_CODE_DEFINE_MORPH_SHAPE2 = 84;
var SWF_TAG_CODE_DEFINE_SCALING_GRID = 78;
var SWF_TAG_CODE_DEFINE_SCENE_AND_FRAME_LABEL_DATA = 86;
var SWF_TAG_CODE_DEFINE_SHAPE = 2;
var SWF_TAG_CODE_DEFINE_SHAPE2 = 22;
var SWF_TAG_CODE_DEFINE_SHAPE3 = 32;
var SWF_TAG_CODE_DEFINE_SHAPE4 = 83;
var SWF_TAG_CODE_DEFINE_SOUND = 14;
var SWF_TAG_CODE_DEFINE_SPRITE = 39;
var SWF_TAG_CODE_DEFINE_TEXT = 11;
var SWF_TAG_CODE_DEFINE_TEXT2 = 33;
var SWF_TAG_CODE_DEFINE_VIDEO_STREAM = 60;
var SWF_TAG_CODE_DO_ABC = 82;
var SWF_TAG_CODE_DO_ABC_ = 72;
var SWF_TAG_CODE_DO_ACTION = 12;
var SWF_TAG_CODE_DO_INIT_ACTION = 59;
var SWF_TAG_CODE_ENABLE_DEBUGGER = 58;
var SWF_TAG_CODE_ENABLE_DEBUGGER2 = 64;
var SWF_TAG_CODE_END = 0;
var SWF_TAG_CODE_EXPORT_ASSETS = 56;
var SWF_TAG_CODE_FILE_ATTRIBUTES = 69;
var SWF_TAG_CODE_FRAME_LABEL = 43;
var SWF_TAG_CODE_IMPORT_ASSETS = 57;
var SWF_TAG_CODE_IMPORT_ASSETS2 = 71;
var SWF_TAG_CODE_JPEG_TABLES = 8;
var SWF_TAG_CODE_METADATA = 77;
var SWF_TAG_CODE_PLACE_OBJECT = 4;
var SWF_TAG_CODE_PLACE_OBJECT2 = 26;
var SWF_TAG_CODE_PLACE_OBJECT3 = 70;
var SWF_TAG_CODE_PROTECT = 24;
var SWF_TAG_CODE_REMOVE_OBJECT = 5;
var SWF_TAG_CODE_REMOVE_OBJECT2 = 28;
var SWF_TAG_CODE_SCRIPT_LIMITS = 65;
var SWF_TAG_CODE_SET_BACKGROUND_COLOR = 9;
var SWF_TAG_CODE_SET_TAB_INDEX = 66;
var SWF_TAG_CODE_SHOW_FRAME = 1;
var SWF_TAG_CODE_SOUND_STREAM_BLOCK = 19;
var SWF_TAG_CODE_SOUND_STREAM_HEAD = 18;
var SWF_TAG_CODE_SOUND_STREAM_HEAD2 = 45;
var SWF_TAG_CODE_START_SOUND = 15;
var SWF_TAG_CODE_START_SOUND2 = 89;
var SWF_TAG_CODE_SYMBOL_CLASS = 76;
var SWF_TAG_CODE_VIDEO_FRAME = 61;
self.SWF = {};
var codeLengthOrder = [
    16,
    17,
    18,
    0,
    8,
    7,
    9,
    6,
    10,
    5,
    11,
    4,
    12,
    3,
    13,
    2,
    14,
    1,
    15
  ];
var distanceCodes = [];
var distanceExtraBits = [];
for (var i = 0, j = 0, code = 1; i < 30; ++i) {
  distanceCodes[i] = code;
  code += 1 << (distanceExtraBits[i] = ~(~((j += i > 2 ? 1 : 0) / 2)));
}
var bitLengths = [];
for (var i = 0; i < 32; ++i)
  bitLengths[i] = 5;
var fixedDistanceTable = makeHuffmanTable(bitLengths);
var lengthCodes = [];
var lengthExtraBits = [];
for (var i = 0, j = 0, code = 3; i < 29; ++i) {
  lengthCodes[i] = code - (i == 28 ? 1 : 0);
  code += 1 << (lengthExtraBits[i] = ~(~((j += i > 4 ? 1 : 0) / 4 % 6)));
}
for (var i = 0; i < 288; ++i)
  bitLengths[i] = i < 144 || i > 279 ? 8 : i < 256 ? 9 : 7;
var fixedLiteralTable = makeHuffmanTable(bitLengths);
function makeHuffmanTable(bitLengths) {
  var maxBits = max.apply(null, bitLengths);
  var numLengths = bitLengths.length;
  var size = 1 << maxBits;
  var codes = new Uint32Array(size);
  for (var code = 0, len = 1, skip = 2; len <= maxBits; code <<= 1, ++len, skip <<= 1) {
    for (var val = 0; val < numLengths; ++val) {
      if (bitLengths[val] === len) {
        var lsb = 0;
        for (var i = 0; i < len; ++i)
          lsb = lsb * 2 + (code >> i & 1);
        for (var i = lsb; i < size; i += skip)
          codes[i] = len << 16 | val;
        ++code;
      }
    }
  }
  return {
    codes: codes,
    maxBits: maxBits
  };
}
function verifyDeflateHeader(bytes) {
  var header = bytes[0] << 8 | bytes[1];
}
function createInflatedStream(bytes, outputLength) {
  verifyDeflateHeader(bytes);
  var stream = new Stream(bytes, 2);
  var output = {
      data: new Uint8Array(outputLength),
      available: 0,
      completed: false
    };
  var state = {};
  do {
    inflateBlock(stream, output, state);
  } while (!output.completed && stream.pos < stream.end);
  return new Stream(output.data, 0, output.available);
}
var InflateNoDataError = {};
function inflateBlock(stream, output, state) {
  var header = state.header !== undefined ? state.header : state.header = readBits(stream.bytes, stream, 3);
  switch (header >> 1) {
  case 0:
    stream.align();
    var pos = stream.pos;
    if (stream.end - pos < 4) {
      throw InflateNoDataError;
    }
    var len = stream.getUint16(pos, true);
    var nlen = stream.getUint16(pos + 2, true);
    if (stream.end - pos < 4 + len) {
      throw InflateNoDataError;
    }
    var begin = pos + 4;
    var end = stream.pos = begin + len;
    var sbytes = stream.bytes, dbytes = output.data;
    splice.apply(dbytes, [
      output.available,
      len
    ].concat(slice.call(sbytes, begin, end)));
    output.available += len;
    break;
  case 1:
    inflate(stream, output, fixedLiteralTable, fixedDistanceTable, state);
    break;
  case 2:
    var distanceTable, literalTable;
    if (state.distanceTable !== undefined) {
      distanceTable = state.distanceTable;
      literalTable = state.literalTable;
    } else {
      var sbytes = stream.bytes;
      var savedBufferPos = stream.pos;
      var savedBitBuffer = stream.bitBuffer;
      var savedBitLength = stream.bitLength;
      var bitLengths = [];
      var numLiteralCodes, numDistanceCodes;
      try {
        numLiteralCodes = readBits(sbytes, stream, 5) + 257;
        numDistanceCodes = readBits(sbytes, stream, 5) + 1;
        var numCodes = numLiteralCodes + numDistanceCodes;
        var numLengthCodes = readBits(sbytes, stream, 4) + 4;
        for (var i = 0; i < 19; ++i)
          bitLengths[codeLengthOrder[i]] = i < numLengthCodes ? readBits(sbytes, stream, 3) : 0;
        var codeLengthTable = makeHuffmanTable(bitLengths);
        bitLengths = [];
        var i = 0;
        var prev = 0;
        while (i < numCodes) {
          var j = 1;
          var sym = readCode(sbytes, stream, codeLengthTable);
          switch (sym) {
          case 16:
            j = readBits(sbytes, stream, 2) + 3;
            sym = prev;
            break;
          case 17:
            j = readBits(sbytes, stream, 3) + 3;
            sym = 0;
            break;
          case 18:
            j = readBits(sbytes, stream, 7) + 11;
            sym = 0;
            break;
          default:
            prev = sym;
          }
          while (j--)
            bitLengths[i++] = sym;
        }
      } catch (e) {
        stream.pos = savedBufferPos;
        stream.bitBuffer = savedBitBuffer;
        stream.bitLength = savedBitLength;
        throw e;
      }
      distanceTable = state.distanceTable = makeHuffmanTable(bitLengths.splice(numLiteralCodes, numDistanceCodes));
      literalTable = state.literalTable = makeHuffmanTable(bitLengths);
    }
    inflate(stream, output, literalTable, distanceTable, state);
    delete state.distanceTable;
    delete state.literalTable;
    break;
  default:
    fail('unknown block type', 'inflate');
  }
  delete state.header;
  output.completed = !(!(header & 1));
}
function readBits(bytes, stream, size) {
  var bitBuffer = stream.bitBuffer;
  var bitLength = stream.bitLength;
  if (size > bitLength) {
    var pos = stream.pos;
    var end = stream.end;
    do {
      if (pos >= end) {
        stream.pos = pos;
        stream.bitBuffer = bitBuffer;
        stream.bitLength = bitLength;
        throw InflateNoDataError;
      }
      bitBuffer |= bytes[pos++] << bitLength;
      bitLength += 8;
    } while (size > bitLength);
    stream.pos = pos;
  }
  stream.bitBuffer = bitBuffer >>> size;
  stream.bitLength = bitLength - size;
  return bitBuffer & (1 << size) - 1;
}
function inflate(stream, output, literalTable, distanceTable, state) {
  var pos = output.available;
  var dbytes = output.data;
  var sbytes = stream.bytes;
  var sym = state.sym !== undefined ? state.sym : readCode(sbytes, stream, literalTable);
  while (sym !== 256) {
    if (sym < 256) {
      dbytes[pos++] = sym;
    } else {
      state.sym = sym;
      sym -= 257;
      var len = state.len !== undefined ? state.len : state.len = lengthCodes[sym] + readBits(sbytes, stream, lengthExtraBits[sym]);
      var sym2 = state.sym2 !== undefined ? state.sym2 : state.sym2 = readCode(sbytes, stream, distanceTable);
      var distance = distanceCodes[sym2] + readBits(sbytes, stream, distanceExtraBits[sym2]);
      var i = pos - distance;
      while (len--)
        dbytes[pos++] = dbytes[i++];
      delete state.sym2;
      delete state.len;
      delete state.sym;
    }
    output.available = pos;
    sym = readCode(sbytes, stream, literalTable);
  }
}
function readCode(bytes, stream, codeTable) {
  var bitBuffer = stream.bitBuffer;
  var bitLength = stream.bitLength;
  var maxBits = codeTable.maxBits;
  if (maxBits > bitLength) {
    var pos = stream.pos;
    var end = stream.end;
    do {
      if (pos >= end) {
        stream.pos = pos;
        stream.bitBuffer = bitBuffer;
        stream.bitLength = bitLength;
        throw InflateNoDataError;
      }
      bitBuffer |= bytes[pos++] << bitLength;
      bitLength += 8;
    } while (maxBits > bitLength);
    stream.pos = pos;
  }
  var code = codeTable.codes[bitBuffer & (1 << maxBits) - 1];
  var len = code >> 16;
  stream.bitBuffer = bitBuffer >>> len;
  stream.bitLength = bitLength - len;
  return code & 65535;
}
var StreamNoDataError = {};
var Stream = function StreamClosure() {
    function Stream_align() {
      this.bitBuffer = this.bitLength = 0;
    }
    function Stream_ensure(size) {
      if (this.pos + size > this.end) {
        throw StreamNoDataError;
      }
    }
    function Stream_remaining() {
      return this.end - this.pos;
    }
    function Stream_substream(begin, end) {
      var stream = new Stream(this.bytes);
      stream.pos = begin;
      stream.end = end;
      return stream;
    }
    function Stream_push(data) {
      var bytes = this.bytes;
      var newBytesLength = this.end + data.length;
      if (newBytesLength > bytes.length) {
        throw 'stream buffer overfow';
      }
      bytes.set(data, this.end);
      this.end = newBytesLength;
    }
    function Stream(buffer, offset, length, maxLength) {
      if (offset === undefined)
        offset = 0;
      if (buffer.buffer instanceof ArrayBuffer) {
        offset += buffer.byteOffset;
        buffer = buffer.buffer;
      }
      if (length === undefined)
        length = buffer.byteLength - offset;
      if (maxLength === undefined)
        maxLength = length;
      var bytes = new Uint8Array(buffer, offset, maxLength);
      var stream = new DataView(buffer, offset, maxLength);
      stream.bytes = bytes;
      stream.pos = 0;
      stream.end = length;
      stream.bitBuffer = 0;
      stream.bitLength = 0;
      stream.align = Stream_align;
      stream.ensure = Stream_ensure;
      stream.remaining = Stream_remaining;
      stream.substream = Stream_substream;
      stream.push = Stream_push;
      return stream;
    }
    return Stream;
  }();
var FORMAT_COLORMAPPED = 3;
var FORMAT_15BPP = 4;
var FORMAT_24BPP = 5;
var FACTOR_5BBP = 255 / 31;
var crcTable = [];
for (var i = 0; i < 256; i++) {
  var c = i;
  for (var h = 0; h < 8; h++) {
    if (c & 1)
      c = 3988292384 ^ c >> 1 & 2147483647;
    else
      c = c >> 1 & 2147483647;
  }
  crcTable[i] = c;
}
function crc32(data, start, end) {
  var crc = -1;
  for (var i = start; i < end; i++) {
    var a = (crc ^ data[i]) & 255;
    var b = crcTable[a];
    crc = crc >>> 8 ^ b;
  }
  return crc ^ -1;
}
function createPngChunk(type, data) {
  var chunk = new Uint8Array(12 + data.length);
  var p = 0;
  var len = data.length;
  chunk[p] = len >> 24 & 255;
  chunk[p + 1] = len >> 16 & 255;
  chunk[p + 2] = len >> 8 & 255;
  chunk[p + 3] = len & 255;
  chunk[p + 4] = type.charCodeAt(0) & 255;
  chunk[p + 5] = type.charCodeAt(1) & 255;
  chunk[p + 6] = type.charCodeAt(2) & 255;
  chunk[p + 7] = type.charCodeAt(3) & 255;
  if (data instanceof Uint8Array)
    chunk.set(data, 8);
  p = 8 + len;
  var crc = crc32(chunk, 4, p);
  chunk[p] = crc >> 24 & 255;
  chunk[p + 1] = crc >> 16 & 255;
  chunk[p + 2] = crc >> 8 & 255;
  chunk[p + 3] = crc & 255;
  return chunk;
}
function adler32(data, start, end) {
  var a = 1;
  var b = 0;
  for (var i = start; i < end; ++i) {
    a = (a + (data[i] & 255)) % 65521;
    b = (b + a) % 65521;
  }
  return b << 16 | a;
}
function defineBitmap(tag) {
  var width = tag.width;
  var height = tag.height;
  var hasAlpha = tag.hasAlpha;
  var plte = '';
  var trns = '';
  var literals;
  var bmpData = tag.bmpData;
  switch (tag.format) {
  case FORMAT_COLORMAPPED:
    var colorType = 3;
    var bytesPerLine = width + 3 & ~3;
    var colorTableSize = tag.colorTableSize + 1;
    var paletteSize = colorTableSize * (tag.hasAlpha ? 4 : 3);
    var datalen = paletteSize + bytesPerLine * height;
    var stream = createInflatedStream(bmpData, datalen);
    var bytes = stream.bytes;
    var pos = 0;
    stream.ensure(paletteSize);
    if (hasAlpha) {
      var palette = new Uint8Array(paletteSize / 4 * 3);
      var pp = 0;
      var alphaValues = new Uint8Array(paletteSize / 4);
      var pa = 0;
      while (pos < paletteSize) {
        palette[pp++] = bytes[pos];
        palette[pp++] = bytes[pos + 1];
        palette[pp++] = bytes[pos + 2];
        alphaValues[pa++] = bytes[pos + 3];
        pos += 4;
      }
      plte = createPngChunk('PLTE', palette);
      trns = createPngChunk('tRNS', alphaValues);
    } else {
      plte = createPngChunk('PLTE', bytes.subarray(pos, pos + paletteSize));
      pos += paletteSize;
    }
    literals = new Uint8Array(width * height + height);
    var pl = 0;
    while (pos < datalen) {
      stream.ensure(bytesPerLine);
      var begin = pos;
      var end = begin + width;
      pl++;
      literals.set(bytes.subarray(begin, end), pl);
      pl += end - begin;
      stream.pos = pos += bytesPerLine;
    }
    break;
  case FORMAT_15BPP:
    var colorType = 2;
    var bytesPerLine = width * 2 + 3 & ~3;
    var stream = createInflatedStream(bmpData, bytesPerLine * height);
    var pos = 0;
    literals = new Uint8Array(width * height * 3 + height);
    var pl = 0;
    for (var y = 0; y < height; ++y) {
      pl++;
      stream.ensure(bytesPerLine);
      for (var x = 0; x < width; ++x) {
        var word = stream.getUint16(pos);
        pos += 2;
        literals[pl++] = 0 | FACTOR_5BBP * (word >> 10 & 31);
        literals[pl++] = 0 | FACTOR_5BBP * (word >> 5 & 31);
        literals[pl++] = 0 | FACTOR_5BBP * (word & 31);
      }
      stream.pos = pos += bytesPerLine;
    }
    break;
  case FORMAT_24BPP:
    var padding;
    if (hasAlpha) {
      var colorType = 6;
      padding = 0;
      literals = new Uint8Array(width * height * 4 + height);
    } else {
      var colorType = 2;
      padding = 1;
      literals = new Uint8Array(width * height * 3 + height);
    }
    var bytesPerLine = width * 4;
    var stream = createInflatedStream(bmpData, bytesPerLine * height);
    var bytes = stream.bytes;
    var pos = 0;
    var pl = 0;
    for (var y = 0; y < height; ++y) {
      stream.ensure(bytesPerLine);
      pl++;
      for (var x = 0; x < width; ++x) {
        pos += padding;
        if (hasAlpha) {
          var alpha = bytes[pos];
          if (alpha) {
            var opacity = alpha / 255;
            literals[pl++] = 0 | bytes[pos + 1] / opacity;
            literals[pl++] = 0 | bytes[pos + 2] / opacity;
            literals[pl++] = 0 | bytes[pos + 3] / opacity;
            literals[pl++] = alpha;
          } else {
            pl += 4;
          }
        } else {
          literals[pl++] = bytes[pos];
          literals[pl++] = bytes[pos + 1];
          literals[pl++] = bytes[pos + 2];
        }
        pos += 4 - padding;
      }
      stream.pos = pos;
    }
    break;
  default:
    fail('invalid format', 'bitmap');
  }
  var ihdr = new Uint8Array([
      width >> 24 & 255,
      width >> 16 & 255,
      width >> 8 & 255,
      width & 255,
      height >> 24 & 255,
      height >> 16 & 255,
      height >> 8 & 255,
      height & 255,
      8,
      colorType,
      0,
      0,
      0
    ]);
  var len = literals.length;
  var maxBlockLength = 65535;
  var idat = new Uint8Array(2 + len + Math.ceil(len / maxBlockLength) * 5 + 4);
  var pi = 0;
  idat[pi++] = 120;
  idat[pi++] = 156;
  var pos = 0;
  while (len > maxBlockLength) {
    idat[pi++] = 0;
    idat[pi++] = 255;
    idat[pi++] = 255;
    idat[pi++] = 0;
    idat[pi++] = 0;
    idat.set(literals.subarray(pos, pos + maxBlockLength), pi);
    pi += maxBlockLength;
    pos += maxBlockLength;
    len -= maxBlockLength;
  }
  idat[pi++] = 1;
  idat[pi++] = len & 255;
  idat[pi++] = len >> 8 & 255;
  idat[pi++] = ~len & 65535 & 255;
  idat[pi++] = (~len & 65535) >> 8 & 255;
  idat.set(literals.subarray(pos), pi);
  pi += literals.length - pos;
  var adler = adler32(literals, 0, literals.length);
  idat[pi++] = adler >> 24 & 255;
  idat[pi++] = adler >> 16 & 255;
  idat[pi++] = adler >> 8 & 255;
  idat[pi++] = adler & 255;
  var chunks = [
      new Uint8Array([
        137,
        80,
        78,
        71,
        13,
        10,
        26,
        10
      ]),
      createPngChunk('IHDR', ihdr),
      plte,
      trns,
      createPngChunk('IDAT', idat),
      createPngChunk('IEND', '')
    ];
  return {
    type: 'image',
    id: tag.id,
    width: width,
    height: height,
    mimeType: 'image/png',
    data: new Blob(chunks, {
      type: 'image/png'
    })
  };
}
function defineButton(tag, dictionary) {
  var characters = tag.characters;
  var states = {
      up: {},
      over: {},
      down: {},
      hitTest: {}
    };
  var i = 0, character;
  while (character = characters[i++]) {
    if (character.eob)
      break;
    var characterItem = dictionary[character.symbolId];
    var entry = {
        symbolId: characterItem.id,
        hasMatrix: !(!character.matrix),
        matrix: character.matrix
      };
    if (character.stateUp)
      states.up[character.depth] = entry;
    if (character.stateOver)
      states.over[character.depth] = entry;
    if (character.stateDown)
      states.down[character.depth] = entry;
    if (character.stateHitTest)
      states.hitTest[character.depth] = entry;
  }
  var button = {
      type: 'button',
      id: tag.id,
      buttonActions: tag.buttonActions,
      states: states
    };
  return button;
}
var nextFontId = 1;
function maxPower2(num) {
  var maxPower = 0;
  var val = num;
  while (val >= 2) {
    val /= 2;
    ++maxPower;
  }
  return pow(2, maxPower);
}
function toString16(val) {
  return fromCharCode(val >> 8 & 255, val & 255);
}
function toString32(val) {
  return toString16(val >> 16) + toString16(val);
}
function defineFont(tag, dictionary) {
  var tables = {};
  var codes = [];
  var glyphIndex = {};
  var ranges = [];
  var glyphs = tag.glyphs;
  var glyphCount = glyphs.length;
  if (tag.codes) {
    codes = codes.concat(tag.codes);
    for (var i = 0, code; code = codes[i]; ++i)
      glyphIndex[code] = i;
    codes.sort(function (a, b) {
      return a - b;
    });
    var i = 0;
    var code;
    while (code = codes[i++]) {
      var start = code;
      var end = start;
      var indices = [
          i - 1
        ];
      while ((code = codes[i]) && end + 1 === code) {
        ++end;
        indices.push(i);
        ++i;
      }
      ranges.push([
        start,
        end,
        indices
      ]);
    }
  } else {
    var indices = [];
    var UAC_OFFSET = 57344;
    for (var i = 0; i < glyphCount; i++) {
      var code = UAC_OFFSET + i;
      codes.push(code);
      glyphIndex[code] = i;
      indices.push(i);
    }
    ranges.push([
      UAC_OFFSET,
      UAC_OFFSET + glyphCount - 1,
      indices
    ]);
  }
  var resolution = tag.resolution || 1;
  var ascent = Math.ceil(tag.ascent / resolution) || 1024;
  var descent = -Math.ceil(tag.descent / resolution) | 0;
  var leading = tag.leading / resolution | 0;
  tables['OS/2'] = '\0\x01\0\0' + toString16(tag.bold ? 700 : 400) + '\0\x05' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0\0\0\0\0\0\0\0\0' + '\0\0\0\0' + '\0\0\0\0' + '\0\0\0\0' + '\0\0\0\0' + 'ALF ' + toString16((tag.italic ? 1 : 0) | (tag.bold ? 32 : 0)) + toString16(codes[0]) + toString16(codes[codes.length - 1]) + toString16(ascent) + toString16(descent) + toString16(leading) + toString16(ascent) + toString16(-descent) + '\0\0\0\0' + '\0\0\0\0';
  ;
  var startCount = '';
  var endCount = '';
  var idDelta = '';
  var idRangeOffset = '';
  var i = 0;
  var range;
  while (range = ranges[i++]) {
    var start = range[0];
    var end = range[1];
    var code = range[2][0];
    startCount += toString16(start);
    endCount += toString16(end);
    idDelta += toString16(code - start + 1 & 65535);
    idRangeOffset += toString16(0);
  }
  endCount += '\xff\xff';
  startCount += '\xff\xff';
  idDelta += '\0\x01';
  idRangeOffset += '\0\0';
  var segCount = ranges.length + 1;
  var searchRange = maxPower2(segCount) * 2;
  var rangeShift = 2 * segCount - searchRange;
  var format314 = '\0\0' + toString16(segCount * 2) + toString16(searchRange) + toString16(logE(segCount) / logE(2)) + toString16(rangeShift) + endCount + '\0\0' + startCount + idDelta + idRangeOffset;
  ;
  tables['cmap'] = '\0\0\0\x01\0\x03\0\x01\0\0\0\f\0\x04' + toString16(format314.length + 4) + format314;
  ;
  var glyf = '\0\x01\0\0\0\0\0\0\0\0\0\0\0\x001\0';
  var loca = '\0\0';
  var offset = 16;
  var maxPoints = 0;
  var xMins = [];
  var xMaxs = [];
  var yMins = [];
  var yMaxs = [];
  var maxContours = 0;
  var i = 0;
  var code;
  while (code = codes[i++]) {
    var glyph = glyphs[glyphIndex[code]];
    var records = glyph.records;
    var numberOfContours = 1;
    var endPoint = 0;
    var endPtsOfContours = '';
    var flags = '';
    var xCoordinates = '';
    var yCoordinates = '';
    var x = 0;
    var y = 0;
    var xMin = 1024;
    var xMax = -1024;
    var yMin = 1024;
    var yMax = -1024;
    for (var j = 0, record; record = records[j]; ++j) {
      if (record.type) {
        if (record.isStraight) {
          if (record.isGeneral) {
            flags += '\x01';
            var dx = record.deltaX / resolution;
            var dy = -record.deltaY / resolution;
            xCoordinates += toString16(dx);
            yCoordinates += toString16(dy);
            x += dx;
            y += dy;
          } else if (record.isVertical) {
            flags += '\x11';
            var dy = -record.deltaY / resolution;
            yCoordinates += toString16(dy);
            y += dy;
          } else {
            flags += '!';
            var dx = record.deltaX / resolution;
            xCoordinates += toString16(dx);
            x += dx;
          }
        } else {
          flags += '\0';
          var cx = record.controlDeltaX / resolution;
          var cy = -record.controlDeltaY / resolution;
          xCoordinates += toString16(cx);
          yCoordinates += toString16(cy);
          flags += '\x01';
          var dx = record.anchorDeltaX / resolution;
          var dy = -record.anchorDeltaY / resolution;
          xCoordinates += toString16(dx);
          yCoordinates += toString16(dy);
          ++endPoint;
          x += cx + dx;
          y += cy + dy;
        }
        if (x < xMin)
          xMin = x;
        if (x > xMax)
          xMax = x;
        if (y < yMin)
          yMin = y;
        if (y > yMax)
          yMax = y;
        ++endPoint;
      } else {
        if (record.eos)
          break;
        if (record.move) {
          if (endPoint) {
            ++numberOfContours;
            endPtsOfContours += toString16(endPoint - 1);
          }
          flags += '\x01';
          var moveX = record.moveX / resolution;
          var moveY = -record.moveY / resolution;
          var dx = moveX - x;
          var dy = moveY - y;
          xCoordinates += toString16(dx);
          yCoordinates += toString16(dy);
          x = moveX;
          y = moveY;
          if (endPoint > maxPoints)
            maxPoints = endPoint;
          if (x < xMin)
            xMin = x;
          if (x > xMax)
            xMax = x;
          if (y < yMin)
            yMin = y;
          if (y > yMax)
            yMax = y;
          ++endPoint;
        }
      }
    }
    endPtsOfContours += toString16((endPoint || 1) - 1);
    if (!j) {
      xMin = xMax = yMin = yMax = 0;
      flags += '1';
    }
    var entry = toString16(numberOfContours) + toString16(xMin) + toString16(yMin) + toString16(xMax) + toString16(yMax) + endPtsOfContours + '\0\0' + flags + xCoordinates + yCoordinates;
    ;
    if (entry.length & 1)
      entry += '\0';
    glyf += entry;
    loca += toString16(offset / 2);
    offset += entry.length;
    xMins.push(xMin);
    xMaxs.push(xMax);
    yMins.push(yMin);
    yMaxs.push(yMax);
    if (numberOfContours > maxContours)
      maxContours = numberOfContours;
    if (endPoint > maxPoints)
      maxPoints = endPoint;
  }
  loca += toString16(offset / 2);
  tables['glyf'] = glyf;
  tables['head'] = '\0\x01\0\0\0\x01\0\0\0\0\0\0_\x0f<\xf5\0\v\x04\0\0\0\0\0' + toString32(Date.now()) + '\0\0\0\0' + toString32(Date.now()) + toString16(min.apply(null, xMins)) + toString16(min.apply(null, yMins)) + toString16(max.apply(null, xMaxs)) + toString16(max.apply(null, yMaxs)) + toString16((tag.italic ? 2 : 0) | (tag.bold ? 1 : 0)) + '\0\b' + '\0\x02' + '\0\0' + '\0\0';
  ;
  var advance = tag.advance;
  tables['hhea'] = '\0\x01\0\0' + toString16(ascent) + toString16(descent) + toString16(leading) + toString16(advance ? max.apply(null, advance) : 1024) + '\0\0' + '\0\0' + '\x03\xb8' + '\0\x01' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + toString16(glyphCount + 1);
  ;
  var hmtx = '\0\0\0\0';
  for (var i = 0; i < glyphCount; ++i)
    hmtx += toString16(advance ? advance[i] / resolution : 1024) + '\0\0';
  tables['hmtx'] = hmtx;
  if (tag.kerning) {
    var kerning = tag.kerning;
    var nPairs = kerning.length;
    var searchRange = maxPower2(nPairs) * 2;
    var kern = '\0\0\0\x01\0\0' + toString16(14 + nPairs * 6) + '\0\x01' + toString16(nPairs) + toString16(searchRange) + toString16(logE(nPairs) / logE(2)) + toString16(2 * nPairs - searchRange);
    ;
    var i = 0;
    var record;
    while (record = kerning[i++]) {
      kern += toString16(glyphIndex[record.code1]) + toString16(glyphIndex[record.code2]) + toString16(record.adjustment);
      ;
    }
    tables['kern'] = kern;
  }
  tables['loca'] = loca;
  tables['maxp'] = '\0\x01\0\0' + toString16(glyphCount + 1) + toString16(maxPoints) + toString16(maxContours) + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0' + '\0\0';
  ;
  var uniqueId = 'swf-font-' + nextFontId++;
  var fontName = tag.name || uniqueId;
  var psName = fontName.replace(/ /g, '');
  var strings = [
      tag.copyright || 'Original licence',
      fontName,
      'Unknown',
      uniqueId,
      fontName,
      '1.0',
      psName,
      'Unknown',
      'Unknown',
      'Unknown'
    ];
  var count = strings.length;
  var name = '\0\0' + toString16(count) + toString16(count * 12 + 6);
  var offset = 0;
  var i = 0;
  var str;
  while (str = strings[i++]) {
    name += '\0\x01\0\0\0\0' + toString16(i - 1) + toString16(str.length) + toString16(offset);
    offset += str.length;
  }
  tables['name'] = name + strings.join('');
  tables['post'] = '\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0';
  ;
  var names = keys(tables);
  var numTables = names.length;
  var header = '\0\x01\0\0' + toString16(numTables) + '\0\x80' + '\0\x03' + '\0 ';
  ;
  var data = '';
  var offset = numTables * 16 + header.length;
  var i = 0;
  var name;
  while (name = names[i++]) {
    var table = tables[name];
    var length = table.length;
    header += name + '\0\0\0\0' + toString32(offset) + toString32(length);
    ;
    while (length & 3) {
      table += '\0';
      ++length;
    }
    data += table;
    while (offset & 3)
      ++offset;
    offset += length;
  }
  var otf = header + data;
  var unitPerEm = 1024;
  var metrics = {
      ascent: ascent / unitPerEm,
      descent: -descent / unitPerEm,
      leading: leading / unitPerEm
    };
  return {
    type: 'font',
    id: tag.id,
    name: fontName,
    uniqueName: psName + uniqueId,
    codes: codes,
    metrics: metrics,
    bold: tag.bold === 1,
    italic: tag.italic === 1,
    data: otf
  };
}
function getUint16(buff, pos) {
  return buff[pos] << 8 | buff[pos + 1];
}
function parseJpegChunks(imgDef, bytes) {
  var i = 0;
  var n = bytes.length;
  var chunks = [];
  var code;
  do {
    var begin = i;
    while (i < n && bytes[i] !== 255)
      ++i;
    while (i < n && bytes[i] === 255)
      ++i;
    code = bytes[i++];
    if (code === 218) {
      i = n;
    } else if (code === 217) {
      i += 2;
      continue;
    } else if (code < 208 || code > 216) {
      var length = getUint16(bytes, i);
      if (code >= 192 && code <= 195) {
        imgDef.height = getUint16(bytes, i + 3);
        imgDef.width = getUint16(bytes, i + 5);
      }
      i += length;
    }
    chunks.push(bytes.subarray(begin, i));
  } while (i < n);
  return chunks;
}
function defineImage(tag, dictionary) {
  var img = {
      type: 'image',
      id: tag.id,
      mimeType: tag.mimeType
    };
  var imgData = tag.imgData;
  var chunks;
  if (tag.mimeType === 'image/jpeg') {
    chunks = parseJpegChunks(img, imgData);
    var alphaData = tag.alphaData;
    if (alphaData) {
      img.mask = createInflatedStream(alphaData, img.width * img.height).bytes;
    }
    if (tag.incomplete) {
      var tables = dictionary[0];
      var header = tables.data;
      if (header && header.size) {
        chunks[0] = chunks[0].subarray(2);
        chunks.unshift(header.slice(0, header.size - 2));
      }
    }
  } else {
    chunks = [
      imgData
    ];
  }
  img.data = new Blob(chunks, {
    type: tag.mimeType
  });
  return img;
}
function defineLabel(tag, dictionary) {
  var records = tag.records;
  var m = tag.matrix;
  var cmds = [
      'c.save()',
      'c.transform(' + [
        m.a,
        m.b,
        m.c,
        m.d,
        m.tx / 20,
        m.ty / 20
      ].join(',') + ')',
      'c.scale(0.05, 0.05)'
    ];
  var dependencies = [];
  var x = 0;
  var y = 0;
  var i = 0;
  var record;
  var codes;
  while (record = records[i++]) {
    if (record.eot)
      break;
    if (record.hasFont) {
      var font = dictionary[record.fontId];
      codes = font.codes;
      cmds.push('c.font="' + record.fontHeight + 'px \'' + font.uniqueName + '\'"');
      dependencies.push(font.id);
    }
    if (record.hasColor) {
      cmds.push('ct.setFillStyle(c,"' + rgbaObjToStr(record.color) + '")');
      cmds.push('ct.setAlpha(c)');
    } else {
      cmds.push('ct.setAlpha(c,true)');
    }
    if (record.hasMoveX)
      x = record.moveX;
    if (record.hasMoveY)
      y = record.moveY;
    var entries = record.entries;
    var j = 0;
    var entry;
    while (entry = entries[j++]) {
      var code = codes[entry.glyphIndex];
      var text = code >= 32 && code != 34 && code != 92 ? fromCharCode(code) : '\\u' + (code + 65536).toString(16).substring(1);
      cmds.push('c.fillText("' + text + '",' + x + ',' + y + ')');
      x += entry.advance;
    }
  }
  cmds.push('c.restore()');
  var label = {
      type: 'label',
      id: tag.id,
      bbox: tag.bbox,
      data: cmds.join('\n')
    };
  if (dependencies.length)
    label.require = dependencies;
  return label;
}
var GRAPHICS_FILL_CLIPPED_BITMAP = 65;
var GRAPHICS_FILL_FOCAL_RADIAL_GRADIENT = 19;
var GRAPHICS_FILL_LINEAR_GRADIENT = 16;
var GRAPHICS_FILL_NONSMOOTHED_CLIPPED_BITMAP = 67;
var GRAPHICS_FILL_NONSMOOTHED_REPEATING_BITMAP = 66;
var GRAPHICS_FILL_RADIAL_GRADIENT = 18;
var GRAPHICS_FILL_REPEATING_BITMAP = 64;
var GRAPHICS_FILL_SOLID = 0;
function applySegmentToStyles(segment, styles, linePaths, fillPaths, isMorph) {
  if (!segment) {
    return;
  }
  var commands = segment.commands;
  var data = segment.data;
  var morphData = segment.morphData;
  if (morphData) {
  }
  var path;
  var targetSegment;
  var command;
  var i;
  if (styles.fill0) {
    path = fillPaths[styles.fill0 - 1];
    if (!(styles.fill1 || styles.line)) {
      targetSegment = path.head();
      targetSegment.commands = [];
      targetSegment.data = [];
      targetSegment.morphData = isMorph ? [] : null;
    } else {
      targetSegment = path.addSegment([], [], isMorph ? [] : null);
    }
    var targetCommands = targetSegment.commands;
    var targetData = targetSegment.data;
    var targetMorphData = targetSegment.morphData;
    targetCommands.push(SHAPE_MOVE_TO);
    var j = data.length - 2;
    targetData.push(data[j], data[j + 1]);
    if (isMorph) {
      targetMorphData.push(morphData[j], morphData[j + 1]);
    }
    for (i = commands.length; i-- > 1; j -= 2) {
      command = commands[i];
      targetCommands.push(command);
      targetData.push(data[j - 2], data[j - 1]);
      if (isMorph) {
        targetMorphData.push(morphData[j - 2], morphData[j - 1]);
      }
      if (command === SHAPE_CURVE_TO) {
        targetData.push(data[j - 4], data[j - 3]);
        if (isMorph) {
          targetMorphData.push(morphData[j - 4], morphData[j - 3]);
        }
        j -= 2;
      }
    }
    if (isMorph) {
    }
  }
  if (styles.line && styles.fill1) {
    path = linePaths[styles.line - 1];
    path.addSegment(commands, data, morphData);
  }
}
function convertRecordsToStyledPaths(records, fillPaths, linePaths, dictionary, dependencies, recordsMorph) {
  var isMorph = recordsMorph !== null;
  var styles = {
      fill0: 0,
      fill1: 0,
      line: 0
    };
  var segment = null;
  var allFillPaths = fillPaths;
  var allLinePaths = linePaths;
  var numRecords = records.length - 1;
  var x = 0;
  var y = 0;
  var morphX = 0;
  var morphY = 0;
  var path;
  for (var i = 0, j = 0; i < numRecords; i++) {
    var record = records[i];
    var morphRecord;
    if (isMorph) {
      morphRecord = recordsMorph[j++];
    }
    if (record.type === 0) {
      if (segment) {
        applySegmentToStyles(segment, styles, linePaths, fillPaths, isMorph);
      }
      if (record.hasNewStyles) {
        fillPaths = createPathsList(record.fillStyles, false, dictionary, dependencies);
        push.apply(allFillPaths, fillPaths);
        linePaths = createPathsList(record.lineStyles, true, dictionary, dependencies);
        push.apply(allLinePaths, linePaths);
        styles = {
          fill0: 0,
          fill1: 0,
          line: 0
        };
      }
      if (record.hasFillStyle0) {
        styles.fill0 = record.fillStyle0;
      }
      if (record.hasFillStyle1) {
        styles.fill1 = record.fillStyle1;
      }
      if (record.hasLineStyle) {
        styles.line = record.lineStyle;
      }
      if (styles.fill1) {
        path = fillPaths[styles.fill1 - 1];
      } else if (styles.line) {
        path = linePaths[styles.line - 1];
      } else if (styles.fill0) {
        path = fillPaths[styles.fill0 - 1];
      }
      if (record.move) {
        x = record.moveX | 0;
        y = record.moveY | 0;
      }
      if (path) {
        segment = path.addSegment([], [], isMorph ? [] : null);
        segment.commands.push(SHAPE_MOVE_TO);
        segment.data.push(x, y);
        if (isMorph) {
          if (morphRecord.type === 0) {
            morphX = morphRecord.moveX | 0;
            morphY = morphRecord.moveY | 0;
          } else {
            morphX = x;
            morphY = y;
            j--;
          }
          segment.morphData.push(morphX, morphY);
        }
      }
    } else {
      if (isMorph) {
      }
      if (record.isStraight && (!isMorph || morphRecord.isStraight)) {
        x += record.deltaX | 0;
        y += record.deltaY | 0;
        segment.commands.push(SHAPE_LINE_TO);
        segment.data.push(x, y);
        if (isMorph) {
          morphX += morphRecord.deltaX | 0;
          morphY += morphRecord.deltaY | 0;
          segment.morphData.push(morphX, morphY);
        }
      } else {
        var cx, cy;
        var deltaX, deltaY;
        if (!record.isStraight) {
          cx = x + record.controlDeltaX | 0;
          cy = y + record.controlDeltaY | 0;
          x = cx + record.anchorDeltaX | 0;
          y = cy + record.anchorDeltaY | 0;
        } else {
          deltaX = record.deltaX | 0;
          deltaY = record.deltaY | 0;
          cx = x + (deltaX >> 1);
          cy = y + (deltaY >> 1);
          x += deltaX;
          y += deltaY;
        }
        segment.commands.push(SHAPE_CURVE_TO);
        segment.data.push(cx, cy, x, y);
        if (isMorph) {
          if (!morphRecord.isStraight) {
            cx = morphX + morphRecord.controlDeltaX | 0;
            cy = morphY + morphRecord.controlDeltaY | 0;
            morphX = cx + morphRecord.anchorDeltaX | 0;
            morphY = cy + morphRecord.anchorDeltaY | 0;
          } else {
            deltaX = morphRecord.deltaX | 0;
            deltaY = morphRecord.deltaY | 0;
            cx = morphX + (deltaX >> 1);
            cy = morphY + (deltaY >> 1);
            morphX += deltaX;
            morphY += deltaY;
          }
          segment.morphData.push(cx, cy, morphX, morphY);
        }
      }
    }
  }
  applySegmentToStyles(segment, styles, linePaths, fillPaths, isMorph);
  push.apply(allFillPaths, allLinePaths);
  var removeCount = 0;
  for (i = 0; i < allFillPaths.length; i++) {
    path = allFillPaths[i];
    if (!path.head()) {
      removeCount++;
      continue;
    }
    allFillPaths[i - removeCount] = segmentedPathToShapePath(path, isMorph);
  }
  allFillPaths.length -= removeCount;
  return allFillPaths;
}
function segmentedPathToShapePath(path, isMorph) {
  var start = path.head();
  var end = start;
  var finalRoot = null;
  var finalHead = null;
  var skippedMoves = 0;
  var current = start.prev;
  while (start) {
    while (current) {
      if (path.segmentsConnect(current, start)) {
        if (current.next !== start) {
          path.removeSegment(current);
          path.insertSegment(current, start);
        }
        start = current;
        current = start.prev;
        skippedMoves++;
        continue;
      }
      if (path.segmentsConnect(end, current)) {
        path.removeSegment(current);
        end.next = current;
        current = current.prev;
        end.next.prev = end;
        end.next.next = null;
        end = end.next;
        skippedMoves++;
        continue;
      }
      current = current.prev;
    }
    current = start.prev;
    if (!finalRoot) {
      finalRoot = start;
      finalHead = end;
    } else {
      finalHead.next = start;
      start.prev = finalHead;
      finalHead = end;
      finalHead.next = null;
    }
    if (!current) {
      break;
    }
    start = end = current;
    current = start.prev;
  }
  var totalCommandsLength = -skippedMoves;
  var totalDataLength = -skippedMoves << 1;
  current = finalRoot;
  while (current) {
    totalCommandsLength += current.commands.length;
    totalDataLength += current.data.length;
    current = current.next;
  }
  var shape = new ShapePath(path.fillStyle, path.lineStyle, totalCommandsLength, totalDataLength, isMorph);
  var allCommands = shape.commands;
  var allData = shape.data;
  var allMorphData = shape.morphData;
  var commandsIndex = 0;
  var dataIndex = 0;
  current = finalRoot;
  while (current) {
    var offset = 0;
    var commands = current.commands;
    var data = current.data;
    var morphData = current.morphData;
    if (data[0] === allData[dataIndex - 2] && data[1] === allData[dataIndex - 1]) {
      offset = 1;
    }
    for (var i = offset; i < commands.length; i++, commandsIndex++) {
      allCommands[commandsIndex] = commands[i];
    }
    for (i = offset << 1; i < data.length; i++, dataIndex++) {
      allData[dataIndex] = data[i];
      if (isMorph) {
        allMorphData[dataIndex] = morphData[i];
      }
    }
    current = current.next;
  }
  return shape;
}
var CAPS_STYLE_TYPES = [
    'round',
    'none',
    'square'
  ];
var JOIN_STYLE_TYPES = [
    'round',
    'bevel',
    'miter'
  ];
function processStyle(style, isLineStyle, dictionary, dependencies) {
  if (isLineStyle) {
    style.lineCap = CAPS_STYLE_TYPES[style.endCapStyle | 0];
    style.lineJoin = JOIN_STYLE_TYPES[style.joinStyle | 0];
    style.miterLimit = style.miterLimitFactor * 2;
    if (!style.color && style.hasFill) {
      var fillStyle = processStyle(style.fillStyle, false, dictionary, dependencies);
      style.style = fillStyle.style;
      style.type = fillStyle.type;
      style.transform = fillStyle.transform;
      style.records = fillStyle.records;
      style.focalPoint = fillStyle.focalPoint;
      style.bitmapId = fillStyle.bitmapId;
      style.repeat = fillStyle.repeat;
      style.fillStyle = null;
      return style;
    }
  }
  var color;
  if (style.type === undefined || style.type === GRAPHICS_FILL_SOLID) {
    color = style.color;
    style.style = 'rgba(' + color.red + ',' + color.green + ',' + color.blue + ',' + color.alpha / 255 + ')';
    style.color = null;
    return style;
  }
  var scale;
  switch (style.type) {
  case GRAPHICS_FILL_LINEAR_GRADIENT:
  case GRAPHICS_FILL_RADIAL_GRADIENT:
  case GRAPHICS_FILL_FOCAL_RADIAL_GRADIENT:
    scale = 819.2;
    break;
  case GRAPHICS_FILL_REPEATING_BITMAP:
  case GRAPHICS_FILL_CLIPPED_BITMAP:
  case GRAPHICS_FILL_NONSMOOTHED_REPEATING_BITMAP:
  case GRAPHICS_FILL_NONSMOOTHED_CLIPPED_BITMAP:
    if (dictionary[style.bitmapId]) {
      dependencies.push(dictionary[style.bitmapId].id);
      scale = 0.05;
    }
    break;
  default:
    fail('invalid fill style', 'shape');
  }
  if (!style.matrix) {
    return style;
  }
  var matrix = style.matrix;
  style.transform = {
    a: matrix.a * scale,
    b: matrix.b * scale,
    c: matrix.c * scale,
    d: matrix.d * scale,
    e: matrix.tx,
    f: matrix.ty
  };
  style.matrix = null;
  return style;
}
function createPathsList(styles, isLineStyle, dictionary, dependencies) {
  var paths = [];
  for (var i = 0; i < styles.length; i++) {
    var style = processStyle(styles[i], isLineStyle, dictionary, dependencies);
    if (!isLineStyle) {
      paths[i] = new SegmentedPath(style, null);
    } else {
      paths[i] = new SegmentedPath(null, style);
    }
  }
  return paths;
}
function defineShape(tag, dictionary) {
  var dependencies = [];
  var fillPaths = createPathsList(tag.fillStyles, false, dictionary, dependencies);
  var linePaths = createPathsList(tag.lineStyles, true, dictionary, dependencies);
  var paths = convertRecordsToStyledPaths(tag.records, fillPaths, linePaths, dictionary, dependencies, tag.recordsMorph || null);
  if (tag.bboxMorph) {
    var mbox = tag.bboxMorph;
    extendBoundsByPoint(tag.bbox, mbox.xMin, mbox.yMin);
    extendBoundsByPoint(tag.bbox, mbox.xMax, mbox.yMax);
    mbox = tag.strokeBboxMorph;
    if (mbox) {
      extendBoundsByPoint(tag.strokeBbox, mbox.xMin, mbox.yMin);
      extendBoundsByPoint(tag.strokeBbox, mbox.xMax, mbox.yMax);
    }
  }
  return {
    type: 'shape',
    id: tag.id,
    strokeBbox: tag.strokeBbox,
    strokeBboxMorph: tag.strokeBboxMorph,
    bbox: tag.bbox,
    bboxMorph: tag.bboxMorph,
    isMorph: tag.isMorph,
    paths: paths,
    require: dependencies.length ? dependencies : null
  };
}
function SegmentedPath(fillStyle, lineStyle) {
  this.fillStyle = fillStyle;
  this.lineStyle = lineStyle;
  this._head = null;
}
SegmentedPath.prototype = {
  addSegment: function (commands, data, morphData) {
    var segment = {
        commands: commands,
        data: data,
        morphData: morphData,
        prev: this._head,
        next: null
      };
    if (this._head) {
      this._head.next = segment;
    }
    this._head = segment;
    return segment;
  },
  removeSegment: function (segment) {
    if (segment.prev) {
      segment.prev.next = segment.next;
    }
    if (segment.next) {
      segment.next.prev = segment.prev;
    }
  },
  insertSegment: function (segment, next) {
    var prev = next.prev;
    segment.prev = prev;
    segment.next = next;
    if (prev) {
      prev.next = segment;
    }
    next.prev = segment;
  },
  head: function () {
    return this._head;
  },
  segmentsConnect: function (first, second) {
    var firstLength = first.data.length;
    return first.data[firstLength - 2] === second.data[0] && first.data[firstLength - 1] === second.data[1];
  }
};
var SHAPE_MOVE_TO = 1;
var SHAPE_LINE_TO = 2;
var SHAPE_CURVE_TO = 3;
var SHAPE_WIDE_MOVE_TO = 4;
var SHAPE_WIDE_LINE_TO = 5;
var SHAPE_CUBIC_CURVE_TO = 6;
var SHAPE_CIRCLE = 7;
var SHAPE_ELLIPSE = 8;
function ShapePath(fillStyle, lineStyle, commandsCount, dataLength, isMorph) {
  this.fillStyle = fillStyle;
  this.lineStyle = lineStyle;
  if (commandsCount) {
    this.commands = new Uint8Array(commandsCount);
    this.data = new Int32Array(dataLength);
    this.morphData = isMorph ? new Int32Array(dataLength) : null;
  } else {
    this.commands = [];
    this.data = [];
  }
  this.bounds = null;
  this.strokeBounds = null;
  this.isMorph = isMorph;
  this.fullyInitialized = false;
}
ShapePath.prototype = {
  moveTo: function (x, y) {
    if (this.commands[this.commands.length - 1] === SHAPE_MOVE_TO) {
      this.data[this.data.length - 2] = x;
      this.data[this.data.length - 1] = y;
      return;
    }
    this.commands.push(SHAPE_MOVE_TO);
    this.data.push(x, y);
  },
  lineTo: function (x, y) {
    this.commands.push(SHAPE_LINE_TO);
    this.data.push(x, y);
  },
  curveTo: function (controlX, controlY, anchorX, anchorY) {
    this.commands.push(SHAPE_CURVE_TO);
    this.data.push(controlX, controlY, anchorX, anchorY);
  },
  cubicCurveTo: function (control1X, control1Y, control2X, control2Y, anchorX, anchorY) {
    this.commands.push(SHAPE_CUBIC_CURVE_TO);
    this.data.push(control1X, control1Y, control2X, control2Y, anchorX, anchorY);
  },
  rect: function (x, y, w, h) {
    var x2 = x + w;
    var y2 = y + h;
    this.commands.push(SHAPE_MOVE_TO, SHAPE_LINE_TO, SHAPE_LINE_TO, SHAPE_LINE_TO, SHAPE_LINE_TO);
    this.data.push(x, y, x2, y, x2, y2, x, y2, x, y);
  },
  circle: function (x, y, radius) {
    this.commands.push(SHAPE_CIRCLE);
    this.data.push(x, y, radius);
  },
  ellipse: function (x, y, radiusX, radiusY) {
    this.commands.push(SHAPE_ELLIPSE);
    this.data.push(x, y, radiusX, radiusY);
  },
  draw: function (ctx, clip, ratio, colorTransform) {
    if (clip && !this.fillStyle) {
      return;
    }
    ctx.beginPath();
    var commands = this.commands;
    var data = this.data;
    var morphData = this.morphData;
    var formOpen = false;
    var formOpenX = 0;
    var formOpenY = 0;
    for (var j = 0, k = 0; j < commands.length; j++) {
      if (!this.isMorph) {
        switch (commands[j]) {
        case SHAPE_MOVE_TO:
          formOpen = true;
          formOpenX = data[k++] / 20;
          formOpenY = data[k++] / 20;
          ctx.moveTo(formOpenX, formOpenY);
          break;
        case SHAPE_WIDE_MOVE_TO:
          ctx.moveTo(data[k++] / 20, data[k++] / 20);
          k += 2;
          break;
        case SHAPE_LINE_TO:
          ctx.lineTo(data[k++] / 20, data[k++] / 20);
          break;
        case SHAPE_WIDE_LINE_TO:
          ctx.lineTo(data[k++] / 20, data[k++] / 20);
          k += 2;
          break;
        case SHAPE_CURVE_TO:
          ctx.quadraticCurveTo(data[k++] / 20, data[k++] / 20, data[k++] / 20, data[k++] / 20);
          break;
        case SHAPE_CUBIC_CURVE_TO:
          ctx.bezierCurveTo(data[k++] / 20, data[k++] / 20, data[k++] / 20, data[k++] / 20, data[k++] / 20, data[k++] / 20);
          break;
        case SHAPE_CIRCLE:
          if (formOpen) {
            ctx.lineTo(formOpenX, formOpenY);
            formOpen = false;
          }
          ctx.moveTo((data[k] + data[k + 2]) / 20, data[k + 1] / 20);
          ctx.arc(data[k++] / 20, data[k++] / 20, data[k++] / 20, 0, Math.PI * 2, false);
          break;
        case SHAPE_ELLIPSE:
          if (formOpen) {
            ctx.lineTo(formOpenX, formOpenY);
            formOpen = false;
          }
          var x = data[k++];
          var y = data[k++];
          var rX = data[k++];
          var rY = data[k++];
          var radius;
          if (rX !== rY) {
            ctx.save();
            var ellipseScale;
            if (rX > rY) {
              ellipseScale = rX / rY;
              radius = rY;
              x /= ellipseScale;
              ctx.scale(ellipseScale, 1);
            } else {
              ellipseScale = rY / rX;
              radius = rX;
              y /= ellipseScale;
              ctx.scale(1, ellipseScale);
            }
          }
          ctx.moveTo((x + radius) / 20, y / 20);
          ctx.arc(x / 20, y / 20, radius / 20, 0, Math.PI * 2, false);
          if (rX !== rY) {
            ctx.restore();
          }
          break;
        default:
          console.warn('Unknown drawing command encountered: ' + commands[j]);
        }
      } else {
        switch (commands[j]) {
        case SHAPE_MOVE_TO:
          ctx.moveTo(morph(data[k] / 20, morphData[k++] / 20, ratio), morph(data[k] / 20, morphData[k++] / 20, ratio));
          break;
        case SHAPE_LINE_TO:
          ctx.lineTo(morph(data[k] / 20, morphData[k++] / 20, ratio), morph(data[k] / 20, morphData[k++] / 20, ratio));
          break;
        case SHAPE_CURVE_TO:
          ctx.quadraticCurveTo(morph(data[k] / 20, morphData[k++] / 20, ratio), morph(data[k] / 20, morphData[k++] / 20, ratio), morph(data[k] / 20, morphData[k++] / 20, ratio), morph(data[k] / 20, morphData[k++] / 20, ratio));
          break;
        default:
          console.warn('Drawing command not supported for morph shapes: ' + commands[j]);
        }
      }
    }
    if (!clip) {
      var fillStyle = this.fillStyle;
      if (fillStyle) {
        colorTransform.setFillStyle(ctx, fillStyle.style);
        ctx.imageSmoothingEnabled = ctx.mozImageSmoothingEnabled = fillStyle.smooth;
        var m = fillStyle.transform;
        ctx.save();
        colorTransform.setAlpha(ctx);
        if (m) {
          ctx.transform(m.a, m.b, m.c, m.d, m.e / 20, m.f / 20);
        }
        ctx.fill();
        ctx.restore();
      }
      var lineStyle = this.lineStyle;
      if (lineStyle) {
        colorTransform.setStrokeStyle(ctx, lineStyle.style);
        ctx.save();
        colorTransform.setAlpha(ctx);
        ctx.lineWidth = Math.max(lineStyle.width / 20, 1);
        ctx.lineCap = lineStyle.lineCap;
        ctx.lineJoin = lineStyle.lineJoin;
        ctx.miterLimit = lineStyle.miterLimit;
        ctx.stroke();
        ctx.restore();
      }
    }
    ctx.closePath();
  },
  isPointInPath: function (x, y) {
    if (!(this.fillStyle || this.lineStyle)) {
      return false;
    }
    var bounds = this.strokeBounds || this.bounds || this._calculateBounds();
    if (x < bounds.xMin || x > bounds.xMax || y < bounds.yMin || y > bounds.yMax) {
      return false;
    }
    if (this.fillStyle && this.isPointInFill(x, y)) {
      return true;
    }
    return this.lineStyle && this.lineStyle.width !== undefined && this.isPointInStroke(x, y);
  },
  isPointInFill: function (x, y) {
    var commands = this.commands;
    var data = this.data;
    var length = commands.length;
    var inside = false;
    var fromX = 0;
    var fromY = 0;
    var toX = 0;
    var toY = 0;
    var localX;
    var localY;
    var cpX;
    var cpY;
    var rX;
    var rY;
    var formOpen = false;
    var formOpenX = 0;
    var formOpenY = 0;
    for (var commandIndex = 0, dataIndex = 0; commandIndex < length; commandIndex++) {
      switch (commands[commandIndex]) {
      case SHAPE_WIDE_MOVE_TO:
        dataIndex += 2;
      case SHAPE_MOVE_TO:
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        if (formOpen && intersectsLine(x, y, fromX, fromY, formOpenX, formOpenY)) {
          inside = !inside;
        }
        formOpen = true;
        formOpenX = toX;
        formOpenY = toY;
        break;
      case SHAPE_WIDE_LINE_TO:
        dataIndex += 2;
      case SHAPE_LINE_TO:
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        if (intersectsLine(x, y, fromX, fromY, toX, toY)) {
          inside = !inside;
        }
        break;
      case SHAPE_CURVE_TO:
        cpX = data[dataIndex++];
        cpY = data[dataIndex++];
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        if (cpY > y === fromY > y && toY > y === fromY > y) {
          break;
        }
        if (fromX >= x && cpX >= x && toX >= x) {
          inside = !inside;
          break;
        }
        var a = fromY - 2 * cpY + toY;
        var c = fromY - y;
        var b = 2 * (cpY - fromY);
        var d = b * b - 4 * a * c;
        if (d < 0) {
          break;
        }
        d = Math.sqrt(d);
        a = 1 / (a + a);
        var t1 = (d - b) * a;
        var t2 = (-b - d) * a;
        if (t1 >= 0 && t1 <= 1 && quadraticBezier(fromX, cpX, toX, t1) > x) {
          inside = !inside;
        }
        if (t2 >= 0 && t2 <= 1 && quadraticBezier(fromX, cpX, toX, t2) > x) {
          inside = !inside;
        }
        break;
      case SHAPE_CUBIC_CURVE_TO:
        cpX = data[dataIndex++];
        cpY = data[dataIndex++];
        var cp2X = data[dataIndex++];
        var cp2Y = data[dataIndex++];
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        if (cpY > y === fromY > y && cp2Y > y === fromY > y && toY > y === fromY > y) {
          break;
        }
        if (fromX >= x && cpX >= x && cp2X >= x && toX >= x) {
          inside = !inside;
          break;
        }
        var roots = cubicXAtY(fromX, fromY, cpX, cpY, cp2X, cp2Y, toX, toY, y);
        for (var i = roots.length; i--;) {
          if (roots[i] >= x) {
            inside = !inside;
          }
        }
        break;
      case SHAPE_CIRCLE:
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        var r = data[dataIndex++];
        localX = x - toX;
        localY = y - toY;
        if (localX * localX + localY * localY < r * r) {
          inside = !inside;
        }
        toX += r;
        break;
      case SHAPE_ELLIPSE:
        cpX = data[dataIndex++];
        cpY = data[dataIndex++];
        rX = data[dataIndex++];
        rY = data[dataIndex++];
        localX = x - cpX;
        localY = y - cpY;
        if (localX * localX / (rX * rX) + localY * localY / (rY * rY) <= 1) {
          inside = !inside;
        }
        toX = cpX + rX;
        toY = cpY;
        break;
      default:
        if (!inWorker) {
          console.warn('Drawing command not handled in isPointInPath: ' + commands[commandIndex]);
        }
      }
      fromX = toX;
      fromY = toY;
    }
    if (formOpen && intersectsLine(x, y, fromX, fromY, formOpenX, formOpenY)) {
      inside = !inside;
    }
    return inside;
  },
  isPointInStroke: function (x, y) {
    var commands = this.commands;
    var data = this.data;
    var length = commands.length;
    var width = this.lineStyle.width;
    var halfWidth = width / 2;
    var halfWidthSq = halfWidth * halfWidth;
    var minX = x - halfWidth;
    var maxX = x + halfWidth;
    var minY = y - halfWidth;
    var maxY = y + halfWidth;
    var fromX = 0;
    var fromY = 0;
    var toX = 0;
    var toY = 0;
    var localX;
    var localY;
    var cpX;
    var cpY;
    var rX;
    var rY;
    var curveX;
    var curveY;
    var t;
    for (var commandIndex = 0, dataIndex = 0; commandIndex < length; commandIndex++) {
      switch (commands[commandIndex]) {
      case SHAPE_WIDE_MOVE_TO:
        dataIndex += 2;
      case SHAPE_MOVE_TO:
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        break;
      case SHAPE_WIDE_LINE_TO:
        dataIndex += 2;
      case SHAPE_LINE_TO:
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        if (fromX === toX && fromY === toY) {
          break;
        }
        if (maxX < fromX && maxX < toX || minX > fromX && minX > toX || maxY < fromY && maxY < toY || minY > fromY && minY > toY) {
          break;
        }
        if (toX === fromX || toY === fromY) {
          return true;
        }
        t = ((x - fromX) * (toX - fromX) + (y - fromY) * (toY - fromY)) / distanceSq(fromX, fromY, toX, toY);
        if (t < 0) {
          if (distanceSq(x, y, fromX, fromY) <= halfWidthSq) {
            return true;
          }
          break;
        }
        if (t > 1) {
          if (distanceSq(x, y, toX, toY) <= halfWidthSq) {
            return true;
          }
          break;
        }
        if (distanceSq(x, y, fromX + t * (toX - fromX), fromY + t * (toY - fromY)) <= halfWidthSq) {
          return true;
        }
        break;
      case SHAPE_CURVE_TO:
        cpX = data[dataIndex++];
        cpY = data[dataIndex++];
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        var extremeX = quadraticBezierExtreme(fromX, cpX, toX);
        if (maxX < fromX && maxX < extremeX && maxX < toX || minX > fromX && minX > extremeX && minX > toX) {
          break;
        }
        var extremeY = quadraticBezierExtreme(fromY, cpY, toY);
        if (maxY < fromY && maxY < extremeY && maxY < toY || minY > fromY && minY > extremeY && minY > toY) {
          break;
        }
        for (t = 0; t < 1; t += 0.02) {
          curveX = quadraticBezier(fromX, cpX, toX, t);
          if (curveX < minX || curveX > maxX) {
            continue;
          }
          curveY = quadraticBezier(fromY, cpY, toY, t);
          if (curveY < minY || curveY > maxY) {
            continue;
          }
          if ((x - curveX) * (x - curveX) + (y - curveY) * (y - curveY) < halfWidthSq) {
            return true;
          }
        }
        break;
      case SHAPE_CUBIC_CURVE_TO:
        cpX = data[dataIndex++];
        cpY = data[dataIndex++];
        var cp2X = data[dataIndex++];
        var cp2Y = data[dataIndex++];
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        var extremesX = cubicBezierExtremes(fromX, cpX, cp2X, toX);
        while (extremesX.length < 2) {
          extremesX.push(toX);
        }
        if (maxX < fromX && maxX < toX && maxX < extremesX[0] && maxX < extremesX[1] || minX > fromX && minX > toX && minX > extremesX[0] && minX > extremesX[1]) {
          break;
        }
        var extremesY = cubicBezierExtremes(fromY, cpY, cp2Y, toY);
        while (extremesY.length < 2) {
          extremesY.push(toY);
        }
        if (maxY < fromY && maxY < toY && maxY < extremesY[0] && maxY < extremesY[1] || minY > fromY && minY > toY && minY > extremesY[0] && minY > extremesY[1]) {
          break;
        }
        for (t = 0; t < 1; t += 0.02) {
          curveX = cubicBezier(fromX, cpX, cp2X, toX, t);
          if (curveX < minX || curveX > maxX) {
            continue;
          }
          curveY = cubicBezier(fromY, cpY, cp2Y, toY, t);
          if (curveY < minY || curveY > maxY) {
            continue;
          }
          if ((x - curveX) * (x - curveX) + (y - curveY) * (y - curveY) < halfWidthSq) {
            return true;
          }
        }
        break;
      case SHAPE_CIRCLE:
        cpX = data[dataIndex++];
        cpY = data[dataIndex++];
        var r = data[dataIndex++];
        toX = cpX + r;
        toY = cpY;
        if (maxX < cpX - r || minX > cpX + r || maxY < cpY - r || minY > cpY + r) {
          break;
        }
        localX = x - cpX;
        localY = y - cpY;
        var rMin = r - halfWidth;
        var rMax = r + halfWidth;
        var distSq = localX * localX + localY * localY;
        if (distSq >= rMin * rMin && distSq <= rMax * rMax) {
          return true;
        }
        break;
      case SHAPE_ELLIPSE:
        cpX = data[dataIndex++];
        cpY = data[dataIndex++];
        rX = data[dataIndex++];
        rY = data[dataIndex++];
        toX = cpX + rX;
        toY = cpY;
        localX = Math.abs(x - cpX);
        localY = Math.abs(y - cpY);
        localX -= halfWidth;
        localY -= halfWidth;
        if (localX * localX / (rX * rX) + localY * localY / (rY * rY) > 1) {
          break;
        }
        localX += width;
        localY += width;
        if (localX * localX / (rX * rX) + localY * localY / (rY * rY) > 1) {
          return true;
        }
        break;
      default:
        if (!inWorker) {
          console.warn('Drawing command not handled in isPointInPath: ' + commands[commandIndex]);
        }
      }
      fromX = toX;
      fromY = toY;
    }
    return false;
  },
  getBounds: function (includeStroke) {
    var bounds = includeStroke ? this.strokeBounds : this.bounds;
    if (!bounds) {
      this._calculateBounds();
      bounds = includeStroke ? this.strokeBounds : this.bounds;
    }
    return bounds;
  },
  _calculateBounds: function () {
    var commands = this.commands;
    var data = this.data;
    var length = commands.length;
    var bounds;
    if (commands[0] === SHAPE_MOVE_TO || commands[0] > SHAPE_CUBIC_CURVE_TO) {
      bounds = {
        xMin: data[0],
        yMin: data[1]
      };
    } else {
      bounds = {
        xMin: 0,
        yMin: 0
      };
    }
    bounds.xMax = bounds.xMin;
    bounds.yMax = bounds.yMin;
    var fromX = bounds.xMin;
    var fromY = bounds.yMin;
    for (var commandIndex = 0, dataIndex = 0; commandIndex < length; commandIndex++) {
      var toX;
      var toY;
      var cpX;
      var cpY;
      switch (commands[commandIndex]) {
      case SHAPE_WIDE_MOVE_TO:
        dataIndex += 2;
      case SHAPE_MOVE_TO:
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        extendBoundsByPoint(bounds, toX, toY);
        break;
      case SHAPE_WIDE_LINE_TO:
        dataIndex += 2;
      case SHAPE_LINE_TO:
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        extendBoundsByPoint(bounds, toX, toY);
        break;
      case SHAPE_CURVE_TO:
        cpX = data[dataIndex++];
        cpY = data[dataIndex++];
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        extendBoundsByPoint(bounds, toX, toY);
        if (cpX < fromX || cpX > toX) {
          extendBoundsByX(bounds, quadraticBezierExtreme(fromX, cpX, toX));
        }
        if (cpY < fromY || cpY > toY) {
          extendBoundsByY(bounds, quadraticBezierExtreme(fromY, cpY, toY));
        }
        break;
      case SHAPE_CUBIC_CURVE_TO:
        cpX = data[dataIndex++];
        cpY = data[dataIndex++];
        var cp2X = data[dataIndex++];
        var cp2Y = data[dataIndex++];
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        extendBoundsByPoint(bounds, toX, toY);
        var extremes;
        var i;
        if (cpX < fromX || cp2X < fromX || cpX > toX || cp2X > toX) {
          extremes = cubicBezierExtremes(fromX, cpX, cp2X, toX);
          for (i = extremes.length; i--;) {
            extendBoundsByX(bounds, extremes[i]);
          }
        }
        if (cpY < fromY || cp2Y < fromY || cpY > toY || cp2Y > toY) {
          extremes = cubicBezierExtremes(fromY, cpY, cp2Y, toY);
          for (i = extremes.length; i--;) {
            extendBoundsByY(bounds, extremes[i]);
          }
        }
        break;
      case SHAPE_CIRCLE:
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        var radius = data[dataIndex++];
        extendBoundsByPoint(bounds, toX - radius, toY - radius);
        extendBoundsByPoint(bounds, toX + radius, toY + radius);
        toX += radius;
        break;
      case SHAPE_ELLIPSE:
        toX = data[dataIndex++];
        toY = data[dataIndex++];
        var radiusX = data[dataIndex++];
        var radiusY = data[dataIndex++];
        extendBoundsByPoint(bounds, toX - radiusX, toY - radiusY);
        extendBoundsByPoint(bounds, toX + radiusX, toY + radiusY);
        toX += radiusX;
        break;
      default:
        if (!inWorker) {
          console.warn('Drawing command not handled in bounds calculation: ' + commands[commandIndex]);
        }
      }
      fromX = toX;
      fromY = toY;
    }
    this.bounds = bounds;
    if (this.lineStyle) {
      var halfLineWidth = this.lineStyle.width / 2;
      this.strokeBounds = {
        xMin: bounds.xMin - halfLineWidth,
        yMin: bounds.yMin - halfLineWidth,
        xMax: bounds.xMax + halfLineWidth,
        yMax: bounds.yMax + halfLineWidth
      };
      return this.strokeBounds;
    } else {
      this.strokeBounds = bounds;
    }
    return bounds;
  }
};
function distanceSq(x1, y1, x2, y2) {
  var dX = x2 - x1;
  var dY = y2 - y1;
  return dX * dX + dY * dY;
}
function intersectsLine(x, y, x1, y1, x2, y2) {
  return y2 > y !== y1 > y && x < (x1 - x2) * (y - y2) / (y1 - y2) + x2;
}
function quadraticBezier(from, cp, to, t) {
  var inverseT = 1 - t;
  return from * inverseT * inverseT + 2 * cp * inverseT * t + to * t * t;
}
function quadraticBezierExtreme(from, cp, to) {
  var t = (from - cp) / (from - 2 * cp + to);
  if (t < 0) {
    return from;
  }
  if (t > 1) {
    return to;
  }
  return quadraticBezier(from, cp, to, t);
}
function cubicBezier(from, cp, cp2, to, t) {
  var tSq = t * t;
  var inverseT = 1 - t;
  var inverseTSq = inverseT * inverseT;
  return from * inverseT * inverseTSq + 3 * cp * t * inverseTSq + 3 * cp2 * inverseT * tSq + to * t * tSq;
}
function cubicBezierExtremes(from, cp, cp2, to) {
  var d1 = cp - from;
  var d2 = cp2 - cp;
  d2 *= 2;
  var d3 = to - cp2;
  if (d1 + d3 === d2) {
    d3 *= 1.0001;
  }
  var fHead = 2 * d1 - d2;
  var part1 = d2 - 2 * d1;
  var fCenter = Math.sqrt(part1 * part1 - 4 * d1 * (d1 - d2 + d3));
  var fTail = 2 * (d1 - d2 + d3);
  var t1 = (fHead + fCenter) / fTail;
  var t2 = (fHead - fCenter) / fTail;
  var result = [];
  if (t1 >= 0 && t1 <= 1) {
    result.push(cubicBezier(from, cp, cp2, to, t1));
  }
  if (t2 >= 0 && t2 <= 1) {
    result.push(cubicBezier(from, cp, cp2, to, t2));
  }
  return result;
}
function cubicXAtY(x0, y0, cx, cy, cx1, cy1, x1, y1, y) {
  var dX = 3 * (cx - x0);
  var dY = 3 * (cy - y0);
  var bX = 3 * (cx1 - cx) - dX;
  var bY = 3 * (cy1 - cy) - dY;
  var c3X = x1 - x0 - dX - bX;
  var c3Y = y1 - y0 - dY - bY;
  function f(t) {
    return t * (dY + t * (bY + t * c3Y)) + y0 - y;
  }
  function pointAt(t) {
    if (t < 0) {
      t = 0;
    } else if (t > 1) {
      t = 1;
    }
    return x0 + t * (dX + t * (bX + t * c3X));
  }
  function bisectCubicBezierRange(f, l, r, limit) {
    if (Math.abs(r - l) <= limit) {
      return;
    }
    var middle = 0.5 * (l + r);
    if (f(l) * f(r) <= 0) {
      left = l;
      right = r;
      return;
    }
    bisectCubicBezierRange(f, l, middle, limit);
    bisectCubicBezierRange(f, middle, r, limit);
  }
  var left = 0;
  var right = 1;
  bisectCubicBezierRange(f, 0, 1, 0.05);
  var t0 = findRoot(left, right, f, 50, 0.000001);
  var evalResult = Math.abs(f(t0));
  if (evalResult > 0.00001) {
    return [];
  }
  var result = [];
  if (t0 <= 1) {
    result.push(pointAt(t0));
  }
  var a = c3Y;
  var b = t0 * a + bY;
  var c = t0 * b + dY;
  var d = b * b - 4 * a * c;
  if (d < 0) {
    return result;
  }
  d = Math.sqrt(d);
  a = 1 / (a + a);
  var t1 = (d - b) * a;
  var t2 = (-b - d) * a;
  if (t1 >= 0 && t1 <= 1) {
    result.push(pointAt(t1));
  }
  if (t2 >= 0 && t2 <= 1) {
    result.push(pointAt(t2));
  }
  return result;
}
function findRoot(x0, x2, f, maxIterations, epsilon) {
  var x1;
  var y0;
  var y1;
  var y2;
  var b;
  var c;
  var y10;
  var y20;
  var y21;
  var xm;
  var ym;
  var temp;
  var xmlast = x0;
  y0 = f(x0);
  if (y0 === 0) {
    return x0;
  }
  y2 = f(x2);
  if (y2 === 0) {
    return x2;
  }
  if (y2 * y0 > 0) {
    return x0;
  }
  var __iter = 0;
  for (var i = 0; i < maxIterations; ++i) {
    __iter++;
    x1 = 0.5 * (x2 + x0);
    y1 = f(x1);
    if (y1 === 0) {
      return x1;
    }
    if (Math.abs(x1 - x0) < epsilon) {
      return x1;
    }
    if (y1 * y0 > 0) {
      temp = x0;
      x0 = x2;
      x2 = temp;
      temp = y0;
      y0 = y2;
      y2 = temp;
    }
    y10 = y1 - y0;
    y21 = y2 - y1;
    y20 = y2 - y0;
    if (y2 * y20 < 2 * y1 * y10) {
      x2 = x1;
      y2 = y1;
    } else {
      b = (x1 - x0) / y10;
      c = (y10 - y21) / (y21 * y20);
      xm = x0 - b * y0 * (1 - c * y1);
      ym = f(xm);
      if (ym === 0) {
        return xm;
      }
      if (Math.abs(xm - xmlast) < epsilon) {
        return xm;
      }
      xmlast = xm;
      if (ym * y0 < 0) {
        x2 = xm;
        y2 = ym;
      } else {
        x0 = xm;
        y0 = ym;
        x2 = x1;
        y2 = y1;
      }
    }
  }
  return x1;
}
function extendBoundsByPoint(bounds, x, y) {
  if (x < bounds.xMin) {
    bounds.xMin = x;
  } else if (x > bounds.xMax) {
    bounds.xMax = x;
  }
  if (y < bounds.yMin) {
    bounds.yMin = y;
  } else if (y > bounds.yMax) {
    bounds.yMax = y;
  }
}
function extendBoundsByX(bounds, x) {
  if (x < bounds.xMin) {
    bounds.xMin = x;
  } else if (x > bounds.xMax) {
    bounds.xMax = x;
  }
}
function extendBoundsByY(bounds, y) {
  if (y < bounds.yMin) {
    bounds.yMin = y;
  } else if (y > bounds.yMax) {
    bounds.yMax = y;
  }
}
function morph(start, end, ratio) {
  return start + (end - start) * ratio;
}
function finishShapePaths(paths, dictionary) {
  for (var i = 0; i < paths.length; i++) {
    var path = paths[i];
    if (path.fullyInitialized) {
      continue;
    }
    if (!(path instanceof ShapePath)) {
      var untypedPath = path;
      path = paths[i] = new ShapePath(path.fillStyle, path.lineStyle, 0, 0, path.isMorph);
      path.commands = untypedPath.commands;
      path.data = untypedPath.data;
      path.morphData = untypedPath.morphData;
    }
    path.fillStyle && initStyle(path.fillStyle, dictionary);
    path.lineStyle && initStyle(path.lineStyle, dictionary);
    path.fullyInitialized = true;
  }
}
var inWorker = typeof window === 'undefined';
var factoryCtx = !inWorker ? document.createElement('canvas').getContext('2d') : null;
function buildLinearGradientFactory(colorStops) {
  var defaultGradient = factoryCtx.createLinearGradient(-1, 0, 1, 0);
  for (var i = 0; i < colorStops.length; i++) {
    defaultGradient.addColorStop(colorStops[i].ratio, colorStops[i].color);
  }
  var fn = function createLinearGradient(ctx, colorTransform) {
    var gradient = ctx.createLinearGradient(-1, 0, 1, 0);
    for (var i = 0; i < colorStops.length; i++) {
      colorTransform.addGradientColorStop(gradient, colorStops[i].ratio, colorStops[i].color);
    }
    return gradient;
  };
  fn.defaultGradient = defaultGradient;
  return fn;
}
function buildRadialGradientFactory(focalPoint, colorStops) {
  var defaultGradient = factoryCtx.createRadialGradient(focalPoint, 0, 0, 0, 0, 1);
  for (var i = 0; i < colorStops.length; i++) {
    defaultGradient.addColorStop(colorStops[i].ratio, colorStops[i].color);
  }
  var fn = function createRadialGradient(ctx, colorTransform) {
    var gradient = ctx.createRadialGradient(focalPoint, 0, 0, 0, 0, 1);
    for (var i = 0; i < colorStops.length; i++) {
      colorTransform.addGradientColorStop(gradient, colorStops[i].ratio, colorStops[i].color);
    }
    return gradient;
  };
  fn.defaultGradient = defaultGradient;
  return fn;
}
function initStyle(style, dictionary) {
  if (style.type === undefined) {
    return;
  }
  switch (style.type) {
  case GRAPHICS_FILL_SOLID:
    break;
  case GRAPHICS_FILL_LINEAR_GRADIENT:
  case GRAPHICS_FILL_RADIAL_GRADIENT:
  case GRAPHICS_FILL_FOCAL_RADIAL_GRADIENT:
    var records = style.records, colorStops = [];
    for (var j = 0, n = records.length; j < n; j++) {
      var record = records[j];
      var colorStr = rgbaObjToStr(record.color);
      colorStops.push({
        ratio: record.ratio / 255,
        color: colorStr
      });
    }
    var gradientConstructor;
    var isLinear = style.type === GRAPHICS_FILL_LINEAR_GRADIENT;
    if (isLinear) {
      gradientConstructor = buildLinearGradientFactory(colorStops);
    } else {
      gradientConstructor = buildRadialGradientFactory((style.focalPoint | 0) / 20, colorStops);
    }
    style.style = gradientConstructor;
    break;
  case GRAPHICS_FILL_REPEATING_BITMAP:
  case GRAPHICS_FILL_CLIPPED_BITMAP:
  case GRAPHICS_FILL_NONSMOOTHED_REPEATING_BITMAP:
  case GRAPHICS_FILL_NONSMOOTHED_CLIPPED_BITMAP:
    var bitmap = dictionary[style.bitmapId];
    var repeat = style.type === GRAPHICS_FILL_REPEATING_BITMAP || style.type === GRAPHICS_FILL_NONSMOOTHED_REPEATING_BITMAP;
    style.style = factoryCtx.createPattern(bitmap.value.props.img, repeat ? 'repeat' : 'no-repeat');
    break;
  default:
    fail('invalid fill style', 'shape');
  }
}
var SOUND_SIZE_8_BIT = 0;
var SOUND_SIZE_16_BIT = 1;
var SOUND_TYPE_MONO = 0;
var SOUND_TYPE_STEREO = 1;
var SOUND_FORMAT_PCM_BE = 0;
var SOUND_FORMAT_ADPCM = 1;
var SOUND_FORMAT_MP3 = 2;
var SOUND_FORMAT_PCM_LE = 3;
var SOUND_FORMAT_NELLYMOSER_16 = 4;
var SOUND_FORMAT_NELLYMOSER_8 = 5;
var SOUND_FORMAT_NELLYMOSER = 6;
var SOUND_FORMAT_SPEEX = 11;
var SOUND_RATES = [
    5512,
    11250,
    22500,
    44100
  ];
var WaveHeader = new Uint8Array([
    82,
    73,
    70,
    70,
    0,
    0,
    0,
    0,
    87,
    65,
    86,
    69,
    102,
    109,
    116,
    32,
    16,
    0,
    0,
    0,
    1,
    0,
    2,
    0,
    68,
    172,
    0,
    0,
    16,
    177,
    2,
    0,
    4,
    0,
    16,
    0,
    100,
    97,
    116,
    97,
    0,
    0,
    0,
    0
  ]);
function packageWave(data, sampleRate, channels, size, swapBytes) {
  var sizeInBytes = size >> 3;
  var sizePerSecond = channels * sampleRate * sizeInBytes;
  var sizePerSample = channels * sizeInBytes;
  var dataLength = data.length + (data.length & 1);
  var buffer = new ArrayBuffer(WaveHeader.length + dataLength);
  var bytes = new Uint8Array(buffer);
  bytes.set(WaveHeader);
  if (swapBytes) {
    for (var i = 0, j = WaveHeader.length; i < data.length; i += 2, j += 2) {
      bytes[j] = data[i + 1];
      bytes[j + 1] = data[i];
    }
  } else {
    bytes.set(data, WaveHeader.length);
  }
  var view = new DataView(buffer);
  view.setUint32(4, dataLength + 36, true);
  view.setUint16(22, channels, true);
  view.setUint32(24, sampleRate, true);
  view.setUint32(28, sizePerSecond, true);
  view.setUint16(32, sizePerSample, true);
  view.setUint16(34, size, true);
  view.setUint32(40, dataLength, true);
  return {
    data: bytes,
    mimeType: 'audio/wav'
  };
}
function defineSound(tag, dictionary) {
  var channels = tag.soundType == SOUND_TYPE_STEREO ? 2 : 1;
  var samplesCount = tag.samplesCount;
  var sampleRate = SOUND_RATES[tag.soundRate];
  var data = tag.soundData;
  var pcm, packaged;
  switch (tag.soundFormat) {
  case SOUND_FORMAT_PCM_BE:
    pcm = new Float32Array(samplesCount * channels);
    if (tag.soundSize == SOUND_SIZE_16_BIT) {
      for (var i = 0, j = 0; i < pcm.length; i++, j += 2)
        pcm[i] = (data[j] << 24 | data[j + 1] << 16) / 2147483648;
      packaged = packageWave(data, sampleRate, channels, 16, true);
    } else {
      for (var i = 0; i < pcm.length; i++)
        pcm[i] = (data[i] - 128) / 128;
      packaged = packageWave(data, sampleRate, channels, 8, false);
    }
    break;
  case SOUND_FORMAT_PCM_LE:
    pcm = new Float32Array(samplesCount * channels);
    if (tag.soundSize == SOUND_SIZE_16_BIT) {
      for (var i = 0, j = 0; i < pcm.length; i++, j += 2)
        pcm[i] = (data[j + 1] << 24 | data[j] << 16) / 2147483648;
      packaged = packageWave(data, sampleRate, channels, 16, false);
    } else {
      for (var i = 0; i < pcm.length; i++)
        pcm[i] = (data[i] - 128) / 128;
      packaged = packageWave(data, sampleRate, channels, 8, false);
    }
    break;
  case SOUND_FORMAT_MP3:
    packaged = {
      data: new Uint8Array(data.subarray(2)),
      mimeType: 'audio/mpeg'
    };
    break;
  case SOUND_FORMAT_ADPCM:
    var pcm16 = new Int16Array(samplesCount * channels);
    decodeACPCMSoundData(data, pcm16, channels);
    pcm = new Float32Array(samplesCount * channels);
    for (var i = 0; i < pcm.length; i++)
      pcm[i] = pcm16[i] / 32768;
    packaged = packageWave(new Uint8Array(pcm16.buffer), sampleRate, channels, 16, !new Uint8Array(new Uint16Array([
      1
    ]).buffer)[0]);
    break;
  default:
    throw new Error('Unsupported audio format: ' + tag.soundFormat);
  }
  var sound = {
      type: 'sound',
      id: tag.id,
      sampleRate: sampleRate,
      channels: channels,
      pcm: pcm
    };
  if (packaged)
    sound.packaged = packaged;
  return sound;
}
var ACPCMIndexTables = [
    [
      -1,
      2
    ],
    [
      -1,
      -1,
      2,
      4
    ],
    [
      -1,
      -1,
      -1,
      -1,
      2,
      4,
      6,
      8
    ],
    [
      -1,
      -1,
      -1,
      -1,
      -1,
      -1,
      -1,
      -1,
      1,
      2,
      4,
      6,
      8,
      10,
      13,
      16
    ]
  ];
var ACPCMStepSizeTable = [
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    16,
    17,
    19,
    21,
    23,
    25,
    28,
    31,
    34,
    37,
    41,
    45,
    50,
    55,
    60,
    66,
    73,
    80,
    88,
    97,
    107,
    118,
    130,
    143,
    157,
    173,
    190,
    209,
    230,
    253,
    279,
    307,
    337,
    371,
    408,
    449,
    494,
    544,
    598,
    658,
    724,
    796,
    876,
    963,
    1060,
    1166,
    1282,
    1411,
    1552,
    1707,
    1878,
    2066,
    2272,
    2499,
    2749,
    3024,
    3327,
    3660,
    4026,
    4428,
    4871,
    5358,
    5894,
    6484,
    7132,
    7845,
    8630,
    9493,
    10442,
    11487,
    12635,
    13899,
    15289,
    16818,
    18500,
    20350,
    22385,
    24623,
    27086,
    29794,
    32767
  ];
function decodeACPCMSoundData(data, pcm16, channels) {
  function readBits(n, signed) {
    while (dataBufferLength < n) {
      dataBuffer = dataBuffer << 8 | data[dataPosition++];
      dataBufferLength += 8;
    }
    dataBufferLength -= n;
    return dataBuffer >>> dataBufferLength & (1 << n) - 1;
  }
  var dataPosition = 0;
  var dataBuffer = 0;
  var dataBufferLength = 0;
  var pcmPosition = 0;
  var codeSize = readBits(2);
  var indexTable = ACPCMIndexTables[codeSize];
  while (pcmPosition < pcm16.length) {
    var x = pcm16[pcmPosition++] = readBits(16) << 16 >> 16, x2;
    var stepIndex = readBits(6), stepIndex2;
    if (channels > 1) {
      x2 = pcm16[pcmPosition++] = readBits(16) << 16 >> 16;
      stepIndex2 = readBits(6);
    }
    var signMask = 1 << codeSize + 1;
    for (var i = 0; i < 4095; i++) {
      var nibble = readBits(codeSize + 2);
      var step = ACPCMStepSizeTable[stepIndex];
      var sum = 0;
      for (var currentBit = signMask >> 1; currentBit; currentBit >>= 1, step >>= 1) {
        if (nibble & currentBit)
          sum += step;
      }
      x += (nibble & signMask ? -1 : 1) * (sum + step);
      pcm16[pcmPosition++] = x = x < -32768 ? -32768 : x > 32767 ? 32767 : x;
      stepIndex += indexTable[nibble & ~signMask];
      stepIndex = stepIndex < 0 ? 0 : stepIndex > 88 ? 88 : stepIndex;
      if (channels > 1) {
        nibble = readBits(codeSize + 2);
        step = ACPCMStepSizeTable[stepIndex2];
        sum = 0;
        for (var currentBit = signMask >> 1; currentBit; currentBit >>= 1, step >>= 1) {
          if (nibble & currentBit)
            sum += step;
        }
        x2 += (nibble & signMask ? -1 : 1) * (sum + step);
        pcm16[pcmPosition++] = x2 = x2 < -32768 ? -32768 : x2 > 32767 ? 32767 : x2;
        stepIndex2 += indexTable[nibble & ~signMask];
        stepIndex2 = stepIndex2 < 0 ? 0 : stepIndex2 > 88 ? 88 : stepIndex2;
      }
    }
  }
}
var nextSoundStreamId = 0;
function SwfSoundStream(samplesCount, sampleRate, channels) {
  this.streamId = nextSoundStreamId++;
  this.samplesCount = samplesCount;
  this.sampleRate = sampleRate;
  this.channels = channels;
  this.format = null;
  this.currentSample = 0;
}
SwfSoundStream.prototype = {
  get info() {
    return {
      samplesCount: this.samplesCount,
      sampleRate: this.sampleRate,
      channels: this.channels,
      format: this.format,
      streamId: this.streamId
    };
  },
  decode: function (data) {
    throw new Error('SwfSoundStream.decode: not implemented');
  }
};
function SwfSoundStream_decode_PCM(data) {
  var pcm = new Float32Array(data.length);
  for (var i = 0; i < pcm.length; i++)
    pcm[i] = (data[i] - 128) / 128;
  this.currentSample += pcm.length / this.channels;
  return {
    streamId: this.streamId,
    samplesCount: pcm.length / this.channels,
    pcm: pcm
  };
}
function SwfSoundStream_decode_PCM_be(data) {
  var pcm = new Float32Array(data.length / 2);
  for (var i = 0, j = 0; i < pcm.length; i++, j += 2)
    pcm[i] = (data[j] << 24 | data[j + 1] << 16) / 2147483648;
  this.currentSample += pcm.length / this.channels;
  return {
    streamId: this.streamId,
    samplesCount: pcm.length / this.channels,
    pcm: pcm
  };
}
function SwfSoundStream_decode_PCM_le(data) {
  var pcm = new Float32Array(data.length / 2);
  for (var i = 0, j = 0; i < pcm.length; i++, j += 2)
    pcm[i] = (data[j + 1] << 24 | data[j] << 16) / 2147483648;
  this.currentSample += pcm.length / this.channels;
  return {
    streamId: this.streamId,
    samplesCount: pcm.length / this.channels,
    pcm: pcm
  };
}
function SwfSoundStream_decode_MP3(data) {
  var samplesCount = data[1] << 8 | data[0];
  var seek = data[3] << 8 | data[2];
  this.currentSample += samplesCount;
  return {
    streamId: this.streamId,
    samplesCount: samplesCount,
    data: new Uint8Array(data.subarray(4)),
    seek: seek
  };
}
function createSoundStream(tag) {
  var channels = tag.streamType == SOUND_TYPE_STEREO ? 2 : 1;
  var samplesCount = tag.samplesCount;
  var sampleRate = SOUND_RATES[tag.streamRate];
  var stream = new SwfSoundStream(samplesCount, sampleRate, channels);
  switch (tag.streamCompression) {
  case SOUND_FORMAT_PCM_BE:
    stream.format = 'wave';
    if (tag.soundSize == SOUND_SIZE_16_BIT) {
      stream.decode = SwfSoundStream_decode_PCM_be;
    } else {
      stream.decode = SwfSoundStream_decode_PCM;
    }
    break;
  case SOUND_FORMAT_PCM_LE:
    stream.format = 'wave';
    if (tag.soundSize == SOUND_SIZE_16_BIT) {
      stream.decode = SwfSoundStream_decode_PCM_le;
    } else {
      stream.decode = SwfSoundStream_decode_PCM;
    }
    break;
  case SOUND_FORMAT_MP3:
    stream.format = 'mp3';
    stream.decode = SwfSoundStream_decode_MP3;
    break;
  default:
    throw new Error('Unsupported audio format: ' + tag.soundFormat);
  }
  return stream;
}
function defineText(tag, dictionary) {
  var dependencies = [];
  if (tag.hasFont) {
    var font = dictionary[tag.fontId];
    tag.font = font.uniqueName;
    dependencies.push(font.id);
  }
  var props = {
      type: 'text',
      id: tag.id,
      variableName: tag.variableName,
      tag: tag
    };
  if (dependencies.length)
    props.require = dependencies;
  return props;
}
var isWorker = typeof window === 'undefined';
if (isWorker) {
  importScripts('../../../lib/mp3/mp3.js');
  self.addEventListener('message', function (e) {
    var data = e.data;
    var sessionId = data.sessionId;
    try {
      switch (data.action) {
      case 'create':
        var session = new Session(sessionId);
        sessions[sessionId] = session;
        break;
      case 'close':
        var session = sessions[sessionId];
        if (session) {
          session.close();
          delete sessions[sessionId];
        }
        break;
      case 'decode':
        var session = sessions[sessionId];
        if (!session) {
          throw new Error('mp3 decoding session is unavailable');
        }
        session.decode(data.data);
        break;
      }
    } catch (ex) {
      self.postMessage({
        sessionId: sessionId,
        action: 'error',
        message: ex.message
      });
    }
  }, false);
  var sessions = {};
  function Session(id) {
    this.id = id;
    if (typeof MP3Decoder === 'undefined') {
      throw new Error('mp3 decoder is not available');
    }
    var decoder = new MP3Decoder();
    decoder.onframedata = function (frameData, channels, sampleRate, bitRate) {
      self.postMessage({
        sessionId: this.id,
        action: 'frame',
        frameData: frameData,
        channels: channels,
        sampleRate: sampleRate,
        bitRate: bitRate
      });
    }.bind(this);
    decoder.onid3tag = function (data) {
      self.postMessage({
        sessionId: this.id,
        action: 'id3',
        id3Data: data
      });
    }.bind(this);
    this.decoder = decoder;
  }
  Session.prototype = {
    decode: function (data) {
      this.decoder.push(data);
    },
    close: function () {
      self.postMessage({
        sessionId: this.id,
        action: 'closed'
      });
    }
  };
  self.console = {
    log: function (s) {
      self.postMessage({
        action: 'console',
        method: 'log',
        message: s
      });
    },
    error: function (s) {
      self.postMessage({
        action: 'console',
        method: 'error',
        message: s
      });
    }
  };
} else {
  var mp3Worker;
  function createMP3Worker() {
    var worker = new Worker(SHUMWAY_ROOT + 'swf/mp3worker.js');
    worker.addEventListener('message', function (e) {
      if (e.data.action === 'console') {
        console[e.data.method].call(console, e.data.message);
      }
    });
    return worker;
  }
  var nextSessionId = 0;
  function MP3DecoderSession() {
    mp3Worker = mp3Worker || createMP3Worker();
    var sessionId = nextSessionId++;
    this.id = sessionId;
    this.onworkermessage = function (e) {
      if (e.data.sessionId !== sessionId)
        return;
      var action = e.data.action;
      switch (action) {
      case 'closed':
        if (this.onclosed)
          this.onclosed();
        mp3Worker.removeEventListener('message', this.onworkermessage, false);
        break;
      case 'frame':
        this.onframedata(e.data.frameData, e.data.channels, e.data.sampleRate, e.data.bitRate);
        break;
      case 'id3':
        if (this.onid3tag)
          this.onid3tag(e.data.id3Data);
        break;
      case 'error':
        if (this.onerror)
          this.onerror(e.data.message);
        break;
      }
    }.bind(this);
    mp3Worker.addEventListener('message', this.onworkermessage, false);
    mp3Worker.postMessage({
      sessionId: sessionId,
      action: 'create'
    });
  }
  MP3DecoderSession.prototype = {
    pushAsync: function (data) {
      mp3Worker.postMessage({
        sessionId: this.id,
        action: 'decode',
        data: data
      });
    },
    close: function () {
      mp3Worker.postMessage({
        sessionId: this.id,
        action: 'close'
      });
    }
  };
  MP3DecoderSession.processAll = function (data, onloaded) {
    var currentBufferSize = 8000;
    var currentBuffer = new Float32Array(currentBufferSize);
    var bufferPosition = 0;
    var id3Tags = [];
    var sessionAborted = false;
    var session = new MP3DecoderSession();
    session.onframedata = function (frameData, channels, sampleRate, bitRate) {
      var needed = frameData.length + bufferPosition;
      if (needed > currentBufferSize) {
        do {
          currentBufferSize *= 2;
        } while (needed > currentBufferSize);
        var newBuffer = new Float32Array(currentBufferSize);
        newBuffer.set(currentBuffer);
        currentBuffer = newBuffer;
      }
      currentBuffer.set(frameData, bufferPosition);
      bufferPosition += frameData.length;
    };
    session.onid3tag = function (tagData) {
      id3Tags.push(tagData);
    };
    session.onclosed = function () {
      if (sessionAborted)
        return;
      onloaded(currentBuffer.subarray(0, bufferPosition), id3Tags);
    };
    session.onerror = function (error) {
      if (sessionAborted)
        return;
      sessionAborted = true;
      onloaded(null, null, error);
    };
    session.pushAsync(data);
    session.close();
  };
}
SWF.embed = function (file, doc, container, options) {
  var canvas = doc.createElement('canvas');
  var ctx = canvas.getContext('2d');
  var loader = new flash.display.Loader();
  var loaderInfo = loader.contentLoaderInfo;
  var stage = new flash.display.Stage();
  stage._loader = loader;
  loaderInfo._parameters = options.movieParams;
  loaderInfo._url = options.url || (typeof file === 'string' ? file : null);
  loaderInfo._loaderURL = options.loaderURL || loaderInfo._url;
  var pixelRatio = 'devicePixelRatio' in window ? window.devicePixelRatio : 1;
  var canvasHolder = null;
  canvas._pixelRatio = pixelRatio;
  if (pixelRatio > 1) {
    var cssScale = 'scale(' + 1 / pixelRatio + ', ' + 1 / pixelRatio + ')';
    canvas.setAttribute('style', '-moz-transform: ' + cssScale + ';' + '-webkit-transform: ' + cssScale + ';' + 'transform: ' + cssScale + ';' + '-moz-transform-origin: 0% 0%;' + '-webkit-transform-origin: 0% 0%;' + 'transform-origin: 0% 0%;');
    canvasHolder = doc.createElement('div');
    canvasHolder.setAttribute('style', 'display: inline-block; overflow: hidden;');
    canvasHolder.appendChild(canvas);
  }
  stage._contentsScaleFactor = pixelRatio;
  loader._parent = stage;
  loader._stage = stage;
  function fitCanvas(container, canvas) {
    if (canvasHolder) {
      canvasHolder.style.width = container.clientWidth + 'px';
      canvasHolder.style.height = container.clientHeight + 'px';
    }
    canvas.width = container.clientWidth * pixelRatio;
    canvas.height = container.clientHeight * pixelRatio;
    stage._invalid = true;
  }
  loaderInfo._addEventListener('init', function () {
    if (container.clientHeight) {
      fitCanvas(container, canvas);
      window.addEventListener('resize', function () {
        fitCanvas(container, canvas);
      });
    } else {
      if (canvasHolder) {
        canvasHolder.style.width = stage._stageWidth / 20 + 'px';
        canvasHolder.style.height = stage._stageHeight / 20 + 'px';
      }
      canvas.width = stage._stageWidth * pixelRatio / 20;
      canvas.height = stage._stageHeight * pixelRatio / 20;
    }
    container.setAttribute('style', 'position: relative');
    canvas.addEventListener('click', function () {
      ShumwayKeyboardListener.focus = stage;
      stage._mouseTarget._dispatchEvent('click');
    });
    canvas.addEventListener('dblclick', function () {
      if (stage._mouseTarget._doubleClickEnabled) {
        stage._mouseTarget._dispatchEvent('doubleClick');
      }
    });
    canvas.addEventListener('mousedown', function () {
      if (stage._mouseTarget._buttonMode) {
        stage._mouseTarget._gotoButtonState('down');
      }
      stage._mouseTarget._dispatchEvent('mouseDown');
    });
    canvas.addEventListener('mousemove', function (domEvt) {
      var node = this;
      var left = 0;
      var top = 0;
      if (node.offsetParent) {
        do {
          left += node.offsetLeft;
          top += node.offsetTop;
        } while (node = node.offsetParent);
      }
      var m = stage._concatenatedTransform;
      var mouseX = ((domEvt.pageX - left) * pixelRatio - m.tx) / m.a;
      var mouseY = ((domEvt.pageY - top) * pixelRatio - m.ty) / m.d;
      if (mouseX !== stage._mouseX || mouseY !== stage._mouseY) {
        stage._mouseMoved = true;
        stage._mouseX = mouseX * 20;
        stage._mouseY = mouseY * 20;
      }
    });
    canvas.addEventListener('mouseup', function () {
      if (stage._mouseTarget._buttonMode) {
        stage._mouseTarget._gotoButtonState('over');
      }
      stage._mouseTarget._dispatchEvent('mouseUp');
    });
    canvas.addEventListener('mouseover', function () {
      stage._mouseMoved = true;
      stage._mouseOver = true;
    });
    canvas.addEventListener('mouseout', function () {
      stage._mouseMoved = true;
      stage._mouseOver = false;
    });
    var bgcolor = loaderInfo._backgroundColor;
    if (options.objectParams) {
      var m;
      if (options.objectParams.bgcolor && (m = /#([0-9A-F]{6})/i.exec(options.objectParams.bgcolor))) {
        var hexColor = parseInt(m[1], 16);
        bgcolor = {
          red: hexColor >> 16 & 255,
          green: hexColor >> 8 & 255,
          blue: hexColor & 255,
          alpha: 255
        };
      }
      if (options.objectParams.wmode === 'transparent') {
        bgcolor = {
          red: 0,
          green: 0,
          blue: 0,
          alpha: 0
        };
      }
    }
    stage._color = bgcolor;
    ctx.fillStyle = rgbaObjToStr(bgcolor);
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    var root = loader._content;
    stage._children[0] = root;
    root._dispatchEvent('added');
    root._dispatchEvent('addedToStage');
    container.appendChild(canvasHolder || canvas);
    if (options.onStageInitialized) {
      options.onStageInitialized(stage);
    }
    renderStage(stage, ctx, options);
  });
  if (options.onComplete) {
    loaderInfo._addEventListener('complete', function () {
      options.onComplete();
    });
  }
  loader._load(typeof file === 'string' ? new flash.net.URLRequest(file) : file);
  return loader;
};
var rendererOptions = coreOptions.register(new OptionSet('Renderer Options'));
var traceRenderer = rendererOptions.register(new Option('tr', 'traceRenderer', 'number', 0, 'trace renderer execution'));
var disablePreVisitor = rendererOptions.register(new Option('dpv', 'disablePreVisitor', 'boolean', false, 'disable pre visitor'));
var disableRenderVisitor = rendererOptions.register(new Option('drv', 'disableRenderVisitor', 'boolean', false, 'disable render visitor'));
var disableMouseVisitor = rendererOptions.register(new Option('dmv', 'disableMouseVisitor', 'boolean', false, 'disable mouse visitor'));
var showRedrawRegions = rendererOptions.register(new Option('rr', 'showRedrawRegions', 'boolean', false, 'show redraw regions'));
var renderAsWireframe = rendererOptions.register(new Option('raw', 'renderAsWireframe', 'boolean', false, 'render as wireframe'));
var showQuadTree = rendererOptions.register(new Option('qt', 'showQuadTree', 'boolean', false, 'show quad tree'));
var turboMode = rendererOptions.register(new Option('', 'turbo', 'boolean', false, 'turbo mode'));
if (typeof FirefoxCom !== 'undefined') {
  turboMode.value = FirefoxCom.requestSync('getBoolPref', {
    pref: 'shumway.turboMode',
    def: false
  });
}
var CanvasCache = {
    cache: [],
    getCanvas: function getCanvas(protoCanvas) {
      var tempCanvas = this.cache.shift();
      if (!tempCanvas) {
        tempCanvas = {
          canvas: document.createElement('canvas')
        };
        tempCanvas.ctx = tempCanvas.canvas.getContext('2d');
      }
      tempCanvas.canvas.width = protoCanvas.width;
      tempCanvas.canvas.height = protoCanvas.height;
      tempCanvas.ctx.save();
      return tempCanvas;
    },
    releaseCanvas: function releaseCanvas(tempCanvas) {
      tempCanvas.ctx.restore();
      this.cache.push(tempCanvas);
    }
  };
function isCanvasVisible(canvas) {
  if (canvas.ownerDocument.hidden) {
    return false;
  }
  if (canvas.mozVisible === false) {
    return false;
  }
  return true;
}
function visitContainer(container, visitor, context) {
  var children = container._children;
  visitor.childrenStart(container);
  for (var i = 0, n = children.length; i < n; i++) {
    var child = children[i];
    if (!child) {
      continue;
    }
    if (visitor.ignoreVisibleAttribute || child._visible && !child._maskedObject) {
      var isContainer = flash.display.DisplayObjectContainer.class.isInstanceOf(child) || flash.display.SimpleButton.class.isInstanceOf(child);
      visitor.visit(child, isContainer, visitContainer, context);
    }
  }
  visitor.childrenEnd(container);
}
var BlendModeNameMap = {
    'normal': 'normal',
    'multiply': 'multiply',
    'screen': 'screen',
    'lighten': 'lighten',
    'darken': 'darken',
    'difference': 'difference',
    'overlay': 'overlay',
    'hardlight': 'hard-light'
  };
function getBlendModeName(blendMode) {
  return BlendModeNameMap[blendMode] || 'normal';
}
function RenderVisitor(root, ctx, invalidPath, refreshStage) {
  this.root = root;
  this.ctx = ctx;
  this.depth = 0;
  this.invalidPath = invalidPath;
  this.refreshStage = refreshStage;
  this.clipDepth = null;
  this.clipStack = null;
}
RenderVisitor.prototype = {
  ignoreVisibleAttribute: false,
  start: function () {
    visitContainer(this.root, this, new RenderingContext(this.refreshStage, this.invalidPath));
  },
  startFragment: function () {
    var isContainer = flash.display.DisplayObjectContainer.class.isInstanceOf(this.root) || flash.display.SimpleButton.class.isInstanceOf(this.root);
    var t = this.root._currentTransform;
    var inverse;
    if (t) {
      inverse = new flash.geom.Matrix(t.a, t.b, t.c, t.d, t.tx / 20, t.ty / 20);
      inverse.invert();
      this.ctx.save();
      this.ctx.transform(inverse.a, inverse.b, inverse.c, inverse.d, inverse.tx, inverse.ty);
    }
    this.visit(this.root, isContainer, visitContainer, new RenderingContext(this.refreshStage, this.invalidPath));
    if (t) {
      this.ctx.restore();
    }
  },
  childrenStart: function (parent) {
    if (this.depth === 0) {
      var ctx = this.ctx;
      ctx.save();
      if (this.invalidPath && !this.refreshStage && !renderAsWireframe.value) {
        this.invalidPath.draw(ctx);
        ctx.clip();
      }
      var bgcolor = this.root._color;
      if (bgcolor) {
        if (bgcolor.alpha < 255) {
          ctx.clearRect(0, 0, ctx.canvas.width, ctx.canvas.height);
        }
        if (bgcolor.alpha > 0) {
          ctx.fillStyle = rgbaObjToStr(bgcolor);
          if (this.invalidPath && !this.refreshStage && !renderAsWireframe.value) {
            ctx.fill();
          } else {
            ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);
          }
        }
      }
      ctx.mozFillRule = 'evenodd';
    }
    this.depth++;
    if (this.clipDepth && this.clipDepth.length > 0) {
      this.clipStack = {
        depth: this.depth,
        clip: this.clipDepth,
        next: this.clipStack
      };
      this.clipDepth = null;
    }
  },
  childrenEnd: function (parent) {
    if (this.clipDepth) {
      while (this.clipDepth.length > 0) {
        this.clipDepth.pop();
        this.ctx.restore();
      }
      this.clipDepth = null;
    }
    if (this.clipStack && this.clipStack.depth === this.depth) {
      this.clipDepth = this.clipStack.clip;
      this.clipStack = this.clipStack.next;
    }
    this.depth--;
    if (this.depth === 0) {
      this.ctx.restore();
      this.invalidPath = null;
    }
  },
  visit: function (child, isContainer, visitContainer, context) {
    var ctx = this.ctx;
    var parentHasClippingMask = context.isClippingMask;
    var parentColorTransform = context.colorTransform;
    var clippingMask = parentHasClippingMask === true;
    if (child._cxform) {
      context.colorTransform = parentColorTransform.applyCXForm(child._cxform);
    }
    if (!clippingMask) {
      while (this.clipDepth && this.clipDepth.length > 0 && child._depth > this.clipDepth[0]) {
        this.clipDepth.shift();
        ctx.restore();
      }
      if (child._clipDepth) {
        if (!this.clipDepth) {
          this.clipDepth = [];
        }
        context.isClippingMask = clippingMask = true;
        this.clipDepth.unshift(child._clipDepth);
        ctx.save();
      }
    }
    if (clippingMask && isContainer) {
      ctx.save();
      renderDisplayObject(child, ctx, context);
      for (var i = 0, n = child._children.length; i < n; i++) {
        var child1 = child._children[i];
        if (!child1) {
          continue;
        }
        if (this.ignoreVisibleAttribute || child1._visible && !child1._maskedObject) {
          var isContainer = flash.display.DisplayObjectContainer.class.isInstanceOf(child1) || flash.display.SimpleButton.class.isInstanceOf(child1);
          this.visit(child1, isContainer, visitContainer, context);
        }
      }
      ctx.restore();
      ctx.clip();
      context.isClippingMask = parentHasClippingMask;
      context.colorTransform = parentColorTransform;
      return;
    }
    ctx.save();
    ctx.globalCompositeOperation = getBlendModeName(child._blendMode);
    if (child._mask) {
      var m = child._parent._getConcatenatedTransform(true);
      var tempCanvas, tempCtx, maskCanvas, maskCtx;
      maskCanvas = CanvasCache.getCanvas(ctx.canvas);
      maskCtx = maskCanvas.ctx;
      maskCtx.setTransform(m.a, m.b, m.c, m.d, m.tx, m.ty);
      var isMaskContainer = flash.display.DisplayObjectContainer.class.isInstanceOf(child._mask) || flash.display.SimpleButton.class.isInstanceOf(child._mask);
      this.ctx = maskCtx;
      this.visit(child._mask, isMaskContainer, visitContainer, new RenderingContext(this.refreshStage));
      this.ctx = ctx;
      tempCanvas = CanvasCache.getCanvas(ctx.canvas);
      tempCtx = tempCanvas.ctx;
      tempCtx.setTransform(m.a, m.b, m.c, m.d, m.tx, m.ty);
      renderDisplayObject(child, tempCtx, context);
      if (isContainer) {
        this.ctx = tempCtx;
        visitContainer(child, this, context);
        this.ctx = ctx;
      }
      tempCtx.globalCompositeOperation = 'destination-in';
      tempCtx.setTransform(1, 0, 0, 1, 0, 0);
      tempCtx.drawImage(maskCanvas.canvas, 0, 0);
      ctx.save();
      ctx.setTransform(1, 0, 0, 1, 0, 0);
      ctx.drawImage(tempCanvas.canvas, 0, 0);
      ctx.restore();
      CanvasCache.releaseCanvas(tempCanvas);
      CanvasCache.releaseCanvas(maskCanvas);
    } else {
      renderDisplayObject(child, ctx, context);
      if (isContainer) {
        visitContainer(child, this, context);
      }
    }
    ctx.restore();
    if (clippingMask) {
      ctx.clip();
    }
    context.isClippingMask = parentHasClippingMask;
    context.colorTransform = parentColorTransform;
  }
};
function RenderingColorTransform() {
  this.mode = null;
  this.transform = [
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0
  ];
}
RenderingColorTransform.prototype = {
  applyCXForm: function (cxform) {
    var t = this.transform;
    t = [
      t[0] * cxform.redMultiplier / 256,
      t[1] * cxform.greenMultiplier / 256,
      t[2] * cxform.blueMultiplier / 256,
      t[3] * cxform.alphaMultiplier / 256,
      t[4] * cxform.redMultiplier / 256 + cxform.redOffset,
      t[5] * cxform.greenMultiplier / 256 + cxform.greenOffset,
      t[6] * cxform.blueMultiplier / 256 + cxform.blueOffset,
      t[7] * cxform.alphaMultiplier / 256 + cxform.alphaOffset
    ];
    var mode;
    var PRECISION = 0.0001;
    if (Math.abs(t[0] - 1) < PRECISION && Math.abs(t[1] - 1) < PRECISION && Math.abs(t[2] - 1) < PRECISION && t[3] >= 0 && Math.abs(t[4]) < PRECISION && Math.abs(t[5]) < PRECISION && Math.abs(t[6]) < PRECISION && Math.abs(t[7]) < PRECISION) {
      mode = Math.abs(t[3] - 1) < PRECISION ? null : 'simple';
    } else {
      mode = 'complex';
    }
    var clone = Object.create(RenderingColorTransform.prototype);
    clone.mode = mode;
    clone.transform = t;
    return clone;
  },
  setFillStyle: function (ctx, style) {
    if (this.mode === 'complex') {
      style = typeof style === 'function' ? style(ctx, this) : this.convertColor(style);
    } else if (typeof style === 'number') {
      style = this.convertNumericColor(style);
    } else if (typeof style === 'function') {
      style = style.defaultGradient;
    }
    ctx.fillStyle = style;
  },
  setStrokeStyle: function (ctx, style) {
    if (this.mode === 'complex') {
      style = typeof style === 'function' ? style(ctx, this) : this.convertColor(style);
    } else if (typeof style === 'number') {
      style = this.convertNumericColor(style);
    } else if (typeof style === 'function') {
      style = style.defaultGradient;
    }
    ctx.strokeStyle = style;
  },
  addGradientColorStop: function (gradient, ratio, style) {
    if (this.mode === 'complex') {
      style = this.convertColor(style);
    } else if (typeof style === 'number') {
      style = this.convertNumericColor(style);
    }
    gradient.addColorStop(ratio, style);
  },
  setAlpha: function (ctx, force) {
    if (this.mode === 'simple' || force) {
      var t = this.transform;
      ctx.globalAlpha = Math.min(1, Math.max(0, ctx.globalAlpha * t[3]));
    }
  },
  convertNumericColor: function (num) {
    return '#' + (num | 16777216).toString(16).substr(1);
  },
  convertColor: function (style) {
    var t = this.transform;
    var m;
    switch (typeof style) {
    case 'string':
      if (style[0] === '#') {
        m = [
          undefined,
          parseInt(style.substr(1, 2), 16),
          parseInt(style.substr(3, 2), 16),
          parseInt(style.substr(5, 2), 16),
          1
        ];
      }
      m = m || /rgba\(([^,]+),([^,]+),([^,]+),([^)]+)\)/.exec(style);
      if (!m) {
        return style;
      }
      break;
    case 'number':
      m = [
        style,
        style >> 16 & 255,
        style >> 8 & 255,
        style & 255,
        1
      ];
      break;
    default:
      return style;
    }
    var r = Math.min(255, Math.max(0, m[1] * t[0] + t[4])) | 0;
    var g = Math.min(255, Math.max(0, m[2] * t[1] + t[5])) | 0;
    var b = Math.min(255, Math.max(0, m[3] * t[2] + t[6])) | 0;
    var a = Math.min(1, Math.max(0, m[4] * t[3] + t[7] / 256));
    return 'rgba(' + r + ',' + g + ',' + b + ',' + a + ')';
  }
};
function RenderingContext(refreshStage, invalidPath) {
  this.refreshStage = refreshStage === true;
  this.invalidPath = invalidPath;
  this.isClippingMask = false;
  this.colorTransform = new RenderingColorTransform();
}
function renderDisplayObject(child, ctx, context) {
  var m = child._currentTransform;
  if (m) {
    if (m.a * m.d == m.b * m.c) {
      ctx.closePath();
      ctx.rect(0, 0, 0, 0);
      ctx.clip();
    } else {
      ctx.transform(m.a, m.b, m.c, m.d, m.tx / 20, m.ty / 20);
    }
  }
  if (!renderAsWireframe.value) {
    if (child._alpha !== 1) {
      ctx.globalAlpha *= child._alpha;
    }
    if (context.invalidPath && !child._invalid && !context.refreshStage) {
      return;
    }
    if (child._graphics) {
      var graphics = child._graphics;
      if (graphics._bitmap) {
        ctx.save();
        ctx.translate(child._bbox.xMin / 20, child._bbox.yMin / 20);
        context.colorTransform.setAlpha(ctx, true);
        ctx.drawImage(graphics._bitmap, 0, 0);
        ctx.restore();
      } else {
        graphics.draw(ctx, context.isClippingMask, child.ratio, context.colorTransform);
      }
    }
    if (child.draw) {
      child.draw(ctx, child.ratio, context.colorTransform);
    }
  } else {
    if (!child._invalid && !context.refreshStage) {
      return;
    }
    if (child.getBounds) {
      var b = child.getBounds(null);
      if (b && b.xMax - b.xMin > 0 && b.yMax - b.yMin > 0) {
        if (!child._wireframeStrokeStyle) {
          child._wireframeStrokeStyle = randomStyle();
        }
        ctx.save();
        ctx.strokeStyle = child._wireframeStrokeStyle;
        var x = b.xMin / 20;
        var y = b.yMin / 20;
        ctx.strokeRect(x + 0.5, y + 0.5, b.xMax / 20 - x - 1, b.yMax / 20 - y - 1);
        ctx.restore();
      }
    }
  }
  child._invalid = false;
}
function renderQuadTree(ctx, qtree) {
  ctx.strokeRect(qtree.x / 20, qtree.y / 20, qtree.width / 20, qtree.height / 20);
  var nodes = qtree.nodes;
  for (var i = 0; i < nodes.length; i++) {
    renderQuadTree(ctx, nodes[i]);
  }
}
var fps;
var renderingTerminated = false;
var samplesLeftPlusOne = 0;
function triggerSampling(count) {
  samplesLeftPlusOne = -count - 1;
}
function sampleStart() {
  if (!samplesLeftPlusOne) {
    return;
  }
  if (samplesLeftPlusOne < 0) {
    console.profile('Sample');
    samplesLeftPlusOne *= -1;
  }
  if (samplesLeftPlusOne > 0) {
    console.info('Sampling Frame: ' + (samplesLeftPlusOne - 1));
  }
}
function sampleEnd() {
  if (!samplesLeftPlusOne) {
    return;
  }
  samplesLeftPlusOne--;
  if (samplesLeftPlusOne === 1) {
    console.profileEnd('Sample');
  }
}
function renderStage(stage, ctx, events) {
  var frameWidth, frameHeight;
  function updateRenderTransform() {
    frameWidth = ctx.canvas.width;
    frameHeight = ctx.canvas.height;
    var scaleX = frameWidth / stage._stageWidth * 20;
    var scaleY = frameHeight / stage._stageHeight * 20;
    switch (stage._scaleMode) {
    case 'exactFit':
      break;
    case 'noBorder':
      if (scaleX > scaleY) {
        scaleY = scaleX;
      } else {
        scaleX = scaleY;
      }
      break;
    case 'noScale':
      var pixelRatio = ctx.canvas._pixelRatio || 1;
      scaleX = pixelRatio;
      scaleY = pixelRatio;
      break;
    case 'showAll':
      if (scaleX < scaleY) {
        scaleY = scaleX;
      } else {
        scaleX = scaleY;
      }
      break;
    }
    var align = stage._align;
    var offsetX, offsetY;
    if (align.indexOf('L') >= 0) {
      offsetX = 0;
    } else if (align.indexOf('R') >= 0) {
      offsetX = frameWidth - scaleX * stage._stageWidth / 20;
    } else {
      offsetX = (frameWidth - scaleX * stage._stageWidth / 20) / 2;
    }
    if (align.indexOf('T') >= 0) {
      offsetY = 0;
    } else if (align.indexOf('B') >= 0) {
      offsetY = frameHeight - scaleY * stage._stageHeight / 20;
    } else {
      offsetY = (frameHeight - scaleY * stage._stageHeight / 20) / 2;
    }
    ctx.setTransform(scaleX, 0, 0, scaleY, offsetX, offsetY);
    var m = stage._concatenatedTransform;
    m.a = scaleX;
    m.d = scaleY;
    m.tx = offsetX;
    m.ty = offsetY;
  }
  updateRenderTransform();
  var frameTime = 0;
  var maxDelay = 1000 / stage._frameRate;
  var nextRenderAt = performance.now();
  var requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || window.setTimeout;
  var renderDummyBalls;
  var dummyBalls;
  if (typeof FirefoxCom !== 'undefined' && FirefoxCom.requestSync('getBoolPref', {
      pref: 'shumway.dummyMode',
      def: false
    })) {
    var radius = 10;
    var speed = 1;
    var m = stage._concatenatedTransform;
    var scaleX = m.a, scaleY = m.d;
    dummyBalls = [];
    for (var i = 0; i < 10; i++) {
      dummyBalls.push({
        position: {
          x: radius + Math.random() * ((ctx.canvas.width - 2 * radius) / scaleX),
          y: radius + Math.random() * ((ctx.canvas.height - 2 * radius) / scaleY)
        },
        velocity: {
          x: speed * (Math.random() - 0.5),
          y: speed * (Math.random() - 0.5)
        }
      });
    }
    ctx.fillStyle = 'black';
    ctx.lineWidth = 2;
    ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);
    renderDummyBalls = function () {
      ctx.fillStyle = 'black';
      ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);
      ctx.strokeStyle = 'green';
      dummyBalls.forEach(function (ball) {
        var position = ball.position;
        var velocity = ball.velocity;
        ctx.beginPath();
        ctx.arc(position.x, position.y, radius, 0, Math.PI * 2, true);
        ctx.stroke();
        var x = position.x + velocity.x;
        var y = position.y + velocity.y;
        if (x < radius || x > ctx.canvas.width / scaleX - radius) {
          velocity.x *= -1;
        }
        if (y < radius || y > ctx.canvas.height / scaleY - radius) {
          velocity.y *= -1;
        }
        position.x += velocity.x;
        position.y += velocity.y;
      });
    };
  }
  console.timeEnd('Initialize Renderer');
  console.timeEnd('Total');
  var firstRun = true;
  var frameCount = 0;
  var frameFPSAverage = new metrics.Average(120);
  (function draw() {
    var now = performance.now();
    var renderFrame = now >= nextRenderAt;
    if (renderFrame && events.onBeforeFrame) {
      var e = {
          cancel: false
        };
      events.onBeforeFrame(e);
      renderFrame = !e.cancel;
    }
    if (renderFrame && renderDummyBalls) {
      frameTime = now;
      nextRenderAt = frameTime + maxDelay;
      renderDummyBalls();
      requestAnimationFrame(draw);
      return;
    }
    sampleStart();
    var refreshStage = false;
    if (stage._invalid) {
      updateRenderTransform();
      stage._invalid = false;
      refreshStage = true;
    }
    var mouseMoved = false;
    if (stage._mouseMoved) {
      stage._mouseMoved = false;
      mouseMoved = stage._mouseOver;
    }
    if (renderFrame || refreshStage || mouseMoved) {
      FrameCounter.clear();
      var frameStartTime = performance.now();
      traceRenderer.value && appendToFrameTerminal('Begin Frame #' + frameCount++, 'purple');
      var domain = avm2.systemDomain;
      if (renderFrame) {
        frameTime = now;
        maxDelay = 1000 / stage._frameRate;
        if (!turboMode.value) {
          while (nextRenderAt < now) {
            nextRenderAt += maxDelay;
          }
        }
        fps && fps.enter('EVENTS');
        if (firstRun) {
          firstRun = false;
        } else {
          domain.broadcastMessage('advanceFrame');
          domain.broadcastMessage('enterFrame');
          domain.broadcastMessage('constructChildren');
        }
        domain.broadcastMessage('frameConstructed');
        domain.broadcastMessage('executeFrame');
        domain.broadcastMessage('exitFrame');
        fps && fps.leave('EVENTS');
      }
      if (stage._deferRenderEvent) {
        stage._deferRenderEvent = false;
        domain.broadcastMessage('render', 'render');
      }
      if (isCanvasVisible(ctx.canvas) && (refreshStage || renderFrame)) {
        var invalidPath = null;
        if (!disablePreVisitor.value) {
          traceRenderer.value && frameWriter.enter('> Pre Visitor');
          fps && fps.enter('PRE');
          invalidPath = stage._processInvalidRegions(true);
          fps && fps.leave('PRE');
          traceRenderer.value && frameWriter.leave('< Pre Visitor');
        } else {
          stage._processInvalidRegions(false);
        }
        if (!disableRenderVisitor.value) {
          fps && fps.enter('RENDER');
          traceRenderer.value && frameWriter.enter('> Render Visitor');
          new RenderVisitor(stage, ctx, invalidPath, refreshStage).start();
          traceRenderer.value && frameWriter.leave('< Render Visitor');
          fps && fps.leave('RENDER');
        }
        if (showQuadTree.value) {
          ctx.strokeStyle = 'green';
          renderQuadTree(ctx, stage._qtree);
        }
        if (invalidPath && !refreshStage && showRedrawRegions.value) {
          ctx.strokeStyle = 'red';
          invalidPath.draw(ctx);
          ctx.stroke();
        }
      }
      if (mouseMoved && !disableMouseVisitor.value) {
        fps && renderFrame && fps.enter('MOUSE');
        traceRenderer.value && frameWriter.enter('> Mouse Visitor');
        stage._handleMouse();
        traceRenderer.value && frameWriter.leave('< Mouse Visitor');
        fps && renderFrame && fps.leave('MOUSE');
        ctx.canvas.style.cursor = stage._cursor;
      }
      if (renderFrame && events.onAfterFrame) {
        events.onAfterFrame();
      }
      if (traceRenderer.value) {
        for (var name in FrameCounter.counts) {
          appendToFrameTerminal(name + ': ' + FrameCounter.counts[name], 'gray');
        }
        var frameElapsedTime = performance.now() - frameStartTime;
        var frameFPS = 1000 / frameElapsedTime;
        frameFPSAverage.push(frameFPS);
        traceRenderer.value && appendToFrameTerminal('End Frame Time: ' + frameElapsedTime.toFixed(2) + ' (' + frameFPS.toFixed(2) + ' fps, ' + frameFPSAverage.average().toFixed(2) + ' average fps)', 'purple');
      }
    } else {
      traceRenderer.value && appendToFrameTerminal('Skip Frame', 'black');
    }
    sampleEnd();
    if (renderingTerminated) {
      if (events.onTerminated) {
        events.onTerminated();
      }
      return;
    }
    requestAnimationFrame(draw);
  }());
}
var tagHandler = function (global) {
    function defineShape($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      $.id = readUi16($bytes, $stream);
      var $0 = $.bbox = {};
      bbox($bytes, $stream, $0, swfVersion, tagCode);
      var isMorph = $.isMorph = tagCode === 46 || tagCode === 84;
      if (isMorph) {
        var $1 = $.bboxMorph = {};
        bbox($bytes, $stream, $1, swfVersion, tagCode);
      }
      var hasStrokes = $.hasStrokes = tagCode === 83 || tagCode === 84;
      if (hasStrokes) {
        var $2 = $.strokeBbox = {};
        bbox($bytes, $stream, $2, swfVersion, tagCode);
        if (isMorph) {
          var $3 = $.strokeBboxMorph = {};
          bbox($bytes, $stream, $3, swfVersion, tagCode);
        }
        var reserved = readUb($bytes, $stream, 5);
        $.fillWinding = readUb($bytes, $stream, 1);
        $.nonScalingStrokes = readUb($bytes, $stream, 1);
        $.scalingStrokes = readUb($bytes, $stream, 1);
      }
      if (isMorph) {
        $.offsetMorph = readUi32($bytes, $stream);
        morphShapeWithStyle($bytes, $stream, $, swfVersion, tagCode, isMorph, hasStrokes);
      } else {
        shapeWithStyle($bytes, $stream, $, swfVersion, tagCode, isMorph, hasStrokes);
      }
      return $;
    }
    function placeObject($bytes, $stream, $, swfVersion, tagCode) {
      var flags, hasEvents, clip, hasName, hasRatio, hasCxform, hasMatrix, place;
      var move, hasBackgroundColor, hasVisibility, hasImage, hasClassName, cache;
      var blend, hasFilters, eoe;
      $ || ($ = {});
      if (tagCode > 4) {
        if (tagCode > 26) {
          flags = readUi16($bytes, $stream);
        } else {
          flags = readUi8($bytes, $stream);
        }
        hasEvents = $.hasEvents = flags >> 7 & 1;
        clip = $.clip = flags >> 6 & 1;
        hasName = $.hasName = flags >> 5 & 1;
        hasRatio = $.hasRatio = flags >> 4 & 1;
        hasCxform = $.hasCxform = flags >> 3 & 1;
        hasMatrix = $.hasMatrix = flags >> 2 & 1;
        place = $.place = flags >> 1 & 1;
        move = $.move = flags & 1;
        if (tagCode === 70) {
          hasBackgroundColor = $.hasBackgroundColor = flags >> 15 & 1;
          hasVisibility = $.hasVisibility = flags >> 14 & 1;
          hasImage = $.hasImage = flags >> 12 & 1;
          hasClassName = $.hasClassName = flags >> 11 & 1;
          cache = $.cache = flags >> 10 & 1;
          blend = $.blend = flags >> 9 & 1;
          hasFilters = $.hasFilters = flags >> 8 & 1;
        } else {
          cache = $.cache = 0;
          blend = $.blend = 0;
          hasFilters = $.hasFilters = 0;
        }
        $.depth = readUi16($bytes, $stream);
        if (hasClassName) {
          $.className = readString($bytes, $stream, 0);
        }
        if (place) {
          $.symbolId = readUi16($bytes, $stream);
        }
        if (hasMatrix) {
          var $0 = $.matrix = {};
          matrix($bytes, $stream, $0, swfVersion, tagCode);
        }
        if (hasCxform) {
          var $1 = $.cxform = {};
          cxform($bytes, $stream, $1, swfVersion, tagCode);
        }
        if (hasRatio) {
          $.ratio = readUi16($bytes, $stream);
        }
        if (hasName) {
          $.name = readString($bytes, $stream, 0);
        }
        if (clip) {
          $.clipDepth = readUi16($bytes, $stream);
        }
        if (hasFilters) {
          var count = readUi8($bytes, $stream);
          var $2 = $.filters = [];
          var $3 = count;
          while ($3--) {
            var $4 = {};
            anyFilter($bytes, $stream, $4, swfVersion, tagCode);
            $2.push($4);
          }
        }
        if (blend) {
          $.blendMode = readUi8($bytes, $stream);
        }
        if (cache) {
          $.bmpCache = readUi8($bytes, $stream);
        }
        if (hasEvents) {
          var reserved = readUi16($bytes, $stream);
          if (swfVersion >= 6) {
            var allFlags = readUi32($bytes, $stream);
          } else {
            var allFlags = readUi16($bytes, $stream);
          }
          var $28 = $.events = [];
          do {
            var $29 = {};
            var temp = events($bytes, $stream, $29, swfVersion, tagCode);
            eoe = temp.eoe;
            $28.push($29);
          } while (!eoe);
        }
        if (hasBackgroundColor) {
          var $126 = $.backgroundColor = {};
          argb($bytes, $stream, $126, swfVersion, tagCode);
        }
        if (hasVisibility) {
          $.visibility = readUi8($bytes, $stream);
        }
      } else {
        $.place = 1;
        $.symbolId = readUi16($bytes, $stream);
        $.depth = readUi16($bytes, $stream);
        $.hasMatrix = 1;
        var $30 = $.matrix = {};
        matrix($bytes, $stream, $30, swfVersion, tagCode);
        if ($stream.remaining()) {
          $.hasCxform = 1;
          var $31 = $.cxform = {};
          cxform($bytes, $stream, $31, swfVersion, tagCode);
        }
      }
      return $;
    }
    function removeObject($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      if (tagCode === 5) {
        $.symbolId = readUi16($bytes, $stream);
      }
      $.depth = readUi16($bytes, $stream);
      return $;
    }
    function defineImage($bytes, $stream, $, swfVersion, tagCode) {
      var imgData;
      $ || ($ = {});
      $.id = readUi16($bytes, $stream);
      if (tagCode > 21) {
        var alphaDataOffset = readUi32($bytes, $stream);
        if (tagCode === 90) {
          $.deblock = readFixed8($bytes, $stream);
        }
        imgData = $.imgData = readBinary($bytes, $stream, alphaDataOffset);
        $.alphaData = readBinary($bytes, $stream, 0);
      } else {
        imgData = $.imgData = readBinary($bytes, $stream, 0);
      }
      switch (imgData[0] << 8 | imgData[1]) {
      case 65496:
      case 65497:
        $.mimeType = 'image/jpeg';
        break;
      case 35152:
        $.mimeType = 'image/png';
        break;
      case 18249:
        $.mimeType = 'image/gif';
        break;
      default:
        $.mimeType = 'application/octet-stream';
      }
      if (tagCode === 6) {
        $.incomplete = 1;
      }
      return $;
    }
    function defineButton($bytes, $stream, $, swfVersion, tagCode) {
      var eob, hasFilters, count, blend;
      $ || ($ = {});
      $.id = readUi16($bytes, $stream);
      if (tagCode == 7) {
        var $0 = $.characters = [];
        do {
          var $1 = {};
          var temp = button($bytes, $stream, $1, swfVersion, tagCode);
          eob = temp.eob;
          $0.push($1);
        } while (!eob);
        $.actionsData = readBinary($bytes, $stream, 0);
      } else {
        var trackFlags = readUi8($bytes, $stream);
        $.trackAsMenu = trackFlags >> 7 & 1;
        var actionOffset = readUi16($bytes, $stream);
        var $28 = $.characters = [];
        do {
          var $29 = {};
          var flags = readUi8($bytes, $stream);
          var eob = $29.eob = !flags;
          if (swfVersion >= 8) {
            blend = $29.blend = flags >> 5 & 1;
            hasFilters = $29.hasFilters = flags >> 4 & 1;
          } else {
            blend = $29.blend = 0;
            hasFilters = $29.hasFilters = 0;
          }
          $29.stateHitTest = flags >> 3 & 1;
          $29.stateDown = flags >> 2 & 1;
          $29.stateOver = flags >> 1 & 1;
          $29.stateUp = flags & 1;
          if (!eob) {
            $29.symbolId = readUi16($bytes, $stream);
            $29.depth = readUi16($bytes, $stream);
            var $30 = $29.matrix = {};
            matrix($bytes, $stream, $30, swfVersion, tagCode);
            if (tagCode === 34) {
              var $31 = $29.cxform = {};
              cxform($bytes, $stream, $31, swfVersion, tagCode);
            }
            if (hasFilters) {
              var count = readUi8($bytes, $stream);
              var $2 = $.filters = [];
              var $3 = count;
              while ($3--) {
                var $4 = {};
                anyFilter($bytes, $stream, $4, swfVersion, tagCode);
                $2.push($4);
              }
            }
            if (blend) {
              $29.blendMode = readUi8($bytes, $stream);
            }
          }
          $28.push($29);
        } while (!eob);
        if (!(!actionOffset)) {
          var $56 = $.buttonActions = [];
          do {
            var $57 = {};
            buttonCondAction($bytes, $stream, $57, swfVersion, tagCode);
            $56.push($57);
          } while ($stream.remaining() > 0);
        }
      }
      return $;
    }
    function defineJPEGTables($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      $.id = 0;
      $.imgData = readBinary($bytes, $stream, 0);
      $.mimeType = 'application/octet-stream';
      return $;
    }
    function setBackgroundColor($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      var $0 = $.color = {};
      rgb($bytes, $stream, $0, swfVersion, tagCode);
      return $;
    }
    function defineBinaryData($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      $.id = readUi16($bytes, $stream);
      var reserved = readUi32($bytes, $stream);
      $.data = readBinary($bytes, $stream, 0);
      return $;
    }
    function defineFont($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      $.id = readUi16($bytes, $stream);
      var firstOffset = readUi16($bytes, $stream);
      var glyphCount = $.glyphCount = firstOffset / 2;
      var restOffsets = [];
      var $0 = glyphCount - 1;
      while ($0--) {
        restOffsets.push(readUi16($bytes, $stream));
      }
      $.offsets = [
        firstOffset
      ].concat(restOffsets);
      var $1 = $.glyphs = [];
      var $2 = glyphCount;
      while ($2--) {
        var $3 = {};
        shape($bytes, $stream, $3, swfVersion, tagCode);
        $1.push($3);
      }
      return $;
    }
    function defineLabel($bytes, $stream, $, swfVersion, tagCode) {
      var eot;
      $ || ($ = {});
      $.id = readUi16($bytes, $stream);
      var $0 = $.bbox = {};
      bbox($bytes, $stream, $0, swfVersion, tagCode);
      var $1 = $.matrix = {};
      matrix($bytes, $stream, $1, swfVersion, tagCode);
      var glyphBits = $.glyphBits = readUi8($bytes, $stream);
      var advanceBits = $.advanceBits = readUi8($bytes, $stream);
      var $2 = $.records = [];
      do {
        var $3 = {};
        var temp = textRecord($bytes, $stream, $3, swfVersion, tagCode, glyphBits, advanceBits);
        eot = temp.eot;
        $2.push($3);
      } while (!eot);
      return $;
    }
    function doAction($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      if (tagCode === 59) {
        $.spriteId = readUi16($bytes, $stream);
      }
      $.actionsData = readBinary($bytes, $stream, 0);
      return $;
    }
    function defineSound($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      $.id = readUi16($bytes, $stream);
      var soundFlags = readUi8($bytes, $stream);
      $.soundFormat = soundFlags >> 4 & 15;
      $.soundRate = soundFlags >> 2 & 3;
      $.soundSize = soundFlags >> 1 & 1;
      $.soundType = soundFlags & 1;
      $.samplesCount = readUi32($bytes, $stream);
      $.soundData = readBinary($bytes, $stream, 0);
      return $;
    }
    function startSound($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      if (tagCode == 15) {
        $.soundId = readUi16($bytes, $stream);
      }
      if (tagCode == 89) {
        $.soundClassName = readString($bytes, $stream, 0);
      }
      var $0 = $.soundInfo = {};
      soundInfo($bytes, $stream, $0, swfVersion, tagCode);
      return $;
    }
    function soundStreamHead($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      var playbackFlags = readUi8($bytes, $stream);
      $.playbackRate = playbackFlags >> 2 & 3;
      $.playbackSize = playbackFlags >> 1 & 1;
      $.playbackType = playbackFlags & 1;
      var streamFlags = readUi8($bytes, $stream);
      var streamCompression = $.streamCompression = streamFlags >> 4 & 15;
      $.streamRate = streamFlags >> 2 & 3;
      $.streamSize = streamFlags >> 1 & 1;
      $.streamType = streamFlags & 1;
      $.samplesCount = readUi32($bytes, $stream);
      if (streamCompression == 2) {
        $.latencySeek = readSi16($bytes, $stream);
      }
      return $;
    }
    function soundStreamBlock($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      $.data = readBinary($bytes, $stream, 0);
      return $;
    }
    function defineBitmap($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      $.id = readUi16($bytes, $stream);
      var format = $.format = readUi8($bytes, $stream);
      $.width = readUi16($bytes, $stream);
      $.height = readUi16($bytes, $stream);
      $.hasAlpha = tagCode === 36;
      if (format === 3) {
        $.colorTableSize = readUi8($bytes, $stream);
      }
      $.bmpData = readBinary($bytes, $stream, 0);
      return $;
    }
    function defineText($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      $.id = readUi16($bytes, $stream);
      var $0 = $.bbox = {};
      bbox($bytes, $stream, $0, swfVersion, tagCode);
      var flags = readUi16($bytes, $stream);
      var hasText = $.hasText = flags >> 7 & 1;
      $.wordWrap = flags >> 6 & 1;
      $.multiline = flags >> 5 & 1;
      $.password = flags >> 4 & 1;
      $.readonly = flags >> 3 & 1;
      var hasColor = $.hasColor = flags >> 2 & 1;
      var hasMaxLength = $.hasMaxLength = flags >> 1 & 1;
      var hasFont = $.hasFont = flags & 1;
      var hasFontClass = $.hasFontClass = flags >> 15 & 1;
      $.autoSize = flags >> 14 & 1;
      var hasLayout = $.hasLayout = flags >> 13 & 1;
      $.noSelect = flags >> 12 & 1;
      $.border = flags >> 11 & 1;
      $.wasStatic = flags >> 10 & 1;
      $.html = flags >> 9 & 1;
      $.useOutlines = flags >> 8 & 1;
      if (hasFont) {
        $.fontId = readUi16($bytes, $stream);
      }
      if (hasFontClass) {
        $.fontClass = readString($bytes, $stream, 0);
      }
      if (hasFont) {
        $.fontHeight = readUi16($bytes, $stream);
      }
      if (hasColor) {
        var $1 = $.color = {};
        rgba($bytes, $stream, $1, swfVersion, tagCode);
      }
      if (hasMaxLength) {
        $.maxLength = readUi16($bytes, $stream);
      }
      if (hasLayout) {
        $.align = readUi8($bytes, $stream);
        $.leftMargin = readUi16($bytes, $stream);
        $.rightMargin = readUi16($bytes, $stream);
        $.indent = readSi16($bytes, $stream);
        $.leading = readSi16($bytes, $stream);
      }
      $.variableName = readString($bytes, $stream, 0);
      if (hasText) {
        $.initialText = readString($bytes, $stream, 0);
      }
      return $;
    }
    function frameLabel($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      $.name = readString($bytes, $stream, 0);
      return $;
    }
    function defineFont2($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      $.id = readUi16($bytes, $stream);
      var hasLayout = $.hasLayout = readUb($bytes, $stream, 1);
      if (swfVersion > 5) {
        $.shiftJis = readUb($bytes, $stream, 1);
      } else {
        var reserved = readUb($bytes, $stream, 1);
      }
      $.smallText = readUb($bytes, $stream, 1);
      $.ansi = readUb($bytes, $stream, 1);
      var wideOffset = $.wideOffset = readUb($bytes, $stream, 1);
      var wide = $.wide = readUb($bytes, $stream, 1);
      $.italic = readUb($bytes, $stream, 1);
      $.bold = readUb($bytes, $stream, 1);
      if (swfVersion > 5) {
        $.language = readUi8($bytes, $stream);
      } else {
        var reserved = readUi8($bytes, $stream);
        $.language = 0;
      }
      var nameLength = readUi8($bytes, $stream);
      $.name = readString($bytes, $stream, nameLength);
      if (tagCode === 75) {
        $.resolution = 20;
      }
      var glyphCount = $.glyphCount = readUi16($bytes, $stream);
      if (wideOffset) {
        var $0 = $.offsets = [];
        var $1 = glyphCount;
        while ($1--) {
          $0.push(readUi32($bytes, $stream));
        }
        $.mapOffset = readUi32($bytes, $stream);
      } else {
        var $2 = $.offsets = [];
        var $3 = glyphCount;
        while ($3--) {
          $2.push(readUi16($bytes, $stream));
        }
        $.mapOffset = readUi16($bytes, $stream);
      }
      var $4 = $.glyphs = [];
      var $5 = glyphCount;
      while ($5--) {
        var $6 = {};
        shape($bytes, $stream, $6, swfVersion, tagCode);
        $4.push($6);
      }
      if (wide) {
        var $47 = $.codes = [];
        var $48 = glyphCount;
        while ($48--) {
          $47.push(readUi16($bytes, $stream));
        }
      } else {
        var $49 = $.codes = [];
        var $50 = glyphCount;
        while ($50--) {
          $49.push(readUi8($bytes, $stream));
        }
      }
      if (hasLayout) {
        $.ascent = readUi16($bytes, $stream);
        $.descent = readUi16($bytes, $stream);
        $.leading = readSi16($bytes, $stream);
        var $51 = $.advance = [];
        var $52 = glyphCount;
        while ($52--) {
          $51.push(readSi16($bytes, $stream));
        }
        var $53 = $.bbox = [];
        var $54 = glyphCount;
        while ($54--) {
          var $55 = {};
          bbox($bytes, $stream, $55, swfVersion, tagCode);
          $53.push($55);
        }
        var kerningCount = readUi16($bytes, $stream);
        var $56 = $.kerning = [];
        var $57 = kerningCount;
        while ($57--) {
          var $58 = {};
          kerning($bytes, $stream, $58, swfVersion, tagCode, wide);
          $56.push($58);
        }
      }
      return $;
    }
    function fileAttributes($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      var reserved = readUb($bytes, $stream, 1);
      $.useDirectBlit = readUb($bytes, $stream, 1);
      $.useGpu = readUb($bytes, $stream, 1);
      $.hasMetadata = readUb($bytes, $stream, 1);
      $.doAbc = readUb($bytes, $stream, 1);
      $.noCrossDomainCaching = readUb($bytes, $stream, 1);
      $.relativeUrls = readUb($bytes, $stream, 1);
      $.network = readUb($bytes, $stream, 1);
      var pad = readUb($bytes, $stream, 24);
      return $;
    }
    function doABC($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      if (tagCode === 82) {
        $.flags = readUi32($bytes, $stream);
      } else {
        $.flags = 0;
      }
      if (tagCode === 82) {
        $.name = readString($bytes, $stream, 0);
      } else {
        $.name = '';
      }
      $.data = readBinary($bytes, $stream, 0);
      return $;
    }
    function symbolClass($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      var symbolCount = readUi16($bytes, $stream);
      var $0 = $.exports = [];
      var $1 = symbolCount;
      while ($1--) {
        var $2 = {};
        $2.symbolId = readUi16($bytes, $stream);
        $2.className = readString($bytes, $stream, 0);
        $0.push($2);
      }
      return $;
    }
    function defineScalingGrid($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      $.symbolId = readUi16($bytes, $stream);
      var $0 = $.splitter = {};
      bbox($bytes, $stream, $0, swfVersion, tagCode);
      return $;
    }
    function defineScene($bytes, $stream, $, swfVersion, tagCode) {
      $ || ($ = {});
      var sceneCount = readEncodedU32($bytes, $stream);
      var $0 = $.scenes = [];
      var $1 = sceneCount;
      while ($1--) {
        var $2 = {};
        $2.offset = readEncodedU32($bytes, $stream);
        $2.name = readString($bytes, $stream, 0);
        $0.push($2);
      }
      var labelCount = readEncodedU32($bytes, $stream);
      var $3 = $.labels = [];
      var $4 = labelCount;
      while ($4--) {
        var $5 = {};
        $5.frame = readEncodedU32($bytes, $stream);
        $5.name = readString($bytes, $stream, 0);
        $3.push($5);
      }
      return $;
    }
    function bbox($bytes, $stream, $, swfVersion, tagCode) {
      align($bytes, $stream);
      var bits = readUb($bytes, $stream, 5);
      var xMin = readSb($bytes, $stream, bits);
      var xMax = readSb($bytes, $stream, bits);
      var yMin = readSb($bytes, $stream, bits);
      var yMax = readSb($bytes, $stream, bits);
      $.xMin = xMin;
      $.xMax = xMax;
      $.yMin = yMin;
      $.yMax = yMax;
      align($bytes, $stream);
    }
    function rgb($bytes, $stream, $, swfVersion, tagCode) {
      $.red = readUi8($bytes, $stream);
      $.green = readUi8($bytes, $stream);
      $.blue = readUi8($bytes, $stream);
      $.alpha = 255;
      return;
    }
    function rgba($bytes, $stream, $, swfVersion, tagCode) {
      $.red = readUi8($bytes, $stream);
      $.green = readUi8($bytes, $stream);
      $.blue = readUi8($bytes, $stream);
      $.alpha = readUi8($bytes, $stream);
      return;
    }
    function argb($bytes, $stream, $, swfVersion, tagCode) {
      $.alpha = readUi8($bytes, $stream);
      $.red = readUi8($bytes, $stream);
      $.green = readUi8($bytes, $stream);
      $.blue = readUi8($bytes, $stream);
    }
    function fillSolid($bytes, $stream, $, swfVersion, tagCode, isMorph) {
      if (tagCode > 22 || isMorph) {
        var $125 = $.color = {};
        rgba($bytes, $stream, $125, swfVersion, tagCode);
      } else {
        var $126 = $.color = {};
        rgb($bytes, $stream, $126, swfVersion, tagCode);
      }
      if (isMorph) {
        var $127 = $.colorMorph = {};
        rgba($bytes, $stream, $127, swfVersion, tagCode);
      }
      return;
    }
    function matrix($bytes, $stream, $, swfVersion, tagCode) {
      align($bytes, $stream);
      var hasScale = readUb($bytes, $stream, 1);
      if (hasScale) {
        var bits = readUb($bytes, $stream, 5);
        $.a = readFb($bytes, $stream, bits);
        $.d = readFb($bytes, $stream, bits);
      } else {
        $.a = 1;
        $.d = 1;
      }
      var hasRotate = readUb($bytes, $stream, 1);
      if (hasRotate) {
        var bits = readUb($bytes, $stream, 5);
        $.b = readFb($bytes, $stream, bits);
        $.c = readFb($bytes, $stream, bits);
      } else {
        $.b = 0;
        $.c = 0;
      }
      var bits = readUb($bytes, $stream, 5);
      var e = readSb($bytes, $stream, bits);
      var f = readSb($bytes, $stream, bits);
      $.tx = e;
      $.ty = f;
      align($bytes, $stream);
    }
    function cxform($bytes, $stream, $, swfVersion, tagCode) {
      align($bytes, $stream);
      var hasOffsets = readUb($bytes, $stream, 1);
      var hasMultipliers = readUb($bytes, $stream, 1);
      var bits = readUb($bytes, $stream, 4);
      if (hasMultipliers) {
        $.redMultiplier = readSb($bytes, $stream, bits);
        $.greenMultiplier = readSb($bytes, $stream, bits);
        $.blueMultiplier = readSb($bytes, $stream, bits);
        if (tagCode > 4) {
          $.alphaMultiplier = readSb($bytes, $stream, bits);
        } else {
          $.alphaMultiplier = 256;
        }
      } else {
        $.redMultiplier = 256;
        $.greenMultiplier = 256;
        $.blueMultiplier = 256;
        $.alphaMultiplier = 256;
      }
      if (hasOffsets) {
        $.redOffset = readSb($bytes, $stream, bits);
        $.greenOffset = readSb($bytes, $stream, bits);
        $.blueOffset = readSb($bytes, $stream, bits);
        if (tagCode > 4) {
          $.alphaOffset = readSb($bytes, $stream, bits);
        } else {
          $.alphaOffset = 0;
        }
      } else {
        $.redOffset = 0;
        $.greenOffset = 0;
        $.blueOffset = 0;
        $.alphaOffset = 0;
      }
      align($bytes, $stream);
    }
    function fillGradient($bytes, $stream, $, swfVersion, tagCode, isMorph, type) {
      var $128 = $.matrix = {};
      matrix($bytes, $stream, $128, swfVersion, tagCode);
      if (isMorph) {
        var $129 = $.matrixMorph = {};
        matrix($bytes, $stream, $129, swfVersion, tagCode);
      }
      gradient($bytes, $stream, $, swfVersion, tagCode, isMorph, type);
    }
    function gradient($bytes, $stream, $, swfVersion, tagCode, isMorph, type) {
      if (tagCode === 83) {
        $.spreadMode = readUb($bytes, $stream, 2);
        $.interpolationMode = readUb($bytes, $stream, 2);
      } else {
        var pad = readUb($bytes, $stream, 4);
      }
      var count = $.count = readUb($bytes, $stream, 4);
      var $130 = $.records = [];
      var $131 = count;
      while ($131--) {
        var $132 = {};
        gradientRecord($bytes, $stream, $132, swfVersion, tagCode, isMorph);
        $130.push($132);
      }
      if (type === 19) {
        $.focalPoint = readFixed8($bytes, $stream);
        if (isMorph) {
          $.focalPointMorph = readFixed8($bytes, $stream);
        }
      }
    }
    function gradientRecord($bytes, $stream, $, swfVersion, tagCode, isMorph) {
      $.ratio = readUi8($bytes, $stream);
      if (tagCode > 22) {
        var $133 = $.color = {};
        rgba($bytes, $stream, $133, swfVersion, tagCode);
      } else {
        var $134 = $.color = {};
        rgb($bytes, $stream, $134, swfVersion, tagCode);
      }
      if (isMorph) {
        $.ratioMorph = readUi8($bytes, $stream);
        var $135 = $.colorMorph = {};
        rgba($bytes, $stream, $135, swfVersion, tagCode);
      }
    }
    function morphShapeWithStyle($bytes, $stream, $, swfVersion, tagCode, isMorph, hasStrokes) {
      var eos, bits;
      var temp = styles($bytes, $stream, $, swfVersion, tagCode, isMorph, hasStrokes);
      var lineBits = temp.lineBits;
      var fillBits = temp.fillBits;
      var $160 = $.records = [];
      do {
        var $161 = {};
        var temp = shapeRecord($bytes, $stream, $161, swfVersion, tagCode, isMorph, fillBits, lineBits, hasStrokes, bits);
        var eos = temp.eos;
        var flags = temp.flags;
        var type = temp.type;
        var fillBits = temp.fillBits;
        var lineBits = temp.lineBits;
        var bits = temp.bits;
        $160.push($161);
      } while (!eos);
      var temp = styleBits($bytes, $stream, $, swfVersion, tagCode);
      var fillBits = temp.fillBits;
      var lineBits = temp.lineBits;
      var $162 = $.recordsMorph = [];
      do {
        var $163 = {};
        var temp = shapeRecord($bytes, $stream, $163, swfVersion, tagCode, isMorph, fillBits, lineBits, hasStrokes, bits);
        eos = temp.eos;
        var flags = temp.flags;
        var type = temp.type;
        var fillBits = temp.fillBits;
        var lineBits = temp.lineBits;
        bits = temp.bits;
        $162.push($163);
      } while (!eos);
    }
    function shapeWithStyle($bytes, $stream, $, swfVersion, tagCode, isMorph, hasStrokes) {
      var eos;
      var temp = styles($bytes, $stream, $, swfVersion, tagCode, isMorph, hasStrokes);
      var fillBits = temp.fillBits;
      var lineBits = temp.lineBits;
      var $160 = $.records = [];
      do {
        var $161 = {};
        var temp = shapeRecord($bytes, $stream, $161, swfVersion, tagCode, isMorph, fillBits, lineBits, hasStrokes, bits);
        eos = temp.eos;
        var flags = temp.flags;
        var type = temp.type;
        var fillBits = temp.fillBits;
        var lineBits = temp.lineBits;
        var bits = temp.bits;
        $160.push($161);
      } while (!eos);
    }
    function shapeRecord($bytes, $stream, $, swfVersion, tagCode, isMorph, fillBits, lineBits, hasStrokes, bits) {
      var type = $.type = readUb($bytes, $stream, 1);
      var flags = readUb($bytes, $stream, 5);
      var eos = $.eos = !(type || flags);
      if (type) {
        var temp = shapeRecordEdge($bytes, $stream, $, swfVersion, tagCode, flags, bits);
        var bits = temp.bits;
      } else {
        var temp = shapeRecordSetup($bytes, $stream, $, swfVersion, tagCode, flags, isMorph, fillBits, lineBits, hasStrokes, bits);
        var fillBits = temp.fillBits;
        var lineBits = temp.lineBits;
        var bits = temp.bits;
      }
      return {
        type: type,
        flags: flags,
        eos: eos,
        fillBits: fillBits,
        lineBits: lineBits,
        bits: bits
      };
    }
    function shapeRecordEdge($bytes, $stream, $, swfVersion, tagCode, flags, bits) {
      var isStraight = 0, tmp = 0, bits = 0, isGeneral = 0, isVertical = 0;
      isStraight = $.isStraight = flags >> 4;
      tmp = flags & 15;
      bits = tmp + 2;
      if (isStraight) {
        isGeneral = $.isGeneral = readUb($bytes, $stream, 1);
        if (isGeneral) {
          $.deltaX = readSb($bytes, $stream, bits);
          $.deltaY = readSb($bytes, $stream, bits);
        } else {
          isVertical = $.isVertical = readUb($bytes, $stream, 1);
          if (isVertical) {
            $.deltaY = readSb($bytes, $stream, bits);
          } else {
            $.deltaX = readSb($bytes, $stream, bits);
          }
        }
      } else {
        $.controlDeltaX = readSb($bytes, $stream, bits);
        $.controlDeltaY = readSb($bytes, $stream, bits);
        $.anchorDeltaX = readSb($bytes, $stream, bits);
        $.anchorDeltaY = readSb($bytes, $stream, bits);
      }
      return {
        bits: bits
      };
    }
    function shapeRecordSetup($bytes, $stream, $, swfVersion, tagCode, flags, isMorph, fillBits, lineBits, hasStrokes, bits) {
      var hasNewStyles = 0, hasLineStyle = 0, hasFillStyle1 = 0;
      var hasFillStyle0 = 0, move = 0;
      if (tagCode > 2) {
        hasNewStyles = $.hasNewStyles = flags >> 4;
      } else {
        hasNewStyles = $.hasNewStyles = 0;
      }
      hasLineStyle = $.hasLineStyle = flags >> 3 & 1;
      hasFillStyle1 = $.hasFillStyle1 = flags >> 2 & 1;
      hasFillStyle0 = $.hasFillStyle0 = flags >> 1 & 1;
      move = $.move = flags & 1;
      if (move) {
        bits = readUb($bytes, $stream, 5);
        $.moveX = readSb($bytes, $stream, bits);
        $.moveY = readSb($bytes, $stream, bits);
      }
      if (hasFillStyle0) {
        $.fillStyle0 = readUb($bytes, $stream, fillBits);
      }
      if (hasFillStyle1) {
        $.fillStyle1 = readUb($bytes, $stream, fillBits);
      }
      if (hasLineStyle) {
        $.lineStyle = readUb($bytes, $stream, lineBits);
      }
      if (hasNewStyles) {
        var temp = styles($bytes, $stream, $, swfVersion, tagCode, isMorph, hasStrokes);
        var lineBits = temp.lineBits;
        var fillBits = temp.fillBits;
      }
      return {
        lineBits: lineBits,
        fillBits: fillBits,
        bits: bits
      };
    }
    function styles($bytes, $stream, $, swfVersion, tagCode, isMorph, hasStrokes) {
      fillStyleArray($bytes, $stream, $, swfVersion, tagCode, isMorph);
      lineStyleArray($bytes, $stream, $, swfVersion, tagCode, isMorph, hasStrokes);
      var temp = styleBits($bytes, $stream, $, swfVersion, tagCode);
      var fillBits = temp.fillBits;
      var lineBits = temp.lineBits;
      return {
        fillBits: fillBits,
        lineBits: lineBits
      };
    }
    function fillStyleArray($bytes, $stream, $, swfVersion, tagCode, isMorph) {
      var count;
      var tmp = readUi8($bytes, $stream);
      if (tagCode > 2 && tmp === 255) {
        count = readUi16($bytes, $stream);
      } else {
        count = tmp;
      }
      var $4 = $.fillStyles = [];
      var $5 = count;
      while ($5--) {
        var $6 = {};
        fillStyle($bytes, $stream, $6, swfVersion, tagCode, isMorph);
        $4.push($6);
      }
    }
    function lineStyleArray($bytes, $stream, $, swfVersion, tagCode, isMorph, hasStrokes) {
      var count;
      var tmp = readUi8($bytes, $stream);
      if (tagCode > 2 && tmp === 255) {
        count = readUi16($bytes, $stream);
      } else {
        count = tmp;
      }
      var $138 = $.lineStyles = [];
      var $139 = count;
      while ($139--) {
        var $140 = {};
        lineStyle($bytes, $stream, $140, swfVersion, tagCode, isMorph, hasStrokes);
        $138.push($140);
      }
    }
    function styleBits($bytes, $stream, $, swfVersion, tagCode) {
      align($bytes, $stream);
      var fillBits = readUb($bytes, $stream, 4);
      var lineBits = readUb($bytes, $stream, 4);
      return {
        fillBits: fillBits,
        lineBits: lineBits
      };
    }
    function fillStyle($bytes, $stream, $, swfVersion, tagCode, isMorph) {
      var type = $.type = readUi8($bytes, $stream);
      switch (type) {
      case 0:
        fillSolid($bytes, $stream, $, swfVersion, tagCode, isMorph);
        break;
      case 16:
      case 18:
      case 19:
        fillGradient($bytes, $stream, $, swfVersion, tagCode, isMorph, type);
        break;
      case 64:
      case 65:
      case 66:
      case 67:
        fillBitmap($bytes, $stream, $, swfVersion, tagCode, isMorph, type);
        break;
      default:
      }
    }
    function lineStyle($bytes, $stream, $, swfVersion, tagCode, isMorph, hasStrokes) {
      $.width = readUi16($bytes, $stream);
      if (isMorph) {
        $.widthMorph = readUi16($bytes, $stream);
      }
      if (hasStrokes) {
        align($bytes, $stream);
        $.startCapStyle = readUb($bytes, $stream, 2);
        var joinStyle = $.joinStyle = readUb($bytes, $stream, 2);
        var hasFill = $.hasFill = readUb($bytes, $stream, 1);
        $.noHscale = readUb($bytes, $stream, 1);
        $.noVscale = readUb($bytes, $stream, 1);
        $.pixelHinting = readUb($bytes, $stream, 1);
        var reserved = readUb($bytes, $stream, 5);
        $.noClose = readUb($bytes, $stream, 1);
        $.endCapStyle = readUb($bytes, $stream, 2);
        if (joinStyle === 2) {
          $.miterLimitFactor = readFixed8($bytes, $stream);
        }
        if (hasFill) {
          var $141 = $.fillStyle = {};
          fillStyle($bytes, $stream, $141, swfVersion, tagCode, isMorph);
        } else {
          var $155 = $.color = {};
          rgba($bytes, $stream, $155, swfVersion, tagCode);
          if (isMorph) {
            var $156 = $.colorMorph = {};
            rgba($bytes, $stream, $156, swfVersion, tagCode);
          }
        }
      } else {
        if (tagCode > 22) {
          var $157 = $.color = {};
          rgba($bytes, $stream, $157, swfVersion, tagCode);
        } else {
          var $158 = $.color = {};
          rgb($bytes, $stream, $158, swfVersion, tagCode);
        }
        if (isMorph) {
          var $159 = $.colorMorph = {};
          rgba($bytes, $stream, $159, swfVersion, tagCode);
        }
      }
    }
    function fillBitmap($bytes, $stream, $, swfVersion, tagCode, isMorph, type) {
      $.bitmapId = readUi16($bytes, $stream);
      var $18 = $.matrix = {};
      matrix($bytes, $stream, $18, swfVersion, tagCode);
      if (isMorph) {
        var $19 = $.matrixMorph = {};
        matrix($bytes, $stream, $19, swfVersion, tagCode);
      }
      $.condition = type === 64 || type === 67;
    }
    function filterGlow($bytes, $stream, $, swfVersion, tagCode, type) {
      var count;
      if (type === 4 || type === 7) {
        count = readUi8($bytes, $stream);
      } else {
        count = 1;
      }
      var $5 = $.colors = [];
      var $6 = count;
      while ($6--) {
        var $7 = {};
        rgba($bytes, $stream, $7, swfVersion, tagCode);
        $5.push($7);
      }
      if (type === 3) {
        var $8 = $.higlightColor = {};
        rgba($bytes, $stream, $8, swfVersion, tagCode);
      }
      if (type === 4 || type === 7) {
        var $9 = $.ratios = [];
        var $10 = count;
        while ($10--) {
          $9.push(readUi8($bytes, $stream));
        }
      }
      $.blurX = readFixed($bytes, $stream);
      $.blurY = readFixed($bytes, $stream);
      if (type !== 2) {
        $.angle = readFixed($bytes, $stream);
        $.distance = readFixed($bytes, $stream);
      }
      $.strength = readFixed8($bytes, $stream);
      $.innerShadow = readUb($bytes, $stream, 1);
      $.knockout = readUb($bytes, $stream, 1);
      $.compositeSource = readUb($bytes, $stream, 1);
      if (type === 3) {
        $.onTop = readUb($bytes, $stream, 1);
      } else {
        var reserved = readUb($bytes, $stream, 1);
      }
      if (type === 4 || type === 7) {
        $.passes = readUb($bytes, $stream, 4);
      } else {
        var reserved = readUb($bytes, $stream, 4);
      }
    }
    function filterBlur($bytes, $stream, $, swfVersion, tagCode) {
      $.blurX = readFixed($bytes, $stream);
      $.blurY = readFixed($bytes, $stream);
      $.passes = readUb($bytes, $stream, 5);
      var reserved = readUb($bytes, $stream, 3);
    }
    function filterConvolution($bytes, $stream, $, swfVersion, tagCode) {
      var columns = $.columns = readUi8($bytes, $stream);
      var rows = $.rows = readUi8($bytes, $stream);
      $.divisor = readFloat($bytes, $stream);
      $.bias = readFloat($bytes, $stream);
      var $17 = $.weights = [];
      var $18 = columns * rows;
      while ($18--) {
        $17.push(readFloat($bytes, $stream));
      }
      var $19 = $.defaultColor = {};
      rgba($bytes, $stream, $19, swfVersion, tagCode);
      var reserved = readUb($bytes, $stream, 6);
      $.clamp = readUb($bytes, $stream, 1);
      $.preserveAlpha = readUb($bytes, $stream, 1);
    }
    function filterColorMatrix($bytes, $stream, $, swfVersion, tagCode) {
      var $20 = $.matrix = [];
      var $21 = 20;
      while ($21--) {
        $20.push(readFloat($bytes, $stream));
      }
    }
    function anyFilter($bytes, $stream, $, swfVersion, tagCode) {
      var type = $.type = readUi8($bytes, $stream);
      switch (type) {
      case 0:
      case 2:
      case 3:
      case 4:
      case 7:
        filterGlow($bytes, $stream, $, swfVersion, tagCode, type);
        break;
      case 1:
        filterBlur($bytes, $stream, $, swfVersion, tagCode);
        break;
      case 5:
        filterConvolution($bytes, $stream, $, swfVersion, tagCode);
        break;
      case 6:
        filterColorMatrix($bytes, $stream, $, swfVersion, tagCode);
        break;
      default:
      }
    }
    function events($bytes, $stream, $, swfVersion, tagCode) {
      var flags, keyPress;
      if (swfVersion >= 6) {
        flags = readUi32($bytes, $stream);
      } else {
        flags = readUi16($bytes, $stream);
      }
      var eoe = $.eoe = !flags;
      $.onKeyUp = flags >> 7 & 1;
      $.onKeyDown = flags >> 6 & 1;
      $.onMouseUp = flags >> 5 & 1;
      $.onMouseDown = flags >> 4 & 1;
      $.onMouseMove = flags >> 3 & 1;
      $.onUnload = flags >> 2 & 1;
      $.onEnterFrame = flags >> 1 & 1;
      $.onLoad = flags & 1;
      if (swfVersion >= 6) {
        $.onDragOver = flags >> 15 & 1;
        $.onRollOut = flags >> 14 & 1;
        $.onRollOver = flags >> 13 & 1;
        $.onReleaseOutside = flags >> 12 & 1;
        $.onRelease = flags >> 11 & 1;
        $.onPress = flags >> 10 & 1;
        $.onInitialize = flags >> 9 & 1;
        $.onData = flags >> 8 & 1;
        if (swfVersion >= 7) {
          $.onConstruct = flags >> 18 & 1;
        } else {
          $.onConstruct = 0;
        }
        keyPress = $.keyPress = flags >> 17 & 1;
        $.onDragOut = flags >> 16 & 1;
      }
      if (!eoe) {
        var length = $.length = readUi32($bytes, $stream);
        if (keyPress) {
          $.keyCode = readUi8($bytes, $stream);
        }
        $.actionsData = readBinary($bytes, $stream, length - (keyPress ? 1 : 0));
      }
      return {
        eoe: eoe
      };
    }
    function kerning($bytes, $stream, $, swfVersion, tagCode, wide) {
      if (wide) {
        $.code1 = readUi16($bytes, $stream);
        $.code2 = readUi16($bytes, $stream);
      } else {
        $.code1 = readUi8($bytes, $stream);
        $.code2 = readUi8($bytes, $stream);
      }
      $.adjustment = readUi16($bytes, $stream);
    }
    function textEntry($bytes, $stream, $, swfVersion, tagCode, glyphBits, advanceBits) {
      $.glyphIndex = readUb($bytes, $stream, glyphBits);
      $.advance = readSb($bytes, $stream, advanceBits);
    }
    function textRecordSetup($bytes, $stream, $, swfVersion, tagCode, flags) {
      var hasFont = $.hasFont = flags >> 3 & 1;
      var hasColor = $.hasColor = flags >> 2 & 1;
      var hasMoveY = $.hasMoveY = flags >> 1 & 1;
      var hasMoveX = $.hasMoveX = flags & 1;
      if (hasFont) {
        $.fontId = readUi16($bytes, $stream);
      }
      if (hasColor) {
        if (tagCode === 33) {
          var $4 = $.color = {};
          rgba($bytes, $stream, $4, swfVersion, tagCode);
        } else {
          var $5 = $.color = {};
          rgb($bytes, $stream, $5, swfVersion, tagCode);
        }
      }
      if (hasMoveX) {
        $.moveX = readSi16($bytes, $stream);
      }
      if (hasMoveY) {
        $.moveY = readSi16($bytes, $stream);
      }
      if (hasFont) {
        $.fontHeight = readUi16($bytes, $stream);
      }
    }
    function textRecord($bytes, $stream, $, swfVersion, tagCode, glyphBits, advanceBits) {
      var glyphCount;
      align($bytes, $stream);
      var flags = readUb($bytes, $stream, 8);
      var eot = $.eot = !flags;
      textRecordSetup($bytes, $stream, $, swfVersion, tagCode, flags);
      if (!eot) {
        var tmp = readUi8($bytes, $stream);
        if (swfVersion > 6) {
          glyphCount = $.glyphCount = tmp;
        } else {
          glyphCount = $.glyphCount = tmp & 127;
        }
        var $6 = $.entries = [];
        var $7 = glyphCount;
        while ($7--) {
          var $8 = {};
          textEntry($bytes, $stream, $8, swfVersion, tagCode, glyphBits, advanceBits);
          $6.push($8);
        }
      }
      return {
        eot: eot
      };
    }
    function soundEnvelope($bytes, $stream, $, swfVersion, tagCode) {
      $.pos44 = readUi32($bytes, $stream);
      $.volumeLeft = readUi16($bytes, $stream);
      $.volumeRight = readUi16($bytes, $stream);
    }
    function soundInfo($bytes, $stream, $, swfVersion, tagCode) {
      var reserved = readUb($bytes, $stream, 2);
      $.stop = readUb($bytes, $stream, 1);
      $.noMultiple = readUb($bytes, $stream, 1);
      var hasEnvelope = $.hasEnvelope = readUb($bytes, $stream, 1);
      var hasLoops = $.hasLoops = readUb($bytes, $stream, 1);
      var hasOutPoint = $.hasOutPoint = readUb($bytes, $stream, 1);
      var hasInPoint = $.hasInPoint = readUb($bytes, $stream, 1);
      if (hasInPoint) {
        $.inPoint = readUi32($bytes, $stream);
      }
      if (hasOutPoint) {
        $.outPoint = readUi32($bytes, $stream);
      }
      if (hasLoops) {
        $.loopCount = readUi16($bytes, $stream);
      }
      if (hasEnvelope) {
        var envelopeCount = $.envelopeCount = readUi8($bytes, $stream);
        var $1 = $.envelopes = [];
        var $2 = envelopeCount;
        while ($2--) {
          var $3 = {};
          soundEnvelope($bytes, $stream, $3, swfVersion, tagCode);
          $1.push($3);
        }
      }
    }
    function button($bytes, $stream, $, swfVersion, tagCode) {
      var hasFilters, blend;
      var flags = readUi8($bytes, $stream);
      var eob = $.eob = !flags;
      if (swfVersion >= 8) {
        blend = $.blend = flags >> 5 & 1;
        hasFilters = $.hasFilters = flags >> 4 & 1;
      } else {
        blend = $.blend = 0;
        hasFilters = $.hasFilters = 0;
      }
      $.stateHitTest = flags >> 3 & 1;
      $.stateDown = flags >> 2 & 1;
      $.stateOver = flags >> 1 & 1;
      $.stateUp = flags & 1;
      if (!eob) {
        $.symbolId = readUi16($bytes, $stream);
        $.depth = readUi16($bytes, $stream);
        var $2 = $.matrix = {};
        matrix($bytes, $stream, $2, swfVersion, tagCode);
        if (tagCode === 34) {
          var $3 = $.cxform = {};
          cxform($bytes, $stream, $3, swfVersion, tagCode);
        }
        if (hasFilters) {
          $.filterCount = readUi8($bytes, $stream);
          var $4 = $.filters = {};
          anyFilter($bytes, $stream, $4, swfVersion, tagCode);
        }
        if (blend) {
          $.blendMode = readUi8($bytes, $stream);
        }
      }
      return {
        eob: eob
      };
    }
    function buttonCondAction($bytes, $stream, $, swfVersion, tagCode) {
      var buttonCondSize = readUi16($bytes, $stream);
      var buttonConditions = readUi16($bytes, $stream);
      $.idleToOverDown = buttonConditions >> 7 & 1;
      $.outDownToIdle = buttonConditions >> 6 & 1;
      $.outDownToOverDown = buttonConditions >> 5 & 1;
      $.overDownToOutDown = buttonConditions >> 4 & 1;
      $.overDownToOverUp = buttonConditions >> 3 & 1;
      $.overUpToOverDown = buttonConditions >> 2 & 1;
      $.overUpToIdle = buttonConditions >> 1 & 1;
      $.idleToOverUp = buttonConditions & 1;
      $.mouseEventFlags = buttonConditions & 511;
      $.keyPress = buttonConditions >> 9 & 127;
      $.overDownToIdle = buttonConditions >> 8 & 1;
      if (!buttonCondSize) {
        $.actionsData = readBinary($bytes, $stream, 0);
      } else {
        $.actionsData = readBinary($bytes, $stream, buttonCondSize - 4);
      }
    }
    function shape($bytes, $stream, $, swfVersion, tagCode) {
      var eos;
      var temp = styleBits($bytes, $stream, $, swfVersion, tagCode);
      var fillBits = temp.fillBits;
      var lineBits = temp.lineBits;
      var $4 = $.records = [];
      do {
        var $5 = {};
        var isMorph = false;
        var hasStrokes = false;
        var temp = shapeRecord($bytes, $stream, $5, swfVersion, tagCode, isMorph, fillBits, lineBits, hasStrokes, bits);
        eos = temp.eos;
        var fillBits = temp.fillBits;
        var lineBits = temp.lineBits;
        var bits = bits;
        $4.push($5);
      } while (!eos);
    }
    return {
      0: undefined,
      1: undefined,
      2: defineShape,
      4: placeObject,
      5: removeObject,
      6: defineImage,
      7: defineButton,
      8: defineJPEGTables,
      9: setBackgroundColor,
      10: defineFont,
      11: defineLabel,
      12: doAction,
      13: undefined,
      14: defineSound,
      15: startSound,
      17: undefined,
      18: soundStreamHead,
      19: soundStreamBlock,
      20: defineBitmap,
      21: defineImage,
      22: defineShape,
      23: undefined,
      24: undefined,
      26: placeObject,
      28: removeObject,
      32: defineShape,
      33: defineLabel,
      34: defineButton,
      35: defineImage,
      36: defineBitmap,
      37: defineText,
      39: undefined,
      43: frameLabel,
      45: soundStreamHead,
      46: defineShape,
      48: defineFont2,
      56: undefined,
      57: undefined,
      58: undefined,
      59: doAction,
      60: undefined,
      61: undefined,
      62: undefined,
      64: undefined,
      65: undefined,
      66: undefined,
      69: fileAttributes,
      70: placeObject,
      71: undefined,
      72: doABC,
      73: undefined,
      74: undefined,
      75: defineFont2,
      76: symbolClass,
      77: undefined,
      78: defineScalingGrid,
      82: doABC,
      83: defineShape,
      84: defineShape,
      86: defineScene,
      87: defineBinaryData,
      88: undefined,
      89: startSound,
      90: defineImage,
      91: undefined
    };
  }(this);
var readHeader = function readHeader($bytes, $stream, $, swfVersion, tagCode) {
  $ || ($ = {});
  var $0 = $.bbox = {};
  align($bytes, $stream);
  var bits = readUb($bytes, $stream, 5);
  var xMin = readSb($bytes, $stream, bits);
  var xMax = readSb($bytes, $stream, bits);
  var yMin = readSb($bytes, $stream, bits);
  var yMax = readSb($bytes, $stream, bits);
  $0.xMin = xMin;
  $0.xMax = xMax;
  $0.yMin = yMin;
  $0.yMax = yMax;
  align($bytes, $stream);
  var frameRateFraction = readUi8($bytes, $stream);
  $.frameRate = readUi8($bytes, $stream) + frameRateFraction / 256;
  $.frameCount = readUi16($bytes, $stream);
  return $;
};
function readTags(context, stream, swfVersion, onprogress) {
  var tags = context.tags;
  var bytes = stream.bytes;
  var lastSuccessfulPosition;
  try {
    do {
      lastSuccessfulPosition = stream.pos;
      stream.ensure(2);
      var tagCodeAndLength = readUi16(bytes, stream);
      var tagCode = tagCodeAndLength >> 6;
      var length = tagCodeAndLength & 63;
      if (length === 63) {
        stream.ensure(4);
        length = readUi32(bytes, stream);
      }
      stream.ensure(length);
      if (tagCode === 0) {
        break;
      }
      var substream = stream.substream(stream.pos, stream.pos += length);
      var subbytes = substream.bytes;
      var tag = {
          code: tagCode
        };
      if (tagCode === 39) {
        tag.type = 'sprite';
        tag.id = readUi16(subbytes, substream);
        tag.frameCount = readUi16(subbytes, substream);
        tag.tags = [];
        readTags(tag, substream, swfVersion);
      } else {
        var handler = tagHandler[tagCode];
        if (handler) {
          handler(subbytes, substream, tag, swfVersion, tagCode);
        }
      }
      tags.push(tag);
      if (tagCode === 1) {
        while (stream.pos + 2 <= stream.end && stream.getUint16(stream.pos, true) >> 6 === 1) {
          tags.push(tag);
          stream.pos += 2;
        }
        if (onprogress)
          onprogress(context);
      } else if (onprogress && tag.id !== undefined) {
        onprogress(context);
      }
    } while (stream.pos < stream.end);
  } catch (e) {
    if (e !== StreamNoDataError)
      throw e;
    stream.pos = lastSuccessfulPosition;
  }
}
function HeadTailBuffer(defaultSize) {
  this.bufferSize = defaultSize || 16;
  this.buffer = new Uint8Array(this.bufferSize);
  this.pos = 0;
}
HeadTailBuffer.prototype = {
  push: function (data, need) {
    var bufferLengthNeed = this.pos + data.length;
    if (this.bufferSize < bufferLengthNeed) {
      var newBufferSize = this.bufferSize;
      while (newBufferSize < bufferLengthNeed) {
        newBufferSize <<= 1;
      }
      var newBuffer = new Uint8Array(newBufferSize);
      if (this.bufferSize > 0) {
        newBuffer.set(this.buffer);
      }
      this.buffer = newBuffer;
      this.bufferSize = newBufferSize;
    }
    this.buffer.set(data, this.pos);
    this.pos += data.length;
    if (need)
      return this.pos >= need;
  },
  getHead: function (size) {
    return this.buffer.subarray(0, size);
  },
  getTail: function (offset) {
    return this.buffer.subarray(offset, this.pos);
  },
  removeHead: function (size) {
    var tail = this.getTail(size);
    this.buffer = new Uint8Array(this.bufferSize);
    this.buffer.set(tail);
    this.pos = tail.length;
  },
  get arrayBuffer() {
    return this.buffer.buffer;
  },
  get length() {
    return this.pos;
  },
  createStream: function () {
    return new Stream(this.arrayBuffer, 0, this.length);
  }
};
function CompressedPipe(target, length) {
  this.target = target;
  this.length = length;
  this.initialize = true;
  this.buffer = new HeadTailBuffer(8096);
  this.state = {
    bitBuffer: 0,
    bitLength: 0,
    compression: {}
  };
  this.output = {
    data: new Uint8Array(length),
    available: 0,
    completed: false
  };
}
CompressedPipe.prototype = {
  push: function (data, progressInfo) {
    var buffer = this.buffer;
    if (this.initialize) {
      if (!buffer.push(data, 2))
        return;
      var headerBytes = buffer.getHead(2);
      verifyDeflateHeader(headerBytes);
      buffer.removeHead(2);
      this.initialize = false;
    } else {
      buffer.push(data);
    }
    var stream = buffer.createStream();
    stream.bitBuffer = this.state.bitBuffer;
    stream.bitLength = this.state.bitLength;
    var output = this.output;
    var lastAvailable = output.available;
    try {
      do {
        inflateBlock(stream, output, this.state.compression);
      } while (stream.pos < buffer.length && !output.completed);
    } catch (e) {
      if (e !== InflateNoDataError)
        throw e;
    } finally {
      this.state.bitBuffer = stream.bitBuffer;
      this.state.bitLength = stream.bitLength;
    }
    buffer.removeHead(stream.pos);
    this.target.push(output.data.subarray(lastAvailable, output.available), progressInfo);
  }
};
function BodyParser(swfVersion, length, options) {
  this.swf = {
    swfVersion: swfVersion,
    parseTime: 0
  };
  this.buffer = new HeadTailBuffer(32768);
  this.initialize = true;
  this.totalRead = 0;
  this.length = length;
  this.options = options;
}
BodyParser.prototype = {
  push: function (data, progressInfo) {
    if (data.length === 0)
      return;
    var swf = this.swf;
    var swfVersion = swf.swfVersion;
    var buffer = this.buffer;
    var options = this.options;
    var stream;
    if (this.initialize) {
      var PREFETCH_SIZE = 27;
      if (!buffer.push(data, PREFETCH_SIZE))
        return;
      stream = buffer.createStream();
      var bytes = stream.bytes;
      readHeader(bytes, stream, swf);
      var nextTagHeader = readUi16(bytes, stream);
      var FILE_ATTRIBUTES_LENGTH = 4;
      if (nextTagHeader == (SWF_TAG_CODE_FILE_ATTRIBUTES << 6 | FILE_ATTRIBUTES_LENGTH)) {
        stream.ensure(FILE_ATTRIBUTES_LENGTH);
        var substream = stream.substream(stream.pos, stream.pos += FILE_ATTRIBUTES_LENGTH);
        var handler = tagHandler[SWF_TAG_CODE_FILE_ATTRIBUTES];
        var fileAttributesTag = {
            code: SWF_TAG_CODE_FILE_ATTRIBUTES
          };
        handler(substream.bytes, substream, fileAttributesTag, swfVersion, SWF_TAG_CODE_FILE_ATTRIBUTES);
        swf.fileAttributes = fileAttributesTag;
      } else {
        stream.pos -= 2;
        swf.fileAttributes = {};
      }
      if (options.onstart)
        options.onstart(swf);
      swf.tags = [];
      this.initialize = false;
    } else {
      buffer.push(data);
      stream = buffer.createStream();
    }
    if (progressInfo) {
      swf.bytesLoaded = progressInfo.bytesLoaded;
      swf.bytesTotal = progressInfo.bytesTotal;
    }
    var readStartTime = performance.now();
    readTags(swf, stream, swfVersion, options.onprogress);
    swf.parseTime += performance.now() - readStartTime;
    var read = stream.pos;
    buffer.removeHead(read);
    this.totalRead += read;
    if (this.totalRead >= this.length && options.oncomplete) {
      options.oncomplete(swf);
    }
  }
};
SWF.parseAsync = function swf_parseAsync(options) {
  var buffer = new HeadTailBuffer();
  var pipe = {
      push: function (data, progressInfo) {
        if (this.target !== undefined) {
          return this.target.push(data, progressInfo);
        }
        if (!buffer.push(data, 8)) {
          return null;
        }
        var bytes = buffer.getHead(8);
        var magic1 = bytes[0];
        var magic2 = bytes[1];
        var magic3 = bytes[2];
        if ((magic1 === 70 || magic1 === 67) && magic2 === 87 && magic3 === 83) {
          var swfVersion = bytes[3];
          var compressed = magic1 === 67;
          parseSWF(compressed, swfVersion, progressInfo);
          buffer = null;
          return;
        }
        var isImage = false;
        var imageType;
        if (magic1 === 255 && magic2 === 216 && magic3 === 255) {
          isImage = true;
          imageType = 'image/jpeg';
        } else if (magic1 === 137 && magic2 === 80 && magic3 === 78) {
          isImage = true;
          imageType = 'image/png';
        }
        if (isImage) {
          parseImage(data, progressInfo.bytesTotal, imageType);
        }
        buffer = null;
      },
      close: function () {
        if (buffer) {
          var symbol = {
              command: 'empty',
              data: buffer.buffer.subarray(0, buffer.pos)
            };
          options.oncomplete && options.oncomplete(symbol);
        }
        if (this.target !== undefined && this.target.close) {
          this.target.close();
        }
      }
    };
  function parseSWF(compressed, swfVersion, progressInfo) {
    var stream = buffer.createStream();
    stream.pos += 4;
    var fileLength = readUi32(null, stream);
    var bodyLength = fileLength - 8;
    var target = new BodyParser(swfVersion, bodyLength, options);
    if (compressed) {
      target = new CompressedPipe(target, bodyLength);
    }
    target.push(buffer.getTail(8), progressInfo);
    pipe['target'] = target;
  }
  function parseImage(data, bytesTotal, type) {
    var buffer = new Uint8Array(bytesTotal);
    buffer.set(data);
    var bufferPos = data.length;
    pipe['target'] = {
      push: function (data) {
        buffer.set(data, bufferPos);
        bufferPos += data.length;
      },
      close: function () {
        var props = {};
        var chunks;
        if (type == 'image/jpeg') {
          chunks = parseJpegChunks(props, buffer);
        } else {
          chunks = [
            buffer
          ];
        }
        var symbol = {
            type: 'image',
            props: props,
            data: new Blob(chunks, {
              type: type
            })
          };
        options.oncomplete && options.oncomplete(symbol);
      }
    };
  }
  return pipe;
};
SWF.parse = function (buffer, options) {
  if (!options)
    options = {};
  var pipe = SWF.parseAsync(options);
  var bytes = new Uint8Array(buffer);
  var progressInfo = {
      bytesLoaded: bytes.length,
      bytesTotal: bytes.length
    };
  pipe.push(bytes, progressInfo);
};
function ActionsDataStream(array, swfVersion) {
  this.array = array;
  this.position = 0;
  this.end = array.length;
  if (swfVersion >= 6) {
    this.readString = this.readUTF8String;
  } else {
    this.readString = this.readANSIString;
  }
  var buffer = new ArrayBuffer(4);
  new Int32Array(buffer)[0] = 1;
  if (!new Uint8Array(buffer)[0]) {
    throw new Error('big-endian platform');
  }
}
ActionsDataStream.prototype = {
  readUI8: function ActionsDataStream_readUI8() {
    return this.array[this.position++];
  },
  readUI16: function ActionsDataStream_readUI16() {
    var position = this.position, array = this.array;
    var value = array[position + 1] << 8 | array[position];
    this.position = position + 2;
    return value;
  },
  readSI16: function ActionsDataStream_readSI16() {
    var position = this.position, array = this.array;
    var value = array[position + 1] << 8 | array[position];
    this.position = position + 2;
    return value < 32768 ? value : value - 65536;
  },
  readInteger: function ActionsDataStream_readInteger() {
    var position = this.position, array = this.array;
    var value = array[position] | array[position + 1] << 8 | array[position + 2] << 16 | array[position + 3] << 24;
    this.position = position + 4;
    return value;
  },
  readFloat: function ActionsDataStream_readFloat() {
    var position = this.position;
    var array = this.array;
    var buffer = new ArrayBuffer(4);
    var bytes = new Uint8Array(buffer);
    bytes[0] = array[position];
    bytes[1] = array[position + 1];
    bytes[2] = array[position + 2];
    bytes[3] = array[position + 3];
    this.position = position + 4;
    return new Float32Array(buffer)[0];
  },
  readDouble: function ActionsDataStream_readDouble() {
    var position = this.position;
    var array = this.array;
    var buffer = new ArrayBuffer(8);
    var bytes = new Uint8Array(buffer);
    bytes[4] = array[position];
    bytes[5] = array[position + 1];
    bytes[6] = array[position + 2];
    bytes[7] = array[position + 3];
    bytes[0] = array[position + 4];
    bytes[1] = array[position + 5];
    bytes[2] = array[position + 6];
    bytes[3] = array[position + 7];
    this.position = position + 8;
    return new Float64Array(buffer)[0];
  },
  readBoolean: function ActionsDataStream_readBoolean() {
    return !(!this.readUI8());
  },
  readANSIString: function ActionsDataStream_readANSIString() {
    var value = '';
    var ch;
    while (ch = this.readUI8()) {
      value += String.fromCharCode(ch);
    }
    return value;
  },
  readUTF8String: function ActionsDataStream_readUTF8String() {
    var value = '';
    var ch;
    while (ch = this.readUI8()) {
      if (ch < 128) {
        value += String.fromCharCode(ch);
        continue;
      }
      if ((ch & 192) === 128) {
        throw new Error('Invalid UTF8 encoding');
      }
      var currentPrefix = 192;
      var validBits = 5;
      do {
        var mask = currentPrefix >> 1 | 128;
        if ((ch & mask) === currentPrefix) {
          break;
        }
        currentPrefix = mask;
        --validBits;
      } while (validBits >= 0);
      var code = ch & (1 << validBits) - 1;
      for (var i = 5; i >= validBits; --i) {
        ch = this.readUI8();
        if ((ch & 192) !== 128) {
          throw new Error('Invalid UTF8 encoding');
        }
        code = code << 6 | ch & 63;
      }
      if (code >= 65536) {
        value += String.fromCharCode(code - 65536 >> 10 & 1023 | 55296, code & 1023 | 56320);
      } else {
        value += String.fromCharCode(code);
      }
    }
    return value;
  },
  readBytes: function ActionsDataStream_readBytes(length) {
    var position = this.position;
    var remaining = Math.max(this.end - position, 0);
    if (remaining < length) {
      length = remaining;
    }
    var subarray = this.array.subarray(position, position + length);
    this.position = position + length;
    return subarray;
  }
};
if (typeof GLOBAL !== 'undefined') {
  GLOBAL.ActionsDataStream = ActionsDataStream;
}
var AVM1_TRACE_ENABLED = false;
var AVM1_ERRORS_IGNORED = true;
var MAX_AVM1_INSTRUCTIONS_LIMIT = 100000;
var MAX_AVM1_ERRORS_LIMIT = 1000;
var MAX_AVM1_STACK_LIMIT = 256;
function AS2ScopeListItem(scope, next) {
  this.scope = scope;
  this.next = next;
}
AS2ScopeListItem.prototype = {
  create: function (scope) {
    return new AS2ScopeListItem(scope, this);
  }
};
function AS2Context(swfVersion) {
  this.swfVersion = swfVersion;
  this.globals = new avm1lib.AS2Globals(this);
  this.initialScope = new AS2ScopeListItem(this.globals, null);
  this.assets = {};
  this.instructionsExecuted = 0;
  this.stackDepth = 0;
  this.isTryCatchListening = false;
  this.errorsIgnored = 0;
  this.deferScriptExecution = true;
  this.pendingScripts = [];
}
AS2Context.instance = null;
AS2Context.prototype = {
  addAssets: function (assets) {
    for (var i = 0; i < assets.length; i++) {
      if (assets[i].className) {
        this.assets[assets[i].className] = assets[i];
      }
    }
  },
  resolveTarget: function (target) {
    if (!target) {
      target = this.defaultTarget;
    } else if (typeof target === 'string') {
      target = lookupAS2Children(target, this.defaultTarget, this.globals.asGetPublicProperty('_root'));
    }
    if (typeof target !== 'object' || target === null || !('$nativeObject' in target)) {
      throw new Error('Invalid AS2 target object: ' + Object.prototype.toString.call(target));
    }
    return target;
  },
  resolveLevel: function (level) {
    return this.resolveTarget(this.globals['_level' + level]);
  },
  addToPendingScripts: function (fn) {
    if (!this.deferScriptExecution) {
      return fn();
    }
    this.pendingScripts.push(fn);
  },
  flushPendingScripts: function () {
    var scripts = this.pendingScripts;
    while (scripts.length) {
      scripts.shift()();
    }
    this.deferScriptExecution = false;
  }
};
function AS2Error(error) {
  this.error = error;
}
function AS2CriticalError(message, error) {
  this.message = message;
  this.error = error;
}
AS2CriticalError.prototype = Object.create(Error.prototype);
function isAS2MovieClip(obj) {
  return typeof obj === 'object' && obj && obj instanceof avm1lib.AS2MovieClip;
}
function as2GetType(v) {
  if (v === null) {
    return 'null';
  }
  var type = typeof v;
  if (type === 'function') {
    return 'object';
  }
  if (type === 'object' && isAS2MovieClip(v)) {
    return 'movieclip';
  }
  return type;
}
function as2ToPrimitive(value) {
  return as2GetType(value) !== 'object' ? value : value.valueOf();
}
function as2ToAddPrimitive(value) {
  if (as2GetType(value) !== 'object') {
    return value;
  }
  if (value instanceof Date && AS2Context.instance.swfVersion >= 6) {
    return value.toString();
  } else {
    return value.valueOf();
  }
}
function as2ToBoolean(value) {
  switch (as2GetType(value)) {
  default:
  case 'undefined':
  case 'null':
    return false;
  case 'boolean':
    return value;
  case 'number':
    return value !== 0 && !isNaN(value);
  case 'string':
    return value.length !== 0;
  case 'movieclip':
  case 'object':
    return true;
  }
}
function as2ToNumber(value) {
  value = as2ToPrimitive(value);
  switch (as2GetType(value)) {
  case 'undefined':
  case 'null':
    return AS2Context.instance.swfVersion >= 7 ? NaN : 0;
  default:
    return AS2Context.instance.swfVersion >= 5 ? NaN : 0;
  case 'null':
    return NaN;
  case 'boolean':
    return value ? 1 : +0;
  case 'number':
    return value;
  case 'string':
    if (value === '' && AS2Context.instance.swfVersion < 5) {
      return 0;
    }
    return +value;
  }
}
function as2ToInteger(value) {
  var result = as2ToNumber(value);
  if (isNaN(result)) {
    return 0;
  }
  if (!isFinite(result) || result === 0) {
    return result;
  }
  return (result < 0 ? -1 : 1) * Math.abs(result) | 0;
}
function as2ToInt32(value) {
  var result = as2ToNumber(value);
  return isNaN(result) || !isFinite(result) || result === 0 ? 0 : result | 0;
}
function as2ToString(value) {
  switch (as2GetType(value)) {
  case 'undefined':
    return AS2Context.instance.swfVersion >= 7 ? 'undefined' : '';
  case 'null':
    return 'null';
  case 'boolean':
    return value ? 'true' : 'false';
  case 'number':
    return value.toString();
  case 'string':
    return value;
  case 'undefined':
    return 'undefined';
  case 'movieclip':
    return value.$targetPath;
  case 'object':
    var result = value.toString !== Function.prototype.toString ? value.toString() : value;
    if (typeof result === 'string') {
      return result;
    }
    return typeof value === 'function' ? '[type Function]' : '[type Object]';
  }
}
function as2Compare(x, y) {
  var x2 = as2ToPrimitive(x);
  var y2 = as2ToPrimitive(y);
  if (typeof x2 === 'string' && typeof y2 === 'string') {
    return x2 < y2;
  } else {
    return as2ToNumber(x2) < as2ToNumber(y2);
  }
}
function as2InstanceOf(obj, constructor) {
  if (obj instanceof constructor) {
    return true;
  }
  return false;
}
function as2ResolveProperty(obj, name) {
  var avm2PublicName = Multiname.getPublicQualifiedName(name);
  if (avm2PublicName in obj) {
    return name;
  }
  if (isNumeric(name)) {
    return null;
  }
  var lowerCaseName = avm2PublicName.toLowerCase();
  for (var i in obj) {
    if (i.toLowerCase() === lowerCaseName) {
      return i.substr(Multiname.PUBLIC_QUALIFIED_NAME_PREFIX.length);
    }
  }
  return null;
}
function as2GetPrototype(obj) {
  return obj && obj.asGetPublicProperty('prototype');
}
function isAvm2Class(obj) {
  return typeof obj === 'object' && obj !== null && 'instanceConstructor' in obj;
}
function as2CreatePrototypeProxy(obj) {
  var prototype = obj.asGetPublicProperty('prototype');
  if (typeof Proxy === 'undefined') {
    console.error('ES6 proxies are not found');
    return prototype;
  }
  return Proxy.create({
    getOwnPropertyDescriptor: function (name) {
      return Object.getOwnPropertyDescriptor(prototype, name);
    },
    getPropertyDescriptor: function (name) {
      for (var p = prototype; p; p = Object.getPrototypeOf(p)) {
        var desc = Object.getOwnPropertyDescriptor(p, name);
        if (desc)
          return desc;
      }
    },
    getOwnPropertyNames: function () {
      return Object.getOwnPropertyNames(prototype);
    },
    getPropertyNames: function () {
      var names = Object.getOwnPropertyNames(prototype);
      for (var p = Object.getPrototypeOf(prototype); p; p = Object.getPrototypeOf(p)) {
        names = names.concat(Object.getOwnPropertyNames(p));
      }
      return names;
    },
    defineProperty: function (name, desc) {
      if (desc) {
        if (typeof desc.value === 'function' && desc.value._setClass) {
          desc.value._setClass(obj);
        }
        if (typeof desc.get === 'function' && desc.get._setClass) {
          desc.get._setClass(obj);
        }
        if (typeof desc.set === 'function' && desc.set._setClass) {
          desc.set._setClass(obj);
        }
      }
      return Object.defineProperty(prototype, name, desc);
    },
    delete: function (name) {
      return delete prototype[name];
    },
    fix: function () {
      return undefined;
    }
  });
}
function executeActions(actionsData, context, scope, assets) {
  var actionTracer = ActionTracerFactory.get();
  var scopeContainer = context.initialScope.create(scope);
  var savedContext = AS2Context.instance;
  try {
    AS2Context.instance = context;
    context.defaultTarget = scope;
    context.globals.asSetPublicProperty('this', scope);
    if (assets) {
      context.addAssets(assets);
    }
    actionTracer.message('ActionScript Execution Starts');
    actionTracer.indent();
    interpretActions(actionsData, scopeContainer, null, []);
  } finally {
    context.instructionsExecuted = 0;
    context.errorsIgnored = 0;
    actionTracer.unindent();
    actionTracer.message('ActionScript Execution Stops');
    AS2Context.instance = savedContext;
  }
}
function lookupAS2Children(targetPath, defaultTarget, root) {
  var path = targetPath.split(/[\/.]/g);
  if (path[path.length - 1] === '') {
    path.pop();
  }
  var obj = defaultTarget;
  if (path[0] === '' || path[0] === '_level0' || path[0] === '_root') {
    obj = root;
    path.shift();
  }
  while (path.length > 0) {
    var prevObj = obj;
    obj = obj.$lookupChild(path[0]);
    if (!obj) {
      throw new Error(path[0] + ' (expr ' + targetPath + ') is not found in ' + prevObj._target);
    }
    path.shift();
  }
  return obj;
}
function createBuiltinType(obj, args) {
  if (obj === Array) {
    var result = args;
    if (args.length == 1 && typeof args[0] === 'number') {
      result = [];
      result.length = args[0];
    }
    return result;
  }
  if (obj === Boolean || obj === Number || obj === String || obj === Function) {
    return obj.apply(null, args);
  }
  if (obj === Date) {
    switch (args.length) {
    case 0:
      return new Date();
    case 1:
      return new Date(args[0]);
    default:
      return new Date(args[0], args[1], args.length > 2 ? args[2] : 1, args.length > 3 ? args[3] : 0, args.length > 4 ? args[4] : 0, args.length > 5 ? args[5] : 0, args.length > 6 ? args[6] : 0);
    }
  }
  if (obj === Object) {
    return {};
  }
}
var AS2_SUPER_STUB = {};
function interpretActions(actionsData, scopeContainer, constantPool, registers) {
  var currentContext = AS2Context.instance;
  function setTarget(targetPath) {
    if (!targetPath) {
      currentContext.defaultTarget = scope;
      return;
    }
    try {
      currentContext.defaultTarget = lookupAS2Children(targetPath, defaultTarget, _global.asGetPublicProperty('_root'));
    } catch (e) {
      currentContext.defaultTarget = null;
      throw e;
    }
  }
  function defineFunction(functionName, parametersNames, registersAllocation, actionsData) {
    var ownerClass;
    var fn = function () {
      var newScope = {};
      newScope.asSetPublicProperty('this', this);
      newScope.asSetPublicProperty('arguments', arguments);
      newScope.asSetPublicProperty('super', AS2_SUPER_STUB);
      newScope.asSetPublicProperty('__class', ownerClass);
      var newScopeContainer = scopeContainer.create(newScope);
      var i;
      for (i = 0; i < arguments.length || i < parametersNames.length; i++) {
        newScope.asSetPublicProperty(parametersNames[i], arguments[i]);
      }
      var registers = [];
      if (registersAllocation) {
        for (i = 0; i < registersAllocation.length; i++) {
          var registerAllocation = registersAllocation[i];
          if (!registerAllocation) {
            continue;
          }
          if (registerAllocation.type == 'param') {
            registers[i] = arguments[registerAllocation.index];
          } else {
            switch (registerAllocation.name) {
            case 'this':
              registers[i] = this;
              break;
            case 'arguments':
              registers[i] = arguments;
              break;
            case 'super':
              registers[i] = AS2_SUPER_STUB;
              break;
            case '_global':
              registers[i] = _global;
              break;
            case '_parent':
              registers[i] = scope.asGetPublicProperty('_parent');
              break;
            case '_root':
              registers[i] = _global.asGetPublicProperty('_root');
              break;
            }
          }
        }
      }
      var savedContext = AS2Context.instance;
      var resetCounters;
      try {
        AS2Context.instance = currentContext;
        resetCounters = currentContext.instructionsExecuted === 0;
        currentContext.defaultTarget = scope;
        actionTracer.indent();
        currentContext.stackDepth++;
        if (currentContext.stackDepth >= MAX_AVM1_STACK_LIMIT) {
          throw new AS2CriticalError('long running script -- AVM1 recursion limit is reached');
        }
        return interpretActions(actionsData, newScopeContainer, constantPool, registers);
      } finally {
        if (resetCounters) {
          currentContext.instructionsExecuted = 0;
          currentContext.errorsIgnored = 0;
        }
        currentContext.stackDepth--;
        actionTracer.unindent();
        currentContext.defaultTarget = defaultTarget;
        AS2Context.instance = savedContext;
      }
    };
    ownerClass = fn;
    fn._setClass = function (class_) {
      ownerClass = class_;
    };
    fn.instanceConstructor = fn;
    fn.debugName = 'avm1 ' + (functionName || '<function>');
    if (functionName) {
      fn.name = functionName;
    }
    return fn;
  }
  function deleteProperty(propertyName) {
    for (var p = scopeContainer; p; p = p.next) {
      if (p.scope.asHasProperty(undefined, propertyName, 0)) {
        p.scope.asSetPublicProperty(propertyName, undefined);
        return p.scope.asDeleteProperty(undefined, propertyName, 0);
      }
    }
    return false;
  }
  function resolveVariableName(variableName, nonStrict) {
    var obj, name, i;
    if (variableName.indexOf(':') >= 0) {
      var parts = variableName.split(':');
      obj = lookupAS2Children(parts[0], defaultTarget, _global.asGetPublicProperty('_root'));
      if (!obj) {
        throw new Error(parts[0] + ' is undefined');
      }
      name = parts[1];
    } else if (variableName.indexOf('.') >= 0) {
      var objPath = variableName.split('.');
      name = objPath.pop();
      obj = _global;
      for (i = 0; i < objPath.length; i++) {
        obj = obj.asGetPublicProperty(objPath[i]) || obj[objPath[i]];
        if (!obj) {
          throw new Error(objPath.slice(0, i + 1) + ' is undefined');
        }
      }
    }
    if (!obj) {
      return null;
    }
    var resolvedName = as2ResolveProperty(obj, name);
    var resolved = resolvedName !== null;
    if (resolved || nonStrict) {
      return {
        obj: obj,
        name: resolvedName || name,
        resolved: resolved
      };
    }
    return null;
  }
  function getThis() {
    var _this = scope.asGetPublicProperty('this');
    if (_this) {
      return _this;
    }
    for (var p = scopeContainer; p; p = p.next) {
      resolvedName = as2ResolveProperty(p.scope, 'this');
      if (resolvedName !== null) {
        return p.scope.asGetPublicProperty(resolvedName);
      }
    }
  }
  function getVariable(variableName) {
    if (scope.asHasProperty(undefined, variableName, 0)) {
      return scope.asGetPublicProperty(variableName);
    }
    var target = resolveVariableName(variableName);
    if (target) {
      return target.obj.asGetPublicProperty(target.name);
    }
    var resolvedName, _this = getThis();
    for (var p = scopeContainer; p; p = p.next) {
      resolvedName = as2ResolveProperty(p.scope, variableName);
      if (resolvedName !== null) {
        return p.scope.asGetPublicProperty(resolvedName);
      }
    }
    if (_this && (resolvedName = as2ResolveProperty(_this, variableName))) {
      return _this.asGetPublicProperty(resolvedName);
    }
    var mc = isAS2MovieClip(defaultTarget) && defaultTarget.$lookupChild(variableName);
    if (mc) {
      return mc;
    }
  }
  function setVariable(variableName, value) {
    if (scope.asHasProperty(undefined, variableName, 0)) {
      scope.asSetPublicProperty(variableName, value);
      return;
    }
    var target = resolveVariableName(variableName, true);
    if (target) {
      target.obj.asSetPublicProperty(target.name, value);
      return;
    }
    var resolvedName, _this = getThis();
    if (_this && (resolvedName = as2ResolveProperty(_this, variableName))) {
      return _this.asSetPublicProperty(resolvedName, value);
    }
    for (var p = scopeContainer; p.next; p = p.next) {
      resolvedName = as2ResolveProperty(p.scope, variableName);
      if (resolvedName !== null) {
        return p.scope.asSetPublicProperty(resolvedName, value);
      }
    }
    (_this || scope).asSetPublicProperty(variableName, value);
  }
  function getFunction(functionName) {
    var fn = getVariable(functionName);
    if (!(fn instanceof Function)) {
      throw new Error('Function "' + functionName + '" is not found');
    }
    return fn;
  }
  function getObjectByName(objectName) {
    var obj = getVariable(objectName);
    if (!(obj instanceof Object)) {
      throw new Error('Object "' + objectName + '" is not found');
    }
    return obj;
  }
  function processWith(obj, withBlock) {
    var newScopeContainer = scopeContainer.create(Object(obj));
    interpretActions(withBlock, newScopeContainer, constantPool, registers);
  }
  function processTry(catchIsRegisterFlag, finallyBlockFlag, catchBlockFlag, catchTarget, tryBlock, catchBlock, finallyBlock) {
    var savedTryCatchState = currentContext.isTryCatchListening;
    try {
      currentContext.isTryCatchListening = true;
      interpretActions(tryBlock, scopeContainer, constantPool, registers);
    } catch (e) {
      currentContext.isTryCatchListening = savedTryCatchState;
      if (!catchBlockFlag) {
        throw e;
      }
      if (!(e instanceof AS2Error)) {
        throw e;
      }
      if (typeof catchTarget === 'string') {
        scope[catchTarget] = e.error;
      } else {
        registers[catchTarget] = e.error;
      }
      interpretActions(catchBlock, scopeContainer, constantPool, registers);
    } finally {
      currentContext.isTryCatchListening = savedTryCatchState;
      if (finallyBlockFlag) {
        interpretActions(finallyBlock, scopeContainer, constantPool, registers);
      }
    }
  }
  function validateArgsCount(numArgs, maxAmount) {
    if (isNaN(numArgs) || numArgs < 0 || numArgs > maxAmount || numArgs != (0 | numArgs)) {
      throw new Error('Invalid number of arguments: ' + numArgs);
    }
  }
  function readArgs(stack) {
    var numArgs = +stack.pop();
    validateArgsCount(numArgs, stack.length);
    var args = [];
    for (var i = 0; i < numArgs; i++) {
      args.push(stack.pop());
    }
    return args;
  }
  var stream = new ActionsDataStream(actionsData, currentContext.swfVersion);
  var _global = currentContext.globals;
  var defaultTarget = currentContext.defaultTarget;
  var stack = [];
  var scope = scopeContainer.scope;
  var isSwfVersion5 = currentContext.swfVersion >= 5;
  var actionTracer = ActionTracerFactory.get();
  var nextPosition;
  if (scope.$nativeObject && scope.$nativeObject._deferScriptExecution) {
    currentContext.deferScriptExecution = true;
  }
  function skipActions(count) {
    while (count > 0 && stream.position < stream.end) {
      var actionCode = stream.readUI8();
      var length = actionCode >= 128 ? stream.readUI16() : 0;
      stream.position += length;
      count--;
    }
    nextPosition = stream.position;
  }
  var recoveringFromError = false;
  var stackItemsExpected;
  while (stream.position < stream.end) {
    try {
      while (stream.position < stream.end) {
        if (currentContext.instructionsExecuted++ >= MAX_AVM1_INSTRUCTIONS_LIMIT) {
          throw new AS2CriticalError('long running script -- AVM1 instruction limit is reached');
        }
        var actionCode = stream.readUI8();
        var length = actionCode >= 128 ? stream.readUI16() : 0;
        nextPosition = stream.position + length;
        stackItemsExpected = 0;
        actionTracer.print(stream.position, actionCode, stack);
        var frame, type, count, index, target, method, constr, codeSize, offset;
        var name, variableName, methodName, functionName, targetName;
        var paramName, resolvedName, objectName;
        var value, a, b, c, f, sa, sb, obj, args, fn, result, flags, i;
        var dragParams, register;
        switch (actionCode | 0) {
        case 129:
          frame = stream.readUI16();
          var nextActionCode = stream.readUI8();
          nextPosition++;
          methodName = nextActionCode === 6 ? 'gotoAndPlay' : 'gotoAndStop';
          _global[methodName](frame + 1);
          break;
        case 131:
          var urlString = stream.readString();
          var targetString = stream.readString();
          _global.getURL(urlString, targetString);
          break;
        case 4:
          _global.nextFrame();
          break;
        case 5:
          _global.prevFrame();
          break;
        case 6:
          _global.play();
          break;
        case 7:
          _global.stop();
          break;
        case 8:
          _global.toggleHighQuality();
          break;
        case 9:
          _global.stopAllSounds();
          break;
        case 138:
          frame = stream.readUI16();
          count = stream.readUI8();
          if (!_global.ifFrameLoaded(frame)) {
            skipActions(count);
          }
          break;
        case 139:
          targetName = stream.readString();
          setTarget(targetName);
          break;
        case 140:
          var label = stream.readString();
          _global.gotoLabel(label);
          break;
        case 150:
          while (stream.position < nextPosition) {
            type = stream.readUI8();
            switch (type) {
            case 0:
              value = stream.readString();
              break;
            case 1:
              value = stream.readFloat();
              break;
            case 2:
              value = null;
              break;
            case 3:
              value = void 0;
              break;
            case 4:
              value = registers[stream.readUI8()];
              break;
            case 5:
              value = stream.readBoolean();
              break;
            case 6:
              value = stream.readDouble();
              break;
            case 7:
              value = stream.readInteger();
              break;
            case 8:
              value = constantPool[stream.readUI8()];
              break;
            case 9:
              value = constantPool[stream.readUI16()];
              break;
            default:
              throw new Error('Unknown value type: ' + type);
            }
            stack.push(value);
          }
          break;
        case 23:
          stack.pop();
          break;
        case 10:
          a = as2ToNumber(stack.pop());
          b = as2ToNumber(stack.pop());
          stack.push(a + b);
          break;
        case 11:
          a = as2ToNumber(stack.pop());
          b = as2ToNumber(stack.pop());
          stack.push(b - a);
          break;
        case 12:
          a = as2ToNumber(stack.pop());
          b = as2ToNumber(stack.pop());
          stack.push(a * b);
          break;
        case 13:
          a = as2ToNumber(stack.pop());
          b = as2ToNumber(stack.pop());
          c = b / a;
          stack.push(isSwfVersion5 ? c : isFinite(c) ? c : '#ERROR#');
          break;
        case 14:
          a = as2ToNumber(stack.pop());
          b = as2ToNumber(stack.pop());
          f = a == b;
          stack.push(isSwfVersion5 ? f : f ? 1 : 0);
          break;
        case 15:
          a = as2ToNumber(stack.pop());
          b = as2ToNumber(stack.pop());
          f = b < a;
          stack.push(isSwfVersion5 ? f : f ? 1 : 0);
          break;
        case 16:
          a = as2ToBoolean(stack.pop());
          b = as2ToBoolean(stack.pop());
          f = a && b;
          stack.push(isSwfVersion5 ? f : f ? 1 : 0);
          break;
        case 17:
          a = as2ToBoolean(stack.pop());
          b = as2ToBoolean(stack.pop());
          f = a || b;
          stack.push(isSwfVersion5 ? f : f ? 1 : 0);
          break;
        case 18:
          f = !as2ToBoolean(stack.pop());
          stack.push(isSwfVersion5 ? f : f ? 1 : 0);
          break;
        case 19:
          sa = as2ToString(stack.pop());
          sb = as2ToString(stack.pop());
          f = sa == sb;
          stack.push(isSwfVersion5 ? f : f ? 1 : 0);
          break;
        case 20:
        case 49:
          sa = as2ToString(stack.pop());
          stack.push(_global.length(sa));
          break;
        case 33:
          sa = as2ToString(stack.pop());
          sb = as2ToString(stack.pop());
          stack.push(sb + sa);
          break;
        case 21:
          count = stack.pop();
          index = stack.pop();
          value = as2ToString(stack.pop());
          stack.push(_global.substring(value, index, count));
          break;
        case 53:
          count = stack.pop();
          index = stack.pop();
          value = as2ToString(stack.pop());
          stack.push(_global.mbsubstring(value, index, count));
          break;
        case 41:
          sa = as2ToString(stack.pop());
          sb = as2ToString(stack.pop());
          f = sb < sa;
          stack.push(isSwfVersion5 ? f : f ? 1 : 0);
          break;
        case 24:
          stack.push(_global.int(stack.pop()));
          break;
        case 50:
          stack.push(_global.chr(stack.pop()));
          break;
        case 54:
          stack.push(_global.mbchr(stack.pop()));
          break;
        case 51:
          stack.push(_global.ord(stack.pop()));
          break;
        case 55:
          stack.push(_global.mbord(stack.pop()));
          break;
        case 153:
          offset = stream.readSI16();
          nextPosition += offset;
          break;
        case 157:
          offset = stream.readSI16();
          f = !(!stack.pop());
          if (f) {
            nextPosition += offset;
          }
          break;
        case 158:
          label = stack.pop();
          _global.call(label);
          break;
        case 28:
          variableName = '' + stack.pop();
          stackItemsExpected++;
          stack.push(getVariable(variableName));
          break;
        case 29:
          value = stack.pop();
          variableName = '' + stack.pop();
          setVariable(variableName, value);
          break;
        case 154:
          flags = stream.readUI8();
          var httpMethod;
          switch (flags >> 6 & 3) {
          case 1:
            httpMethod = 'GET';
            break;
          case 2:
            httpMethod = 'POST';
            break;
          }
          var loadMethod = !(!(flags & 2)) ? !(!(flags & 1)) ? _global.loadVariables : _global.loadMovie : !(!(flags & 1)) ? _global.loadVariablesNum : _global.loadMovieNum;
          target = stack.pop();
          var url = stack.pop();
          loadMethod.call(_global, url, target, httpMethod);
          break;
        case 159:
          flags = stream.readUI8();
          var gotoParams = [
              stack.pop()
            ];
          if (!(!(flags & 2))) {
            gotoParams.push(stream.readUI16());
          }
          var gotoMethod = !(!(flags & 1)) ? _global.gotoAndPlay : _global.gotoAndStop;
          gotoMethod.apply(_global, gotoParams);
          break;
        case 32:
          target = stack.pop();
          setTarget(target);
          break;
        case 34:
          index = stack.pop();
          target = stack.pop();
          stackItemsExpected++;
          stack.push(_global.getAS2Property(target, index));
          break;
        case 35:
          value = stack.pop();
          index = stack.pop();
          target = stack.pop();
          _global.setAS2Property(target, index, value);
          break;
        case 36:
          var depth = stack.pop();
          target = stack.pop();
          var source = stack.pop();
          _global.duplicateMovieClip(source, target, depth);
          break;
        case 37:
          target = stack.pop();
          _global.removeMovieClip(target);
          break;
        case 39:
          target = stack.pop();
          var lockcenter = stack.pop();
          var constrain = !stack.pop() ? null : {
              y2: stack.pop(),
              x2: stack.pop(),
              y1: stack.pop(),
              x1: stack.pop()
            };
          dragParams = [
            target,
            lockcenter
          ];
          if (constrain) {
            dragParams = dragParams.push(constrain.x1, constrain.y1, constrain.x2, constrain.y2);
          }
          _global.startDrag.apply(_global, dragParams);
          break;
        case 40:
          _global.stopDrag();
          break;
        case 141:
          count = stream.readUI8();
          frame = stack.pop();
          if (!_global.ifFrameLoaded(frame)) {
            skipActions(count);
          }
          break;
        case 38:
          value = stack.pop();
          _global.trace(value);
          break;
        case 52:
          stack.push(_global.getTimer());
          break;
        case 48:
          stack.push(_global.random(stack.pop()));
          break;
        case 61:
          functionName = stack.pop();
          args = readArgs(stack);
          stackItemsExpected++;
          fn = getFunction(functionName);
          result = fn.apply(scope, args);
          stack.push(result);
          break;
        case 82:
          methodName = stack.pop();
          obj = stack.pop();
          args = readArgs(stack);
          stackItemsExpected++;
          if (methodName !== null && methodName !== undefined && methodName !== '') {
            if (obj === null || obj === undefined) {
              throw new Error('Cannot call method ' + methodName + ' of ' + typeof obj);
            } else if (obj !== AS2_SUPER_STUB) {
              target = Object(obj);
            } else {
              target = as2GetPrototype(getVariable('__class').__super);
              obj = getVariable('this');
            }
            resolvedName = as2ResolveProperty(target, methodName);
            if (resolvedName === null) {
              throw new Error('Method ' + methodName + ' is not defined.');
            }
            result = target.asGetPublicProperty(resolvedName).apply(obj, args);
          } else if (obj !== AS2_SUPER_STUB) {
            result = obj.apply(obj, args);
          } else {
            result = getVariable('__class').__super.apply(getVariable('this'), args);
          }
          stack.push(result);
          break;
        case 136:
          count = stream.readUI16();
          constantPool = [];
          for (i = 0; i < count; i++) {
            constantPool.push(stream.readString());
          }
          break;
        case 155:
          functionName = stream.readString();
          count = stream.readUI16();
          args = [];
          for (i = 0; i < count; i++) {
            args.push(stream.readString());
          }
          codeSize = stream.readUI16();
          nextPosition += codeSize;
          fn = defineFunction(functionName, args, null, stream.readBytes(codeSize));
          if (functionName) {
            scope.asSetPublicProperty(functionName, fn);
          } else {
            stack.push(fn);
          }
          break;
        case 60:
          value = stack.pop();
          name = stack.pop();
          scope.asSetPublicProperty(name, value);
          break;
        case 65:
          name = stack.pop();
          scope.asSetPublicProperty(name, undefined);
          break;
        case 58:
          name = stack.pop();
          obj = stack.pop();
          obj.asSetPublicProperty(name, undefined);
          stack.push(obj.asDeleteProperty(undefined, name, 0));
          break;
        case 59:
          name = stack.pop();
          result = deleteProperty(name);
          stack.push(result);
          break;
        case 70:
          objectName = stack.pop();
          stack.push(null);
          obj = getObjectByName(objectName);
          forEachPublicProperty(obj, function (name) {
            stack.push(name);
          });
          break;
        case 73:
          a = stack.pop();
          b = stack.pop();
          stack.push(a == b);
          break;
        case 78:
          name = stack.pop();
          obj = stack.pop();
          if (name === 'prototype') {
            stack.push(as2CreatePrototypeProxy(obj));
          } else {
            resolvedName = as2ResolveProperty(Object(obj), name);
            stack.push(resolvedName === null ? undefined : obj.asGetPublicProperty(resolvedName));
          }
          break;
        case 66:
          obj = readArgs(stack);
          stack.push(obj);
          break;
        case 67:
          count = +stack.pop();
          validateArgsCount(count, stack.length >> 1);
          obj = {};
          for (i = 0; i < count; i++) {
            value = stack.pop();
            name = stack.pop();
            obj.asSetPublicProperty(name, value);
          }
          stack.push(obj);
          break;
        case 83:
          methodName = stack.pop();
          obj = stack.pop();
          args = readArgs(stack);
          stackItemsExpected++;
          if (methodName !== null && methodName !== undefined && methodName !== '') {
            resolvedName = as2ResolveProperty(obj, methodName);
            if (resolvedName === null) {
              throw new Error('Method ' + methodName + ' is not defined.');
            }
            if (obj === null || obj === undefined) {
              throw new Error('Cannot call new using method ' + resolvedName + ' of ' + typeof obj);
            }
            method = obj.asGetPublicProperty(resolvedName);
          } else {
            if (obj === null || obj === undefined) {
              throw new Error('Cannot call new using ' + typeof obj);
            }
            method = obj;
          }
          if (isAvm2Class(obj)) {
            result = construct(obj, args);
          } else {
            result = Object.create(as2GetPrototype(method) || as2GetPrototype(Object));
            method.apply(result, args);
          }
          result.constructor = method;
          stack.push(result);
          break;
        case 64:
          objectName = stack.pop();
          obj = getObjectByName(objectName);
          args = readArgs(stack);
          stackItemsExpected++;
          result = createBuiltinType(obj, args);
          if (typeof result === 'undefined') {
            if (isAvm2Class(obj)) {
              result = construct(obj, args);
            } else {
              result = Object.create(as2GetPrototype(obj) || as2GetPrototype(Object));
              obj.apply(result, args);
            }
            result.constructor = obj;
          }
          stack.push(result);
          break;
        case 79:
          value = stack.pop();
          name = stack.pop();
          obj = stack.pop();
          obj.asSetPublicProperty(name, value);
          break;
        case 69:
          obj = stack.pop();
          stack.push(as2GetType(obj) === 'movieclip' ? obj._target : void 0);
          break;
        case 148:
          codeSize = stream.readUI16();
          obj = stack.pop();
          nextPosition += codeSize;
          processWith(obj, stream.readBytes(codeSize));
          break;
        case 74:
          stack.push(as2ToNumber(stack.pop()));
          break;
        case 75:
          stack.push(as2ToString(stack.pop()));
          break;
        case 68:
          obj = stack.pop();
          result = as2GetType(obj);
          stack.push(result);
          break;
        case 71:
          a = as2ToAddPrimitive(stack.pop());
          b = as2ToAddPrimitive(stack.pop());
          if (typeof a === 'string' || typeof b === 'string') {
            stack.push(as2ToString(b) + as2ToString(a));
          } else {
            stack.push(as2ToNumber(b) + as2ToNumber(a));
          }
          break;
        case 72:
          a = stack.pop();
          b = stack.pop();
          stack.push(as2Compare(b, a));
          break;
        case 63:
          a = as2ToNumber(stack.pop());
          b = as2ToNumber(stack.pop());
          stack.push(b % a);
          break;
        case 96:
          a = as2ToInt32(stack.pop());
          b = as2ToInt32(stack.pop());
          stack.push(b & a);
          break;
        case 99:
          a = as2ToInt32(stack.pop());
          b = as2ToInt32(stack.pop());
          stack.push(b << a);
          break;
        case 97:
          a = as2ToInt32(stack.pop());
          b = as2ToInt32(stack.pop());
          stack.push(b | a);
          break;
        case 100:
          a = as2ToInt32(stack.pop());
          b = as2ToInt32(stack.pop());
          stack.push(b >> a);
          break;
        case 101:
          a = as2ToInt32(stack.pop());
          b = as2ToInt32(stack.pop());
          stack.push(b >>> a);
          break;
        case 98:
          a = as2ToInt32(stack.pop());
          b = as2ToInt32(stack.pop());
          stack.push(b ^ a);
          break;
        case 81:
          a = as2ToNumber(stack.pop());
          a--;
          stack.push(a);
          break;
        case 80:
          a = as2ToNumber(stack.pop());
          a++;
          stack.push(a);
          break;
        case 76:
          stack.push(stack[stack.length - 1]);
          break;
        case 62:
          return stack.pop();
        case 77:
          stack.push(stack.pop(), stack.pop());
          break;
        case 135:
          register = stream.readUI8();
          registers[register] = stack[stack.length - 1];
          break;
        case 84:
          constr = stack.pop();
          obj = stack.pop();
          stack.push(as2InstanceOf(Object(obj), constr));
          break;
        case 85:
          obj = stack.pop();
          stack.push(null);
          forEachPublicProperty(obj, function (name) {
            stack.push(name);
          });
          break;
        case 102:
          a = stack.pop();
          b = stack.pop();
          stack.push(b === a);
          break;
        case 103:
          a = stack.pop();
          b = stack.pop();
          stack.push(as2Compare(a, b));
          break;
        case 104:
          sa = as2ToString(stack.pop());
          sb = as2ToString(stack.pop());
          f = sb > sa;
          stack.push(isSwfVersion5 ? f : f ? 1 : 0);
          break;
        case 142:
          functionName = stream.readString();
          count = stream.readUI16();
          var registerCount = stream.readUI8();
          flags = stream.readUI16();
          var registerAllocation = [];
          args = [];
          for (i = 0; i < count; i++) {
            register = stream.readUI8();
            paramName = stream.readString();
            args.push(paramName);
            if (register) {
              registerAllocation[register] = {
                type: 'param',
                name: paramName,
                index: i
              };
            }
          }
          codeSize = stream.readUI16();
          nextPosition += codeSize;
          var j = 1;
          if (flags & 1) {
            registerAllocation[j++] = {
              type: 'var',
              name: 'this'
            };
          }
          if (flags & 4) {
            registerAllocation[j++] = {
              type: 'var',
              name: 'arguments'
            };
          }
          if (flags & 16) {
            registerAllocation[j++] = {
              type: 'var',
              name: 'super'
            };
          }
          if (flags & 64) {
            registerAllocation[j++] = {
              type: 'var',
              name: '_root'
            };
          }
          if (flags & 128) {
            registerAllocation[j++] = {
              type: 'var',
              name: '_parent'
            };
          }
          if (flags & 256) {
            registerAllocation[j++] = {
              type: 'var',
              name: '_global'
            };
          }
          fn = defineFunction(functionName, args, registerAllocation, stream.readBytes(codeSize));
          if (functionName) {
            scope.asSetPublicProperty(functionName, fn);
          } else {
            stack.push(fn);
          }
          break;
        case 105:
          var constrSuper = stack.pop();
          constr = stack.pop();
          obj = Object.create(constrSuper.traitsPrototype || as2GetPrototype(constrSuper), {
            constructor: {
              value: constr,
              enumerable: false
            }
          });
          constr.__super = constrSuper;
          constr.prototype = obj;
          break;
        case 43:
          obj = stack.pop();
          constr = stack.pop();
          stack.push(as2InstanceOf(obj, constr) ? obj : null);
          break;
        case 44:
          constr = stack.pop();
          count = +stack.pop();
          validateArgsCount(count, stack.length);
          var interfaces = [];
          for (i = 0; i < count; i++) {
            interfaces.push(stack.pop());
          }
          constr.$interfaces = interfaces;
          break;
        case 143:
          flags = stream.readUI8();
          var catchIsRegisterFlag = !(!(flags & 4));
          var finallyBlockFlag = !(!(flags & 2));
          var catchBlockFlag = !(!(flags & 1));
          var trySize = stream.readUI16();
          var catchSize = stream.readUI16();
          var finallySize = stream.readUI16();
          var catchTarget = catchIsRegisterFlag ? stream.readUI8() : stream.readString();
          nextPosition += trySize + catchSize + finallySize;
          processTry(catchIsRegisterFlag, finallyBlockFlag, catchBlockFlag, catchTarget, stream.readBytes(trySize), stream.readBytes(catchSize), stream.readBytes(finallySize));
          break;
        case 42:
          obj = stack.pop();
          throw new AS2Error(obj);
        case 45:
          args = readArgs(stack);
          stackItemsExpected++;
          result = _global.fscommand.apply(null, args);
          stack.push(result);
          break;
        case 137:
          var mode = stream.readUI8();
          break;
        case 0:
          return;
        default:
          throw new Error('Unknown action code: ' + actionCode);
        }
        stream.position = nextPosition;
        recoveringFromError = false;
      }
    } catch (e) {
      if (!AVM1_ERRORS_IGNORED && !currentContext.isTryCatchListening || e instanceof AS2CriticalError) {
        throw e;
      }
      if (e instanceof AS2Error) {
        throw e;
      }
      var AVM1_ERROR_TYPE = 1;
      TelemetryService.reportTelemetry({
        topic: 'error',
        error: AVM1_ERROR_TYPE
      });
      stream.position = nextPosition;
      if (stackItemsExpected > 0) {
        while (stackItemsExpected--) {
          stack.push(undefined);
        }
      }
      if (!recoveringFromError) {
        if (currentContext.errorsIgnored++ >= MAX_AVM1_ERRORS_LIMIT) {
          throw new AS2CriticalError('long running script -- AVM1 errors limit is reached');
        }
        console.error('AVM1 error: ' + e);
        recoveringFromError = true;
      }
    }
  }
}
var ActionTracerFactory = function () {
    var indentation = 0;
    var tracer = {
        print: function (position, actionCode, stack) {
          var stackDump = [];
          for (var q = 0; q < stack.length; q++) {
            var item = stack[q];
            stackDump.push(item && typeof item === 'object' ? '[' + (item.constructor && item.constructor.name ? item.constructor.name : 'Object') + ']' : item);
          }
          var indent = new Array(indentation + 1).join('..');
          console.log('AVM1 trace: ' + indent + position + ': ' + ActionNamesMap[actionCode] + '(' + actionCode.toString(16) + '), ' + 'stack=' + stackDump);
        },
        indent: function () {
          indentation++;
        },
        unindent: function () {
          indentation--;
        },
        message: function (str) {
          console.log('AVM1 trace: ------- ' + str);
        }
      };
    var nullTracer = {
        print: function () {
        },
        indent: function () {
        },
        unindent: function () {
        },
        message: function () {
        }
      };
    function ActionTracerFactory() {
    }
    ActionTracerFactory.get = function () {
      return AVM1_TRACE_ENABLED ? tracer : nullTracer;
    };
    return ActionTracerFactory;
  }();
var ActionNamesMap = {
    0: 'EOA',
    4: 'ActionNextFrame',
    5: 'ActionPreviousFrame',
    6: 'ActionPlay',
    7: 'ActionStop',
    8: 'ActionToggleQuality',
    9: 'ActionStopSounds',
    10: 'ActionAdd',
    11: 'ActionSubtract',
    12: 'ActionMultiply',
    13: 'ActionDivide',
    14: 'ActionEquals',
    15: 'ActionLess',
    16: 'ActionAnd',
    17: 'ActionOr',
    18: 'ActionNot',
    19: 'ActionStringEquals',
    20: 'ActionStringLength',
    21: 'ActionStringExtract',
    23: 'ActionPop',
    24: 'ActionToInteger',
    28: 'ActionGetVariable',
    29: 'ActionSetVariable',
    32: 'ActionSetTarget2',
    33: 'ActionStringAdd',
    34: 'ActionGetProperty',
    35: 'ActionSetProperty',
    36: 'ActionCloneSprite',
    37: 'ActionRemoveSprite',
    38: 'ActionTrace',
    39: 'ActionStartDrag',
    40: 'ActionEndDrag',
    41: 'ActionStringLess',
    42: 'ActionThrow',
    43: 'ActionCastOp',
    44: 'ActionImplementsOp',
    45: 'ActionFSCommand2',
    48: 'ActionRandomNumber',
    49: 'ActionMBStringLength',
    50: 'ActionCharToAscii',
    51: 'ActionAsciiToChar',
    52: 'ActionGetTime',
    53: 'ActionMBStringExtrac',
    54: 'ActionMBCharToAscii',
    55: 'ActionMBAsciiToChar',
    58: 'ActionDelete',
    59: 'ActionDelete2',
    60: 'ActionDefineLocal',
    61: 'ActionCallFunction',
    62: 'ActionReturn',
    63: 'ActionModulo',
    64: 'ActionNewObject',
    65: 'ActionDefineLocal2',
    66: 'ActionInitArray',
    67: 'ActionInitObject',
    68: 'ActionTypeOf',
    69: 'ActionTargetPath',
    70: 'ActionEnumerate',
    71: 'ActionAdd2',
    72: 'ActionLess2',
    73: 'ActionEquals2',
    74: 'ActionToNumber',
    75: 'ActionToString',
    76: 'ActionPushDuplicate',
    77: 'ActionStackSwap',
    78: 'ActionGetMember',
    79: 'ActionSetMember',
    80: 'ActionIncrement',
    81: 'ActionDecrement',
    82: 'ActionCallMethod',
    83: 'ActionNewMethod',
    84: 'ActionInstanceOf',
    85: 'ActionEnumerate2',
    96: 'ActionBitAnd',
    97: 'ActionBitOr',
    98: 'ActionBitXor',
    99: 'ActionBitLShift',
    100: 'ActionBitRShift',
    101: 'ActionBitURShift',
    102: 'ActionStrictEquals',
    103: 'ActionGreater',
    104: 'ActionStringGreater',
    105: 'ActionExtends',
    129: 'ActionGotoFrame',
    131: 'ActionGetURL',
    135: 'ActionStoreRegister',
    136: 'ActionConstantPool',
    137: 'ActionStrictMode',
    138: 'ActionWaitForFrame',
    139: 'ActionSetTarget',
    140: 'ActionGoToLabel',
    141: 'ActionWaitForFrame2',
    142: 'ActionDefineFunction',
    143: 'ActionTry',
    148: 'ActionWith',
    150: 'ActionPush',
    153: 'ActionJump',
    154: 'ActionGetURL2',
    155: 'ActionDefineFunction',
    157: 'ActionIf',
    158: 'ActionCall',
    159: 'ActionGotoFrame2'
  };
if (typeof GLOBAL !== 'undefined') {
  GLOBAL.createBuiltinType = createBuiltinType;
  GLOBAL.executeActions = executeActions;
  GLOBAL.AS2Context = AS2Context;
}
var debug = true;
var $DEBUG;
var release = false;
var compatibility = true;
var useSurrogates = true;
var useAsAdd = true;
var sealConstTraits = false;
var c4CoerceNonPrimitiveParameters = false;
var c4CoerceNonPrimitive = false;
var c4AsTypeLate = true;
var inBrowser = typeof console != 'undefined';
if (!inBrowser) {
  console = {
    info: print,
    warn: function (x) {
      if (traceWarnings.value) {
        print(x);
      }
    }
  };
}
if (!this.performance) {
  this.performance = {};
}
if (!this.performance.now) {
  this.performance.now = Date.now;
}
function backtrace() {
  try {
    throw new Error();
  } catch (e) {
    return e.stack ? e.stack.split('\n').slice(2).join('\n') : '';
  }
}
function error(message) {
  if (!inBrowser) {
    console.info(backtrace());
  }
  throw new Error(message);
}
function assert(condition) {
  if (condition === '') {
    condition = true;
  }
  if (!condition) {
    var message = Array.prototype.slice.call(arguments);
    message.shift();
    error(message.join(''));
  }
}
function assertFalse(condition, message) {
  if (condition) {
    error(message);
  }
}
function assertNotImplemented(condition, message) {
  if (!condition) {
    error('NotImplemented: ' + message);
  }
}
function warning(message) {
  true;
}
function notImplemented(message) {
  true;
}
function somewhatImplemented(message) {
  warning('somewhatImplemented: ' + message);
}
function unexpected(message) {
}
function makeForwardingGetter(target) {
  return new Function('return this["' + target + '"]');
}
function makeForwardingSetter(target) {
  return new Function('value', 'this["' + target + '"] = value;');
}
function defineReadOnlyProperty(obj, name, value) {
  Object.defineProperty(obj, name, {
    value: value,
    writable: false,
    configurable: true,
    enumerable: false
  });
}
function bindSafely(fn, obj) {
  true;
  var f = fn.bind(obj);
  f.boundTo = obj;
  return f;
}
function createEmptyObject() {
  return Object.create(null);
}
function getOwnPropertyDescriptors(object) {
  var o = createEmptyObject();
  var properties = Object.getOwnPropertyNames(object);
  for (var i = 0; i < properties.length; i++) {
    o[properties[i]] = Object.getOwnPropertyDescriptor(object, properties[i]);
  }
  return o;
}
function cloneObject(object) {
  var clone = Object.create(null);
  for (var property in object) {
    clone[property] = object[property];
  }
  return clone;
}
function extendObject(object, properties) {
  var extended = Object.create(object);
  if (properties) {
    for (var key in properties) {
      extended[key] = properties[key];
    }
  }
  return extended;
}
function copyProperties(object, template) {
  for (var property in template) {
    object[property] = template[property];
  }
}
function toSafeString(value) {
  if (typeof value === 'string') {
    return '"' + value + '"';
  }
  if (typeof value === 'number' || typeof value === 'boolean') {
    return String(value);
  }
  return typeof value;
}
function toSafeArrayString(array) {
  var str = [];
  for (var i = 0; i < array.length; i++) {
    str.push(toSafeString(array[i]));
  }
  return str.join(', ');
}
function getLatestGetterOrSetterPropertyDescriptor(obj, name) {
  var descriptor = {};
  while (obj) {
    var tmp = Object.getOwnPropertyDescriptor(obj, name);
    if (tmp) {
      descriptor.get = descriptor.get || tmp.get;
      descriptor.set = descriptor.set || tmp.set;
    }
    if (descriptor.get && descriptor.set) {
      break;
    }
    obj = Object.getPrototypeOf(obj);
  }
  return descriptor;
}
function defineNonEnumerableGetterOrSetter(obj, name, value, isGetter) {
  var descriptor = getLatestGetterOrSetterPropertyDescriptor(obj, name);
  descriptor.configurable = true;
  descriptor.enumerable = false;
  if (isGetter) {
    descriptor.get = value;
  } else {
    descriptor.set = value;
  }
  Object.defineProperty(obj, name, descriptor);
}
function defineNonEnumerableGetter(obj, name, getter) {
  Object.defineProperty(obj, name, {
    get: getter,
    configurable: true,
    enumerable: false
  });
}
function defineNonEnumerableSetter(obj, name, setter) {
  Object.defineProperty(obj, name, {
    set: setter,
    configurable: true,
    enumerable: false
  });
}
function defineNonEnumerableProperty(obj, name, value) {
  Object.defineProperty(obj, name, {
    value: value,
    writable: true,
    configurable: true,
    enumerable: false
  });
}
function defineNonEnumerableForwardingProperty(obj, name, otherName) {
  Object.defineProperty(obj, name, {
    get: makeForwardingGetter(otherName),
    set: makeForwardingSetter(otherName),
    writable: true,
    configurable: true,
    enumerable: false
  });
}
function defineNewNonEnumerableProperty(obj, name, value) {
  true;
  defineNonEnumerableProperty(obj, name, value);
}
function isNullOrUndefined(value) {
  return value == undefined;
}
function isPowerOfTwo(x) {
  return x && (x & x - 1) === 0;
}
function time(fn, count) {
  var start = performance.now();
  for (var i = 0; i < count; i++) {
    fn();
  }
  var time = (performance.now() - start) / count;
  console.info('Took: ' + time.toFixed(2) + 'ms.');
  return time;
}
function clamp(x, min, max) {
  if (x < min) {
    return min;
  } else if (x > max) {
    return max;
  }
  return x;
}
function fromCharCodeArray(buffer) {
  var str = '', SLICE = 1024 * 16;
  for (var i = 0; i < buffer.length; i += SLICE) {
    var chunk = Math.min(buffer.length - i, SLICE);
    str += String.fromCharCode.apply(null, buffer.subarray(i, i + chunk));
  }
  return str;
}
function hasOwnProperty(object, name) {
  return Object.prototype.hasOwnProperty.call(object, name);
}
function toKeyValueArray(o) {
  var hasOwnProperty = Object.prototype.hasOwnProperty;
  var a = [];
  for (var k in o) {
    if (hasOwnProperty.call(o, k)) {
      a.push([
        k,
        o[k]
      ]);
    }
  }
  return a;
}
function isNumeric(x) {
  if (typeof x === 'number') {
    return x === (x | 0);
  }
  if (typeof x === 'string' && x.length) {
    if (x === '0') {
      return true;
    }
    if (x[0] >= '1' && x[0] <= '9') {
      for (var i = 1; i < x.length; i++) {
        if (!(x[i] >= '1' && x[i] <= '9')) {
          return false;
        }
      }
      return true;
    }
  }
  return false;
}
function boxValue(value) {
  if (isNullOrUndefined(value)) {
    return value;
  }
  return Object(value);
}
function isObject(value) {
  return typeof value === 'object' || typeof value === 'function';
}
function isString(value) {
  return typeof value === 'string';
}
function isFunction(value) {
  return typeof value === 'function';
}
function isNumber(value) {
  return typeof value === 'number';
}
function toNumber(x) {
  return +x;
}
function setBitFlags(flags, flag, value) {
  return value ? flags | flag : flags & ~flag;
}
function getBitFlags(flags, flag) {
  return !(!(flags & flag));
}
function popManyInto(src, count, dst) {
  true;
  for (var i = count - 1; i >= 0; i--) {
    dst[i] = src.pop();
  }
  dst.length = count;
}
(function () {
  function extendBuiltin(proto, prop, f) {
    if (!proto[prop]) {
      Object.defineProperty(proto, prop, {
        value: f,
        writable: true,
        configurable: true,
        enumerable: false
      });
    }
  }
  var Sp = String.prototype;
  function removeColors(s) {
    return s.replace(/\033\[[0-9]*m/g, '');
  }
  extendBuiltin(Sp, 'padRight', function (c, n) {
    var str = this;
    var length = removeColors(str).length;
    if (!c || length >= n) {
      return str;
    }
    var max = (n - length) / c.length;
    for (var i = 0; i < max; i++) {
      str += c;
    }
    return str;
  });
  extendBuiltin(Sp, 'padLeft', function (c, n) {
    var str = this;
    var length = str.length;
    if (!c || length >= n) {
      return str;
    }
    var max = (n - length) / c.length;
    for (var i = 0; i < max; i++) {
      str = c + str;
    }
    return str;
  });
  extendBuiltin(Sp, 'trim', function () {
    return this.replace(/^\s+|\s+$/g, '');
  });
  extendBuiltin(Sp, 'endsWith', function (str) {
    return this.indexOf(str, this.length - str.length) !== -1;
  });
  var Ap = Array.prototype;
  extendBuiltin(Ap, 'popMany', function (count) {
    true;
    var start = this.length - count;
    var res = this.slice(start, this.length);
    this.splice(start, count);
    return res;
  });
  extendBuiltin(Ap, 'pushMany', function (array) {
    for (var i = 0; i < array.length; i++) {
      this.push(array[i]);
    }
  });
  extendBuiltin(Ap, 'clone', function () {
    return this.slice(0);
  });
  extendBuiltin(Ap, 'first', function () {
    true;
    return this[0];
  });
  extendBuiltin(Ap, 'last', function () {
    true;
    return this[this.length - 1];
  });
  extendBuiltin(Ap, 'peek', function () {
    true;
    return this[this.length - 1];
  });
  extendBuiltin(Ap, 'empty', function () {
    return this.length === 0;
  });
  extendBuiltin(Ap, 'pushUnique', function (v) {
    for (var i = 0, j = this.length; i < j; i++) {
      if (this[i] === v) {
        return;
      }
    }
    this.push(v);
  });
  extendBuiltin(Ap, 'unique', function () {
    var unique = [];
    for (var i = 0; i < this.length; i++) {
      unique.pushUnique(this[i]);
    }
    return unique;
  });
  extendBuiltin(Ap, 'replace', function (x, y) {
    if (x === y) {
      return 0;
    }
    var count = 0;
    for (var i = 0; i < this.length; i++) {
      if (this[i] === x) {
        this[i] = y;
        count++;
      }
    }
    return count;
  });
  extendBuiltin(Ap, 'count', function (x) {
    var count = 0;
    for (var i = 0; i < this.length; i++) {
      if (this[i] === x) {
        count++;
      }
    }
    return count;
  });
  extendBuiltin(Ap, 'notEmpty', function () {
    return this.length > 0;
  });
  extendBuiltin(Ap, 'contains', function (val) {
    return this.indexOf(val) >= 0;
  });
  extendBuiltin(Ap, 'top', function () {
    return this.length && this[this.length - 1];
  });
  extendBuiltin(Ap, 'mapWithIndex', function (fn) {
    var arr = [];
    for (var i = 0; i < this.length; i++) {
      arr.push(fn(this[i], i));
    }
    return arr;
  });
}());
function utf8decode(str) {
  var bytes = new Uint8Array(str.length * 4);
  var b = 0;
  for (var i = 0, j = str.length; i < j; i++) {
    var code = str.charCodeAt(i);
    if (code <= 127) {
      bytes[b++] = code;
      continue;
    }
    if (55296 <= code && code <= 56319) {
      var codeLow = str.charCodeAt(i + 1);
      if (56320 <= codeLow && codeLow <= 57343) {
        code = ((code & 1023) << 10) + (codeLow & 1023) + 65536;
        ++i;
      }
    }
    if ((code & 4292870144) !== 0) {
      bytes[b++] = 248 | code >>> 24 & 3;
      bytes[b++] = 128 | code >>> 18 & 63;
      bytes[b++] = 128 | code >>> 12 & 63;
      bytes[b++] = 128 | code >>> 6 & 63;
      bytes[b++] = 128 | code & 63;
    } else if ((code & 4294901760) !== 0) {
      bytes[b++] = 240 | code >>> 18 & 7;
      bytes[b++] = 128 | code >>> 12 & 63;
      bytes[b++] = 128 | code >>> 6 & 63;
      bytes[b++] = 128 | code & 63;
    } else if ((code & 4294965248) !== 0) {
      bytes[b++] = 224 | code >>> 12 & 15;
      bytes[b++] = 128 | code >>> 6 & 63;
      bytes[b++] = 128 | code & 63;
    } else {
      bytes[b++] = 192 | code >>> 6 & 31;
      bytes[b++] = 128 | code & 63;
    }
  }
  return bytes.subarray(0, b);
}
function utf8encode(bytes) {
  var j = 0, str = '';
  while (j < bytes.length) {
    var b1 = bytes[j++] & 255;
    if (b1 <= 127) {
      str += String.fromCharCode(b1);
    } else {
      var currentPrefix = 192;
      var validBits = 5;
      do {
        var mask = currentPrefix >> 1 | 128;
        if ((b1 & mask) === currentPrefix)
          break;
        currentPrefix = currentPrefix >> 1 | 128;
        --validBits;
      } while (validBits >= 0);
      if (validBits <= 0) {
        str += String.fromCharCode(b1);
        continue;
      }
      var code = b1 & (1 << validBits) - 1;
      var invalid = false;
      for (var i = 5; i >= validBits; --i) {
        var bi = bytes[j++];
        if ((bi & 192) != 128) {
          invalid = true;
          break;
        }
        code = code << 6 | bi & 63;
      }
      if (invalid) {
        for (var k = j - (7 - i); k < j; ++k) {
          str += String.fromCharCode(bytes[k] & 255);
        }
        continue;
      }
      if (code >= 65536) {
        str += String.fromCharCode(code - 65536 >> 10 & 1023 | 55296, code & 1023 | 56320);
      } else {
        str += String.fromCharCode(code);
      }
    }
  }
  return str;
}
function getFlags(value, flags) {
  var str = '';
  for (var i = 0; i < flags.length; i++) {
    if (value & 1 << i) {
      str += flags[i] + ' ';
    }
  }
  if (str.length === 0) {
    return '';
  }
  return str.trim();
}
function bitCount(i) {
  i = i - (i >> 1 & 1431655765);
  i = (i & 858993459) + (i >> 2 & 858993459);
  return (i + (i >> 4) & 252645135) * 16843009 >> 24;
}
function escapeString(str) {
  if (str !== undefined) {
    str = str.replace(/[^\w$]/gi, '$');
  }
  return str;
}
function BitSetFunctor(length) {
  var ADDRESS_BITS_PER_WORD = 5;
  var BITS_PER_WORD = 1 << ADDRESS_BITS_PER_WORD;
  var BIT_INDEX_MASK = BITS_PER_WORD - 1;
  var SIZE = length + (BITS_PER_WORD - 1) >> ADDRESS_BITS_PER_WORD << ADDRESS_BITS_PER_WORD;
  function BitSet() {
    this.count = 0;
    this.dirty = 0;
    this.size = SIZE;
    this.bits = new Uint32Array(SIZE >> ADDRESS_BITS_PER_WORD);
  }
  function BitSetS() {
    this.count = 0;
    this.dirty = 0;
    this.size = SIZE;
    this.bits = 0;
  }
  var singleword = SIZE >> ADDRESS_BITS_PER_WORD === 1;
  var Ctor = singleword ? BitSetS : BitSet;
  Ctor.ADDRESS_BITS_PER_WORD = ADDRESS_BITS_PER_WORD;
  Ctor.BITS_PER_WORD = BITS_PER_WORD;
  Ctor.BIT_INDEX_MASK = BIT_INDEX_MASK;
  Ctor.singleword = singleword;
  function ones(v) {
    v = v - (v >> 1 & 1431655765);
    v = (v & 858993459) + (v >> 2 & 858993459);
    return (v + (v >> 4) & 252645135) * 16843009 >> 24;
  }
  function leadingZeros(v) {
    v |= v >> 1;
    v |= v >> 2;
    v |= v >> 4;
    v |= v >> 8;
    v |= v >> 16;
    return 32 - ones(v);
  }
  function trailingZeros(v) {
    return ones((v & -v) - 1);
  }
  BitSet.prototype = {
    recount: function recount() {
      if (!this.dirty) {
        return;
      }
      var bits = this.bits;
      var c = 0;
      for (var i = 0, j = bits.length; i < j; i++) {
        var v = bits[i];
        v = v - (v >> 1 & 1431655765);
        v = (v & 858993459) + (v >> 2 & 858993459);
        c += (v + (v >> 4) & 252645135) * 16843009 >> 24;
      }
      this.count = c;
      this.dirty = 0;
    },
    set: function set(i) {
      var n = i >> ADDRESS_BITS_PER_WORD;
      var old = this.bits[n];
      var b = old | 1 << (i & BIT_INDEX_MASK);
      this.bits[n] = b;
      this.dirty |= old ^ b;
    },
    setAll: function setAll() {
      var bits = this.bits;
      for (var i = 0, j = bits.length; i < j; i++) {
        bits[i] = 4294967295;
      }
      this.count = this.size;
      this.dirty = 0;
    },
    assign: function assign(set) {
      this.count = set.count;
      this.dirty = set.dirty;
      this.size = set.size;
      for (var i = 0, j = this.bits.length; i < j; i++) {
        this.bits[i] = set.bits[i];
      }
    },
    clear: function clear(i) {
      var n = i >> ADDRESS_BITS_PER_WORD;
      var old = this.bits[n];
      var b = old & ~(1 << (i & BIT_INDEX_MASK));
      this.bits[n] = b;
      this.dirty |= old ^ b;
    },
    get: function get(i) {
      var word = this.bits[i >> ADDRESS_BITS_PER_WORD];
      return (word & 1 << (i & BIT_INDEX_MASK)) !== 0;
    },
    clearAll: function clearAll() {
      var bits = this.bits;
      for (var i = 0, j = bits.length; i < j; i++) {
        bits[i] = 0;
      }
      this.count = 0;
      this.dirty = 0;
    },
    _union: function _union(other) {
      var dirty = this.dirty;
      var bits = this.bits;
      var otherBits = other.bits;
      for (var i = 0, j = bits.length; i < j; i++) {
        var old = bits[i];
        var b = old | otherBits[i];
        bits[i] = b;
        dirty |= old ^ b;
      }
      this.dirty = dirty;
    },
    intersect: function intersect(other) {
      var dirty = this.dirty;
      var bits = this.bits;
      var otherBits = other.bits;
      for (var i = 0, j = bits.length; i < j; i++) {
        var old = bits[i];
        var b = old & otherBits[i];
        bits[i] = b;
        dirty |= old ^ b;
      }
      this.dirty = dirty;
    },
    subtract: function subtract(other) {
      var dirty = this.dirty;
      var bits = this.bits;
      var otherBits = other.bits;
      for (var i = 0, j = bits.length; i < j; i++) {
        var old = bits[i];
        var b = old & ~otherBits[i];
        bits[i] = b;
        dirty |= old ^ b;
      }
      this.dirty = dirty;
    },
    negate: function negate() {
      var dirty = this.dirty;
      var bits = this.bits;
      for (var i = 0, j = bits.length; i < j; i++) {
        var old = bits[i];
        var b = ~old;
        bits[i] = b;
        dirty |= old ^ b;
      }
      this.dirty = dirty;
    },
    forEach: function forEach(fn) {
      true;
      var bits = this.bits;
      for (var i = 0, j = bits.length; i < j; i++) {
        var word = bits[i];
        if (word) {
          for (var k = 0; k < BITS_PER_WORD; k++) {
            if (word & 1 << k) {
              fn(i * BITS_PER_WORD + k);
            }
          }
        }
      }
    },
    toArray: function toArray() {
      var set = [];
      var bits = this.bits;
      for (var i = 0, j = bits.length; i < j; i++) {
        var word = bits[i];
        if (word) {
          for (var k = 0; k < BITS_PER_WORD; k++) {
            if (word & 1 << k) {
              set.push(i * BITS_PER_WORD + k);
            }
          }
        }
      }
      return set;
    },
    equals: function equals(other) {
      if (this.size !== other.size) {
        return false;
      }
      var bits = this.bits;
      var otherBits = other.bits;
      for (var i = 0, j = bits.length; i < j; i++) {
        if (bits[i] !== otherBits[i]) {
          return false;
        }
      }
      return true;
    },
    contains: function contains(other) {
      if (this.size !== other.size) {
        return false;
      }
      var bits = this.bits;
      var otherBits = other.bits;
      for (var i = 0, j = bits.length; i < j; i++) {
        if ((bits[i] | otherBits[i]) !== bits[i]) {
          return false;
        }
      }
      return true;
    },
    toBitString: function toBitString(on, off) {
      on = on || '1';
      off = off || '0';
      var str = '';
      for (var i = 0; i < length; i++) {
        str += this.get(i) ? on : off;
      }
      return str;
    },
    length: length,
    toString: function toString(names) {
      var set = [];
      for (var i = 0; i < length; i++) {
        if (this.get(i)) {
          set.push(names ? names[i] : i);
        }
      }
      return set.join(', ');
    },
    isEmpty: function isEmpty() {
      this.recount();
      return this.count === 0;
    },
    clone: function clone() {
      var set = new BitSet();
      set._union(this);
      return set;
    }
  };
  BitSetS.prototype = {
    recount: function recount() {
      if (!this.dirty) {
        return;
      }
      var c = 0;
      var v = this.bits;
      v = v - (v >> 1 & 1431655765);
      v = (v & 858993459) + (v >> 2 & 858993459);
      c += (v + (v >> 4) & 252645135) * 16843009 >> 24;
      this.count = c;
      this.dirty = 0;
    },
    set: function set(i) {
      var old = this.bits;
      var b = old | 1 << (i & BIT_INDEX_MASK);
      this.bits = b;
      this.dirty |= old ^ b;
    },
    setAll: function setAll() {
      this.bits = 4294967295;
      this.count = this.size;
      this.dirty = 0;
    },
    assign: function assign(set) {
      this.count = set.count;
      this.dirty = set.dirty;
      this.size = set.size;
      this.bits = set.bits;
    },
    clear: function clear(i) {
      var old = this.bits;
      var b = old & ~(1 << (i & BIT_INDEX_MASK));
      this.bits = b;
      this.dirty |= old ^ b;
    },
    get: function get(i) {
      return (this.bits & 1 << (i & BIT_INDEX_MASK)) !== 0;
    },
    clearAll: function clearAll() {
      this.bits = 0;
      this.count = 0;
      this.dirty = 0;
    },
    _union: function _union(other) {
      var old = this.bits;
      var b = old | other.bits;
      this.bits = b;
      this.dirty = old ^ b;
    },
    intersect: function intersect(other) {
      var old = this.bits;
      var b = old & other.bits;
      this.bits = b;
      this.dirty = old ^ b;
    },
    subtract: function subtract(other) {
      var old = this.bits;
      var b = old & ~other.bits;
      this.bits = b;
      this.dirty = old ^ b;
    },
    negate: function negate() {
      var old = this.bits;
      var b = ~old;
      this.bits = b;
      this.dirty = old ^ b;
    },
    forEach: function forEach(fn) {
      true;
      var word = this.bits;
      if (word) {
        for (var k = 0; k < BITS_PER_WORD; k++) {
          if (word & 1 << k) {
            fn(k);
          }
        }
      }
    },
    toArray: function toArray() {
      var set = [];
      var word = this.bits;
      if (word) {
        for (var k = 0; k < BITS_PER_WORD; k++) {
          if (word & 1 << k) {
            set.push(k);
          }
        }
      }
      return set;
    },
    equals: function equals(other) {
      return this.bits === other.bits;
    },
    contains: function contains(other) {
      var bits = this.bits;
      return (bits | other.bits) === bits;
    },
    isEmpty: function isEmpty() {
      this.recount();
      return this.count === 0;
    },
    clone: function clone() {
      var set = new BitSetS();
      set._union(this);
      return set;
    },
    toBitString: BitSet.prototype.toBitString,
    toString: BitSet.prototype.toString,
    length: length
  };
  return Ctor;
}
function base64ArrayBuffer(arrayBuffer) {
  var base64 = '';
  var encodings = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
  var bytes = new Uint8Array(arrayBuffer);
  var byteLength = bytes.byteLength;
  var byteRemainder = byteLength % 3;
  var mainLength = byteLength - byteRemainder;
  var a, b, c, d;
  var chunk;
  for (var i = 0; i < mainLength; i = i + 3) {
    chunk = bytes[i] << 16 | bytes[i + 1] << 8 | bytes[i + 2];
    a = (chunk & 16515072) >> 18;
    b = (chunk & 258048) >> 12;
    c = (chunk & 4032) >> 6;
    d = chunk & 63;
    base64 += encodings[a] + encodings[b] + encodings[c] + encodings[d];
  }
  if (byteRemainder == 1) {
    chunk = bytes[mainLength];
    a = (chunk & 252) >> 2;
    b = (chunk & 3) << 4;
    base64 += encodings[a] + encodings[b] + '==';
  } else if (byteRemainder == 2) {
    chunk = bytes[mainLength] << 8 | bytes[mainLength + 1];
    a = (chunk & 64512) >> 10;
    b = (chunk & 1008) >> 4;
    c = (chunk & 15) << 2;
    base64 += encodings[a] + encodings[b] + encodings[c] + '=';
  }
  return base64;
}
var PURPLE = '\x1b[94m';
var YELLOW = '\x1b[93m';
var GREEN = '\x1b[92m';
var RED = '\x1b[91m';
var ENDC = '\x1b[0m';
var IndentingWriter = function () {
    var consoleOutFn = console.info.bind(console);
    function indentingWriter(suppressOutput, outFn) {
      this.tab = '  ';
      this.padding = '';
      this.suppressOutput = suppressOutput;
      this.out = outFn || consoleOutFn;
    }
    indentingWriter.prototype.writeLn = function writeLn(str) {
      if (!this.suppressOutput) {
        this.out(this.padding + str);
      }
    };
    indentingWriter.prototype.writeLns = function writeLns(str) {
      var lines = str.split('\n');
      for (var i = 0; i < lines.length; i++) {
        this.writeLn(lines[i]);
      }
    };
    indentingWriter.prototype.debugLn = function debugLn(str) {
      this.colorLn(PURPLE, str);
    };
    indentingWriter.prototype.yellowLn = function yellowLn(str) {
      this.colorLn(YELLOW, str);
    };
    indentingWriter.prototype.greenLn = function greenLn(str) {
      this.colorLn(GREEN, str);
    };
    indentingWriter.prototype.redLn = function redLn(str) {
      this.colorLn(RED, str);
    };
    indentingWriter.prototype.colorLn = function writeLn(color, str) {
      if (!this.suppressOutput) {
        if (!inBrowser) {
          this.out(this.padding + color + str + ENDC);
        } else {
          this.out(this.padding + str);
        }
      }
    };
    indentingWriter.prototype.enter = function enter(str) {
      if (!this.suppressOutput) {
        this.out(this.padding + str);
      }
      this.indent();
    };
    indentingWriter.prototype.leaveAndEnter = function leaveAndEnter(str) {
      this.leave(str);
      this.indent();
    };
    indentingWriter.prototype.leave = function leave(str) {
      this.outdent();
      if (!this.suppressOutput) {
        this.out(this.padding + str);
      }
    };
    indentingWriter.prototype.indent = function indent() {
      this.padding += this.tab;
    };
    indentingWriter.prototype.outdent = function outdent() {
      if (this.padding.length > 0) {
        this.padding = this.padding.substring(0, this.padding.length - this.tab.length);
      }
    };
    indentingWriter.prototype.writeArray = function writeArray(arr, detailed, noNumbers) {
      detailed = detailed || false;
      for (var i = 0, j = arr.length; i < j; i++) {
        var prefix = '';
        if (detailed) {
          if (arr[i] === null) {
            prefix = 'null';
          } else if (arr[i] === undefined) {
            prefix = 'undefined';
          } else {
            prefix = arr[i].constructor.name;
          }
          prefix += ' ';
        }
        var number = noNumbers ? '' : ('' + i).padRight(' ', 4);
        this.writeLn(number + prefix + arr[i]);
      }
    };
    return indentingWriter;
  }();
var Map = function () {
    function map() {
      this.elements = {};
    }
    map.prototype.set = function set(k, v) {
      this.elements[k] = v;
    };
    map.prototype.get = function get(k) {
      if (this.has(k)) {
        return this.elements[k];
      }
      return undefined;
    };
    map.prototype.has = function has(k) {
      return Object.prototype.hasOwnProperty.call(this.elements, k);
    };
    map.prototype.remove = function remove(k) {
      if (this.has(k)) {
        delete this.elements[k];
      }
    };
    return map;
  }();
var SortedList = function () {
    function sortedList(compare) {
      true;
      this.compare = compare;
      this.head = null;
      this.length = 0;
    }
    sortedList.RETURN = 1;
    sortedList.DELETE = 2;
    sortedList.prototype.push = function push(value) {
      true;
      this.length++;
      if (!this.head) {
        this.head = {
          value: value,
          next: null
        };
        return;
      }
      var curr = this.head;
      var prev = null;
      var node = {
          value: value,
          next: null
        };
      var compare = this.compare;
      while (curr) {
        if (compare(curr.value, node.value) > 0) {
          if (prev) {
            node.next = curr;
            prev.next = node;
          } else {
            node.next = this.head;
            this.head = node;
          }
          return;
        }
        prev = curr;
        curr = curr.next;
      }
      prev.next = node;
    };
    sortedList.prototype.forEach = function forEach(visitor) {
      var curr = this.head;
      var last = null;
      while (curr) {
        var result = visitor(curr.value);
        if (result === sortedList.RETURN) {
          return;
        } else if (result === sortedList.DELETE) {
          if (!last) {
            curr = this.head = this.head.next;
          } else {
            curr = last.next = curr.next;
          }
        } else {
          last = curr;
          curr = curr.next;
        }
      }
    };
    sortedList.prototype.pop = function pop() {
      if (!this.head) {
        return undefined;
      }
      this.length--;
      var ret = this.head;
      this.head = this.head.next;
      return ret.value;
    };
    sortedList.prototype.peek = function peek() {
      return this.head;
    };
    sortedList.prototype.contains = function contains(value) {
      var curr = this.head;
      while (curr) {
        if (curr.value === value) {
          return true;
        }
        curr = curr.next;
      }
      return false;
    };
    sortedList.prototype.toString = function () {
      var str = '[';
      var curr = this.head;
      while (curr) {
        str += curr.value.toString();
        curr = curr.next;
        if (curr) {
          str += ',';
        }
      }
      str += ']';
      return str;
    };
    return sortedList;
  }();
(function checkWeakMap() {
  if (typeof this.WeakMap === 'function')
    return;
  var id = 0;
  function WeakMap() {
    this.id = '$weakmap' + id++;
  }
  ;
  WeakMap.prototype = {
    has: function (obj) {
      return obj.hasOwnProperty(this.id);
    },
    get: function (obj, defaultValue) {
      return obj.hasOwnProperty(this.id) ? obj[this.id] : defaultValue;
    },
    set: function (obj, value) {
      Object.defineProperty(obj, this.id, {
        value: value,
        enumerable: false,
        configurable: true
      });
    }
  };
  this.WeakMap = WeakMap;
}());
var Callback = function () {
    function callback() {
      this.queues = {};
    }
    callback.prototype.register = function register(type, callback) {
      var queue = this.queues[type];
      if (queue) {
        if (queue.indexOf(callback) > -1) {
          return;
        }
      } else {
        queue = this.queues[type] = [];
      }
      queue.push(callback);
    };
    callback.prototype.unregister = function unregister(type, callback) {
      var queue = this.queues[type];
      if (!queue) {
        return;
      }
      var i = queue.indexOf(callback);
      if (i !== -1) {
        queue.splice(i, 1);
      }
      if (queue.length === 0) {
        this.queues[type] = null;
      }
    };
    callback.prototype.notify = function notify(type, args) {
      var queue = this.queues[type];
      if (!queue) {
        return;
      }
      queue = queue.slice();
      var args = sliceArguments(arguments, 0);
      for (var i = 0; i < queue.length; i++) {
        if (false) {
          Counter.count('callback(' + type + ').notify');
        }
        var callback = queue[i];
        callback.apply(null, args);
      }
    };
    callback.prototype.notify1 = function notify1(type, value) {
      var queue = this.queues[type];
      if (!queue) {
        return;
      }
      queue = queue.slice();
      for (var i = 0; i < queue.length; i++) {
        if (false) {
          Counter.count('callback(' + type + ').notify1');
        }
        var callback = queue[i];
        callback(type, value);
      }
    };
    return callback;
  }();
function dumpBytes(buffer, start, length) {
  var s = '';
  bytes = new Uint8Array(buffer, start, length);
  var end = length;
  for (var i = 0; i < end; i++) {
    if (i % 16 === 0) {
      s += '\n' + (start + i) + ': ';
    }
    s += bytes[i] + ' ';
  }
  return s;
}
function addProfileMarker(marker) {
  if (typeof FirefoxCom !== 'undefined') {
    FirefoxCom.requestSync('addProfilerMarker', marker);
  }
}
var CircularBuffer = function () {
    var mask = 4095, size = 4096;
    function circularBuffer(Type) {
      this.index = 0;
      this.start = 0;
      this.array = new Type(size);
    }
    circularBuffer.prototype.get = function (i) {
      return this.array[i];
    };
    circularBuffer.prototype.forEachInReverse = function (visitor) {
      if (this.isEmpty()) {
        return;
      }
      var i = this.index === 0 ? size - 1 : this.index - 1;
      while (i !== this.start) {
        if (visitor(this.array[i], i)) {
          break;
        }
        i = i === 0 ? size - 1 : i - 1;
      }
    };
    circularBuffer.prototype.write = function (value) {
      this.array[this.index] = value;
      this.index = this.index + 1 & mask;
      if (this.index === this.start) {
        this.start = this.start + 1 & mask;
      }
    };
    circularBuffer.prototype.isFull = function () {
      return this.index + 1 & mask === this.start;
    };
    circularBuffer.prototype.isEmpty = function () {
      return this.index === this.start;
    };
    return circularBuffer;
  }();
(function (exports) {
  if (!performance) {
    performance = {
      now: Date.now
    };
  }
  var Timer = function () {
      var base = new timer(null, 'Total'), top = base;
      var flat = new timer(null, 'Flat'), flatStack = [];
      function timer(parent, name) {
        this.parent = parent;
        this.timers = {};
        this.name = name;
        this.begin = 0;
        this.last = 0;
        this.total = 0;
        this.count = 0;
      }
      timer.flat = flat;
      function getTicks() {
        return performance.now();
      }
      timer.prototype.start = function () {
        this.begin = getTicks();
      };
      timer.prototype.stop = function () {
        this.last = getTicks() - this.begin;
        this.total += this.last;
        this.count += 1;
      };
      timer.time = function (name, fn) {
        timer.start(name);
        fn();
        timer.stop();
      };
      timer.start = function (name) {
        top = top.timers[name] || (top.timers[name] = new timer(top, name));
        top.start();
        var tmp = flat.timers[name] || (flat.timers[name] = new timer(flat, name));
        tmp.start();
        flatStack.push(tmp);
      };
      timer.stop = function () {
        top.stop();
        top = top.parent;
        flatStack.pop().stop();
      };
      timer.stopStart = function (name) {
        Timer.stop();
        Timer.start(name);
      }, timer.prototype.toJSON = function () {
        return {
          name: this.name,
          total: this.total,
          timers: this.timers
        };
      };
      timer.prototype.trace = function (writer, json) {
        if (json) {
          writer.writeLn('SHUMWAY$JSON ' + JSON.stringify({
            timer: this
          }));
          return;
        }
        writer.enter(this.name + ': ' + this.total + ' ms' + ', count: ' + this.count + ', average: ' + (this.total / this.count).toFixed(2) + ' ms');
        for (var name in this.timers) {
          this.timers[name].trace(writer);
        }
        writer.outdent();
      };
      timer.trace = function (writer, json) {
        base.trace(writer, json);
        flat.trace(writer, json);
      };
      return timer;
    }();
  var Counter = function () {
      function counter(enabled) {
        this.enabled = !(!enabled);
        this.counts = createEmptyObject();
      }
      counter.prototype.setEnabled = function (enabled) {
        this.enabled = enabled;
      };
      counter.prototype.clear = function () {
        this.counts = {};
      };
      counter.prototype.toJSON = function () {
        return {
          counts: this.counts
        };
      };
      counter.prototype.count = function (name, increment) {
        if (!this.enabled) {
          return;
        }
        increment = increment !== undefined ? increment : 1;
        if (this.counts[name] === undefined) {
          this.counts[name] = 0;
        }
        this.counts[name] += increment;
        return this.counts[name];
      };
      counter.prototype.trace = function (writer, json) {
        if (json) {
          writer.writeLn('SHUMWAY$JSON ' + JSON.stringify({
            counter: this
          }));
          return;
        }
        for (var name in this.counts) {
          writer.writeLn(name + ': ' + this.counts[name]);
        }
      };
      counter.prototype.traceSorted = function (writer) {
        var pairs = [];
        for (var name in this.counts) {
          pairs.push([
            name,
            this.counts[name]
          ]);
        }
        pairs.sort(function (a, b) {
          return b[1] - a[1];
        });
        pairs.forEach(function (pair) {
          writer.writeLn(pair[0] + ': ' + pair[1]);
        });
      };
      return counter;
    }();
  var Average = function () {
      function average(max) {
        this.samples = new Float64Array(max);
        this.count = 0;
        this.index = 0;
      }
      average.prototype.push = function push(sample) {
        if (this.count < this.samples.length) {
          this.count++;
        }
        this.index++;
        this.samples[this.index % this.samples.length] = sample;
      };
      average.prototype.average = function average() {
        var sum = 0;
        for (var i = 0; i < this.count; i++) {
          sum += this.samples[i];
        }
        return sum / this.count;
      };
      return average;
    }();
  exports.Timer = Timer;
  exports.Counter = Counter;
  exports.Average = Average;
}(typeof exports === 'undefined' ? metrics = {} : exports));
var Counter = new metrics.Counter(true);
var FrameCounter = new metrics.Counter(true);
var Timer = metrics.Timer;
var systemOptions = new OptionSet('System Options');
var disassemble = systemOptions.register(new Option('d', 'disassemble', 'boolean', false, 'disassemble'));
var traceLevel = systemOptions.register(new Option('t', 'traceLevel', 'number', 0, 'trace level'));
window.print = function (s) {
  console.log(s);
};
var CONSTANT_Undefined = 0;
var CONSTANT_Utf8 = 1;
var CONSTANT_Float = 2;
var CONSTANT_Int = 3;
var CONSTANT_UInt = 4;
var CONSTANT_PrivateNs = 5;
var CONSTANT_Double = 6;
var CONSTANT_QName = 7;
var CONSTANT_Namespace = 8;
var CONSTANT_Multiname = 9;
var CONSTANT_False = 10;
var CONSTANT_True = 11;
var CONSTANT_Null = 12;
var CONSTANT_QNameA = 13;
var CONSTANT_MultinameA = 14;
var CONSTANT_RTQName = 15;
var CONSTANT_RTQNameA = 16;
var CONSTANT_RTQNameL = 17;
var CONSTANT_RTQNameLA = 18;
var CONSTANT_NameL = 19;
var CONSTANT_NameLA = 20;
var CONSTANT_NamespaceSet = 21;
var CONSTANT_PackageNamespace = 22;
var CONSTANT_PackageInternalNs = 23;
var CONSTANT_ProtectedNamespace = 24;
var CONSTANT_ExplicitNamespace = 25;
var CONSTANT_StaticProtectedNs = 26;
var CONSTANT_MultinameL = 27;
var CONSTANT_MultinameLA = 28;
var CONSTANT_TypeName = 29;
var CONSTANT_ClassSealed = 1;
var CONSTANT_ClassFinal = 2;
var CONSTANT_ClassInterface = 4;
var CONSTANT_ClassProtectedNs = 8;
var TRAIT_Slot = 0;
var TRAIT_Method = 1;
var TRAIT_Getter = 2;
var TRAIT_Setter = 3;
var TRAIT_Class = 4;
var TRAIT_Function = 5;
var TRAIT_Const = 6;
var ATTR_Final = 1;
var ATTR_Override = 2;
var ATTR_Metadata = 4;
var SLOT_var = 0;
var SLOT_method = 1;
var SLOT_getter = 2;
var SLOT_setter = 3;
var SLOT_class = 4;
var SLOT_function = 6;
var METHOD_Arguments = 1;
var METHOD_Activation = 2;
var METHOD_Needrest = 4;
var METHOD_HasOptional = 8;
var METHOD_IgnoreRest = 16;
var METHOD_Native = 32;
var METHOD_Setsdxns = 64;
var METHOD_HasParamNames = 128;
var OP_bkpt = 1;
var OP_nop = 2;
var OP_throw = 3;
var OP_getsuper = 4;
var OP_setsuper = 5;
var OP_dxns = 6;
var OP_dxnslate = 7;
var OP_kill = 8;
var OP_label = 9;
var OP_lf32x4 = 10;
var OP_sf32x4 = 11;
var OP_ifnlt = 12;
var OP_ifnle = 13;
var OP_ifngt = 14;
var OP_ifnge = 15;
var OP_jump = 16;
var OP_iftrue = 17;
var OP_iffalse = 18;
var OP_ifeq = 19;
var OP_ifne = 20;
var OP_iflt = 21;
var OP_ifle = 22;
var OP_ifgt = 23;
var OP_ifge = 24;
var OP_ifstricteq = 25;
var OP_ifstrictne = 26;
var OP_lookupswitch = 27;
var OP_pushwith = 28;
var OP_popscope = 29;
var OP_nextname = 30;
var OP_hasnext = 31;
var OP_pushnull = 32;
var OP_pushundefined = 33;
var OP_pushfloat = 34;
var OP_nextvalue = 35;
var OP_pushbyte = 36;
var OP_pushshort = 37;
var OP_pushtrue = 38;
var OP_pushfalse = 39;
var OP_pushnan = 40;
var OP_pop = 41;
var OP_dup = 42;
var OP_swap = 43;
var OP_pushstring = 44;
var OP_pushint = 45;
var OP_pushuint = 46;
var OP_pushdouble = 47;
var OP_pushscope = 48;
var OP_pushnamespace = 49;
var OP_hasnext2 = 50;
var OP_li8 = 53;
var OP_li16 = 54;
var OP_li32 = 55;
var OP_lf32 = 56;
var OP_lf64 = 57;
var OP_si8 = 58;
var OP_si16 = 59;
var OP_si32 = 60;
var OP_sf32 = 61;
var OP_sf64 = 62;
var OP_newfunction = 64;
var OP_call = 65;
var OP_construct = 66;
var OP_callmethod = 67;
var OP_callstatic = 68;
var OP_callsuper = 69;
var OP_callproperty = 70;
var OP_returnvoid = 71;
var OP_returnvalue = 72;
var OP_constructsuper = 73;
var OP_constructprop = 74;
var OP_callsuperid = 75;
var OP_callproplex = 76;
var OP_callinterface = 77;
var OP_callsupervoid = 78;
var OP_callpropvoid = 79;
var OP_sxi1 = 80;
var OP_sxi8 = 81;
var OP_sxi16 = 82;
var OP_applytype = 83;
var OP_pushfloat4 = 84;
var OP_newobject = 85;
var OP_newarray = 86;
var OP_newactivation = 87;
var OP_newclass = 88;
var OP_getdescendants = 89;
var OP_newcatch = 90;
var OP_findpropstrict = 93;
var OP_findproperty = 94;
var OP_finddef = 95;
var OP_getlex = 96;
var OP_setproperty = 97;
var OP_getlocal = 98;
var OP_setlocal = 99;
var OP_getglobalscope = 100;
var OP_getscopeobject = 101;
var OP_getproperty = 102;
var OP_getouterscope = 103;
var OP_initproperty = 104;
var OP_setpropertylate = 105;
var OP_deleteproperty = 106;
var OP_deletepropertylate = 107;
var OP_getslot = 108;
var OP_setslot = 109;
var OP_getglobalslot = 110;
var OP_setglobalslot = 111;
var OP_convert_s = 112;
var OP_esc_xelem = 113;
var OP_esc_xattr = 114;
var OP_convert_i = 115;
var OP_convert_u = 116;
var OP_convert_d = 117;
var OP_convert_b = 118;
var OP_convert_o = 119;
var OP_checkfilter = 120;
var OP_convert_f = 121;
var OP_unplus = 122;
var OP_convert_f4 = 123;
var OP_coerce = 128;
var OP_coerce_b = 129;
var OP_coerce_a = 130;
var OP_coerce_i = 131;
var OP_coerce_d = 132;
var OP_coerce_s = 133;
var OP_astype = 134;
var OP_astypelate = 135;
var OP_coerce_u = 136;
var OP_coerce_o = 137;
var OP_negate = 144;
var OP_increment = 145;
var OP_inclocal = 146;
var OP_decrement = 147;
var OP_declocal = 148;
var OP_typeof = 149;
var OP_not = 150;
var OP_bitnot = 151;
var OP_add = 160;
var OP_subtract = 161;
var OP_multiply = 162;
var OP_divide = 163;
var OP_modulo = 164;
var OP_lshift = 165;
var OP_rshift = 166;
var OP_urshift = 167;
var OP_bitand = 168;
var OP_bitor = 169;
var OP_bitxor = 170;
var OP_equals = 171;
var OP_strictequals = 172;
var OP_lessthan = 173;
var OP_lessequals = 174;
var OP_greaterthan = 175;
var OP_greaterequals = 176;
var OP_instanceof = 177;
var OP_istype = 178;
var OP_istypelate = 179;
var OP_in = 180;
var OP_increment_i = 192;
var OP_decrement_i = 193;
var OP_inclocal_i = 194;
var OP_declocal_i = 195;
var OP_negate_i = 196;
var OP_add_i = 197;
var OP_subtract_i = 198;
var OP_multiply_i = 199;
var OP_getlocal0 = 208;
var OP_getlocal1 = 209;
var OP_getlocal2 = 210;
var OP_getlocal3 = 211;
var OP_setlocal0 = 212;
var OP_setlocal1 = 213;
var OP_setlocal2 = 214;
var OP_setlocal3 = 215;
var OP_invalid = 237;
var OP_debug = 239;
var OP_debugline = 240;
var OP_debugfile = 241;
var OP_bkptline = 242;
var OP_timestamp = 243;
var INT_MIN_VALUE = -2147483648;
var INT_MAX_VALUE = 2147483647;
var UINT_MIN_VALUE = 0;
var UINT_MAX_VALUE = 4294967295;
var SORT_CASEINSENSITIVE = 1;
var SORT_DESCENDING = 2;
var SORT_UNIQUESORT = 4;
var SORT_RETURNINDEXEDARRAY = 8;
var SORT_NUMERIC = 16;
var Errors = {
    OutOfMemoryError: {
      code: 1000,
      message: 'The system is out of memory.'
    },
    NotImplementedError: {
      code: 1001,
      message: 'The method %1 is not implemented.'
    },
    InvalidPrecisionError: {
      code: 1002,
      message: 'Number.toPrecision has a range of 1 to 21. Number.toFixed and Number.toExponential have a range of 0 to 20. Specified value is not within expected range.'
    },
    InvalidRadixError: {
      code: 1003,
      message: 'The radix argument must be between 2 and 36; got %1.'
    },
    InvokeOnIncompatibleObjectError: {
      code: 1004,
      message: 'Method %1 was invoked on an incompatible object.'
    },
    ArrayIndexNotIntegerError: {
      code: 1005,
      message: 'Array index is not a positive integer (%1).'
    },
    CallOfNonFunctionError: {
      code: 1006,
      message: '%1 is not a function.'
    },
    ConstructOfNonFunctionError: {
      code: 1007,
      message: 'Instantiation attempted on a non-constructor.'
    },
    AmbiguousBindingError: {
      code: 1008,
      message: '%1 is ambiguous; Found more than one matching binding.'
    },
    ConvertNullToObjectError: {
      code: 1009,
      message: 'Cannot access a property or method of a null object reference.'
    },
    ConvertUndefinedToObjectError: {
      code: 1010,
      message: 'A term is undefined and has no properties.'
    },
    IllegalOpcodeError: {
      code: 1011,
      message: 'Method %1 contained illegal opcode %2 at offset %3.'
    },
    LastInstExceedsCodeSizeError: {
      code: 1012,
      message: 'The last instruction exceeded code size.'
    },
    FindVarWithNoScopeError: {
      code: 1013,
      message: 'Cannot call OP_findproperty when scopeDepth is 0.'
    },
    ClassNotFoundError: {
      code: 1014,
      message: 'Class %1 could not be found.'
    },
    IllegalSetDxns: {
      code: 1015,
      message: 'Method %1 cannot set default xml namespace'
    },
    DescendentsError: {
      code: 1016,
      message: 'Descendants operator (..) not supported on type %1.'
    },
    ScopeStackOverflowError: {
      code: 1017,
      message: 'Scope stack overflow occurred.'
    },
    ScopeStackUnderflowError: {
      code: 1018,
      message: 'Scope stack underflow occurred.'
    },
    GetScopeObjectBoundsError: {
      code: 1019,
      message: 'Getscopeobject %1 is out of bounds.'
    },
    CannotFallOffMethodError: {
      code: 1020,
      message: 'Code cannot fall off the end of a method.'
    },
    InvalidBranchTargetError: {
      code: 1021,
      message: 'At least one branch target was not on a valid instruction in the method.'
    },
    IllegalVoidError: {
      code: 1022,
      message: 'Type void may only be used as a function return type.'
    },
    StackOverflowError: {
      code: 1023,
      message: 'Stack overflow occurred.'
    },
    StackUnderflowError: {
      code: 1024,
      message: 'Stack underflow occurred.'
    },
    InvalidRegisterError: {
      code: 1025,
      message: 'An invalid register %1 was accessed.'
    },
    SlotExceedsCountError: {
      code: 1026,
      message: 'Slot %1 exceeds slotCount=%2 of %3.'
    },
    MethodInfoExceedsCountError: {
      code: 1027,
      message: 'Method_info %1 exceeds method_count=%2.'
    },
    DispIdExceedsCountError: {
      code: 1028,
      message: 'Disp_id %1 exceeds max_disp_id=%2 of %3.'
    },
    DispIdUndefinedError: {
      code: 1029,
      message: 'Disp_id %1 is undefined on %2.'
    },
    StackDepthUnbalancedError: {
      code: 1030,
      message: 'Stack depth is unbalanced. %1 != %2.'
    },
    ScopeDepthUnbalancedError: {
      code: 1031,
      message: 'Scope depth is unbalanced. %1 != %2.'
    },
    CpoolIndexRangeError: {
      code: 1032,
      message: 'Cpool index %1 is out of range %2.'
    },
    CpoolEntryWrongTypeError: {
      code: 1033,
      message: 'Cpool entry %1 is wrong type.'
    },
    CheckTypeFailedError: {
      code: 1034,
      message: 'Type Coercion failed: cannot convert %1 to %2.'
    },
    IllegalSuperCallError: {
      code: 1035,
      message: 'Illegal super expression found in method %1.'
    },
    CannotAssignToMethodError: {
      code: 1037,
      message: 'Cannot assign to a method %1 on %2.'
    },
    RedefinedError: {
      code: 1038,
      message: '%1 is already defined.'
    },
    CannotVerifyUntilReferencedError: {
      code: 1039,
      message: 'Cannot verify method until it is referenced.'
    },
    CantUseInstanceofOnNonObjectError: {
      code: 1040,
      message: 'The right-hand side of instanceof must be a class or function.'
    },
    IsTypeMustBeClassError: {
      code: 1041,
      message: 'The right-hand side of operator must be a class.'
    },
    InvalidMagicError: {
      code: 1042,
      message: 'Not an ABC file.  major_version=%1 minor_version=%2.'
    },
    InvalidCodeLengthError: {
      code: 1043,
      message: 'Invalid code_length=%1.'
    },
    InvalidMethodInfoFlagsError: {
      code: 1044,
      message: 'MethodInfo-%1 unsupported flags=%2.'
    },
    UnsupportedTraitsKindError: {
      code: 1045,
      message: 'Unsupported traits kind=%1.'
    },
    MethodInfoOrderError: {
      code: 1046,
      message: 'MethodInfo-%1 referenced before definition.'
    },
    MissingEntryPointError: {
      code: 1047,
      message: 'No entry point was found.'
    },
    PrototypeTypeError: {
      code: 1049,
      message: 'Prototype objects must be vanilla Objects.'
    },
    ConvertToPrimitiveError: {
      code: 1050,
      message: 'Cannot convert %1 to primitive.'
    },
    IllegalEarlyBindingError: {
      code: 1051,
      message: 'Illegal early binding access to %1.'
    },
    InvalidURIError: {
      code: 1052,
      message: 'Invalid URI passed to %1 function.'
    },
    IllegalOverrideError: {
      code: 1053,
      message: 'Illegal override of %1 in %2.'
    },
    IllegalExceptionHandlerError: {
      code: 1054,
      message: 'Illegal range or target offsets in exception handler.'
    },
    WriteSealedError: {
      code: 1056,
      message: 'Cannot create property %1 on %2.'
    },
    IllegalSlotError: {
      code: 1057,
      message: '%1 can only contain methods.'
    },
    IllegalOperandTypeError: {
      code: 1058,
      message: 'Illegal operand type: %1 must be %2.'
    },
    ClassInfoOrderError: {
      code: 1059,
      message: 'ClassInfo-%1 is referenced before definition.'
    },
    ClassInfoExceedsCountError: {
      code: 1060,
      message: 'ClassInfo %1 exceeds class_count=%2.'
    },
    NumberOutOfRangeError: {
      code: 1061,
      message: 'The value %1 cannot be converted to %2 without losing precision.'
    },
    WrongArgumentCountError: {
      code: 1063,
      message: 'Argument count mismatch on %1. Expected %2, got %3.'
    },
    CannotCallMethodAsConstructor: {
      code: 1064,
      message: 'Cannot call method %1 as constructor.'
    },
    UndefinedVarError: {
      code: 1065,
      message: 'Variable %1 is not defined.'
    },
    FunctionConstructorError: {
      code: 1066,
      message: 'The form function(\'function body\') is not supported.'
    },
    IllegalNativeMethodBodyError: {
      code: 1067,
      message: 'Native method %1 has illegal method body.'
    },
    CannotMergeTypesError: {
      code: 1068,
      message: '%1 and %2 cannot be reconciled.'
    },
    ReadSealedError: {
      code: 1069,
      message: 'Property %1 not found on %2 and there is no default value.'
    },
    CallNotFoundError: {
      code: 1070,
      message: 'Method %1 not found on %2'
    },
    AlreadyBoundError: {
      code: 1071,
      message: 'Function %1 has already been bound to %2.'
    },
    ZeroDispIdError: {
      code: 1072,
      message: 'Disp_id 0 is illegal.'
    },
    DuplicateDispIdError: {
      code: 1073,
      message: 'Non-override method %1 replaced because of duplicate disp_id %2.'
    },
    ConstWriteError: {
      code: 1074,
      message: 'Illegal write to read-only property %1 on %2.'
    },
    MathNotFunctionError: {
      code: 1075,
      message: 'Math is not a function.'
    },
    MathNotConstructorError: {
      code: 1076,
      message: 'Math is not a constructor.'
    },
    WriteOnlyError: {
      code: 1077,
      message: 'Illegal read of write-only property %1 on %2.'
    },
    IllegalOpMultinameError: {
      code: 1078,
      message: 'Illegal opcode/multiname combination: %1<%2>.'
    },
    IllegalNativeMethodError: {
      code: 1079,
      message: 'Native methods are not allowed in loaded code.'
    },
    IllegalNamespaceError: {
      code: 1080,
      message: 'Illegal value for namespace.'
    },
    ReadSealedErrorNs: {
      code: 1081,
      message: 'Property %1 not found on %2 and there is no default value.'
    },
    NoDefaultNamespaceError: {
      code: 1082,
      message: 'No default namespace has been set.'
    },
    XMLPrefixNotBound: {
      code: 1083,
      message: 'The prefix "%1" for element "%2" is not bound.'
    },
    XMLBadQName: {
      code: 1084,
      message: 'Element or attribute ("%1") does not match QName production: QName::=(NCName\':\')?NCName.'
    },
    XMLUnterminatedElementTag: {
      code: 1085,
      message: 'The element type "%1" must be terminated by the matching end-tag "</%2>".'
    },
    XMLOnlyWorksWithOneItemLists: {
      code: 1086,
      message: 'The %1 method only works on lists containing one item.'
    },
    XMLAssignmentToIndexedXMLNotAllowed: {
      code: 1087,
      message: 'Assignment to indexed XML is not allowed.'
    },
    XMLMarkupMustBeWellFormed: {
      code: 1088,
      message: 'The markup in the document following the root element must be well-formed.'
    },
    XMLAssigmentOneItemLists: {
      code: 1089,
      message: 'Assignment to lists with more than one item is not supported.'
    },
    XMLMalformedElement: {
      code: 1090,
      message: 'XML parser failure: element is malformed.'
    },
    XMLUnterminatedCData: {
      code: 1091,
      message: 'XML parser failure: Unterminated CDATA section.'
    },
    XMLUnterminatedXMLDecl: {
      code: 1092,
      message: 'XML parser failure: Unterminated XML declaration.'
    },
    XMLUnterminatedDocTypeDecl: {
      code: 1093,
      message: 'XML parser failure: Unterminated DOCTYPE declaration.'
    },
    XMLUnterminatedComment: {
      code: 1094,
      message: 'XML parser failure: Unterminated comment.'
    },
    XMLUnterminatedAttribute: {
      code: 1095,
      message: 'XML parser failure: Unterminated attribute.'
    },
    XMLUnterminatedElement: {
      code: 1096,
      message: 'XML parser failure: Unterminated element.'
    },
    XMLUnterminatedProcessingInstruction: {
      code: 1097,
      message: 'XML parser failure: Unterminated processing instruction.'
    },
    XMLNamespaceWithPrefixAndNoURI: {
      code: 1098,
      message: 'Illegal prefix %1 for no namespace.'
    },
    RegExpFlagsArgumentError: {
      code: 1100,
      message: 'Cannot supply flags when constructing one RegExp from another.'
    },
    NoScopeError: {
      code: 1101,
      message: 'Cannot verify method %1 with unknown scope.'
    },
    IllegalDefaultValue: {
      code: 1102,
      message: 'Illegal default value for type %1.'
    },
    CannotExtendFinalClass: {
      code: 1103,
      message: 'Class %1 cannot extend final base class.'
    },
    XMLDuplicateAttribute: {
      code: 1104,
      message: 'Attribute "%1" was already specified for element "%2".'
    },
    CorruptABCError: {
      code: 1107,
      message: 'The ABC data is corrupt, attempt to read out of bounds.'
    },
    InvalidBaseClassError: {
      code: 1108,
      message: 'The OP_newclass opcode was used with the incorrect base class.'
    },
    DanglingFunctionError: {
      code: 1109,
      message: 'Attempt to directly call unbound function %1 from method %2.'
    },
    CannotExtendError: {
      code: 1110,
      message: '%1 cannot extend %2.'
    },
    CannotImplementError: {
      code: 1111,
      message: '%1 cannot implement %2.'
    },
    CoerceArgumentCountError: {
      code: 1112,
      message: 'Argument count mismatch on class coercion.  Expected 1, got %1.'
    },
    InvalidNewActivationError: {
      code: 1113,
      message: 'OP_newactivation used in method without NEED_ACTIVATION flag.'
    },
    NoGlobalScopeError: {
      code: 1114,
      message: 'OP_getglobalslot or OP_setglobalslot used with no global scope.'
    },
    NotConstructorError: {
      code: 1115,
      message: '%1 is not a constructor.'
    },
    ApplyError: {
      code: 1116,
      message: 'second argument to Function.prototype.apply must be an array.'
    },
    XMLInvalidName: {
      code: 1117,
      message: 'Invalid XML name: %1.'
    },
    XMLIllegalCyclicalLoop: {
      code: 1118,
      message: 'Illegal cyclical loop between nodes.'
    },
    DeleteTypeError: {
      code: 1119,
      message: 'Delete operator is not supported with operand of type %1.'
    },
    DeleteSealedError: {
      code: 1120,
      message: 'Cannot delete property %1 on %2.'
    },
    DuplicateMethodBodyError: {
      code: 1121,
      message: 'Method %1 has a duplicate method body.'
    },
    IllegalInterfaceMethodBodyError: {
      code: 1122,
      message: 'Interface method %1 has illegal method body.'
    },
    FilterError: {
      code: 1123,
      message: 'Filter operator not supported on type %1.'
    },
    InvalidHasNextError: {
      code: 1124,
      message: 'OP_hasnext2 requires object and index to be distinct registers.'
    },
    OutOfRangeError: {
      code: 1125,
      message: 'The index %1 is out of range %2.'
    },
    VectorFixedError: {
      code: 1126,
      message: 'Cannot change the length of a fixed Vector.'
    },
    TypeAppOfNonParamType: {
      code: 1127,
      message: 'Type application attempted on a non-parameterized type.'
    },
    WrongTypeArgCountError: {
      code: 1128,
      message: 'Incorrect number of type parameters for %1. Expected %2, got %3.'
    },
    JSONCyclicStructure: {
      code: 1129,
      message: 'Cyclic structure cannot be converted to JSON string.'
    },
    JSONInvalidReplacer: {
      code: 1131,
      message: 'Replacer argument to JSON stringifier must be an array or a two parameter function.'
    },
    JSONInvalidParseInput: {
      code: 1132,
      message: 'Invalid JSON parse input.'
    },
    FileOpenError: {
      code: 1500,
      message: 'Error occurred opening file %1.'
    },
    FileWriteError: {
      code: 1501,
      message: 'Error occurred writing to file %1.'
    },
    ScriptTimeoutError: {
      code: 1502,
      message: 'A script has executed for longer than the default timeout period of 15 seconds.'
    },
    ScriptTerminatedError: {
      code: 1503,
      message: 'A script failed to exit after 30 seconds and was terminated.'
    },
    EndOfFileError: {
      code: 1504,
      message: 'End of file.'
    },
    StringIndexOutOfBoundsError: {
      code: 1505,
      message: 'The string index %1 is out of bounds; must be in range %2 to %3.'
    },
    InvalidRangeError: {
      code: 1506,
      message: 'The specified range is invalid.'
    },
    NullArgumentError: {
      code: 1507,
      message: 'Argument %1 cannot be null.'
    },
    InvalidArgumentError: {
      code: 1508,
      message: 'The value specified for argument %1 is invalid.'
    },
    ArrayFilterNonNullObjectError: {
      code: 1510,
      message: 'When the callback argument is a method of a class, the optional this argument must be null.'
    },
    InvalidParamError: {
      code: 2004,
      message: 'One of the parameters is invalid.'
    },
    ParamRangeError: {
      code: 2006,
      message: 'The supplied index is out of bounds.'
    },
    NullPointerError: {
      code: 2007,
      message: 'Parameter %1 must be non-null.'
    },
    InvalidEnumError: {
      code: 2008,
      message: 'Parameter %1 must be one of the accepted values.'
    },
    CantInstantiateError: {
      code: 2012,
      message: '%1 class cannot be instantiated.'
    },
    ArgumentError: {
      code: 2015,
      message: 'Invalid BitmapData.'
    },
    EOFError: {
      code: 2030,
      message: 'End of file was encountered.'
    },
    CompressedDataError: {
      code: 2058,
      message: 'There was an error decompressing the data.'
    },
    EmptyStringError: {
      code: 2085,
      message: 'Parameter %1 must be non-empty string.'
    },
    ProxyGetPropertyError: {
      code: 2088,
      message: 'The Proxy class does not implement getProperty. It must be overridden by a subclass.'
    },
    ProxySetPropertyError: {
      code: 2089,
      message: 'The Proxy class does not implement setProperty. It must be overridden by a subclass.'
    },
    ProxyCallPropertyError: {
      code: 2090,
      message: 'The Proxy class does not implement callProperty. It must be overridden by a subclass.'
    },
    ProxyHasPropertyError: {
      code: 2091,
      message: 'The Proxy class does not implement hasProperty. It must be overridden by a subclass.'
    },
    ProxyDeletePropertyError: {
      code: 2092,
      message: 'The Proxy class does not implement deleteProperty. It must be overridden by a subclass.'
    },
    ProxyGetDescendantsError: {
      code: 2093,
      message: 'The Proxy class does not implement getDescendants. It must be overridden by a subclass.'
    },
    ProxyNextNameIndexError: {
      code: 2105,
      message: 'The Proxy class does not implement nextNameIndex. It must be overridden by a subclass.'
    },
    ProxyNextNameError: {
      code: 2106,
      message: 'The Proxy class does not implement nextName. It must be overridden by a subclass.'
    },
    ProxyNextValueError: {
      code: 2107,
      message: 'The Proxy class does not implement nextValue. It must be overridden by a subclass.'
    },
    InvalidArrayLengthError: {
      code: 2108,
      message: 'The value %1 is not a valid Array length.'
    },
    ReadExternalNotImplementedError: {
      code: 2173,
      message: 'Unable to read object in stream.  The class %1 does not implement flash.utils.IExternalizable but is aliased to an externalizable class.'
    },
    NoSecurityContextError: {
      code: 2000,
      message: 'No active security context.'
    },
    TooFewArgumentsError: {
      code: 2001,
      message: 'Too few arguments were specified; got %1, %2 expected.'
    },
    InvalidSocketError: {
      code: 2002,
      message: 'Operation attempted on invalid socket.'
    },
    InvalidSocketPortError: {
      code: 2003,
      message: 'Invalid socket port number specified.'
    },
    ParamTypeError: {
      code: 2005,
      message: 'Parameter %1 is of the incorrect type. Should be type %2.'
    },
    HasStyleSheetError: {
      code: 2009,
      message: 'This method cannot be used on a text field with a style sheet.'
    },
    SocketLocalFileSecurityError: {
      code: 2010,
      message: 'Local-with-filesystem SWF files are not permitted to use sockets.'
    },
    SocketConnectError: {
      code: 2011,
      message: 'Socket connection failed to %1:%2.'
    },
    AuthoringOnlyFeatureError: {
      code: 2013,
      message: 'Feature can only be used in Flash Authoring.'
    },
    FeatureNotAvailableError: {
      code: 2014,
      message: 'Feature is not available at this time.'
    },
    InvalidBitmapDataError: {
      code: 2015,
      message: 'Invalid BitmapData.'
    },
    SystemExitSecurityError: {
      code: 2017,
      message: 'Only trusted local files may cause the Flash Player to exit.'
    },
    SystemExitUnsupportedError: {
      code: 2018,
      message: 'System.exit is only available in the standalone Flash Player.'
    },
    InvalidDepthError: {
      code: 2019,
      message: 'Depth specified is invalid.'
    },
    MovieClipSwapError: {
      code: 2020,
      message: 'MovieClips objects with different parents cannot be swapped.'
    },
    ObjectCreationError: {
      code: 2021,
      message: 'Object creation failed.'
    },
    NotDisplayObjectError: {
      code: 2022,
      message: 'Class %1 must inherit from DisplayObject to link to a symbol.'
    },
    NotSpriteError: {
      code: 2023,
      message: 'Class %1 must inherit from Sprite to link to the root.'
    },
    CantAddSelfError: {
      code: 2024,
      message: 'An object cannot be added as a child of itself.'
    },
    NotAChildError: {
      code: 2025,
      message: 'The supplied DisplayObject must be a child of the caller.'
    },
    NavigateURLError: {
      code: 2026,
      message: 'An error occurred navigating to the URL %1.'
    },
    MustBeNonNegativeError: {
      code: 2027,
      message: 'Parameter %1 must be a non-negative number; got %2.'
    },
    LocalSecurityError: {
      code: 2028,
      message: 'Local-with-filesystem SWF file %1 cannot access Internet URL %2.'
    },
    InvalidStreamError: {
      code: 2029,
      message: 'This URLStream object does not have a stream opened.'
    },
    SocketError: {
      code: 2031,
      message: 'Socket Error.'
    },
    StreamError: {
      code: 2032,
      message: 'Stream Error.'
    },
    KeyGenerationError: {
      code: 2033,
      message: 'Key Generation Failed.'
    },
    InvalidKeyError: {
      code: 2034,
      message: 'An invalid digest was supplied.'
    },
    URLNotFoundError: {
      code: 2035,
      message: 'URL Not Found.'
    },
    LoadNeverCompletedError: {
      code: 2036,
      message: 'Load Never Completed.'
    },
    InvalidCallError: {
      code: 2037,
      message: 'Functions called in incorrect sequence, or earlier call was unsuccessful.'
    },
    FileIOError: {
      code: 2038,
      message: 'File I/O Error.'
    },
    RemoteURLError: {
      code: 2039,
      message: 'Invalid remote URL protocol. The remote URL protocol must be HTTP or HTTPS.'
    },
    BrowseInProgressError: {
      code: 2041,
      message: 'Only one file browsing session may be performed at a time.'
    },
    DigestNotSupportedError: {
      code: 2042,
      message: 'The digest property is not supported by this load operation.'
    },
    UnhandledError: {
      code: 2044,
      message: 'Unhandled %1:.'
    },
    FileVerificationError: {
      code: 2046,
      message: 'The loaded file did not have a valid signature.'
    },
    DisplayListSecurityError: {
      code: 2047,
      message: 'Security sandbox violation: %1: %2 cannot access %3.'
    },
    DownloadSecurityError: {
      code: 2048,
      message: 'Security sandbox violation: %1 cannot load data from %2.'
    },
    UploadSecurityError: {
      code: 2049,
      message: 'Security sandbox violation: %1 cannot upload data to %2.'
    },
    OutboundScriptingSecurityError: {
      code: 2051,
      message: 'Security sandbox violation: %1 cannot evaluate scripting URLs within %2 (allowScriptAccess is %3). Attempted URL was %4.'
    },
    AllowDomainArgumentError: {
      code: 2052,
      message: 'Only String arguments are permitted for allowDomain and allowInsecureDomain.'
    },
    IntervalSecurityError: {
      code: 2053,
      message: 'Security sandbox violation: %1 cannot clear an interval timer set by %2.'
    },
    ExactSettingsError: {
      code: 2054,
      message: 'The value of Security.exactSettings cannot be changed after it has been used.'
    },
    PrintJobStartError: {
      code: 2055,
      message: 'The print job could not be started.'
    },
    PrintJobSendError: {
      code: 2056,
      message: 'The print job could not be sent to the printer.'
    },
    PrintJobAddPageError: {
      code: 2057,
      message: 'The page could not be added to the print job.'
    },
    ExternalCallbackSecurityError: {
      code: 2059,
      message: 'Security sandbox violation: %1 cannot overwrite an ExternalInterface callback added by %2.'
    },
    ExternalInterfaceSecurityError: {
      code: 2060,
      message: 'Security sandbox violation: ExternalInterface caller %1 cannot access %2.'
    },
    ExternalInterfaceNoCallbackError: {
      code: 2061,
      message: 'No ExternalInterface callback %1 registered.'
    },
    NoCloneMethodError: {
      code: 2062,
      message: 'Children of Event must override clone() {return new MyEventClass (...);}.'
    },
    IMEError: {
      code: 2063,
      message: 'Error attempting to execute IME command.'
    },
    FocusNotSetError: {
      code: 2065,
      message: 'The focus cannot be set for this target.'
    },
    DelayRangeError: {
      code: 2066,
      message: 'The Timer delay specified is out of range.'
    },
    ExternalInterfaceNotAvailableError: {
      code: 2067,
      message: 'The ExternalInterface is not available in this container. ExternalInterface requires Internet Explorer ActiveX, Firefox, Mozilla 1.7.5 and greater, or other browsers that support NPRuntime.'
    },
    InvalidSoundError: {
      code: 2068,
      message: 'Invalid sound.'
    },
    InvalidLoaderMethodError: {
      code: 2069,
      message: 'The Loader class does not implement this method.'
    },
    StageOwnerSecurityError: {
      code: 2070,
      message: 'Security sandbox violation: caller %1 cannot access Stage owned by %2.'
    },
    InvalidStageMethodError: {
      code: 2071,
      message: 'The Stage class does not implement this property or method.'
    },
    ProductManagerDiskError: {
      code: 2073,
      message: 'There was a problem saving the application to disk.'
    },
    ProductManagerStageError: {
      code: 2074,
      message: 'The stage is too small to fit the download ui.'
    },
    ProductManagerVerifyError: {
      code: 2075,
      message: 'The downloaded file is invalid.'
    },
    FilterFailedError: {
      code: 2077,
      message: 'This filter operation cannot be performed with the specified input parameters.'
    },
    TimelineObjectNameSealedError: {
      code: 2078,
      message: 'The name property of a Timeline-placed object cannot be modified.'
    },
    BitmapNotAssociatedWithBitsCharError: {
      code: 2079,
      message: 'Classes derived from Bitmap can only be associated with defineBits characters (bitmaps).'
    },
    AlreadyConnectedError: {
      code: 2082,
      message: 'Connect failed because the object is already connected.'
    },
    CloseNotConnectedError: {
      code: 2083,
      message: 'Close failed because the object is not connected.'
    },
    ArgumentSizeError: {
      code: 2084,
      message: 'The AMF encoding of the arguments cannot exceed 40K.'
    },
    FileReferenceProhibitedError: {
      code: 2086,
      message: 'A setting in the mms.cfg file prohibits this FileReference request.'
    },
    DownloadFileNameProhibitedError: {
      code: 2087,
      message: 'The FileReference.download() file name contains prohibited characters.'
    },
    EventDispatchRecursionError: {
      code: 2094,
      message: 'Event dispatch recursion overflow.'
    },
    AsyncError: {
      code: 2095,
      message: '%1 was unable to invoke callback %2.'
    },
    DisallowedHTTPHeaderError: {
      code: 2096,
      message: 'The HTTP request header %1 cannot be set via ActionScript.'
    },
    FileFilterError: {
      code: 2097,
      message: 'The FileFilter Array is not in the correct format.'
    },
    LoadingObjectNotSWFError: {
      code: 2098,
      message: 'The loading object is not a .swf file, you cannot request SWF properties from it.'
    },
    LoadingObjectNotInitializedError: {
      code: 2099,
      message: 'The loading object is not sufficiently loaded to provide this information.'
    },
    EmptyByteArrayError: {
      code: 2100,
      message: 'The ByteArray parameter in Loader.loadBytes() must have length greater than 0.'
    },
    DecodeParamError: {
      code: 2101,
      message: 'The String passed to URLVariables.decode() must be a URL-encoded query string containing name/value pairs.'
    },
    NotAnXMLChildError: {
      code: 2102,
      message: 'The before XMLNode parameter must be a child of the caller.'
    },
    XMLRecursionError: {
      code: 2103,
      message: 'XML recursion failure: new child would create infinite loop.'
    },
    SceneNotFoundError: {
      code: 2108,
      message: 'Scene %1 was not found.'
    },
    FrameLabelNotFoundError: {
      code: 2109,
      message: 'Frame label %1 not found in scene %2.'
    },
    DisableAVM1LoadingError: {
      code: 2110,
      message: 'The value of Security.disableAVM1Loading cannot be set unless the caller can access the stage and is in an ActionScript 3.0 SWF file.'
    },
    AVM1LoadingError: {
      code: 2111,
      message: 'Security.disableAVM1Loading is true so the current load of the ActionScript 1.0/2.0 SWF file has been blocked.'
    },
    ApplicationDomainSecurityError: {
      code: 2112,
      message: 'Provided parameter LoaderContext.ApplicationDomain is from a disallowed domain.'
    },
    SecurityDomainSecurityError: {
      code: 2113,
      message: 'Provided parameter LoaderContext.SecurityDomain is from a disallowed domain.'
    },
    NonNullPointerError: {
      code: 2114,
      message: 'Parameter %1 must be null.'
    },
    TrueParamError: {
      code: 2115,
      message: 'Parameter %1 must be false.'
    },
    FalseParamError: {
      code: 2116,
      message: 'Parameter %1 must be true.'
    },
    InvalidLoaderInfoMethodError: {
      code: 2118,
      message: 'The LoaderInfo class does not implement this method.'
    },
    LoaderInfoAppDomainSecurityError: {
      code: 2119,
      message: 'Security sandbox violation: caller %1 cannot access LoaderInfo.applicationDomain owned by %2.'
    },
    SecuritySwfNotAllowedError: {
      code: 2121,
      message: 'Security sandbox violation: %1: %2 cannot access %3. This may be worked around by calling Security.allowDomain.'
    },
    SecurityNonSwfIncompletePolicyFilesError: {
      code: 2122,
      message: 'Security sandbox violation: %1: %2 cannot access %3. A policy file is required, but the checkPolicyFile flag was not set when this media was loaded.'
    },
    SecurityNonSwfNotAllowedError: {
      code: 2123,
      message: 'Security sandbox violation: %1: %2 cannot access %3. No policy files granted access.'
    },
    UnknownFileTypeError: {
      code: 2124,
      message: 'Loaded file is an unknown type.'
    },
    SecurityCrossVMNotAllowedError: {
      code: 2125,
      message: 'Security sandbox violation: %1 cannot use Runtime Shared Library %2 because crossing the boundary between ActionScript 3.0 and ActionScript 1.0/2.0 objects is not allowed.'
    },
    NotConnectedError: {
      code: 2126,
      message: 'NetConnection object must be connected.'
    },
    FileRefBadPostDataTypeError: {
      code: 2127,
      message: 'FileReference POST data cannot be type ByteArray.'
    },
    NetConnectionConnectError: {
      code: 2129,
      message: 'Connection to %1 failed.'
    },
    SharedObjectFlushFailedError: {
      code: 2130,
      message: 'Unable to flush SharedObject.'
    },
    DefinitionNotFoundError: {
      code: 2131,
      message: 'Definition %1 cannot be found.'
    },
    NetConnectionInvalidConnectFromNetStatusEventError: {
      code: 2132,
      message: 'NetConnection.connect cannot be called from a netStatus event handler.'
    },
    CallbackNotRegisteredError: {
      code: 2133,
      message: 'Callback %1 is not registered.'
    },
    SharedObjectCreateError: {
      code: 2134,
      message: 'Cannot create SharedObject.'
    },
    InvalidSWFError: {
      code: 2136,
      message: 'The SWF file %1 contains invalid data.'
    },
    NavigationSecurityError: {
      code: 2137,
      message: 'Security sandbox violation: %1 cannot navigate window %2 within %3 (allowScriptAccess is %4). Attempted URL was %5.'
    },
    NonParsableRichTextXMLError: {
      code: 2138,
      message: 'Rich text XML could not be parsed.'
    },
    SharedObjectConnectError: {
      code: 2139,
      message: 'SharedObject could not connect.'
    },
    LocalSecurityLoadingError: {
      code: 2140,
      message: 'Security sandbox violation: %1 cannot load %2. Local-with-filesystem and local-with-networking SWF files cannot load each other.'
    },
    MultiplePrintJobsError: {
      code: 2141,
      message: 'Only one PrintJob may be in use at a time.'
    },
    LocalImportSecurityError: {
      code: 2142,
      message: 'Security sandbox violation: local SWF files cannot use the LoaderContext.securityDomain property. %1 was attempting to load %2.'
    },
    AccOverrideRole: {
      code: 2143,
      message: 'AccessibilityImplementation.get_accRole() must be overridden from its default.'
    },
    AccOverrideState: {
      code: 2144,
      message: 'AccessibilityImplementation.get_accState() must be overridden from its default.'
    },
    URLRequestHeaderInvalidLengthError: {
      code: 2145,
      message: 'Cumulative length of requestHeaders must be less than 8192 characters.'
    },
    AllowNetworkingSecurityError: {
      code: 2146,
      message: 'Security sandbox violation: %1 cannot call %2 because the HTML/container parameter allowNetworking has the value %3.'
    },
    ForbiddenProtocolError: {
      code: 2147,
      message: 'Forbidden protocol in URL %1.'
    },
    RemoteToLocalSecurityError: {
      code: 2148,
      message: 'SWF file %1 cannot access local resource %2. Only local-with-filesystem and trusted local SWF files may access local resources.'
    },
    FsCommandSecurityError: {
      code: 2149,
      message: 'Security sandbox violation: %1 cannot make fscommand calls to %2 (allowScriptAccess is %3).'
    },
    CantAddParentError: {
      code: 2150,
      message: 'An object cannot be added as a child to one of it\'s children (or children\'s children, etc.).'
    },
    FullScreenSecurityError: {
      code: 2151,
      message: 'You cannot enter full screen mode when the settings dialog is visible.'
    },
    FullScreenNotAllowedError: {
      code: 2152,
      message: 'Full screen mode is not allowed.'
    },
    URLRequestInvalidHeader: {
      code: 2153,
      message: 'The URLRequest.requestHeaders array must contain only non-NULL URLRequestHeader objects.'
    },
    InvalidNetStreamObject: {
      code: 2154,
      message: 'The NetStream Object is invalid.  This may be due to a failed NetConnection.'
    },
    InvalidFunctionName: {
      code: 2155,
      message: 'The ExternalInterface.call functionName parameter is invalid.  Only alphanumeric characters are supported.'
    },
    ForbiddenPortForProtocolError: {
      code: 2156,
      message: 'Port %1 may not be accessed using protocol %2. Calling SWF was %3.'
    },
    NoAsfunctionErrror: {
      code: 2157,
      message: 'Rejecting URL %1 because the \'asfunction:\' protocol may only be used for link targets, not for networking APIs.'
    },
    InvalidNetConnectionObject: {
      code: 2158,
      message: 'The NetConnection Object is invalid.  This may be due to a dropped NetConnection.'
    },
    InvalidSharedObject: {
      code: 2159,
      message: 'The SharedObject Object is invalid.'
    },
    InvalidTextLineError: {
      code: 2160,
      message: 'The TextLine is INVALID and cannot be used to access the current state of the TextBlock.'
    },
    TextLayoutError: {
      code: 2161,
      message: 'An internal error occured while laying out the text.'
    },
    FragmentOutputType: {
      code: 2162,
      message: 'The Shader output type is not compatible for this operation.'
    },
    FragmentInputType: {
      code: 2163,
      message: 'The Shader input type %1 is not compatible for this operation.'
    },
    FragmentInputMissing: {
      code: 2164,
      message: 'The Shader input %1 is missing or an unsupported type.'
    },
    FragmentInputTooSmall: {
      code: 2165,
      message: 'The Shader input %1 does not have enough data.'
    },
    FragmentInputNoDimension: {
      code: 2166,
      message: 'The Shader input %1 lacks valid dimensions.'
    },
    FragmentNotEnoughInput: {
      code: 2167,
      message: 'The Shader does not have the required number of inputs for this operation.'
    },
    StaticTextLineError: {
      code: 2168,
      message: 'Static text lines have no atoms and no reference to a text block.'
    },
    SecurityQuestionableBrowserScriptingError: {
      code: 2169,
      message: 'The method %1 may not be used for browser scripting.  The URL %2 requested by %3 is being ignored.  If you intend to call browser script, use navigateToURL instead.'
    },
    HeaderSecurityError: {
      code: 2170,
      message: 'Security sandbox violation: %1 cannot send HTTP headers to %2.'
    },
    FragmentMissing: {
      code: 2171,
      message: 'The Shader object contains no byte code to execute.'
    },
    FragmentAlreadyRunning: {
      code: 2172,
      message: 'The ShaderJob is already running or finished.'
    },
    FileReferenceBusyError: {
      code: 2174,
      message: 'Only one download, upload, load or save operation can be active at a time on each FileReference.'
    },
    UnformattedElementError: {
      code: 2175,
      message: 'One or more elements of the content of the TextBlock has a null ElementFormat.'
    },
    UserActionRequiredError: {
      code: 2176,
      message: 'Certain actions, such as those that display a pop-up window, may only be invoked upon user interaction, for example by a mouse click or button press.'
    },
    FragmentInputTooLarge: {
      code: 2177,
      message: 'The Shader input %1 is too large.'
    },
    ClipboardConstNotAllowed: {
      code: 2178,
      message: 'The Clipboard.generalClipboard object must be used instead of creating a new Clipboard.'
    },
    ClipboardDisallowedRead: {
      code: 2179,
      message: 'The Clipboard.generalClipboard object may only be read while processing a flash.events.Event.PASTE event.'
    },
    CantMoveAVM1ContentLoadedIntoAVM2: {
      code: 2180,
      message: 'It is illegal to move AVM1 content (AS1 or AS2) to a different part of the displayList when it has been loaded into AVM2 (AS3) content.'
    },
    InvalidTextLineMethodError: {
      code: 2181,
      message: 'The TextLine class does not implement this property or method.'
    },
    PerspectiveFieldOfViewValueInvalid: {
      code: 2182,
      message: 'Invalid fieldOfView value.  The value must be greater than 0 and less than 180.'
    },
    Invalid3DScale: {
      code: 2183,
      message: 'Scale values must not be zero.'
    },
    LockedElementFormatError: {
      code: 2184,
      message: 'The ElementFormat object is locked and cannot be modified.'
    },
    LockedFontDescriptionError: {
      code: 2185,
      message: 'The FontDescription object is locked and cannot be modified.'
    },
    PerspectiveFocalLengthInvalid: {
      code: 2186,
      message: 'Invalid focalLength %1.'
    },
    Matrix3DDecomposeTypeInvalid: {
      code: 2187,
      message: 'Invalid orientation style %1.  Value must be one of \'Orientation3D.EULER_ANGLES\', \'Orientation3D.AXIS_ANGLE\', or \'Orientation3D.QUATERNION\'.'
    },
    MatrixNonInvertibleError: {
      code: 2188,
      message: 'Invalid raw matrix. Matrix must be invertible.'
    },
    Matrix3DRefCannontBeShared: {
      code: 2189,
      message: 'A Matrix3D can not be assigned to more than one DisplayObject.'
    },
    ForceDownloadSecurityError: {
      code: 2190,
      message: 'The attempted load of %1 failed as it had a Content-Disposition of attachment set.'
    },
    ClipboardDisallowedWrite: {
      code: 2191,
      message: 'The Clipboard.generalClipboard object may only be written to as the result of user interaction, for example by a mouse click or button press.'
    },
    MalformedUnicodeError: {
      code: 2192,
      message: 'An unpaired Unicode surrogate was encountered in the input.'
    },
    SecurityContentAccessDeniedError: {
      code: 2193,
      message: 'Security sandbox violation: %1: %2 cannot access %3.'
    },
    LoaderParamError: {
      code: 2194,
      message: 'Parameter %1 cannot be a Loader.'
    },
    LoaderAsyncError: {
      code: 2195,
      message: 'Error thrown as Loader called %1.'
    },
    ObjectWithStringsParamError: {
      code: 2196,
      message: 'Parameter %1 must be an Object with only String values.'
    },
    SystemUpdaterPlayerNotSupportedError: {
      code: 2200,
      message: 'The SystemUpdater class is not supported by this player.'
    },
    SystemUpdaterOSNotSupportedError: {
      code: 2201,
      message: 'The requested update type is not supported on this operating system.'
    },
    SystemUpdaterBusy: {
      code: 2202,
      message: 'Only one SystemUpdater action is allowed at a time.'
    },
    SystemUpdaterFailed: {
      code: 2203,
      message: 'The requested SystemUpdater action cannot be completed.'
    },
    SystemUpdaterCannotCancel: {
      code: 2204,
      message: 'This operation cannot be canceled because it is waiting for user interaction.'
    },
    SystemUpdaterUnknownTarget: {
      code: 2205,
      message: 'Invalid update type %1.'
    },
    SignedSWfLoadingError: {
      code: 2500,
      message: 'An error occurred decrypting the signed swf file. The swf will not be loaded.'
    },
    NotScreenSharingError: {
      code: 2501,
      message: 'This property can only be accessed during screen sharing.'
    },
    NotSharingMonitorError: {
      code: 2502,
      message: 'This property can only be accessed if sharing the entire screen.'
    },
    FileBadPathName: {
      code: 3000,
      message: 'Illegal path name.'
    },
    FileAccessDenied: {
      code: 3001,
      message: 'File or directory access denied.'
    },
    FileExists: {
      code: 3002,
      message: 'File or directory exists.'
    },
    FileDoesNotExist: {
      code: 3003,
      message: 'File or directory does not exist.'
    },
    FileInsufficientSpace: {
      code: 3004,
      message: 'Insufficient file space.'
    },
    FileSystemResources: {
      code: 3005,
      message: 'Insufficient system resources.'
    },
    FileNotAFile: {
      code: 3006,
      message: 'Not a file.'
    },
    FileNotADir: {
      code: 3007,
      message: 'Not a directory.'
    },
    FileReadOnlyFileSys: {
      code: 3008,
      message: 'Read-only or write-protected media.'
    },
    FileNotSameDevice: {
      code: 3009,
      message: 'Cannot move file or directory to a different device.'
    },
    DirNotEmpty: {
      code: 3010,
      message: 'Directory is not empty.'
    },
    FileDestinationExists: {
      code: 3011,
      message: 'Move or copy destination already exists.'
    },
    FileCantDelete: {
      code: 3012,
      message: 'Cannot delete file or directory.'
    },
    FileInUse: {
      code: 3013,
      message: 'File or directory is in use.'
    },
    FileCopyMoveAncestor: {
      code: 3014,
      message: 'Cannot copy or move a file or directory to overwrite a containing directory.'
    },
    LoadBytesCodeExecutionSecurityError: {
      code: 3015,
      message: 'Loader.loadBytes() is not permitted to load content with executable code.'
    },
    FileApplicationNotFound: {
      code: 3016,
      message: 'No application was found that can open this file.'
    },
    SQLConnectionCannotClose: {
      code: 3100,
      message: 'A SQLConnection cannot be closed while statements are still executing.'
    },
    SQLConnectionAlreadyOpen: {
      code: 3101,
      message: 'Database connection is already open.'
    },
    SQLConnectionInvalidName: {
      code: 3102,
      message: 'Name argument specified was invalid. It must not be null or empty.'
    },
    SQLConnectionInTransaction: {
      code: 3103,
      message: 'Operation cannot be performed while there is an open transaction on this connection.'
    },
    SQLConnectionNotOpen: {
      code: 3104,
      message: 'A SQLConnection must be open to perform this operation.'
    },
    SQLConnectionNoOpenTransaction: {
      code: 3105,
      message: 'Operation is only allowed if a connection has an open transaction.'
    },
    SQLStatementIsExecutingProperty: {
      code: 3106,
      message: 'Property cannot be changed while SQLStatement.executing is true.'
    },
    SQLStatementIvalidCall: {
      code: 3107,
      message: '%1 may not be called unless SQLResult.complete is false.'
    },
    SQLStatementInvalidText: {
      code: 3108,
      message: 'Operation is not permitted when the SQLStatement.text property is not set.'
    },
    SQLStatementInvalidConnection: {
      code: 3109,
      message: 'Operation is not permitted when the SQLStatement.sqlConnection property is not set.'
    },
    SQLStatementIsExecutingCall: {
      code: 3110,
      message: 'Operation cannot be performed while SQLStatement.executing is true.'
    },
    SQLStatementInvalidSchemaType: {
      code: 3111,
      message: 'An invalid schema type was specified.'
    },
    SQLConnectionInvalidLockType: {
      code: 3112,
      message: 'An invalid transaction lock type was specified.'
    },
    SQLConnectionNotFileReference: {
      code: 3113,
      message: 'Reference specified is not of type File.'
    },
    SQLConnectionInvalidModeSpecified: {
      code: 3114,
      message: 'An invalid open mode was specified.'
    },
    SQLGeneralEngineError: {
      code: 3115,
      message: 'SQL Error.'
    },
    SQLInternalEngineError: {
      code: 3116,
      message: 'An internal logic error occurred.'
    },
    SQLPermissionError: {
      code: 3117,
      message: 'Access permission denied.'
    },
    SQLOperationAbortedError: {
      code: 3118,
      message: 'Operation aborted.'
    },
    SQLDatabaseLockedError: {
      code: 3119,
      message: 'Database file is currently locked.'
    },
    SQLTableLockedError: {
      code: 3120,
      message: 'Table is locked.'
    },
    SQLOutOfMemoryError: {
      code: 3121,
      message: 'Out of memory.'
    },
    SQLDatabaseIsReadonlyError: {
      code: 3122,
      message: 'Attempt to write a readonly database.'
    },
    SQLDatabaseCorruptError: {
      code: 3123,
      message: 'Database disk image is malformed.'
    },
    SQLDatabaseFullError: {
      code: 3124,
      message: 'Insertion failed because database is full.'
    },
    SQLCannotOpenDatabaseError: {
      code: 3125,
      message: 'Unable to open the database file.'
    },
    SQLLockingProtocolError: {
      code: 3126,
      message: 'Database lock protocol error.'
    },
    SQLDatabaseEmptyError: {
      code: 3127,
      message: 'Database is empty.'
    },
    SQLDiskIOError: {
      code: 3128,
      message: 'Disk I/O error occurred.'
    },
    SQLSchemaChangedError: {
      code: 3129,
      message: 'The database schema changed.'
    },
    SQLTooMuchDataError: {
      code: 3130,
      message: 'Too much data for one row of a table.'
    },
    SQLConstraintError: {
      code: 3131,
      message: 'Abort due to constraint violation.'
    },
    SQLDataTypeMismatchError: {
      code: 3132,
      message: 'Data type mismatch.'
    },
    SQLConcurrencyError: {
      code: 3133,
      message: 'An internal error occurred.'
    },
    SQLNotSupportedOnOSError: {
      code: 3134,
      message: 'Feature not supported on this operating system.'
    },
    SQLAuthorizationDeniedError: {
      code: 3135,
      message: 'Authorization denied.'
    },
    SQLAuxDatabaseFormatError: {
      code: 3136,
      message: 'Auxiliary database format error.'
    },
    SQLBindingRangeError: {
      code: 3137,
      message: 'An index specified for a parameter was out of range.'
    },
    SQLInvalidDatabaseFileError: {
      code: 3138,
      message: 'File opened is not a database file.'
    },
    SQLInvalidPageSizeError: {
      code: 3139,
      message: 'The page size specified was not valid for this operation.'
    },
    SQLInvalidKeySizeError: {
      code: 3140,
      message: 'The encryption key size specified was not valid for this operation. Keys must be exactly 16 bytes in length'
    },
    SQLInvalidConfigurationError: {
      code: 3141,
      message: 'The requested database configuration is not supported.'
    },
    SQLCannotRekeyNonKeyedDatabase: {
      code: 3143,
      message: 'Unencrypted databases may not be reencrypted.'
    },
    NativeWindowClosedError: {
      code: 3200,
      message: 'Cannot perform operation on closed window.'
    },
    PDFNoReaderInstalled: {
      code: 3201,
      message: 'Adobe Reader cannot be found.'
    },
    PDFOldReaderInstalled: {
      code: 3202,
      message: 'Adobe Reader 8.1 or later cannot be found.'
    },
    PDFOldDefaultText: {
      code: 3203,
      message: 'Default Adobe Reader must be version 8.1 or later.'
    },
    PDFCannotLoadReader: {
      code: 3204,
      message: 'An error ocurred trying to load Adobe Reader.'
    },
    ApplicationFeatureSecurityError: {
      code: 3205,
      message: 'Only application-sandbox content can access this feature.'
    },
    LoaderInfoDoorSecurityError: {
      code: 3206,
      message: 'Caller %1 cannot set LoaderInfo property %2.'
    },
    ApplicationNonFeatureSecurityError: {
      code: 3207,
      message: 'Application-sandbox content cannot access this feature.'
    },
    InvalidClipboardAccess: {
      code: 3208,
      message: 'Attempt to access invalid clipboard.'
    },
    DeadClipboardAccess: {
      code: 3209,
      message: 'Attempt to access dead clipboard.'
    },
    DeadJavaScriptObjectAccess: {
      code: 3210,
      message: 'The application attempted to reference a JavaScript object in a HTML page that is no longer loaded.'
    },
    FilePromiseIOError: {
      code: 3211,
      message: 'Drag and Drop File Promise error: %1'
    },
    NativeProcessNotRunning: {
      code: 3212,
      message: 'Cannot perform operation on a NativeProcess that is not running.'
    },
    NativeProcessAlreadyRunning: {
      code: 3213,
      message: 'Cannot perform operation on a NativeProcess that is already running.'
    },
    NativeProcessBadExecutable: {
      code: 3214,
      message: 'NativeProcessStartupInfo.executable does not specify a valid executable file.'
    },
    NativeProcessBadWorkingDirectory: {
      code: 3215,
      message: 'NativeProcessStartupInfo.workingDirectory does not specify a valid directory.'
    },
    NativeProcessStdOutReadError: {
      code: 3216,
      message: 'Error while reading data from NativeProcess.standardOutput.'
    },
    NativeProcessStdErrReadError: {
      code: 3217,
      message: 'Error while reading data from NativeProcess.standardError.'
    },
    NativeProcessStdInWriteError: {
      code: 3218,
      message: 'Error while writing data to NativeProcess.standardInput.'
    },
    NativeProcessNotStarted: {
      code: 3219,
      message: 'The NativeProcess could not be started. \'%1\''
    },
    ActionNotAllowedSecurityError: {
      code: 3220,
      message: 'Action \'%1\' not allowed in current security context \'%2\'.'
    },
    SWFNoPlayerInstalled: {
      code: 3221,
      message: 'Adobe Flash Player cannot be found.'
    },
    SWFOldPlayerInstalled: {
      code: 3222,
      message: 'The installed version of Adobe Flash Player is too old.'
    },
    DNSResolverLookupError: {
      code: 3223,
      message: 'DNS lookup error: platform error %1'
    },
    SocketMessageTooLongError: {
      code: 3224,
      message: 'Socket message too long'
    },
    SocketCannotSendDataToAddressAfterConnect: {
      code: 3225,
      message: 'Cannot send data to a location when connected.'
    },
    AllowCodeImportError: {
      code: 3226,
      message: 'Cannot import a SWF file when LoaderContext.allowCodeImport is false.'
    },
    BackgroundLaunchError: {
      code: 3227,
      message: 'Cannot launch another application from background.'
    },
    StageWebViewLoadError: {
      code: 3228,
      message: 'StageWebView encountered an error during the load operation.'
    },
    StageWebViewProtocolNotSupported: {
      code: 3229,
      message: 'The protocol is not supported.:'
    },
    BrowseOperationUnsupported: {
      code: 3230,
      message: 'The browse operation is unsupported.'
    },
    InvalidVoucher: {
      code: 3300,
      message: 'Voucher is invalid.'
    },
    AuthenticationFailed: {
      code: 3301,
      message: 'User authentication failed.'
    },
    RequireSSLError: {
      code: 3302,
      message: 'Flash Access server does not support SSL.'
    },
    ContentExpiredError: {
      code: 3303,
      message: 'Content expired.'
    },
    AuthorizationFailed: {
      code: 3304,
      message: 'User authorization failed (for example, the user has not purchased the content).'
    },
    ServerConnectionFailed: {
      code: 3305,
      message: 'Can\'t connect to the server.'
    },
    ClientUpdateRequired: {
      code: 3306,
      message: 'Client update required (Flash Access server requires new client).'
    },
    InternalError: {
      code: 3307,
      message: 'Generic internal Flash Access failure.'
    },
    WrongVoucherKey: {
      code: 3308,
      message: 'Wrong voucher key.'
    },
    CorruptedFLV: {
      code: 3309,
      message: 'Video content is corrupted.'
    },
    AppIDMismatch: {
      code: 3310,
      message: 'The AIR application or Flash Player SWF does not match the one specified in the DRM policy.'
    },
    AppVersionMismatch: {
      code: 3311,
      message: 'The version of the application does not match the one specified in the DRM policy.'
    },
    VoucherIntegrityError: {
      code: 3312,
      message: 'Verification of voucher failed.'
    },
    WriteFileSystemFailed: {
      code: 3313,
      message: 'Write to the file system failed.'
    },
    FLVHeaderIntegrityFailed: {
      code: 3314,
      message: 'Verification of FLV/F4V header file failed.'
    },
    PermissionDenied: {
      code: 3315,
      message: 'The current security context does not allow this operation.'
    },
    LocalConnectionUserScopedLocked: {
      code: 3316,
      message: 'The value of LocalConnection.isPerUser cannot be changed because it has already been locked by a call to LocalConnection.connect, .send, or .close.'
    },
    LoadAdobeCPFailed: {
      code: 3317,
      message: 'Failed to load Flash Access module.'
    },
    IncompatibleAdobeCPVersion: {
      code: 3318,
      message: 'Incompatible version of Flash Access module found.'
    },
    MissingAdobeCPEntryPoint: {
      code: 3319,
      message: 'Missing Flash Access module API entry point.'
    },
    InternalErrorHA: {
      code: 3320,
      message: 'Generic internal Flash Access failure.'
    },
    IndividualizationFailed: {
      code: 3321,
      message: 'Individualization failed.'
    },
    DeviceBindingFailed: {
      code: 3322,
      message: 'Device binding failed.'
    },
    CorruptStore: {
      code: 3323,
      message: 'The internal stores are corrupted.'
    },
    MachineTokenInvalid: {
      code: 3324,
      message: 'Reset license files and the client will fetch a new machine token.'
    },
    CorruptServerStateStore: {
      code: 3325,
      message: 'Internal stores are corrupt.'
    },
    TamperingDetected: {
      code: 3326,
      message: 'Call customer support.'
    },
    ClockTamperingDetected: {
      code: 3327,
      message: 'Clock tampering detected.'
    },
    ServerErrorTryAgain: {
      code: 3328,
      message: 'Server error; retry the request.'
    },
    ApplicationSpecificError: {
      code: 3329,
      message: 'Error in application-specific namespace.'
    },
    NeedAuthentication: {
      code: 3330,
      message: 'Need to authenticate the user and reacquire the voucher.'
    },
    ContentNotYetValid: {
      code: 3331,
      message: 'Content is not yet valid.'
    },
    CachedVoucherExpired: {
      code: 3332,
      message: 'Cached voucher has expired. Reacquire the voucher from the server.'
    },
    PlaybackWindowExpired: {
      code: 3333,
      message: 'The playback window for this policy has expired.'
    },
    InvalidDRMPlatform: {
      code: 3334,
      message: 'This platform is not allowed to play this content.'
    },
    InvalidDRMVersion: {
      code: 3335,
      message: 'Invalid version of Flash Access module. Upgrade AIR or Flash Access module for the Flash Player.'
    },
    InvalidRuntimePlatform: {
      code: 3336,
      message: 'This platform is not allowed to play this content.'
    },
    InvalidRuntimeVersion: {
      code: 3337,
      message: 'Upgrade Flash Player or AIR  and retry playback.'
    },
    UnknownConnectionType: {
      code: 3338,
      message: 'Unknown connection type.'
    },
    NoAnalogPlaybackAllowed: {
      code: 3339,
      message: 'Can\'t play back on analog device. Connect to a digital device.'
    },
    NoAnalogProtectionAvail: {
      code: 3340,
      message: 'Can\'t play back because connected analog device doesn\'t have the correct capabilities.'
    },
    NoDigitalPlaybackAllowed: {
      code: 3341,
      message: 'Can\'t play back on digital device.'
    },
    NoDigitalProtectionAvail: {
      code: 3342,
      message: 'The connected digital device doesn\'t have the correct capabilities.'
    },
    InternalErrorIV: {
      code: 3343,
      message: 'Internal Error.'
    },
    MissingAdobeCPModule: {
      code: 3344,
      message: 'Missing Flash Access module.'
    },
    DRMNoAccessError: {
      code: 3345,
      message: 'This operation is not permitted with content protected using Flash Access.'
    },
    DRMDataMigrationFailed: {
      code: 3346,
      message: 'Failed migrating local DRM data, all locally cached DRM vouchers are lost.'
    },
    DRMInsufficientDeviceCapabilites: {
      code: 3347,
      message: 'The device does not meet the Flash Access server\'s playback device constraints.'
    },
    DRMHardStopIntervalExpired: {
      code: 3348,
      message: 'This protected content is expired.'
    },
    DRMServerVersionTooHigh: {
      code: 3349,
      message: 'The Flash Access server is running at a version that\'s higher than the max supported by this runtime.'
    },
    DRMServerVersionTooLow: {
      code: 3350,
      message: 'The Flash Access server is running at a version that\'s lower than the min supported by this runtime.'
    },
    DRMDeviceGroupTokenInvalid: {
      code: 3351,
      message: 'Device Group registration token is corrupted, please refresh the token by registering again to the DRMDeviceGroup.'
    },
    DRMDeviceGroupTokenTooOld: {
      code: 3352,
      message: 'The server is using a newer version of the registration token for this Device Group. Please refresh the token by registering again to the DRMDeviceGroup.'
    },
    DRMDeviceGroupTokenTooNew: {
      code: 3353,
      message: 'the server is using an older version of the registration token for this Device Group.'
    },
    DRMDeviceGroupTokenExpired: {
      code: 3354,
      message: 'Device Group registration is expired, please refresh the token by registering again to the DRMDeviceGroup.'
    },
    JoinDRMDeviceGroupFailed: {
      code: 3355,
      message: 'The server denied this Device Group registration request.'
    },
    DRMVoucherHasNoCorrespondingRoot: {
      code: 3356,
      message: 'The root voucher for this content\'s DRMVoucher was not found.'
    },
    NoValidEmbeddedDRMVoucher: {
      code: 3357,
      message: 'The DRMContentData provides no valid embedded voucher and no Flash Access server url to acquire the voucher from.'
    },
    NoACPProtectionAvailable: {
      code: 3358,
      message: 'ACP protection is not available on the device but required to playback the content.'
    },
    NoCGMSAProtectionAvailable: {
      code: 3359,
      message: 'CGMSA protection is not available on the device but required to playback the content.'
    },
    DRMDeviceGroupRegistrationRequired: {
      code: 3360,
      message: 'Device Group registration is required before doing this operation.'
    },
    DeviceIsNotRegisteredToDRMDeviceGroup: {
      code: 3361,
      message: 'The device is not registered to this Device Group.'
    },
    ScriptBridgeError: {
      code: 3400,
      message: 'An error occured while executing JavaScript code.'
    },
    ScriptBridgeNameAccessSecurityError: {
      code: 3401,
      message: 'Security sandbox violation: An object with this name has already been registered from another security domain.'
    },
    ScriptBridgeBrowserAccessSecurityError: {
      code: 3402,
      message: 'Security sandbox violation: Bridge caller %1 cannot access %2.'
    },
    ExtensionContextNoSuchMethod: {
      code: 3500,
      message: 'The extension context does not have a method with the name %1.'
    },
    ExtensionContextAlreadyDisposed: {
      code: 3501,
      message: 'The extension context has already been disposed.'
    },
    ExtensionContextInvalidReturnValue: {
      code: 3502,
      message: 'The extension returned an invalid value.'
    },
    ExtensionContextInvalidState: {
      code: 3503,
      message: 'The extension was left in an invalid state.'
    },
    NoValidProgramSet: {
      code: 3600,
      message: 'No valid program set.'
    },
    NoValidIndexBufferSet: {
      code: 3601,
      message: 'No valid index buffer set.'
    },
    SanityCheckOnParametersFailed: {
      code: 3602,
      message: 'Sanity check on parameters failed, %1 triangles and %2 index offset.'
    },
    NotEnoughIndicesInThisBuffer: {
      code: 3603,
      message: 'Not enough indices in this buffer. %1 triangles at offset %2, but there are only %3 indices in buffer.'
    },
    SampleBindsTextureAlsoBoundToRender: {
      code: 3604,
      message: 'Sampler %1 binds a texture that is also bound for render to texture.'
    },
    SampleBindsInvalidTexture: {
      code: 3605,
      message: 'Sampler %1 binds an invalid texture.'
    },
    SamplerFormatDoesNotMatchTextureFormat: {
      code: 3606,
      message: 'Sampler %1 format does not match texture format.'
    },
    StreamIsNotUsed: {
      code: 3607,
      message: 'Stream %1 is set but not used by the current vertex program.'
    },
    StreamIsInvalid: {
      code: 3608,
      message: 'Stream %1 is invalid.'
    },
    StreamDoesNotHaveEnoughVertices: {
      code: 3609,
      message: 'Stream %1 does not have enough vertices.'
    },
    StreamVertexOffsetOutOfBounds: {
      code: 3610,
      message: 'Stream %1 vertex offset is out of bounds'
    },
    StreamReadButNotSet: {
      code: 3611,
      message: 'Stream %1 is read by the current vertex program but not set.'
    },
    ProgramMustBeLittleEndian: {
      code: 3612,
      message: 'Programs must be in little endian format.'
    },
    NativeShaderCompilationFailed: {
      code: 3613,
      message: 'The native shader compilation failed.'
    },
    NativeShaderCompilationFailedOpenGL: {
      code: 3614,
      message: 'The native shader compilation failed.enGL specific: %1'
    },
    AgalProgramTooSmall: {
      code: 3615,
      message: 'AGAL validation failed: Program size below minimum length for %1 program.'
    },
    NotAnAgalProgram: {
      code: 3616,
      message: 'AGAL validation failed: Not an AGAL program. Wrong magic byte for %1 program.'
    },
    BadAgalVersion: {
      code: 3617,
      message: 'AGAL validation failed: Bad AGAL version for %1 program. Current version is %2.'
    },
    BadAgalProgramType: {
      code: 3618,
      message: 'AGAL validation failed: Bad AGAL program type identifier for %1 program.'
    },
    BadAgalShadertype: {
      code: 3619,
      message: 'AGAL validation failed: Shader type must be either fragment or vertex for %1 program.'
    },
    InvalidAgalOpcodeOutOfRange: {
      code: 3620,
      message: 'AGAL validation failed: Invalid opcode, value out of range: %2 at token %3 of %1 program.'
    },
    InvalidAgalOpcodeNotImplemented: {
      code: 3621,
      message: 'AGAL validation failed: Invalid opcode, %2 is not implemented in this version at token %3 of %1 program.'
    },
    AgalOpcodeOnlyAllowedInFragmentProgram: {
      code: 3622,
      message: 'AGAL validation failed: Opcode %2 only allowed in fragment programs at token %3 of %1 program.'
    },
    OpenConditionNesting: {
      code: 3623,
      message: 'AGAL validation failed: Open condition nesting (close without open) at token %2 of %1 program.'
    },
    ConditionNestingTooDeep: {
      code: 3624,
      message: 'AGAL validation failed: Condition nesting (%2) too deep at token %3 of %1 program.'
    },
    BadAgalSourceOperands: {
      code: 3625,
      message: 'AGAL validation failed: Bad AGAL source operands. Both are constants (this must be precomputed) at token %2 of %1 program.'
    },
    BothOperandsAreIndirectReads: {
      code: 3626,
      message: 'AGAL validation failed: Opcode %2, both operands are indirect reads at token %3 of %1 program.'
    },
    OpcodeDestinationMustBeAllZero: {
      code: 3627,
      message: 'AGAL validation failed: Opcode %2 destination operand must be all zero at token %3 of %1 program.'
    },
    OpcodeDestinationMustUseMask: {
      code: 3628,
      message: 'AGAL validation failed: The destination operand for the %2 instruction must mask w (use .xyz or less) at token %3 of %1 program.'
    },
    TooManyTokens: {
      code: 3629,
      message: 'AGAL validation failed: Too many tokens (%2) for %1 program.'
    },
    FragmentShaderType: {
      code: 3630,
      message: 'Fragment shader type is not fragment.'
    },
    VertexShaderType: {
      code: 3631,
      message: 'Vertex shader type is not vertex.'
    },
    VaryingReadButNotWrittenTo: {
      code: 3632,
      message: 'AGAL linkage: Varying %1 is read in the fragment shader but not written to by the vertex shader.'
    },
    VaryingPartialWrite: {
      code: 3633,
      message: 'AGAL linkage: Varying %1 is only partially written to. Must write all four components.'
    },
    FragmentWriteAllComponents: {
      code: 3634,
      message: 'AGAL linkage: Fragment output needs to write to all components.'
    },
    VertexWriteAllComponents: {
      code: 3635,
      message: 'AGAL linkage: Vertex output needs to write to all components.'
    },
    UnusedOperand: {
      code: 3636,
      message: 'AGAL validation failed: Unused operand is not set to zero for %2 at token %3 of %1 program.'
    },
    SamplerRegisterOnlyInFragment: {
      code: 3637,
      message: 'AGAL validation failed: Sampler registers only allowed in fragment programs for %2 at token %3 of %1 program.'
    },
    SamplerRegisterSecondOperand: {
      code: 3638,
      message: 'AGAL validation failed: Sampler register only allowed as second operand in texture instructions for %2 at token %3 of %1 program.'
    },
    IndirectOnlyAllowedInVertex: {
      code: 3639,
      message: 'AGAL validation failed: Indirect addressing only allowed in vertex programs for %2 at token %3 of %1 program.'
    },
    IndirectOnlyIntoConstantRegisters: {
      code: 3640,
      message: 'AGAL validation failed: Indirect addressing only allowed into constant registers for %2 at token %3 of %1 program.'
    },
    IndirectNotAllowed: {
      code: 3641,
      message: 'AGAL validation failed: Indirect addressing not allowed for this operand in this instruction for %2 at token %3 of %1 program.'
    },
    IndirectSourceType: {
      code: 3642,
      message: 'AGAL validation failed: Indirect source type must be attribute, constant or temporary for %2 at token %3 of %1 program.'
    },
    IndirectAddressingFieldsMustBeZero: {
      code: 3643,
      message: 'AGAL validation failed: Indirect addressing fields must be zero for direct adressing for %2 at token %3 of %1 program.'
    },
    VaryingRegistersOnlyReadInFragment: {
      code: 3644,
      message: 'AGAL validation failed: Varying registers can only be read in fragment programs for %2 at token %3 of %1 program.'
    },
    AttributeRegistersOnlyReadInVertex: {
      code: 3645,
      message: 'AGAL validation failed: Attribute registers can only be read in vertex programs for %2 at token %3 of %1 program.'
    },
    CanNotReadOutputRegister: {
      code: 3646,
      message: 'AGAL validation failed: Can not read from output register for %2 at token %3 of %1 program.'
    },
    TempRegisterReadWithoutWrite: {
      code: 3647,
      message: 'AGAL validation failed: Temporary register read without being written to for %2 at token %3 of %1 program.'
    },
    TempRegisterComponentReadWithoutWrite: {
      code: 3648,
      message: 'AGAL validation failed: Temporary register component read without being written to for %2 at token %3 of %1 program.'
    },
    SamplerRegisterCannotBeWrittenTo: {
      code: 3649,
      message: 'AGAL validation failed: Sampler registers can not be written to for %2 at token %3 of %1 program.'
    },
    VaryingRegistersWrite: {
      code: 3650,
      message: 'AGAL validation failed: Varying registers can only be written in vertex programs for %2 at token %3 of %1 program.'
    },
    AttributeRegisterCannotBeWrittenTo: {
      code: 3651,
      message: 'AGAL validation failed: Attribute registers can not be written to for %2 at token %3 of %1 program.'
    },
    ConstantRegisterCannotBeWrittenTo: {
      code: 3652,
      message: 'AGAL validation failed: Constant registers can not be written to for %2 at token %3 of %1 program.'
    },
    DestinationWritemaskIsZero: {
      code: 3653,
      message: 'AGAL validation failed: Destination writemask is zero for %2 at token %3 of %1 program.'
    },
    AGALReservedBitsShouldBeZero: {
      code: 3654,
      message: 'AGAL validation failed: Reserve bits should be zero for %2 at token %3 of %1 program.'
    },
    UnknownRegisterType: {
      code: 3655,
      message: 'AGAL validation failed: Unknown register type for %2 at token %3 of %1 program.'
    },
    SamplerRegisterOutOfBounds: {
      code: 3656,
      message: 'AGAL validation failed: Sampler register index out of bounds for %2 at token %3 of %1 program.'
    },
    VaryingRegisterOutOfBounds: {
      code: 3657,
      message: 'AGAL validation failed: Varying register index out of bounds for %2 at token %3 of %1 program.'
    },
    AttributeRegisterOutOfBounds: {
      code: 3658,
      message: 'AGAL validation failed: Attribute register index out of bounds for %2 at token %3 of %1 program.'
    },
    ConstantRegisterOutOfBounds: {
      code: 3659,
      message: 'AGAL validation failed: Constant register index out of bounds for %2 at token %3 of %1 program.'
    },
    OutputRegisterOutOfBounds: {
      code: 3660,
      message: 'AGAL validation failed: Output register index out of bounds for %2 at token %3 of %1 program.'
    },
    TemporaryRegisterOutOfBounds: {
      code: 3661,
      message: 'AGAL validation failed: Temporary register index out of bounds for %2 at token %3 of %1 program.'
    },
    CubeMapSamplerMustUseClamp: {
      code: 3662,
      message: 'AGAL validation failed: Cube map samplers must set wrapping to clamp mode for %2 at token %3 of %1 program.'
    },
    SampleBindsUndefinedTexture: {
      code: 3663,
      message: 'Sampler %1 binds an undefined texture.'
    },
    UnknownSamplerDimension: {
      code: 3664,
      message: 'AGAL validation failed: Unknown sampler dimension %4 for %2 at token %3 of %1 program.'
    },
    UnknownFilterMode: {
      code: 3665,
      message: 'AGAL validation failed: Unknown filter mode in sampler: %4 for %2 at token %3 of %1 program.'
    },
    UnknownMipmapMode: {
      code: 3666,
      message: 'AGAL validation failed: Unknown mipmap mode in sampler: %4 for %2 at token %3 of %1 program.'
    },
    UnknownWrappingMode: {
      code: 3667,
      message: 'AGAL validation failed: Unknown wrapping mode in sampler: %4 for %2 at token %3 of %1 program.'
    },
    UnknownSpecialFlag: {
      code: 3668,
      message: 'AGAL validation failed: Unknown special flag used in sampler: %4 for %2 at token %3 of %1 program.'
    },
    BadInputSize: {
      code: 3669,
      message: 'Bad input size.'
    },
    BufferTooBig: {
      code: 3670,
      message: 'Buffer too big.'
    },
    BufferHasZeroSize: {
      code: 3671,
      message: 'Buffer has zero size.'
    },
    BufferCreationFailed: {
      code: 3672,
      message: 'Buffer creation failed. Internal error.'
    },
    InvalidCubeSide: {
      code: 3673,
      message: 'Cube side must be [0..5].'
    },
    MiplevelTooLarge: {
      code: 3674,
      message: 'Miplevel too large.'
    },
    TextureFormatMismatch: {
      code: 3675,
      message: 'Texture format mismatch.'
    },
    PlatformDoesNotSupportTextureFormat: {
      code: 3676,
      message: 'Platform does not support desired texture format.'
    },
    TextureDecodingFailed: {
      code: 3677,
      message: 'Texture decoding failed. Internal error.'
    },
    TextureNeedsToBeSquare: {
      code: 3678,
      message: 'Texture needs to be square.'
    },
    TextureSizeDoesNotMatch: {
      code: 3679,
      message: 'Texture size does not match.'
    },
    DepthTextureNotImplemented: {
      code: 3680,
      message: 'Depth texture not implemented yet.'
    },
    TextureSizeIsZero: {
      code: 3681,
      message: 'Texture size is zero.'
    },
    TextureNotPowerOfTwo: {
      code: 3682,
      message: 'Texture size not a power of two.'
    },
    TextureTooBig: {
      code: 3683,
      message: 'Texture too big (max is 2048x2048).'
    },
    TextureCreationFailed: {
      code: 3684,
      message: 'Texture creation failed. Internal error.'
    },
    CouldNotCreateRenderer: {
      code: 3685,
      message: 'Could not create renderer.'
    },
    DisabledFormatNeedsNullVertexBuffer: {
      code: 3686,
      message: '\'disabled\' format only valid with a null vertex buffer.'
    },
    NullVertexBufferNeedsDisabledFormat: {
      code: 3687,
      message: 'Null vertex buffers require the \'disabled\' format.'
    },
    NeedListenerToRequestContext: {
      code: 3688,
      message: 'You must add an event listener for the context3DCreate event before requesting a new Context3D.'
    },
    CantSwizzle2ndSource: {
      code: 3689,
      message: 'You can not swizzle second operand for %2 at token %3 of %1 program.'
    },
    TooManyDrawCalls: {
      code: 3690,
      message: 'Too many draw calls before calling present.'
    },
    ResourceLimitExceeded: {
      code: 3691,
      message: 'Resource limit for this resource type exceeded.'
    },
    NeedToClearBeforeDraw: {
      code: 3692,
      message: 'All buffers need to be cleared every frame before drawing.'
    },
    SecondOperandMustBeSamplerRegister: {
      code: 3693,
      message: 'AGAL validation failed: Sampler register must be used for second operand in texture instructions for %2 at token %3 of %1 program.'
    },
    ObjectDisposed: {
      code: 3694,
      message: 'The object was disposed by an earlier call of dispose() on it.'
    },
    SameTextureNeedsSameSamplerParams: {
      code: 3695,
      message: 'A texture can only be bound to multiple samplers if the samplers also have the exact same properties. Mismatch at samplers %1 and %2.'
    },
    SecondUseOfSamplerMustHaveSameParams: {
      code: 3696,
      message: 'AGAL validation failed: Second use of sampler register needs to specify the exact same properties. At token %3 of %1 program.'
    },
    TextureBoundButNotUsed: {
      code: 3697,
      message: 'A texture is bound on sampler %1 but not used by the fragment program.'
    },
    BackBufferNotConfigured: {
      code: 3698,
      message: 'The back buffer is not configured.'
    },
    OperationFailed: {
      code: 3699,
      message: 'Requested Operation failed to complete'
    },
    TextureMipchainIsNotComplete: {
      code: 3700,
      message: 'A texture sampler binds an incomplete texture. Make sure to upload(). All miplevels are required when mipmapping is enabled.'
    },
    OutputColorNotMaskable: {
      code: 3701,
      message: 'The output color register can not use a write mask. All components must be written.'
    },
    Context3DNotAvailable: {
      code: 3702,
      message: 'Context3D not available.'
    },
    SwizzleMustBeScalar: {
      code: 3703,
      message: 'AGAL validation failed: Source swizzle must be scalar (one of: xxxx, yyyy, zzzz, wwww) for %2 at token %3 of %1 program.'
    },
    CubeMapSamplerMustUseMipmap: {
      code: 3704,
      message: 'AGAL validation failed: Cube map samplers must enable mipmapping for %2 at token %3 of %1 program.'
    }
  };
function getErrorMessage(index) {
  if (!debuggerMode.value) {
    return 'Error #' + index;
  }
  for (var k in Errors) {
    if (Errors[k].code == index) {
      return 'Error #' + index + ': ' + Errors[k].message;
    }
  }
}
function formatErrorMessage(error) {
  var message = error.message;
  Array.prototype.slice.call(arguments, 1).forEach(function (x, i) {
    message = message.replace('%' + (i + 1), x);
  });
  return 'Error #' + error.code + ': ' + message;
}
function translateErrorMessage(error) {
  if (error.type) {
    switch (error.type) {
    case 'undefined_method':
      return formatErrorMessage(Errors.CallOfNonFunctionError, 'value');
    default:
      throw notImplemented(error.type);
    }
  } else {
    if (error.message.indexOf('is not a function') >= 0) {
      return formatErrorMessage(Errors.CallOfNonFunctionError, 'value');
    }
    return error.message;
  }
}
var opcodeTable = [
    null,
    {
      name: 'bkpt',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'nop',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'throw',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'getsuper',
      operands: 'index:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'setsuper',
      operands: 'index:u30',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'dxns',
      operands: 'index:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'dxnslate',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'kill',
      operands: 'index:u30',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'label',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'lf32x4',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'sf32x4',
      operands: '',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'ifnlt',
      operands: 'offset:s24',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'ifnle',
      operands: 'offset:s24',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'ifngt',
      operands: 'offset:s24',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'ifnge',
      operands: 'offset:s24',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'jump',
      operands: 'offset:s24',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'iftrue',
      operands: 'offset:s24',
      canThrow: false,
      stackDelta: -1
    },
    {
      name: 'iffalse',
      operands: 'offset:s24',
      canThrow: false,
      stackDelta: -1
    },
    {
      name: 'ifeq',
      operands: 'offset:s24',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'ifne',
      operands: 'offset:s24',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'iflt',
      operands: 'offset:s24',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'ifle',
      operands: 'offset:s24',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'ifgt',
      operands: 'offset:s24',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'ifge',
      operands: 'offset:s24',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'ifstricteq',
      operands: 'offset:s24',
      canThrow: false,
      stackDelta: -2
    },
    {
      name: 'ifstrictne',
      operands: 'offset:s24',
      canThrow: false,
      stackDelta: -2
    },
    {
      name: 'lookupswitch',
      operands: null,
      canThrow: false,
      stackDelta: -1
    },
    {
      name: 'pushwith',
      operands: '',
      canThrow: false,
      stackDelta: -1
    },
    {
      name: 'popscope',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'nextname',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'hasnext',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'pushnull',
      operands: '',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'pushundefined',
      operands: '',
      canThrow: false,
      stackDelta: 1
    },
    null,
    {
      name: 'nextvalue',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'pushbyte',
      operands: 'value:s08',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'pushshort',
      operands: 'value:s16',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'pushtrue',
      operands: '',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'pushfalse',
      operands: '',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'pushnan',
      operands: '',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'pop',
      operands: '',
      canThrow: false,
      stackDelta: -1
    },
    {
      name: 'dup',
      operands: '',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'swap',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'pushstring',
      operands: 'index:u30S',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'pushint',
      operands: 'index:u30I',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'pushuint',
      operands: 'index:u30U',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'pushdouble',
      operands: 'index:u30D',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'pushscope',
      operands: '',
      canThrow: false,
      stackDelta: -1
    },
    {
      name: 'pushnamespace',
      operands: 'index:u30N',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'hasnext2',
      operands: 'object:u30,index:u30',
      canThrow: true,
      stackDelta: 1
    },
    {
      name: 'lix8',
      operands: null,
      canThrow: true,
      stackDelta: 0,
      internal: true
    },
    {
      name: 'lix16',
      operands: null,
      canThrow: true,
      stackDelta: 0,
      internal: true
    },
    {
      name: 'li8',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'li16',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'li32',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'lf32',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'lf64',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'si8',
      operands: '',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'si16',
      operands: '',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'si32',
      operands: '',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'sf32',
      operands: '',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'sf64',
      operands: '',
      canThrow: true,
      stackDelta: -2
    },
    null,
    {
      name: 'newfunction',
      operands: 'index:u30MI',
      canThrow: true,
      stackDelta: 1
    },
    {
      name: 'call',
      operands: 'argCount:u30',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'construct',
      operands: 'argCount:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'callmethod',
      operands: 'index:u30,argCount:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'callstatic',
      operands: 'index:u30MI,argCount:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'callsuper',
      operands: 'index:u30M,argCount:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'callproperty',
      operands: 'index:u30M,argCount:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'returnvoid',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'returnvalue',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'constructsuper',
      operands: 'argCount:u30',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'constructprop',
      operands: 'index:u30M,argCount:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'callsuperid',
      operands: null,
      canThrow: true,
      stackDelta: 0,
      internal: true
    },
    {
      name: 'callproplex',
      operands: 'index:u30M,argCount:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'callinterface',
      operands: null,
      canThrow: true,
      stackDelta: 0,
      internal: true
    },
    {
      name: 'callsupervoid',
      operands: 'index:u30M,argCount:u30',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'callpropvoid',
      operands: 'index:u30M,argCount:u30',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'sxi1',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'sxi8',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'sxi16',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'applytype',
      operands: 'argCount:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'pushfloat4',
      operands: null,
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'newobject',
      operands: 'argCount:u30',
      canThrow: true,
      stackDelta: 1
    },
    {
      name: 'newarray',
      operands: 'argCount:u30',
      canThrow: true,
      stackDelta: 1
    },
    {
      name: 'newactivation',
      operands: '',
      canThrow: true,
      stackDelta: 1
    },
    {
      name: 'newclass',
      operands: 'index:u30CI',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'getdescendants',
      operands: 'index:u30M',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'newcatch',
      operands: 'index:u30EI',
      canThrow: true,
      stackDelta: 1
    },
    {
      name: 'findpropglobalstrict',
      operands: null,
      canThrow: true,
      stackDelta: 0,
      internal: true
    },
    {
      name: 'findpropglobal',
      operands: null,
      canThrow: true,
      stackDelta: 0,
      internal: true
    },
    {
      name: 'findpropstrict',
      operands: 'index:u30M',
      canThrow: true,
      stackDelta: 1
    },
    {
      name: 'findproperty',
      operands: 'index:u30M',
      canThrow: true,
      stackDelta: 1
    },
    {
      name: 'finddef',
      operands: null,
      canThrow: true,
      stackDelta: 1
    },
    {
      name: 'getlex',
      operands: 'index:u30M',
      canThrow: true,
      stackDelta: 1
    },
    {
      name: 'setproperty',
      operands: 'index:u30M',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'getlocal',
      operands: 'index:u30',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'setlocal',
      operands: 'index:u30',
      canThrow: false,
      stackDelta: -1
    },
    {
      name: 'getglobalscope',
      operands: '',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'getscopeobject',
      operands: 'index:u30',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'getproperty',
      operands: 'index:u30M',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'getouterscope',
      operands: null,
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'initproperty',
      operands: 'index:u30M',
      canThrow: true,
      stackDelta: -2
    },
    null,
    {
      name: 'deleteproperty',
      operands: 'index:u30M',
      canThrow: true,
      stackDelta: 0
    },
    null,
    {
      name: 'getslot',
      operands: 'index:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'setslot',
      operands: 'index:u30',
      canThrow: true,
      stackDelta: -2
    },
    {
      name: 'getglobalslot',
      operands: 'index:u30',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'setglobalslot',
      operands: 'index:u30',
      canThrow: false,
      stackDelta: -1
    },
    {
      name: 'convert_s',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'esc_xelem',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'esc_xattr',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'convert_i',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'convert_u',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'convert_d',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'convert_b',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'convert_o',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'checkfilter',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'convert_f',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'unplus',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'convert_f4',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    null,
    null,
    null,
    null,
    {
      name: 'coerce',
      operands: 'index:u30M',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'coerce_b',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'coerce_a',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'coerce_i',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'coerce_d',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'coerce_s',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'astype',
      operands: 'index:u30M',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'astypelate',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'coerce_u',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'coerce_o',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    null,
    null,
    null,
    null,
    null,
    null,
    {
      name: 'negate',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'increment',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'inclocal',
      operands: 'index:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'decrement',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'declocal',
      operands: 'index:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'typeof',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'not',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    {
      name: 'bitnot',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    {
      name: 'add',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'subtract',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'multiply',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'divide',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'modulo',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'lshift',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'rshift',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'urshift',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'bitand',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'bitor',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'bitxor',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'equals',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'strictequals',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'lessthan',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'lessequals',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'greaterthan',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'greaterequals',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'instanceof',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'istype',
      operands: 'index:u30M',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'istypelate',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'in',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    {
      name: 'increment_i',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'decrement_i',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'inclocal_i',
      operands: 'index:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'declocal_i',
      operands: 'index:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'negate_i',
      operands: '',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'add_i',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'subtract_i',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    {
      name: 'multiply_i',
      operands: '',
      canThrow: true,
      stackDelta: -1
    },
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    {
      name: 'getlocal0',
      operands: '',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'getlocal1',
      operands: '',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'getlocal2',
      operands: '',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'getlocal3',
      operands: '',
      canThrow: false,
      stackDelta: 1
    },
    {
      name: 'setlocal0',
      operands: '',
      canThrow: false,
      stackDelta: -1
    },
    {
      name: 'setlocal1',
      operands: '',
      canThrow: false,
      stackDelta: -1
    },
    {
      name: 'setlocal2',
      operands: '',
      canThrow: false,
      stackDelta: -1
    },
    {
      name: 'setlocal3',
      operands: '',
      canThrow: false,
      stackDelta: -1
    },
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    {
      name: 'invalid',
      operands: '',
      canThrow: false,
      stackDelta: 0
    },
    null,
    {
      name: 'debug',
      operands: 'debugType:u08,index:u30S,reg:u08,extra:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'debugline',
      operands: 'lineNumber:u30',
      canThrow: true,
      stackDelta: 0
    },
    {
      name: 'debugfile',
      operands: 'index:u30S',
      canThrow: true,
      stackDelta: 0
    },
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null,
    null
  ];
(function processOpcodeTable() {
  function splitter(value) {
    var list = value.split(':');
    return {
      name: list[0],
      size: list[1].substring(0, 3),
      type: list[1].substring(3)
    };
  }
  for (var i = 0; i < opcodeTable.length; i++) {
    var entry = opcodeTable[i];
    if (entry && entry.operands !== null) {
      if (entry.operands === '') {
        entry.operands = [];
      } else {
        entry.operands = entry.operands.split(',').map(splitter);
      }
    }
  }
}());
function opcodeName(op) {
  return opcodeTable[op].name;
}
var AbcStream = function () {
    function abcStream(bytes) {
      this.bytes = bytes;
      this.view = new DataView(bytes.buffer, bytes.byteOffset);
      this.pos = 0;
    }
    var resultBuffer = new Int32Array(256);
    abcStream.prototype = {
      get position() {
        return this.pos;
      },
      remaining: function () {
        return this.bytes.length - this.pos;
      },
      seek: function (pos) {
        this.pos = pos;
      },
      readU8: function () {
        return this.bytes[this.pos++];
      },
      readU8s: function (count) {
        var b = new Uint8Array(count);
        b.set(this.bytes.subarray(this.pos, this.pos + count), 0);
        this.pos += count;
        return b;
      },
      readS8: function () {
        return this.bytes[this.pos++] << 24 >> 24;
      },
      readU32: function () {
        return this.readS32() >>> 0;
      },
      readU30: function () {
        var result = this.readU32();
        if (result & 3221225472) {
          return result;
        }
        return result;
      },
      readU30Unsafe: function () {
        return this.readU32();
      },
      readS16: function () {
        return this.readU30Unsafe() << 16 >> 16;
      },
      readS32: function () {
        var result = this.readU8();
        if (result & 128) {
          result = result & 127 | this.readU8() << 7;
          if (result & 16384) {
            result = result & 16383 | this.readU8() << 14;
            if (result & 2097152) {
              result = result & 2097151 | this.readU8() << 21;
              if (result & 268435456) {
                result = result & 268435455 | this.readU8() << 28;
                result = result & 4294967295;
              }
            }
          }
        }
        return result;
      },
      readWord: function () {
        var result = this.view.getUint32(this.pos, true);
        this.pos += 4;
        return result;
      },
      readS24: function () {
        var u = this.readU8() | this.readU8() << 8 | this.readU8() << 16;
        return u << 8 >> 8;
      },
      readDouble: function () {
        var result = this.view.getFloat64(this.pos, true);
        this.pos += 8;
        return result;
      },
      readUTFString: function (length) {
        var pos = this.pos;
        var end = pos + length;
        var bytes = this.bytes;
        var i = 0;
        if (!resultBuffer || resultBuffer.length < length) {
          resultBuffer = new Int32Array(length * 2);
        }
        var result = resultBuffer;
        while (pos < end) {
          var c = bytes[pos++];
          if (c <= 127) {
            result[i++] = c;
          } else if (c >= 192) {
            var code = 0;
            if (c < 224) {
              code = (c & 31) << 6 | bytes[pos++] & 63;
            } else if (c < 240) {
              code = (c & 15) << 12 | (bytes[pos++] & 63) << 6 | bytes[pos++] & 63;
            } else {
              code = ((c & 7) << 18 | (bytes[pos++] & 63) << 12 | (bytes[pos++] & 63) << 6 | bytes[pos++] & 63) - 65536;
              result[i++] = ((code & 1047552) >>> 10) + 55296;
              code = (code & 1023) + 56320;
            }
            result[i++] = code;
          }
        }
        this.pos = pos;
        return fromCharCodeArray(result.subarray(0, i));
      }
    };
    if (typeof TextDecoder !== 'undefined') {
      var decoder = new TextDecoder();
      abcStream.prototype.readUTFString = function (length) {
        var pos = this.pos;
        this.pos += length;
        return decoder.decode(this.bytes.subarray(pos, pos + length));
      };
    }
    return abcStream;
  }();
function parseTraits(abc, stream, holder) {
  var count = stream.readU30();
  var traits = [];
  for (var i = 0; i < count; i++) {
    traits.push(new Trait(abc, stream, holder));
  }
  return traits;
}
var Trait = function () {
    function trait(abc, stream, holder) {
      var constantPool = abc.constantPool;
      var methods = abc.methods;
      var classes = abc.classes;
      var metadata = abc.metadata;
      this.holder = holder;
      this.name = constantPool.multinames[stream.readU30()];
      var tag = stream.readU8();
      this.kind = tag & 15;
      this.attributes = tag >> 4 & 15;
      true;
      switch (this.kind) {
      case TRAIT_Slot:
      case TRAIT_Const:
        this.slotId = stream.readU30();
        this.typeName = constantPool.multinames[stream.readU30()];
        var valueIndex = stream.readU30();
        this.value = undefined;
        if (valueIndex !== 0) {
          this.hasDefaultValue = true;
          this.value = constantPool.getValue(stream.readU8(), valueIndex);
        }
        break;
      case TRAIT_Method:
      case TRAIT_Setter:
      case TRAIT_Getter:
        this.dispId = stream.readU30();
        this.methodInfo = methods[stream.readU30()];
        this.methodInfo.name = this.name;
        attachHolder(this.methodInfo, this.holder);
        this.methodInfo.abc = abc;
        break;
      case TRAIT_Class:
        this.slotId = stream.readU30();
        true;
        this.classInfo = classes[stream.readU30()];
        break;
      case TRAIT_Function:
        true;
        break;
      }
      if (this.attributes & ATTR_Metadata) {
        var traitMetadata;
        for (var i = 0, j = stream.readU30(); i < j; i++) {
          var md = metadata[stream.readU30()];
          if (md.name === '__go_to_definition_help' || md.name === '__go_to_ctor_definition_help') {
            continue;
          }
          if (!traitMetadata) {
            traitMetadata = {};
          }
          traitMetadata[md.name] = md;
        }
        if (traitMetadata) {
          if (this.isClass()) {
            this.classInfo.metadata = traitMetadata;
          }
          this.metadata = traitMetadata;
        }
      }
    }
    trait.prototype.isSlot = function isSlot() {
      return this.kind === TRAIT_Slot;
    };
    trait.prototype.isConst = function isConst() {
      return this.kind === TRAIT_Const;
    };
    trait.prototype.isMethod = function isMethod() {
      return this.kind === TRAIT_Method;
    };
    trait.prototype.isClass = function isClass() {
      return this.kind === TRAIT_Class;
    };
    trait.prototype.isGetter = function isGetter() {
      return this.kind === TRAIT_Getter;
    };
    trait.prototype.isSetter = function isSetter() {
      return this.kind === TRAIT_Setter;
    };
    trait.prototype.isProtected = function isProtected() {
      true;
      return this.name.namespaces[0].isProtected();
    };
    trait.prototype.kindName = function kindName() {
      switch (this.kind) {
      case TRAIT_Slot:
        return 'Slot';
      case TRAIT_Const:
        return 'Const';
      case TRAIT_Method:
        return 'Method';
      case TRAIT_Setter:
        return 'Setter';
      case TRAIT_Getter:
        return 'Getter';
      case TRAIT_Class:
        return 'Class';
      case TRAIT_Function:
        return 'Function';
      }
      unexpected();
    };
    trait.prototype.isOverride = function isOverride() {
      return this.attributes & ATTR_Override;
    };
    trait.prototype.isFinal = function isFinal() {
      return this.attributes & ATTR_Final;
    };
    trait.prototype.toString = function toString() {
      var str = getFlags(this.attributes, 'final|override|metadata'.split('|'));
      if (str) {
        str += ' ';
      }
      str += Multiname.getQualifiedName(this.name);
      switch (this.kind) {
      case TRAIT_Slot:
      case TRAIT_Const:
        return str + ', typeName: ' + this.typeName + ', slotId: ' + this.slotId + ', value: ' + this.value;
      case TRAIT_Method:
      case TRAIT_Setter:
      case TRAIT_Getter:
        return str + ', ' + this.kindName() + ': ' + this.methodInfo.name;
      case TRAIT_Class:
        return str + ', slotId: ' + this.slotId + ', class: ' + this.classInfo;
      case TRAIT_Function:
        break;
      }
    };
    return trait;
  }();
var ShumwayNamespace = function () {
    var kinds = {};
    kinds[CONSTANT_Namespace] = 'public';
    kinds[CONSTANT_PackageNamespace] = 'public';
    kinds[CONSTANT_PackageInternalNs] = 'packageInternal';
    kinds[CONSTANT_PrivateNs] = 'private';
    kinds[CONSTANT_ProtectedNamespace] = 'protected';
    kinds[CONSTANT_ExplicitNamespace] = 'explicit';
    kinds[CONSTANT_StaticProtectedNs] = 'staticProtected';
    var prefixes = {};
    for (var k in kinds) {
      prefixes[kinds[k]] = true;
    }
    var MIN_API_MARK = 58004;
    var MAX_API_MARK = 63743;
    function namespace(kind, uri, prefix, dontMangle) {
      if (kind !== undefined) {
        if (uri === undefined) {
          uri = '';
        }
        if (prefix !== undefined) {
          this.prefix = prefix;
        }
        this.kind = kind;
        this.originalURI = this.uri = uri;
        buildNamespace.call(this, dontMangle);
      }
    }
    namespace.PREFIXES = prefixes;
    var uniqueNamespaceCounter = 0;
    function buildNamespace(dontMangle) {
      if (this.isPublic() && this.uri) {
        var n = this.uri.length - 1;
        var mark = this.uri.charCodeAt(n);
        if (mark > MIN_API_MARK) {
          this.uri = this.uri.substring(0, n - 1);
        }
      } else if (this.isUnique()) {
        this.uri = String(this.uri + uniqueNamespaceCounter++);
      }
      this.uri = dontMangle ? this.uri : mangleNamespaceURI(this.uri);
      true;
      this.qualifiedName = kinds[this.kind] + '$' + this.uri;
    }
    function escapeUri(uri) {
      if (uri !== undefined) {
        uri = uri.replace(/[^\w]/g, '_');
      }
      return uri;
    }
    var uriToMangledNameMap = createEmptyObject();
    var mangledNameToURIMap = createEmptyObject();
    var mangledNameList = [];
    var MANGLE_NAMESPACES = true;
    function mangleNamespaceURI(uri) {
      if (uri === '') {
        return '';
      }
      var name = uriToMangledNameMap[uri];
      if (name) {
        return name;
      }
      if (!MANGLE_NAMESPACES) {
        name = escapeUri(uri);
        mangledNameToURIMap[name] = uri;
      } else {
        name = String(mangledNameList.length);
        mangledNameList.push(name);
      }
      uriToMangledNameMap[uri] = name;
      return name;
    }
    namespace.fromQualifiedName = function fromQualifiedName(qn) {
      var a = qn.indexOf('$');
      var b = qn.indexOf('$', a + 1);
      var str = qn.substring(0, a);
      var kind = namespace.kindFromString(str);
      str = qn.substring(a + 1, b);
      var uri = str === '' ? str : MANGLE_NAMESPACES ? mangledNameList[Number(str)] : mangledNameToURIMap[str];
      true;
      true;
      return new namespace(kind, uri, undefined, true);
    };
    namespace.kindFromString = function kindFromString(str) {
      for (var kind in kinds) {
        if (kinds[kind] === str) {
          return kind;
        }
      }
      return true;
    };
    namespace.createNamespace = function createNamespace(uri, prefix) {
      return new namespace(CONSTANT_Namespace, uri, prefix);
    };
    namespace.prototype = Object.create({
      parse: function parse(constantPool, stream) {
        this.kind = stream.readU8();
        this.originalURI = this.uri = constantPool.strings[stream.readU30()];
        buildNamespace.call(this);
      },
      isPublic: function isPublic() {
        return this.kind === CONSTANT_Namespace || this.kind === CONSTANT_PackageNamespace;
      },
      isProtected: function isProtected() {
        return this.kind === CONSTANT_ProtectedNamespace;
      },
      isUnique: function isUnique() {
        return this.kind === CONSTANT_PrivateNs && !this.originalURI;
      },
      isDynamic: function isDynamic() {
        return this.isPublic() && !this.uri;
      },
      getURI: function getURI() {
        return this.uri;
      },
      toString: function toString() {
        return kinds[this.kind] + (this.originalURI ? ' ' + this.originalURI : '');
      },
      clone: function clone() {
        var c = new namespace();
        c.kind = this.kind;
        c.uri = this.uri;
        c.originalURI = this.originalURI;
        c.qualifiedName = this.qualifiedName;
        return c;
      },
      isEqualTo: function isEqualTo(o) {
        return this.qualifiedName === o.qualifiedName;
      },
      inNamespaceSet: function inNamespaceSet(set) {
        for (var i = 0; i < set.length; i++) {
          if (set[i].qualifiedName === this.qualifiedName) {
            return true;
          }
        }
        return false;
      },
      getAccessModifier: function getAccessModifier() {
        return kinds[this.kind];
      },
      getQualifiedName: function getQualifiedName() {
        return this.qualifiedName;
      }
    });
    namespace.PUBLIC = new namespace(CONSTANT_Namespace);
    namespace.PROTECTED = new namespace(CONSTANT_ProtectedNamespace);
    namespace.PROXY = new namespace(CONSTANT_Namespace, 'http://www.adobe.com/2006/actionscript/flash/proxy');
    var simpleNameCache = {};
    namespace.fromSimpleName = function fromSimpleName(simpleName) {
      if (simpleName in simpleNameCache) {
        return simpleNameCache[simpleName];
      }
      var namespaceNames;
      if (simpleName.indexOf('[') === 0) {
        true;
        namespaceNames = simpleName.substring(1, simpleName.length - 1).split(',');
      } else {
        namespaceNames = [
          simpleName
        ];
      }
      return simpleNameCache[simpleName] = namespaceNames.map(function (name) {
        name = name.trim();
        var kindName, uri;
        if (name.indexOf(' ') > 0) {
          kindName = name.substring(0, name.indexOf(' ')).trim();
          uri = name.substring(name.indexOf(' ') + 1).trim();
        } else {
          if (name === kinds[CONSTANT_Namespace] || name === kinds[CONSTANT_PackageInternalNs] || name === kinds[CONSTANT_PrivateNs] || name === kinds[CONSTANT_ProtectedNamespace] || name === kinds[CONSTANT_ExplicitNamespace] || name === kinds[CONSTANT_StaticProtectedNs]) {
            kindName = name;
            uri = '';
          } else {
            kindName = 'public';
            uri = name;
          }
        }
        return new namespace(namespace.kindFromString(kindName), uri);
      });
    };
    return namespace;
  }();
var Multiname = function () {
    var ATTRIBUTE = 1;
    var RUNTIME_NAMESPACE = 2;
    var RUNTIME_NAME = 4;
    var nextID = 0;
    var PUBLIC_QUALIFIED_NAME_PREFIX = 'public$$';
    function multiname(namespaces, name, flags) {
      if (name !== undefined) {
        true;
      }
      this.id = nextID++;
      this.namespaces = namespaces;
      this.name = name;
      this.flags = flags || 0;
    }
    multiname.TEMPORARY = new multiname();
    true;
    multiname.RUNTIME_NAME = RUNTIME_NAME;
    multiname.ATTRIBUTE = ATTRIBUTE;
    multiname.parse = function parse(constantPool, stream, multinames, patchFactoryTypes) {
      var index = 0;
      var kind = stream.readU8();
      var name, namespaces = [], flags = 0, typeParameter;
      switch (kind) {
      case CONSTANT_QName:
      case CONSTANT_QNameA:
        index = stream.readU30();
        if (index) {
          namespaces = [
            constantPool.namespaces[index]
          ];
        } else {
          flags &= ~RUNTIME_NAME;
        }
        index = stream.readU30();
        if (index) {
          name = constantPool.strings[index];
        }
        break;
      case CONSTANT_RTQName:
      case CONSTANT_RTQNameA:
        index = stream.readU30();
        if (index) {
          name = constantPool.strings[index];
        } else {
          flags &= ~RUNTIME_NAME;
        }
        flags |= RUNTIME_NAMESPACE;
        break;
      case CONSTANT_RTQNameL:
      case CONSTANT_RTQNameLA:
        flags |= RUNTIME_NAMESPACE;
        flags |= RUNTIME_NAME;
        break;
      case CONSTANT_Multiname:
      case CONSTANT_MultinameA:
        index = stream.readU30();
        if (index) {
          name = constantPool.strings[index];
        } else {
          flags &= ~RUNTIME_NAME;
        }
        index = stream.readU30();
        true;
        namespaces = constantPool.namespaceSets[index];
        break;
      case CONSTANT_MultinameL:
      case CONSTANT_MultinameLA:
        flags |= RUNTIME_NAME;
        index = stream.readU30();
        true;
        namespaces = constantPool.namespaceSets[index];
        break;
      case CONSTANT_TypeName:
        var factoryTypeIndex = stream.readU32();
        if (multinames[factoryTypeIndex]) {
          namespaces = multinames[factoryTypeIndex].namespaces;
          name = multinames[factoryTypeIndex].name;
        }
        var typeParameterCount = stream.readU32();
        true;
        var typeParameterIndex = stream.readU32();
        var mn = new Multiname(namespaces, name, flags);
        mn.typeParameter = multinames[typeParameterIndex];
        if (!multinames[factoryTypeIndex]) {
          patchFactoryTypes.push({
            multiname: mn,
            index: factoryTypeIndex
          });
        }
        return mn;
        break;
      default:
        unexpected();
        break;
      }
      switch (kind) {
      case CONSTANT_QNameA:
      case CONSTANT_RTQNameA:
      case CONSTANT_RTQNameLA:
      case CONSTANT_MultinameA:
      case CONSTANT_MultinameLA:
        flags |= ATTRIBUTE;
        break;
      }
      return new Multiname(namespaces, name, flags);
    };
    multiname.isMultiname = function (mn) {
      return typeof mn === 'number' || typeof mn === 'string' || mn instanceof Multiname || mn instanceof Number;
    };
    multiname.needsResolution = function (mn) {
      return mn instanceof multiname && mn.namespaces.length > 1;
    };
    multiname.isQName = function (mn) {
      if (mn instanceof multiname) {
        return mn.namespaces && mn.namespaces.length === 1;
      }
      return true;
    };
    multiname.isRuntimeName = function isRuntimeName(mn) {
      return mn instanceof Multiname && mn.isRuntimeName();
    };
    multiname.isRuntimeNamespace = function isRuntimeNamespace(mn) {
      return mn instanceof Multiname && mn.isRuntimeNamespace();
    };
    multiname.isRuntime = function (mn) {
      return mn instanceof Multiname && mn.isRuntimeName() || mn.isRuntimeNamespace();
    };
    function qualifyNameInternal(qualifier, name) {
      true;
      return qualifier ? qualifier + '$' + name : name;
    }
    multiname.getQualifiedName = function getQualifiedName(mn) {
      true;
      if (mn instanceof Multiname) {
        if (mn.qualifiedName !== undefined) {
          return mn.qualifiedName;
        }
        var name = String(mn.name);
        if (isNumeric(name)) {
          true;
          return mn.qualifiedName = name;
        }
        mn = mn.qualifiedName = qualifyNameInternal(mn.namespaces[0].qualifiedName, name);
      }
      return mn;
    };
    multiname.qualifyName = function qualifyName(namespace, name) {
      return qualifyNameInternal(namespace.qualifiedName, name);
    };
    multiname.stripPublicQualifier = function stripPublicQualifier(qn) {
      var index = qn.indexOf(PUBLIC_QUALIFIED_NAME_PREFIX);
      if (index !== 0) {
        return undefined;
      }
      return qn.substring(PUBLIC_QUALIFIED_NAME_PREFIX.length);
    };
    multiname.fromQualifiedName = function fromQualifiedName(qn) {
      if (qn instanceof Multiname) {
        return qn;
      }
      true;
      var a = qn.indexOf('$');
      if (a < 0 || !ShumwayNamespace.PREFIXES[qn.substring(0, a)]) {
        return undefined;
      }
      var ns = ShumwayNamespace.fromQualifiedName(qn);
      var b = qn.indexOf('$', a + 1);
      return new Multiname([
        ns
      ], qn.substring(b + 1));
    };
    multiname.getFullQualifiedName = function getFullQualifiedName(mn) {
      var qn = multiname.getQualifiedName(mn);
      if (mn instanceof Multiname && mn.typeParameter) {
        qn += '$' + multiname.getFullQualifiedName(mn.typeParameter);
      }
      return qn;
    };
    multiname.PUBLIC_QUALIFIED_NAME_PREFIX = PUBLIC_QUALIFIED_NAME_PREFIX;
    multiname.getPublicQualifiedName = function getPublicQualifiedName(name) {
      if (isNumeric(name)) {
        return toNumber(name);
      } else if (name !== null && isObject(name)) {
        return name;
      }
      return PUBLIC_QUALIFIED_NAME_PREFIX + name;
    };
    multiname.isPublicQualifiedName = function isPublicQualifiedName(qn) {
      return typeof qn === 'number' || isNumeric(qn) || qn.indexOf(PUBLIC_QUALIFIED_NAME_PREFIX) === 0;
    };
    multiname.getAccessModifier = function getAccessModifier(mn) {
      true;
      if (typeof mn === 'number' || typeof mn === 'string' || mn instanceof Number) {
        return 'public';
      }
      true;
      return mn.namespaces[0].getAccessModifier();
    };
    multiname.isNumeric = function (mn) {
      if (typeof mn === 'number') {
        return true;
      } else if (typeof mn === 'string') {
        return isNumeric(mn);
      }
      true;
      return !isNaN(parseInt(multiname.getName(mn), 10));
    };
    multiname.getName = function getName(mn) {
      true;
      true;
      return mn.getName();
    };
    multiname.isAnyName = function isAnyName(mn) {
      return typeof mn === 'object' && !mn.isRuntimeName() && !mn.name;
    };
    var simpleNameCache = {};
    multiname.fromSimpleName = function fromSimpleName(simpleName) {
      true;
      if (simpleName in simpleNameCache) {
        return simpleNameCache[simpleName];
      }
      var nameIndex, namespaceIndex, name, namespace;
      nameIndex = simpleName.lastIndexOf('.');
      if (nameIndex <= 0) {
        nameIndex = simpleName.lastIndexOf(' ');
      }
      if (nameIndex > 0 && nameIndex < simpleName.length - 1) {
        name = simpleName.substring(nameIndex + 1).trim();
        namespace = simpleName.substring(0, nameIndex).trim();
      } else {
        name = simpleName;
        namespace = '';
      }
      return simpleNameCache[simpleName] = new Multiname(ShumwayNamespace.fromSimpleName(namespace), name);
    };
    multiname.prototype.getQName = function getQName(index) {
      true;
      true;
      if (!this.cache) {
        this.cache = [];
      }
      var name = this.cache[index];
      if (!name) {
        name = this.cache[index] = new Multiname([
          this.namespaces[index]
        ], this.name, this.flags);
      }
      return name;
    };
    multiname.prototype.hasQName = function hasQName(qn) {
      true;
      if (this.name !== qn.name) {
        return false;
      }
      for (var i = 0; i < this.namespaces.length; i++) {
        if (this.namespaces[i].isEqualTo(qn.namespaces[0])) {
          return true;
        }
      }
      return false;
    };
    multiname.prototype.isAttribute = function isAttribute() {
      return this.flags & ATTRIBUTE;
    };
    multiname.prototype.isAnyName = function isAnyName() {
      return Multiname.isAnyName(this);
    };
    multiname.prototype.isAnyNamespace = function isAnyNamespace() {
      return !this.isRuntimeNamespace() && (this.namespaces.length === 0 || this.isAnyName() && this.namespaces.length !== 1);
    };
    multiname.prototype.isRuntimeName = function isRuntimeName() {
      return this.flags & RUNTIME_NAME;
    };
    multiname.prototype.isRuntimeNamespace = function isRuntimeNamespace() {
      return this.flags & RUNTIME_NAMESPACE;
    };
    multiname.prototype.isRuntime = function isRuntime() {
      return this.flags & (RUNTIME_NAME | RUNTIME_NAMESPACE);
    };
    multiname.prototype.isQName = function isQName() {
      return this.namespaces.length === 1 && !this.isAnyName();
    };
    multiname.prototype.hasTypeParameter = function hasTypeParameter() {
      return !(!this.typeParameter);
    };
    multiname.prototype.getName = function getName() {
      return this.name;
    };
    multiname.prototype.getOriginalName = function getOriginalName() {
      true;
      var name = this.namespaces[0].originalURI;
      if (name) {
        name += '.';
      }
      return name + this.name;
    };
    multiname.prototype.getNamespace = function getNamespace() {
      true;
      true;
      return this.namespaces[0];
    };
    multiname.prototype.nameToString = function nameToString() {
      if (this.isAnyName()) {
        return '*';
      } else {
        var name = this.getName();
        return this.isRuntimeName() ? '[]' : name;
      }
    };
    multiname.prototype.hasObjectName = function hasObjectName() {
      return typeof this.name === 'object';
    };
    multiname.prototype.toString = function toString() {
      var str = this.isAttribute() ? '@' : '';
      if (this.isAnyNamespace()) {
        str += '*::' + this.nameToString();
      } else if (this.isRuntimeNamespace()) {
        str += '[]::' + this.nameToString();
      } else if (this.namespaces.length === 1 && this.isQName()) {
        str += this.namespaces[0].toString() + '::';
        str += this.nameToString();
      } else {
        str += '{';
        for (var i = 0, count = this.namespaces.length; i < count; i++) {
          str += this.namespaces[i].toString();
          if (i + 1 < count) {
            str += ',';
          }
        }
        str += '}::' + this.nameToString();
      }
      if (this.hasTypeParameter()) {
        str += '<' + this.typeParameter.toString() + '>';
      }
      return str;
    };
    multiname.Int = multiname.getPublicQualifiedName('int');
    multiname.Uint = multiname.getPublicQualifiedName('uint');
    multiname.Class = multiname.getPublicQualifiedName('Class');
    multiname.Array = multiname.getPublicQualifiedName('Array');
    multiname.Object = multiname.getPublicQualifiedName('Object');
    multiname.String = multiname.getPublicQualifiedName('String');
    multiname.Number = multiname.getPublicQualifiedName('Number');
    multiname.Boolean = multiname.getPublicQualifiedName('Boolean');
    multiname.Function = multiname.getPublicQualifiedName('Function');
    multiname.XML = multiname.getPublicQualifiedName('XML');
    multiname.XMLList = multiname.getPublicQualifiedName('XMLList');
    return multiname;
  }();
var ConstantPool = function constantPool() {
    var nextNamespaceSetID = 1;
    function constantPool(stream, name) {
      var i, n;
      var ints = [
          0
        ];
      n = stream.readU30();
      for (i = 1; i < n; ++i) {
        ints.push(stream.readS32());
      }
      var uints = [
          0
        ];
      n = stream.readU30();
      for (i = 1; i < n; ++i) {
        uints.push(stream.readU32());
      }
      var doubles = [
          NaN
        ];
      n = stream.readU30();
      for (i = 1; i < n; ++i) {
        doubles.push(stream.readDouble());
      }
      var strings = [
          ''
        ];
      n = stream.readU30();
      for (i = 1; i < n; ++i) {
        strings.push(stream.readUTFString(stream.readU30()));
      }
      this.positionAfterUTFStrings = stream.pos;
      this.ints = ints;
      this.uints = uints;
      this.doubles = doubles;
      this.strings = strings;
      var namespaces = [
          undefined
        ];
      n = stream.readU30();
      for (i = 1; i < n; ++i) {
        var namespace = new ShumwayNamespace();
        namespace.parse(this, stream);
        namespaces.push(namespace);
      }
      var namespaceSets = [
          undefined
        ];
      n = stream.readU30();
      for (i = 1; i < n; ++i) {
        var count = stream.readU30();
        var set = [];
        set.id = nextNamespaceSetID++;
        for (var j = 0; j < count; ++j) {
          set.push(namespaces[stream.readU30()]);
        }
        namespaceSets.push(set);
      }
      this.namespaces = namespaces;
      this.namespaceSets = namespaceSets;
      var multinames = [
          undefined
        ];
      var patchFactoryTypes = [];
      n = stream.readU30();
      for (i = 1; i < n; ++i) {
        multinames.push(Multiname.parse(this, stream, multinames, patchFactoryTypes));
      }
      patchFactoryTypes.forEach(function (patch) {
        var multiname = multinames[patch.index];
        true;
        patch.multiname.name = multiname.name;
        patch.multiname.namespaces = multiname.namespaces;
      });
      this.multinames = multinames;
    }
    constantPool.prototype.getValue = function getValue(kind, index) {
      switch (kind) {
      case CONSTANT_Int:
        return this.ints[index];
      case CONSTANT_UInt:
        return this.uints[index];
      case CONSTANT_Double:
        return this.doubles[index];
      case CONSTANT_Utf8:
        return this.strings[index];
      case CONSTANT_True:
        return true;
      case CONSTANT_False:
        return false;
      case CONSTANT_Null:
        return null;
      case CONSTANT_Undefined:
        return undefined;
      case CONSTANT_Namespace:
      case CONSTANT_PackageInternalNs:
        return this.namespaces[index];
      case CONSTANT_QName:
      case CONSTANT_MultinameA:
      case CONSTANT_RTQName:
      case CONSTANT_RTQNameA:
      case CONSTANT_RTQNameL:
      case CONSTANT_RTQNameLA:
      case CONSTANT_NameL:
      case CONSTANT_NameLA:
        return this.multinames[index];
      case CONSTANT_Float:
        warning('TODO: CONSTANT_Float may be deprecated?');
        break;
      default:
        true;
      }
    };
    return constantPool;
  }();
var MethodInfo = function () {
    function getParameterName(i) {
      true;
      return 'p' + String.fromCharCode('A'.charCodeAt(0) + i);
    }
    function methodInfo(abc, stream) {
      var constantPool = abc.constantPool;
      var parameterCount = stream.readU30();
      var returnType = constantPool.multinames[stream.readU30()];
      var parameters = [];
      for (var i = 0; i < parameterCount; i++) {
        parameters.push({
          type: constantPool.multinames[stream.readU30()]
        });
      }
      var debugName = constantPool.strings[stream.readU30()];
      var flags = stream.readU8();
      var optionalCount = 0;
      var optionals = null;
      if (flags & METHOD_HasOptional) {
        optionalCount = stream.readU30();
        true;
        for (var i = parameterCount - optionalCount; i < parameterCount; i++) {
          var valueIndex = stream.readU30();
          parameters[i].value = constantPool.getValue(stream.readU8(), valueIndex);
        }
      }
      var paramnames = null;
      if (flags & METHOD_HasParamNames) {
        for (var i = 0; i < parameterCount; i++) {
          if (false) {
            parameters[i].name = constantPool.strings[stream.readU30()];
          } else {
            stream.readU30();
            parameters[i].name = getParameterName(i);
          }
        }
      } else {
        for (var i = 0; i < parameterCount; i++) {
          parameters[i].name = getParameterName(i);
        }
      }
      this.abc = abc;
      this.flags = flags;
      this.optionals = optionals;
      this.debugName = debugName;
      this.parameters = parameters;
      this.returnType = returnType;
    }
    methodInfo.prototype = {
      toString: function toString() {
        var flags = getFlags(this.flags, 'NEED_ARGUMENTS|NEED_ACTIVATION|NEED_REST|HAS_OPTIONAL|||SET_DXN|HAS_PARAM_NAMES'.split('|'));
        return (flags ? flags + ' ' : '') + this.name;
      },
      hasOptional: function hasOptional() {
        return !(!(this.flags & METHOD_HasOptional));
      },
      needsActivation: function needsActivation() {
        return !(!(this.flags & METHOD_Activation));
      },
      needsRest: function needsRest() {
        return !(!(this.flags & METHOD_Needrest));
      },
      needsArguments: function needsArguments() {
        return !(!(this.flags & METHOD_Arguments));
      },
      isNative: function isNative() {
        return !(!(this.flags & METHOD_Native));
      },
      isClassMember: function isClassMember() {
        return this.holder instanceof ClassInfo;
      },
      isInstanceMember: function isInstanceMember() {
        return this.holder instanceof InstanceInfo;
      },
      isScriptMember: function isScriptMember() {
        return this.holder instanceof ScriptInfo;
      }
    };
    function parseException(abc, stream) {
      var multinames = abc.constantPool.multinames;
      var ex = {
          start: stream.readU30(),
          end: stream.readU30(),
          target: stream.readU30(),
          typeName: multinames[stream.readU30()],
          varName: multinames[stream.readU30()]
        };
      true;
      true;
      return ex;
    }
    methodInfo.parseBody = function parseBody(abc, stream) {
      var constantPool = abc.constantPool;
      var methods = abc.methods;
      var info = methods[stream.readU30()];
      info.hasBody = true;
      true;
      info.maxStack = stream.readU30();
      info.localCount = stream.readU30();
      info.initScopeDepth = stream.readU30();
      info.maxScopeDepth = stream.readU30();
      info.code = stream.readU8s(stream.readU30());
      var exceptions = [];
      var exceptionCount = stream.readU30();
      for (var i = 0; i < exceptionCount; ++i) {
        exceptions.push(parseException(abc, stream));
      }
      info.exceptions = exceptions;
      info.traits = parseTraits(abc, stream, info);
    };
    methodInfo.prototype.hasExceptions = function hasExceptions() {
      return this.exceptions.length > 0;
    };
    return methodInfo;
  }();
var MetaDataInfo = function () {
    function metaDataInfo(abc, stream) {
      var strings = abc.constantPool.strings;
      var name = this.name = strings[stream.readU30()];
      var itemCount = stream.readU30();
      var keys = [];
      var items = [];
      for (var i = 0; i < itemCount; i++) {
        keys[i] = strings[stream.readU30()];
      }
      for (var i = 0; i < itemCount; i++) {
        var key = keys[i];
        items[i] = {
          key: key,
          value: strings[stream.readU30()]
        };
        if (key && name === 'native') {
          true;
          this[key] = items[i].value;
        }
      }
      this.value = items;
    }
    metaDataInfo.prototype = {
      toString: function toString() {
        return '[' + this.name + ']';
      }
    };
    return metaDataInfo;
  }();
function attachHolder(mi, holder) {
  true;
  mi.holder = holder;
}
var InstanceInfo = function () {
    var nextID = 1;
    function instanceInfo(abc, stream) {
      this.id = nextID++;
      this.abc = abc;
      var constantPool = abc.constantPool;
      var methods = abc.methods;
      this.name = constantPool.multinames[stream.readU30()];
      true;
      this.superName = constantPool.multinames[stream.readU30()];
      this.flags = stream.readU8();
      this.protectedNs = undefined;
      if (this.flags & 8) {
        this.protectedNs = constantPool.namespaces[stream.readU30()];
      }
      var interfaceCount = stream.readU30();
      this.interfaces = [];
      for (var i = 0; i < interfaceCount; i++) {
        this.interfaces[i] = constantPool.multinames[stream.readU30()];
      }
      this.init = methods[stream.readU30()];
      this.init.isInstanceInitializer = true;
      this.init.name = this.name;
      attachHolder(this.init, this);
      this.traits = parseTraits(abc, stream, this);
    }
    instanceInfo.prototype = {
      toString: function toString() {
        var flags = getFlags(this.flags & 8, 'sealed|final|interface|protected'.split('|'));
        var str = (flags ? flags + ' ' : '') + this.name;
        if (this.superName) {
          str += ' extends ' + this.superName;
        }
        return str;
      },
      isFinal: function isFinal() {
        return this.flags & CONSTANT_ClassFinal;
      },
      isSealed: function isSealed() {
        return this.flags & CONSTANT_ClassSealed;
      },
      isInterface: function isInterface() {
        return this.flags & CONSTANT_ClassInterface;
      }
    };
    return instanceInfo;
  }();
var ClassInfo = function () {
    var nextID = 1;
    function classInfo(abc, instanceInfo, stream) {
      this.id = nextID++;
      this.abc = abc;
      this.init = abc.methods[stream.readU30()];
      this.init.isClassInitializer = true;
      attachHolder(this.init, this);
      this.traits = parseTraits(abc, stream, this);
      this.instanceInfo = instanceInfo;
      this.instanceInfo.classInfo = this;
      this.defaultValue = getDefaultValue(this.instanceInfo.name);
    }
    function getDefaultValue(qn) {
      if (Multiname.getQualifiedName(qn) === Multiname.Int || Multiname.getQualifiedName(qn) === Multiname.Uint) {
        return 0;
      } else if (Multiname.getQualifiedName(qn) === Multiname.Number) {
        return NaN;
      } else if (Multiname.getQualifiedName(qn) === Multiname.Boolean) {
        return false;
      } else {
        return null;
      }
    }
    classInfo.prototype.toString = function () {
      return this.instanceInfo.name.toString();
    };
    return classInfo;
  }();
function isClassOrInstanceInfo(x) {
  return x instanceof ClassInfo || x instanceof InstanceInfo;
}
var ScriptInfo = function scriptInfo() {
    var nextID = 1;
    function scriptInfo(abc, index, stream) {
      this.id = nextID++;
      this.abc = abc;
      this.name = abc.name + '$script' + index;
      this.init = abc.methods[stream.readU30()];
      this.init.isScriptInitializer = true;
      this.index = index;
      attachHolder(this.init, this);
      this.traits = parseTraits(abc, stream, this);
      this.traits.verified = true;
    }
    scriptInfo.prototype = {
      get entryPoint() {
        return this.init;
      },
      toString: function () {
        return this.name;
      }
    };
    return scriptInfo;
  }();
var AbcFile = function () {
    function abcFile(bytes, name) {
      console.time('Parse ABC: ' + name);
      this.name = name;
      var n, i;
      var stream = new AbcStream(bytes);
      checkMagic(stream);
      this.constantPool = new ConstantPool(stream, name);
      this.methods = [];
      n = stream.readU30();
      for (i = 0; i < n; ++i) {
        this.methods.push(new MethodInfo(this, stream));
      }
      this.metadata = [];
      n = stream.readU30();
      for (i = 0; i < n; ++i) {
        this.metadata.push(new MetaDataInfo(this, stream));
      }
      this.instances = [];
      n = stream.readU30();
      for (i = 0; i < n; ++i) {
        this.instances.push(new InstanceInfo(this, stream));
      }
      this.classes = [];
      for (i = 0; i < n; ++i) {
        this.classes.push(new ClassInfo(this, this.instances[i], stream));
      }
      this.scripts = [];
      n = stream.readU30();
      for (i = 0; i < n; ++i) {
        this.scripts.push(new ScriptInfo(this, i, stream));
      }
      n = stream.readU30();
      for (i = 0; i < n; ++i) {
        MethodInfo.parseBody(this, stream);
      }
      console.timeEnd('Parse ABC: ' + name);
    }
    function checkMagic(stream) {
      var magic = stream.readWord();
      var flashPlayerBrannan = 46 << 16 | 15;
      if (magic < flashPlayerBrannan) {
        throw new Error('Invalid ABC File (magic = ' + Number(magic).toString(16) + ')');
      }
    }
    abcFile.prototype = {
      get lastScript() {
        true;
        return this.scripts[this.scripts.length - 1];
      },
      toString: function () {
        return this.name;
      }
    };
    return abcFile;
  }();
var Bytecode = function () {
    function Bytecode(code) {
      var op = code.readU8();
      this.op = op;
      this.originalPosition = code.position;
      var opdesc = opcodeTable[op];
      if (!opdesc) {
        unexpected('Unknown Op ' + op);
      }
      this.canThrow = opdesc.canThrow;
      var i, n;
      switch (op) {
      case OP_lookupswitch:
        var defaultOffset = code.readS24();
        this.offsets = [];
        var n = code.readU30() + 1;
        for (i = 0; i < n; i++) {
          this.offsets.push(code.readS24());
        }
        this.offsets.push(defaultOffset);
        break;
      default:
        for (i = 0, n = opdesc.operands.length; i < n; i++) {
          var operand = opdesc.operands[i];
          switch (operand.size) {
          case 'u08':
            this[operand.name] = code.readU8();
            break;
          case 's08':
            this[operand.name] = code.readS8();
            break;
          case 's16':
            this[operand.name] = code.readS16();
            break;
          case 's24':
            this[operand.name] = code.readS24();
            break;
          case 'u30':
            this[operand.name] = code.readU30();
            break;
          case 'u32':
            this[operand.name] = code.readU32();
            break;
          default:
            unexpected();
          }
        }
      }
    }
    Bytecode.prototype = {
      makeBlockHead: function makeBlockHead(id) {
        if (this.succs) {
          return id;
        }
        this.bid = id;
        this.succs = [];
        this.preds = [];
        this.dominatees = [];
        return id + 1;
      },
      trace: function trace(writer) {
        if (!this.succs) {
          return;
        }
        writer.writeLn('#' + this.bid);
      },
      toString: function toString(abc) {
        var opDescription = opcodeTable[this.op];
        var str = opDescription.name.padRight(' ', 20);
        var i, j;
        if (this.op === OP_lookupswitch) {
          str += 'targets:';
          for (i = 0, j = this.targets.length; i < j; i++) {
            str += (i > 0 ? ',' : '') + this.targets[i].position;
          }
        } else {
          for (i = 0, j = opDescription.operands.length; i < j; i++) {
            var operand = opDescription.operands[i];
            if (operand.name === 'offset') {
              str += 'target:' + this.target.position;
            } else {
              str += operand.name + ': ';
              var value = this[operand.name];
              if (abc) {
                switch (operand.type) {
                case '':
                  str += value;
                  break;
                case 'I':
                  str += abc.constantPool.ints[value];
                  break;
                case 'U':
                  str += abc.constantPool.uints[value];
                  break;
                case 'D':
                  str += abc.constantPool.doubles[value];
                  break;
                case 'S':
                  str += abc.constantPool.strings[value];
                  break;
                case 'N':
                  str += abc.constantPool.namespaces[value];
                  break;
                case 'CI':
                  str += abc.classes[value];
                  break;
                case 'M':
                  str += abc.constantPool.multinames[value];
                  break;
                default:
                  str += '?';
                  break;
                }
              } else {
                str += value;
              }
            }
            if (i < j - 1) {
              str += ', ';
            }
          }
        }
        return str;
      }
    };
    return Bytecode;
  }();
var Analysis = function () {
    function blockSetClass(length, blockById) {
      var BlockSet = BitSetFunctor(length);
      var ADDRESS_BITS_PER_WORD = BlockSet.ADDRESS_BITS_PER_WORD;
      var BITS_PER_WORD = BlockSet.BITS_PER_WORD;
      var BIT_INDEX_MASK = BlockSet.BIT_INDEX_MASK;
      BlockSet.singleton = function singleton(b) {
        var bs = new BlockSet();
        bs.set(b.bid);
        bs.count = 1;
        bs.dirty = 0;
        return bs;
      };
      BlockSet.fromBlocks = function fromArray(other) {
        var bs = new BlockSet();
        bs.setBlocks(other);
        return bs;
      };
      var Bsp = BlockSet.prototype;
      if (BlockSet.singleword) {
        Bsp.forEachBlock = function forEach(fn) {
          true;
          var byId = blockById;
          var word = this.bits;
          if (word) {
            for (var k = 0; k < BITS_PER_WORD; k++) {
              if (word & 1 << k) {
                fn(byId[k]);
              }
            }
          }
        };
        Bsp.choose = function choose() {
          var byId = blockById;
          var word = this.bits;
          if (word) {
            for (var k = 0; k < BITS_PER_WORD; k++) {
              if (word & 1 << k) {
                return byId[k];
              }
            }
          }
        };
        Bsp.members = function members() {
          var byId = blockById;
          var set = [];
          var word = this.bits;
          if (word) {
            for (var k = 0; k < BITS_PER_WORD; k++) {
              if (word & 1 << k) {
                set.push(byId[k]);
              }
            }
          }
          return set;
        };
        Bsp.setBlocks = function setBlocks(bs) {
          var bits = this.bits;
          for (var i = 0, j = bs.length; i < j; i++) {
            var id = bs[i].bid;
            bits |= 1 << (id & BIT_INDEX_MASK);
          }
          this.bits = bits;
        };
      } else {
        Bsp.forEachBlock = function forEach(fn) {
          true;
          var byId = blockById;
          var bits = this.bits;
          for (var i = 0, j = bits.length; i < j; i++) {
            var word = bits[i];
            if (word) {
              for (var k = 0; k < BITS_PER_WORD; k++) {
                if (word & 1 << k) {
                  fn(byId[i * BITS_PER_WORD + k]);
                }
              }
            }
          }
        };
        Bsp.choose = function choose() {
          var byId = blockById;
          var bits = this.bits;
          for (var i = 0, j = bits.length; i < j; i++) {
            var word = bits[i];
            if (word) {
              for (var k = 0; k < BITS_PER_WORD; k++) {
                if (word & 1 << k) {
                  return byId[i * BITS_PER_WORD + k];
                }
              }
            }
          }
        };
        Bsp.members = function members() {
          var byId = blockById;
          var set = [];
          var bits = this.bits;
          for (var i = 0, j = bits.length; i < j; i++) {
            var word = bits[i];
            if (word) {
              for (var k = 0; k < BITS_PER_WORD; k++) {
                if (word & 1 << k) {
                  set.push(byId[i * BITS_PER_WORD + k]);
                }
              }
            }
          }
          return set;
        };
        Bsp.setBlocks = function setBlocks(bs) {
          var bits = this.bits;
          for (var i = 0, j = bs.length; i < j; i++) {
            var id = bs[i].bid;
            bits[id >> ADDRESS_BITS_PER_WORD] |= 1 << (id & BIT_INDEX_MASK);
          }
        };
      }
      return BlockSet;
    }
    function Analysis(method) {
      Counter.count('Analysis');
      this.method = method;
      if (this.method.code) {
        Timer.start('Normalize');
        this.normalizeBytecode();
        Timer.stop();
      }
    }
    Analysis.prototype = {
      normalizeBytecode: function normalizeBytecode() {
        function getInvalidTarget(cache, offset) {
          if (cache && cache[offset]) {
            return cache[offset];
          }
          var code = Object.create(Bytecode.prototype);
          code.op = OP_invalid;
          code.position = offset;
          cache && (cache[offset] = code);
          return code;
        }
        var method = this.method;
        function accessLocal(index) {
          if (index-- === 0)
            return;
          if (index < method.parameters.length) {
            method.parameters[index].isUsed = true;
          }
        }
        var bytecodesOffset = [];
        var bytecodes = [];
        var codeStream = new AbcStream(this.method.code);
        var code;
        while (codeStream.remaining() > 0) {
          var pos = codeStream.position;
          code = new Bytecode(codeStream);
          switch (code.op) {
          case OP_nop:
          case OP_label:
            bytecodesOffset[pos] = bytecodes.length;
            continue;
          case OP_lookupswitch:
            this.method.hasLookupSwitches = true;
            code.targets = [];
            var offsets = code.offsets;
            for (var i = 0, j = offsets.length; i < j; i++) {
              offsets[i] += pos;
            }
            break;
          case OP_jump:
          case OP_iflt:
          case OP_ifnlt:
          case OP_ifle:
          case OP_ifnle:
          case OP_ifgt:
          case OP_ifngt:
          case OP_ifge:
          case OP_ifnge:
          case OP_ifeq:
          case OP_ifne:
          case OP_ifstricteq:
          case OP_ifstrictne:
          case OP_iftrue:
          case OP_iffalse:
            code.offset += codeStream.position;
            break;
          case OP_getlocal0:
          case OP_getlocal1:
          case OP_getlocal2:
          case OP_getlocal3:
            accessLocal(code.op - OP_getlocal0);
            break;
          case OP_getlocal:
            accessLocal(code.index);
            break;
          default:
            break;
          }
          code.position = bytecodes.length;
          bytecodesOffset[pos] = bytecodes.length;
          bytecodes.push(code);
        }
        var invalidJumps = {};
        var newOffset;
        for (var pc = 0, end = bytecodes.length; pc < end; pc++) {
          code = bytecodes[pc];
          switch (code.op) {
          case OP_lookupswitch:
            var offsets = code.offsets;
            for (var i = 0, j = offsets.length; i < j; i++) {
              newOffset = bytecodesOffset[offsets[i]];
              code.targets.push(bytecodes[newOffset] || getInvalidTarget(invalidJumps, offsets[i]));
              offsets[i] = newOffset;
            }
            break;
          case OP_jump:
          case OP_iflt:
          case OP_ifnlt:
          case OP_ifle:
          case OP_ifnle:
          case OP_ifgt:
          case OP_ifngt:
          case OP_ifge:
          case OP_ifnge:
          case OP_ifeq:
          case OP_ifne:
          case OP_ifstricteq:
          case OP_ifstrictne:
          case OP_iftrue:
          case OP_iffalse:
            newOffset = bytecodesOffset[code.offset];
            code.target = bytecodes[newOffset] || getInvalidTarget(invalidJumps, code.offset);
            code.offset = newOffset;
            break;
          default:
          }
        }
        this.bytecodes = bytecodes;
        var exceptions = this.method.exceptions;
        for (var i = 0, j = exceptions.length; i < j; i++) {
          var ex = exceptions[i];
          ex.start = bytecodesOffset[ex.start];
          ex.end = bytecodesOffset[ex.end];
          ex.offset = bytecodesOffset[ex.target];
          ex.target = bytecodes[ex.offset];
          ex.target.exception = ex;
        }
      },
      detectBasicBlocks: function detectBasicBlocks() {
        var bytecodes = this.bytecodes;
        var exceptions = this.method.exceptions;
        var hasExceptions = exceptions.length > 0;
        var blockById = {};
        var code;
        var pc, end;
        var id = 0;
        function tryTargets(block) {
          var targets = [];
          for (var i = 0, j = exceptions.length; i < j; i++) {
            var ex = exceptions[i];
            if (block.position >= ex.start && block.end.position <= ex.end) {
              targets.push(ex.target);
            }
          }
          return targets;
        }
        id = bytecodes[0].makeBlockHead(id);
        for (pc = 0, end = bytecodes.length - 1; pc < end; pc++) {
          code = bytecodes[pc];
          switch (code.op) {
          case OP_returnvoid:
          case OP_returnvalue:
          case OP_throw:
            id = bytecodes[pc + 1].makeBlockHead(id);
            break;
          case OP_lookupswitch:
            var targets = code.targets;
            for (var i = 0, j = targets.length; i < j; i++) {
              id = targets[i].makeBlockHead(id);
            }
            id = bytecodes[pc + 1].makeBlockHead(id);
            break;
          case OP_jump:
          case OP_iflt:
          case OP_ifnlt:
          case OP_ifle:
          case OP_ifnle:
          case OP_ifgt:
          case OP_ifngt:
          case OP_ifge:
          case OP_ifnge:
          case OP_ifeq:
          case OP_ifne:
          case OP_ifstricteq:
          case OP_ifstrictne:
          case OP_iftrue:
          case OP_iffalse:
            id = code.target.makeBlockHead(id);
            id = bytecodes[pc + 1].makeBlockHead(id);
            break;
          default:
          }
        }
        code = bytecodes[end];
        switch (code.op) {
        case OP_returnvoid:
        case OP_returnvalue:
        case OP_throw:
          break;
        case OP_lookupswitch:
          var targets = code.targets;
          for (var i = 0, j = targets.length; i < j; i++) {
            id = targets[i].makeBlockHead(id);
          }
          break;
        case OP_jump:
          id = code.target.makeBlockHead(id);
          break;
        case OP_iflt:
        case OP_ifnlt:
        case OP_ifle:
        case OP_ifnle:
        case OP_ifgt:
        case OP_ifngt:
        case OP_ifge:
        case OP_ifnge:
        case OP_ifeq:
        case OP_ifne:
        case OP_ifstricteq:
        case OP_ifstrictne:
        case OP_iftrue:
        case OP_iffalse:
          id = code.target.makeBlockHead(id);
          bytecodes[pc + 1] = getInvalidTarget(null, pc + 1);
          id = bytecodes[pc + 1].makeBlockHead(id);
          break;
        default:
        }
        if (hasExceptions) {
          for (var i = 0, j = exceptions.length; i < j; i++) {
            var ex = exceptions[i];
            var tryStart = bytecodes[ex.start];
            var afterTry = bytecodes[ex.end + 1];
            id = tryStart.makeBlockHead(id);
            if (afterTry) {
              id = afterTry.makeBlockHead(id);
            }
            id = ex.target.makeBlockHead(id);
          }
        }
        var currentBlock = bytecodes[0];
        for (pc = 1, end = bytecodes.length; pc < end; pc++) {
          if (!bytecodes[pc].succs) {
            continue;
          }
          true;
          blockById[currentBlock.bid] = currentBlock;
          code = bytecodes[pc - 1];
          currentBlock.end = code;
          var nextBlock = bytecodes[pc];
          switch (code.op) {
          case OP_returnvoid:
          case OP_returnvalue:
          case OP_throw:
            break;
          case OP_lookupswitch:
            for (var i = 0, j = code.targets.length; i < j; i++) {
              currentBlock.succs.push(code.targets[i]);
            }
            break;
          case OP_jump:
            currentBlock.succs.push(code.target);
            break;
          case OP_iflt:
          case OP_ifnlt:
          case OP_ifle:
          case OP_ifnle:
          case OP_ifgt:
          case OP_ifngt:
          case OP_ifge:
          case OP_ifnge:
          case OP_ifeq:
          case OP_ifne:
          case OP_ifstricteq:
          case OP_ifstrictne:
          case OP_iftrue:
          case OP_iffalse:
            currentBlock.succs.push(code.target);
            if (code.target !== nextBlock) {
              currentBlock.succs.push(nextBlock);
            }
            break;
          default:
            currentBlock.succs.push(nextBlock);
          }
          if (hasExceptions) {
            var targets = tryTargets(currentBlock);
            currentBlock.hasCatches = targets.length > 0;
            currentBlock.succs.push.apply(currentBlock.succs, targets);
          }
          currentBlock = nextBlock;
        }
        blockById[currentBlock.bid] = currentBlock;
        code = bytecodes[end - 1];
        switch (code.op) {
        case OP_lookupswitch:
          for (var i = 0, j = code.targets.length; i < j; i++) {
            currentBlock.succs.push(code.targets[i]);
          }
          break;
        case OP_jump:
          currentBlock.succs.push(code.target);
          break;
        default:
        }
        currentBlock.end = code;
        this.BlockSet = blockSetClass(id, blockById);
      },
      normalizeReachableBlocks: function normalizeReachableBlocks() {
        var root = this.bytecodes[0];
        true;
        var ONCE = 1;
        var BUNCH_OF_TIMES = 2;
        var BlockSet = this.BlockSet;
        var blocks = [];
        var visited = {};
        var ancestors = {};
        var worklist = [
            root
          ];
        var node;
        ancestors[root.bid] = true;
        while (node = worklist.top()) {
          if (visited[node.bid]) {
            if (visited[node.bid] === ONCE) {
              visited[node.bid] = BUNCH_OF_TIMES;
              blocks.push(node);
              var succs = node.succs;
              for (var i = 0, j = succs.length; i < j; i++) {
                succs[i].preds.push(node);
              }
            }
            ancestors[node.bid] = false;
            worklist.pop();
            continue;
          }
          visited[node.bid] = ONCE;
          ancestors[node.bid] = true;
          var succs = node.succs;
          for (var i = 0, j = succs.length; i < j; i++) {
            var s = succs[i];
            if (ancestors[s.bid]) {
              if (!node.spbacks) {
                node.spbacks = new BlockSet();
              }
              node.spbacks.set(s.bid);
            }
            !visited[s.bid] && worklist.push(s);
          }
        }
        this.blocks = blocks.reverse();
      },
      computeDominance: function computeDominance() {
        function intersectDominators(doms, b1, b2) {
          var finger1 = b1;
          var finger2 = b2;
          while (finger1 !== finger2) {
            while (finger1 > finger2) {
              finger1 = doms[finger1];
            }
            while (finger2 > finger1) {
              finger2 = doms[finger2];
            }
          }
          return finger1;
        }
        var blocks = this.blocks;
        var n = blocks.length;
        var doms = new Array(n);
        doms[0] = 0;
        var rpo = {};
        for (var b = 0; b < n; b++) {
          rpo[blocks[b].bid] = b;
        }
        var changed = true;
        while (changed) {
          changed = false;
          for (var b = 1; b < n; b++) {
            var preds = blocks[b].preds;
            var j = preds.length;
            var newIdom = rpo[preds[0].bid];
            if (!(newIdom in doms)) {
              for (var i = 1; i < j; i++) {
                newIdom = rpo[preds[i].bid];
                if (newIdom in doms) {
                  break;
                }
              }
            }
            true;
            for (var i = 0; i < j; i++) {
              var p = rpo[preds[i].bid];
              if (p === newIdom) {
                continue;
              }
              if (p in doms) {
                newIdom = intersectDominators(doms, p, newIdom);
              }
            }
            if (doms[b] !== newIdom) {
              doms[b] = newIdom;
              changed = true;
            }
          }
        }
        blocks[0].dominator = blocks[0];
        var block;
        for (var b = 1; b < n; b++) {
          block = blocks[b];
          var idom = blocks[doms[b]];
          block.dominator = idom;
          idom.dominatees.push(block);
          block.npreds = block.preds.length;
        }
        var worklist = [
            blocks[0]
          ];
        blocks[0].level || (blocks[0].level = 0);
        while (block = worklist.shift()) {
          var dominatees = block.dominatees;
          for (var i = 0, j = dominatees.length; i < j; i++) {
            dominatees[i].level = block.level + 1;
          }
          worklist.push.apply(worklist, dominatees);
        }
      },
      analyzeControlFlow: function analyzeControlFlow() {
        true;
        this.detectBasicBlocks();
        this.normalizeReachableBlocks();
        this.computeDominance();
        this.analyzedControlFlow = true;
        return true;
      },
      markLoops: function markLoops() {
        if (!this.analyzedControlFlow && !this.analyzeControlFlow()) {
          return false;
        }
        var BlockSet = this.BlockSet;
        function findSCCs(root) {
          var preorderId = 1;
          var preorder = {};
          var assigned = {};
          var unconnectedNodes = [];
          var pendingNodes = [];
          var sccs = [];
          var level = root.level + 1;
          var worklist = [
              root
            ];
          var node;
          var u, s;
          while (node = worklist.top()) {
            if (preorder[node.bid]) {
              if (pendingNodes.peek() === node) {
                pendingNodes.pop();
                var scc = [];
                do {
                  u = unconnectedNodes.pop();
                  assigned[u.bid] = true;
                  scc.push(u);
                } while (u !== node);
                if (scc.length > 1 || u.spbacks && u.spbacks.get(u.bid)) {
                  sccs.push(scc);
                }
              }
              worklist.pop();
              continue;
            }
            preorder[node.bid] = preorderId++;
            unconnectedNodes.push(node);
            pendingNodes.push(node);
            var succs = node.succs;
            for (var i = 0, j = succs.length; i < j; i++) {
              s = succs[i];
              if (s.level < level) {
                continue;
              }
              var sid = s.bid;
              if (!preorder[sid]) {
                worklist.push(s);
              } else if (!assigned[sid]) {
                while (preorder[pendingNodes.peek().bid] > preorder[sid]) {
                  pendingNodes.pop();
                }
              }
            }
          }
          return sccs;
        }
        function findLoopHeads(blocks) {
          var heads = new BlockSet();
          for (var i = 0, j = blocks.length; i < j; i++) {
            var block = blocks[i];
            var spbacks = block.spbacks;
            if (!spbacks) {
              continue;
            }
            var succs = block.succs;
            for (var k = 0, l = succs.length; k < l; k++) {
              var s = succs[k];
              if (spbacks.get(s.bid)) {
                heads.set(s.dominator.bid);
              }
            }
          }
          return heads.members();
        }
        function LoopInfo(scc, loopId) {
          var body = new BlockSet();
          body.setBlocks(scc);
          body.recount();
          this.id = loopId;
          this.body = body;
          this.exit = new BlockSet();
          this.save = {};
          this.head = new BlockSet();
          this.npreds = 0;
        }
        var heads = findLoopHeads(this.blocks);
        if (heads.length <= 0) {
          this.markedLoops = true;
          return true;
        }
        var worklist = heads.sort(function (a, b) {
            return a.level - b.level;
          });
        var loopId = 0;
        for (var n = worklist.length - 1; n >= 0; n--) {
          var top = worklist[n];
          var sccs = findSCCs(top);
          if (sccs.length === 0) {
            continue;
          }
          for (var i = 0, j = sccs.length; i < j; i++) {
            var scc = sccs[i];
            var loop = new LoopInfo(scc, loopId++);
            for (var k = 0, l = scc.length; k < l; k++) {
              var h = scc[k];
              if (h.level === top.level + 1 && !h.loop) {
                h.loop = loop;
                loop.head.set(h.bid);
                var preds = h.preds;
                for (var pi = 0, pj = preds.length; pi < pj; pi++) {
                  loop.body.get(preds[pi].bid) && h.npreds--;
                }
                loop.npreds += h.npreds;
              }
            }
            for (var k = 0, l = scc.length; k < l; k++) {
              var h = scc[k];
              if (h.level === top.level + 1) {
                h.npreds = loop.npreds;
              }
            }
            loop.head.recount();
          }
        }
        this.markedLoops = true;
        return true;
      }
    };
    return Analysis;
  }();
(function (exports) {
  var lang = exports.lang = {
      Node: {},
      Program: {
        extends: 'Node',
        fields: [
          '@body'
        ]
      },
      Statement: {
        extends: 'Node'
      },
      EmptyStatement: {
        extends: 'Statement'
      },
      BlockStatement: {
        extends: 'Statement',
        fields: [
          '@body'
        ]
      },
      ExpressionStatement: {
        extends: 'Statement',
        fields: [
          '@expression'
        ]
      },
      IfStatement: {
        extends: 'Statement',
        fields: [
          '@test',
          '@consequent',
          '@alternate'
        ]
      },
      LabeledStatement: {
        extends: 'Statement',
        fields: [
          '@label',
          '@body'
        ]
      },
      BreakStatement: {
        extends: 'Statement',
        fields: [
          '@label'
        ]
      },
      ContinueStatement: {
        extends: 'Statement',
        fields: [
          '@label'
        ]
      },
      WithStatement: {
        extends: 'Statement',
        fields: [
          '@object',
          '@body'
        ]
      },
      SwitchStatement: {
        extends: 'Statement',
        fields: [
          '@discriminant',
          '@cases',
          'lexical'
        ]
      },
      ReturnStatement: {
        extends: 'Statement',
        fields: [
          '@argument'
        ]
      },
      ThrowStatement: {
        extends: 'Statement',
        fields: [
          '@argument'
        ]
      },
      TryStatement: {
        extends: 'Statement',
        fields: [
          '@block',
          '@handlers',
          '@finalizer'
        ]
      },
      WhileStatement: {
        extends: 'Statement',
        fields: [
          '@test',
          '@body'
        ]
      },
      DoWhileStatement: {
        extends: 'Statement',
        fields: [
          '@body',
          '@test'
        ]
      },
      ForStatement: {
        extends: 'Statement',
        fields: [
          '@init',
          '@test',
          '@update',
          '@body'
        ]
      },
      ForInStatement: {
        extends: 'Statement',
        fields: [
          '@left',
          '@right',
          '@body',
          'each'
        ]
      },
      LetStatement: {
        extends: 'Statement',
        fields: [
          '@head',
          '@body'
        ]
      },
      DebuggerStatement: {
        extends: 'Statement'
      },
      Declaration: {
        extends: 'Statement'
      },
      FunctionDeclaration: {
        extends: 'Declaration',
        fields: [
          '@id',
          '@params',
          '@body',
          '@decltype',
          'generator',
          'expression',
          '@modifiers'
        ]
      },
      VariableDeclaration: {
        extends: 'Declaration',
        fields: [
          'kind',
          '@declarations'
        ]
      },
      VariableDeclarator: {
        extends: 'Node',
        fields: [
          '@id',
          '@init',
          '@decltype',
          '@arguments'
        ]
      },
      Expression: {
        extends: 'Pattern'
      },
      ThisExpression: {
        extends: 'Expression'
      },
      ArrayExpression: {
        extends: 'Expression',
        fields: [
          '@elements'
        ]
      },
      ObjectExpression: {
        extends: 'Expression',
        fields: [
          '@properties'
        ]
      },
      Property: {
        extends: 'Node',
        fields: [
          '@key',
          '@value',
          'kind'
        ]
      },
      FunctionExpression: {
        extends: 'Expression',
        fields: [
          '@id',
          '@params',
          '@body',
          '@decltype',
          'generator',
          'expression'
        ]
      },
      SequenceExpression: {
        extends: 'Expression',
        fields: [
          '@expressions'
        ]
      },
      UnaryExpression: {
        extends: 'Expression',
        fields: [
          'operator',
          '@argument',
          'prefix'
        ]
      },
      BinaryExpression: {
        extends: 'Expression',
        fields: [
          'operator',
          '@left',
          '@right'
        ]
      },
      AssignmentExpression: {
        extends: 'Expression',
        fields: [
          '@left',
          'operator',
          '@right'
        ]
      },
      UpdateExpression: {
        extends: 'Expression',
        fields: [
          'operator',
          '@argument',
          'prefix'
        ]
      },
      LogicalExpression: {
        extends: 'Expression',
        fields: [
          'operator',
          '@left',
          '@right'
        ]
      },
      ConditionalExpression: {
        extends: 'Expression',
        fields: [
          '@test',
          '@consequent',
          '@alternate'
        ]
      },
      NewExpression: {
        extends: 'Expression',
        fields: [
          '@callee',
          '@arguments'
        ]
      },
      CallExpression: {
        extends: 'Expression',
        fields: [
          '@callee',
          '@arguments'
        ]
      },
      MemberExpression: {
        extends: 'Expression',
        fields: [
          '@object',
          '@property',
          'computed',
          'kind'
        ]
      },
      YieldExpression: {
        extends: 'Expression',
        fields: [
          '@argument'
        ]
      },
      ComprehensionExpression: {
        extends: 'Expression',
        fields: [
          '@blocks',
          '@filter'
        ]
      },
      GeneratorExpression: {
        extends: 'Expression',
        fields: [
          '@blocks',
          '@filter'
        ]
      },
      LetExpression: {
        extends: 'Expression',
        fields: [
          '@head',
          '@body'
        ]
      },
      Pattern: {
        extends: 'Node'
      },
      ObjectPattern: {
        extends: 'Pattern',
        fields: [
          '@properties'
        ]
      },
      ArrayPattern: {
        extends: 'Pattern',
        fields: [
          '@elements'
        ]
      },
      SwitchCase: {
        extends: 'Node',
        fields: [
          '@test',
          '@consequent'
        ]
      },
      CatchClause: {
        extends: 'Node',
        fields: [
          '@param',
          '@guard',
          '@body'
        ]
      },
      Identifier: {
        extends: 'Expression',
        fields: [
          'name',
          'kind'
        ]
      },
      Literal: {
        extends: 'Expression',
        fields: [
          'value'
        ]
      },
      Type: {
        extends: 'Node'
      },
      PointerType: {
        extends: 'Type',
        fields: [
          '@base'
        ]
      },
      ArrayType: {
        extends: 'PointerType',
        fields: [
          'length'
        ]
      },
      StructType: {
        extends: 'Type',
        fields: [
          '@id',
          '@members',
          'isUnion'
        ]
      },
      MemberDeclarator: {
        extends: 'Node',
        fields: [
          'modifiers',
          '@declarator'
        ]
      },
      ArrowType: {
        extends: 'Type',
        fields: [
          '@params',
          '@return'
        ]
      },
      TypeIdentifier: {
        extends: 'Type',
        fields: [
          'name'
        ]
      },
      TypeAliasDirective: {
        extends: 'Node',
        fields: [
          '@original',
          '@alias'
        ]
      },
      CastExpression: {
        extends: 'Expression',
        fields: [
          '@as',
          '@argument'
        ]
      }
    };
  function allFields(spec) {
    var fields = [
        'leadingComments',
        'loc'
      ];
    while (spec) {
      if (spec.fields) {
        fields = spec.fields.concat(fields);
      }
      spec = spec.extends ? lang[spec.extends] : null;
    }
    return fields;
  }
  ;
  exports.allFields = allFields;
  function prefixUnderscore(s) {
    return '_' + s;
  }
  function ensureConstructor(name, spec) {
    if (!exports[name]) {
      var fields = allFields(spec);
      var children = [];
      var body = [
          'this.type = "' + name + '";'
        ];
      for (var i = 0, j = fields.length; i < j; i++) {
        var fname = fields[i];
        if (fname.charAt(0) === '@') {
          fields[i] = fname = fname.substr(1);
          children.push(fname);
        }
        body.push('this.' + fname + ' = _' + fname + ';');
      }
      var node = new Function(fields.map(prefixUnderscore), body.join('\n'));
      if (spec.extends) {
        var pnode = ensureConstructor(spec.extends, lang[spec.extends]);
        node.prototype = Object.create(pnode.prototype);
      }
      Object.defineProperty(node.prototype, '_children', {
        value: children,
        writable: true,
        configurable: true,
        enumerable: false
      });
      exports[name] = node;
    }
    return exports[name];
  }
  for (var name in lang) {
    ensureConstructor(name, lang[name]);
  }
  exports.makePass = function makePass(name, prop) {
    return function (o) {
      var trans, arr;
      var child, children = this._children;
      for (var i = 0, j = children.length; i < j; i++) {
        if (!(child = this[children[i]])) {
          continue;
        }
        if (child instanceof Array) {
          arr = this[children[i]] = [];
          for (var k = 0, l = child.length; k < l; k++) {
            if (!child[k]) {
              arr.push(child[k]);
            } else if (typeof child[k][name] === 'function') {
              trans = child[k][name](o);
              if (trans !== null) {
                arr.push(trans);
              }
            }
          }
        } else if (typeof child[name] === 'function') {
          trans = child[name](o);
          if (trans === null) {
            this[children[i]] = undefined;
          } else {
            this[children[i]] = trans;
          }
        }
      }
      if (typeof this[prop] === 'function') {
        if (o.logger && typeof this.loc !== 'undefined') {
          o.logger.push(this);
          trans = this[prop](o);
          o.logger.pop();
        } else {
          trans = this[prop](o);
        }
        if (trans === null) {
          return null;
        }
        return trans ? trans : this;
      }
      return this;
    };
  };
  exports.makePass = function makePass(name, prop, backward) {
    return function (o) {
      var trans, arr;
      var child, children = this._children;
      var i, k;
      for (var x = 0, j = children.length; x < j; x++) {
        i = backward ? children.length - 1 - x : x;
        if (!(child = this[children[i]])) {
          continue;
        }
        if (child instanceof Array) {
          arr = this[children[i]] = [];
          var y;
          for (var y = 0, l = child.length; y < l; y++) {
            k = backward ? child.length - 1 - y : y;
            if (!child[k]) {
              if (backward) {
                arr.unshift(child[k]);
              } else {
                arr.push(child[k]);
              }
            } else if (typeof child[k][name] === 'function') {
              trans = child[k][name](o);
              if (trans !== null) {
                if (backward) {
                  arr.unshift(trans);
                } else {
                  arr.push(trans);
                }
              }
            }
          }
        } else if (typeof child[name] === 'function') {
          trans = child[name](o);
          if (trans === null) {
            this[children[i]] = undefined;
          } else {
            this[children[i]] = trans;
          }
        }
      }
      if (typeof this[prop] === 'function') {
        if (o.logger && typeof this.loc !== 'undefined') {
          o.logger.push(this);
          trans = this[prop](o);
          o.logger.pop();
        } else {
          trans = this[prop](o);
        }
        if (trans === null) {
          return null;
        }
        return trans ? trans : this;
      }
      return this;
    };
  };
  exports.lift = function lift(raw) {
    if (!raw) {
      return raw;
    }
    if (raw instanceof Array) {
      return raw.map(function (r) {
        return r ? lift(r) : r;
      });
    }
    var type = raw.type;
    var Node = exports[type];
    if (!Node) {
      throw new Error('unknown node type `' + type + '\'');
    }
    var node = new Node();
    node.loc = raw.loc;
    var fields = allFields(lang[type]);
    for (var i = 0, j = fields.length; i < j; i++) {
      var field;
      if (fields[i].charAt(0) === '@') {
        field = fields[i].substr(1);
        if (raw[field]) {
          node[field] = lift(raw[field]);
        }
      } else {
        field = fields[i];
        node[field] = raw[field];
      }
    }
    return node;
  };
  exports.flatten = function flatten(node) {
    if (!node) {
      return node;
    }
    if (node instanceof Array) {
      return node.map(function (n) {
        return flatten(n);
      });
    }
    var type = node.type;
    var raw = {
        type: type
      };
    var fields = allFields(lang[type]);
    for (var i = 0, j = fields.length; i < j; i++) {
      var field;
      if (fields[i].charAt(0) === '@') {
        field = fields[i].substr(1);
        if (node[field]) {
          raw[field] = flatten(node[field]);
        } else {
          raw[field] = null;
        }
      } else {
        field = fields[i];
        raw[field] = node[field];
      }
    }
    return raw;
  };
}(typeof exports === 'undefined' ? estransform = {} : exports));
(function (exports) {
  var Syntax, Precedence, BinaryPrecedence, Regex, VisitorKeys, VisitorOption, isArray, base, indent, json, renumber, hexadecimal, quotes, escapeless, newline, space, parentheses, semicolons, extra, parse;
  Syntax = {
    AssignmentExpression: 'AssignmentExpression',
    ArrayExpression: 'ArrayExpression',
    BlockStatement: 'BlockStatement',
    BinaryExpression: 'BinaryExpression',
    BreakStatement: 'BreakStatement',
    CallExpression: 'CallExpression',
    CatchClause: 'CatchClause',
    ConditionalExpression: 'ConditionalExpression',
    ContinueStatement: 'ContinueStatement',
    DoWhileStatement: 'DoWhileStatement',
    DebuggerStatement: 'DebuggerStatement',
    EmptyStatement: 'EmptyStatement',
    ExpressionStatement: 'ExpressionStatement',
    ForStatement: 'ForStatement',
    ForInStatement: 'ForInStatement',
    FunctionDeclaration: 'FunctionDeclaration',
    FunctionExpression: 'FunctionExpression',
    Identifier: 'Identifier',
    IfStatement: 'IfStatement',
    Literal: 'Literal',
    LabeledStatement: 'LabeledStatement',
    LogicalExpression: 'LogicalExpression',
    MemberExpression: 'MemberExpression',
    NewExpression: 'NewExpression',
    ObjectExpression: 'ObjectExpression',
    Program: 'Program',
    Property: 'Property',
    ReturnStatement: 'ReturnStatement',
    SequenceExpression: 'SequenceExpression',
    SwitchStatement: 'SwitchStatement',
    SwitchCase: 'SwitchCase',
    ThisExpression: 'ThisExpression',
    ThrowStatement: 'ThrowStatement',
    TryStatement: 'TryStatement',
    UnaryExpression: 'UnaryExpression',
    UpdateExpression: 'UpdateExpression',
    VariableDeclaration: 'VariableDeclaration',
    VariableDeclarator: 'VariableDeclarator',
    WhileStatement: 'WhileStatement',
    WithStatement: 'WithStatement'
  };
  Precedence = {
    Sequence: 0,
    Assignment: 1,
    Conditional: 2,
    LogicalOR: 3,
    LogicalAND: 4,
    BitwiseOR: 5,
    BitwiseXOR: 6,
    BitwiseAND: 7,
    Equality: 8,
    Relational: 9,
    BitwiseSHIFT: 10,
    Additive: 11,
    Multiplicative: 12,
    Unary: 13,
    Postfix: 14,
    Call: 15,
    New: 16,
    Member: 17,
    Primary: 18
  };
  BinaryPrecedence = {
    '||': Precedence.LogicalOR,
    '&&': Precedence.LogicalAND,
    '|': Precedence.BitwiseOR,
    '^': Precedence.BitwiseXOR,
    '&': Precedence.BitwiseAND,
    '==': Precedence.Equality,
    '!=': Precedence.Equality,
    '===': Precedence.Equality,
    '!==': Precedence.Equality,
    '<': Precedence.Relational,
    '>': Precedence.Relational,
    '<=': Precedence.Relational,
    '>=': Precedence.Relational,
    'in': Precedence.Relational,
    'instanceof': Precedence.Relational,
    '<<': Precedence.BitwiseSHIFT,
    '>>': Precedence.BitwiseSHIFT,
    '>>>': Precedence.BitwiseSHIFT,
    '+': Precedence.Additive,
    '-': Precedence.Additive,
    '*': Precedence.Multiplicative,
    '%': Precedence.Multiplicative,
    '/': Precedence.Multiplicative
  };
  Regex = {
    NonAsciiIdentifierPart: new RegExp('[\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0300-\u0374\u0376\u0377\u037a-\u037d\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u0483-\u0487\u048a-\u0527\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u05d0-\u05ea\u05f0-\u05f2\u0610-\u061a\u0620-\u0669\u066e-\u06d3\u06d5-\u06dc\u06df-\u06e8\u06ea-\u06fc\u06ff\u0710-\u074a\u074d-\u07b1\u07c0-\u07f5\u07fa\u0800-\u082d\u0840-\u085b\u08a0\u08a2-\u08ac\u08e4-\u08fe\u0900-\u0963\u0966-\u096f\u0971-\u0977\u0979-\u097f\u0981-\u0983\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bc-\u09c4\u09c7\u09c8\u09cb-\u09ce\u09d7\u09dc\u09dd\u09df-\u09e3\u09e6-\u09f1\u0a01-\u0a03\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a59-\u0a5c\u0a5e\u0a66-\u0a75\u0a81-\u0a83\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abc-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ad0\u0ae0-\u0ae3\u0ae6-\u0aef\u0b01-\u0b03\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3c-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b56\u0b57\u0b5c\u0b5d\u0b5f-\u0b63\u0b66-\u0b6f\u0b71\u0b82\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd0\u0bd7\u0be6-\u0bef\u0c01-\u0c03\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c3d-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c58\u0c59\u0c60-\u0c63\u0c66-\u0c6f\u0c82\u0c83\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbc-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0cde\u0ce0-\u0ce3\u0ce6-\u0cef\u0cf1\u0cf2\u0d02\u0d03\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d-\u0d44\u0d46-\u0d48\u0d4a-\u0d4e\u0d57\u0d60-\u0d63\u0d66-\u0d6f\u0d7a-\u0d7f\u0d82\u0d83\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0df2\u0df3\u0e01-\u0e3a\u0e40-\u0e4e\u0e50-\u0e59\u0e81\u0e82\u0e84\u0e87\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa\u0eab\u0ead-\u0eb9\u0ebb-\u0ebd\u0ec0-\u0ec4\u0ec6\u0ec8-\u0ecd\u0ed0-\u0ed9\u0edc-\u0edf\u0f00\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f3e-\u0f47\u0f49-\u0f6c\u0f71-\u0f84\u0f86-\u0f97\u0f99-\u0fbc\u0fc6\u1000-\u1049\u1050-\u109d\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u135d-\u135f\u1380-\u138f\u13a0-\u13f4\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f0\u1700-\u170c\u170e-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176c\u176e-\u1770\u1772\u1773\u1780-\u17d3\u17d7\u17dc\u17dd\u17e0-\u17e9\u180b-\u180d\u1810-\u1819\u1820-\u1877\u1880-\u18aa\u18b0-\u18f5\u1900-\u191c\u1920-\u192b\u1930-\u193b\u1946-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u19d0-\u19d9\u1a00-\u1a1b\u1a20-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1aa7\u1b00-\u1b4b\u1b50-\u1b59\u1b6b-\u1b73\u1b80-\u1bf3\u1c00-\u1c37\u1c40-\u1c49\u1c4d-\u1c7d\u1cd0-\u1cd2\u1cd4-\u1cf6\u1d00-\u1de6\u1dfc-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u200c\u200d\u203f\u2040\u2054\u2071\u207f\u2090-\u209c\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2102\u2107\u210a-\u2113\u2115\u2119-\u211d\u2124\u2126\u2128\u212a-\u212d\u212f-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d7f-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u2de0-\u2dff\u2e2f\u3005-\u3007\u3021-\u302f\u3031-\u3035\u3038-\u303c\u3041-\u3096\u3099\u309a\u309d-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312d\u3131-\u318e\u31a0-\u31ba\u31f0-\u31ff\u3400-\u4db5\u4e00-\u9fcc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua62b\ua640-\ua66f\ua674-\ua67d\ua67f-\ua697\ua69f-\ua6f1\ua717-\ua71f\ua722-\ua788\ua78b-\ua78e\ua790-\ua793\ua7a0-\ua7aa\ua7f8-\ua827\ua840-\ua873\ua880-\ua8c4\ua8d0-\ua8d9\ua8e0-\ua8f7\ua8fb\ua900-\ua92d\ua930-\ua953\ua960-\ua97c\ua980-\ua9c0\ua9cf-\ua9d9\uaa00-\uaa36\uaa40-\uaa4d\uaa50-\uaa59\uaa60-\uaa76\uaa7a\uaa7b\uaa80-\uaac2\uaadb-\uaadd\uaae0-\uaaef\uaaf2-\uaaf6\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uabc0-\uabea\uabec\uabed\uabf0-\uabf9\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe00-\ufe0f\ufe20-\ufe26\ufe33\ufe34\ufe4d-\ufe4f\ufe70-\ufe74\ufe76-\ufefc\uff10-\uff19\uff21-\uff3a\uff3f\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc]')
  };
  function getDefaultOptions() {
    return {
      indent: null,
      base: null,
      parse: null,
      comment: false,
      format: {
        indent: {
          style: '    ',
          base: 0,
          adjustMultilineComment: false
        },
        json: false,
        renumber: false,
        hexadecimal: false,
        quotes: 'single',
        escapeless: false,
        compact: false,
        parentheses: true,
        semicolons: true
      }
    };
  }
  function stringToArray(str) {
    var length = str.length, result = [], i;
    for (i = 0; i < length; i += 1) {
      result[i] = str.charAt(i);
    }
    return result;
  }
  function stringRepeat(str, num) {
    var result = '';
    for (num |= 0; num > 0; num >>>= 1, str += str) {
      if (num & 1) {
        result += str;
      }
    }
    return result;
  }
  isArray = Array.isArray;
  if (!isArray) {
    isArray = function isArray(array) {
      return Object.prototype.toString.call(array) === '[object Array]';
    };
  }
  function endsWithLineTerminator(str) {
    var len, ch;
    len = str.length;
    ch = str.charAt(len - 1);
    return ch === '\r' || ch === '\n';
  }
  function shallowCopy(obj) {
    var ret = {}, key;
    for (key in obj) {
      if (obj.hasOwnProperty(key)) {
        ret[key] = obj[key];
      }
    }
    return ret;
  }
  function deepCopy(obj) {
    var ret = {}, key, val;
    for (key in obj) {
      if (obj.hasOwnProperty(key)) {
        val = obj[key];
        if (typeof val === 'object' && val !== null) {
          ret[key] = deepCopy(val);
        } else {
          ret[key] = val;
        }
      }
    }
    return ret;
  }
  function updateDeeply(target, override) {
    var key, val;
    function isHashObject(target) {
      return typeof target === 'object' && target instanceof Object && !(target instanceof RegExp);
    }
    for (key in override) {
      if (override.hasOwnProperty(key)) {
        val = override[key];
        if (isHashObject(val)) {
          if (isHashObject(target[key])) {
            updateDeeply(target[key], val);
          } else {
            target[key] = updateDeeply({}, val);
          }
        } else {
          target[key] = val;
        }
      }
    }
    return target;
  }
  function generateNumber(value) {
    var result, point, temp, exponent, pos;
    if (value !== value) {
      throw new Error('Numeric literal whose value is NaN');
    }
    if (1 / value < 0) {
      throw new Error('Numeric literal whose value is negative');
    }
    if (value === 1 / 0) {
      return json ? 'null' : renumber ? '1e400' : '1e+400';
    }
    result = '' + value;
    if (!renumber || result.length < 3) {
      return result;
    }
    point = result.indexOf('.');
    if (!json && result.charAt(0) === '0' && point === 1) {
      point = 0;
      result = result.slice(1);
    }
    temp = result;
    result = result.replace('e+', 'e');
    exponent = 0;
    if ((pos = temp.indexOf('e')) > 0) {
      exponent = +temp.slice(pos + 1);
      temp = temp.slice(0, pos);
    }
    if (point >= 0) {
      exponent -= temp.length - point - 1;
      temp = +(temp.slice(0, point) + temp.slice(point + 1)) + '';
    }
    pos = 0;
    while (temp.charAt(temp.length + pos - 1) === '0') {
      pos -= 1;
    }
    if (pos !== 0) {
      exponent -= pos;
      temp = temp.slice(0, pos);
    }
    if (exponent !== 0) {
      temp += 'e' + exponent;
    }
    if ((temp.length < result.length || hexadecimal && value > 1000000000000 && Math.floor(value) === value && (temp = '0x' + value.toString(16)).length < result.length) && +temp === value) {
      result = temp;
    }
    return result;
  }
  function escapeAllowedCharacter(ch, next) {
    var code = ch.charCodeAt(0), hex = code.toString(16), result = '\\';
    switch (ch) {
    case '\b':
      result += 'b';
      break;
    case '\f':
      result += 'f';
      break;
    case '\t':
      result += 't';
      break;
    default:
      if (json || code > 255) {
        result += 'u' + '0000'.slice(hex.length) + hex;
      } else if (ch === '\0' && '0123456789'.indexOf(next) < 0) {
        result += '0';
      } else if (ch === '\v') {
        result += 'v';
      } else {
        result += 'x' + '00'.slice(hex.length) + hex;
      }
      break;
    }
    return result;
  }
  function escapeDisallowedCharacter(ch) {
    var result = '\\';
    switch (ch) {
    case '\\':
      result += '\\';
      break;
    case '\n':
      result += 'n';
      break;
    case '\r':
      result += 'r';
      break;
    case '\u2028':
      result += 'u2028';
      break;
    case '\u2029':
      result += 'u2029';
      break;
    default:
      throw new Error('Incorrectly classified character');
    }
    return result;
  }
  function escapeString(str) {
    var result = '', i, len, ch, next, singleQuotes = 0, doubleQuotes = 0, single;
    if (typeof str[0] === 'undefined') {
      str = stringToArray(str);
    }
    for (i = 0, len = str.length; i < len; i += 1) {
      ch = str[i];
      if (ch === '\'') {
        singleQuotes += 1;
      } else if (ch === '"') {
        doubleQuotes += 1;
      } else if (ch === '/' && json) {
        result += '\\';
      } else if ('\\\n\r\u2028\u2029'.indexOf(ch) >= 0) {
        result += escapeDisallowedCharacter(ch);
        continue;
      } else if (json && ch < ' ' || !(json || escapeless || ch >= ' ' && ch <= '~')) {
        result += escapeAllowedCharacter(ch, str[i + 1]);
        continue;
      }
      result += ch;
    }
    single = !(quotes === 'double' || quotes === 'auto' && doubleQuotes < singleQuotes);
    str = result;
    result = single ? '\'' : '"';
    if (typeof str[0] === 'undefined') {
      str = stringToArray(str);
    }
    for (i = 0, len = str.length; i < len; i += 1) {
      ch = str[i];
      if (ch === '\'' && single || ch === '"' && !single) {
        result += '\\';
      }
      result += ch;
    }
    return result + (single ? '\'' : '"');
  }
  function isWhiteSpace(ch) {
    return '\t\v\f \xa0'.indexOf(ch) >= 0 || ch.charCodeAt(0) >= 5760 && '\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\ufeff'.indexOf(ch) >= 0;
  }
  function isLineTerminator(ch) {
    return '\n\r\u2028\u2029'.indexOf(ch) >= 0;
  }
  function isIdentifierPart(ch) {
    return ch === '$' || ch === '_' || ch === '\\' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch.charCodeAt(0) >= 128 && Regex.NonAsciiIdentifierPart.test(ch);
  }
  function join(left, right) {
    var leftChar = left.charAt(left.length - 1), rightChar = right.charAt(0);
    if ((leftChar === '+' || leftChar === '-') && leftChar === rightChar || isIdentifierPart(leftChar) && isIdentifierPart(rightChar)) {
      return left + ' ' + right;
    } else if (isWhiteSpace(leftChar) || isLineTerminator(leftChar) || isWhiteSpace(rightChar) || isLineTerminator(rightChar)) {
      return left + right;
    }
    return left + space + right;
  }
  function addIndent(stmt) {
    return base + stmt;
  }
  function calculateSpaces(str) {
    var i;
    for (i = str.length - 1; i >= 0; i -= 1) {
      if (isLineTerminator(str.charAt(i))) {
        break;
      }
    }
    return str.length - 1 - i;
  }
  function adjustMultilineComment(value, specialBase) {
    var array, i, len, line, j, ch, spaces, previousBase;
    array = value.split(/\r\n|[\r\n]/);
    spaces = Number.MAX_VALUE;
    for (i = 1, len = array.length; i < len; i += 1) {
      line = array[i];
      j = 0;
      while (j < line.length && isWhiteSpace(line[j])) {
        j += 1;
      }
      if (spaces > j) {
        spaces = j;
      }
    }
    if (typeof specialBase !== 'undefined') {
      previousBase = base;
      if (array[1][spaces] === '*') {
        specialBase += ' ';
      }
      base = specialBase;
    } else {
      if (spaces % 2 === 1) {
        spaces -= 1;
      }
      previousBase = base;
    }
    for (i = 1, len = array.length; i < len; i += 1) {
      array[i] = addIndent(array[i].slice(spaces));
    }
    base = previousBase;
    return array.join('\n');
  }
  function generateComment(comment, specialBase) {
    if (comment.type === 'Line') {
      if (endsWithLineTerminator(comment.value)) {
        return '//' + comment.value;
      } else {
        return '//' + comment.value + '\n';
      }
    }
    if (extra.format.indent.adjustMultilineComment && /[\n\r]/.test(comment.value)) {
      return adjustMultilineComment('/*' + comment.value + '*/', specialBase);
    }
    return '/*' + comment.value + '*/';
  }
  function addCommentsToStatement(stmt, result) {
    var i, len, comment, save, node, tailingToStatement, specialBase, fragment;
    if (stmt.leadingComments) {
      save = result;
      comment = stmt.leadingComments[0];
      result = generateComment(comment);
      if (!endsWithLineTerminator(result)) {
        result += '\n';
      }
      for (i = 1, len = stmt.leadingComments.length; i < len; i += 1) {
        comment = stmt.leadingComments[i];
        fragment = generateComment(comment);
        if (!endsWithLineTerminator(fragment)) {
          fragment += '\n';
        }
        result += addIndent(fragment);
      }
      result += addIndent(save);
    }
    if (stmt.trailingComments) {
      tailingToStatement = !endsWithLineTerminator(result);
      specialBase = stringRepeat(' ', calculateSpaces(base + result + indent));
      for (i = 0, len = stmt.trailingComments.length; i < len; i += 1) {
        comment = stmt.trailingComments[i];
        if (tailingToStatement) {
          if (i === 0) {
            result += indent;
          } else {
            result += specialBase;
          }
          result += generateComment(comment, specialBase);
        } else {
          result += addIndent(generateComment(comment));
        }
        if (i !== len - 1 && !endsWithLineTerminator(result)) {
          result += '\n';
        }
      }
    }
    return result;
  }
  function parenthesize(text, current, should) {
    if (current < should) {
      return '(' + text + ')';
    }
    return text;
  }
  function maybeBlock(stmt, semicolonOptional) {
    var previousBase, result, noLeadingComment;
    noLeadingComment = !extra.comment || !stmt.leadingComments;
    if (stmt.type === Syntax.BlockStatement && noLeadingComment) {
      return space + generateStatement(stmt);
    }
    if (stmt.type === Syntax.EmptyStatement && noLeadingComment) {
      return ';';
    }
    previousBase = base;
    base += indent;
    result = newline + addIndent(generateStatement(stmt, {
      semicolonOptional: semicolonOptional
    }));
    base = previousBase;
    return result;
  }
  function maybeBlockSuffix(stmt, result) {
    if (stmt.type === Syntax.BlockStatement && (!extra.comment || !stmt.leadingComments) && !endsWithLineTerminator(result)) {
      return space;
    }
    if (endsWithLineTerminator(result)) {
      return addIndent('');
    }
    return (newline === '' ? ' ' : newline) + addIndent('');
  }
  function generateFunctionBody(node) {
    var result, i, len;
    result = '(';
    for (i = 0, len = node.params.length; i < len; i += 1) {
      result += node.params[i].name;
      if (i + 1 < len) {
        result += ',' + space;
      }
    }
    return result + ')' + maybeBlock(node.body);
  }
  function generateExpression(expr, option) {
    var result, precedence, currentPrecedence, previousBase, i, len, raw, fragment, allowIn, allowCall, allowUnparenthesizedNew;
    precedence = option.precedence;
    allowIn = option.allowIn;
    allowCall = option.allowCall;
    switch (expr.type) {
    case Syntax.SequenceExpression:
      result = '';
      allowIn |= Precedence.Sequence < precedence;
      for (i = 0, len = expr.expressions.length; i < len; i += 1) {
        result += generateExpression(expr.expressions[i], {
          precedence: Precedence.Assignment,
          allowIn: allowIn,
          allowCall: true
        });
        if (i + 1 < len) {
          result += ',' + space;
        }
      }
      result = parenthesize(result, Precedence.Sequence, precedence);
      break;
    case Syntax.AssignmentExpression:
      allowIn |= Precedence.Assignment < precedence;
      result = parenthesize(generateExpression(expr.left, {
        precedence: Precedence.Call,
        allowIn: allowIn,
        allowCall: true
      }) + space + expr.operator + space + generateExpression(expr.right, {
        precedence: Precedence.Assignment,
        allowIn: allowIn,
        allowCall: true
      }), Precedence.Assignment, precedence);
      break;
    case Syntax.ConditionalExpression:
      allowIn |= Precedence.Conditional < precedence;
      result = parenthesize(generateExpression(expr.test, {
        precedence: Precedence.LogicalOR,
        allowIn: allowIn,
        allowCall: true
      }) + space + '?' + space + generateExpression(expr.consequent, {
        precedence: Precedence.Assignment,
        allowIn: allowIn,
        allowCall: true
      }) + space + ':' + space + generateExpression(expr.alternate, {
        precedence: Precedence.Assignment,
        allowIn: allowIn,
        allowCall: true
      }), Precedence.Conditional, precedence);
      break;
    case Syntax.LogicalExpression:
    case Syntax.BinaryExpression:
      currentPrecedence = BinaryPrecedence[expr.operator];
      allowIn |= currentPrecedence < precedence;
      result = join(generateExpression(expr.left, {
        precedence: currentPrecedence,
        allowIn: allowIn,
        allowCall: true
      }), expr.operator);
      fragment = generateExpression(expr.right, {
        precedence: currentPrecedence + 1,
        allowIn: allowIn,
        allowCall: true
      });
      if (expr.operator === '/' && result.charAt(result.length - 1) === '/') {
        result += ' ' + fragment;
      } else {
        result = join(result, fragment);
      }
      if (expr.operator === 'in' && !allowIn) {
        result = '(' + result + ')';
      } else {
        result = parenthesize(result, currentPrecedence, precedence);
      }
      break;
    case Syntax.CallExpression:
      result = generateExpression(expr.callee, {
        precedence: Precedence.Call,
        allowIn: true,
        allowCall: true,
        allowUnparenthesizedNew: false
      });
      result += '(';
      for (i = 0, len = expr['arguments'].length; i < len; i += 1) {
        result += generateExpression(expr['arguments'][i], {
          precedence: Precedence.Assignment,
          allowIn: true,
          allowCall: true
        });
        if (i + 1 < len) {
          result += ',' + space;
        }
      }
      result += ')';
      if (!allowCall) {
        result = '(' + result + ')';
      } else {
        result = parenthesize(result, Precedence.Call, precedence);
      }
      break;
    case Syntax.NewExpression:
      len = expr['arguments'].length;
      allowUnparenthesizedNew = option.allowUnparenthesizedNew === undefined || option.allowUnparenthesizedNew;
      result = join('new', generateExpression(expr.callee, {
        precedence: Precedence.New,
        allowIn: true,
        allowCall: false,
        allowUnparenthesizedNew: allowUnparenthesizedNew && !parentheses && len === 0
      }));
      if (!allowUnparenthesizedNew || parentheses || len > 0) {
        result += '(';
        for (i = 0; i < len; i += 1) {
          result += generateExpression(expr['arguments'][i], {
            precedence: Precedence.Assignment,
            allowIn: true,
            allowCall: true
          });
          if (i + 1 < len) {
            result += ',' + space;
          }
        }
        result += ')';
      }
      result = parenthesize(result, Precedence.New, precedence);
      break;
    case Syntax.MemberExpression:
      result = generateExpression(expr.object, {
        precedence: Precedence.Call,
        allowIn: true,
        allowCall: allowCall,
        allowUnparenthesizedNew: false
      });
      if (expr.computed) {
        result += '[' + generateExpression(expr.property, {
          precedence: Precedence.Sequence,
          allowIn: true,
          allowCall: allowCall
        }) + ']';
      } else {
        if (expr.object.type === Syntax.Literal && typeof expr.object.value === 'number') {
          if (result.indexOf('.') < 0) {
            if (!/[eExX]/.test(result) && !(result.length >= 2 && result[0] === '0')) {
              result += '.';
            }
          }
        }
        result += '.' + expr.property.name;
      }
      result = parenthesize(result, Precedence.Member, precedence);
      break;
    case Syntax.UnaryExpression:
      fragment = generateExpression(expr.argument, {
        precedence: Precedence.Unary + (expr.argument.type === Syntax.UnaryExpression && expr.operator.length < 3 && expr.argument.operator === expr.operator ? 1 : 0),
        allowIn: true,
        allowCall: true
      });
      if (space === '') {
        result = join(expr.operator, fragment);
      } else {
        result = expr.operator;
        if (result.length > 2) {
          result += ' ';
        }
        result += fragment;
      }
      result = parenthesize(result, Precedence.Unary, precedence);
      break;
    case Syntax.UpdateExpression:
      if (expr.prefix) {
        result = parenthesize(expr.operator + generateExpression(expr.argument, {
          precedence: Precedence.Unary,
          allowIn: true,
          allowCall: true
        }), Precedence.Unary, precedence);
      } else {
        result = parenthesize(generateExpression(expr.argument, {
          precedence: Precedence.Postfix,
          allowIn: true,
          allowCall: true
        }) + expr.operator, Precedence.Postfix, precedence);
      }
      break;
    case Syntax.FunctionExpression:
      result = 'function';
      if (expr.id) {
        result += ' ' + expr.id.name;
      } else {
        result += space;
      }
      result += generateFunctionBody(expr);
      break;
    case Syntax.ArrayExpression:
      if (!expr.elements.length) {
        result = '[]';
        break;
      }
      result = '[' + newline;
      previousBase = base;
      base += indent;
      for (i = 0, len = expr.elements.length; i < len; i += 1) {
        if (!expr.elements[i]) {
          result += addIndent('');
          if (i + 1 === len) {
            result += ',';
          }
        } else {
          result += addIndent(generateExpression(expr.elements[i], {
            precedence: Precedence.Assignment,
            allowIn: true,
            allowCall: true
          }));
        }
        if (i + 1 < len) {
          result += ',' + newline;
        }
      }
      base = previousBase;
      if (!endsWithLineTerminator(result)) {
        result += newline;
      }
      result += addIndent(']');
      break;
    case Syntax.Property:
      if (expr.kind === 'get' || expr.kind === 'set') {
        result = expr.kind + ' ' + generateExpression(expr.key, {
          precedence: Precedence.Sequence,
          allowIn: true,
          allowCall: true
        }) + generateFunctionBody(expr.value);
      } else {
        result = generateExpression(expr.key, {
          precedence: Precedence.Sequence,
          allowIn: true,
          allowCall: true
        }) + ':' + space + generateExpression(expr.value, {
          precedence: Precedence.Assignment,
          allowIn: true,
          allowCall: true
        });
      }
      break;
    case Syntax.ObjectExpression:
      if (!expr.properties.length) {
        result = '{}';
        break;
      }
      result = '{' + newline;
      previousBase = base;
      base += indent;
      for (i = 0, len = expr.properties.length; i < len; i += 1) {
        result += addIndent(generateExpression(expr.properties[i], {
          precedence: Precedence.Sequence,
          allowIn: true,
          allowCall: true
        }));
        if (i + 1 < len) {
          result += ',' + newline;
        }
      }
      base = previousBase;
      if (!endsWithLineTerminator(result)) {
        result += newline;
      }
      result += addIndent('}');
      break;
    case Syntax.ThisExpression:
      result = 'this';
      break;
    case Syntax.Identifier:
      result = expr.name;
      break;
    case Syntax.Literal:
      if (expr.hasOwnProperty('raw') && parse) {
        try {
          raw = parse(expr.raw).body[0].expression;
          if (raw.type === Syntax.Literal) {
            if (raw.value === expr.value) {
              result = expr.raw;
              break;
            }
          }
        } catch (e) {
        }
      }
      if (expr.value === null) {
        result = 'null';
        break;
      }
      if (typeof expr.value === 'string') {
        result = escapeString(expr.value);
        break;
      }
      if (typeof expr.value === 'number') {
        result = generateNumber(expr.value);
        break;
      }
      result = expr.value.toString();
      break;
    default:
      break;
    }
    if (result === undefined) {
      throw new Error('Unknown expression type: ' + expr.type);
    }
    return result;
  }
  function generateStatement(stmt, option) {
    var i, len, result, previousBase, node, allowIn, fragment, semicolon;
    allowIn = true;
    semicolon = ';';
    if (option) {
      allowIn = option.allowIn === undefined || option.allowIn;
      if (!semicolons && option.semicolonOptional === true) {
        semicolon = '';
      }
    }
    switch (stmt.type) {
    case Syntax.BlockStatement:
      result = '{' + newline;
      previousBase = base;
      base += indent;
      for (i = 0, len = stmt.body.length; i < len; i += 1) {
        fragment = addIndent(generateStatement(stmt.body[i], {
          semicolonOptional: i === len - 1
        }));
        result += fragment;
        if (!endsWithLineTerminator(fragment)) {
          result += newline;
        }
      }
      base = previousBase;
      result += addIndent('}');
      break;
    case Syntax.BreakStatement:
      if (stmt.label) {
        result = 'break ' + stmt.label.name + semicolon;
      } else {
        result = 'break' + semicolon;
      }
      break;
    case Syntax.ContinueStatement:
      if (stmt.label) {
        result = 'continue ' + stmt.label.name + semicolon;
      } else {
        result = 'continue' + semicolon;
      }
      break;
    case Syntax.DoWhileStatement:
      result = join('do', maybeBlock(stmt.body));
      result += maybeBlockSuffix(stmt.body, result);
      result += 'while' + space + '(' + generateExpression(stmt.test, {
        precedence: Precedence.Sequence,
        allowIn: true,
        allowCall: true
      }) + ')' + semicolon;
      break;
    case Syntax.CatchClause:
      previousBase = base;
      base += indent;
      result = 'catch' + space + '(' + generateExpression(stmt.param, {
        precedence: Precedence.Sequence,
        allowIn: true,
        allowCall: true
      }) + ')';
      base = previousBase;
      result += maybeBlock(stmt.body);
      break;
    case Syntax.DebuggerStatement:
      result = 'debugger' + semicolon;
      break;
    case Syntax.EmptyStatement:
      result = ';';
      break;
    case Syntax.ExpressionStatement:
      result = generateExpression(stmt.expression, {
        precedence: Precedence.Sequence,
        allowIn: true,
        allowCall: true
      });
      if (result.charAt(0) === '{' || result.slice(0, 8) === 'function' && ' ('.indexOf(result.charAt(8)) >= 0) {
        result = '(' + result + ')' + semicolon;
      } else {
        result += semicolon;
      }
      break;
    case Syntax.VariableDeclarator:
      if (stmt.init) {
        result = stmt.id.name + space + '=' + space + generateExpression(stmt.init, {
          precedence: Precedence.Assignment,
          allowIn: allowIn,
          allowCall: true
        });
      } else {
        result = stmt.id.name;
      }
      break;
    case Syntax.VariableDeclaration:
      result = stmt.kind;
      if (stmt.declarations.length === 1 && stmt.declarations[0].init && stmt.declarations[0].init.type === Syntax.FunctionExpression) {
        result += ' ' + generateStatement(stmt.declarations[0], {
          allowIn: allowIn
        });
      } else {
        previousBase = base;
        base += indent;
        node = stmt.declarations[0];
        if (extra.comment && node.leadingComments) {
          result += '\n' + addIndent(generateStatement(node, {
            allowIn: allowIn
          }));
        } else {
          result += ' ' + generateStatement(node, {
            allowIn: allowIn
          });
        }
        for (i = 1, len = stmt.declarations.length; i < len; i += 1) {
          node = stmt.declarations[i];
          if (extra.comment && node.leadingComments) {
            result += ',' + newline + addIndent(generateStatement(node, {
              allowIn: allowIn
            }));
          } else {
            result += ',' + space + generateStatement(node, {
              allowIn: allowIn
            });
          }
        }
        base = previousBase;
      }
      result += semicolon;
      break;
    case Syntax.ThrowStatement:
      result = join('throw', generateExpression(stmt.argument, {
        precedence: Precedence.Sequence,
        allowIn: true,
        allowCall: true
      })) + semicolon;
      break;
    case Syntax.TryStatement:
      result = 'try' + maybeBlock(stmt.block);
      result += maybeBlockSuffix(stmt.block, result);
      for (i = 0, len = stmt.handlers.length; i < len; i += 1) {
        result += generateStatement(stmt.handlers[i]);
        if (stmt.finalizer || i + 1 !== len) {
          result += maybeBlockSuffix(stmt.handlers[i].body, result);
        }
      }
      if (stmt.finalizer) {
        result += 'finally' + maybeBlock(stmt.finalizer);
      }
      break;
    case Syntax.SwitchStatement:
      previousBase = base;
      base += indent;
      result = 'switch' + space + '(' + generateExpression(stmt.discriminant, {
        precedence: Precedence.Sequence,
        allowIn: true,
        allowCall: true
      }) + ')' + space + '{' + newline;
      base = previousBase;
      if (stmt.cases) {
        for (i = 0, len = stmt.cases.length; i < len; i += 1) {
          fragment = addIndent(generateStatement(stmt.cases[i], {
            semicolonOptional: i === len - 1
          }));
          result += fragment;
          if (!endsWithLineTerminator(fragment)) {
            result += newline;
          }
        }
      }
      result += addIndent('}');
      break;
    case Syntax.SwitchCase:
      previousBase = base;
      base += indent;
      if (stmt.test) {
        result = join('case', generateExpression(stmt.test, {
          precedence: Precedence.Sequence,
          allowIn: true,
          allowCall: true
        })) + ':';
      } else {
        result = 'default:';
      }
      i = 0;
      len = stmt.consequent.length;
      if (len && stmt.consequent[0].type === Syntax.BlockStatement) {
        fragment = maybeBlock(stmt.consequent[0]);
        result += fragment;
        i = 1;
      }
      if (i !== len && !endsWithLineTerminator(result)) {
        result += newline;
      }
      for (; i < len; i += 1) {
        fragment = addIndent(generateStatement(stmt.consequent[i], {
          semicolonOptional: i === len - 1 && semicolon === ''
        }));
        result += fragment;
        if (i + 1 !== len && !endsWithLineTerminator(fragment)) {
          result += newline;
        }
      }
      base = previousBase;
      break;
    case Syntax.IfStatement:
      previousBase = base;
      base += indent;
      if (stmt.alternate) {
        if (stmt.alternate.type === Syntax.IfStatement) {
          result = 'if' + space + '(' + generateExpression(stmt.test, {
            precedence: Precedence.Sequence,
            allowIn: true,
            allowCall: true
          }) + ')';
          base = previousBase;
          result += maybeBlock(stmt.consequent);
          result += maybeBlockSuffix(stmt.consequent, result);
          result += 'else ' + generateStatement(stmt.alternate);
        } else {
          result = 'if' + space + '(' + generateExpression(stmt.test, {
            precedence: Precedence.Sequence,
            allowIn: true,
            allowCall: true
          }) + ')';
          base = previousBase;
          result += maybeBlock(stmt.consequent);
          result += maybeBlockSuffix(stmt.consequent, result);
          result += 'else';
          result = join(result, maybeBlock(stmt.alternate, semicolon === ''));
        }
      } else {
        result = 'if' + space + '(' + generateExpression(stmt.test, {
          precedence: Precedence.Sequence,
          allowIn: true,
          allowCall: true
        }) + ')';
        base = previousBase;
        result += maybeBlock(stmt.consequent, semicolon === '');
      }
      break;
    case Syntax.ForStatement:
      previousBase = base;
      base += indent;
      result = 'for' + space + '(';
      if (stmt.init) {
        if (stmt.init.type === Syntax.VariableDeclaration) {
          result += generateStatement(stmt.init, {
            allowIn: false
          });
        } else {
          result += generateExpression(stmt.init, {
            precedence: Precedence.Sequence,
            allowIn: false,
            allowCall: true
          }) + ';';
        }
      } else {
        result += ';';
      }
      if (stmt.test) {
        result += space + generateExpression(stmt.test, {
          precedence: Precedence.Sequence,
          allowIn: true,
          allowCall: true
        }) + ';';
      } else {
        result += ';';
      }
      if (stmt.update) {
        result += space + generateExpression(stmt.update, {
          precedence: Precedence.Sequence,
          allowIn: true,
          allowCall: true
        }) + ')';
      } else {
        result += ')';
      }
      base = previousBase;
      result += maybeBlock(stmt.body, semicolon === '');
      break;
    case Syntax.ForInStatement:
      result = 'for' + space + '(';
      if (stmt.left.type === Syntax.VariableDeclaration) {
        previousBase = base;
        base += indent + indent;
        result += stmt.left.kind + ' ' + generateStatement(stmt.left.declarations[0], {
          allowIn: false
        });
        base = previousBase;
      } else {
        previousBase = base;
        base += indent;
        result += generateExpression(stmt.left, {
          precedence: Precedence.Call,
          allowIn: true,
          allowCall: true
        });
        base = previousBase;
      }
      previousBase = base;
      base += indent;
      result = join(result, 'in');
      result = join(result, generateExpression(stmt.right, {
        precedence: Precedence.Sequence,
        allowIn: true,
        allowCall: true
      })) + ')';
      base = previousBase;
      result += maybeBlock(stmt.body, semicolon === '');
      break;
    case Syntax.LabeledStatement:
      result = stmt.label.name + ':' + maybeBlock(stmt.body, semicolon === '');
      break;
    case Syntax.Program:
      result = '';
      for (i = 0, len = stmt.body.length; i < len; i += 1) {
        fragment = addIndent(generateStatement(stmt.body[i], {
          semicolonOptional: i === len - 1
        }));
        result += fragment;
        if (i + 1 < len && !endsWithLineTerminator(fragment)) {
          result += newline;
        }
      }
      break;
    case Syntax.FunctionDeclaration:
      result = 'function' + space;
      if (stmt.id) {
        result += (space === '' ? ' ' : '') + stmt.id.name;
      }
      result += generateFunctionBody(stmt);
      break;
    case Syntax.ReturnStatement:
      if (stmt.argument) {
        result = join('return', generateExpression(stmt.argument, {
          precedence: Precedence.Sequence,
          allowIn: true,
          allowCall: true
        })) + semicolon;
      } else {
        result = 'return' + semicolon;
      }
      break;
    case Syntax.WhileStatement:
      previousBase = base;
      base += indent;
      result = 'while' + space + '(' + generateExpression(stmt.test, {
        precedence: Precedence.Sequence,
        allowIn: true,
        allowCall: true
      }) + ')';
      base = previousBase;
      result += maybeBlock(stmt.body, semicolon === '');
      break;
    case Syntax.WithStatement:
      previousBase = base;
      base += indent;
      result = 'with' + space + '(' + generateExpression(stmt.object, {
        precedence: Precedence.Sequence,
        allowIn: true,
        allowCall: true
      }) + ')';
      base = previousBase;
      result += maybeBlock(stmt.body, semicolon === '');
      break;
    default:
      break;
    }
    if (result === undefined) {
      throw new Error('Unknown statement type: ' + stmt.type);
    }
    if (extra.comment) {
      return addCommentsToStatement(stmt, result);
    }
    return result;
  }
  function generate(node, options) {
    var defaultOptions = getDefaultOptions();
    if (typeof options !== 'undefined') {
      if (typeof options.indent === 'string') {
        defaultOptions.format.indent.style = options.indent;
      }
      if (typeof options.base === 'number') {
        defaultOptions.format.indent.base = options.base;
      }
      options = updateDeeply(defaultOptions, options);
      indent = options.format.indent.style;
      if (typeof options.base === 'string') {
        base = options.base;
      } else {
        base = stringRepeat(indent, options.format.indent.base);
      }
    } else {
      options = defaultOptions;
      indent = options.format.indent.style;
      base = stringRepeat(indent, options.format.indent.base);
    }
    json = options.format.json;
    renumber = options.format.renumber;
    hexadecimal = json ? false : options.format.hexadecimal;
    quotes = json ? 'double' : options.format.quotes;
    escapeless = options.format.escapeless;
    if (options.format.compact) {
      newline = space = indent = base = '';
    } else {
      newline = '\n';
      space = ' ';
    }
    parentheses = options.format.parentheses;
    semicolons = options.format.semicolons;
    parse = json ? null : options.parse;
    extra = options;
    switch (node.type) {
    case Syntax.BlockStatement:
    case Syntax.BreakStatement:
    case Syntax.CatchClause:
    case Syntax.ContinueStatement:
    case Syntax.DoWhileStatement:
    case Syntax.DebuggerStatement:
    case Syntax.EmptyStatement:
    case Syntax.ExpressionStatement:
    case Syntax.ForStatement:
    case Syntax.ForInStatement:
    case Syntax.FunctionDeclaration:
    case Syntax.IfStatement:
    case Syntax.LabeledStatement:
    case Syntax.Program:
    case Syntax.ReturnStatement:
    case Syntax.SwitchStatement:
    case Syntax.SwitchCase:
    case Syntax.ThrowStatement:
    case Syntax.TryStatement:
    case Syntax.VariableDeclaration:
    case Syntax.VariableDeclarator:
    case Syntax.WhileStatement:
    case Syntax.WithStatement:
      return generateStatement(node);
    case Syntax.AssignmentExpression:
    case Syntax.ArrayExpression:
    case Syntax.BinaryExpression:
    case Syntax.CallExpression:
    case Syntax.ConditionalExpression:
    case Syntax.FunctionExpression:
    case Syntax.Identifier:
    case Syntax.Literal:
    case Syntax.LogicalExpression:
    case Syntax.MemberExpression:
    case Syntax.NewExpression:
    case Syntax.ObjectExpression:
    case Syntax.Property:
    case Syntax.SequenceExpression:
    case Syntax.ThisExpression:
    case Syntax.UnaryExpression:
    case Syntax.UpdateExpression:
      return generateExpression(node, {
        precedence: Precedence.Sequence,
        allowIn: true,
        allowCall: true
      });
    default:
      break;
    }
    throw new Error('Unknown node type: ' + node.type);
  }
  VisitorKeys = {
    AssignmentExpression: [
      'left',
      'right'
    ],
    ArrayExpression: [
      'elements'
    ],
    BlockStatement: [
      'body'
    ],
    BinaryExpression: [
      'left',
      'right'
    ],
    BreakStatement: [
      'label'
    ],
    CallExpression: [
      'callee',
      'arguments'
    ],
    CatchClause: [
      'param',
      'body'
    ],
    ConditionalExpression: [
      'test',
      'consequent',
      'alternate'
    ],
    ContinueStatement: [
      'label'
    ],
    DoWhileStatement: [
      'body',
      'test'
    ],
    DebuggerStatement: [],
    EmptyStatement: [],
    ExpressionStatement: [
      'expression'
    ],
    ForStatement: [
      'init',
      'test',
      'update',
      'body'
    ],
    ForInStatement: [
      'left',
      'right',
      'body'
    ],
    FunctionDeclaration: [
      'id',
      'params',
      'body'
    ],
    FunctionExpression: [
      'id',
      'params',
      'body'
    ],
    Identifier: [],
    IfStatement: [
      'test',
      'consequent',
      'alternate'
    ],
    Literal: [],
    LabeledStatement: [
      'label',
      'body'
    ],
    LogicalExpression: [
      'left',
      'right'
    ],
    MemberExpression: [
      'object',
      'property'
    ],
    NewExpression: [
      'callee',
      'arguments'
    ],
    ObjectExpression: [
      'properties'
    ],
    Program: [
      'body'
    ],
    Property: [
      'key',
      'value'
    ],
    ReturnStatement: [
      'argument'
    ],
    SequenceExpression: [
      'expressions'
    ],
    SwitchStatement: [
      'descriminant',
      'cases'
    ],
    SwitchCase: [
      'test',
      'consequent'
    ],
    ThisExpression: [],
    ThrowStatement: [
      'argument'
    ],
    TryStatement: [
      'block',
      'handlers',
      'finalizer'
    ],
    UnaryExpression: [
      'argument'
    ],
    UpdateExpression: [
      'argument'
    ],
    VariableDeclaration: [
      'declarations'
    ],
    VariableDeclarator: [
      'id',
      'init'
    ],
    WhileStatement: [
      'test',
      'body'
    ],
    WithStatement: [
      'object',
      'body'
    ],
    PointerType: [
      'base'
    ],
    StructType: [
      'id',
      'fields'
    ],
    FieldDeclarator: [
      'id',
      'decltype'
    ],
    ArrowType: [
      'params',
      'return'
    ],
    TypeIdentifier: [],
    TypeAliasDirective: [
      'original',
      'alias'
    ],
    CastExpression: [
      'as',
      'argument'
    ]
  };
  VisitorOption = {
    Break: 1,
    Skip: 2
  };
  function traverse(top, visitor) {
    var worklist, leavelist, node, ret, current, current2, candidates, candidate;
    worklist = [
      top
    ];
    leavelist = [];
    while (worklist.length) {
      node = worklist.pop();
      if (node) {
        if (visitor.enter) {
          ret = visitor.enter(node);
        } else {
          ret = undefined;
        }
        if (ret === VisitorOption.Break) {
          return;
        }
        worklist.push(null);
        leavelist.push(node);
        if (ret !== VisitorOption.Skip) {
          candidates = VisitorKeys[node.type];
          current = candidates.length;
          while ((current -= 1) >= 0) {
            candidate = node[candidates[current]];
            if (candidate) {
              if (isArray(candidate)) {
                current2 = candidate.length;
                while ((current2 -= 1) >= 0) {
                  if (candidate[current2]) {
                    worklist.push(candidate[current2]);
                  }
                }
              } else {
                worklist.push(candidate);
              }
            }
          }
        }
      } else {
        node = leavelist.pop();
        if (visitor.leave) {
          ret = visitor.leave(node);
        } else {
          ret = undefined;
        }
        if (ret === VisitorOption.Break) {
          return;
        }
      }
    }
  }
  function upperBound(array, func) {
    var diff, len, i, current;
    len = array.length;
    i = 0;
    while (len) {
      diff = len >>> 1;
      current = i + diff;
      if (func(array[current])) {
        len = diff;
      } else {
        i = current + 1;
        len -= diff + 1;
      }
    }
    return i;
  }
  function lowerBound(array, func) {
    var diff, len, i, current;
    len = array.length;
    i = 0;
    while (len) {
      diff = len >>> 1;
      current = i + diff;
      if (func(array[current])) {
        i = current + 1;
        len -= diff + 1;
      } else {
        len = diff;
      }
    }
    return i;
  }
  function extendCommentRange(comment, tokens) {
    var target, token;
    target = upperBound(tokens, function search(token) {
      return token.range[0] > comment.range[0];
    });
    comment.extendedRange = [
      comment.range[0],
      comment.range[1]
    ];
    if (target !== tokens.length) {
      comment.extendedRange[1] = tokens[target].range[0];
    }
    target -= 1;
    if (target >= 0) {
      if (target < tokens.length) {
        comment.extendedRange[0] = tokens[target].range[1];
      } else if (token.length) {
        comment.extendedRange[1] = tokens[tokens.length - 1].range[0];
      }
    }
    return comment;
  }
  function attachComments(tree, providedComments, tokens) {
    var comments = [], comment, len, i;
    if (!tree.range) {
      throw new Error('attachComments needs range information');
    }
    if (!tokens.length) {
      if (providedComments.length) {
        for (i = 0, len = providedComments.length; i < len; i += 1) {
          comment = deepCopy(providedComments[i]);
          comment.extendedRange = [
            0,
            tree.range[0]
          ];
          comments.push(comment);
        }
        tree.leadingComments = comments;
      }
      return tree;
    }
    for (i = 0, len = providedComments.length; i < len; i += 1) {
      comments.push(extendCommentRange(deepCopy(providedComments[i]), tokens));
    }
    traverse(tree, {
      cursor: 0,
      enter: function (node) {
        var comment;
        while (this.cursor < comments.length) {
          comment = comments[this.cursor];
          if (comment.extendedRange[1] > node.range[0]) {
            break;
          }
          if (comment.extendedRange[1] === node.range[0]) {
            if (!node.leadingComments) {
              node.leadingComments = [];
            }
            node.leadingComments.push(comment);
            comments.splice(this.cursor, 1);
          } else {
            this.cursor += 1;
          }
        }
        if (this.cursor === comments.length) {
          return VisitorOption.Break;
        }
        if (comments[this.cursor].extendedRange[0] > node.range[1]) {
          return VisitorOption.Skip;
        }
      }
    });
    traverse(tree, {
      cursor: 0,
      leave: function (node) {
        var comment;
        while (this.cursor < comments.length) {
          comment = comments[this.cursor];
          if (node.range[1] < comment.extendedRange[0]) {
            break;
          }
          if (node.range[1] === comment.extendedRange[0]) {
            if (!node.trailingComments) {
              node.trailingComments = [];
            }
            node.trailingComments.push(comment);
            comments.splice(this.cursor, 1);
          } else {
            this.cursor += 1;
          }
        }
        if (this.cursor === comments.length) {
          return VisitorOption.Break;
        }
        if (comments[this.cursor].extendedRange[0] > node.range[1]) {
          return VisitorOption.Skip;
        }
      }
    });
    return tree;
  }
  exports.version = '0.0.6-dev';
  exports.generate = generate;
  exports.traverse = traverse;
  exports.attachComments = attachComments;
}(typeof exports === 'undefined' ? escodegen = {} : exports));
var verifierOptions = systemOptions.register(new OptionSet('Verifier Options'));
var verifierTraceLevel = verifierOptions.register(new Option('tv', 'tv', 'number', 0, 'Verifier Trace Level'));
var Type = function () {
    function type() {
      unexpected('Type is Abstract');
    }
    type.prototype.equals = function (other) {
      return this === other;
    };
    type.prototype.merge = function (other) {
      unexpected('Merging ' + this + ' with ' + other);
    };
    type.cache = {
      name: {},
      classInfo: [],
      instanceInfo: [],
      scriptInfo: [],
      methodInfo: []
    };
    type.from = function from(x, domain) {
      var traitsTypeCache = null;
      if (x instanceof ClassInfo) {
        traitsTypeCache = type.cache.classInfo;
      } else if (x instanceof InstanceInfo) {
        traitsTypeCache = type.cache.instanceInfo;
      } else if (x instanceof ScriptInfo) {
        traitsTypeCache = type.cache.scriptInfo;
      }
      if (traitsTypeCache) {
        return traitsTypeCache[x.id] || (traitsTypeCache[x.id] = new TraitsType(x, domain));
      }
      if (x instanceof Activation) {
        return new TraitsType(x.methodInfo);
      } else if (x instanceof Global) {
        return new TraitsType(x.scriptInfo);
      } else if (x instanceof Interface) {
        return new TraitsType(x.classInfo, domain);
      } else if (x instanceof MethodInfo) {
        return new MethodType(x);
      } else if (domain && x instanceof Class) {
        return type.from(x.classInfo, domain);
      }
      return Type.Any;
    };
    type.fromSimpleName = function (name, domain) {
      return Type.fromName(Multiname.fromSimpleName(name), domain);
    };
    type.fromName = function fromName(mn, domain) {
      if (mn === undefined) {
        return Type.Undefined;
      } else {
        var qn = Multiname.isQName(mn) ? Multiname.getFullQualifiedName(mn) : undefined;
        if (qn) {
          var ty = type.cache.name[qn];
          if (ty) {
            return ty;
          }
        }
        if (qn === Multiname.getPublicQualifiedName('void')) {
          return Type.Void;
        }
        true;
        ty = domain.findClassInfo(mn);
        ty = ty ? type.from(ty, domain) : Type.Any;
        if (mn.hasTypeParameter()) {
          ty = new ParameterizedType(ty, type.fromName(mn.typeParameter, domain));
        }
        return type.cache.name[qn] = ty;
      }
    };
    type.prototype.applyType = function (parameter) {
      return new ParameterizedType(this, parameter);
    };
    type.prototype.toString = function () {
      return '[type]';
    };
    type.prototype.isNumeric = function () {
      return this === Type.Int || this === Type.Uint || this === Type.Number;
    };
    type.prototype.isString = function () {
      return this === Type.String;
    };
    type.prototype.isDirectlyReadable = function () {
      return this === Type.Array;
    };
    type.prototype.isIndexedReadable = function () {
      return this.isParameterizedType();
    };
    type.prototype.isDirectlyWriteable = function () {
      return this === Type.Array;
    };
    type.prototype.isIndexedWriteable = function () {
      return this.isParameterizedType();
    };
    type.prototype.isVector = function () {
      return this.isParameterizedType();
    };
    type.prototype.isNotDirectlyIndexable = function () {
      return this === Type.Any || this === Type.XML || this === Type.XMLList || this === Type.Dictionary;
    };
    type.prototype.isParameterizedType = function () {
      return this instanceof ParameterizedType;
    };
    type.prototype.instanceType = function () {
      return this;
    };
    type.prototype.getTrait = function () {
      return null;
    };
    type.prototype.super = function () {
      unexpected('Can\'t call super on ' + this);
    };
    type.prototype.isSubtypeOf = function (other) {
      if (this === other || this.equals(other)) {
        return true;
      }
      return this.merge(other) === this;
    };
    var typesInitialized = false;
    type.initializeTypes = function (domain) {
      if (typesInitialized) {
        return;
      }
      type.Any = new AtomType('Any');
      type.Null = new AtomType('Null');
      type.Undefined = new AtomType('Undefined');
      type.Void = new AtomType('Void');
      type.Int = Type.fromSimpleName('int', domain).instanceType();
      type.Uint = Type.fromSimpleName('uint', domain).instanceType();
      type.Class = Type.fromSimpleName('Class', domain).instanceType();
      type.Array = Type.fromSimpleName('Array', domain).instanceType();
      type.Object = Type.fromSimpleName('Object', domain).instanceType();
      type.String = Type.fromSimpleName('String', domain).instanceType();
      type.Number = Type.fromSimpleName('Number', domain).instanceType();
      type.Boolean = Type.fromSimpleName('Boolean', domain).instanceType();
      type.Function = Type.fromSimpleName('Function', domain).instanceType();
      type.XML = Type.fromSimpleName('XML', domain).instanceType();
      type.XMLList = Type.fromSimpleName('XMLList', domain).instanceType();
      type.Dictionary = Type.fromSimpleName('flash.utils.Dictionary', domain).instanceType();
      typesInitialized = true;
    };
    return type;
  }();
var AtomType = function () {
    function atomType(name) {
      this.name = name;
    }
    atomType.prototype = Object.create(Type.prototype);
    atomType.prototype.toString = function () {
      if (this === Type.Any) {
        return '?';
      } else if (this === Type.Undefined) {
        return '_';
      } else if (this === Type.Null) {
        return 'X';
      } else if (this === Type.Void) {
        return 'V';
      }
      unexpected();
    };
    atomType.prototype.merge = function merge(other) {
      if (other instanceof TraitsType) {
        return Type.Any;
      }
      if (this === other) {
        return this;
      }
      if (this === Type.Any || other === Type.Any) {
        return Type.Any;
      }
      return Type.Any;
    };
    return atomType;
  }();
var MethodType = function () {
    function methodType(methodInfo) {
      this.methodInfo = methodInfo;
    }
    methodType.prototype = Object.create(Type.prototype);
    methodType.prototype.toString = function () {
      return 'MT ' + this.methodInfo;
    };
    return methodType;
  }();
var TraitsType = function () {
    function traitsType(object, domain) {
      true;
      this.object = object;
      this.traits = object.traits;
      this.domain = domain;
      if (this.object instanceof InstanceInfo) {
        true;
      }
    }
    traitsType.prototype = Object.create(Type.prototype);
    function nameOf(x) {
      if (x instanceof ScriptInfo) {
        return 'SI';
      } else if (x instanceof ClassInfo) {
        return 'CI:' + x.instanceInfo.name.name;
      } else if (x instanceof InstanceInfo) {
        return 'II:' + x.name.name;
      } else if (x instanceof MethodInfo) {
        return 'MI';
      } else if (x instanceof Activation) {
        return 'AC';
      }
      true;
    }
    function findTraitBySlotId(traits, slotId) {
      for (var i = traits.length - 1; i >= 0; i--) {
        if (traits[i].slotId === slotId) {
          return traits[i];
        }
      }
      unexpected('Cannot find trait with slotId: ' + slotId + ' in ' + traits);
    }
    function findTraitByName(traits, mn, isSetter) {
      var isGetter = !isSetter;
      var trait;
      if (!Multiname.isQName(mn)) {
        if (mn instanceof MultinameType) {
          return;
        }
        true;
        var dy;
        for (var i = 0, j = mn.namespaces.length; i < j; i++) {
          var qn = mn.getQName(i);
          if (mn.namespaces[i].isDynamic()) {
            dy = qn;
          } else {
            if (trait = findTraitByName(traits, qn, isSetter)) {
              return trait;
            }
          }
        }
        if (dy) {
          return findTraitByName(traits, dy, isSetter);
        }
      } else {
        var qn = Multiname.getQualifiedName(mn);
        for (var i = 0, j = traits.length; i < j; i++) {
          trait = traits[i];
          if (Multiname.getQualifiedName(trait.name) === qn) {
            if (isSetter && trait.isGetter() || isGetter && trait.isSetter()) {
              continue;
            }
            return trait;
          }
        }
      }
    }
    traitsType.prototype.getTrait = function (mn, isSetter, followSuperType) {
      if (mn instanceof MultinameType) {
        return null;
      }
      if (followSuperType && (this.isInstanceInfo() || this.isClassInfo())) {
        var that = this;
        do {
          var trait = that.getTrait(mn, isSetter, false);
          if (!trait) {
            that = that.super();
          }
        } while (!trait && that);
        return trait;
      } else {
        return findTraitByName(this.traits, mn, isSetter);
      }
    };
    traitsType.prototype.getTraitAt = function (i) {
      if (this.object instanceof ScriptInfo || this.object instanceof MethodInfo) {
        return findTraitBySlotId(this.traits, i);
      }
    };
    traitsType.prototype.toString = function () {
      switch (this) {
      case Type.Int:
        return 'I';
      case Type.Uint:
        return 'U';
      case Type.Array:
        return 'A';
      case Type.Object:
        return 'O';
      case Type.String:
        return 'S';
      case Type.Number:
        return 'N';
      case Type.Boolean:
        return 'B';
      case Type.Function:
        return 'F';
      }
      return nameOf(this.object);
    };
    traitsType.prototype.instanceType = function () {
      true;
      return this.instanceCache || (this.instanceCache = Type.from(this.object.instanceInfo, this.domain));
    };
    traitsType.prototype.classType = function () {
      true;
      return this.instanceCache || (this.instanceCache = Type.from(this.object.classInfo, this.domain));
    };
    traitsType.prototype.super = function () {
      if (this.object instanceof ClassInfo) {
        return Type.Class;
      }
      true;
      if (this.object.superName) {
        var result = Type.fromName(this.object.superName, this.domain).instanceType();
        true;
        return result;
      }
      return null;
    };
    traitsType.prototype.isClassInfo = function () {
      return this.object instanceof ClassInfo;
    };
    traitsType.prototype.isInstanceInfo = function () {
      return this.object instanceof InstanceInfo;
    };
    traitsType.prototype.isInstanceOrClassInfo = function () {
      return this.isInstanceInfo() || this.isClassInfo();
    };
    traitsType.prototype.equals = function (other) {
      return this.traits === other.traits;
    };
    traitsType.prototype.merge = function (other) {
      if (other instanceof TraitsType) {
        if (this.equals(other)) {
          return this;
        }
        if (this.isNumeric() && other.isNumeric()) {
          return Type.Number;
        }
        if (this.isInstanceInfo() && other.isInstanceInfo()) {
          var path = [];
          for (var curr = this; curr; curr = curr.super()) {
            path.push(curr);
          }
          for (var curr = other; curr; curr = curr.super()) {
            for (var i = 0; i < path.length; i++) {
              if (path[i].equals(curr)) {
                return curr;
              }
            }
          }
          return Type.Object;
        }
      }
      return Type.Any;
    };
    return traitsType;
  }();
var MultinameType = function () {
    function multinameType(namespaces, name, flags) {
      this.namespaces = namespaces;
      this.name = name;
      this.flags = flags;
    }
    multinameType.prototype = Object.create(Type.prototype);
    multinameType.prototype.toString = function () {
      return 'MN';
    };
    return multinameType;
  }();
var ParameterizedType = function () {
    function parameterizedType(type, parameter) {
      this.type = type;
      this.parameter = parameter;
    }
    parameterizedType.prototype = Object.create(Type.prototype);
    parameterizedType.prototype.toString = function () {
      return this.type + '<' + this.parameter + '>';
    };
    parameterizedType.prototype.instanceType = function () {
      true;
      return new ParameterizedType(this.type.instanceType(), this.parameter.instanceType());
    };
    parameterizedType.prototype.equals = function (other) {
      if (other instanceof ParameterizedType) {
        return this.type.equals(other.type) && this.parameter.equals(other.parameter);
      }
      return false;
    };
    parameterizedType.prototype.merge = function (other) {
      if (other instanceof TraitsType) {
        if (this.equals(other)) {
          return this;
        }
      }
      return Type.Any;
    };
    return parameterizedType;
  }();
var TypeInformation = function () {
    function typeInformation() {
    }
    typeInformation.prototype.toString = function () {
      return toKeyValueArray(this).map(function (x) {
        return x[0] + ': ' + x[1];
      }).join(' | ');
    };
    return typeInformation;
  }();
var Verifier = function () {
    function VerifierError(message) {
      this.name = 'VerifierError';
      this.message = message || '';
    }
    var State = function () {
        var id = 0;
        function state() {
          this.id = id += 1;
          this.stack = [];
          this.scope = [];
          this.local = [];
        }
        state.prototype.clone = function clone() {
          var s = new State();
          s.originalId = this.id;
          s.stack = this.stack.slice(0);
          s.scope = this.scope.slice(0);
          s.local = this.local.slice(0);
          return s;
        };
        state.prototype.trace = function trace(writer) {
          writer.writeLn(this.toString());
        };
        state.prototype.toString = function () {
          return '<' + this.id + (this.originalId ? ':' + this.originalId : '') + ', L[' + this.local.join(', ') + ']' + ', S[' + this.stack.join(', ') + ']' + ', $[' + this.scope.join(', ') + ']>';
        };
        state.prototype.equals = function (other) {
          return arrayEquals(this.stack, other.stack) && arrayEquals(this.scope, other.scope) && arrayEquals(this.local, other.local);
        };
        function arrayEquals(a, b) {
          if (a.length != b.length) {
            return false;
          }
          for (var i = a.length - 1; i >= 0; i--) {
            if (!a[i].equals(b[i])) {
              return false;
            }
          }
          return true;
        }
        state.prototype.isSubset = function (other) {
          return arraySubset(this.stack, other.stack) && arraySubset(this.scope, other.scope) && arraySubset(this.local, other.local);
        };
        function arraySubset(a, b) {
          if (a.length != b.length) {
            return false;
          }
          for (var i = a.length - 1; i >= 0; i--) {
            if (a[i] === b[i] || a[i].equals(b[i])) {
              continue;
            }
            if (a[i].merge(b[i]) !== a[i]) {
              return false;
            }
          }
          return true;
        }
        state.prototype.merge = function (other) {
          mergeArrays(this.local, other.local);
          mergeArrays(this.stack, other.stack);
          mergeArrays(this.scope, other.scope);
        };
        function mergeArrays(a, b) {
          true;
          for (var i = a.length - 1; i >= 0; i--) {
            true;
            if (a[i] === b[i]) {
              continue;
            }
            a[i] = a[i].merge(b[i]);
          }
        }
        return state;
      }();
    var Verification = function () {
        function verification(methodInfo, scope) {
          this.scope = scope;
          this.methodInfo = methodInfo;
          this.domain = methodInfo.abc.domain;
          this.writer = new IndentingWriter();
          this.returnType = Type.Undefined;
        }
        verification.prototype.verify = function verify() {
          var mi = this.methodInfo;
          var writer = verifierTraceLevel.value ? this.writer : null;
          var blocks = mi.analysis.blocks;
          blocks.forEach(function (x) {
            x.entryState = x.exitState = null;
          });
          if (writer) {
            this.methodInfo.trace(writer);
          }
          var entryState = new State();
          true;
          this.thisType = mi.holder ? Type.from(mi.holder, this.domain) : Type.Any;
          entryState.local.push(this.thisType);
          for (var i = 0; i < mi.parameters.length; i++) {
            entryState.local.push(Type.fromName(mi.parameters[i].type, this.domain).instanceType());
          }
          var remainingLocals = mi.localCount - mi.parameters.length - 1;
          if (mi.needsRest() || mi.needsArguments()) {
            entryState.local.push(Type.Array);
            remainingLocals -= 1;
          }
          for (var i = 0; i < remainingLocals; i++) {
            entryState.local.push(Type.Undefined);
          }
          true;
          if (writer) {
            entryState.trace(writer);
          }
          for (var bi = 0, len = blocks.length; bi < len; bi++) {
            blocks[bi].bdo = bi;
          }
          var worklist = new SortedList(function compare(blockA, blockB) {
              return blockA.bdo - blockB.bdo;
            });
          blocks[0].entryState = entryState;
          worklist.push(blocks[0]);
          while (worklist.peek()) {
            var block = worklist.pop();
            var exitState = block.exitState = block.entryState.clone();
            this.verifyBlock(block, exitState);
            block.succs.forEach(function (successor) {
              if (worklist.contains(successor)) {
                if (writer) {
                  writer.writeLn('Forward Merged Block: ' + successor.bid + ' ' + exitState.toString() + ' with ' + successor.entryState.toString());
                }
                successor.entryState.merge(exitState);
                if (writer) {
                  writer.writeLn('Merged State: ' + successor.entryState);
                }
                return;
              }
              if (successor.entryState) {
                if (!successor.entryState.isSubset(exitState)) {
                  if (writer) {
                    writer.writeLn('Backward Merged Block: ' + block.bid + ' with ' + successor.bid + ' ' + exitState.toString() + ' with ' + successor.entryState.toString());
                  }
                  successor.entryState.merge(exitState);
                  worklist.push(successor);
                  if (writer) {
                    writer.writeLn('Merged State: ' + successor.entryState);
                  }
                }
                return;
              }
              successor.entryState = exitState.clone();
              worklist.push(successor);
              if (writer) {
                writer.writeLn('Added Block: ' + successor.bid + ' to worklist: ' + successor.entryState.toString());
              }
            });
          }
          if (writer) {
            writer.writeLn('Inferred return type: ' + this.returnType);
          }
          this.methodInfo.inferredReturnType = this.returnType;
        };
        verification.prototype.verifyBlock = function verifyBlock(block, state) {
          var savedScope = this.scope;
          var local = state.local;
          var stack = state.stack;
          var scope = state.scope;
          var writer = verifierTraceLevel.value ? this.writer : null;
          var bytecodes = this.methodInfo.analysis.bytecodes;
          var domain = this.methodInfo.abc.domain;
          var multinames = this.methodInfo.abc.constantPool.multinames;
          var mi = this.methodInfo;
          var bc, obj, fn, mn, l, r, val, type, returnType;
          if (writer) {
            writer.enter('verifyBlock: ' + block.bid + ', range: [' + block.position + ', ' + block.end.position + '], entryState: ' + state.toString() + ' {');
          }
          function construct(obj) {
            if (obj instanceof TraitsType || obj instanceof ParameterizedType) {
              if (obj === Type.Function || obj === Type.Class || obj === Type.Object) {
                return Type.Object;
              }
              return obj.instanceType();
            } else {
              return Type.Any;
            }
          }
          function ti() {
            return bc.ti || (bc.ti = new TypeInformation());
          }
          function push(x) {
            true;
            ti().type = x;
            stack.push(x);
          }
          function pop() {
            return stack.pop();
          }
          function findProperty(mn, strict) {
            if (mn instanceof MultinameType) {
              return Type.Any;
            }
            for (var i = scope.length - 1; i >= 0; i--) {
              if (scope[i] instanceof TraitsType) {
                var trait = scope[i].getTrait(mn, false, true);
                if (trait) {
                  ti().scopeDepth = scope.length - i - 1;
                  return scope[i];
                }
              } else {
                return Type.Any;
              }
            }
            if (isClassOrInstanceInfo(mi.holder)) {
              var classType;
              if (mi.holder instanceof ClassInfo) {
                classType = Type.from(mi.holder, domain);
              } else if (mi.holder instanceof InstanceInfo) {
                classType = Type.from(mi.holder, domain).classType();
              }
              var trait = classType.getTrait(mn, false, true);
              if (trait) {
                ti().object = LazyInitializer.create(classType.object);
                return classType;
              }
            }
            if (savedScope && savedScope.object && mn instanceof Multiname) {
              var obj = savedScope.findScopeProperty(mn.namespaces, mn.name, mn.flags, domain, strict, true);
              if (obj) {
                var savedScopeDepth = savedScope.findDepth(obj);
                true;
                ti().scopeDepth = savedScopeDepth + scope.length;
                return Type.from(obj, domain);
              }
            }
            var resolved = domain.findDefiningScript(mn, false);
            if (resolved) {
              ti().object = LazyInitializer.create(resolved.script);
              return Type.from(resolved.script, domain);
            }
            return Type.Any;
          }
          function popMultiname() {
            var mn = multinames[bc.index];
            if (mn.isRuntime()) {
              var namespaces = mn.namespaces;
              var name = mn.name;
              if (mn.isRuntimeName()) {
                name = pop();
              }
              if (mn.isRuntimeNamespace()) {
                namespaces = [
                  pop()
                ];
              }
              return new MultinameType(namespaces, name, mn.flags);
            }
            return mn;
          }
          function accessSlot(obj) {
            if (obj instanceof TraitsType) {
              var trait = obj.getTraitAt(bc.index);
              writer && writer.debugLn('accessSlot() -> ' + trait);
              if (trait) {
                ti().trait = trait;
                if (trait.isSlot()) {
                  return Type.fromName(trait.typeName, domain).instanceType();
                } else if (trait.isClass()) {
                  return Type.from(trait.classInfo, domain);
                }
              }
            }
            return Type.Any;
          }
          function isNumericMultiname(mn) {
            return mn instanceof Multiname && isNumeric(mn.name) || mn instanceof MultinameType && (mn.name instanceof TraitsType && mn.name.isNumeric() || isNumeric(mn.name));
          }
          function getProperty(obj, mn) {
            if (obj instanceof TraitsType || obj instanceof ParameterizedType) {
              var trait = obj.getTrait(mn, false, true);
              writer && writer.debugLn('getProperty(' + mn + ') -> ' + trait);
              if (trait) {
                ti().trait = trait;
                if (trait.isSlot() || trait.isConst()) {
                  return Type.fromName(trait.typeName, domain).instanceType();
                } else if (trait.isGetter()) {
                  return Type.fromName(trait.methodInfo.returnType, domain).instanceType();
                } else if (trait.isClass()) {
                  return Type.from(trait.classInfo, domain);
                } else if (trait.isMethod()) {
                  return Type.from(trait.methodInfo, domain);
                }
              } else if (obj.isDirectlyReadable() && mn instanceof Multiname) {
                ti().propertyQName = Multiname.getPublicQualifiedName(mn.name);
              } else if (obj === Type.Object && mn instanceof Multiname) {
                ti().propertyQName = Multiname.getPublicQualifiedName(mn.name);
              }
              if (isNumericMultiname(mn)) {
                if (obj.isIndexedReadable()) {
                  ti().isIndexedReadable = true;
                  if (obj.isVector()) {
                    return obj.parameter;
                  }
                } else if (obj.isDirectlyReadable()) {
                  ti().isDirectlyReadable = true;
                }
              }
            }
            return Type.Any;
          }
          function setProperty(obj, mn, value) {
            if (obj instanceof TraitsType || obj instanceof ParameterizedType) {
              var trait = obj.getTrait(mn, true, true);
              writer && writer.debugLn('setProperty(' + mn + ') -> ' + trait);
              if (trait) {
                ti().trait = trait;
              } else if (obj.isDirectlyWriteable() && mn instanceof Multiname) {
                ti().propertyQName = Multiname.getPublicQualifiedName(mn.name);
              }
              if (isNumericMultiname(mn)) {
                if (obj.isDirectlyWriteable()) {
                  ti().isDirectlyWriteable = true;
                } else if (obj.isVector()) {
                  ti().isIndexedWriteable = true;
                }
              }
            }
          }
          for (var bci = block.position, end = block.end.position; bci <= end; bci++) {
            bc = bytecodes[bci];
            var op = bc.op;
            if (writer && verifierTraceLevel.value > 1) {
              writer.writeLn(('stateBefore: ' + state.toString()).padRight(' ', 100) + ' : ' + bci + ', ' + bc.toString(mi.abc));
            }
            switch (op) {
            case 1:
              break;
            case 3:
              pop();
              break;
            case 4:
              mn = popMultiname();
              obj = pop();
              true;
              push(getProperty(obj.super(), mn));
              break;
            case 5:
              val = pop();
              mn = popMultiname();
              obj = pop();
              true;
              setProperty(obj.super(), mn, val);
              break;
            case 6:
              notImplemented(bc);
              break;
            case 7:
              notImplemented(bc);
              break;
            case 8:
              state.local[bc.index] = Type.Undefined;
              break;
            case 10:
              notImplemented(bc);
              break;
            case 11:
              notImplemented(bc);
              break;
            case 12:
            case 24:
            case 13:
            case 23:
            case 14:
            case 22:
            case 15:
            case 21:
            case 19:
            case 20:
            case 25:
            case 26:
              pop();
              pop();
              break;
            case 16:
              break;
            case 17:
            case 18:
              pop();
              break;
            case 27:
              pop(Type.Int);
              break;
            case 29:
              scope.pop();
              break;
            case 30:
            case 35:
              pop(Type.Int);
              pop();
              push(Type.Any);
              break;
            case 31:
              push(Type.Boolean);
              break;
            case 50:
              push(Type.Boolean);
              break;
            case 32:
              push(Type.Null);
              break;
            case 33:
              push(Type.Undefined);
              break;
            case 34:
              notImplemented(bc);
              break;
            case 36:
              push(Type.Int);
              break;
            case 37:
              push(Type.Int);
              break;
            case 44:
              push(Type.String);
              break;
            case 45:
              push(Type.Int);
              break;
            case 46:
              push(Type.Uint);
              break;
            case 47:
              push(Type.Number);
              break;
            case 38:
              push(Type.Boolean);
              break;
            case 39:
              push(Type.Boolean);
              break;
            case 40:
              push(Type.Number);
              break;
            case 41:
              pop();
              break;
            case 42:
              val = pop();
              push(val);
              push(val);
              break;
            case 43:
              l = pop();
              r = pop();
              push(l);
              push(r);
              break;
            case 28:
              pop();
              scope.push(Type.Any);
              break;
            case 48:
              scope.push(pop());
              break;
            case 49:
              notImplemented(bc);
              break;
            case 53:
            case 54:
            case 55:
              push(Type.Int);
              break;
            case 56:
            case 57:
              push(Type.Number);
              break;
            case 58:
            case 59:
            case 60:
              pop(Type.Int);
              break;
            case 61:
            case 62:
              pop(Type.Number);
              break;
            case 64:
              push(Type.Function);
              break;
            case 65:
              stack.popMany(bc.argCount);
              obj = pop();
              fn = pop();
              push(Type.Any);
              break;
            case 67:
              throw new VerifierError('callmethod');
            case 68:
              notImplemented(bc);
              break;
            case 69:
              stack.popMany(bc.argCount);
              mn = popMultiname();
              obj = pop();
              getProperty(obj, mn);
              push(Type.Any);
              break;
            case 79:
            case 70:
            case 76:
              stack.popMany(bc.argCount);
              mn = popMultiname();
              obj = pop();
              type = getProperty(obj, mn);
              if (op === OP_callpropvoid) {
                break;
              }
              if (type instanceof MethodType) {
                returnType = Type.fromName(type.methodInfo.returnType, domain).instanceType();
              } else if (type instanceof TraitsType && type.isClassInfo()) {
                returnType = type.instanceType();
              } else {
                returnType = Type.Any;
              }
              push(returnType);
              break;
            case 71:
              this.returnType.merge(Type.Undefined);
              break;
            case 72:
              type = pop();
              if (mi.returnType) {
                var coerceType = Type.fromName(mi.returnType, this.domain).instanceType();
                if (coerceType.isSubtypeOf(type)) {
                  ti().noCoercionNeeded = true;
                }
              }
              break;
            case 73:
              stack.popMany(bc.argCount);
              stack.pop();
              if (this.thisType.isInstanceInfo() && this.thisType.super() === Type.Object) {
                ti().noCallSuperNeeded = true;
              }
              break;
            case 66:
              stack.popMany(bc.argCount);
              push(construct(pop()));
              break;
            case 74:
              stack.popMany(bc.argCount);
              mn = popMultiname();
              push(construct(getProperty(stack.pop(), mn)));
              break;
            case 75:
              notImplemented(bc);
              break;
            case 77:
              notImplemented(bc);
              break;
            case 78:
              stack.popMany(bc.argCount);
              popMultiname();
              pop();
              break;
            case 80:
            case 81:
            case 82:
              break;
            case 83:
              true;
              val = pop();
              obj = pop();
              push(obj.applyType(val));
              break;
            case 84:
              notImplemented(bc);
              break;
            case 85:
              stack.popMany(bc.argCount * 2);
              push(Type.Object);
              break;
            case 86:
              stack.popMany(bc.argCount);
              push(Type.Array);
              break;
            case 87:
              push(Type.from(new Activation(this.methodInfo)));
              break;
            case 88:
              push(Type.Any);
              break;
            case 89:
              push(Type.XMLList);
              break;
            case 90:
              push(Type.Any);
              break;
            case 93:
              push(findProperty(popMultiname(), true));
              break;
            case 94:
              push(findProperty(popMultiname(), false));
              break;
            case 95:
              notImplemented(bc);
              break;
            case 96:
              mn = popMultiname();
              push(getProperty(findProperty(mn, true), mn));
              break;
            case 104:
            case 97:
              val = pop();
              mn = popMultiname();
              obj = pop();
              setProperty(obj, mn, val, bc);
              break;
            case 98:
              push(local[bc.index]);
              break;
            case 99:
              local[bc.index] = pop();
              break;
            case 100:
              if (savedScope.object) {
                push(Type.from(savedScope.global.object));
              } else {
                push(Type.Any);
              }
              break;
            case 101:
              push(scope[bc.index]);
              break;
            case 102:
              mn = popMultiname();
              obj = pop();
              push(getProperty(obj, mn));
              break;
            case 103:
              notImplemented(bc);
              break;
            case 105:
              notImplemented(bc);
              break;
            case 106:
              popMultiname();
              pop();
              push(Type.Boolean);
              break;
            case 107:
              notImplemented(bc);
              break;
            case 108:
              push(accessSlot(pop()));
              break;
            case 109:
              val = pop();
              obj = pop();
              accessSlot(obj);
              break;
            case 110:
              notImplemented(bc);
              break;
            case 111:
              notImplemented(bc);
              break;
            case 112:
              pop();
              push(Type.String);
              break;
            case 113:
              pop();
              push(Type.String);
              break;
            case 114:
              pop();
              push(Type.String);
              break;
            case 131:
            case 115:
              pop();
              push(Type.Int);
              break;
            case 136:
            case 116:
              pop();
              push(Type.Uint);
              break;
            case 132:
            case 117:
              pop();
              push(Type.Number);
              break;
            case 129:
            case 118:
              pop();
              push(Type.Boolean);
              break;
            case 119:
              notImplemented(bc);
              break;
            case 120:
              break;
            case 121:
              pop();
              push(Type.Number);
              break;
            case 122:
              notImplemented(bc);
              break;
            case 123:
              notImplemented(bc);
              break;
            case 128:
              type = pop();
              var coerceType = Type.fromName(multinames[bc.index], this.domain).instanceType();
              if (coerceType.isSubtypeOf(type)) {
                ti().noCoercionNeeded = true;
              }
              push(coerceType);
              break;
            case 130:
              break;
            case 133:
              pop();
              push(Type.String);
              break;
            case 134:
              notImplemented(bc);
              break;
            case 135:
              type = pop();
              pop();
              if (type instanceof TraitsType) {
                push(type.instanceType());
              } else {
                push(Type.Any);
              }
              break;
            case 137:
              notImplemented(bc);
              break;
            case 144:
            case 145:
            case 147:
              pop();
              push(Type.Number);
              break;
            case 146:
            case 148:
              local[bc.index] = Type.Number;
              break;
            case 149:
              pop();
              push(Type.String);
              break;
            case 150:
              pop();
              push(Type.Boolean);
              break;
            case 160:
              r = pop();
              l = pop();
              if (l.isNumeric() && r.isNumeric()) {
                push(Type.Number);
              } else if (l === Type.String || r === Type.String) {
                push(Type.String);
              } else {
                push(Type.Any);
              }
              break;
            case 161:
            case 162:
            case 163:
            case 164:
              pop();
              pop();
              push(Type.Number);
              break;
            case 168:
            case 169:
            case 170:
            case 165:
            case 166:
            case 167:
              pop();
              pop();
              push(Type.Int);
              break;
            case 151:
              pop();
              push(Type.Int);
              break;
            case 171:
            case 172:
            case 173:
            case 174:
            case 175:
            case 176:
            case 177:
            case 180:
              pop();
              pop();
              push(Type.Boolean);
              break;
            case 178:
              pop();
              push(Type.Boolean);
              break;
            case 179:
              pop();
              pop();
              push(Type.Boolean);
              break;
            case 194:
            case 195:
              local[bc.index] = Type.Int;
              break;
            case 193:
            case 192:
            case 196:
              pop();
              push(Type.Int);
              break;
            case 197:
            case 198:
            case 199:
              pop();
              pop();
              push(Type.Int);
              break;
            case 208:
            case 209:
            case 210:
            case 211:
              push(local[op - OP_getlocal0]);
              break;
            case 212:
            case 213:
            case 214:
            case 215:
              local[op - OP_setlocal0] = pop();
              break;
            case 239:
              break;
            case 240:
              break;
            case 241:
              break;
            case 242:
              break;
            case 243:
              break;
            default:
              console.info('Not Implemented: ' + bc);
            }
            if (writer) {
              if (bc.ti) {
                writer.debugLn('> TI: ' + bc.ti);
              }
            }
          }
          if (writer) {
            writer.leave('}');
            writer.writeLn('verifiedBlock: ' + block.bid + ', range: [' + block.position + ', ' + block.end.position + '], exitState: ' + state.toString());
          }
        };
        return verification;
      }();
    function verifier() {
      this.writer = new IndentingWriter();
    }
    verifier.prototype.verifyMethod = function (methodInfo, scope) {
      try {
        new Verification(methodInfo, scope).verify();
        methodInfo.verified = true;
        Counter.count('Verifier: Methods');
      } catch (e) {
        if (e instanceof VerifierError) {
          return;
        }
        throw e;
      }
    };
    return verifier;
  }();
(function (exports) {
  var debug = false;
  var IRDefinition = {
      Control: {
        Region: {
          predecessors: {
            array: true,
            expand: 'control'
          },
          Start: {
            _constructorText: 'this.control = this;',
            scope: {
              dynamic: true
            },
            domain: {
              dynamic: true
            }
          }
        },
        End: {
          control: {
            assert: 'isControlOrNull'
          },
          Stop: {
            store: {
              assert: 'isStore'
            },
            argument: {
              assert: ''
            }
          },
          If: {
            predicate: {
              assert: ''
            }
          },
          Switch: {
            determinant: {
              assert: ''
            }
          },
          Jump: {}
        }
      },
      Value: {
        StoreDependent: {
          control: {
            assert: 'isControlOrNull',
            nullable: true
          },
          store: {
            assert: 'isStoreOrNull',
            nullable: true
          },
          loads: {
            dynamic: true,
            nullable: true,
            array: true
          },
          Call: {
            callee: {
              assert: ''
            },
            object: {
              assert: 'isValueOrNull',
              nullable: true
            },
            args: {
              assert: 'isArray',
              array: true
            },
            flags: {
              internal: true,
              assert: 'isNumber'
            }
          },
          CallProperty: {
            object: {
              assert: ''
            },
            name: {
              assert: ''
            },
            args: {
              assert: 'isArray',
              array: true
            },
            flags: {
              internal: true,
              assert: 'isNumber'
            },
            ASCallProperty: {
              isLex: {
                assert: '',
                internal: true
              }
            }
          },
          New: {
            callee: {
              assert: ''
            },
            args: {
              assert: '',
              array: true
            },
            ASNew: {}
          },
          GetProperty: {
            object: {
              assert: ''
            },
            name: {
              assert: ''
            },
            ASGetProperty: {
              flags: {
                internal: true,
                assert: 'isNumber'
              }
            },
            ASGetDescendants: {},
            ASHasProperty: {},
            ASGetSlot: {}
          },
          SetProperty: {
            object: {
              assert: ''
            },
            name: {
              assert: ''
            },
            value: {
              assert: ''
            },
            ASSetProperty: {
              flags: {
                internal: true
              }
            },
            ASSetSlot: {}
          },
          DeleteProperty: {
            object: {
              assert: ''
            },
            name: {
              assert: ''
            },
            ASDeleteProperty: {}
          },
          ASFindProperty: {
            scope: {
              assert: ''
            },
            name: {
              assert: ''
            },
            domain: {
              assert: ''
            },
            strict: {
              internal: true
            }
          }
        },
        Store: {},
        Phi: {
          control: {
            assert: 'isControl',
            nullable: true
          },
          args: {
            array: true,
            expand: 'value'
          }
        },
        Variable: {
          name: {
            internal: true
          }
        },
        Copy: {
          argument: {}
        },
        Move: {
          to: {},
          from: {}
        },
        Projection: {
          argument: {},
          type: {
            internal: true
          },
          selector: {
            internal: true,
            optional: true
          }
        },
        Latch: {
          control: {
            assert: 'isControlOrNull',
            nullable: true
          },
          condition: {},
          left: {},
          right: {}
        },
        Binary: {
          operator: {
            internal: true
          },
          left: {},
          right: {}
        },
        Unary: {
          operator: {
            internal: true
          },
          argument: {}
        },
        Constant: {
          value: {
            internal: true
          }
        },
        GlobalProperty: {
          name: {
            internal: true
          }
        },
        This: {
          control: {
            assert: 'isControl'
          }
        },
        Throw: {
          control: {
            assert: 'isControl'
          },
          argument: {}
        },
        Arguments: {
          control: {
            assert: 'isControl'
          }
        },
        Parameter: {
          control: {
            assert: 'isControl'
          },
          index: {
            internal: true
          },
          name: {
            internal: true
          }
        },
        NewArray: {
          control: {
            assert: 'isControl'
          },
          elements: {
            array: true
          }
        },
        NewObject: {
          control: {
            assert: 'isControl'
          },
          properties: {
            array: true
          }
        },
        KeyValuePair: {
          key: {},
          value: {}
        },
        ASScope: {
          parent: {},
          object: {},
          isWith: {
            internal: true
          }
        },
        ASGlobal: {
          control: {
            assert: 'isControlOrNull',
            nullable: true
          },
          scope: {
            assert: 'isScope'
          }
        },
        ASNewActivation: {
          methodInfo: {
            internal: true
          }
        },
        ASMultiname: {
          namespaces: {},
          name: {},
          flags: {
            internal: true
          }
        }
      }
    };
  function IRGenerator(root) {
    var str = '';
    function out(s) {
      str += s + '\n';
    }
    var writer = new IndentingWriter(false, out);
    function makeProperties(node) {
      var result = [];
      for (var k in node) {
        if (isProperty(k)) {
          node[k].name = k;
          result.push(node[k]);
        }
      }
      return result;
    }
    function isProperty(v) {
      if (v[0] === '_') {
        return false;
      }
      return v[0].toLowerCase() === v[0];
    }
    function generate(node, path) {
      path = path.concat([
        node
      ]);
      writer.enter('var ' + node._name + ' = (function () {');
      var constructorName = node._name[0].toLowerCase() + node._name.slice(1) + 'Node';
      if (constructorName.substring(0, 2) === 'aS') {
        constructorName = 'as' + constructorName.substring(2);
      }
      var prototypeName = constructorName + '.prototype';
      var properties = path.reduce(function (a, v) {
          return a.concat(makeProperties(v));
        }, []);
      var parameters = properties.filter(function (property) {
          return !property.dynamic;
        });
      var optionalParameters = parameters.filter(function (property) {
          return property.optional;
        });
      var parameterString = parameters.map(function (property) {
          if (property.expand) {
            return property.expand;
          }
          return property.name;
        }).join(', ');
      writer.enter('function ' + constructorName + '(' + parameterString + ') {');
      if (true) {
        properties.forEach(function (property) {
          if (property.assert === '') {
            writer.writeLn('release || assert (!(' + property.name + ' == undefined), "' + property.name + '");');
          } else if (property.assert) {
            writer.writeLn('release || assert (' + property.assert + '(' + property.name + '), "' + property.name + '");');
          }
        });
        writer.writeLn('release || assert (arguments.length >= ' + (parameters.length - optionalParameters.length) + ', "' + node._name + ' not enough args.");');
      }
      if (node._constructorText) {
        writer.writeLn(node._constructorText);
      }
      properties.forEach(function (property) {
        if (property.expand) {
          writer.writeLn('this.' + property.name + ' = ' + property.expand + ' ? [' + property.expand + '] : [];');
        } else if (property.dynamic) {
          writer.writeLn('this.' + property.name + ' = undefined;');
        } else {
          writer.writeLn('this.' + property.name + ' = ' + property.name + ';');
        }
      });
      writer.writeLn('this.id = nextID[nextID.length - 1] += 1;');
      writer.leave('}');
      if (path.length > 1) {
        writer.writeLn(prototypeName + ' = ' + 'extend(' + path[path.length - 2]._name + ', "' + node._name + '")');
      }
      writer.writeLn(prototypeName + '.nodeName = "' + node._name + '";');
      writer.enter(prototypeName + '.visitInputs = function (visitor) {');
      properties.forEach(function (property) {
        if (property.internal) {
          return;
        }
        var str = '';
        if (property.nullable) {
          str += 'this.' + property.name + ' && ';
        }
        if (property.array) {
          str += 'visitArrayInputs(this.' + property.name + ', visitor);';
        } else {
          str += 'visitor(this.' + property.name + ');';
        }
        writer.writeLn(str);
      });
      writer.leave('};');
      writer.writeLn('return ' + constructorName + ';');
      writer.leave('})();');
      writer.writeLn('');
      for (var name in node) {
        if (name[0] === '_' || isProperty(name)) {
          continue;
        }
        var child = node[name];
        child._name = name;
        generate(child, path);
      }
    }
    IRDefinition._name = 'Node';
    generate(IRDefinition, []);
    return str;
  }
  var nextID = [];
  var Node = function () {
      function nodeNode() {
        true;
        this.id = nextID[nextID.length - 1] += 1;
      }
      nodeNode.prototype.nodeName = 'Node';
      nodeNode.prototype.visitInputs = function (visitor) {
      };
      return nodeNode;
    }();
  var Control = function () {
      function controlNode() {
        true;
        this.id = nextID[nextID.length - 1] += 1;
      }
      controlNode.prototype = extend(Node, 'Control');
      controlNode.prototype.nodeName = 'Control';
      controlNode.prototype.visitInputs = function (visitor) {
      };
      return controlNode;
    }();
  var Region = function () {
      function regionNode(control) {
        true;
        this.predecessors = control ? [
          control
        ] : [];
        this.id = nextID[nextID.length - 1] += 1;
      }
      regionNode.prototype = extend(Control, 'Region');
      regionNode.prototype.nodeName = 'Region';
      regionNode.prototype.visitInputs = function (visitor) {
        visitArrayInputs(this.predecessors, visitor);
      };
      return regionNode;
    }();
  var Start = function () {
      function startNode(control) {
        true;
        this.control = this;
        this.predecessors = control ? [
          control
        ] : [];
        this.scope = undefined;
        this.domain = undefined;
        this.id = nextID[nextID.length - 1] += 1;
      }
      startNode.prototype = extend(Region, 'Start');
      startNode.prototype.nodeName = 'Start';
      startNode.prototype.visitInputs = function (visitor) {
        visitArrayInputs(this.predecessors, visitor);
        visitor(this.scope);
        visitor(this.domain);
      };
      return startNode;
    }();
  var End = function () {
      function endNode(control) {
        true;
        true;
        this.control = control;
        this.id = nextID[nextID.length - 1] += 1;
      }
      endNode.prototype = extend(Control, 'End');
      endNode.prototype.nodeName = 'End';
      endNode.prototype.visitInputs = function (visitor) {
        visitor(this.control);
      };
      return endNode;
    }();
  var Stop = function () {
      function stopNode(control, store, argument) {
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.argument = argument;
        this.id = nextID[nextID.length - 1] += 1;
      }
      stopNode.prototype = extend(End, 'Stop');
      stopNode.prototype.nodeName = 'Stop';
      stopNode.prototype.visitInputs = function (visitor) {
        visitor(this.control);
        visitor(this.store);
        visitor(this.argument);
      };
      return stopNode;
    }();
  var If = function () {
      function ifNode(control, predicate) {
        true;
        true;
        true;
        this.control = control;
        this.predicate = predicate;
        this.id = nextID[nextID.length - 1] += 1;
      }
      ifNode.prototype = extend(End, 'If');
      ifNode.prototype.nodeName = 'If';
      ifNode.prototype.visitInputs = function (visitor) {
        visitor(this.control);
        visitor(this.predicate);
      };
      return ifNode;
    }();
  var Switch = function () {
      function switchNode(control, determinant) {
        true;
        true;
        true;
        this.control = control;
        this.determinant = determinant;
        this.id = nextID[nextID.length - 1] += 1;
      }
      switchNode.prototype = extend(End, 'Switch');
      switchNode.prototype.nodeName = 'Switch';
      switchNode.prototype.visitInputs = function (visitor) {
        visitor(this.control);
        visitor(this.determinant);
      };
      return switchNode;
    }();
  var Jump = function () {
      function jumpNode(control) {
        true;
        true;
        this.control = control;
        this.id = nextID[nextID.length - 1] += 1;
      }
      jumpNode.prototype = extend(End, 'Jump');
      jumpNode.prototype.nodeName = 'Jump';
      jumpNode.prototype.visitInputs = function (visitor) {
        visitor(this.control);
      };
      return jumpNode;
    }();
  var Value = function () {
      function valueNode() {
        true;
        this.id = nextID[nextID.length - 1] += 1;
      }
      valueNode.prototype = extend(Node, 'Value');
      valueNode.prototype.nodeName = 'Value';
      valueNode.prototype.visitInputs = function (visitor) {
      };
      return valueNode;
    }();
  var StoreDependent = function () {
      function storeDependentNode(control, store) {
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.id = nextID[nextID.length - 1] += 1;
      }
      storeDependentNode.prototype = extend(Value, 'StoreDependent');
      storeDependentNode.prototype.nodeName = 'StoreDependent';
      storeDependentNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
      };
      return storeDependentNode;
    }();
  var Call = function () {
      function callNode(control, store, callee, object, args, flags) {
        true;
        true;
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.callee = callee;
        this.object = object;
        this.args = args;
        this.flags = flags;
        this.id = nextID[nextID.length - 1] += 1;
      }
      callNode.prototype = extend(StoreDependent, 'Call');
      callNode.prototype.nodeName = 'Call';
      callNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.callee);
        this.object && visitor(this.object);
        visitArrayInputs(this.args, visitor);
      };
      return callNode;
    }();
  var CallProperty = function () {
      function callPropertyNode(control, store, object, name, args, flags) {
        true;
        true;
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.args = args;
        this.flags = flags;
        this.id = nextID[nextID.length - 1] += 1;
      }
      callPropertyNode.prototype = extend(StoreDependent, 'CallProperty');
      callPropertyNode.prototype.nodeName = 'CallProperty';
      callPropertyNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
        visitArrayInputs(this.args, visitor);
      };
      return callPropertyNode;
    }();
  var ASCallProperty = function () {
      function asCallPropertyNode(control, store, object, name, args, flags, isLex) {
        true;
        true;
        true;
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.args = args;
        this.flags = flags;
        this.isLex = isLex;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asCallPropertyNode.prototype = extend(CallProperty, 'ASCallProperty');
      asCallPropertyNode.prototype.nodeName = 'ASCallProperty';
      asCallPropertyNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
        visitArrayInputs(this.args, visitor);
      };
      return asCallPropertyNode;
    }();
  var New = function () {
      function newNode(control, store, callee, args) {
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.callee = callee;
        this.args = args;
        this.id = nextID[nextID.length - 1] += 1;
      }
      newNode.prototype = extend(StoreDependent, 'New');
      newNode.prototype.nodeName = 'New';
      newNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.callee);
        visitArrayInputs(this.args, visitor);
      };
      return newNode;
    }();
  var ASNew = function () {
      function asNewNode(control, store, callee, args) {
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.callee = callee;
        this.args = args;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asNewNode.prototype = extend(New, 'ASNew');
      asNewNode.prototype.nodeName = 'ASNew';
      asNewNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.callee);
        visitArrayInputs(this.args, visitor);
      };
      return asNewNode;
    }();
  var GetProperty = function () {
      function getPropertyNode(control, store, object, name) {
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.id = nextID[nextID.length - 1] += 1;
      }
      getPropertyNode.prototype = extend(StoreDependent, 'GetProperty');
      getPropertyNode.prototype.nodeName = 'GetProperty';
      getPropertyNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
      };
      return getPropertyNode;
    }();
  var ASGetProperty = function () {
      function asGetPropertyNode(control, store, object, name, flags) {
        true;
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.flags = flags;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asGetPropertyNode.prototype = extend(GetProperty, 'ASGetProperty');
      asGetPropertyNode.prototype.nodeName = 'ASGetProperty';
      asGetPropertyNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
      };
      return asGetPropertyNode;
    }();
  var ASGetDescendants = function () {
      function asGetDescendantsNode(control, store, object, name) {
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asGetDescendantsNode.prototype = extend(GetProperty, 'ASGetDescendants');
      asGetDescendantsNode.prototype.nodeName = 'ASGetDescendants';
      asGetDescendantsNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
      };
      return asGetDescendantsNode;
    }();
  var ASHasProperty = function () {
      function asHasPropertyNode(control, store, object, name) {
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asHasPropertyNode.prototype = extend(GetProperty, 'ASHasProperty');
      asHasPropertyNode.prototype.nodeName = 'ASHasProperty';
      asHasPropertyNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
      };
      return asHasPropertyNode;
    }();
  var ASGetSlot = function () {
      function asGetSlotNode(control, store, object, name) {
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asGetSlotNode.prototype = extend(GetProperty, 'ASGetSlot');
      asGetSlotNode.prototype.nodeName = 'ASGetSlot';
      asGetSlotNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
      };
      return asGetSlotNode;
    }();
  var SetProperty = function () {
      function setPropertyNode(control, store, object, name, value) {
        true;
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.value = value;
        this.id = nextID[nextID.length - 1] += 1;
      }
      setPropertyNode.prototype = extend(StoreDependent, 'SetProperty');
      setPropertyNode.prototype.nodeName = 'SetProperty';
      setPropertyNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
        visitor(this.value);
      };
      return setPropertyNode;
    }();
  var ASSetProperty = function () {
      function asSetPropertyNode(control, store, object, name, value, flags) {
        true;
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.value = value;
        this.flags = flags;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asSetPropertyNode.prototype = extend(SetProperty, 'ASSetProperty');
      asSetPropertyNode.prototype.nodeName = 'ASSetProperty';
      asSetPropertyNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
        visitor(this.value);
      };
      return asSetPropertyNode;
    }();
  var ASSetSlot = function () {
      function asSetSlotNode(control, store, object, name, value) {
        true;
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.value = value;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asSetSlotNode.prototype = extend(SetProperty, 'ASSetSlot');
      asSetSlotNode.prototype.nodeName = 'ASSetSlot';
      asSetSlotNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
        visitor(this.value);
      };
      return asSetSlotNode;
    }();
  var DeleteProperty = function () {
      function deletePropertyNode(control, store, object, name) {
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.id = nextID[nextID.length - 1] += 1;
      }
      deletePropertyNode.prototype = extend(StoreDependent, 'DeleteProperty');
      deletePropertyNode.prototype.nodeName = 'DeleteProperty';
      deletePropertyNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
      };
      return deletePropertyNode;
    }();
  var ASDeleteProperty = function () {
      function asDeletePropertyNode(control, store, object, name) {
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.object = object;
        this.name = name;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asDeletePropertyNode.prototype = extend(DeleteProperty, 'ASDeleteProperty');
      asDeletePropertyNode.prototype.nodeName = 'ASDeleteProperty';
      asDeletePropertyNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.object);
        visitor(this.name);
      };
      return asDeletePropertyNode;
    }();
  var ASFindProperty = function () {
      function asFindPropertyNode(control, store, scope, name, domain, strict) {
        true;
        true;
        true;
        true;
        true;
        true;
        this.control = control;
        this.store = store;
        this.loads = undefined;
        this.scope = scope;
        this.name = name;
        this.domain = domain;
        this.strict = strict;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asFindPropertyNode.prototype = extend(StoreDependent, 'ASFindProperty');
      asFindPropertyNode.prototype.nodeName = 'ASFindProperty';
      asFindPropertyNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        this.store && visitor(this.store);
        this.loads && visitArrayInputs(this.loads, visitor);
        visitor(this.scope);
        visitor(this.name);
        visitor(this.domain);
      };
      return asFindPropertyNode;
    }();
  var Store = function () {
      function storeNode() {
        true;
        this.id = nextID[nextID.length - 1] += 1;
      }
      storeNode.prototype = extend(Value, 'Store');
      storeNode.prototype.nodeName = 'Store';
      storeNode.prototype.visitInputs = function (visitor) {
      };
      return storeNode;
    }();
  var Phi = function () {
      function phiNode(control, value) {
        true;
        true;
        this.control = control;
        this.args = value ? [
          value
        ] : [];
        this.id = nextID[nextID.length - 1] += 1;
      }
      phiNode.prototype = extend(Value, 'Phi');
      phiNode.prototype.nodeName = 'Phi';
      phiNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        visitArrayInputs(this.args, visitor);
      };
      return phiNode;
    }();
  var Variable = function () {
      function variableNode(name) {
        true;
        this.name = name;
        this.id = nextID[nextID.length - 1] += 1;
      }
      variableNode.prototype = extend(Value, 'Variable');
      variableNode.prototype.nodeName = 'Variable';
      variableNode.prototype.visitInputs = function (visitor) {
      };
      return variableNode;
    }();
  var Copy = function () {
      function copyNode(argument) {
        true;
        this.argument = argument;
        this.id = nextID[nextID.length - 1] += 1;
      }
      copyNode.prototype = extend(Value, 'Copy');
      copyNode.prototype.nodeName = 'Copy';
      copyNode.prototype.visitInputs = function (visitor) {
        visitor(this.argument);
      };
      return copyNode;
    }();
  var Move = function () {
      function moveNode(to, from) {
        true;
        this.to = to;
        this.from = from;
        this.id = nextID[nextID.length - 1] += 1;
      }
      moveNode.prototype = extend(Value, 'Move');
      moveNode.prototype.nodeName = 'Move';
      moveNode.prototype.visitInputs = function (visitor) {
        visitor(this.to);
        visitor(this.from);
      };
      return moveNode;
    }();
  var Projection = function () {
      function projectionNode(argument, type, selector) {
        true;
        this.argument = argument;
        this.type = type;
        this.selector = selector;
        this.id = nextID[nextID.length - 1] += 1;
      }
      projectionNode.prototype = extend(Value, 'Projection');
      projectionNode.prototype.nodeName = 'Projection';
      projectionNode.prototype.visitInputs = function (visitor) {
        visitor(this.argument);
      };
      return projectionNode;
    }();
  var Latch = function () {
      function latchNode(control, condition, left, right) {
        true;
        true;
        this.control = control;
        this.condition = condition;
        this.left = left;
        this.right = right;
        this.id = nextID[nextID.length - 1] += 1;
      }
      latchNode.prototype = extend(Value, 'Latch');
      latchNode.prototype.nodeName = 'Latch';
      latchNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        visitor(this.condition);
        visitor(this.left);
        visitor(this.right);
      };
      return latchNode;
    }();
  var Binary = function () {
      function binaryNode(operator, left, right) {
        true;
        this.operator = operator;
        this.left = left;
        this.right = right;
        this.id = nextID[nextID.length - 1] += 1;
      }
      binaryNode.prototype = extend(Value, 'Binary');
      binaryNode.prototype.nodeName = 'Binary';
      binaryNode.prototype.visitInputs = function (visitor) {
        visitor(this.left);
        visitor(this.right);
      };
      return binaryNode;
    }();
  var Unary = function () {
      function unaryNode(operator, argument) {
        true;
        this.operator = operator;
        this.argument = argument;
        this.id = nextID[nextID.length - 1] += 1;
      }
      unaryNode.prototype = extend(Value, 'Unary');
      unaryNode.prototype.nodeName = 'Unary';
      unaryNode.prototype.visitInputs = function (visitor) {
        visitor(this.argument);
      };
      return unaryNode;
    }();
  var Constant = function () {
      function constantNode(value) {
        true;
        this.value = value;
        this.id = nextID[nextID.length - 1] += 1;
      }
      constantNode.prototype = extend(Value, 'Constant');
      constantNode.prototype.nodeName = 'Constant';
      constantNode.prototype.visitInputs = function (visitor) {
      };
      return constantNode;
    }();
  var GlobalProperty = function () {
      function globalPropertyNode(name) {
        true;
        this.name = name;
        this.id = nextID[nextID.length - 1] += 1;
      }
      globalPropertyNode.prototype = extend(Value, 'GlobalProperty');
      globalPropertyNode.prototype.nodeName = 'GlobalProperty';
      globalPropertyNode.prototype.visitInputs = function (visitor) {
      };
      return globalPropertyNode;
    }();
  var This = function () {
      function thisNode(control) {
        true;
        true;
        this.control = control;
        this.id = nextID[nextID.length - 1] += 1;
      }
      thisNode.prototype = extend(Value, 'This');
      thisNode.prototype.nodeName = 'This';
      thisNode.prototype.visitInputs = function (visitor) {
        visitor(this.control);
      };
      return thisNode;
    }();
  var Throw = function () {
      function throwNode(control, argument) {
        true;
        true;
        this.control = control;
        this.argument = argument;
        this.id = nextID[nextID.length - 1] += 1;
      }
      throwNode.prototype = extend(Value, 'Throw');
      throwNode.prototype.nodeName = 'Throw';
      throwNode.prototype.visitInputs = function (visitor) {
        visitor(this.control);
        visitor(this.argument);
      };
      return throwNode;
    }();
  var Arguments = function () {
      function argumentsNode(control) {
        true;
        true;
        this.control = control;
        this.id = nextID[nextID.length - 1] += 1;
      }
      argumentsNode.prototype = extend(Value, 'Arguments');
      argumentsNode.prototype.nodeName = 'Arguments';
      argumentsNode.prototype.visitInputs = function (visitor) {
        visitor(this.control);
      };
      return argumentsNode;
    }();
  var Parameter = function () {
      function parameterNode(control, index, name) {
        true;
        true;
        this.control = control;
        this.index = index;
        this.name = name;
        this.id = nextID[nextID.length - 1] += 1;
      }
      parameterNode.prototype = extend(Value, 'Parameter');
      parameterNode.prototype.nodeName = 'Parameter';
      parameterNode.prototype.visitInputs = function (visitor) {
        visitor(this.control);
      };
      return parameterNode;
    }();
  var NewArray = function () {
      function newArrayNode(control, elements) {
        true;
        true;
        this.control = control;
        this.elements = elements;
        this.id = nextID[nextID.length - 1] += 1;
      }
      newArrayNode.prototype = extend(Value, 'NewArray');
      newArrayNode.prototype.nodeName = 'NewArray';
      newArrayNode.prototype.visitInputs = function (visitor) {
        visitor(this.control);
        visitArrayInputs(this.elements, visitor);
      };
      return newArrayNode;
    }();
  var NewObject = function () {
      function newObjectNode(control, properties) {
        true;
        true;
        this.control = control;
        this.properties = properties;
        this.id = nextID[nextID.length - 1] += 1;
      }
      newObjectNode.prototype = extend(Value, 'NewObject');
      newObjectNode.prototype.nodeName = 'NewObject';
      newObjectNode.prototype.visitInputs = function (visitor) {
        visitor(this.control);
        visitArrayInputs(this.properties, visitor);
      };
      return newObjectNode;
    }();
  var KeyValuePair = function () {
      function keyValuePairNode(key, value) {
        true;
        this.key = key;
        this.value = value;
        this.id = nextID[nextID.length - 1] += 1;
      }
      keyValuePairNode.prototype = extend(Value, 'KeyValuePair');
      keyValuePairNode.prototype.nodeName = 'KeyValuePair';
      keyValuePairNode.prototype.visitInputs = function (visitor) {
        visitor(this.key);
        visitor(this.value);
      };
      return keyValuePairNode;
    }();
  var ASScope = function () {
      function asScopeNode(parent, object, isWith) {
        true;
        this.parent = parent;
        this.object = object;
        this.isWith = isWith;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asScopeNode.prototype = extend(Value, 'ASScope');
      asScopeNode.prototype.nodeName = 'ASScope';
      asScopeNode.prototype.visitInputs = function (visitor) {
        visitor(this.parent);
        visitor(this.object);
      };
      return asScopeNode;
    }();
  var ASGlobal = function () {
      function asGlobalNode(control, scope) {
        true;
        true;
        true;
        this.control = control;
        this.scope = scope;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asGlobalNode.prototype = extend(Value, 'ASGlobal');
      asGlobalNode.prototype.nodeName = 'ASGlobal';
      asGlobalNode.prototype.visitInputs = function (visitor) {
        this.control && visitor(this.control);
        visitor(this.scope);
      };
      return asGlobalNode;
    }();
  var ASNewActivation = function () {
      function asNewActivationNode(methodInfo) {
        true;
        this.methodInfo = methodInfo;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asNewActivationNode.prototype = extend(Value, 'ASNewActivation');
      asNewActivationNode.prototype.nodeName = 'ASNewActivation';
      asNewActivationNode.prototype.visitInputs = function (visitor) {
      };
      return asNewActivationNode;
    }();
  var ASMultiname = function () {
      function asMultinameNode(namespaces, name, flags) {
        true;
        this.namespaces = namespaces;
        this.name = name;
        this.flags = flags;
        this.id = nextID[nextID.length - 1] += 1;
      }
      asMultinameNode.prototype = extend(Value, 'ASMultiname');
      asMultinameNode.prototype.nodeName = 'ASMultiname';
      asMultinameNode.prototype.visitInputs = function (visitor) {
        visitor(this.namespaces);
        visitor(this.name);
      };
      return asMultinameNode;
    }();
  function node() {
    this.id = nextID[nextID.length - 1] += 1;
  }
  Node.startNumbering = function () {
    nextID.push(0);
  };
  Node.stopNumbering = function () {
    nextID.pop();
  };
  Node.prototype.toString = function (brief) {
    if (brief) {
      return nameOf(this);
    }
    var inputs = [];
    this.visitInputs(function (input) {
      inputs.push(nameOf(input));
    }, true);
    var str = nameOf(this) + ' = ' + this.nodeName.toUpperCase();
    if (this.toStringDetails) {
      str += ' ' + this.toStringDetails();
    }
    if (inputs.length) {
      str += ' ' + inputs.join(', ');
    }
    return str;
  };
  Node.prototype.visitInputsNoConstants = function visitInputs(visitor) {
    this.visitInputs(function (node) {
      if (isConstant(node)) {
        return;
      }
      visitor(node);
    });
  };
  Node.prototype.replaceInput = function (oldInput, newInput) {
    var count = 0;
    for (var k in this) {
      var v = this[k];
      if (v instanceof Node) {
        if (v === oldInput) {
          this[k] = newInput;
          count++;
        }
      }
      if (v instanceof Array) {
        count += v.replace(oldInput, newInput);
      }
    }
    return count;
  };
  Projection.Type = {
    CASE: 'case',
    TRUE: 'true',
    FALSE: 'false',
    STORE: 'store',
    SCOPE: 'scope'
  };
  Projection.prototype.project = function () {
    return this.argument;
  };
  Phi.prototype.seal = function seal() {
    this.sealed = true;
  };
  Phi.prototype.pushValue = function pushValue(x) {
    true;
    true;
    this.args.push(x);
  };
  KeyValuePair.prototype.mustFloat = true;
  ASMultiname.prototype.mustFloat = true;
  ASMultiname.prototype.isAttribute = function () {
    return this.flags & 1;
  };
  var Flags = {
      INDEXED: 1,
      RESOLVED: 2,
      PRISTINE: 4,
      IS_METHOD: 8
    };
  var Operator = function () {
      var map = {};
      function operator(name, evaluate, binary) {
        this.name = name;
        this.binary = binary;
        this.evaluate = evaluate;
        map[name] = this;
      }
      operator.ADD = new operator('+', function (l, r) {
        return l + r;
      }, true);
      operator.SUB = new operator('-', function (l, r) {
        return l - r;
      }, true);
      operator.MUL = new operator('*', function (l, r) {
        return l * r;
      }, true);
      operator.DIV = new operator('/', function (l, r) {
        return l / r;
      }, true);
      operator.MOD = new operator('%', function (l, r) {
        return l % r;
      }, true);
      operator.AND = new operator('&', function (l, r) {
        return l & r;
      }, true);
      operator.OR = new operator('|', function (l, r) {
        return l | r;
      }, true);
      operator.XOR = new operator('^', function (l, r) {
        return l ^ r;
      }, true);
      operator.LSH = new operator('<<', function (l, r) {
        return l << r;
      }, true);
      operator.RSH = new operator('>>', function (l, r) {
        return l >> r;
      }, true);
      operator.URSH = new operator('>>>', function (l, r) {
        return l >>> r;
      }, true);
      operator.SEQ = new operator('===', function (l, r) {
        return l === r;
      }, true);
      operator.SNE = new operator('!==', function (l, r) {
        return l !== r;
      }, true);
      operator.EQ = new operator('==', function (l, r) {
        return l == r;
      }, true);
      operator.NE = new operator('!=', function (l, r) {
        return l != r;
      }, true);
      operator.LE = new operator('<=', function (l, r) {
        return l <= r;
      }, true);
      operator.GT = new operator('>', function (l, r) {
        return l > r;
      }, true);
      operator.LT = new operator('<', function (l, r) {
        return l < r;
      }, true);
      operator.GE = new operator('>=', function (l, r) {
        return l >= r;
      }, true);
      operator.BITWISE_NOT = new operator('~', function (a) {
        return ~a;
      }, false);
      operator.PLUS = new operator('+', function (a) {
        return +a;
      }, false);
      operator.NEG = new operator('-', function (a) {
        return -a;
      }, false);
      operator.TRUE = new operator('!!', function (a) {
        return !(!a);
      }, false);
      operator.FALSE = new operator('!', function (a) {
        return !a;
      }, false);
      operator.AS_ADD = new operator('+', function (l, r) {
        if (typeof l === 'string' || typeof r === 'string') {
          return String(l) + String(r);
        }
        return l + r;
      }, true);
      function linkOpposites(a, b) {
        a.not = b;
        b.not = a;
      }
      linkOpposites(operator.SEQ, operator.SNE);
      linkOpposites(operator.EQ, operator.NE);
      linkOpposites(operator.TRUE, operator.FALSE);
      operator.fromName = function fromName(name) {
        return map[name];
      };
      operator.prototype.isBinary = function isBinary() {
        return this.binary;
      };
      operator.prototype.toString = function toString() {
        return this.name;
      };
      return operator;
    }();
  function extend(c, name) {
    true;
    return Object.create(c.prototype, {
      nodeName: {
        value: name
      }
    });
  }
  function nameOf(o) {
    var useColors = false;
    var result;
    if (o instanceof Constant) {
      if (o.value instanceof Multiname) {
        return o.value.name;
      }
      return o.value;
    } else if (o instanceof Variable) {
      return o.name;
    } else if (o instanceof Phi) {
      return result = '|' + o.id + '|', useColors ? PURPLE + result + ENDC : result;
    } else if (o instanceof Control) {
      return result = '{' + o.id + '}', useColors ? RED + result + ENDC : result;
    } else if (o instanceof Projection) {
      if (o.type === Projection.Type.STORE) {
        return result = '[' + o.id + '->' + o.argument.id + ']', useColors ? YELLOW + result + ENDC : result;
      }
      return result = '(' + o.id + ')', useColors ? GREEN + result + ENDC : result;
    } else if (o instanceof Value) {
      return result = '(' + o.id + ')', useColors ? GREEN + result + ENDC : result;
    } else if (o instanceof Node) {
      return o.id;
    }
    unexpected(o + ' ' + typeof o);
  }
  function toID(node) {
    return node.id;
  }
  function visitArrayInputs(array, visitor) {
    for (var i = 0; i < array.length; i++) {
      visitor(array[i]);
    }
  }
  function visitNothing() {
  }
  function isNotPhi(phi) {
    return !isPhi(phi);
  }
  function isPhi(phi) {
    return phi instanceof Phi;
  }
  function isScope(scope) {
    return isPhi(scope) || scope instanceof ASScope || isProjection(scope, Projection.Type.SCOPE);
  }
  function isMultinameConstant(node) {
    return node instanceof Constant && node.value instanceof Multiname;
  }
  function isMultiname(name) {
    return isMultinameConstant(name) || name instanceof ASMultiname;
  }
  function isStore(store) {
    return isPhi(store) || store instanceof Store || isProjection(store, Projection.Type.STORE);
  }
  function isConstant(constant) {
    return constant instanceof Constant;
  }
  function isBoolean(boolean) {
    return boolean === true || boolean === false;
  }
  function isInteger(integer) {
    return integer | 0 === integer;
  }
  function isArray(array) {
    return array instanceof Array;
  }
  function isControlOrNull(control) {
    return isControl(control) || control === null;
  }
  function isStoreOrNull(store) {
    return isStore(store) || store === null;
  }
  function isControl(control) {
    return control instanceof Control;
  }
  function isValueOrNull(value) {
    return isValue(value) || value === null;
  }
  function isValue(value) {
    return value instanceof Value;
  }
  function isProjection(node, type) {
    return node instanceof Projection && (!type || node.type === type);
  }
  var Null = new Constant(null);
  var Undefined = new Constant(undefined);
  Undefined.toString = function () {
    return '_';
  };
  var Block = function () {
      function block(id, start, end) {
        if (start) {
          true;
        }
        this.region = start;
        this.id = id;
        this.successors = [];
        this.predecessors = [];
        this.nodes = [
          start,
          end
        ];
      }
      block.prototype.pushSuccessorAt = function pushSuccessor(successor, index, pushPredecessor) {
        true;
        true;
        this.successors[index] = successor;
        if (pushPredecessor) {
          successor.pushPredecessor(this);
        }
      };
      block.prototype.pushSuccessor = function pushSuccessor(successor, pushPredecessor) {
        true;
        this.successors.push(successor);
        if (pushPredecessor) {
          successor.pushPredecessor(this);
        }
      };
      block.prototype.pushPredecessor = function pushPredecessor(predecessor) {
        true;
        this.predecessors.push(predecessor);
      };
      block.prototype.visitNodes = function (fn) {
        var nodes = this.nodes;
        for (var i = 0, j = nodes.length; i < j; i++) {
          fn(nodes[i]);
        }
      };
      block.prototype.visitSuccessors = function (fn) {
        var successors = this.successors;
        for (var i = 0, j = successors.length; i < j; i++) {
          fn(successors[i]);
        }
      };
      block.prototype.visitPredecessors = function (fn) {
        var predecessors = this.predecessors;
        for (var i = 0, j = predecessors.length; i < j; i++) {
          fn(predecessors[i]);
        }
      };
      block.prototype.append = function (node) {
        true;
        true;
        true;
        true;
        if (node.mustFloat) {
          return;
        }
        this.nodes.splice(this.nodes.length - 1, 0, node);
      };
      block.prototype.toString = function () {
        return 'B' + this.id + (this.name ? ' (' + this.name + ')' : '');
      };
      block.prototype.trace = function (writer) {
        writer.writeLn(this);
      };
      return block;
    }();
  var DFG = function () {
      function constructor(exit) {
        this.exit = exit;
      }
      constructor.prototype.buildCFG = function () {
        return CFG.fromDFG(this);
      };
      function preOrderDepthFirstSearch(root, visitChildren, pre) {
        var visited = [];
        var worklist = [
            root
          ];
        var push = worklist.push.bind(worklist);
        var node;
        while (node = worklist.pop()) {
          if (visited[node.id] === 1) {
            continue;
          }
          visited[node.id] = 1;
          pre(node);
          worklist.push(node);
          visitChildren(node, push);
        }
      }
      function postOrderDepthFirstSearch(root, visitChildren, post) {
        var ONE_TIME = 1, MANY_TIMES = 2;
        var visited = [];
        var worklist = [
            root
          ];
        function visitChild(child) {
          if (!visited[child.id]) {
            worklist.push(child);
          }
        }
        var node;
        while (node = worklist.top()) {
          if (visited[node.id]) {
            if (visited[node.id] === ONE_TIME) {
              visited[node.id] = MANY_TIMES;
              post(node);
            }
            worklist.pop();
            continue;
          }
          visited[node.id] = ONE_TIME;
          visitChildren(node, visitChild);
        }
      }
      constructor.prototype.forEachInPreOrderDepthFirstSearch = function forEachInPreOrderDepthFirstSearch(visitor) {
        var visited = new Array(1024);
        var worklist = [
            this.exit
          ];
        function push(node) {
          if (isConstant(node)) {
            return;
          }
          true;
          worklist.push(node);
        }
        var node;
        while (node = worklist.pop()) {
          if (visited[node.id]) {
            continue;
          }
          visited[node.id] = 1;
          visitor && visitor(node);
          worklist.push(node);
          node.visitInputs(push);
        }
      };
      constructor.prototype.forEach = function forEach(visitor, postOrder) {
        var search = postOrder ? postOrderDepthFirstSearch : preOrderDepthFirstSearch;
        search(this.exit, function (node, v) {
          node.visitInputsNoConstants(v);
        }, visitor);
      };
      constructor.prototype.traceMetrics = function (writer) {
        var counter = new metrics.Counter(true);
        preOrderDepthFirstSearch(this.exit, function (node, visitor) {
          node.visitInputsNoConstants(visitor);
        }, function (node) {
          counter.count(node.nodeName);
        });
        counter.trace(writer);
      };
      constructor.prototype.trace = function (writer) {
        var nodes = [];
        var visited = {};
        function colorOf(node) {
          if (node instanceof Control) {
            return 'yellow';
          } else if (node instanceof Phi) {
            return 'purple';
          } else if (node instanceof Value) {
            return 'green';
          }
          return 'white';
        }
        var blocks = [];
        function followProjection(node) {
          return node instanceof Projection ? node.project() : node;
        }
        function next(node) {
          node = followProjection(node);
          if (!visited[node.id]) {
            visited[node.id] = true;
            if (node.block) {
              blocks.push(node.block);
            }
            nodes.push(node);
            node.visitInputsNoConstants(next);
          }
        }
        next(this.exit);
        writer.writeLn('');
        writer.enter('digraph DFG {');
        writer.writeLn('graph [bgcolor = gray10];');
        writer.writeLn('edge [color = white];');
        writer.writeLn('node [shape = box, fontname = Consolas, fontsize = 11, color = white, fontcolor = white];');
        writer.writeLn('rankdir = BT;');
        function writeNode(node) {
          writer.writeLn('N' + node.id + ' [label = "' + node.toString() + '", color = "' + colorOf(node) + '"];');
        }
        function defineNode(node) {
          writer.writeLn('N' + node.id + ';');
        }
        blocks.forEach(function (block) {
          writer.enter('subgraph cluster' + block.nodes[0].id + ' { bgcolor = gray20;');
          block.visitNodes(function (node) {
            defineNode(followProjection(node));
          });
          writer.leave('}');
        });
        nodes.forEach(writeNode);
        nodes.forEach(function (node) {
          node.visitInputsNoConstants(function (input) {
            input = followProjection(input);
            writer.writeLn('N' + node.id + ' -> ' + 'N' + input.id + ' [color=' + colorOf(input) + '];');
          });
        });
        writer.leave('}');
        writer.writeLn('');
      };
      return constructor;
    }();
  var CFG = function () {
      function constructor() {
        this.nextBlockID = 0;
        this.blocks = [];
        this.exit;
        this.root;
      }
      constructor.fromDFG = function fromDFG(dfg) {
        var cfg = new CFG();
        true;
        cfg.dfg = dfg;
        var visited = [];
        function buildEnd(end) {
          if (end instanceof Projection) {
            end = end.project();
          }
          true;
          if (visited[end.id]) {
            return;
          }
          visited[end.id] = true;
          var start = end.control;
          if (!(start instanceof Region)) {
            start = end.control = new Region(start);
          }
          var block = start.block = cfg.buildBlock(start, end);
          if (start instanceof Start) {
            cfg.root = block;
          }
          for (var i = 0; i < start.predecessors.length; i++) {
            var c = start.predecessors[i];
            var d;
            var trueProjection = false;
            if (c instanceof Projection) {
              d = c.project();
              trueProjection = c.type === Projection.Type.TRUE;
            } else {
              d = c;
            }
            if (d instanceof Region) {
              d = new Jump(c);
              d = new Projection(d, Projection.Type.TRUE);
              start.predecessors[i] = d;
              d = d.project();
              trueProjection = true;
            }
            buildEnd(d);
            var controlBlock = d.control.block;
            if (d instanceof Switch) {
              true;
              controlBlock.pushSuccessorAt(block, c.selector.value, true);
            } else if (trueProjection && controlBlock.successors.length > 0) {
              controlBlock.pushSuccessor(block, true);
              controlBlock.hasFlippedSuccessors = true;
            } else {
              controlBlock.pushSuccessor(block, true);
            }
          }
        }
        buildEnd(dfg.exit);
        cfg.splitCriticalEdges();
        cfg.exit = dfg.exit.control.block;
        cfg.computeDominators(true);
        return cfg;
      };
      constructor.prototype.buildRootAndExit = function buildRootAndExit() {
        true;
        if (this.blocks[0].predecessors.length > 0) {
          this.root = new Block(this.nextBlockID++);
          this.blocks.push(this.root);
          this.root.pushSuccessor(this.blocks[0], true);
        } else {
          this.root = this.blocks[0];
        }
        var exitBlocks = [];
        for (var i = 0; i < this.blocks.length; i++) {
          var block = this.blocks[i];
          if (block.successors.length === 0) {
            exitBlocks.push(block);
          }
        }
        if (exitBlocks.length === 0) {
          unexpected('Must have an exit block.');
        } else if (exitBlocks.length === 1 && exitBlocks[0] !== this.root) {
          this.exit = exitBlocks[0];
        } else {
          this.exit = new Block(this.nextBlockID++);
          this.blocks.push(this.exit);
          for (var i = 0; i < exitBlocks.length; i++) {
            exitBlocks[i].pushSuccessor(this.exit, true);
          }
        }
        true;
        true;
      };
      constructor.prototype.fromString = function (list, rootName) {
        var cfg = this;
        var names = cfg.blockNames || (cfg.blockNames = {});
        var blocks = cfg.blocks;
        var sets = list.replace(/\ /g, '').split(',');
        sets.forEach(function (set) {
          var edgeList = set.split('->');
          var last = null;
          for (var i = 0; i < edgeList.length; i++) {
            var next = edgeList[i];
            if (last) {
              buildEdge(last, next);
            } else {
              buildBlock(next);
            }
            last = next;
          }
        });
        function buildBlock(name) {
          var block = names[name];
          if (block) {
            return block;
          }
          names[name] = block = new Block(cfg.nextBlockID++);
          block.name = name;
          blocks.push(block);
          return block;
        }
        function buildEdge(from, to) {
          buildBlock(from).pushSuccessor(buildBlock(to), true);
        }
        true;
        this.root = names[rootName];
      };
      constructor.prototype.buildBlock = function (start, end) {
        var block = new Block(this.nextBlockID++, start, end);
        this.blocks.push(block);
        return block;
      };
      constructor.prototype.createBlockSet = function () {
        if (!this.setConstructor) {
          this.setConstructor = BitSetFunctor(this.blocks.length);
        }
        return new this.setConstructor();
      };
      constructor.prototype.computeReversePostOrder = function computeReversePostOrder() {
        if (this.order) {
          return this.order;
        }
        var order = this.order = [];
        this.depthFirstSearch(null, order.push.bind(order));
        order.reverse();
        for (var i = 0; i < order.length; i++) {
          order[i].rpo = i;
        }
        return order;
      };
      constructor.prototype.depthFirstSearch = function depthFirstSearch(preFn, postFn) {
        var visited = this.createBlockSet();
        function visit(node) {
          visited.set(node.id);
          if (preFn)
            preFn(node);
          var successors = node.successors;
          for (var i = 0, j = successors.length; i < j; i++) {
            var s = successors[i];
            if (!visited.get(s.id)) {
              visit(s);
            }
          }
          if (postFn)
            postFn(node);
        }
        visit(this.root);
      };
      constructor.prototype.computeDominators = function (apply) {
        true;
        var dom = new Int32Array(this.blocks.length);
        for (var i = 0; i < dom.length; i++) {
          dom[i] = -1;
        }
        var map = this.createBlockSet();
        function computeCommonDominator(a, b) {
          map.clearAll();
          while (a >= 0) {
            map.set(a);
            a = dom[a];
          }
          while (b >= 0 && !map.get(b)) {
            b = dom[b];
          }
          return b;
        }
        function computeDominator(blockID, parentID) {
          if (dom[blockID] < 0) {
            dom[blockID] = parentID;
          } else {
            dom[blockID] = computeCommonDominator(dom[blockID], parentID);
          }
        }
        this.depthFirstSearch(function visit(block) {
          var s = block.successors;
          for (var i = 0, j = s.length; i < j; i++) {
            computeDominator(s[i].id, block.id);
          }
        });
        if (apply) {
          for (var i = 0, j = this.blocks.length; i < j; i++) {
            this.blocks[i].dominator = this.blocks[dom[i]];
          }
          function computeDominatorDepth(block) {
            var dominatorDepth;
            if (block.dominatorDepth !== undefined) {
              return block.dominatorDepth;
            } else if (!block.dominator) {
              dominatorDepth = 0;
            } else {
              dominatorDepth = computeDominatorDepth(block.dominator) + 1;
            }
            return block.dominatorDepth = dominatorDepth;
          }
          for (var i = 0, j = this.blocks.length; i < j; i++) {
            computeDominatorDepth(this.blocks[i]);
          }
        }
        return dom;
      };
      constructor.prototype.computeLoops = function computeLoops() {
        var active = this.createBlockSet();
        var visited = this.createBlockSet();
        var nextLoop = 0;
        function makeLoopHeader(block) {
          if (!block.isLoopHeader) {
            block.isLoopHeader = true;
            block.loops = 1 << nextLoop;
            nextLoop += 1;
          }
        }
        function visit(block) {
          if (visited.get(block.id)) {
            if (active.get(block.id)) {
              makeLoopHeader(block);
            }
            return block.loops;
          }
          visited.set(block.id);
          active.set(block.id);
          var loops = 0;
          for (var i = 0, j = block.successors.length; i < j; i++) {
            loops |= visit(block.successors[i]);
          }
          if (block.isLoopHeader) {
            loops &= ~block.loops;
          }
          block.loops = loops;
          active.clear(block.id);
          return loops;
        }
        var loop = visit(this.root);
      };
      function followProjection(node) {
        return node instanceof Projection ? node.project() : node;
      }
      var Uses = function () {
          function constructor() {
            this.entries = [];
          }
          constructor.prototype.addUse = function addUse(def, use) {
            var entry = this.entries[def.id];
            if (!entry) {
              entry = this.entries[def.id] = {
                def: def,
                uses: []
              };
            }
            entry.uses.pushUnique(use);
          };
          constructor.prototype.trace = function (writer) {
            writer.enter('> Uses');
            this.entries.forEach(function (entry) {
              writer.writeLn(entry.def.id + ' -> [' + entry.uses.map(toID).join(', ') + '] ' + entry.def);
            });
            writer.leave('<');
          };
          constructor.prototype.replace = function (def, value) {
            var entry = this.entries[def.id];
            if (entry.uses.length === 0) {
              return false;
            }
            var count = 0;
            entry.uses.forEach(function (use) {
              count += use.replaceInput(def, value);
            });
            true;
            entry.uses = [];
            return true;
          };
          function updateUses(def, value) {
            debug && writer.writeLn('Update ' + def + ' with ' + value);
            var entry = useEntries[def.id];
            if (entry.uses.length === 0) {
              return false;
            }
            debug && writer.writeLn('Replacing: ' + def.id + ' in [' + entry.uses.map(toID).join(', ') + '] with ' + value.id);
            var count = 0;
            entry.uses.forEach(function (use) {
              count += use.replaceInput(def, value);
            });
            true;
            entry.uses = [];
            return true;
          }
          return constructor;
        }();
      constructor.prototype.computeUses = function computeUses() {
        Timer.start('computeUses');
        var writer = debug && new IndentingWriter();
        debug && writer.enter('> Compute Uses');
        var dfg = this.dfg;
        var uses = new Uses();
        dfg.forEachInPreOrderDepthFirstSearch(function (use) {
          use.visitInputs(function (def) {
            uses.addUse(def, use);
          });
        });
        if (debug) {
          writer.enter('> Uses');
          uses.entries.forEach(function (entry) {
            writer.writeLn(entry.def.id + ' -> [' + entry.uses.map(toID).join(', ') + '] ' + entry.def);
          });
          writer.leave('<');
          writer.leave('<');
        }
        Timer.stop();
        return uses;
      };
      constructor.prototype.verify = function verify() {
        var writer = debug && new IndentingWriter();
        debug && writer.enter('> Verify');
        var order = this.computeReversePostOrder();
        order.forEach(function (block) {
          if (block.phis) {
            block.phis.forEach(function (phi) {
              true;
              true;
            });
          }
        });
        debug && writer.leave('<');
      };
      constructor.prototype.optimizePhis = function optimizePhis() {
        var writer = debug && new IndentingWriter();
        debug && writer.enter('> Optimize Phis');
        var phis = [];
        var useEntries = this.computeUses().entries;
        useEntries.forEach(function (entry) {
          if (isPhi(entry.def)) {
            phis.push(entry.def);
          }
        });
        debug && writer.writeLn('Trying to optimize ' + phis.length + ' phis.');
        function updateUses(def, value) {
          debug && writer.writeLn('Update ' + def + ' with ' + value);
          var entry = useEntries[def.id];
          if (entry.uses.length === 0) {
            return false;
          }
          debug && writer.writeLn('Replacing: ' + def.id + ' in [' + entry.uses.map(toID).join(', ') + '] with ' + value.id);
          var count = 0;
          var entryUses = entry.uses;
          for (var i = 0, j = entryUses.length; i < j; i++) {
            count += entryUses[i].replaceInput(def, value);
          }
          true;
          entry.uses = [];
          return true;
        }
        function simplify(phi, args) {
          args = args.unique();
          if (args.length === 1) {
            return args[0];
          } else {
            if (args.length === 2) {
              if (args[0] === phi) {
                return args[1];
              } else if (args[1] === phi) {
                return args[0];
              }
              return phi;
            }
          }
          return phi;
        }
        var count = 0;
        var iterations = 0;
        var changed = true;
        while (changed) {
          iterations++;
          changed = false;
          phis.forEach(function (phi) {
            var value = simplify(phi, phi.args);
            if (value !== phi) {
              if (updateUses(phi, value)) {
                changed = true;
                count++;
              }
            }
          });
        }
        if (debug) {
          writer.writeLn('Simplified ' + count + ' phis, in ' + iterations + ' iterations.');
          writer.leave('<');
        }
      };
      constructor.prototype.splitCriticalEdges = function splitCriticalEdges() {
        var writer = debug && new IndentingWriter();
        var blocks = this.blocks;
        var criticalEdges = [];
        debug && writer.enter('> Splitting Critical Edges');
        for (var i = 0; i < blocks.length; i++) {
          var successors = blocks[i].successors;
          if (successors.length > 1) {
            for (var j = 0; j < successors.length; j++) {
              if (successors[j].predecessors.length > 1) {
                criticalEdges.push({
                  from: blocks[i],
                  to: successors[j]
                });
              }
            }
          }
        }
        var criticalEdgeCount = criticalEdges.length;
        if (criticalEdgeCount && debug) {
          writer.writeLn('Splitting: ' + criticalEdgeCount);
          this.trace(writer);
        }
        var edge;
        while (edge = criticalEdges.pop()) {
          var fromIndex = edge.from.successors.indexOf(edge.to);
          var toIndex = edge.to.predecessors.indexOf(edge.from);
          true;
          debug && writer.writeLn('Splitting critical edge: ' + edge.from + ' -> ' + edge.to);
          var toBlock = edge.to;
          var toRegion = toBlock.region;
          var control = toRegion.predecessors[toIndex];
          var region = new Region(control);
          var jump = new Jump(region);
          var block = this.buildBlock(region, jump);
          toRegion.predecessors[toIndex] = new Projection(jump, Projection.Type.TRUE);
          var fromBlock = edge.from;
          fromBlock.successors[fromIndex] = block;
          block.pushPredecessor(fromBlock);
          block.pushSuccessor(toBlock);
          toBlock.predecessors[toIndex] = block;
        }
        if (criticalEdgeCount && debug) {
          this.trace(writer);
        }
        if (criticalEdgeCount && !true) {
          true;
        }
        debug && writer.leave('<');
        return criticalEdgeCount;
      };
      constructor.prototype.allocateVariables = function allocateVariables() {
        var writer = debug && new IndentingWriter();
        debug && writer.enter('> Allocating Virtual Registers');
        var order = this.computeReversePostOrder();
        function allocate(node) {
          if (isProjection(node, Projection.Type.STORE)) {
            return;
          }
          if (node instanceof SetProperty) {
            return;
          }
          if (node instanceof Value) {
            node.variable = new Variable('l' + node.id);
            debug && writer.writeLn('Allocated: ' + node.variable + ' to ' + node);
          }
        }
        order.forEach(function (block) {
          block.nodes.forEach(allocate);
          if (block.phis) {
            block.phis.forEach(allocate);
          }
        });
        var blockMoves = [];
        for (var i = 0; i < order.length; i++) {
          var block = order[i];
          var phis = block.phis;
          var predecessors = block.predecessors;
          if (phis) {
            for (var j = 0; j < phis.length; j++) {
              var phi = phis[j];
              debug && writer.writeLn('Emitting moves for: ' + phi);
              var arguments = phi.args;
              true;
              for (var k = 0; k < predecessors.length; k++) {
                var predecessor = predecessors[k];
                var argument = arguments[k];
                if (argument.abstract || isProjection(argument, Projection.Type.STORE)) {
                  continue;
                }
                var moves = blockMoves[predecessor.id] || (blockMoves[predecessor.id] = []);
                argument = argument.variable || argument;
                if (phi.variable !== argument) {
                  moves.push(new Move(phi.variable, argument));
                }
              }
            }
          }
        }
        var blocks = this.blocks;
        blockMoves.forEach(function (moves, blockID) {
          var block = blocks[blockID];
          var temporary = 0;
          debug && writer.writeLn(block + ' Moves: ' + moves);
          while (moves.length) {
            for (var i = 0; i < moves.length; i++) {
              var move = moves[i];
              for (var j = 0; j < moves.length; j++) {
                if (i === j) {
                  continue;
                }
                if (moves[j].from === move.to) {
                  move = null;
                  break;
                }
              }
              if (move) {
                moves.splice(i--, 1);
                block.append(move);
              }
            }
            if (moves.length) {
              debug && writer.writeLn('Breaking Cycle');
              var move = moves[0];
              var temp = new Variable('t' + temporary++);
              blocks[blockID].append(new Move(temp, move.to));
              for (var i = 1; i < moves.length; i++) {
                if (moves[i].from === move.to) {
                  moves[i].from = temp;
                }
              }
            }
          }
        });
        debug && writer.leave('<');
      };
      constructor.prototype.scheduleEarly = function scheduleEarly() {
        var debugScheduler = false;
        var writer = debugScheduler && new IndentingWriter();
        debugScheduler && writer.enter('> Schedule Early');
        var cfg = this;
        var dfg = this.dfg;
        var scheduled = [];
        var roots = [];
        dfg.forEachInPreOrderDepthFirstSearch(function (node) {
          if (node instanceof Region || node instanceof Jump) {
            return;
          }
          if (node.control) {
            roots.push(node);
          }
          if (isPhi(node)) {
            node.args.forEach(function (input) {
              if (shouldFloat(input)) {
                input.mustNotFloat = true;
              }
            });
          }
        }, true);
        if (debugScheduler) {
          roots.forEach(function (node) {
            print('Root: ' + node);
          });
        }
        for (var i = 0; i < roots.length; i++) {
          var root = roots[i];
          if (root instanceof Phi) {
            var block = root.control.block;
            (block.phis || (block.phis = [])).push(root);
          }
          if (root.control) {
            schedule(root);
          }
        }
        function isScheduled(node) {
          return scheduled[node.id];
        }
        function shouldFloat(node) {
          if (node.mustNotFloat || node.shouldNotFloat) {
            return false;
          }
          if (node.mustFloat || node.shouldFloat) {
            return true;
          }
          if (node instanceof Parameter || node instanceof This || node instanceof Arguments) {
            return true;
          }
          return node instanceof Binary || node instanceof Unary || node instanceof Parameter;
        }
        function append(node) {
          true;
          scheduled[node.id] = true;
          true;
          if (shouldFloat(node)) {
          } else {
            node.control.block.append(node);
          }
        }
        function scheduleIn(node, region) {
          true;
          true;
          true;
          debugScheduler && writer.writeLn('Scheduled: ' + node + ' in ' + region);
          node.control = region;
          append(node);
        }
        function schedule(node) {
          debugScheduler && writer.enter('> Schedule: ' + node);
          var inputs = [];
          node.visitInputs(function (input) {
            if (isConstant(input)) {
              {
                return;
              }
            }
            if (isValue(input)) {
              inputs.push(followProjection(input));
            }
          });
          debugScheduler && writer.writeLn('Inputs: [' + inputs.map(toID) + '], length: ' + inputs.length);
          for (var i = 0; i < inputs.length; i++) {
            var input = inputs[i];
            if (isNotPhi(input) && !isScheduled(input)) {
              schedule(input);
            }
          }
          if (node.control) {
            if (node instanceof End || node instanceof Phi || node instanceof Start || isScheduled(node)) {
            } else {
              append(node);
            }
          } else {
            if (inputs.length) {
              var x = inputs[0].control;
              for (var i = 1; i < inputs.length; i++) {
                var y = inputs[i].control;
                if (x.block.dominatorDepth < y.block.dominatorDepth) {
                  x = y;
                }
              }
              scheduleIn(node, x);
            } else {
              scheduleIn(node, cfg.root.region);
            }
          }
          debugScheduler && writer.leave('<');
        }
        debugScheduler && writer.leave('<');
        roots.forEach(function (node) {
          node = followProjection(node);
          if (node === dfg.start || node instanceof Region) {
            return;
          }
          true;
        });
      };
      constructor.prototype.trace = function (writer) {
        var visited = [];
        var blocks = [];
        function next(block) {
          if (!visited[block.id]) {
            visited[block.id] = true;
            blocks.push(block);
            block.visitSuccessors(next);
          }
        }
        var root = this.root;
        var exit = this.exit;
        next(root);
        function colorOf(block) {
          return 'black';
        }
        function styleOf(block) {
          return 'filled';
        }
        function shapeOf(block) {
          true;
          if (block === root) {
            return 'house';
          } else if (block === exit) {
            return 'invhouse';
          }
          return 'box';
        }
        writer.writeLn('');
        writer.enter('digraph CFG {');
        writer.writeLn('graph [bgcolor = gray10];');
        writer.writeLn('edge [fontname = Consolas, fontsize = 11, color = white, fontcolor = white];');
        writer.writeLn('node [shape = box, fontname = Consolas, fontsize = 11, color = white, fontcolor = white, style = filled];');
        writer.writeLn('rankdir = TB;');
        blocks.forEach(function (block) {
          var loopInfo = '';
          var blockInfo = '';
          var intervalInfo = '';
          if (block.loops !== undefined) {
          }
          if (block.name !== undefined) {
            blockInfo += ' ' + block.name;
          }
          if (block.rpo !== undefined) {
            blockInfo += ' O: ' + block.rpo;
          }
          writer.writeLn('B' + block.id + ' [label = "B' + block.id + blockInfo + loopInfo + '", fillcolor = "' + colorOf(block) + '", shape=' + shapeOf(block) + ', style=' + styleOf(block) + '];');
        });
        blocks.forEach(function (block) {
          block.visitSuccessors(function (successor) {
            writer.writeLn('B' + block.id + ' -> ' + 'B' + successor.id);
          });
          if (block.dominator) {
            writer.writeLn('B' + block.id + ' -> ' + 'B' + block.dominator.id + ' [color = orange];');
          }
          if (block.follow) {
            writer.writeLn('B' + block.id + ' -> ' + 'B' + block.follow.id + ' [color = purple];');
          }
        });
        writer.leave('}');
        writer.writeLn('');
      };
      return constructor;
    }();
  var PeepholeOptimizer = function () {
      function constructor() {
      }
      function foldUnary(node, truthy) {
        true;
        if (isConstant(node.argument)) {
          return new Constant(node.operator.evaluate(node.argument.value));
        }
        if (truthy) {
          var argument = fold(node.argument, true);
          if (node.operator === Operator.TRUE) {
            return argument;
          }
          if (argument instanceof Unary) {
            if (node.operator === Operator.FALSE && argument.operator === Operator.FALSE) {
              return argument.argument;
            }
          } else {
            return new Unary(node.operator, argument);
          }
        }
        return node;
      }
      function foldBinary(node, truthy) {
        true;
        if (isConstant(node.left) && isConstant(node.right)) {
          return new Constant(node.operator.evaluate(node.left.value, node.right.value));
        }
        return node;
      }
      function fold(node, truthy) {
        if (node instanceof Unary) {
          return foldUnary(node, truthy);
        } else if (node instanceof Binary) {
          return foldBinary(node, truthy);
        }
        return node;
      }
      constructor.prototype.tryFold = fold;
      return constructor;
    }();
  exports.isConstant = isConstant;
  exports.Block = Block;
  exports.Node = Node;
  exports.Start = Start;
  exports.Null = Null;
  exports.Undefined = Undefined;
  exports.This = This;
  exports.Throw = Throw;
  exports.Arguments = Arguments;
  exports.ASGlobal = ASGlobal;
  exports.Projection = Projection;
  exports.Region = Region;
  exports.Latch = Latch;
  exports.Binary = Binary;
  exports.Unary = Unary;
  exports.Constant = Constant;
  exports.ASFindProperty = ASFindProperty;
  exports.GlobalProperty = GlobalProperty;
  exports.GetProperty = GetProperty;
  exports.SetProperty = SetProperty;
  exports.CallProperty = CallProperty;
  exports.ASCallProperty = ASCallProperty;
  exports.ASGetProperty = ASGetProperty;
  exports.ASHasProperty = ASHasProperty;
  exports.ASDeleteProperty = ASDeleteProperty;
  exports.ASGetDescendants = ASGetDescendants;
  exports.ASSetProperty = ASSetProperty;
  exports.ASGetSlot = ASGetSlot;
  exports.ASSetSlot = ASSetSlot;
  exports.Call = Call;
  exports.ASNew = ASNew;
  exports.Phi = Phi;
  exports.Stop = Stop;
  exports.If = If;
  exports.Switch = Switch;
  exports.End = End;
  exports.Jump = Jump;
  exports.ASScope = ASScope;
  exports.Operator = Operator;
  exports.Variable = Variable;
  exports.Move = Move;
  exports.Copy = Copy;
  exports.Parameter = Parameter;
  exports.NewArray = NewArray;
  exports.NewObject = NewObject;
  exports.ASNewActivation = ASNewActivation;
  exports.KeyValuePair = KeyValuePair;
  exports.ASMultiname = ASMultiname;
  exports.DFG = DFG;
  exports.CFG = CFG;
  exports.Flags = Flags;
  exports.PeepholeOptimizer = PeepholeOptimizer;
}(typeof exports === 'undefined' ? IR = {} : exports));
var c4Options = systemOptions.register(new OptionSet('C4 Options'));
var enableC4 = c4Options.register(new Option('c4', 'c4', 'boolean', false, 'Enable the C4 compiler.'));
var c4TraceLevel = c4Options.register(new Option('tc4', 'tc4', 'number', 0, 'Compiler Trace Level'));
var enableRegisterAllocator = c4Options.register(new Option('ra', 'ra', 'boolean', false, 'Enable register allocator.'));
var getPublicQualifiedName = Multiname.getPublicQualifiedName;
var createName = function createName(namespaces, name) {
  if (isNumeric(name) || isObject(name)) {
    return name;
  }
  return new Multiname(namespaces, name);
};
(function (exports) {
  var Node = IR.Node;
  var Start = IR.Start;
  var Null = IR.Null;
  var Undefined = IR.Undefined;
  var This = IR.This;
  var Projection = IR.Projection;
  var Region = IR.Region;
  var Binary = IR.Binary;
  var Unary = IR.Unary;
  var Constant = IR.Constant;
  var Call = IR.Call;
  var Phi = IR.Phi;
  var Stop = IR.Stop;
  var Operator = IR.Operator;
  var Parameter = IR.Parameter;
  var NewArray = IR.NewArray;
  var NewObject = IR.NewObject;
  var KeyValuePair = IR.KeyValuePair;
  var isConstant = IR.isConstant;
  var DFG = IR.DFG;
  var CFG = IR.CFG;
  var writer = new IndentingWriter();
  var peepholeOptimizer = new IR.PeepholeOptimizer();
  var State = function () {
      var nextID = 0;
      function constructor(index) {
        this.id = nextID += 1;
        this.index = index;
        this.local = [];
        this.stack = [];
        this.scope = [];
        this.store = Undefined;
        this.loads = [];
        this.saved = Undefined;
      }
      constructor.prototype.clone = function clone(index) {
        var s = new State();
        s.index = index !== undefined ? index : this.index;
        s.local = this.local.slice(0);
        s.stack = this.stack.slice(0);
        s.scope = this.scope.slice(0);
        s.loads = this.loads.slice(0);
        s.saved = this.saved;
        s.store = this.store;
        return s;
      };
      constructor.prototype.matches = function matches(other) {
        return this.stack.length === other.stack.length && this.scope.length === other.scope.length && this.local.length === other.local.length;
      };
      constructor.prototype.makeLoopPhis = function makeLoopPhis(control) {
        var s = new State();
        true;
        function makePhi(x) {
          var phi = new Phi(control, x);
          phi.isLoop = true;
          return phi;
        }
        s.index = this.index;
        s.local = this.local.map(makePhi);
        s.stack = this.stack.map(makePhi);
        s.scope = this.scope.map(makePhi);
        s.loads = this.loads.slice(0);
        s.saved = this.saved;
        s.store = makePhi(this.store);
        return s;
      };
      constructor.prototype.optimize = function optimize() {
        function optimize(x) {
          if (x instanceof Phi && !x.isLoop) {
            var args = x.args.unique();
            if (args.length === 1) {
              x.seal();
              Counter.count('Builder: OptimizedPhi');
              return args[0];
            }
          }
          return x;
        }
        this.local = this.local.map(optimize);
        this.stack = this.stack.map(optimize);
        this.scope = this.scope.map(optimize);
        this.saved = optimize(this.saved);
        this.store = optimize(this.store);
      };
      function mergeValue(control, a, b) {
        var phi = a instanceof Phi && a.control === control ? a : new Phi(control, a);
        phi.pushValue(b);
        return phi;
      }
      function mergeValues(control, a, b) {
        for (var i = 0; i < a.length; i++) {
          a[i] = mergeValue(control, a[i], b[i]);
        }
      }
      constructor.prototype.merge = function merge(control, other) {
        true;
        true;
        mergeValues(control, this.local, other.local);
        mergeValues(control, this.stack, other.stack);
        mergeValues(control, this.scope, other.scope);
        this.store = mergeValue(control, this.store, other.store);
        this.store.abstract = true;
      };
      constructor.prototype.trace = function trace(writer) {
        writer.writeLn(this.toString());
      };
      function toBriefString(x) {
        if (x instanceof Node) {
          return x.toString(true);
        }
        return x;
      }
      constructor.prototype.toString = function () {
        return '<' + String(this.id + ' @ ' + this.index).padRight(' ', 10) + (' M: ' + toBriefString(this.store)).padRight(' ', 14) + (' X: ' + toBriefString(this.saved)).padRight(' ', 14) + (' $: ' + this.scope.map(toBriefString).join(', ')).padRight(' ', 20) + (' L: ' + this.local.map(toBriefString).join(', ')).padRight(' ', 40) + (' S: ' + this.stack.map(toBriefString).join(', ')).padRight(' ', 60);
      };
      return constructor;
    }();
  function isNumericConstant(node) {
    return node instanceof Constant && isNumeric(node.value);
  }
  function isStringConstant(node) {
    return node instanceof Constant && isString(node.value);
  }
  function isMultinameConstant(node) {
    return node instanceof Constant && node.value instanceof Multiname;
  }
  function hasNumericType(node) {
    if (isNumericConstant(node)) {
      return true;
    }
    return node.ty && node.ty.isNumeric();
  }
  function typesAreEqual(a, b) {
    if (hasNumericType(a) && hasNumericType(b) || hasStringType(a) && hasStringType(b)) {
      return true;
    }
    return false;
  }
  function hasStringType(node) {
    if (isStringConstant(node)) {
      return true;
    }
    return node.ty && node.ty.isString();
  }
  function constant(value) {
    return new Constant(value);
  }
  function qualifiedNameConstant(name) {
    return constant(Multiname.getQualifiedName(name));
  }
  function getJSPropertyWithState(state, object, path) {
    true;
    var names = path.split('.');
    var node = object;
    for (var i = 0; i < names.length; i++) {
      node = new IR.GetProperty(null, state.store, node, constant(names[i]));
      node.shouldFloat = true;
      state.loads.push(node);
    }
    return node;
  }
  function globalProperty(name) {
    var node = new IR.GlobalProperty(name);
    node.mustFloat = true;
    return node;
  }
  function warn(message) {
    console.warn(message);
  }
  function unary(operator, argument) {
    var node = new Unary(operator, argument);
    if (peepholeOptimizer) {
      node = peepholeOptimizer.tryFold(node);
    }
    return node;
  }
  function binary(operator, left, right) {
    var node = new Binary(operator, left, right);
    if (left.ty && left.ty !== Type.Any && left.ty === right.ty) {
      if (operator === Operator.EQ) {
        node.operator = Operator.SEQ;
      } else if (operator === Operator.NE) {
        node.operator = Operator.SNE;
      }
    }
    if (peepholeOptimizer) {
      node = peepholeOptimizer.tryFold(node);
    }
    return node;
  }
  function coerceInt(value) {
    return binary(Operator.OR, value, constant(0));
  }
  function coerceUint(value) {
    return binary(Operator.URSH, value, constant(0));
  }
  function coerceNumber(value) {
    if (hasNumericType(value)) {
      return value;
    }
    return unary(Operator.PLUS, value);
  }
  function coerceBoolean(value) {
    return unary(Operator.FALSE, unary(Operator.FALSE, value));
  }
  function shouldNotFloat(node) {
    node.shouldNotFloat = true;
    return node;
  }
  function shouldFloat(node) {
    true;
    node.shouldFloat = true;
    return node;
  }
  function mustFloat(node) {
    node.mustFloat = true;
    return node;
  }
  function callPure(callee, object, args) {
    return new Call(null, null, callee, object, args, IR.Flags.PRISTINE);
  }
  function callGlobalProperty(name, value) {
    return callPure(globalProperty(name), null, [
      value
    ]);
  }
  function convertString(value) {
    if (isStringConstant(value)) {
      return value;
    }
    return callPure(globalProperty('String'), null, [
      value
    ]);
  }
  var coerceString = callGlobalProperty.bind(null, 'asCoerceString');
  var coerceObject = callGlobalProperty.bind(null, 'asCoerceObject');
  var coercers = createEmptyObject();
  coercers[Multiname.Int] = coerceInt;
  coercers[Multiname.Uint] = coerceUint;
  coercers[Multiname.Number] = coerceNumber;
  coercers[Multiname.String] = coerceString;
  coercers[Multiname.Object] = coerceObject;
  coercers[Multiname.Boolean] = coerceBoolean;
  function getCoercerForType(multiname) {
    true;
    return coercers[Multiname.getQualifiedName(multiname)];
  }
  var callableConstructors = createEmptyObject();
  callableConstructors[Multiname.Int] = coerceInt;
  callableConstructors[Multiname.Uint] = coerceUint;
  callableConstructors[Multiname.Number] = callGlobalProperty.bind(null, 'Number');
  callableConstructors[Multiname.String] = callGlobalProperty.bind(null, 'String');
  callableConstructors[Multiname.Object] = callGlobalProperty.bind(null, 'Object');
  callableConstructors[Multiname.Boolean] = callGlobalProperty.bind(null, 'Boolean');
  function getCallableConstructorForType(multiname) {
    true;
    return callableConstructors[Multiname.getQualifiedName(multiname)];
  }
  var Builder = function () {
      function builder(methodInfo, scope, hasDynamicScope) {
        true;
        this.abc = methodInfo.abc;
        this.scope = scope;
        this.methodInfo = methodInfo;
        this.hasDynamicScope = hasDynamicScope;
      }
      builder.prototype.buildStart = function (start) {
        var mi = this.methodInfo;
        var state = start.entryState = new State(0);
        state.local.push(new This(start));
        var parameterIndexOffset = this.hasDynamicScope ? 1 : 0;
        var parameterCount = mi.parameters.length;
        for (var i = 0; i < parameterCount; i++) {
          state.local.push(new Parameter(start, parameterIndexOffset + i, PARAMETER_PREFIX + mi.parameters[i].name));
        }
        for (var i = parameterCount; i < mi.localCount; i++) {
          state.local.push(Undefined);
        }
        state.store = new Projection(start, Projection.Type.STORE);
        if (this.hasDynamicScope) {
          start.scope = new Parameter(start, 0, SAVED_SCOPE_NAME);
        } else {
          start.scope = new Constant(this.scope);
        }
        state.saved = new Projection(start, Projection.Type.SCOPE);
        start.domain = new Constant(this.domain);
        var args = new IR.Arguments(start);
        if (mi.needsRest() || mi.needsArguments()) {
          var offset = constant(parameterIndexOffset + (mi.needsRest() ? parameterCount : 0));
          state.local[parameterCount + 1] = new Call(start, state.store, globalProperty('sliceArguments'), null, [
            args,
            offset
          ], IR.Flags.PRISTINE);
        }
        var argumentsLength = getJSPropertyWithState(state, args, 'length');
        for (var i = 0; i < parameterCount; i++) {
          var parameter = mi.parameters[i];
          var index = i + 1;
          var local = state.local[index];
          if (parameter.value !== undefined) {
            var condition = new IR.Binary(Operator.LT, argumentsLength, constant(parameterIndexOffset + i + 1));
            local = new IR.Latch(null, condition, constant(parameter.value), local);
          }
          if (parameter.type && !parameter.type.isAnyName()) {
            var coercer = getCoercerForType(parameter.type);
            if (coercer) {
              local = coercer(local);
            } else if (c4CoerceNonPrimitiveParameters) {
              local = new Call(start, state.store, globalProperty('asCoerceByMultiname'), null, [
                constant(this.abc.domain),
                constant(parameter.type),
                local
              ], true);
            }
          }
          state.local[index] = local;
        }
        return start;
      };
      builder.prototype.buildGraph = function buildGraph(callerRegion, callerState, inlineArguments) {
        var analysis = this.methodInfo.analysis;
        var blocks = analysis.blocks;
        var bytecodes = analysis.bytecodes;
        var methodInfo = this.methodInfo;
        var ints = this.abc.constantPool.ints;
        var uints = this.abc.constantPool.uints;
        var doubles = this.abc.constantPool.doubles;
        var strings = this.abc.constantPool.strings;
        var methods = this.abc.methods;
        var classes = this.abc.classes;
        var multinames = this.abc.constantPool.multinames;
        var domain = new Constant(this.abc.domain);
        var traceBuilder = c4TraceLevel.value > 2;
        var stopPoints = [];
        for (var i = 0; i < blocks.length; i++) {
          blocks[i].blockDominatorOrder = i;
        }
        var worklist = new SortedList(function compare(a, b) {
            return a.block.blockDominatorOrder - b.block.blockDominatorOrder;
          });
        var start = new Start(null);
        this.buildStart(start);
        var createFunctionCallee = globalProperty('createFunction');
        worklist.push({
          region: start,
          block: blocks[0]
        });
        var next;
        while (next = worklist.pop()) {
          buildBlock(next.region, next.block, next.region.entryState.clone()).forEach(function (stop) {
            var target = stop.target;
            var region = target.region;
            if (region) {
              traceBuilder && writer.enter('Merging into region: ' + region + ' @ ' + target.position + ', block ' + target.bid + ' {');
              traceBuilder && writer.writeLn('  R ' + region.entryState);
              traceBuilder && writer.writeLn('+ I ' + stop.state);
              region.entryState.merge(region, stop.state);
              region.predecessors.push(stop.control);
              traceBuilder && writer.writeLn('  = ' + region.entryState);
              traceBuilder && writer.leave('}');
            } else {
              region = target.region = new Region(stop.control);
              if (target.loop) {
                traceBuilder && writer.writeLn('Adding PHIs to loop region.');
              }
              region.entryState = target.loop ? stop.state.makeLoopPhis(region) : stop.state.clone(target.position);
              traceBuilder && writer.writeLn('Adding new region: ' + region + ' @ ' + target.position + ' to worklist.');
              worklist.push({
                region: region,
                block: target
              });
            }
          });
          traceBuilder && writer.enter('Worklist: {');
          worklist.forEach(function (item) {
            traceBuilder && writer.writeLn(item.region + ' ' + item.block.bdo + ' ' + item.region.entryState);
          });
          traceBuilder && writer.leave('}');
        }
        traceBuilder && writer.writeLn('Done');
        function buildBlock(region, block, state) {
          true;
          state.optimize();
          var typeState = block.entryState;
          if (typeState) {
            traceBuilder && writer.writeLn('Type State: ' + typeState);
            for (var i = 0; i < typeState.local.length; i++) {
              var type = typeState.local[i];
              var local = state.local[i];
              if (local.ty) {
              } else {
                local.ty = type;
              }
            }
          }
          var local = state.local;
          var stack = state.stack;
          var scope = state.scope;
          function savedScope() {
            return state.saved;
          }
          function topScope(depth) {
            if (depth !== undefined) {
              if (depth < scope.length) {
                return scope[scope.length - 1 - depth];
              } else if (depth === scope.length) {
                return savedScope();
              } else {
                var s = savedScope();
                var savedScopeDepth = depth - scope.length;
                for (var i = 0; i < savedScopeDepth; i++) {
                  s = getJSProperty(s, 'parent');
                }
                return s;
              }
            }
            if (scope.length > 0) {
              return scope.top();
            }
            return savedScope();
          }
          var object, receiver, index, callee, value, multiname, type, args, pristine, left, right, operator;
          function push(x) {
            true;
            if (bc.ti) {
              if (x.ty) {
              } else {
                x.ty = bc.ti.type;
              }
            }
            stack.push(x);
          }
          function pop() {
            return stack.pop();
          }
          function popMany(count) {
            return stack.popMany(count);
          }
          function pushLocal(index) {
            push(local[index]);
          }
          function popLocal(index) {
            local[index] = shouldNotFloat(pop());
          }
          function buildMultiname(index) {
            var multiname = multinames[index];
            var namespaces, name, flags = multiname.flags;
            if (multiname.isRuntimeName()) {
              name = stack.pop();
            } else {
              name = constant(multiname.name);
            }
            if (multiname.isRuntimeNamespace()) {
              namespaces = shouldFloat(new NewArray(region, [
                pop()
              ]));
            } else {
              namespaces = constant(multiname.namespaces);
            }
            return new IR.ASMultiname(namespaces, name, flags);
          }
          function simplifyName(name) {
            if (isMultinameConstant(name) && Multiname.isQName(name.value)) {
              return constant(Multiname.getQualifiedName(name.value));
            }
            return name;
          }
          function findProperty(multiname, strict, ti) {
            var slowPath = new IR.ASFindProperty(region, state.store, topScope(), multiname, domain, strict);
            if (ti) {
              if (ti.object) {
                if (ti.object instanceof Global && !ti.object.isExecuting()) {
                  warn('Can\'t optimize findProperty ' + multiname + ', global object is not yet executed or executing.');
                  return slowPath;
                }
                return constant(ti.object);
              } else if (ti.scopeDepth !== undefined) {
                return getScopeObject(topScope(ti.scopeDepth));
              }
            }
            warn('Can\'t optimize findProperty ' + multiname);
            return slowPath;
          }
          function getJSProperty(object, path) {
            return getJSPropertyWithState(state, object, path);
          }
          function coerce(multiname, value) {
            if (false && isConstant(value)) {
              return constant(asCoerceByMultiname(domain.value, multiname, value.value));
            } else {
              var coercer = getCoercerForType(multiname);
              if (coercer) {
                return coercer(value);
              }
            }
            if (c4CoerceNonPrimitive) {
              return call(globalProperty('asCoerceByMultiname'), null, [
                domain,
                constant(multiname),
                value
              ]);
            }
            return value;
          }
          function getScopeObject(scope) {
            if (scope instanceof IR.ASScope) {
              return scope.object;
            }
            return getJSProperty(scope, 'object');
          }
          function store(node) {
            state.store = new Projection(node, Projection.Type.STORE);
            node.loads = state.loads.slice(0);
            state.loads.length = 0;
            return node;
          }
          function load(node) {
            state.loads.push(node);
            return node;
          }
          function resolveMultinameGlobally(multiname) {
            var namespaces = multiname.namespaces;
            var name = multiname.name;
            if (!globalMultinameAnalysis.value) {
              return;
            }
            if (!isConstant(namespaces) || !isConstant(name) || multiname.isAttribute()) {
              Counter.count('GlobalMultinameResolver: Cannot resolve runtime multiname or attribute.');
              return;
            }
            if (isNumeric(name.value) || !isString(name.value) || !name.value) {
              Counter.count('GlobalMultinameResolver: Cannot resolve numeric or any names.');
              return false;
            }
            return GlobalMultinameResolver.resolveMultiname(new Multiname(namespaces.value, name.value, multiname.flags));
          }
          function callProperty(object, multiname, args, isLex, ti) {
            if (ti && ti.trait) {
              if (ti.trait.isMethod()) {
                var openQn;
                if (ti.trait.holder instanceof InstanceInfo && ti.trait.holder.isInterface()) {
                  openQn = Multiname.getPublicQualifiedName(Multiname.getName(ti.trait.name));
                } else {
                  openQn = Multiname.getQualifiedName(ti.trait.name);
                }
                openQn = VM_OPEN_METHOD_PREFIX + openQn;
                return store(new IR.CallProperty(region, state.store, object, constant(openQn), args, IR.Flags.PRISTINE));
              } else if (ti.trait.isClass()) {
                var constructor = getCallableConstructorForType(ti.trait.name);
                if (constructor) {
                  return constructor(args[0]);
                }
                var qn = Multiname.getQualifiedName(ti.trait.name);
                return store(new IR.CallProperty(region, state.store, object, constant(qn), args, 0));
              }
            } else if (ti && ti.propertyQName) {
              return store(new IR.CallProperty(region, state.store, object, constant(ti.propertyQName), args, IR.Flags.PRISTINE));
            }
            var qn = resolveMultinameGlobally(multiname);
            if (qn) {
              return store(new IR.ASCallProperty(region, state.store, object, constant(Multiname.getQualifiedName(qn)), args, IR.Flags.PRISTINE | IR.Flags.RESOLVED, isLex));
            }
            return store(new IR.ASCallProperty(region, state.store, object, multiname, args, IR.Flags.PRISTINE, isLex));
          }
          function getProperty(object, multiname, ti, getOpenMethod, ic) {
            true;
            getOpenMethod = !(!getOpenMethod);
            if (ti) {
              if (ti.trait) {
                if (ti.trait.isConst() && ti.trait.hasDefaultValue) {
                  return constant(ti.trait.value);
                }
                var get = new IR.GetProperty(region, state.store, object, qualifiedNameConstant(ti.trait.name));
                return ti.trait.isGetter() ? store(get) : load(get);
              }
              if (ti.propertyQName) {
                return store(new IR.GetProperty(region, state.store, object, constant(ti.propertyQName)));
              } else if (ti.isDirectlyReadable) {
                return store(new IR.GetProperty(region, state.store, object, multiname.name));
              } else if (ti.isIndexedReadable) {
                return store(new IR.ASGetProperty(region, state.store, object, multiname, IR.Flags.INDEXED | (getOpenMethod ? IR.Flagas.IS_METHOD : 0)));
              }
            }
            warn('Can\'t optimize getProperty ' + multiname);
            var qn = resolveMultinameGlobally(multiname);
            if (qn) {
              return store(new IR.ASGetProperty(region, state.store, object, constant(Multiname.getQualifiedName(qn)), IR.Flags.RESOLVED | (getOpenMethod ? IR.Flagas.IS_METHOD : 0)));
            }
            Counter.count('Compiler: Slow ASGetProperty');
            return store(new IR.ASGetProperty(region, state.store, object, multiname, getOpenMethod ? IR.Flagas.IS_METHOD : 0));
          }
          function setProperty(object, multiname, value, ti, ic) {
            true;
            if (ti) {
              if (ti.trait) {
                store(new IR.SetProperty(region, state.store, object, qualifiedNameConstant(ti.trait.name), value));
                return;
              }
              if (ti.propertyQName) {
                return store(new IR.SetProperty(region, state.store, object, constant(ti.propertyQName), value));
              } else if (ti.isDirectlyWriteable) {
                return store(new IR.SetProperty(region, state.store, object, multiname.name, value));
              } else if (ti.isIndexedWriteable) {
                return store(new IR.ASSetProperty(region, state.store, object, multiname, value, IR.Flags.INDEXED));
              }
            }
            warn('Can\'t optimize setProperty ' + multiname);
            var qn = resolveMultinameGlobally(multiname);
            if (qn) {
            }
            return store(new IR.ASSetProperty(region, state.store, object, multiname, value, 0));
          }
          function getDescendants(object, name, ti) {
            name = simplifyName(name);
            return new IR.ASGetDescendants(region, state.store, object, name);
          }
          function getSlot(object, index, ti) {
            if (ti) {
              var trait = ti.trait;
              if (trait) {
                if (trait.isConst() && ti.trait.hasDefaultValue) {
                  return constant(trait.value);
                }
                var slotQn = Multiname.getQualifiedName(trait.name);
                return store(new IR.GetProperty(region, state.store, object, constant(slotQn)));
              }
            }
            return store(new IR.ASGetSlot(null, state.store, object, index));
          }
          function setSlot(object, index, value, ti) {
            if (ti) {
              var trait = ti.trait;
              if (trait) {
                var slotQn = Multiname.getQualifiedName(trait.name);
                store(new IR.SetProperty(region, state.store, object, constant(slotQn), value));
                return;
              }
            }
            store(new IR.ASSetSlot(region, state.store, object, index, value));
          }
          function call(callee, object, args) {
            return store(new Call(region, state.store, callee, object, args, IR.Flags.PRISTINE));
          }
          function callCall(callee, object, args, pristine) {
            return store(new Call(region, state.store, callee, object, args, pristine ? IR.Flags.PRISTINE : 0));
          }
          function truthyCondition(operator) {
            var right;
            if (operator.isBinary()) {
              right = pop();
            }
            var left = pop();
            var node;
            if (right) {
              node = binary(operator, left, right);
            } else {
              node = unary(operator, left);
            }
            if (peepholeOptimizer) {
              node = peepholeOptimizer.tryFold(node, true);
            }
            return node;
          }
          function negatedTruthyCondition(operator) {
            var node = unary(Operator.FALSE, truthyCondition(operator));
            if (peepholeOptimizer) {
              node = peepholeOptimizer.tryFold(node, true);
            }
            return node;
          }
          function pushExpression(operator, toInt) {
            var left, right;
            if (operator.isBinary()) {
              right = pop();
              left = pop();
              if (toInt) {
                right = coerceInt(right);
                left = coerceInt(left);
              }
              push(binary(operator, left, right));
            } else {
              left = pop();
              if (toInt) {
                left = coerceInt(left);
              }
              push(unary(operator, left));
            }
          }
          var stops = null;
          function buildIfStops(predicate) {
            true;
            var _if = new IR.If(region, predicate);
            stops = [
              {
                control: new Projection(_if, Projection.Type.FALSE),
                target: bytecodes[bc.position + 1],
                state: state
              },
              {
                control: new Projection(_if, Projection.Type.TRUE),
                target: bc.target,
                state: state
              }
            ];
          }
          function buildJumpStop() {
            true;
            stops = [
              {
                control: region,
                target: bc.target,
                state: state
              }
            ];
          }
          function buildThrowStop() {
            true;
            stops = [];
          }
          function buildReturnStop() {
            true;
            stops = [];
          }
          function buildSwitchStops(determinant) {
            true;
            if (bc.targets.length > 2) {
              stops = [];
              var _switch = new IR.Switch(region, determinant);
              for (var i = 0; i < bc.targets.length; i++) {
                stops.push({
                  control: new Projection(_switch, Projection.Type.CASE, constant(i)),
                  target: bc.targets[i],
                  state: state
                });
              }
            } else {
              true;
              var predicate = binary(Operator.SEQ, determinant, constant(0));
              var _if = new IR.If(region, predicate);
              stops = [
                {
                  control: new Projection(_if, Projection.Type.FALSE),
                  target: bc.targets[1],
                  state: state
                },
                {
                  control: new Projection(_if, Projection.Type.TRUE),
                  target: bc.targets[0],
                  state: state
                }
              ];
            }
          }
          if (traceBuilder) {
            writer.writeLn('Processing Region: ' + region + ', Block: ' + block.bid);
            writer.enter(('> state: ' + region.entryState.toString()).padRight(' ', 100));
          }
          region.processed = true;
          var bc;
          for (var bci = block.position, end = block.end.position; bci <= end; bci++) {
            bc = bytecodes[bci];
            var op = bc.op;
            state.index = bci;
            switch (op) {
            case 3:
              store(new IR.Throw(region, pop()));
              stopPoints.push({
                region: region,
                store: state.store,
                value: Undefined
              });
              buildThrowStop();
              break;
            case 98:
              pushLocal(bc.index);
              break;
            case 208:
            case 209:
            case 210:
            case 211:
              pushLocal(op - OP_getlocal0);
              break;
            case 99:
              popLocal(bc.index);
              break;
            case 212:
            case 213:
            case 214:
            case 215:
              popLocal(op - OP_setlocal0);
              break;
            case 28:
              scope.push(new IR.ASScope(topScope(), pop(), true));
              break;
            case 48:
              scope.push(new IR.ASScope(topScope(), pop(), false));
              break;
            case 29:
              scope.pop();
              break;
            case 100:
              push(new IR.ASGlobal(null, topScope()));
              break;
            case 101:
              push(getScopeObject(state.scope[bc.index]));
              break;
            case 93:
              push(findProperty(buildMultiname(bc.index), true, bc.ti));
              break;
            case 94:
              push(findProperty(buildMultiname(bc.index), false, bc.ti));
              break;
            case 102:
              multiname = buildMultiname(bc.index);
              object = pop();
              push(getProperty(object, multiname, bc.ti, false, ic(bc)));
              break;
            case 89:
              multiname = buildMultiname(bc.index);
              object = pop();
              push(getDescendants(object, multiname, bc.ti));
              break;
            case 96:
              multiname = buildMultiname(bc.index);
              push(getProperty(findProperty(multiname, true, bc.ti), multiname, bc.ti, false, ic(bc)));
              break;
            case 104:
            case 97:
              value = pop();
              multiname = buildMultiname(bc.index);
              object = pop();
              setProperty(object, multiname, value, bc.ti, ic(bc));
              break;
            case 106:
              multiname = buildMultiname(bc.index);
              object = pop();
              push(store(new IR.ASDeleteProperty(region, state.store, object, multiname)));
              break;
            case 108:
              object = pop();
              push(getSlot(object, constant(bc.index), bc.ti));
              break;
            case 109:
              value = pop();
              object = pop();
              setSlot(object, constant(bc.index), value, bc.ti);
              break;
            case 4:
              multiname = buildMultiname(bc.index);
              object = pop();
              push(call(globalProperty('getSuper'), null, [
                savedScope(),
                object,
                multiname
              ]));
              break;
            case 5:
              value = pop();
              multiname = buildMultiname(bc.index);
              object = pop();
              store(call(globalProperty('setSuper'), null, [
                savedScope(),
                object,
                multiname,
                value
              ]));
              break;
            case 241:
            case 240:
              break;
            case 64:
              push(callPure(createFunctionCallee, null, [
                constant(methods[bc.index]),
                topScope(),
                constant(true)
              ]));
              break;
            case 65:
              args = popMany(bc.argCount);
              object = pop();
              callee = pop();
              push(callCall(callee, object, args));
              break;
            case 70:
            case 79:
            case 76:
              args = popMany(bc.argCount);
              multiname = buildMultiname(bc.index);
              object = pop();
              value = callProperty(object, multiname, args, op === OP_callproplex, bc.ti);
              if (op !== OP_callpropvoid) {
                push(value);
              }
              break;
            case 69:
            case 78:
              multiname = buildMultiname(bc.index);
              args = popMany(bc.argCount);
              object = pop();
              callee = call(globalProperty('getSuper'), null, [
                savedScope(),
                object,
                multiname
              ]);
              value = call(callee, object, args);
              if (op !== OP_callsupervoid) {
                push(value);
              }
              break;
            case 66:
              args = popMany(bc.argCount);
              object = pop();
              push(store(new IR.ASNew(region, state.store, object, args)));
              break;
            case 73:
              args = popMany(bc.argCount);
              object = pop();
              if (!(bc.ti && bc.ti.noCallSuperNeeded)) {
                callee = getJSProperty(savedScope(), 'object.baseClass.instanceConstructorNoInitialize');
                call(callee, object, args);
              }
              break;
            case 74:
              args = popMany(bc.argCount);
              multiname = buildMultiname(bc.index);
              object = pop();
              callee = getProperty(object, multiname, bc.ti, false, ic(bc));
              push(store(new IR.ASNew(region, state.store, callee, args)));
              break;
            case 128:
              if (bc.ti && bc.ti.noCoercionNeeded) {
                Counter.count('Compiler: NoCoercionNeeded');
                break;
              } else {
                Counter.count('Compiler: CoercionNeeded');
              }
              value = pop();
              push(coerce(multinames[bc.index], value));
              break;
            case 131:
            case 115:
              push(coerceInt(pop()));
              break;
            case 136:
            case 116:
              push(coerceUint(pop()));
              break;
            case 132:
            case 117:
              push(coerceNumber(pop()));
              break;
            case 129:
            case 118:
              push(coerceBoolean(pop()));
              break;
            case 120:
              push(call(globalProperty('checkFilter'), null, [
                pop()
              ]));
              break;
            case 130:
              break;
            case 133:
              push(coerceString(pop()));
              break;
            case 112:
              push(convertString(pop()));
              break;
            case 135:
              type = pop();
              if (c4AsTypeLate) {
                value = pop();
                push(call(globalProperty('asAsType'), null, [
                  type,
                  value
                ]));
              }
              break;
            case 72:
            case 71:
              value = Undefined;
              if (op === OP_returnvalue) {
                value = pop();
                if (methodInfo.returnType) {
                  if (!(bc.ti && bc.ti.noCoercionNeeded)) {
                    value = coerce(methodInfo.returnType, value);
                  }
                }
              }
              stopPoints.push({
                region: region,
                store: state.store,
                value: value
              });
              buildReturnStop();
              break;
            case 30:
            case 35:
              index = pop();
              object = pop();
              push(new IR.CallProperty(region, state.store, object, constant(op === OP_nextname ? 'asNextName' : 'asNextValue'), [
                index
              ], IR.Flags.PRISTINE));
              break;
            case 50:
              var temp = call(globalProperty('asHasNext2'), null, [
                  local[bc.object],
                  local[bc.index]
                ]);
              local[bc.object] = getJSProperty(temp, 'object');
              push(local[bc.index] = getJSProperty(temp, 'index'));
              break;
            case 32:
              push(Null);
              break;
            case 33:
              push(Undefined);
              break;
            case 34:
              notImplemented();
              break;
            case 36:
              push(constant(bc.value));
              break;
            case 37:
              push(constant(bc.value));
              break;
            case 44:
              push(constant(strings[bc.index]));
              break;
            case 45:
              push(constant(ints[bc.index]));
              break;
            case 46:
              push(constant(uints[bc.index]));
              break;
            case 47:
              push(constant(doubles[bc.index]));
              break;
            case 38:
              push(constant(true));
              break;
            case 39:
              push(constant(false));
              break;
            case 40:
              push(constant(NaN));
              break;
            case 41:
              pop();
              break;
            case 42:
              value = shouldNotFloat(pop());
              push(value);
              push(value);
              break;
            case 43:
              state.stack.push(pop(), pop());
              break;
            case 239:
            case OP_debugline:
            case OP_debugfile:
              break;
            case 12:
              buildIfStops(negatedTruthyCondition(Operator.LT));
              break;
            case 24:
              buildIfStops(truthyCondition(Operator.GE));
              break;
            case 13:
              buildIfStops(negatedTruthyCondition(Operator.LE));
              break;
            case 23:
              buildIfStops(truthyCondition(Operator.GT));
              break;
            case 14:
              buildIfStops(negatedTruthyCondition(Operator.GT));
              break;
            case 22:
              buildIfStops(truthyCondition(Operator.LE));
              break;
            case 15:
              buildIfStops(negatedTruthyCondition(Operator.GE));
              break;
            case 21:
              buildIfStops(truthyCondition(Operator.LT));
              break;
            case 16:
              buildJumpStop();
              break;
            case 17:
              buildIfStops(truthyCondition(Operator.TRUE));
              break;
            case 18:
              buildIfStops(truthyCondition(Operator.FALSE));
              break;
            case 19:
              buildIfStops(truthyCondition(Operator.EQ));
              break;
            case 20:
              buildIfStops(truthyCondition(Operator.NE));
              break;
            case 25:
              buildIfStops(truthyCondition(Operator.SEQ));
              break;
            case 26:
              buildIfStops(truthyCondition(Operator.SNE));
              break;
            case 27:
              buildSwitchStops(pop());
              break;
            case 150:
              pushExpression(Operator.FALSE);
              break;
            case 151:
              pushExpression(Operator.BITWISE_NOT);
              break;
            case 160:
              right = pop();
              left = pop();
              if (typesAreEqual(left, right)) {
                operator = Operator.ADD;
              } else if (useAsAdd) {
                operator = Operator.AS_ADD;
              } else {
                operator = Operator.ADD;
              }
              push(binary(operator, left, right));
              break;
            case 197:
              pushExpression(Operator.ADD, true);
              break;
            case 161:
              pushExpression(Operator.SUB);
              break;
            case 198:
              pushExpression(Operator.SUB, true);
              break;
            case 162:
              pushExpression(Operator.MUL);
              break;
            case 199:
              pushExpression(Operator.MUL, true);
              break;
            case 163:
              pushExpression(Operator.DIV);
              break;
            case 164:
              pushExpression(Operator.MOD);
              break;
            case 165:
              pushExpression(Operator.LSH);
              break;
            case 166:
              pushExpression(Operator.RSH);
              break;
            case 167:
              pushExpression(Operator.URSH);
              break;
            case 168:
              pushExpression(Operator.AND);
              break;
            case 169:
              pushExpression(Operator.OR);
              break;
            case 170:
              pushExpression(Operator.XOR);
              break;
            case 171:
              pushExpression(Operator.EQ);
              break;
            case 172:
              pushExpression(Operator.SEQ);
              break;
            case 173:
              pushExpression(Operator.LT);
              break;
            case 174:
              pushExpression(Operator.LE);
              break;
            case 175:
              pushExpression(Operator.GT);
              break;
            case 176:
              pushExpression(Operator.GE);
              break;
            case 144:
              pushExpression(Operator.NEG);
              break;
            case 196:
              pushExpression(Operator.NEG, true);
              break;
            case 145:
            case 192:
            case 147:
            case 193:
              push(constant(1));
              if (op === OP_increment || op === OP_decrement) {
                push(coerceNumber(pop()));
              } else {
                push(coerceInt(pop()));
              }
              if (op === OP_increment || op === OP_increment_i) {
                pushExpression(Operator.ADD);
              } else {
                pushExpression(Operator.SUB);
              }
              break;
            case 146:
            case 194:
            case 148:
            case 195:
              push(constant(1));
              if (op === OP_inclocal || op === OP_declocal) {
                push(coerceNumber(local[bc.index]));
              } else {
                push(coerceInt(local[bc.index]));
              }
              if (op === OP_inclocal || op === OP_inclocal_i) {
                pushExpression(Operator.ADD);
              } else {
                pushExpression(Operator.SUB);
              }
              popLocal(bc.index);
              break;
            case 177:
              type = pop();
              value = pop();
              push(call(getJSProperty(type, 'isInstanceOf'), null, [
                value
              ]));
              break;
            case 178:
              value = pop();
              multiname = buildMultiname(bc.index);
              type = getProperty(findProperty(multiname, false), multiname);
              push(call(globalProperty('asIsType'), null, [
                type,
                value
              ]));
              break;
            case 179:
              type = pop();
              value = pop();
              push(call(globalProperty('asIsType'), null, [
                type,
                value
              ]));
              break;
            case 180:
              object = pop();
              value = pop();
              multiname = new IR.ASMultiname(Undefined, value, 0);
              push(store(new IR.ASHasProperty(region, state.store, object, multiname)));
              break;
            case 149:
              push(call(globalProperty('asTypeOf'), null, [
                pop()
              ]));
              break;
            case 8:
              push(Undefined);
              popLocal(bc.index);
              break;
            case 83:
              args = popMany(bc.argCount);
              type = pop();
              callee = globalProperty('applyType');
              push(call(callee, null, [
                domain,
                type,
                new NewArray(region, args)
              ]));
              break;
            case 86:
              args = popMany(bc.argCount);
              push(new NewArray(region, args));
              break;
            case 85:
              var properties = [];
              for (var i = 0; i < bc.argCount; i++) {
                var value = pop();
                var key = pop();
                true;
                key = constant(Multiname.getPublicQualifiedName(key.value));
                properties.push(new KeyValuePair(key, value));
              }
              push(new NewObject(region, properties));
              break;
            case 87:
              push(new IR.ASNewActivation(constant(methodInfo)));
              break;
            case 88:
              callee = globalProperty('createClass');
              push(call(callee, null, [
                constant(classes[bc.index]),
                pop(),
                topScope()
              ]));
              break;
            default:
              unexpected('Not Implemented: ' + bc);
            }
            if (op === OP_debug || op === OP_debugfile || op === OP_debugline) {
              continue;
            }
            if (traceBuilder) {
              writer.writeLn(('state: ' + state.toString()).padRight(' ', 100) + ' : ' + bci + ', ' + bc.toString(this.abc));
            }
          }
          if (traceBuilder) {
            writer.leave(('< state: ' + state.toString()).padRight(' ', 100));
          }
          if (!stops) {
            stops = [];
            if (bc.position + 1 <= bytecodes.length) {
              stops.push({
                control: region,
                target: bytecodes[bc.position + 1],
                state: state
              });
            }
          }
          return stops;
        }
        var stop;
        if (stopPoints.length > 1) {
          var stopRegion = new Region(null);
          var stopValuePhi = new Phi(stopRegion, null);
          var stopStorePhi = new Phi(stopRegion, null);
          stopPoints.forEach(function (stopPoint) {
            stopRegion.predecessors.push(stopPoint.region);
            stopValuePhi.pushValue(stopPoint.value);
            stopStorePhi.pushValue(stopPoint.store);
          });
          stop = new Stop(stopRegion, stopStorePhi, stopValuePhi);
        } else {
          stop = new Stop(stopPoints[0].region, stopPoints[0].store, stopPoints[0].value);
        }
        return new DFG(stop);
      };
      return builder;
    }();
  function buildMethod(verifier, methodInfo, scope, hasDynamicScope) {
    true;
    true;
    true;
    Counter.count('Compiler: Compiled Methods');
    Timer.start('Compiler');
    Timer.start('Mark Loops');
    methodInfo.analysis.markLoops();
    Timer.stop();
    if (enableVerifier.value) {
      Timer.start('Verify');
      verifier.verifyMethod(methodInfo, scope);
      Timer.stop();
    }
    var traceSource = c4TraceLevel.value > 0;
    var traceIR = c4TraceLevel.value > 1;
    Timer.start('Build IR');
    Node.startNumbering();
    var dfg = new Builder(methodInfo, scope, hasDynamicScope).buildGraph();
    Timer.stop();
    traceIR && dfg.trace(writer);
    Timer.start('Build CFG');
    var cfg = dfg.buildCFG();
    Timer.stop();
    Timer.start('Optimize Phis');
    cfg.optimizePhis();
    Timer.stop();
    Timer.start('Schedule Nodes');
    cfg.scheduleEarly();
    Timer.stop();
    traceIR && cfg.trace(writer);
    Timer.start('Verify IR');
    cfg.verify();
    Timer.stop();
    Timer.start('Allocate Variables');
    cfg.allocateVariables();
    Timer.stop();
    Timer.start('Generate Source');
    var result = Backend.generate(cfg, enableRegisterAllocator.value);
    Timer.stop();
    traceSource && writer.writeLn(result.body);
    Node.stopNumbering();
    Timer.stop();
    return result;
  }
  exports.buildMethod = buildMethod;
}(typeof exports === 'undefined' ? Builder = {} : exports));
var Compiler = new (function () {
    function constructor() {
      this.verifier = new Verifier();
    }
    constructor.prototype.compileMethod = function (methodInfo, scope, hasDynamicScope) {
      return Builder.buildMethod(this.verifier, methodInfo, scope, hasDynamicScope);
    };
    return constructor;
  }())();
(function (exports) {
  var Control = function () {
      var SEQ = 1;
      var LOOP = 2;
      var IF = 3;
      var CASE = 4;
      var SWITCH = 5;
      var LABEL_CASE = 6;
      var LABEL_SWITCH = 7;
      var EXIT = 8;
      var BREAK = 9;
      var CONTINUE = 10;
      var TRY = 11;
      var CATCH = 12;
      function Seq(body) {
        this.kind = SEQ;
        this.body = body;
      }
      Seq.prototype = {
        trace: function (writer) {
          var body = this.body;
          for (var i = 0, j = body.length; i < j; i++) {
            body[i].trace(writer);
          }
        },
        first: function () {
          return this.body[0];
        },
        slice: function (begin, end) {
          return new Seq(this.body.slice(begin, end));
        }
      };
      function Loop(body) {
        this.kind = LOOP;
        this.body = body;
      }
      Loop.prototype = {
        trace: function (writer) {
          writer.enter('loop {');
          this.body.trace(writer);
          writer.leave('}');
        }
      };
      function If(cond, then, els, nothingThrownLabel) {
        this.kind = IF;
        this.cond = cond;
        this.then = then;
        this.else = els;
        this.negated = false;
        this.nothingThrownLabel = nothingThrownLabel;
      }
      If.prototype = {
        trace: function (writer) {
          this.cond.trace(writer);
          if (this.nothingThrownLabel) {
            writer.enter('if (label is ' + this.nothingThrownLabel + ') {');
          }
          writer.enter('if' + (this.negated ? ' not' : '') + ' {');
          this.then && this.then.trace(writer);
          if (this.else) {
            writer.outdent();
            writer.enter('} else {');
            this.else.trace(writer);
          }
          writer.leave('}');
          if (this.nothingThrownLabel) {
            writer.leave('}');
          }
        }
      };
      function Case(index, body) {
        this.kind = CASE;
        this.index = index;
        this.body = body;
      }
      Case.prototype = {
        trace: function (writer) {
          if (this.index >= 0) {
            writer.writeLn('case ' + this.index + ':');
          } else {
            writer.writeLn('default:');
          }
          writer.indent();
          this.body && this.body.trace(writer);
          writer.outdent();
        }
      };
      function Switch(determinant, cases, nothingThrownLabel) {
        this.kind = SWITCH;
        this.determinant = determinant;
        this.cases = cases;
        this.nothingThrownLabel = nothingThrownLabel;
      }
      Switch.prototype = {
        trace: function (writer) {
          if (this.nothingThrownLabel) {
            writer.enter('if (label is ' + this.nothingThrownLabel + ') {');
          }
          this.determinant.trace(writer);
          writer.writeLn('switch {');
          for (var i = 0, j = this.cases.length; i < j; i++) {
            this.cases[i].trace(writer);
          }
          writer.writeLn('}');
          if (this.nothingThrownLabel) {
            writer.leave('}');
          }
        }
      };
      function LabelCase(labels, body) {
        this.kind = LABEL_CASE;
        this.labels = labels;
        this.body = body;
      }
      LabelCase.prototype = {
        trace: function (writer) {
          writer.enter('if (label is ' + this.labels.join(' or ') + ') {');
          this.body && this.body.trace(writer);
          writer.leave('}');
        }
      };
      function LabelSwitch(cases) {
        var labelMap = {};
        for (var i = 0, j = cases.length; i < j; i++) {
          var c = cases[i];
          if (!c.labels) {
            print(c.toSource());
          }
          for (var k = 0, l = c.labels.length; k < l; k++) {
            labelMap[c.labels[k]] = c;
          }
        }
        this.kind = LABEL_SWITCH;
        this.cases = cases;
        this.labelMap = labelMap;
      }
      LabelSwitch.prototype = {
        trace: function (writer) {
          for (var i = 0, j = this.cases.length; i < j; i++) {
            this.cases[i].trace(writer);
          }
        }
      };
      function Exit(label) {
        this.kind = EXIT;
        this.label = label;
      }
      Exit.prototype = {
        trace: function (writer) {
          writer.writeLn('label = ' + this.label);
        }
      };
      function Break(label, head) {
        this.kind = BREAK;
        this.label = label;
        this.head = head;
      }
      Break.prototype = {
        trace: function (writer) {
          this.label && writer.writeLn('label = ' + this.label);
          writer.writeLn('break');
        }
      };
      function Continue(label, head) {
        this.kind = CONTINUE;
        this.label = label;
        this.head = head;
        this.necessary = true;
      }
      Continue.prototype = {
        trace: function (writer) {
          this.label && writer.writeLn('label = ' + this.label);
          this.necessary && writer.writeLn('continue');
        }
      };
      function Try(body, catches) {
        this.kind = TRY;
        this.body = body;
        this.catches = catches;
      }
      Try.prototype = {
        trace: function (writer) {
          writer.enter('try {');
          this.body.trace(writer);
          writer.writeLn('label = ' + this.nothingThrownLabel);
          for (var i = 0, j = this.catches.length; i < j; i++) {
            this.catches[i].trace(writer);
          }
          writer.leave('}');
        }
      };
      function Catch(varName, typeName, body) {
        this.kind = CATCH;
        this.varName = varName;
        this.typeName = typeName;
        this.body = body;
      }
      Catch.prototype = {
        trace: function (writer) {
          writer.outdent();
          writer.enter('} catch (' + (this.varName || 'e') + (this.typeName ? ' : ' + this.typeName : '') + ') {');
          this.body.trace(writer);
        }
      };
      return {
        SEQ: SEQ,
        LOOP: LOOP,
        IF: IF,
        CASE: CASE,
        SWITCH: SWITCH,
        LABEL_CASE: LABEL_CASE,
        LABEL_SWITCH: LABEL_SWITCH,
        EXIT: EXIT,
        BREAK: BREAK,
        CONTINUE: CONTINUE,
        TRY: TRY,
        CATCH: CATCH,
        Seq: Seq,
        Loop: Loop,
        If: If,
        Case: Case,
        Switch: Switch,
        LabelCase: LabelCase,
        LabelSwitch: LabelSwitch,
        Exit: Exit,
        Break: Break,
        Continue: Continue,
        Try: Try,
        Catch: Catch
      };
    }();
  var Analysis = function () {
      function blockSetClass(length, blockById) {
        var BlockSet = BitSetFunctor(length);
        var ADDRESS_BITS_PER_WORD = BlockSet.ADDRESS_BITS_PER_WORD;
        var BITS_PER_WORD = BlockSet.BITS_PER_WORD;
        var BIT_INDEX_MASK = BlockSet.BIT_INDEX_MASK;
        BlockSet.singleton = function singleton(b) {
          var bs = new BlockSet();
          bs.set(b.id);
          bs.count = 1;
          bs.dirty = 0;
          return bs;
        };
        BlockSet.fromBlocks = function fromArray(other) {
          var bs = new BlockSet();
          bs.setBlocks(other);
          return bs;
        };
        var Bsp = BlockSet.prototype;
        if (BlockSet.singleword) {
          Bsp.forEachBlock = function forEach(fn) {
            true;
            var byId = blockById;
            var word = this.bits;
            if (word) {
              for (var k = 0; k < BITS_PER_WORD; k++) {
                if (word & 1 << k) {
                  fn(byId[k]);
                }
              }
            }
          };
          Bsp.choose = function choose() {
            var byId = blockById;
            var word = this.bits;
            if (word) {
              for (var k = 0; k < BITS_PER_WORD; k++) {
                if (word & 1 << k) {
                  return byId[k];
                }
              }
            }
          };
          Bsp.members = function members() {
            var byId = blockById;
            var set = [];
            var word = this.bits;
            if (word) {
              for (var k = 0; k < BITS_PER_WORD; k++) {
                if (word & 1 << k) {
                  set.push(byId[k]);
                }
              }
            }
            return set;
          };
          Bsp.setBlocks = function setBlocks(bs) {
            var bits = this.bits;
            for (var i = 0, j = bs.length; i < j; i++) {
              var id = bs[i].id;
              bits |= 1 << (id & BIT_INDEX_MASK);
            }
            this.bits = bits;
          };
        } else {
          Bsp.forEachBlock = function forEach(fn) {
            true;
            var byId = blockById;
            var bits = this.bits;
            for (var i = 0, j = bits.length; i < j; i++) {
              var word = bits[i];
              if (word) {
                for (var k = 0; k < BITS_PER_WORD; k++) {
                  if (word & 1 << k) {
                    fn(byId[i * BITS_PER_WORD + k]);
                  }
                }
              }
            }
          };
          Bsp.choose = function choose() {
            var byId = blockById;
            var bits = this.bits;
            for (var i = 0, j = bits.length; i < j; i++) {
              var word = bits[i];
              if (word) {
                for (var k = 0; k < BITS_PER_WORD; k++) {
                  if (word & 1 << k) {
                    return byId[i * BITS_PER_WORD + k];
                  }
                }
              }
            }
          };
          Bsp.members = function members() {
            var byId = blockById;
            var set = [];
            var bits = this.bits;
            for (var i = 0, j = bits.length; i < j; i++) {
              var word = bits[i];
              if (word) {
                for (var k = 0; k < BITS_PER_WORD; k++) {
                  if (word & 1 << k) {
                    set.push(byId[i * BITS_PER_WORD + k]);
                  }
                }
              }
            }
            return set;
          };
          Bsp.setBlocks = function setBlocks(bs) {
            var bits = this.bits;
            for (var i = 0, j = bs.length; i < j; i++) {
              var id = bs[i].id;
              bits[id >> ADDRESS_BITS_PER_WORD] |= 1 << (id & BIT_INDEX_MASK);
            }
          };
        }
        return BlockSet;
      }
      function Analysis(cfg, options) {
        this.options = options || {};
        this.BlockSet = blockSetClass(cfg.blocks.length, cfg.blocks);
        this.hasExceptions = false;
        this.normalizeReachableBlocks(cfg.root);
      }
      Analysis.prototype = {
        normalizeReachableBlocks: function normalizeReachableBlocks(root) {
          true;
          var ONCE = 1;
          var BUNCH_OF_TIMES = 2;
          var BlockSet = this.BlockSet;
          var blocks = [];
          var visited = {};
          var ancestors = {};
          var worklist = [
              root
            ];
          var node;
          ancestors[root.id] = true;
          while (node = worklist.top()) {
            if (visited[node.id]) {
              if (visited[node.id] === ONCE) {
                visited[node.id] = BUNCH_OF_TIMES;
                blocks.push(node);
              }
              ancestors[node.id] = false;
              worklist.pop();
              continue;
            }
            visited[node.id] = ONCE;
            ancestors[node.id] = true;
            var successors = node.successors;
            for (var i = 0, j = successors.length; i < j; i++) {
              var s = successors[i];
              if (ancestors[s.id]) {
                if (!node.spbacks) {
                  node.spbacks = new BlockSet();
                }
                node.spbacks.set(s.id);
              }
              !visited[s.id] && worklist.push(s);
            }
          }
          this.blocks = blocks.reverse();
        },
        computeDominance: function computeDominance() {
          function intersectDominators(doms, b1, b2) {
            var finger1 = b1;
            var finger2 = b2;
            while (finger1 !== finger2) {
              while (finger1 > finger2) {
                finger1 = doms[finger1];
              }
              while (finger2 > finger1) {
                finger2 = doms[finger2];
              }
            }
            return finger1;
          }
          var blocks = this.blocks;
          var n = blocks.length;
          var doms = new Array(n);
          doms[0] = 0;
          var rpo = [];
          for (var b = 0; b < n; b++) {
            rpo[blocks[b].id] = b;
            blocks[b].dominatees = [];
          }
          var changed = true;
          while (changed) {
            changed = false;
            for (var b = 1; b < n; b++) {
              var predecessors = blocks[b].predecessors;
              var j = predecessors.length;
              var newIdom = rpo[predecessors[0].id];
              if (!(newIdom in doms)) {
                for (var i = 1; i < j; i++) {
                  newIdom = rpo[predecessors[i].id];
                  if (newIdom in doms) {
                    break;
                  }
                }
              }
              true;
              for (var i = 0; i < j; i++) {
                var p = rpo[predecessors[i].id];
                if (p === newIdom) {
                  continue;
                }
                if (p in doms) {
                  newIdom = intersectDominators(doms, p, newIdom);
                }
              }
              if (doms[b] !== newIdom) {
                doms[b] = newIdom;
                changed = true;
              }
            }
          }
          blocks[0].dominator = blocks[0];
          var block;
          for (var b = 1; b < n; b++) {
            block = blocks[b];
            var idom = blocks[doms[b]];
            block.dominator = idom;
            idom.dominatees.push(block);
            block.npredecessors = block.predecessors.length;
          }
          var worklist = [
              blocks[0]
            ];
          blocks[0].level || (blocks[0].level = 0);
          while (block = worklist.shift()) {
            var dominatees = block.dominatees;
            for (var i = 0, j = dominatees.length; i < j; i++) {
              dominatees[i].level = block.level + 1;
            }
            worklist.push.apply(worklist, dominatees);
          }
        },
        computeFrontiers: function computeFrontiers() {
          var BlockSet = this.BlockSet;
          var blocks = this.blocks;
          for (var b = 0, n = blocks.length; b < n; b++) {
            blocks[b].frontier = new BlockSet();
          }
          for (var b = 1, n = blocks.length; b < n; b++) {
            var block = blocks[b];
            var predecessors = block.predecessors;
            if (predecessors.length >= 2) {
              var idom = block.dominator;
              for (var i = 0, j = predecessors.length; i < j; i++) {
                var runner = predecessors[i];
                while (runner !== idom) {
                  runner.frontier.set(block.id);
                  runner = runner.dominator;
                }
              }
            }
          }
        },
        analyzeControlFlow: function analyzeControlFlow() {
          this.computeDominance();
          this.analyzedControlFlow = true;
          return true;
        },
        markLoops: function markLoops() {
          if (!this.analyzedControlFlow && !this.analyzeControlFlow()) {
            return false;
          }
          var BlockSet = this.BlockSet;
          function findSCCs(root) {
            var preorderId = 1;
            var preorder = {};
            var assigned = {};
            var unconnectedNodes = [];
            var pendingNodes = [];
            var sccs = [];
            var level = root.level + 1;
            var worklist = [
                root
              ];
            var node;
            var u, s;
            while (node = worklist.top()) {
              if (preorder[node.id]) {
                if (pendingNodes.peek() === node) {
                  pendingNodes.pop();
                  var scc = [];
                  do {
                    u = unconnectedNodes.pop();
                    assigned[u.id] = true;
                    scc.push(u);
                  } while (u !== node);
                  if (scc.length > 1 || u.spbacks && u.spbacks.get(u.id)) {
                    sccs.push(scc);
                  }
                }
                worklist.pop();
                continue;
              }
              preorder[node.id] = preorderId++;
              unconnectedNodes.push(node);
              pendingNodes.push(node);
              var successors = node.successors;
              for (var i = 0, j = successors.length; i < j; i++) {
                s = successors[i];
                if (s.level < level) {
                  continue;
                }
                var sid = s.id;
                if (!preorder[sid]) {
                  worklist.push(s);
                } else if (!assigned[sid]) {
                  while (preorder[pendingNodes.peek().id] > preorder[sid]) {
                    pendingNodes.pop();
                  }
                }
              }
            }
            return sccs;
          }
          function findLoopHeads(blocks) {
            var heads = new BlockSet();
            for (var i = 0, j = blocks.length; i < j; i++) {
              var block = blocks[i];
              var spbacks = block.spbacks;
              if (!spbacks) {
                continue;
              }
              var successors = block.successors;
              for (var k = 0, l = successors.length; k < l; k++) {
                var s = successors[k];
                if (spbacks.get(s.id)) {
                  heads.set(s.dominator.id);
                }
              }
            }
            return heads.members();
          }
          function LoopInfo(scc, loopId) {
            var body = new BlockSet();
            body.setBlocks(scc);
            body.recount();
            this.id = loopId;
            this.body = body;
            this.exit = new BlockSet();
            this.save = {};
            this.head = new BlockSet();
            this.npredecessors = 0;
          }
          var heads = findLoopHeads(this.blocks);
          if (heads.length <= 0) {
            this.markedLoops = true;
            return true;
          }
          var worklist = heads.sort(function (a, b) {
              return a.level - b.level;
            });
          var loopId = 0;
          for (var n = worklist.length - 1; n >= 0; n--) {
            var top = worklist[n];
            var sccs = findSCCs(top);
            if (sccs.length === 0) {
              continue;
            }
            for (var i = 0, j = sccs.length; i < j; i++) {
              var scc = sccs[i];
              var loop = new LoopInfo(scc, loopId++);
              for (var k = 0, l = scc.length; k < l; k++) {
                var h = scc[k];
                if (h.level === top.level + 1 && !h.loop) {
                  h.loop = loop;
                  loop.head.set(h.id);
                  var predecessors = h.predecessors;
                  for (var pi = 0, pj = predecessors.length; pi < pj; pi++) {
                    loop.body.get(predecessors[pi].id) && h.npredecessors--;
                  }
                  loop.npredecessors += h.npredecessors;
                }
              }
              for (var k = 0, l = scc.length; k < l; k++) {
                var h = scc[k];
                if (h.level === top.level + 1) {
                  h.npredecessors = loop.npredecessors;
                }
              }
              loop.head.recount();
            }
          }
          this.markedLoops = true;
          return true;
        },
        induceControlTree: function induceControlTree() {
          var hasExceptions = this.hasExceptions;
          var BlockSet = this.BlockSet;
          function maybe(exit, save) {
            exit.recount();
            if (exit.count === 0) {
              return null;
            }
            exit.save = save;
            return exit;
          }
          var exceptionId = this.blocks.length;
          function induce(head, exit, save, loop, inLoopHead, lookupSwitch, fallthrough) {
            var v = [];
            while (head) {
              if (head.count > 1) {
                var exit2 = new BlockSet();
                var save2 = {};
                var cases = [];
                var heads = head.members();
                for (var i = 0, j = heads.length; i < j; i++) {
                  var h = heads[i];
                  var bid = h.id;
                  var c;
                  if (h.loop && head.contains(h.loop.head)) {
                    var loop2 = h.loop;
                    if (!loop2.induced) {
                      var lheads = loop2.head.members();
                      var lheadsave = 0;
                      for (k = 0, l = lheads.length; k < l; k++) {
                        lheadsave += head.save[lheads[k].id];
                      }
                      if (h.npredecessors - lheadsave > 0) {
                        h.npredecessors -= head.save[bid];
                        h.save = head.save[bid];
                        c = induce(h, exit2, save2, loop);
                        cases.push(new Control.LabelCase([
                          bid
                        ], c));
                      } else {
                        for (k = 0, l = lheads.length; k < l; k++) {
                          var lh = lheads[k];
                          lh.npredecessors -= lheadsave;
                          lh.save = lheadsave;
                        }
                        c = induce(h, exit2, save2, loop);
                        cases.push(new Control.LabelCase(loop2.head.toArray(), c));
                        loop2.induced = true;
                      }
                    }
                  } else {
                    h.npredecessors -= head.save[bid];
                    h.save = head.save[bid];
                    c = induce(h, exit2, save2, loop);
                    cases.push(new Control.LabelCase([
                      bid
                    ], c));
                  }
                }
                var pruned = [];
                var k = 0;
                var c;
                for (var i = 0, j = cases.length; i < j; i++) {
                  c = cases[i];
                  var labels = c.labels;
                  var lk = 0;
                  for (var ln = 0, nlabels = labels.length; ln < nlabels; ln++) {
                    var bid = labels[ln];
                    if (exit2.get(bid) && heads[i].npredecessors - head.save[bid] > 0) {
                      pruned.push(bid);
                    } else {
                      labels[lk++] = bid;
                    }
                  }
                  labels.length = lk;
                  if (labels.length > 0) {
                    cases[k++] = c;
                  }
                }
                cases.length = k;
                if (cases.length === 0) {
                  for (var i = 0, j = pruned.length; i < j; i++) {
                    var bid = pruned[i];
                    save[bid] = (save[bid] || 0) + head.save[bid];
                    exit.set(bid);
                  }
                  break;
                }
                v.push(new Control.LabelSwitch(cases));
                head = maybe(exit2, save2);
                continue;
              }
              var h, bid, c;
              if (head.count === 1) {
                h = head.choose();
                bid = h.id;
                h.npredecessors -= head.save[bid];
                h.save = head.save[bid];
              } else {
                h = head;
                bid = h.id;
              }
              if (inLoopHead) {
                inLoopHead = false;
              } else {
                if (loop && !loop.body.get(bid)) {
                  h.npredecessors += h.save;
                  loop.exit.set(bid);
                  loop.save[bid] = (loop.save[bid] || 0) + h.save;
                  v.push(new Control.Break(bid, loop));
                  break;
                }
                if (loop && h.loop === loop) {
                  h.npredecessors += h.save;
                  v.push(new Control.Continue(bid, loop));
                  break;
                }
                if (h === fallthrough) {
                  break;
                }
                if (h.npredecessors > 0) {
                  h.npredecessors += h.save;
                  save[bid] = (save[bid] || 0) + h.save;
                  exit.set(bid);
                  v.push(lookupSwitch ? new Control.Break(bid, lookupSwitch) : new Control.Exit(bid));
                  break;
                }
                if (h.loop) {
                  var l = h.loop;
                  var body;
                  if (l.head.count === 1) {
                    body = induce(l.head.choose(), null, null, l, true);
                  } else {
                    var lcases = [];
                    var lheads = l.head.members();
                    for (var i = 0, j = lheads.length; i < j; i++) {
                      var lh = lheads[i];
                      var lbid = lh.id;
                      var c = induce(lh, null, null, l, true);
                      lcases.push(new Control.LabelCase([
                        lbid
                      ], c));
                    }
                    body = new Control.LabelSwitch(lcases);
                  }
                  v.push(new Control.Loop(body));
                  head = maybe(l.exit, l.save);
                  continue;
                }
              }
              var sv;
              var successors;
              var exit2 = new BlockSet();
              var save2 = {};
              if (hasExceptions && h.hasCatches) {
                var allsuccessors = h.successors;
                var catchsuccessors = [];
                successors = [];
                for (var i = 0, j = allsuccessors.length; i < j; i++) {
                  var s = allsuccessors[i];
                  (s.exception ? catchsuccessors : successors).push(s);
                }
                var catches = [];
                for (var i = 0, j = catchsuccessors.length; i < j; i++) {
                  var t = catchsuccessors[i];
                  t.npredecessors -= 1;
                  t.save = 1;
                  var c = induce(t, exit2, save2, loop);
                  var ex = t.exception;
                  catches.push(new Control.Catch(ex.varName, ex.typeName, c));
                }
                sv = new Control.Try(h, catches);
              } else {
                successors = h.successors;
                sv = h;
              }
              if (successors.length > 2) {
                var cases = [];
                var targets = successors;
                for (var i = targets.length - 1; i >= 0; i--) {
                  var t = targets[i];
                  t.npredecessors -= 1;
                  t.save = 1;
                  c = induce(t, exit2, save2, loop, null, h, targets[i + 1]);
                  cases.unshift(new Control.Case(i, c));
                }
                cases.top().index = undefined;
                if (hasExceptions && h.hasCatches) {
                  sv.nothingThrownLabel = exceptionId;
                  sv = new Control.Switch(sv, cases, exceptionId++);
                } else {
                  sv = new Control.Switch(sv, cases);
                }
                head = maybe(exit2, save2);
              } else if (successors.length === 2) {
                var branch1 = h.hasFlippedSuccessors ? successors[1] : successors[0];
                var branch2 = h.hasFlippedSuccessors ? successors[0] : successors[1];
                branch1.npredecessors -= 1;
                branch1.save = 1;
                var c1 = induce(branch1, exit2, save2, loop);
                branch2.npredecessors -= 1;
                branch2.save = 1;
                var c2 = induce(branch2, exit2, save2, loop);
                if (hasExceptions && h.hasCatches) {
                  sv.nothingThrownLabel = exceptionId;
                  sv = new Control.If(sv, c1, c2, exceptionId++);
                } else {
                  sv = new Control.If(sv, c1, c2);
                }
                head = maybe(exit2, save2);
              } else {
                c = successors[0];
                if (c) {
                  if (hasExceptions && h.hasCatches) {
                    sv.nothingThrownLabel = c.id;
                    save2[c.id] = (save2[c.id] || 0) + 1;
                    exit2.set(c.id);
                    head = maybe(exit2, save2);
                  } else {
                    c.npredecessors -= 1;
                    c.save = 1;
                    head = c;
                  }
                } else {
                  if (hasExceptions && h.hasCatches) {
                    sv.nothingThrownLabel = -1;
                    head = maybe(exit2, save2);
                  } else {
                    head = c;
                  }
                }
              }
              v.push(sv);
            }
            if (v.length > 1) {
              return new Control.Seq(v);
            }
            return v[0];
          }
          var root = this.blocks[0];
          this.controlTree = induce(root, new BlockSet(), {});
        },
        restructureControlFlow: function restructureControlFlow() {
          Timer.start('Restructure Control Flow');
          if (!this.markedLoops && !this.markLoops()) {
            Timer.stop();
            return false;
          }
          this.induceControlTree();
          this.restructuredControlFlow = true;
          Timer.stop();
          return true;
        },
        trace: function (writer) {
          function bid(node) {
            return node.id;
          }
          function traceBlock(block) {
            if (!block.dominator) {
              writer.enter('block unreachable {');
            } else {
              writer.enter('block ' + block.id + (block.successors.length > 0 ? ' -> ' + block.successors.map(bid).join(',') : '') + ' {');
              writer.writeLn('npredecessors'.padRight(' ', 10) + block.npredecessors);
              writer.writeLn('idom'.padRight(' ', 10) + block.dominator.id);
              writer.writeLn('domcs'.padRight(' ', 10) + block.dominatees.map(bid).join(','));
              if (block.frontier) {
                writer.writeLn('frontier'.padRight(' ', 10) + '{' + block.frontier.toArray().join(',') + '}');
              }
              writer.writeLn('level'.padRight(' ', 10) + block.level);
            }
            if (block.loop) {
              writer.writeLn('loop'.padRight(' ', 10) + '{' + block.loop.body.toArray().join(',') + '}');
              writer.writeLn('  id'.padRight(' ', 10) + block.loop.id);
              writer.writeLn('  head'.padRight(' ', 10) + '{' + block.loop.head.toArray().join(',') + '}');
              writer.writeLn('  exit'.padRight(' ', 10) + '{' + block.loop.exit.toArray().join(',') + '}');
              writer.writeLn('  npredecessors'.padRight(' ', 10) + block.loop.npredecessors);
            }
            writer.writeLn('');
            if (block.position >= 0) {
              for (var bci = block.position; bci <= block.end.position; bci++) {
                writer.writeLn(('' + bci).padRight(' ', 5) + bytecodes[bci]);
              }
            } else {
              writer.writeLn('abstract');
            }
            writer.leave('}');
          }
          var bytecodes = this.bytecodes;
          writer.enter('analysis {');
          writer.enter('cfg {');
          this.blocks.forEach(traceBlock);
          writer.leave('}');
          if (this.controlTree) {
            writer.enter('control-tree {');
            this.controlTree.trace(writer);
            writer.leave('}');
          }
          writer.leave('}');
        },
        traceCFG: makeVizTrace([
          {
            fn: function (n) {
              return n.successors || [];
            },
            style: ''
          }
        ], [
          {
            fn: function (n) {
              return n.predecessors || [];
            },
            style: ''
          }
        ]),
        traceDJ: makeVizTrace([
          {
            fn: function (n) {
              return n.dominatees || [];
            },
            style: 'style=dashed'
          },
          {
            fn: function (n) {
              var crosses = new this.BlockSet();
              crosses.setBlocks(n.successors);
              crosses.subtract(this.BlockSet.fromBlocks(n.dominatees));
              n.spbacks && crosses.subtract(n.spbacks);
              return crosses.members();
            },
            style: ''
          },
          {
            fn: function (n) {
              return n.spbacks ? n.spbacks.members() : [];
            },
            style: 'style=bold'
          }
        ], [
          {
            fn: function (n) {
              return n.predecessors || [];
            },
            style: ''
          }
        ], function (idFn, writer) {
          var root = this.bytecodes[0];
          var worklist = [
              root
            ];
          var n;
          var level = root.level;
          var currentLevel = [];
          while (n = worklist.shift()) {
            if (level != n.level) {
              writer.writeLn('{rank=same; ' + currentLevel.map(function (n) {
                return 'block_' + idFn(n);
              }).join(' ') + '}');
              currentLevel.length = 0;
              level = n.level;
            }
            currentLevel.push(n);
            worklist.push.apply(worklist, n.dominatees);
          }
        })
      };
      function makeVizTrace(successorFns, predecessorFns, postHook) {
        return function (writer, name, prefix) {
          function idFn(n) {
            return prefix + n.id;
          }
          var analysis = this;
          function bindToThis(x) {
            x.fn = x.fn.bind(analysis);
          }
          prefix = prefix || '';
          var bytecodes = this.bytecodes;
          if (!bytecodes) {
            return;
          }
          successorFns.forEach(bindToThis);
          predecessorFns.forEach(bindToThis);
          writeGraphViz(writer, name.toString(), bytecodes[0], idFn, function (n) {
            return n.successors || [];
          }, successorFns, predecessorFns, function (n) {
            var str = 'Block: ' + n.id + '\\l';
            return str;
          }, postHook && postHook.bind(this, idFn));
        };
      }
      return Analysis;
    }();
  exports.Control = Control;
  exports.analyze = function (cfg) {
    var analysis = new Analysis(cfg);
    analysis.restructureControlFlow();
    return analysis.controlTree;
  };
}(typeof exports === 'undefined' ? Looper = {} : exports));
(function (exports) {
  var TRACE_REGISTER_ALLOCATOR = false;
  var T = estransform;
  var Node = T.Node;
  var Identifier = T.Identifier;
  var VariableDeclaration = T.VariableDeclaration;
  var VariableDeclarator = T.VariableDeclarator;
  var AssignmentExpression = T.AssignmentExpression;
  var MemberExpression = T.MemberExpression;
  var IfStatement = T.IfStatement;
  var WhileStatement = T.WhileStatement;
  var FunctionDeclaration = T.FunctionDeclaration;
  var writer = new IndentingWriter();
  var LinearScan = function () {
      function Interval(id, start, end) {
        this.id = id;
        this.start = start;
        this.end = end;
      }
      Interval.prototype.toString = function () {
        return '[' + this.start + ',' + this.end + ']';
      };
      function linearScan(intervals, maxRegisters) {
        this.intervals = intervals.slice(0);
        this.maxRegisters = maxRegisters;
      }
      linearScan.prototype.allocate = function () {
        var intervals = this.intervals;
        this.intervals.sort(function (a, b) {
          return a.start - b.start;
        });
        var active = new SortedList(function (a, b) {
            return a.end - b.end;
          });
        var maxRegisters = this.maxRegisters;
        var freeRegisters = [];
        for (var i = maxRegisters - 1; i >= 0; i--) {
          freeRegisters.push('R' + i);
        }
        intervals.forEach(function (i) {
          expireOldIntervals(i);
          if (active.length === maxRegisters) {
            notImplemented('Cannot Spill');
          } else {
            i.register = freeRegisters.pop();
            TRACE_REGISTER_ALLOCATOR && writer.writeLn('Allocate: ' + i + ' ' + i.id + ' -> ' + i.register);
            active.push(i);
          }
        });
        function expireOldIntervals(i) {
          active.forEach(function (j) {
            if (j.end >= i.start) {
              return SortedList.RETURN;
            }
            freeRegisters.push(j.register);
            TRACE_REGISTER_ALLOCATOR && writer.writeLn('Release: ' + j + ' -> ' + j.register);
            return SortedList.DELETE;
          });
        }
      };
      linearScan.Interval = Interval;
      return linearScan;
    }();
  function allocateRegisters(program) {
    var scan = T.makePass('scan', 'scanNode');
    var label = 0;
    Node.prototype.scan = function (o) {
      this.position = label++;
      return scan.apply(this, o);
    };
    var variables = [];
    var variableIndexMap = {};
    var identifiers = [];
    FunctionDeclaration.prototype.scan = function () {
      this.params.forEach(function (identifier) {
        if (!(identifier.name in variableIndexMap)) {
          variableIndexMap[identifier.name] = variables.length;
          variables.push(identifier.name);
        }
      });
      this.body.scan();
      return this;
    };
    VariableDeclarator.prototype.scan = function () {
      this.position = label++;
      if (!(this.id.name in variableIndexMap)) {
        variableIndexMap[this.id.name] = variables.length;
        variables.push(this.id.name);
      }
      return this;
    };
    AssignmentExpression.prototype.scan = function (o) {
      this.left.scan(o);
      this.right.scan(o);
      this.position = label++;
      return this;
    };
    WhileStatement.prototype.scan = function (o) {
      this.position = label++;
      this.test.scan(o);
      this.body.scan(o);
      this.afterPosition = label++;
      return this;
    };
    program.scan();
    TRACE_REGISTER_ALLOCATOR && writer.writeLn('Local Variables: ' + variables);
    var Set = BitSetFunctor(variables.length);
    var Range = BitSetFunctor(label);
    var ranges = [];
    for (var i = 0; i < variables.length; i++) {
      ranges.push(new Range());
    }
    function fill(range) {
      var start = -1;
      for (var i = 0; i < range.length; i++) {
        if (range.get(i)) {
          start = i;
          break;
        }
      }
      for (var i = range.length - 1; i >= 0; i--) {
        if (range.get(i)) {
          end = i;
          break;
        }
      }
      for (var i = start; i < end; i++) {
        range.set(i);
      }
    }
    function getRange(range) {
      var start = -1, end = -1;
      for (var i = 0; i < range.length; i++) {
        if (range.get(i)) {
          start = i;
          break;
        }
      }
      for (var i = range.length - 1; i >= 0; i--) {
        if (range.get(i)) {
          end = i;
          break;
        }
      }
      return [
        start,
        end
      ];
    }
    function use(set, name, position) {
      var index = variableIndexMap[name];
      ranges[index].set(position);
      set.set(index);
    }
    function def(set, name, position) {
      var index = variableIndexMap[name];
      ranges[index].set(position);
      set.clear(index);
    }
    Node.prototype.markLiveness = T.makePass('markLiveness', 'markLivenessNode', true);
    Identifier.prototype.markLiveness = function (o) {
      var name = this.name;
      if (name === 'undefined') {
        return this;
      }
      if (o && o.isProperty) {
        return this;
      }
      if (!(name in variableIndexMap)) {
        return this;
      }
      identifiers.push(this);
      var live = o.live;
      use(live, name, this.position);
      return this;
    };
    VariableDeclarator.prototype.markLiveness = function (o) {
      var live = o.live;
      identifiers.push(this.id);
      return this;
    };
    IfStatement.prototype.markLiveness = function (o) {
      var a = o.live.clone();
      var b = o.live.clone();
      this.alternate && this.alternate.markLiveness({
        live: a
      });
      this.consequent && this.consequent.markLiveness({
        live: b
      });
      o.live.assign(a);
      o.live._union(b);
      this.test.markLiveness(o);
      return this;
    };
    WhileStatement.prototype.markLiveness = function (o) {
      var a = o.live.clone();
      TRACE_REGISTER_ALLOCATOR && writer.writeLn('END OF LOOP: ' + a);
      var afterPosition = this.afterPosition;
      do {
        var b = a.clone();
        this.body.markLiveness({
          live: a
        });
        this.test.markLiveness({
          live: a
        });
        TRACE_REGISTER_ALLOCATOR && writer.writeLn('TOP OF LOOP: ' + a);
        var iterate = !b.equals(a);
        if (iterate) {
          TRACE_REGISTER_ALLOCATOR && writer.writeLn('ITERATE');
          a.forEach(function (i) {
            ranges[i].set(afterPosition);
          });
        }
      } while (iterate);
      o.live.assign(a);
      return this;
    };
    AssignmentExpression.prototype.markLiveness = function (o) {
      this.right.markLiveness(o);
      if (this.left instanceof Identifier) {
        def(o.live, this.left.name, this.position);
        identifiers.push(this.left);
      } else {
        this.left.markLiveness(o);
      }
      return this;
    };
    MemberExpression.prototype.markLiveness = function (o) {
      if (this.computed || !(this.property instanceof Identifier)) {
        this.property.markLiveness(o);
      }
      this.object.markLiveness(o);
      return this;
    };
    program.markLiveness({
      live: new Set()
    });
    var intervals = [];
    for (var i = 0; i < ranges.length; i++) {
      var r = getRange(ranges[i]);
      intervals.push(new LinearScan.Interval(i, r[0], r[1]));
    }
    var allocator = new LinearScan(intervals, 1024);
    allocator.allocate();
    var map = createEmptyObject();
    for (var i = 0; i < variables.length; i++) {
      map[variables[i]] = intervals[i].register;
    }
    if (true) {
      for (var i = 0; i < identifiers.length; i++) {
        if (identifiers[i].patched) {
          continue;
        }
        identifiers[i].name = map[identifiers[i].name];
        identifiers[i].patched = true;
      }
    }
    if (TRACE_REGISTER_ALLOCATOR) {
      for (var i = 0; i < ranges.length; i++) {
        fill(ranges[i]);
        writer.writeLn(String(i).padLeft(' ', 3) + ' ' + variables[i].padRight(' ', 5) + ': ' + ranges[i].toBitString('=', ' ') + ' ' + intervals[i].register);
      }
    }
    return program;
  }
  Transform.transform = function (program) {
    allocateRegisters(program);
  };
}(typeof exports === 'undefined' ? Transform = {} : exports));
(function (exports) {
  var T = estransform;
  var Literal = T.Literal;
  var Identifier = T.Identifier;
  var VariableDeclaration = T.VariableDeclaration;
  var VariableDeclarator = T.VariableDeclarator;
  var MemberExpression = T.MemberExpression;
  var BinaryExpression = T.BinaryExpression;
  var SequenceExpression = T.SequenceExpression;
  var CallExpression = T.CallExpression;
  var AssignmentExpression = T.AssignmentExpression;
  var ExpressionStatement = T.ExpressionStatement;
  var ReturnStatement = T.ReturnStatement;
  var Program = T.Program;
  var Statement = T.Statement;
  var FunctionDeclaration = T.FunctionDeclaration;
  var FunctionExpression = T.FunctionExpression;
  var ConditionalExpression = T.ConditionalExpression;
  var ObjectExpression = T.ObjectExpression;
  var ArrayExpression = T.ArrayExpression;
  var UnaryExpression = T.UnaryExpression;
  var NewExpression = T.NewExpression;
  var Property = T.Property;
  var UpdateExpression = T.UpdateExpression;
  var ForStatement = T.ForStatement;
  var BlockStatement = T.BlockStatement;
  var ThisExpression = T.ThisExpression;
  var TypeAliasDirective = T.TypeAliasDirective;
  var CastExpression = T.CastExpression;
  var ThrowStatement = T.ThrowStatement;
  var IfStatement = T.IfStatement;
  var WhileStatement = T.WhileStatement;
  var BreakStatement = T.BreakStatement;
  var ContinueStatement = T.ContinueStatement;
  var SwitchStatement = T.SwitchStatement;
  var SwitchCase = T.SwitchCase;
  var TryStatement = T.TryStatement;
  var CatchClause = T.CatchClause;
  var Block = IR.Block;
  var Operator = IR.Operator;
  var If = IR.If;
  var Jump = IR.Jump;
  var Projection = IR.Projection;
  var Start = IR.Start;
  var Control = Looper.Control;
  var Variable = IR.Variable;
  Control.Break.prototype.compile = function (cx, state) {
    return cx.compileBreak(this, state);
  };
  Control.Continue.prototype.compile = function (cx, state) {
    return cx.compileContinue(this, state);
  };
  Control.Exit.prototype.compile = function (cx, state) {
    return cx.compileExit(this, state);
  };
  Control.LabelSwitch.prototype.compile = function (cx, state) {
    return cx.compileLabelSwitch(this, state);
  };
  Control.Seq.prototype.compile = function (cx, state) {
    return cx.compileSequence(this, state);
  };
  Block.prototype.compile = function (cx, state) {
    return cx.compileBlock(this, state);
  };
  Control.Loop.prototype.compile = function (cx, state) {
    return cx.compileLoop(this, state);
  };
  Control.Switch.prototype.compile = function (cx, state) {
    return cx.compileSwitch(this, state);
  };
  Control.If.prototype.compile = function (cx, state) {
    return cx.compileIf(this, state);
  };
  Control.Try.prototype.compile = function (cx, state) {
    return cx.compileTry(this, state);
  };
  function constant(value) {
    if (typeof value === 'string' || value === null || value === true || value === false) {
      return new Literal(value);
    } else if (value === undefined) {
      return new Identifier('undefined');
    } else if (typeof value === 'object' || typeof value === 'function') {
      return new Identifier(objectConstantName(value));
    } else if (typeof value === 'number' && isNaN(value)) {
      return new Identifier('NaN');
    } else if (value === Infinity) {
      return new Identifier('Infinity');
    } else if (value === -Infinity) {
      return new UnaryExpression('-', new Identifier('Infinity'));
    } else if (typeof value === 'number' && 1 / value < 0) {
      return new UnaryExpression('-', new Literal(Math.abs(value)));
    } else if (typeof value === 'number') {
      return new Literal(value);
    } else {
      unexpected('Cannot emit constant for value: ', value);
    }
  }
  function id(name) {
    true;
    return new Identifier(name);
  }
  function isIdentifierStart(c) {
    return c === '$' || c === '_' || c === '\\' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
  }
  function isIdentifierPart(c) {
    return c === '$' || c === '_' || c === '\\' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
  }
  function isIdentifierName(s) {
    if (!isIdentifierStart(s[0])) {
      return false;
    }
    for (var i = 1; i < s.length; i++) {
      if (!isIdentifierPart(s[i])) {
        return false;
      }
    }
    return true;
  }
  function property(obj) {
    for (var i = 1; i < arguments.length; i++) {
      var x = arguments[i];
      if (typeof x === 'string') {
        if (isIdentifierName(x)) {
          obj = new MemberExpression(obj, new Identifier(x), false);
        } else {
          obj = new MemberExpression(obj, new Literal(x), true);
        }
      } else if (x instanceof Literal && isIdentifierName(x.value)) {
        obj = new MemberExpression(obj, new Identifier(x.value), false);
      } else {
        obj = new MemberExpression(obj, x, true);
      }
    }
    return obj;
  }
  function call(callee, args) {
    true;
    true;
    return new CallExpression(callee, args);
  }
  function callCall(callee, object, args) {
    return call(property(callee, 'call'), [
      object
    ].concat(args));
  }
  function assignment(left, right) {
    true;
    return new AssignmentExpression(left, '=', right);
  }
  function variableDeclaration(declarations) {
    return new VariableDeclaration('var', declarations);
  }
  function negate(node) {
    if (node instanceof Constant) {
      if (node.value === true || node.value === false) {
        return constant(!node.value);
      }
    } else if (node instanceof Identifier) {
      return new UnaryExpression(Operator.FALSE.name, node);
    }
    true;
    var left = node instanceof BinaryExpression ? node.left : node.argument;
    var right = node.right;
    var operator = Operator.fromName(node.operator);
    if (operator === Operator.EQ && right instanceof Literal && right.value === false) {
      return left;
    }
    if (operator === Operator.FALSE) {
      return left;
    }
    if (operator.not) {
      if (node instanceof BinaryExpression) {
        return new BinaryExpression(operator.not.name, left, right);
      } else {
        return new UnaryExpression(operator.not.name, left);
      }
    }
    return new UnaryExpression(Operator.FALSE.name, node);
  }
  function Context() {
    this.label = new Variable('$L');
    this.variables = [];
    this.parameters = [];
  }
  Context.prototype.useVariable = function (variable) {
    true;
    return this.variables.pushUnique(variable);
  };
  Context.prototype.useParameter = function (parameter) {
    return this.parameters[parameter.index] = parameter;
  };
  Context.prototype.compileLabelBody = function compileLabelBody(node) {
    var body = [];
    if (node.label !== undefined) {
      this.useVariable(this.label);
      body.push(new ExpressionStatement(assignment(id(this.label.name), new Literal(node.label))));
    }
    return body;
  };
  Context.prototype.compileBreak = function compileBreak(node) {
    var body = this.compileLabelBody(node);
    body.push(new BreakStatement(null));
    return new BlockStatement(body);
  };
  Context.prototype.compileContinue = function compileContinue(node) {
    var body = this.compileLabelBody(node);
    body.push(new ContinueStatement(null));
    return new BlockStatement(body);
  };
  Context.prototype.compileExit = function compileExit(node) {
    return new BlockStatement(this.compileLabelBody(node));
  };
  Context.prototype.compileIf = function compileIf(node) {
    var cr = node.cond.compile(this);
    var tr = null, er = null;
    if (node.then) {
      tr = node.then.compile(this);
    }
    if (node.else) {
      er = node.else.compile(this);
    }
    var condition = compileValue(cr.end.predicate, this);
    condition = node.negated ? negate(condition) : condition;
    cr.body.push(new IfStatement(condition, tr || new BlockStatement([]), er || null));
    return cr;
  };
  Context.prototype.compileSwitch = function compileSwitch(node) {
    var dr = node.determinant.compile(this);
    var cases = [];
    node.cases.forEach(function (x) {
      var br;
      if (x.body) {
        br = x.body.compile(this);
      }
      var test = typeof x.index === 'number' ? new Literal(x.index) : undefined;
      cases.push(new SwitchCase(test, br ? [
        br
      ] : []));
    }, this);
    var determinant = compileValue(dr.end.determinant, this);
    dr.body.push(new SwitchStatement(determinant, cases, false));
    return dr;
  };
  Context.prototype.compileLabelSwitch = function compileLabelSwitch(node) {
    var statement = null;
    var labelName = id(this.label.name);
    function compileLabelTest(labelID) {
      true;
      return new BinaryExpression('===', labelName, new Literal(labelID));
    }
    for (var i = node.cases.length - 1; i >= 0; i--) {
      var c = node.cases[i];
      var labels = c.labels;
      var labelTest = compileLabelTest(labels[0]);
      for (var j = 1; j < labels.length; j++) {
        labelTest = new BinaryExpression('||', labelTest, compileLabelTest(labels[j]));
      }
      statement = new IfStatement(labelTest, c.body ? c.body.compile(this) : new BlockStatement(), statement);
    }
    return statement;
  };
  Context.prototype.compileLoop = function compileLoop(node) {
    var br = node.body.compile(this);
    return new WhileStatement(constant(true), br);
  };
  Context.prototype.compileSequence = function compileSequence(node) {
    var cx = this;
    var body = [];
    node.body.forEach(function (x) {
      var result = x.compile(cx);
      if (result instanceof BlockStatement) {
        body = body.concat(result.body);
      } else {
        body.push(result);
      }
    });
    return new BlockStatement(body);
  };
  Context.prototype.compileBlock = function compileBlock(block) {
    var body = [];
    for (var i = 1; i < block.nodes.length - 1; i++) {
      var node = block.nodes[i];
      var statement;
      var to;
      var from;
      if (node instanceof IR.Throw) {
        statement = compileValue(node, this, true);
      } else {
        if (node instanceof IR.Move) {
          to = id(node.to.name);
          this.useVariable(node.to);
          from = compileValue(node.from, this);
        } else {
          if (node.variable) {
            to = id(node.variable.name);
            this.useVariable(node.variable);
          } else {
            to = null;
          }
          from = compileValue(node, this, true);
        }
        if (to) {
          statement = new ExpressionStatement(assignment(to, from));
        } else {
          statement = new ExpressionStatement(from);
        }
      }
      body.push(statement);
    }
    var end = block.nodes.last();
    if (end instanceof IR.Stop) {
      body.push(new ReturnStatement(compileValue(end.argument, this)));
    }
    var result = new BlockStatement(body);
    result.end = block.nodes.last();
    true;
    return result;
  };
  function compileValue(value, cx, noVariable) {
    true;
    true;
    true;
    true;
    if (noVariable || !value.variable) {
      var node = value.compile(cx);
      return node;
    }
    true;
    return id(value.variable.name);
  }
  function compileMultiname(name, cx) {
    return [
      compileValue(name.namespaces, cx),
      compileValue(name.name, cx),
      constant(name.flags)
    ];
  }
  function isArray(array) {
    return array instanceof Array;
  }
  function compileValues(values, cx) {
    true;
    return values.map(function (value) {
      return compileValue(value, cx);
    });
  }
  IR.Parameter.prototype.compile = function (cx) {
    cx.useParameter(this);
    return id(this.name);
  };
  IR.Constant.prototype.compile = function (cx) {
    return constant(this.value);
  };
  IR.Variable.prototype.compile = function (cx) {
    return id(this.name);
  };
  IR.Phi.prototype.compile = function (cx) {
    true;
    return compileValue(this.variable, cx);
  };
  IR.ASScope.prototype.compile = function (cx) {
    var parent = compileValue(this.parent, cx);
    var object = compileValue(this.object, cx);
    var isWith = new Literal(this.isWith);
    return new NewExpression(id('Scope'), [
      parent,
      object,
      isWith
    ]);
  };
  IR.ASFindProperty.prototype.compile = function (cx) {
    var scope = compileValue(this.scope, cx);
    var name = compileMultiname(this.name, cx);
    var domain = compileValue(this.domain, cx);
    var strict = new Literal(this.strict);
    return call(property(scope, 'findScopeProperty'), name.concat([
      domain,
      strict
    ]));
  };
  IR.ASGetProperty.prototype.compile = function (cx) {
    var object = compileValue(this.object, cx);
    if (this.flags & IR.Flags.INDEXED) {
      true;
      return call(property(object, 'asGetNumericProperty'), [
        compileValue(this.name.name, cx)
      ]);
    } else if (this.flags & IR.Flags.RESOLVED) {
      return call(property(object, 'asGetResolvedStringProperty'), [
        compileValue(this.name, cx)
      ]);
    }
    var name = compileMultiname(this.name, cx);
    var isMethod = new Literal(this.flags & IR.Flags.IS_METHOD);
    return call(property(object, 'asGetProperty'), name.concat(isMethod));
  };
  IR.Latch.prototype.compile = function (cx) {
    return new ConditionalExpression(compileValue(this.condition, cx), compileValue(this.left, cx), compileValue(this.right, cx));
  };
  IR.Unary.prototype.compile = function (cx) {
    return new UnaryExpression(this.operator.name, compileValue(this.argument, cx));
  };
  IR.Copy.prototype.compile = function (cx) {
    return compileValue(this.argument, cx);
  };
  IR.Binary.prototype.compile = function (cx) {
    var left = compileValue(this.left, cx);
    var right = compileValue(this.right, cx);
    if (this.operator === Operator.AS_ADD) {
      return call(id('asAdd'), [
        left,
        right
      ]);
    }
    return new BinaryExpression(this.operator.name, left, right);
  };
  IR.CallProperty.prototype.compile = function (cx) {
    var object = compileValue(this.object, cx);
    var name = compileValue(this.name, cx);
    var callee = property(object, name);
    var args = this.args.map(function (arg) {
        return compileValue(arg, cx);
      });
    if (this.flags & IR.Flags.PRISTINE) {
      return call(callee, args);
    } else {
      return callCall(callee, object, args);
    }
  };
  IR.ASCallProperty.prototype.compile = function (cx) {
    var object = compileValue(this.object, cx);
    var args = this.args.map(function (arg) {
        return compileValue(arg, cx);
      });
    if (this.flags & IR.Flags.RESOLVED) {
      return call(property(object, 'asCallResolvedStringProperty'), [
        compileValue(this.name, cx),
        new Literal(this.isLex),
        new ArrayExpression(args)
      ]);
    }
    var name = compileMultiname(this.name, cx);
    return call(property(object, 'asCallProperty'), name.concat([
      new Literal(this.isLex),
      new ArrayExpression(args)
    ]));
  };
  IR.Call.prototype.compile = function (cx) {
    var args = this.args.map(function (arg) {
        return compileValue(arg, cx);
      });
    var callee = compileValue(this.callee, cx);
    var object;
    if (this.object) {
      object = compileValue(this.object, cx);
    } else {
      object = new Literal(null);
    }
    if (false && this.pristine && (this.callee instanceof IR.GetProperty && this.callee.object === this.object) || this.object === null) {
      return call(callee, args);
    } else {
      return callCall(callee, object, args);
    }
  };
  IR.ASNew.prototype.compile = function (cx) {
    var args = this.args.map(function (arg) {
        return compileValue(arg, cx);
      });
    var callee = compileValue(this.callee, cx);
    callee = property(callee, 'instanceConstructor');
    return new NewExpression(callee, args);
  };
  IR.This.prototype.compile = function (cx) {
    return new ThisExpression();
  };
  IR.Throw.prototype.compile = function (cx) {
    var argument = compileValue(this.argument, cx);
    return new ThrowStatement(argument);
  };
  IR.Arguments.prototype.compile = function (cx) {
    return id('arguments');
  };
  IR.ASGlobal.prototype.compile = function (cx) {
    var scope = compileValue(this.scope, cx);
    return property(scope, 'global', 'object');
  };
  IR.ASSetProperty.prototype.compile = function (cx) {
    var object = compileValue(this.object, cx);
    var value = compileValue(this.value, cx);
    if (this.flags & IR.Flags.INDEXED) {
      return call(property(object, 'asSetNumericProperty'), [
        compileValue(this.name.name, cx),
        value
      ]);
    }
    var name = compileMultiname(this.name, cx);
    return call(property(object, 'asSetProperty'), name.concat(value));
  };
  IR.ASDeleteProperty.prototype.compile = function (cx) {
    var object = compileValue(this.object, cx);
    var name = compileMultiname(this.name, cx);
    return call(property(object, 'asDeleteProperty'), name);
  };
  IR.ASHasProperty.prototype.compile = function (cx) {
    var object = compileValue(this.object, cx);
    var name = compileMultiname(this.name, cx);
    return call(property(object, 'asHasProperty'), name);
  };
  IR.GlobalProperty.prototype.compile = function (cx) {
    return id(this.name);
  };
  IR.GetProperty.prototype.compile = function (cx) {
    var object = compileValue(this.object, cx);
    var name = compileValue(this.name, cx);
    return property(object, name);
  };
  IR.SetProperty.prototype.compile = function (cx) {
    var object = compileValue(this.object, cx);
    var name = compileValue(this.name, cx);
    var value = compileValue(this.value, cx);
    return assignment(property(object, name), value);
  };
  IR.ASGetDescendants.prototype.compile = function (cx) {
    var object = compileValue(this.object, cx);
    var name = compileValue(this.name, cx);
    return call(id('getDescendants'), [
      object,
      name
    ]);
  };
  IR.ASSetSlot.prototype.compile = function (cx) {
    var object = compileValue(this.object, cx);
    var name = compileValue(this.name, cx);
    var value = compileValue(this.value, cx);
    return call(id('asSetSlot'), [
      object,
      name,
      value
    ]);
  };
  IR.ASGetSlot.prototype.compile = function (cx) {
    var object = compileValue(this.object, cx);
    var name = compileValue(this.name, cx);
    return call(id('asGetSlot'), [
      object,
      name
    ]);
  };
  IR.Projection.prototype.compile = function (cx) {
    true;
    true;
    return compileValue(this.argument.scope, cx);
  };
  IR.NewArray.prototype.compile = function (cx) {
    return new ArrayExpression(compileValues(this.elements, cx));
  };
  IR.NewObject.prototype.compile = function (cx) {
    var properties = this.properties.map(function (property) {
        var key = compileValue(property.key, cx);
        var value = compileValue(property.value, cx);
        return new Property(key, value, 'init');
      });
    return new ObjectExpression(properties);
  };
  IR.ASNewActivation.prototype.compile = function (cx) {
    var methodInfo = compileValue(this.methodInfo, cx);
    return call(id('createActivation'), [
      methodInfo
    ]);
  };
  IR.ASMultiname.prototype.compile = function (cx) {
    var namespaces = compileValue(this.namespaces, cx);
    var name = compileValue(this.name, cx);
    return call(id('createName'), [
      namespaces,
      name
    ]);
  };
  function generateSource(node) {
    return escodegen.generate(node, {
      base: '',
      indent: '  ',
      comment: true,
      format: {
        compact: false
      }
    });
  }
  function generate(cfg, useRegisterAllocator) {
    Timer.start('Looper');
    var root = Looper.analyze(cfg);
    Timer.stop();
    var writer = new IndentingWriter();
    var cx = new Context();
    Timer.start('Construct AST');
    var code = root.compile(cx);
    Timer.stop();
    var parameters = [];
    for (var i = 0; i < cx.parameters.length; i++) {
      var name = cx.parameters[i] ? cx.parameters[i].name : '_';
      parameters.push(id(name));
    }
    if (cx.variables.length) {
      Counter.count('Backend: Locals', cx.variables.length);
      var variables = variableDeclaration(cx.variables.map(function (variable) {
          return new VariableDeclarator(id(variable.name));
        }));
      code.body.unshift(variables);
    }
    var node = new FunctionDeclaration(id('fn'), parameters, code);
    if (useRegisterAllocator) {
      if (c4TraceLevel.value > 0) {
        writer.writeLn('=== BEFORE ===============================');
        writer.writeLn(generateSource(node));
        writer.writeLn('=== TRANSFORMING =========================');
      }
      Transform.transform(node);
      if (c4TraceLevel.value > 0) {
        writer.writeLn('=== AFTER ================================');
        writer.writeLn(generateSource(node));
        writer.writeLn('==========================================');
      }
      var body = generateSource(code);
      return {
        parameters: parameters.map(function (p) {
          return p.name;
        }),
        body: body
      };
    }
    Timer.start('Serialize AST');
    var source = generateSource(code);
    Timer.stop();
    return {
      parameters: parameters.map(function (p) {
        return p.name;
      }),
      body: source
    };
  }
  Backend.generate = generate;
}(typeof exports === 'undefined' ? Backend = {} : exports));
var domainOptions = systemOptions.register(new OptionSet('Domain Options'));
var traceClasses = domainOptions.register(new Option('tc', 'traceClasses', 'boolean', false, 'trace class creation'));
var traceDomain = domainOptions.register(new Option('td', 'traceDomain', 'boolean', false, 'trace domain property access'));
var EXECUTION_MODE = {
    INTERPRET: 1,
    COMPILE: 2
  };
function executeScript(script) {
  var abc = script.abc;
  if (disassemble.value) {
    abc.trace(new IndentingWriter());
  }
  if (traceExecution.value) {
    print('Executing: ' + abc.name + ' ' + script);
  }
  true;
  var global = new Global(script);
  if (abc.domain.allowNatives) {
    global[Multiname.getPublicQualifiedName('unsafeJSNative')] = getNative;
  }
  script.executing = true;
  var scope = new Scope(null, script.global);
  createFunction(script.init, scope).call(script.global);
  script.executed = true;
}
function ensureScriptIsExecuted(script, reason) {
  if (!script.executed && !script.executing) {
    if (traceExecution.value >= 2) {
      print('Executing Script For: ' + reason);
    }
    executeScript(script);
  }
}
var Glue = createEmptyObject();
Glue.PUBLIC_PROPERTIES = 1;
Glue.PUBLIC_METHODS = 2;
Glue.ALL = Glue.PUBLIC_PROPERTIES | Glue.PUBLIC_METHODS;
var Domain = function () {
    function Domain(vm, base, mode, allowNatives) {
      this.vm = vm;
      this.abcs = [];
      this.loadedAbcs = {};
      this.loadedClasses = [];
      this.classCache = createEmptyObject();
      this.scriptCache = createEmptyObject();
      this.classInfoCache = createEmptyObject();
      this.base = base;
      this.allowNatives = allowNatives;
      this.mode = mode;
      this.onMessage = new Callback();
      if (base) {
        this.system = base.system;
      } else {
        this.system = this;
      }
    }
    Domain.passthroughCallable = function passthroughCallable(f) {
      return {
        call: function ($this) {
          Array.prototype.shift.call(arguments);
          return f.apply($this, arguments);
        },
        apply: function ($this, args) {
          return f.apply($this, args);
        }
      };
    };
    Domain.coerceCallable = function coerceCallable(type) {
      return {
        call: function ($this, value) {
          return asCoerce(type, value);
        },
        apply: function ($this, args) {
          return asCoerce(type, args[0]);
        }
      };
    };
    Domain.constructingCallable = function constructingCallable(instanceConstructor) {
      return {
        call: function ($this) {
          return new Function.bind.apply(instanceConstructor, arguments);
        },
        apply: function ($this, args) {
          return new Function.bind.apply(instanceConstructor, [
            $this
          ].concat(args));
        }
      };
    };
    Domain.prototype = {
      getType: function getType(multiname) {
        return this.getProperty(multiname, true, true);
      },
      getProperty: function getProperty(multiname, strict, execute) {
        var resolved = this.findDefiningScript(multiname, execute);
        if (resolved) {
          if (!resolved.script.executing) {
            return undefined;
          }
          return resolved.script.global[Multiname.getQualifiedName(resolved.trait.name)];
        }
        if (strict) {
          return unexpected('Cannot find property ' + multiname);
        }
        return undefined;
      },
      getClass: function getClass(simpleName) {
        var cache = this.classCache;
        var c = cache[simpleName];
        if (!c) {
          c = cache[simpleName] = this.getProperty(Multiname.fromSimpleName(simpleName), true, true);
        }
        true;
        return c;
      },
      findClass: function findClass(simpleName) {
        if (simpleName in this.classCache) {
          return true;
        }
        return this.findDomainProperty(Multiname.fromSimpleName(simpleName), false, true);
      },
      findDomainProperty: function findDomainProperty(multiname, strict, execute) {
        if (traceDomain.value) {
          print('Domain.findDomainProperty: ' + multiname);
        }
        var resolved = this.findDefiningScript(multiname, execute);
        if (resolved) {
          return resolved.script.global;
        }
        if (strict) {
          return unexpected('Cannot find property ' + multiname);
        } else {
          return undefined;
        }
        return undefined;
      },
      findClassInfo: function findClassInfo(mn) {
        var originalQn;
        if (Multiname.isQName(mn)) {
          originalQn = Multiname.getQualifiedName(mn);
          var ci = this.classInfoCache[originalQn];
          if (ci) {
            return ci;
          }
        } else {
          var ci = this.classInfoCache[mn.id];
          if (ci) {
            return ci;
          }
        }
        if (this.base) {
          ci = this.base.findClassInfo(mn);
          if (ci) {
            return ci;
          }
        }
        var abcs = this.abcs;
        for (var i = 0; i < abcs.length; i++) {
          var abc = abcs[i];
          var scripts = abc.scripts;
          for (var j = 0; j < scripts.length; j++) {
            var script = scripts[j];
            var traits = script.traits;
            for (var k = 0; k < traits.length; k++) {
              var trait = traits[k];
              if (trait.isClass()) {
                var traitName = Multiname.getQualifiedName(trait.name);
                if (originalQn) {
                  if (traitName === originalQn) {
                    return this.classInfoCache[originalQn] = trait.classInfo;
                  }
                } else {
                  for (var m = 0, n = mn.namespaces.length; m < n; m++) {
                    var qn = mn.getQName(m);
                    if (traitName === Multiname.getQualifiedName(qn)) {
                      return this.classInfoCache[qn] = trait.classInfo;
                    }
                  }
                }
              }
            }
          }
        }
        if (!this.base && this.vm.findDefiningAbc) {
          var abc = this.vm.findDefiningAbc(mn);
          if (abc !== null && !this.loadedAbcs[abc.name]) {
            this.loadedAbcs[abc.name] = true;
            this.loadAbc(abc);
            return this.findClassInfo(mn);
          }
        }
        return undefined;
      },
      installNative: function (name, func) {
        natives[name] = function () {
          return func;
        };
      },
      findDefiningScript: function findDefiningScript(mn, execute) {
        var resolved = this.scriptCache[mn.id];
        if (resolved && (resolved.script.executed || !execute)) {
          return resolved;
        }
        if (this.base) {
          resolved = this.base.findDefiningScript(mn, execute);
          if (resolved) {
            return resolved;
          }
        }
        Counter.count('Domain: findDefiningScript');
        var abcs = this.abcs;
        for (var i = 0; i < abcs.length; i++) {
          var abc = abcs[i];
          var scripts = abc.scripts;
          for (var j = 0; j < scripts.length; j++) {
            var script = scripts[j];
            var traits = script.traits;
            if (mn instanceof Multiname) {
              for (var k = 0; k < traits.length; k++) {
                var trait = traits[k];
                if (mn.hasQName(trait.name)) {
                  if (execute) {
                    ensureScriptIsExecuted(script, trait.name);
                  }
                  return this.scriptCache[mn.id] = {
                    script: script,
                    trait: trait
                  };
                }
              }
            } else {
              unexpected();
            }
          }
        }
        if (!this.base && this.vm.findDefiningAbc) {
          var abc = this.vm.findDefiningAbc(mn);
          if (abc !== null && !this.loadedAbcs[abc.name]) {
            this.loadedAbcs[abc.name] = true;
            this.loadAbc(abc);
            return this.findDefiningScript(mn, execute);
          }
        }
        return undefined;
      },
      compileAbc: function compileAbc(abc) {
        console.time('Compile ABC: ' + abc.name);
        this.loadAbc(abc);
        var writer = new IndentingWriter();
        writer.enter('var classes = {');
        for (var i = 0; i < abc.scripts.length; i++) {
          compileScript(abc.scripts[i], writer);
        }
        writer.leave('}');
        console.timeEnd('Compile ABC: ' + abc.name);
      },
      executeAbc: function executeAbc(abc) {
        console.time('Execute ABC: ' + abc.name);
        this.loadAbc(abc);
        executeScript(abc.lastScript);
        console.timeEnd('Execute ABC: ' + abc.name);
      },
      loadAbc: function loadAbc(abc) {
        if (traceExecution.value) {
          print('Loading: ' + abc.name);
        }
        abc.domain = this;
        GlobalMultinameResolver.loadAbc(abc);
        this.abcs.push(abc);
        if (!this.base) {
          Type.initializeTypes(this);
        }
      },
      broadcastMessage: function (type, message, origin) {
        if (false) {
          Timer.start('broadcast: ' + type);
        }
        this.onMessage.notify1(type, {
          data: message,
          origin: origin,
          source: this
        });
        if (false) {
          Timer.stop();
        }
      },
      traceLoadedClasses: function (lastOnly) {
        var writer = new IndentingWriter();
        lastOnly || writer.enter('Loaded Classes And Interfaces');
        var classes = lastOnly ? [
            this.loadedClasses.last()
          ] : this.loadedClasses;
        classes.forEach(function (cls) {
          if (cls !== Class) {
            cls.trace(writer);
          }
        });
        lastOnly || writer.leave('');
      }
    };
    return Domain;
  }();
var traitsWriter = null;
var Binding = function () {
    function binding(trait) {
      true;
      this.trait = trait;
    }
    var SET_PREFIX = 'set ';
    var GET_PREFIX = 'get ';
    binding.KEY_PREFIX_LENGTH = SET_PREFIX.length;
    binding.getKey = function getKey(qn, trait) {
      var key = qn;
      if (trait.isGetter()) {
        key = GET_PREFIX + qn;
      } else if (trait.isSetter()) {
        key = SET_PREFIX + qn;
      }
      return key;
    };
    binding.prototype.toString = function toString() {
      return String(this.trait);
    };
    return binding;
  }();
var Bindings = function () {
    function bindings() {
      this.map = createEmptyObject();
      this.slots = [];
      this.nextSlotId = 1;
    }
    bindings.prototype.assignNextSlot = function assignNextSlot(trait) {
      true;
      true;
      if (!trait.slotId) {
        trait.slotId = this.nextSlotId++;
      } else {
        this.nextSlotId = trait.slotId + 1;
      }
      true;
      this.slots[trait.slotId] = trait;
    };
    bindings.prototype.trace = function trace(writer) {
      writer.enter('Bindings');
      for (var key in this.map) {
        var binding = this.map[key];
        writer.writeLn(binding.trait.kindName() + ': ' + key + ' -> ' + binding);
      }
      writer.leaveAndEnter('Slots');
      writer.writeArray(this.slots);
      writer.outdent();
    };
    function SlotInfo(name, isConst, type, trait) {
      this.name = name;
      this.isConst = isConst;
      this.type = type;
      this.trait = trait;
    }
    function patch(patchTargets, value) {
      true;
      for (var i = 0; i < patchTargets.length; i++) {
        var patchTarget = patchTargets[i];
        if (traceExecution.value >= 3) {
          var str = 'Patching: ';
          if (patchTarget.name) {
            str += patchTarget.name;
          } else if (patchTarget.get) {
            str += 'get ' + patchTarget.get;
          } else if (patchTarget.set) {
            str += 'set ' + patchTarget.set;
          }
          traitsWriter && traitsWriter.redLn(str);
        }
        if (patchTarget.get) {
          defineNonEnumerableGetterOrSetter(patchTarget.object, patchTarget.get, value, true);
        } else if (patchTarget.set) {
          defineNonEnumerableGetterOrSetter(patchTarget.object, patchTarget.set, value, false);
        } else {
          defineNonEnumerableProperty(patchTarget.object, patchTarget.name, value);
        }
      }
    }
    function applyNonMemoizedMethodTrait(qn, trait, object, scope, natives) {
      true;
      if (trait.isMethod()) {
        var trampoline = makeTrampoline(function (self) {
            var fn = getTraitFunction(trait, scope, natives);
            patch(self.patchTargets, fn);
            return fn;
          }, trait.methodInfo.parameters.length);
        trampoline.patchTargets = [
          {
            object: object,
            name: qn
          },
          {
            object: object,
            name: VM_OPEN_METHOD_PREFIX + qn
          }
        ];
        var closure = bindSafely(trampoline, object);
        defineReadOnlyProperty(closure, VM_LENGTH, trampoline[VM_LENGTH]);
        defineReadOnlyProperty(closure, Multiname.getPublicQualifiedName('prototype'), null);
        defineNonEnumerableProperty(object, qn, closure);
        defineNonEnumerableProperty(object, VM_OPEN_METHOD_PREFIX + qn, closure);
      } else if (trait.isGetter() || trait.isSetter()) {
        var trampoline = makeTrampoline(function (self) {
            var fn = getTraitFunction(trait, scope, natives);
            patch(self.patchTargets, fn);
            return fn;
          });
        if (trait.isGetter()) {
          trampoline.patchTargets = [
            {
              object: object,
              get: qn
            }
          ];
        } else {
          trampoline.patchTargets = [
            {
              object: object,
              set: qn
            }
          ];
        }
        defineNonEnumerableGetterOrSetter(object, qn, trampoline, trait.isGetter());
      } else {
        unexpected(trait);
      }
    }
    function applyMemoizedMethodTrait(qn, trait, object, scope, natives) {
      true;
      if (trait.isMethod()) {
        var memoizerTarget = {
            value: null
          };
        var trampoline = makeTrampoline(function (self) {
            var fn = getTraitFunction(trait, scope, natives);
            patch(self.patchTargets, fn);
            return fn;
          }, trait.methodInfo.parameters.length, String(trait.name));
        memoizerTarget.value = trampoline;
        var openMethods = object[VM_OPEN_METHODS];
        openMethods[qn] = trampoline;
        defineNonEnumerableProperty(object, VM_OPEN_METHOD_PREFIX + qn, trampoline);
        defineNonEnumerableGetter(object, qn, makeMemoizer(qn, memoizerTarget));
        trampoline.patchTargets = [
          {
            object: memoizerTarget,
            name: 'value'
          },
          {
            object: openMethods,
            name: qn
          },
          {
            object: object,
            name: VM_OPEN_METHOD_PREFIX + qn
          }
        ];
      } else if (trait.isGetter() || trait.isSetter()) {
        var trampoline = makeTrampoline(function (self) {
            var fn = getTraitFunction(trait, scope, natives);
            patch(self.patchTargets, fn);
            return fn;
          }, 0, String(trait.name));
        if (trait.isGetter()) {
          trampoline.patchTargets = [
            {
              object: object,
              get: qn
            }
          ];
        } else {
          trampoline.patchTargets = [
            {
              object: object,
              set: qn
            }
          ];
        }
        defineNonEnumerableGetterOrSetter(object, qn, trampoline, trait.isGetter());
      }
    }
    bindings.prototype.applyTo = function applyTo(domain, object) {
      true;
      true;
      true;
      defineNonEnumerableProperty(object, VM_SLOTS, []);
      defineNonEnumerableProperty(object, VM_BINDINGS, []);
      defineNonEnumerableProperty(object, VM_OPEN_METHODS, createEmptyObject());
      defineNonEnumerableProperty(object, 'bindings', this);
      defineNonEnumerableProperty(object, 'resolutionMap', []);
      traitsWriter && traitsWriter.greenLn('Applying Traits');
      for (var key in this.map) {
        var binding = this.map[key];
        var trait = binding.trait;
        var qn = Multiname.getQualifiedName(trait.name);
        if (trait.isSlot() || trait.isConst() || trait.isClass()) {
          var defaultValue = undefined;
          if (trait.isSlot() || trait.isConst()) {
            if (trait.hasDefaultValue) {
              defaultValue = trait.value;
            } else if (trait.typeName) {
              defaultValue = domain.findClassInfo(trait.typeName).defaultValue;
            }
          }
          if (key !== qn) {
            traitsWriter && traitsWriter.yellowLn('Binding Trait: ' + key + ' -> ' + qn);
            defineNonEnumerableGetter(object, key, makeForwardingGetter(qn));
            object[VM_BINDINGS].pushUnique(key);
          } else {
            traitsWriter && traitsWriter.greenLn('Applying Trait ' + trait.kindName() + ': ' + trait);
            defineNonEnumerableProperty(object, qn, defaultValue);
            object[VM_BINDINGS].pushUnique(qn);
            object[VM_SLOTS][trait.slotId] = new SlotInfo(qn, trait.isConst(), trait.typeName ? domain.getProperty(trait.typeName, false, false) : null, trait);
          }
        } else if (trait.isMethod() || trait.isGetter() || trait.isSetter()) {
          if (trait.isGetter() || trait.isSetter()) {
            key = key.substring(Binding.KEY_PREFIX_LENGTH);
          }
          if (key !== qn) {
            traitsWriter && traitsWriter.yellowLn('Binding Trait: ' + key + ' -> ' + qn);
          } else {
            traitsWriter && traitsWriter.greenLn('Applying Trait ' + trait.kindName() + ': ' + trait);
          }
          object[VM_BINDINGS].pushUnique(key);
          if (this instanceof ScriptBindings) {
            applyNonMemoizedMethodTrait(key, trait, object, binding.scope, binding.natives);
          } else {
            applyMemoizedMethodTrait(key, trait, object, binding.scope, binding.natives);
          }
        }
      }
    };
    return bindings;
  }();
var ActivationBindings = function () {
    function activationBindings(methodInfo) {
      Bindings.call(this);
      true;
      this.methodInfo = methodInfo;
      var traits = methodInfo.traits;
      for (var i = 0; i < traits.length; i++) {
        var trait = traits[i];
        true;
        var key = Multiname.getQualifiedName(trait.name);
        this.map[key] = new Binding(trait);
        this.assignNextSlot(trait);
      }
    }
    activationBindings.prototype = Object.create(Bindings.prototype);
    return activationBindings;
  }();
var CatchBindings = function () {
    function catchBindings(scope, trait) {
      Bindings.call(this);
      var key = Multiname.getQualifiedName(trait.name);
      this.map[key] = new Binding(trait);
      true;
      this.assignNextSlot(trait);
    }
    catchBindings.prototype = Object.create(Bindings.prototype);
    return catchBindings;
  }();
var ScriptBindings = function () {
    function scriptBindings(scriptInfo, scope) {
      Bindings.call(this);
      this.scope = scope;
      this.scriptInfo = scriptInfo;
      var traits = scriptInfo.traits;
      for (var i = 0; i < traits.length; i++) {
        var trait = traits[i];
        var name = Multiname.getQualifiedName(trait.name);
        var key = Binding.getKey(name, trait);
        var binding = this.map[key] = new Binding(trait);
        if (trait.isSlot() || trait.isConst() || trait.isClass()) {
          this.assignNextSlot(trait);
        }
        if (trait.isClass()) {
          if (trait.metadata && trait.metadata.native) {
            trait.classInfo.native = trait.metadata.native;
          }
        }
        if (trait.isMethod() || trait.isGetter() || trait.isSetter()) {
          binding.scope = this.scope;
        }
      }
    }
    scriptBindings.prototype = Object.create(Bindings.prototype);
    return scriptBindings;
  }();
var ClassBindings = function () {
    function classBindings(classInfo, scope, natives) {
      Bindings.call(this);
      this.scope = scope;
      this.natives = natives;
      this.classInfo = classInfo;
      var traits = classInfo.traits;
      for (var i = 0; i < traits.length; i++) {
        var trait = traits[i];
        var name = Multiname.getQualifiedName(trait.name);
        var key = Binding.getKey(name, trait);
        var binding = this.map[key] = new Binding(trait);
        if (trait.isSlot() || trait.isConst()) {
          this.assignNextSlot(trait);
        }
        if (trait.isMethod() || trait.isGetter() || trait.isSetter()) {
          binding.scope = this.scope;
          binding.natives = this.natives;
        }
      }
    }
    classBindings.prototype = Object.create(Bindings.prototype);
    return classBindings;
  }();
var InstanceBindings = function () {
    function instanceBindings(parent, instanceInfo, scope, natives) {
      Bindings.call(this);
      this.scope = scope;
      this.natives = natives;
      this.parent = parent;
      this.instanceInfo = instanceInfo;
      this.implementedInterfaces = parent ? cloneObject(parent.implementedInterfaces) : createEmptyObject();
      if (parent) {
        this.slots = parent.slots.slice();
        this.nextSlotId = parent.nextSlotId;
      }
      extend.call(this, parent);
    }
    function extend(parent) {
      var ii = this.instanceInfo, ib;
      var map = this.map;
      var name, key, trait, binding, protectedName, protectedKey;
      if (parent) {
        for (key in parent.map) {
          binding = parent.map[key];
          trait = binding.trait;
          map[key] = binding;
          if (trait.isProtected()) {
            protectedName = Multiname.getQualifiedName(new Multiname([
              ii.protectedNs
            ], trait.name.getName()));
            protectedKey = Binding.getKey(protectedName, trait);
            map[protectedKey] = binding;
          }
        }
      }
      function writeOrOverwriteBinding(object, key, binding) {
        var trait = binding.trait;
        var oldBinding = object[key];
        if (oldBinding) {
          var oldTrait = oldBinding.trait;
          true;
          true;
        } else {
          true;
        }
        object[key] = binding;
      }
      function overwriteProtectedBinding(object, key, binding) {
        if (key in object) {
          object[key] = binding;
        }
      }
      var traits = ii.traits;
      for (var i = 0; i < traits.length; i++) {
        trait = traits[i];
        name = Multiname.getQualifiedName(trait.name);
        key = Binding.getKey(name, trait);
        binding = new Binding(trait);
        writeOrOverwriteBinding(map, key, binding);
        if (trait.isProtected()) {
          ib = this.parent;
          while (ib) {
            protectedName = Multiname.getQualifiedName(new Multiname([
              ib.instanceInfo.protectedNs
            ], trait.name.getName()));
            protectedKey = Binding.getKey(protectedName, trait);
            overwriteProtectedBinding(map, protectedKey, binding);
            ib = ib.parent;
          }
        }
        if (trait.isSlot() || trait.isConst()) {
          this.assignNextSlot(trait);
        }
        if (trait.isMethod() || trait.isGetter() || trait.isSetter()) {
          binding.scope = this.scope;
          binding.natives = this.natives;
        }
      }
      var domain = ii.abc.domain;
      var interfaces = ii.interfaces;
      for (var i = 0; i < interfaces.length; i++) {
        var interface = domain.getProperty(interfaces[i], true, true);
        copyProperties(this.implementedInterfaces, interface.interfaceBindings.implementedInterfaces);
        this.implementedInterfaces[Multiname.getQualifiedName(interface.name)] = interface;
      }
      for (var interfaceName in this.implementedInterfaces) {
        var interface = this.implementedInterfaces[interfaceName];
        ib = interface.interfaceBindings;
        for (var interfaceKey in ib.map) {
          var interfaceBinding = ib.map[interfaceKey];
          if (ii.isInterface()) {
            map[interfaceKey] = interfaceBinding;
          } else {
            name = Multiname.getPublicQualifiedName(interfaceBinding.trait.name.getName());
            key = Binding.getKey(name, interfaceBinding.trait);
            map[interfaceKey] = map[key];
          }
        }
      }
    }
    instanceBindings.prototype = Object.create(Bindings.prototype);
    instanceBindings.prototype.toString = function toString() {
      return this.instanceInfo.toString();
    };
    return instanceBindings;
  }();
var Interface = function () {
    function Interface(classInfo) {
      var ii = classInfo.instanceInfo;
      true;
      this.name = ii.name;
      this.classInfo = classInfo;
    }
    Interface.createInterface = function createInterface(classInfo) {
      var ii = classInfo.instanceInfo;
      true;
      if (traceExecution.value) {
        var str = 'Creating Interface ' + ii.name;
        if (ii.interfaces.length) {
          str += ' implements ' + ii.interfaces.map(function (name) {
            return name.getName();
          }).join(', ');
        }
        print(str);
      }
      var cls = new Interface(classInfo);
      cls.interfaceBindings = new InstanceBindings(null, ii);
      return cls;
    };
    Interface.prototype = {
      toString: function () {
        return '[interface ' + this.name + ']';
      },
      isInstance: function (value) {
        if (value === null || typeof value !== 'object') {
          return false;
        }
        true;
        var qualifiedName = Multiname.getQualifiedName(this.name);
        return value.class.implementedInterfaces[qualifiedName] !== undefined;
      },
      trace: function trace(writer) {
        writer.enter('interface ' + this.name.getName());
        writer.enter('interfaceBindings: ');
        this.interfaceBindings.trace(writer);
        writer.outdent();
        writer.outdent();
        writer.leave('}');
      },
      call: function ($this, x) {
        return x;
      },
      apply: function ($this, args) {
        return args[0];
      }
    };
    return Interface;
  }();
var Class = function () {
    var OWN_INITIALIZE = 1;
    var SUPER_INITIALIZE = 2;
    function Class(name, instanceConstructor, callable) {
      this.debugName = name;
      if (instanceConstructor) {
        true;
        this.instanceConstructor = instanceConstructor;
        this.instanceConstructorNoInitialize = instanceConstructor;
        this.hasInitialize = 0;
        this.instanceConstructor.class = this;
      }
      if (!callable) {
        callable = Domain.coerceCallable(this);
      } else if (callable === Domain.coerceCallable) {
        callable = Domain.coerceCallable(this);
      }
      defineNonEnumerableProperty(this, 'call', callable.call);
      defineNonEnumerableProperty(this, 'apply', callable.apply);
    }
    Class.createClass = function createClass(classInfo, baseClass, scope) {
      var ci = classInfo;
      var ii = ci.instanceInfo;
      var domain = ci.abc.domain;
      var className = Multiname.getName(ii.name);
      var isNativeClass = ci.native;
      if (isNativeClass) {
        var classBuilder = getNative(ci.native.cls);
        if (!classBuilder) {
          unexpected('No native for ' + ci.native.cls);
        }
        if (!baseClass) {
          scope = new Scope(scope, Class);
        }
      }
      var classScope = new Scope(scope, null);
      var instanceConstructor = createFunction(ii.init, classScope);
      var cls;
      if (isNativeClass) {
        cls = classBuilder(domain, classScope, instanceConstructor, baseClass);
      } else {
        cls = new Class(className, instanceConstructor);
      }
      cls.className = className;
      cls.classInfo = classInfo;
      cls.scope = classScope;
      classScope.object = cls;
      var classNatives;
      var instanceNatives;
      if (isNativeClass) {
        if (cls.native) {
          classNatives = cls.native.static;
          instanceNatives = cls.native.instance;
        }
      } else {
        cls.extend(baseClass);
      }
      cls.classBindings = new ClassBindings(classInfo, classScope, classNatives);
      cls.classBindings.applyTo(domain, cls);
      defineReadOnlyProperty(cls, VM_IS_CLASS, true);
      cls.instanceBindings = new InstanceBindings(baseClass ? baseClass.instanceBindings : null, ii, classScope, instanceNatives);
      if (cls.instanceConstructor) {
        cls.instanceBindings.applyTo(domain, cls.traitsPrototype);
      }
      cls.implementedInterfaces = cls.instanceBindings.implementedInterfaces;
      return cls;
    };
    function setDefaultProperties(cls) {
      defineNonEnumerableProperty(cls.dynamicPrototype, Multiname.getPublicQualifiedName('constructor'), cls);
      defineReadOnlyProperty(cls.traitsPrototype, 'class', cls);
      defineReadOnlyProperty(cls.instanceConstructor, 'class', cls);
    }
    Class.prototype = {
      setSymbol: function setSymbol(props) {
        this.instanceConstructor.prototype.symbol = props;
      },
      getSymbol: function getSymbol() {
        return this.instanceConstructor.prototype.symbol;
      },
      initializeInstance: function initializeInstance(obj) {
        var c = this;
        var initializes = [];
        while (c) {
          if (c.hasInitialize & OWN_INITIALIZE) {
            initializes.push(c.instanceConstructor.prototype.initialize);
          }
          c = c.baseClass;
        }
        var s;
        while (s = initializes.pop()) {
          s.call(obj);
        }
        Counter.count('Initialize Instance');
      },
      createInstance: function createInstance(args) {
        var o = Object.create(this.instanceConstructor.prototype);
        this.instanceConstructor.apply(o, args);
        return o;
      },
      createAsSymbol: function createAsSymbol(props) {
        var o = Object.create(this.instanceConstructor.prototype);
        if (o.symbol) {
          var symbol = Object.create(o.symbol);
          for (var prop in props) {
            symbol[prop] = props[prop];
          }
          o.symbol = symbol;
        } else {
          o.symbol = props;
        }
        return o;
      },
      extendNative: function (baseClass, native) {
        this.baseClass = baseClass;
        this.dynamicPrototype = Object.getPrototypeOf(native.prototype);
        this.instanceConstructor.prototype = this.traitsPrototype = native.prototype;
        setDefaultProperties(this);
      },
      extendWrapper: function (baseClass, wrapper) {
        true;
        this.baseClass = baseClass;
        this.dynamicPrototype = Object.create(baseClass.dynamicPrototype);
        var traitsPrototype = Object.create(this.dynamicPrototype, getOwnPropertyDescriptors(wrapper.prototype));
        this.instanceConstructor.prototype = this.traitsPrototype = traitsPrototype;
        setDefaultProperties(this);
      },
      extendBuiltin: function (baseClass) {
        true;
        this.baseClass = baseClass;
        this.dynamicPrototype = this.traitsPrototype = this.instanceConstructor.prototype;
        setDefaultProperties(this);
      },
      extend: function (baseClass) {
        true;
        this.baseClass = baseClass;
        this.dynamicPrototype = Object.create(baseClass.dynamicPrototype);
        if (baseClass.hasInitialize) {
          var instanceConstructorNoInitialize = this.instanceConstructor;
          var self = this;
          this.instanceConstructor = function () {
            self.initializeInstance(this);
            instanceConstructorNoInitialize.apply(this, arguments);
          };
          defineReadOnlyProperty(this.instanceConstructor, 'class', instanceConstructorNoInitialize.class);
          this.hasInitialize |= SUPER_INITIALIZE;
        }
        this.instanceConstructor.prototype = this.traitsPrototype = Object.create(this.dynamicPrototype);
        setDefaultProperties(this);
      },
      setDefaultProperties: function () {
        setDefaultProperties(this);
      },
      link: function (definition) {
        true;
        true;
        if (definition.initialize) {
          if (!this.hasInitialize) {
            var instanceConstructorNoInitialize = this.instanceConstructor;
            var self = this;
            this.instanceConstructor = function () {
              self.initializeInstance(this);
              instanceConstructorNoInitialize.apply(this, arguments);
            };
            defineReadOnlyProperty(this.instanceConstructor, 'class', instanceConstructorNoInitialize.class);
            this.instanceConstructor.prototype = instanceConstructorNoInitialize.prototype;
          }
          this.hasInitialize |= OWN_INITIALIZE;
        }
        var dynamicPrototype = this.dynamicPrototype;
        var keys = Object.keys(definition);
        for (var i = 0; i < keys.length; i++) {
          var propertyName = keys[i];
          Object.defineProperty(dynamicPrototype, propertyName, Object.getOwnPropertyDescriptor(definition, propertyName));
        }
        function glueProperties(obj, properties) {
          var keys = Object.keys(properties);
          for (var i = 0; i < keys.length; i++) {
            var propertyName = keys[i];
            var propertyGlue = properties[propertyName];
            var propertySimpleName;
            var glueOpenMethod = false;
            if (propertyGlue.indexOf('open ') >= 0) {
              propertySimpleName = propertyGlue.substring(5);
              glueOpenMethod = true;
            } else {
              propertySimpleName = propertyGlue;
            }
            true;
            var qn = Multiname.getQualifiedName(Multiname.fromSimpleName(propertySimpleName));
            if (glueOpenMethod) {
              qn = VM_OPEN_METHOD_PREFIX + qn;
            }
            true;
            var descriptor = Object.getOwnPropertyDescriptor(obj, qn);
            if (descriptor && descriptor.get) {
              Object.defineProperty(obj, propertyName, descriptor);
            } else {
              Object.defineProperty(obj, propertyName, {
                get: new Function('', 'return this.' + qn),
                set: new Function('v', 'this.' + qn + ' = v')
              });
            }
          }
        }
        function generatePropertiesFromTraits(traits) {
          var properties = createEmptyObject();
          traits.forEach(function (trait) {
            var ns = trait.name.getNamespace();
            if (!ns.isPublic()) {
              return;
            }
            properties[trait.name.getName()] = (trait.isMethod() ? 'open ' : '') + 'public ' + trait.name.getName();
          });
          return properties;
        }
        var glue = definition.__glue__;
        if (!glue) {
          return;
        }
        if (glue.script) {
          if (glue.script.instance) {
            if (isNumber(glue.script.instance)) {
              true;
              glueProperties(dynamicPrototype, generatePropertiesFromTraits(this.classInfo.instanceInfo.traits));
            } else {
              glueProperties(dynamicPrototype, glue.script.instance);
            }
          }
          if (glue.script.static) {
            if (isNumber(glue.script.static)) {
              true;
              glueProperties(this, generatePropertiesFromTraits(this.classInfo.traits));
            } else {
              glueProperties(this, glue.script.static);
            }
          }
        }
      },
      linkNatives: function (definition) {
        var glue = definition.__glue__;
        this.native = glue.native;
      },
      verify: function () {
        var instanceConstructor = this.instanceConstructor;
        var tP = this.traitsPrototype;
        var dP = this.dynamicPrototype;
        true;
        true;
        true;
        true;
        if (tP !== Object.prototype) {
        }
        true;
      },
      coerce: function (value) {
        return value;
      },
      isInstanceOf: function (value) {
        return this.isInstance(value);
      },
      isInstance: function (value) {
        if (value === null || typeof value !== 'object') {
          return false;
        }
        return this.dynamicPrototype.isPrototypeOf(value);
      },
      trace: function trace(writer) {
        var description = this.debugName + (this.baseClass ? ' extends ' + this.baseClass.debugName : '');
        writer.enter('class ' + description + ' {');
        writer.writeLn('scope: ' + this.scope);
        writer.writeLn('baseClass: ' + this.baseClass);
        writer.writeLn('classInfo: ' + this.classInfo);
        writer.writeLn('dynamicPrototype: ' + this.dynamicPrototype);
        writer.writeLn('traitsPrototype: ' + this.traitsPrototype);
        writer.writeLn('dynamicPrototype === traitsPrototype: ' + (this.dynamicPrototype === this.traitsPrototype));
        writer.writeLn('instanceConstructor: ' + this.instanceConstructor);
        writer.writeLn('instanceConstructorNoInitialize: ' + this.instanceConstructorNoInitialize);
        writer.writeLn('instanceConstructor === instanceConstructorNoInitialize: ' + (this.instanceConstructor === this.instanceConstructorNoInitialize));
        var traitsPrototype = this.traitsPrototype;
        writer.enter('traitsPrototype: ');
        if (traitsPrototype) {
          writer.enter('VM_SLOTS: ');
          writer.writeArray(traitsPrototype[VM_SLOTS].map(function (slot) {
            return slot.trait;
          }));
          writer.outdent();
          writer.enter('VM_BINDINGS: ');
          writer.writeArray(traitsPrototype[VM_BINDINGS].map(function (binding) {
            var pd = Object.getOwnPropertyDescriptor(traitsPrototype, binding);
            var str = binding;
            if (pd.get || pd.set) {
              if (pd.get) {
                str += ' getter: ' + debugName(pd.get);
              }
              if (pd.set) {
                str += ' setter: ' + debugName(pd.set);
              }
            } else {
              str += ' value: ' + debugName(pd.value);
            }
            return str;
          }));
          writer.outdent();
          writer.enter('VM_OPEN_METHODS: ');
          writer.writeArray(toKeyValueArray(traitsPrototype[VM_OPEN_METHODS]).map(function (pair) {
            return pair[0] + ': ' + debugName(pair[1]);
          }));
          writer.outdent();
        }
        writer.enter('classBindings: ');
        this.classBindings.trace(writer);
        writer.outdent();
        writer.enter('instanceBindings: ');
        this.instanceBindings.trace(writer);
        writer.outdent();
        writer.outdent();
        writer.writeLn('call: ' + this.call);
        writer.writeLn('apply: ' + this.apply);
        writer.leave('}');
      },
      toString: function () {
        return '[class ' + this.classInfo.instanceInfo.name.name + ']';
      }
    };
    var callable = Domain.coerceCallable(Class);
    defineNonEnumerableProperty(Class, 'call', callable.call);
    defineNonEnumerableProperty(Class, 'apply', callable.apply);
    Class.instanceConstructor = Class;
    Class.toString = Class.prototype.toString;
    Class.native = {
      instance: {
        prototype: {
          get: function () {
            return this.dynamicPrototype;
          }
        }
      }
    };
    return Class;
  }();
function MethodClosure($this, fn) {
  var bound = bindSafely(fn, $this);
  defineNonEnumerableProperty(this, 'call', bound.call.bind(bound));
  defineNonEnumerableProperty(this, 'apply', bound.apply.bind(bound));
}
MethodClosure.prototype = {
  toString: function () {
    return 'function Function() {}';
  }
};
var XRegExp = function (undefined) {
    var REGEX_DATA = 'xregexp', self, features = {
        astral: false,
        natives: false
      }, nativ = {
        exec: RegExp.prototype.exec,
        test: RegExp.prototype.test,
        match: String.prototype.match,
        replace: String.prototype.replace,
        split: String.prototype.split
      }, fixed = {}, cache = {}, patternCache = {}, tokens = [], defaultScope = 'default', classScope = 'class', nativeTokens = {
        'default': /\\(?:0(?:[0-3][0-7]{0,2}|[4-7][0-7]?)?|[1-9]\d*|x[\dA-Fa-f]{2}|u[\dA-Fa-f]{4}|c[A-Za-z]|[\s\S])|\(\?[:=!]|[?*+]\?|{\d+(?:,\d*)?}\??|[\s\S]/,
        'class': /\\(?:[0-3][0-7]{0,2}|[4-7][0-7]?|x[\dA-Fa-f]{2}|u[\dA-Fa-f]{4}|c[A-Za-z]|[\s\S])|[\s\S]/
      }, replacementToken = /\$(?:{([\w$]+)}|([\d$&`']))/g, correctExecNpcg = nativ.exec.call(/()??/, '')[1] === undefined, hasNativeY = RegExp.prototype.sticky !== undefined, registeredFlags = {
        g: true,
        i: true,
        m: true,
        y: hasNativeY
      }, toString = {}.toString, add;
    function augment(regex, captureNames, addProto) {
      var p;
      if (addProto) {
        if (regex.__proto__) {
          regex.__proto__ = self.prototype;
        } else {
          for (p in self.prototype) {
            regex[p] = self.prototype[p];
          }
        }
      }
      regex[REGEX_DATA] = {
        captureNames: captureNames
      };
      return regex;
    }
    function clipDuplicates(str) {
      return nativ.replace.call(str, /([\s\S])(?=[\s\S]*\1)/g, '');
    }
    function copy(regex, options) {
      if (!self.isRegExp(regex)) {
        throw new TypeError('Type RegExp expected');
      }
      var flags = nativ.exec.call(/\/([a-z]*)$/i, String(regex))[1];
      options = options || {};
      if (options.add) {
        flags = clipDuplicates(flags + options.add);
      }
      if (options.remove) {
        flags = nativ.replace.call(flags, new RegExp('[' + options.remove + ']+', 'g'), '');
      }
      regex = augment(new RegExp(regex.source, flags), hasNamedCapture(regex) ? regex[REGEX_DATA].captureNames.slice(0) : null, options.addProto);
      return regex;
    }
    function getBaseProps() {
      return {
        captureNames: null
      };
    }
    function hasNamedCapture(regex) {
      return !(!(regex[REGEX_DATA] && regex[REGEX_DATA].captureNames));
    }
    function indexOf(array, value) {
      if (Array.prototype.indexOf) {
        return array.indexOf(value);
      }
      var len = array.length, i;
      for (i = 0; i < len; ++i) {
        if (array[i] === value) {
          return i;
        }
      }
      return -1;
    }
    function isType(value, type) {
      return toString.call(value) === '[object ' + type + ']';
    }
    function isQuantifierNext(pattern, pos, flags) {
      return nativ.test.call(flags.indexOf('x') > -1 ? /^(?:\s+|#.*|\(\?#[^)]*\))*(?:[?*+]|{\d+(?:,\d*)?})/ : /^(?:\(\?#[^)]*\))*(?:[?*+]|{\d+(?:,\d*)?})/, pattern.slice(pos));
    }
    function prepareFlags(pattern, flags) {
      var i;
      if (clipDuplicates(flags) !== flags) {
        throw new SyntaxError('Invalid duplicate regex flag ' + flags);
      }
      pattern = nativ.replace.call(pattern, /^\(\?([\w$]+)\)/, function ($0, $1) {
        if (nativ.test.call(/[gy]/, $1)) {
          throw new SyntaxError('Cannot use flag g or y in mode modifier ' + $0);
        }
        flags = clipDuplicates(flags + $1);
        return '';
      });
      for (i = 0; i < flags.length; ++i) {
        if (!registeredFlags[flags.charAt(i)]) {
          throw new SyntaxError('Unknown regex flag ' + flags.charAt(i));
        }
      }
      return {
        pattern: pattern,
        flags: flags
      };
    }
    function prepareOptions(value) {
      value = value || {};
      if (isType(value, 'String')) {
        value = self.forEach(value, /[^\s,]+/, function (match) {
          this[match] = true;
        }, {});
      }
      return value;
    }
    function registerFlag(flag) {
      if (!/^[\w$]$/.test(flag)) {
        throw new Error('Flag must be a single character A-Za-z0-9_$');
      }
      registeredFlags[flag] = true;
    }
    function runTokens(pattern, flags, pos, scope, context) {
      var i = tokens.length, result = null, match, t;
      while (i--) {
        t = tokens[i];
        if ((t.scope === scope || t.scope === 'all') && (!t.flag || flags.indexOf(t.flag) > -1)) {
          match = self.exec(pattern, t.regex, pos, 'sticky');
          if (match) {
            result = {
              matchLength: match[0].length,
              output: t.handler.call(context, match, scope, flags),
              reparse: t.reparse
            };
            break;
          }
        }
      }
      return result;
    }
    function setAstral(on) {
      self.cache.flush('patterns');
      features.astral = on;
    }
    function setNatives(on) {
      RegExp.prototype.exec = (on ? fixed : nativ).exec;
      RegExp.prototype.test = (on ? fixed : nativ).test;
      String.prototype.match = (on ? fixed : nativ).match;
      String.prototype.replace = (on ? fixed : nativ).replace;
      String.prototype.split = (on ? fixed : nativ).split;
      features.natives = on;
    }
    function toObject(value) {
      if (value == null) {
        throw new TypeError('Cannot convert null or undefined to object');
      }
      return value;
    }
    self = function (pattern, flags) {
      var context = {
          hasNamedCapture: false,
          captureNames: []
        }, scope = defaultScope, output = '', pos = 0, result, token, key;
      if (self.isRegExp(pattern)) {
        if (flags !== undefined) {
          throw new TypeError('Cannot supply flags when copying a RegExp');
        }
        return copy(pattern, {
          addProto: true
        });
      }
      pattern = pattern === undefined ? '' : String(pattern);
      flags = flags === undefined ? '' : String(flags);
      key = pattern + '***' + flags;
      if (!patternCache[key]) {
        result = prepareFlags(pattern, flags);
        pattern = result.pattern;
        flags = result.flags;
        while (pos < pattern.length) {
          do {
            result = runTokens(pattern, flags, pos, scope, context);
            if (result && result.reparse) {
              pattern = pattern.slice(0, pos) + result.output + pattern.slice(pos + result.matchLength);
            }
          } while (result && result.reparse);
          if (result) {
            output += result.output;
            pos += result.matchLength || 1;
          } else {
            token = self.exec(pattern, nativeTokens[scope], pos, 'sticky')[0];
            output += token;
            pos += token.length;
            if (token === '[' && scope === defaultScope) {
              scope = classScope;
            } else if (token === ']' && scope === classScope) {
              scope = defaultScope;
            }
          }
        }
        patternCache[key] = {
          pattern: nativ.replace.call(output, /\(\?:\)(?=\(\?:\))|^\(\?:\)|\(\?:\)$/g, ''),
          flags: nativ.replace.call(flags, /[^gimy]+/g, ''),
          captures: context.hasNamedCapture ? context.captureNames : null
        };
      }
      key = patternCache[key];
      return augment(new RegExp(key.pattern, key.flags), key.captures, true);
    };
    self.prototype = new RegExp();
    self.version = '3.0.0-pre';
    self.addToken = function (regex, handler, options) {
      options = options || {};
      var optionalFlags = options.optionalFlags, i;
      if (options.flag) {
        registerFlag(options.flag);
      }
      if (optionalFlags) {
        optionalFlags = nativ.split.call(optionalFlags, '');
        for (i = 0; i < optionalFlags.length; ++i) {
          registerFlag(optionalFlags[i]);
        }
      }
      tokens.push({
        regex: copy(regex, {
          add: 'g' + (hasNativeY ? 'y' : '')
        }),
        handler: handler,
        scope: options.scope || defaultScope,
        flag: options.flag,
        reparse: options.reparse
      });
      self.cache.flush('patterns');
    };
    self.cache = function (pattern, flags) {
      var key = pattern + '***' + (flags || '');
      return cache[key] || (cache[key] = self(pattern, flags));
    };
    self.cache.flush = function (cacheName) {
      if (cacheName === 'patterns') {
        patternCache = {};
      } else {
        cache = {};
      }
    };
    self.escape = function (str) {
      return nativ.replace.call(toObject(str), /[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
    };
    self.exec = function (str, regex, pos, sticky) {
      var cacheFlags = 'g', match, r2;
      if (hasNativeY && (sticky || regex.sticky && sticky !== false)) {
        cacheFlags += 'y';
      }
      regex[REGEX_DATA] = regex[REGEX_DATA] || getBaseProps();
      r2 = regex[REGEX_DATA][cacheFlags] || (regex[REGEX_DATA][cacheFlags] = copy(regex, {
        add: cacheFlags,
        remove: sticky === false ? 'y' : ''
      }));
      r2.lastIndex = pos = pos || 0;
      match = fixed.exec.call(r2, str);
      if (sticky && match && match.index !== pos) {
        match = null;
      }
      if (regex.global) {
        regex.lastIndex = match ? r2.lastIndex : 0;
      }
      return match;
    };
    self.forEach = function (str, regex, callback, context) {
      var pos = 0, i = -1, match;
      while (match = self.exec(str, regex, pos)) {
        callback.call(context, match, ++i, str, regex);
        pos = match.index + (match[0].length || 1);
      }
      return context;
    };
    self.globalize = function (regex) {
      return copy(regex, {
        add: 'g',
        addProto: true
      });
    };
    self.install = function (options) {
      options = prepareOptions(options);
      if (!features.astral && options.astral) {
        setAstral(true);
      }
      if (!features.natives && options.natives) {
        setNatives(true);
      }
    };
    self.isInstalled = function (feature) {
      return !(!features[feature]);
    };
    self.isRegExp = function (value) {
      return toString.call(value) === '[object RegExp]';
    };
    self.match = function (str, regex, scope) {
      var global = regex.global && scope !== 'one' || scope === 'all', cacheFlags = (global ? 'g' : '') + (regex.sticky ? 'y' : ''), result, r2;
      regex[REGEX_DATA] = regex[REGEX_DATA] || getBaseProps();
      r2 = regex[REGEX_DATA][cacheFlags || 'noGY'] || (regex[REGEX_DATA][cacheFlags || 'noGY'] = copy(regex, {
        add: cacheFlags,
        remove: scope === 'one' ? 'g' : ''
      }));
      result = nativ.match.call(toObject(str), r2);
      if (regex.global) {
        regex.lastIndex = scope === 'one' && result ? result.index + result[0].length : 0;
      }
      return global ? result || [] : result && result[0];
    };
    self.matchChain = function (str, chain) {
      return function recurseChain(values, level) {
        var item = chain[level].regex ? chain[level] : {
            regex: chain[level]
          }, matches = [], addMatch = function (match) {
            if (item.backref) {
              if (!(match.hasOwnProperty(item.backref) || +item.backref < match.length)) {
                throw new ReferenceError('Backreference to undefined group: ' + item.backref);
              }
              matches.push(match[item.backref] || '');
            } else {
              matches.push(match[0]);
            }
          }, i;
        for (i = 0; i < values.length; ++i) {
          self.forEach(values[i], item.regex, addMatch);
        }
        return level === chain.length - 1 || !matches.length ? matches : recurseChain(matches, level + 1);
      }([
        str
      ], 0);
    };
    self.replace = function (str, search, replacement, scope) {
      var isRegex = self.isRegExp(search), global = search.global && scope !== 'one' || scope === 'all', cacheFlags = (global ? 'g' : '') + (search.sticky ? 'y' : ''), s2 = search, result;
      if (isRegex) {
        search[REGEX_DATA] = search[REGEX_DATA] || getBaseProps();
        s2 = search[REGEX_DATA][cacheFlags || 'noGY'] || (search[REGEX_DATA][cacheFlags || 'noGY'] = copy(search, {
          add: cacheFlags,
          remove: scope === 'one' ? 'g' : ''
        }));
      } else if (global) {
        s2 = new RegExp(self.escape(String(search)), 'g');
      }
      result = fixed.replace.call(toObject(str), s2, replacement);
      if (isRegex && search.global) {
        search.lastIndex = 0;
      }
      return result;
    };
    self.replaceEach = function (str, replacements) {
      var i, r;
      for (i = 0; i < replacements.length; ++i) {
        r = replacements[i];
        str = self.replace(str, r[0], r[1], r[2]);
      }
      return str;
    };
    self.split = function (str, separator, limit) {
      return fixed.split.call(toObject(str), separator, limit);
    };
    self.test = function (str, regex, pos, sticky) {
      return !(!self.exec(str, regex, pos, sticky));
    };
    self.uninstall = function (options) {
      options = prepareOptions(options);
      if (features.astral && options.astral) {
        setAstral(false);
      }
      if (features.natives && options.natives) {
        setNatives(false);
      }
    };
    self.union = function (patterns, flags) {
      var parts = /(\()(?!\?)|\\([1-9]\d*)|\\[\s\S]|\[(?:[^\\\]]|\\[\s\S])*]/g, output = [], numCaptures = 0, numPriorCaptures, captureNames, pattern, rewrite = function (match, paren, backref) {
          var name = captureNames[numCaptures - numPriorCaptures];
          if (paren) {
            ++numCaptures;
            if (name) {
              return '(?<' + name + '>';
            }
          } else if (backref) {
            return '\\' + (+backref + numPriorCaptures);
          }
          return match;
        }, i;
      if (!(isType(patterns, 'Array') && patterns.length)) {
        throw new TypeError('Must provide a nonempty array of patterns to merge');
      }
      for (i = 0; i < patterns.length; ++i) {
        pattern = patterns[i];
        if (self.isRegExp(pattern)) {
          numPriorCaptures = numCaptures;
          captureNames = pattern[REGEX_DATA] && pattern[REGEX_DATA].captureNames || [];
          output.push(nativ.replace.call(self(pattern.source).source, parts, rewrite));
        } else {
          output.push(self.escape(pattern));
        }
      }
      return self(output.join('|'), flags);
    };
    fixed.exec = function (str) {
      var origLastIndex = this.lastIndex, match = nativ.exec.apply(this, arguments), name, r2, i;
      if (match) {
        if (!correctExecNpcg && match.length > 1 && indexOf(match, '') > -1) {
          r2 = copy(this, {
            remove: 'g'
          });
          nativ.replace.call(String(str).slice(match.index), r2, function () {
            var len = arguments.length, i;
            for (i = 1; i < len - 2; ++i) {
              if (arguments[i] === undefined) {
                match[i] = undefined;
              }
            }
          });
        }
        if (this[REGEX_DATA] && this[REGEX_DATA].captureNames) {
          for (i = 1; i < match.length; ++i) {
            name = this[REGEX_DATA].captureNames[i - 1];
            if (name) {
              match[name] = match[i];
            }
          }
        }
        if (this.global && !match[0].length && this.lastIndex > match.index) {
          this.lastIndex = match.index;
        }
      }
      if (!this.global) {
        this.lastIndex = origLastIndex;
      }
      return match;
    };
    fixed.test = function (str) {
      return !(!fixed.exec.call(this, str));
    };
    fixed.match = function (regex) {
      var result;
      if (!self.isRegExp(regex)) {
        regex = new RegExp(regex);
      } else if (regex.global) {
        result = nativ.match.apply(this, arguments);
        regex.lastIndex = 0;
        return result;
      }
      return fixed.exec.call(regex, toObject(this));
    };
    fixed.replace = function (search, replacement) {
      var isRegex = self.isRegExp(search), origLastIndex, captureNames, result;
      if (isRegex) {
        if (search[REGEX_DATA]) {
          captureNames = search[REGEX_DATA].captureNames;
        }
        origLastIndex = search.lastIndex;
      } else {
        search += '';
      }
      if (isType(replacement, 'Function')) {
        result = nativ.replace.call(String(this), search, function () {
          var args = arguments, i;
          if (captureNames) {
            args[0] = new String(args[0]);
            for (i = 0; i < captureNames.length; ++i) {
              if (captureNames[i]) {
                args[0][captureNames[i]] = args[i + 1];
              }
            }
          }
          if (isRegex && search.global) {
            search.lastIndex = args[args.length - 2] + args[0].length;
          }
          return replacement.apply(undefined, args);
        });
      } else {
        result = nativ.replace.call(this == null ? this : String(this), search, function () {
          var args = arguments;
          return nativ.replace.call(String(replacement), replacementToken, function ($0, $1, $2) {
            var n;
            if ($1) {
              n = +$1;
              if (n <= args.length - 3) {
                return args[n] || '';
              }
              n = captureNames ? indexOf(captureNames, $1) : -1;
              if (n < 0) {
                throw new SyntaxError('Backreference to undefined group ' + $0);
              }
              return args[n + 1] || '';
            }
            if ($2 === '$') {
              return '$';
            }
            if ($2 === '&' || +$2 === 0) {
              return args[0];
            }
            if ($2 === '`') {
              return args[args.length - 1].slice(0, args[args.length - 2]);
            }
            if ($2 === '\'') {
              return args[args.length - 1].slice(args[args.length - 2] + args[0].length);
            }
            $2 = +$2;
            if (!isNaN($2)) {
              if ($2 > args.length - 3) {
                throw new SyntaxError('Backreference to undefined group ' + $0);
              }
              return args[$2] || '';
            }
            throw new SyntaxError('Invalid token ' + $0);
          });
        });
      }
      if (isRegex) {
        if (search.global) {
          search.lastIndex = 0;
        } else {
          search.lastIndex = origLastIndex;
        }
      }
      return result;
    };
    fixed.split = function (separator, limit) {
      if (!self.isRegExp(separator)) {
        return nativ.split.apply(this, arguments);
      }
      var str = String(this), output = [], origLastIndex = separator.lastIndex, lastLastIndex = 0, lastLength;
      limit = (limit === undefined ? -1 : limit) >>> 0;
      self.forEach(str, separator, function (match) {
        if (match.index + match[0].length > lastLastIndex) {
          output.push(str.slice(lastLastIndex, match.index));
          if (match.length > 1 && match.index < str.length) {
            Array.prototype.push.apply(output, match.slice(1));
          }
          lastLength = match[0].length;
          lastLastIndex = match.index + lastLength;
        }
      });
      if (lastLastIndex === str.length) {
        if (!nativ.test.call(separator, '') || lastLength) {
          output.push('');
        }
      } else {
        output.push(str.slice(lastLastIndex));
      }
      separator.lastIndex = origLastIndex;
      return output.length > limit ? output.slice(0, limit) : output;
    };
    add = self.addToken;
    add(/\\([ABCE-RTUVXYZaeg-mopqyz]|c(?![A-Za-z])|u(?![\dA-Fa-f]{4})|x(?![\dA-Fa-f]{2}))/, function (match, scope) {
      if (match[1] === 'B' && scope === defaultScope) {
        return match[0];
      }
      throw new SyntaxError('Invalid escape ' + match[0]);
    }, {
      scope: 'all'
    });
    add(/\[(\^?)]/, function (match) {
      return match[1] ? '[\\s\\S]' : '\\b\\B';
    });
    add(/\(\?#[^)]*\)/, function (match, scope, flags) {
      return isQuantifierNext(match.input, match.index + match[0].length, flags) ? '' : '(?:)';
    });
    add(/\s+|#.*/, function (match, scope, flags) {
      return isQuantifierNext(match.input, match.index + match[0].length, flags) ? '' : '(?:)';
    }, {
      flag: 'x'
    });
    add(/\./, function () {
      return '[\\s\\S]';
    }, {
      flag: 's'
    });
    add(/\\k<([\w$]+)>/, function (match) {
      var index = isNaN(match[1]) ? indexOf(this.captureNames, match[1]) + 1 : +match[1], endIndex = match.index + match[0].length;
      if (!index || index > this.captureNames.length) {
        throw new SyntaxError('Backreference to undefined group ' + match[0]);
      }
      return '\\' + index + (endIndex === match.input.length || isNaN(match.input.charAt(endIndex)) ? '' : '(?:)');
    });
    add(/\\(\d+)/, function (match, scope) {
      if (!(scope === defaultScope && /^[1-9]/.test(match[1]) && +match[1] <= this.captureNames.length) && match[1] !== '0') {
        throw new SyntaxError('Cannot use octal escape or backreference to undefined group ' + match[0]);
      }
      return match[0];
    }, {
      scope: 'all'
    });
    add(/\(\?P?<([\w$]+)>/, function (match) {
      if (!isNaN(match[1])) {
        throw new SyntaxError('Cannot use integer as capture name ' + match[0]);
      }
      if (match[1] === 'length' || match[1] === '__proto__') {
        throw new SyntaxError('Cannot use reserved word as capture name ' + match[0]);
      }
      if (indexOf(this.captureNames, match[1]) > -1) {
        throw new SyntaxError('Cannot use same name for multiple groups ' + match[0]);
      }
      this.captureNames.push(match[1]);
      this.hasNamedCapture = true;
      return '(';
    });
    add(/\((?!\?)/, function (match, scope, flags) {
      if (flags.indexOf('n') > -1) {
        return '(?:';
      }
      this.captureNames.push(null);
      return '(';
    }, {
      optionalFlags: 'n'
    });
    return self;
  }();
var runtimeOptions = systemOptions.register(new OptionSet('Runtime Options'));
var traceScope = runtimeOptions.register(new Option('ts', 'traceScope', 'boolean', false, 'trace scope execution'));
var traceExecution = runtimeOptions.register(new Option('tx', 'traceExecution', 'number', 0, 'trace script execution'));
var traceCallExecution = runtimeOptions.register(new Option('txc', 'traceCallExecution', 'number', 0, 'trace call execution'));
var functionBreak = runtimeOptions.register(new Option('fb', 'functionBreak', 'number', -1, 'Inserts a debugBreak at function index #.'));
var compileOnly = runtimeOptions.register(new Option('co', 'compileOnly', 'number', -1, 'Compiles only function number.'));
var compileUntil = runtimeOptions.register(new Option('cu', 'compileUntil', 'number', -1, 'Compiles only until a function number.'));
var debuggerMode = runtimeOptions.register(new Option('dm', 'debuggerMode', 'boolean', false, 'matches avm2 debugger build semantics'));
var enableVerifier = runtimeOptions.register(new Option('verify', 'verify', 'boolean', false, 'Enable verifier.'));
var globalMultinameAnalysis = runtimeOptions.register(new Option('ga', 'globalMultinameAnalysis', 'boolean', false, 'Global multiname analysis.'));
var traceInlineCaching = runtimeOptions.register(new Option('tic', 'traceInlineCaching', 'boolean', false, 'Trace inline caching execution.'));
var compilerEnableExceptions = runtimeOptions.register(new Option('cex', 'exceptions', 'boolean', false, 'Compile functions with catch blocks.'));
var compilerMaximumMethodSize = runtimeOptions.register(new Option('cmms', 'maximumMethodSize', 'number', 4 * 1024, 'Compiler maximum method size.'));
var jsGlobal = function () {
    return this || (1, eval)('this');
  }();
var VM_SLOTS = 'vm slots';
var VM_LENGTH = 'vm length';
var VM_BINDINGS = 'vm bindings';
var VM_NATIVE_PROTOTYPE_FLAG = 'vm native prototype';
var VM_OPEN_METHODS = 'vm open methods';
var VM_IS_CLASS = 'vm is class';
var VM_OPEN_METHOD_PREFIX = 'open_';
var VM_NATIVE_BUILTINS = [
    Object,
    Number,
    Boolean,
    String,
    Array,
    Date,
    RegExp
  ];
var VM_NATIVE_BUILTIN_SURROGATES = [
    {
      object: Object,
      methods: [
        'toString',
        'valueOf'
      ]
    },
    {
      object: Function,
      methods: [
        'toString',
        'valueOf'
      ]
    }
  ];
var VM_NATIVE_BUILTIN_ORIGINALS = 'vm originals';
var SAVED_SCOPE_NAME = '$SS';
var PARAMETER_PREFIX = 'p';
var $M = [];
XRegExp.install({
  natives: true
});
var VM_METHOD_OVERRIDES = createEmptyObject();
var vmNextShapeId = 1;
function defineObjectShape(object) {
  defineReadOnlyProperty(object, 'shape', vmNextShapeId++);
}
var vmNextInterpreterFunctionId = 1;
var vmNextCompiledFunctionId = 1;
var vmNextTrampolineId = 1;
var vmNextMemoizerId = 1;
var InlineCache = function () {
    function inlineCache() {
      this.key = undefined;
      this.value = undefined;
    }
    inlineCache.prototype.update = function (key, value) {
      this.key = key;
      this.value = value;
      return value;
    };
    return inlineCache;
  }();
function ic(object) {
  return object.ic || (object.ic = new InlineCache());
}
var AS = 1, JS = 2;
var RUNTIME_ENTER_LEAVE_STACK = [
    AS
  ];
function enter(mode) {
  RUNTIME_ENTER_LEAVE_STACK.push(mode);
}
function leave(mode) {
  var top = RUNTIME_ENTER_LEAVE_STACK.pop();
  true;
}
function inJS() {
  return RUNTIME_ENTER_LEAVE_STACK.top() === JS;
}
function inAS() {
  return RUNTIME_ENTER_LEAVE_STACK.top() === AS;
}
var callWriter = new IndentingWriter(false, function (str) {
    print(str);
  });
var objectIDs = 0;
var OBJECT_NAME = 'Object Name';
function objectConstantName(object) {
  true;
  if (object.hasOwnProperty(OBJECT_NAME)) {
    return object[OBJECT_NAME];
  }
  if (object instanceof LazyInitializer) {
    return object.getName();
  }
  var name, id = objectIDs++;
  if (object instanceof Global) {
    name = '$G' + id;
  } else if (object instanceof Multiname) {
    name = '$M' + id;
  } else if (isClass(object)) {
    name = '$C' + id;
  } else {
    name = '$O' + id;
  }
  Object.defineProperty(object, OBJECT_NAME, {
    value: name,
    writable: false,
    enumerable: false
  });
  jsGlobal[name] = object;
  return name;
}
var LazyInitializer = function () {
    var holder = jsGlobal;
    lazyInitializer.create = function (target) {
      if (target.lazyInitializer) {
        return target.lazyInitializer;
      }
      return target.lazyInitializer = new LazyInitializer(target);
    };
    function lazyInitializer(target) {
      this.target = target;
    }
    lazyInitializer.prototype.getName = function getName() {
      if (this.name) {
        return this.name;
      }
      var target = this.target, initialize;
      if (this.target instanceof ScriptInfo) {
        this.name = '$S' + objectIDs++;
        initialize = function () {
          ensureScriptIsExecuted(target, 'Lazy Initializer');
          return target.global;
        };
      } else if (this.target instanceof ClassInfo) {
        this.name = Multiname.getQualifiedName(target.instanceInfo.name);
        initialize = function () {
          return target.abc.domain.getProperty(target.instanceInfo.name);
        };
      } else {
        notImplemented(target);
      }
      var name = this.name;
      Object.defineProperty(holder, name, {
        get: function () {
          var value = initialize();
          Object.defineProperty(holder, name, {
            value: value,
            writable: true
          });
          return value;
        },
        configurable: true
      });
      return name;
    };
    return lazyInitializer;
  }();
function getNamespaceResolutionMap(namespaces) {
  var map = this.resolutionMap[namespaces.id];
  if (map)
    return map;
  map = this.resolutionMap[namespaces.id] = createEmptyObject();
  var bindings = this.bindings;
  for (var key in bindings.map) {
    var multiname = key;
    var trait = bindings.map[key].trait;
    if (trait.isGetter() || trait.isSetter()) {
      multiname = multiname.substring(Binding.KEY_PREFIX_LENGTH);
    }
    var k = multiname;
    multiname = Multiname.fromQualifiedName(multiname);
    if (multiname.getNamespace().inNamespaceSet(namespaces)) {
      map[multiname.getName()] = Multiname.getQualifiedName(trait.name);
    }
  }
  return map;
}
function resolveMultinameProperty(namespaces, name, flags) {
  if (typeof name === 'object') {
    name = String(name);
  }
  if (isNumeric(name)) {
    return toNumber(name);
  }
  if (!namespaces) {
    return Multiname.getPublicQualifiedName(name);
  }
  if (namespaces.length > 1) {
    var resolved = this.getNamespaceResolutionMap(namespaces)[name];
    if (resolved)
      return resolved;
    return Multiname.getPublicQualifiedName(name);
  } else {
    return namespaces[0].qualifiedName + '$' + name;
  }
}
function asGetPublicProperty(name) {
  return this.asGetProperty(undefined, name, 0);
}
function asGetProperty(namespaces, name, flags) {
  var resolved = this.resolveMultinameProperty(namespaces, name, flags);
  if (this.asGetNumericProperty && Multiname.isNumeric(resolved)) {
    return this.asGetNumericProperty(resolved);
  }
  return this[resolved];
}
function asGetPropertyLikelyNumeric(namespaces, name, flags) {
  if (typeof name === 'number') {
    return this.asGetNumericProperty(name);
  }
  return asGetProperty.call(this, namespaces, name, flags);
}
function asGetResolvedStringProperty(resolved) {
  true;
  return this[resolved];
}
function asCallResolvedStringProperty(resolved, isLex, args) {
  var receiver = isLex ? null : this;
  var openMethods = this[VM_OPEN_METHODS];
  var method;
  if (receiver && openMethods && openMethods[resolved]) {
    method = openMethods[resolved];
  } else {
    method = this[resolved];
  }
  return method.apply(receiver, args);
}
function fromResolvedName(resolved) {
  true;
  return resolved.substring(Multiname.PUBLIC_QUALIFIED_NAME_PREFIX.length);
}
function asGetResolvedStringPropertyFallback(resolved) {
  var name = fromResolvedName(resolved);
  return this.asGetProperty([
    ShumwayNamespace.PUBLIC
  ], name, 0);
}
function asSetPublicProperty(name, value) {
  return this.asSetProperty(undefined, name, 0, value);
}
function asSetProperty(namespaces, name, flags, value) {
  if (typeof name === 'object') {
    name = String(name);
  }
  var resolved = this.resolveMultinameProperty(namespaces, name, flags);
  if (this.asSetNumericProperty && Multiname.isNumeric(resolved)) {
    return this.asSetNumericProperty(resolved, value);
  }
  this[resolved] = value;
}
function asSetPropertyLikelyNumeric(namespaces, name, flags, value) {
  if (typeof name === 'number') {
    this.asSetNumericProperty(name, value);
    return;
  }
  return asSetProperty.call(this, namespaces, name, flags, value);
}
function asDefinePublicProperty(name, descriptor) {
  return this.asDefineProperty(undefined, name, 0, descriptor);
}
function asDefineProperty(namespaces, name, flags, descriptor) {
  if (typeof name === 'object') {
    name = String(name);
  }
  var resolved = this.resolveMultinameProperty(namespaces, name, flags);
  Object.defineProperty(this, resolved, descriptor);
}
function asCallPublicProperty(name, args) {
  return this.asCallProperty(undefined, name, 0, false, args);
}
var callCounter = new metrics.Counter(true);
function asCallProperty(namespaces, name, flags, isLex, args) {
  if (traceCallExecution.value) {
    var receiver = this.class ? this.class.className + ' ' : '';
    callWriter.enter('call ' + receiver + name + '(' + toSafeArrayString(args) + ') #' + callCounter.count(name));
  }
  var receiver = isLex ? null : this;
  var result;
  if (isProxyObject(this)) {
    result = this[VM_CALL_PROXY](new Multiname(namespaces, name, flags), receiver, args);
  } else {
    var method;
    var resolved = this.resolveMultinameProperty(namespaces, name, flags);
    if (this.asGetNumericProperty && Multiname.isNumeric(resolved)) {
      method = this.asGetNumericProperty(resolved);
    } else {
      var openMethods = this[VM_OPEN_METHODS];
      if (receiver && openMethods && openMethods[resolved]) {
        method = openMethods[resolved];
      } else {
        method = this[resolved];
      }
    }
    result = method.apply(receiver, args);
  }
  traceCallExecution.value > 0 && callWriter.leave('return ' + toSafeString(result));
  return result;
}
function construct(constructor, args) {
  if (constructor.classInfo) {
    var qn = constructor.classInfo.instanceInfo.name.qualifiedName;
    if (qn === Multiname.String) {
      return String.apply(null, args);
    }
    if (qn === Multiname.Boolean) {
      return Boolean.apply(null, args);
    }
    if (qn === Multiname.Number) {
      return Number.apply(null, args);
    }
  }
  return new (Function.bind.apply(constructor.instanceConstructor, [
    ,
  ].concat(args)))();
}
function asConstructProperty(namespaces, name, flags, args) {
  var constructor = this.asGetProperty(namespaces, name, flags);
  if (traceCallExecution.value) {
    callWriter.enter('construct ' + name + '(' + toSafeArrayString(args) + ') #' + callCounter.count(name));
  }
  var result = construct(constructor, args);
  traceCallExecution.value > 0 && callWriter.leave('return ' + toSafeString(result));
  return result;
}
function asHasProperty(namespaces, name, flags, nonProxy) {
  if (this.hasProperty) {
    return this.hasProperty(namespaces, name, flags);
  }
  if (nonProxy) {
    return nonProxyingHasProperty(this, this.resolveMultinameProperty(namespaces, name, flags));
  } else {
    return this.resolveMultinameProperty(namespaces, name, flags) in this;
  }
}
function asDeleteProperty(namespaces, name, flags) {
  var resolved = this.resolveMultinameProperty(namespaces, name, flags);
  return delete this[resolved];
}
function asGetNumericProperty(i) {
  return this[i];
}
function asSetNumericProperty(i, v) {
  this[i] = v;
}
function asGetDescendants(namespaces, name, flags) {
  notImplemented('asGetDescendants');
}
function asNextNameIndex(index) {
  if (index === 0) {
    defineNonEnumerableProperty(this, 'enumerableKeys', this.asGetEnumerableKeys());
  }
  var enumerableKeys = this.enumerableKeys;
  while (index < enumerableKeys.length) {
    if (this.asHasProperty(undefined, enumerableKeys[index], 0)) {
      return index + 1;
    }
    index++;
  }
  return 0;
}
function asNextName(index) {
  var enumerableKeys = this.enumerableKeys;
  true;
  return enumerableKeys[index - 1];
}
function asNextValue(index) {
  return this.asGetPublicProperty(this.asNextName(index));
}
function asGetEnumerableKeys() {
  var boxedValue = this.valueOf();
  if (typeof boxedValue === 'string' || typeof boxedValue === 'number') {
    return [];
  }
  var keys = Object.keys(this);
  var result = [];
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (isNumeric(key)) {
      result.push(key);
    } else {
      var name = Multiname.stripPublicQualifier(key);
      if (name !== undefined) {
        result.push(name);
      }
    }
  }
  return result;
}
function initializeGlobalObject(global) {
  var originals = global[VM_NATIVE_BUILTIN_ORIGINALS] = createEmptyObject();
  VM_NATIVE_BUILTIN_SURROGATES.forEach(function (surrogate) {
    var object = surrogate.object;
    originals[object.name] = createEmptyObject();
    surrogate.methods.forEach(function (originalFunctionName) {
      var originalFunction = object.prototype[originalFunctionName];
      originals[object.name][originalFunctionName] = originalFunction;
      var overrideFunctionName = Multiname.getPublicQualifiedName(originalFunctionName);
      if (useSurrogates) {
        global[object.name].prototype[originalFunctionName] = function surrogate() {
          if (this[overrideFunctionName]) {
            return this[overrideFunctionName]();
          }
          return originalFunction.call(this);
        };
      }
    });
  });
  VM_NATIVE_BUILTINS.forEach(function (o) {
    defineReadOnlyProperty(o.prototype, VM_NATIVE_PROTOTYPE_FLAG, true);
  });
  defineNonEnumerableProperty(global.Object.prototype, 'getNamespaceResolutionMap', getNamespaceResolutionMap);
  defineNonEnumerableProperty(global.Object.prototype, 'resolveMultinameProperty', resolveMultinameProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asGetProperty', asGetProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asGetPublicProperty', asGetPublicProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asGetResolvedStringProperty', asGetResolvedStringProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asSetProperty', asSetProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asSetPublicProperty', asSetPublicProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asDefineProperty', asDefineProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asDefinePublicProperty', asDefinePublicProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asCallProperty', asCallProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asCallPublicProperty', asCallPublicProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asCallResolvedStringProperty', asCallResolvedStringProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asConstructProperty', asConstructProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asHasProperty', asHasProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asDeleteProperty', asDeleteProperty);
  defineNonEnumerableProperty(global.Object.prototype, 'asNextName', asNextName);
  defineNonEnumerableProperty(global.Object.prototype, 'asNextValue', asNextValue);
  defineNonEnumerableProperty(global.Object.prototype, 'asNextNameIndex', asNextNameIndex);
  defineNonEnumerableProperty(global.Object.prototype, 'asGetEnumerableKeys', asGetEnumerableKeys);
  [
    'Array',
    'Int8Array',
    'Uint8Array',
    'Uint8ClampedArray',
    'Int16Array',
    'Uint16Array',
    'Int32Array',
    'Uint32Array',
    'Float32Array',
    'Float64Array'
  ].forEach(function (name) {
    if (!(name in global)) {
      print(name + ' was not found in globals');
      return;
    }
    defineNonEnumerableProperty(global[name].prototype, 'asGetNumericProperty', asGetNumericProperty);
    defineNonEnumerableProperty(global[name].prototype, 'asSetNumericProperty', asSetNumericProperty);
    defineNonEnumerableProperty(global[name].prototype, 'asGetProperty', asGetPropertyLikelyNumeric);
    defineNonEnumerableProperty(global[name].prototype, 'asSetProperty', asSetPropertyLikelyNumeric);
  });
  Array.prototype.asGetProperty = function (namespaces, name, flags) {
    if (typeof name === 'number') {
      return this[name];
    }
    return asGetProperty.call(this, namespaces, name, flags);
  };
  Array.prototype.asSetProperty = function (namespaces, name, flags, value) {
    if (typeof name === 'number') {
      this[name] = value;
      return;
    }
    return asSetProperty.call(this, namespaces, name, flags, value);
  };
}
initializeGlobalObject(jsGlobal);
function isNativePrototype(object) {
  return Object.prototype.hasOwnProperty.call(object, VM_NATIVE_PROTOTYPE_FLAG);
}
function asTypeOf(x) {
  if (x) {
    if (x.constructor === String) {
      return 'string';
    } else if (x.constructor === Number) {
      return 'number';
    } else if (x.constructor === Boolean) {
      return 'boolean';
    } else if (x instanceof XML || x instanceof XMLList) {
      return 'xml';
    }
  }
  return typeof x;
}
function publicizeProperties(object) {
  var keys = Object.keys(object);
  for (var i = 0; i < keys.length; i++) {
    var k = keys[i];
    if (!Multiname.isPublicQualifiedName(k)) {
      var v = object[k];
      object[Multiname.getPublicQualifiedName(k)] = v;
      delete object[k];
    }
  }
}
function asGetSlot(object, index) {
  return object[object[VM_SLOTS][index].name];
}
function asSetSlot(object, index, value) {
  var binding = object[VM_SLOTS][index];
  if (binding.const) {
    return;
  }
  var name = binding.name;
  var type = binding.type;
  if (type && type.coerce) {
    object[name] = type.coerce(value);
  } else {
    object[name] = value;
  }
}
function asHasNext2(object, index) {
  if (isNullOrUndefined(object)) {
    return {
      index: 0,
      object: null
    };
  }
  object = boxValue(object);
  var nextIndex = object.asNextNameIndex(index);
  if (nextIndex > 0) {
    return {
      index: nextIndex,
      object: object
    };
  }
  while (true) {
    var object = Object.getPrototypeOf(object);
    if (!object) {
      return {
        index: 0,
        object: null
      };
    }
    nextIndex = object.asNextNameIndex(0);
    if (nextIndex > 0) {
      return {
        index: nextIndex,
        object: object
      };
    }
  }
  return {
    index: 0,
    object: null
  };
}
function getDescendants(object, mn) {
  if (!isXMLType(object)) {
    throw 'Not XML object in getDescendants';
  }
  return object.descendants(mn);
}
function checkFilter(value) {
  if (!value.class || !isXMLType(value)) {
    throw 'TypeError operand of childFilter not of XML type';
  }
  return value;
}
function Activation(methodInfo) {
  this.methodInfo = methodInfo;
}
var ScopeStack = function () {
    function scopeStack(parent) {
      this.parent = parent;
      this.stack = [];
      this.isWith = [];
    }
    scopeStack.prototype.push = function push(object, isWith) {
      this.stack.push(object);
      this.isWith.push(!(!isWith));
    };
    scopeStack.prototype.get = function get(index) {
      return this.stack[index];
    };
    scopeStack.prototype.clear = function clear() {
      this.stack.length = 0;
      this.isWith.length = 0;
    };
    scopeStack.prototype.pop = function pop() {
      this.isWith.pop();
      this.stack.pop();
    };
    scopeStack.prototype.topScope = function topScope() {
      if (!this.scopes) {
        this.scopes = [];
      }
      var parent = this.parent;
      for (var i = 0; i < this.stack.length; i++) {
        var object = this.stack[i], isWith = this.isWith[i], scope = this.scopes[i];
        if (!scope || scope.parent !== parent || scope.object !== object || scope.isWith !== isWith) {
          scope = this.scopes[i] = new Scope(parent, object, isWith);
        }
        parent = scope;
      }
      return parent;
    };
    return scopeStack;
  }();
var Scope = function () {
    function scope(parent, object, isWith) {
      true;
      this.parent = parent;
      this.object = object;
      this.global = parent ? parent.global : this;
      this.isWith = isWith;
      this.cache = createEmptyObject();
    }
    scope.prototype.findDepth = function findDepth(object) {
      var current = this;
      var depth = 0;
      while (current) {
        if (current.object === object) {
          return depth;
        }
        depth++;
        current = current.parent;
      }
      return -1;
    };
    function makeCacheKey(namespaces, name, flags) {
      if (!namespaces) {
        return name;
      } else if (namespaces.length > 1) {
        return namespaces.id + '$' + name;
      } else {
        return namespaces[0].qualifiedName + '$' + name;
      }
    }
    scope.prototype.findScopeProperty = function findScopeProperty(namespaces, name, flags, domain, strict, scopeOnly) {
      var object;
      var key = makeCacheKey(namespaces, name, flags);
      if (!scopeOnly && (object = this.cache[key])) {
        return object;
      }
      if (this.object.asHasProperty(namespaces, name, flags, true)) {
        return this.isWith ? this.object : this.cache[key] = this.object;
      }
      if (this.parent) {
        return this.cache[key] = this.parent.findScopeProperty(namespaces, name, flags, domain, strict, scopeOnly);
      }
      if (scopeOnly)
        return null;
      if (object = domain.findDomainProperty(new Multiname(namespaces, name, flags), strict, true)) {
        return object;
      }
      if (strict) {
        unexpected('Cannot find property ' + name);
      }
      return this.global.object;
    };
    scope.prototype.trace = function () {
      var current = this;
      while (current) {
        print(current.object + (current.object ? ' - ' + current.object.debugName : ''));
        current = current.parent;
      }
    };
    return scope;
  }();
function bindFreeMethodScope(methodInfo, scope) {
  var fn = methodInfo.freeMethod;
  if (methodInfo.lastBoundMethod && methodInfo.lastBoundMethod.scope === scope) {
    return methodInfo.lastBoundMethod.boundMethod;
  }
  true;
  var boundMethod;
  var asGlobal = scope.global.object;
  if (!methodInfo.hasOptional() && !methodInfo.needsArguments() && !methodInfo.needsRest()) {
    switch (methodInfo.parameters.length) {
    case 0:
      boundMethod = function () {
        return fn.call(this === jsGlobal ? asGlobal : this, scope);
      };
      break;
    case 1:
      boundMethod = function (x) {
        return fn.call(this === jsGlobal ? asGlobal : this, scope, x);
      };
      break;
    case 2:
      boundMethod = function (x, y) {
        return fn.call(this === jsGlobal ? asGlobal : this, scope, x, y);
      };
      break;
    case 3:
      boundMethod = function (x, y, z) {
        return fn.call(this === jsGlobal ? asGlobal : this, scope, x, y, z);
      };
      break;
    default:
      break;
    }
  }
  if (!boundMethod) {
    Counter.count('Bind Scope - Slow Path');
    boundMethod = function () {
      Array.prototype.unshift.call(arguments, scope);
      var global = this === jsGlobal ? scope.global.object : this;
      return fn.apply(global, arguments);
    };
  }
  boundMethod.methodInfo = methodInfo;
  boundMethod.instanceConstructor = boundMethod;
  methodInfo.lastBoundMethod = {
    scope: scope,
    boundMethod: boundMethod
  };
  return boundMethod;
}
function nameInTraits(object, qn) {
  if (object.hasOwnProperty(VM_BINDINGS) && object.hasOwnProperty(qn)) {
    return true;
  }
  var proto = Object.getPrototypeOf(object);
  return proto.hasOwnProperty(VM_BINDINGS) && proto.hasOwnProperty(qn);
}
function resolveMultinameUnguarded(object, mn, traitsOnly) {
  true;
  true;
  object = boxValue(object);
  var publicQn;
  var isNative = isNativePrototype(object);
  for (var i = 0, j = mn.namespaces.length; i < j; i++) {
    var qn = mn.getQName(i);
    if (traitsOnly) {
      if (nameInTraits(object, Multiname.getQualifiedName(qn))) {
        return qn;
      }
      continue;
    }
    if (mn.namespaces[i].isDynamic()) {
      publicQn = qn;
      if (isNative) {
        break;
      }
    } else if (!isNative) {
      if (Multiname.getQualifiedName(qn) in object) {
        return qn;
      }
    }
  }
  if (publicQn && !traitsOnly && Multiname.getQualifiedName(publicQn) in object) {
    return publicQn;
  }
  return undefined;
}
function resolveMultiname(object, mn, traitsOnly) {
  enter(JS);
  var result = resolveMultinameUnguarded(object, mn, traitsOnly);
  leave(JS);
  return result;
}
function sliceArguments(args, offset) {
  return Array.prototype.slice.call(args, offset);
}
function hasProperty(object, name) {
  object = boxValue(object);
  if (object.hasProperty) {
    return object.hasProperty(name);
  }
  return resolveName(object, name) in object;
}
function nonProxyingHasProperty(object, name) {
  return name in object;
}
function getSuper(scope, object, mn) {
  true;
  true;
  true;
  var superClass = scope.object.baseClass;
  true;
  var superTraitsPrototype = superClass.instanceConstructor.prototype;
  var resolved = mn.isQName() ? mn : resolveMultiname(superTraitsPrototype, mn);
  var value = undefined;
  if (resolved) {
    if (Multiname.isNumeric(resolved) && superTraitsPrototype.asGetNumericProperty) {
      value = superTraitsPrototype.asGetNumericProperty(Multiname.getQualifiedName(resolved), value);
    } else {
      var qn = Multiname.getQualifiedName(resolved);
      var openMethod = superTraitsPrototype[VM_OPEN_METHODS][qn];
      var superName = superClass.classInfo.instanceInfo.name;
      if (openMethod) {
        value = object[superName + ' ' + qn];
        if (!value) {
          value = object[superName + ' ' + qn] = bindSafely(openMethod, object);
        }
      } else {
        var descriptor = Object.getOwnPropertyDescriptor(superTraitsPrototype, qn);
        true;
        value = descriptor.get ? descriptor.get.call(object) : object[qn];
      }
    }
  }
  return value;
}
function resolveName(object, name) {
  if (name instanceof Multiname) {
    if (name.namespaces.length > 1) {
      var resolved = resolveMultiname(object, name);
      if (resolved !== undefined) {
        return Multiname.getQualifiedName(resolved);
      } else {
        return Multiname.getPublicQualifiedName(name.name);
      }
    } else {
      return Multiname.getQualifiedName(name);
    }
  } else if (typeof name === 'object') {
    return Multiname.getPublicQualifiedName(String(name));
  } else {
    return name;
  }
}
function setSuper(scope, object, mn, value) {
  true;
  true;
  var superClass = scope.object.baseClass;
  true;
  var superTraitsPrototype = superClass.instanceConstructor.prototype;
  var resolved = Multiname.isQName(mn) ? mn : resolveMultiname(superTraitsPrototype, mn);
  if (resolved !== undefined) {
    if (Multiname.isNumeric(resolved) && superTraitsPrototype.asSetNumericProperty) {
      superTraitsPrototype.asSetNumericProperty(Multiname.getQualifiedName(resolved), value);
    } else {
      var qn = Multiname.getQualifiedName(resolved);
      var descriptor = Object.getOwnPropertyDescriptor(superTraitsPrototype, qn);
      true;
      if (descriptor.set) {
        descriptor.set.call(object, value);
      } else {
        object[qn] = value;
      }
    }
  } else {
    throw new ReferenceError('Cannot create property ' + mn.name + ' on ' + superClass.debugName);
  }
}
function forEachPublicProperty(object, fn, self) {
  if (!object[VM_BINDINGS]) {
    for (var key in object) {
      fn.call(self, key, object[key]);
    }
    return;
  }
  for (var key in object) {
    if (isNumeric(key)) {
      fn.call(self, key, object[key]);
    } else if (Multiname.isPublicQualifiedName(key) && object[VM_BINDINGS].indexOf(key) < 0) {
      var name = key.substr(Multiname.PUBLIC_QUALIFIED_NAME_PREFIX.length);
      fn.call(self, name, object[key]);
    }
  }
}
function wrapJSObject(object) {
  var wrapper = Object.create(object);
  for (var i in object) {
    Object.defineProperty(wrapper, Multiname.getPublicQualifiedName(i), function (object, i) {
      return {
        get: function () {
          return object[i];
        },
        set: function (value) {
          object[i] = value;
        },
        enumerable: true
      };
    }(object, i));
  }
  return wrapper;
}
function createActivation(methodInfo) {
  return Object.create(methodInfo.activationPrototype);
}
function isClass(object) {
  true;
  return Object.hasOwnProperty.call(object, VM_IS_CLASS);
}
function isTrampoline(fn) {
  true;
  return fn.isTrampoline;
}
function isMemoizer(fn) {
  true;
  return fn.isMemoizer;
}
function CatchScopeObject(domain, trait) {
  if (trait) {
    new CatchBindings(new Scope(null, this), trait).applyTo(domain, this);
  }
}
var Global = function () {
    function Global(script) {
      this.scriptInfo = script;
      script.global = this;
      script.scriptBindings = new ScriptBindings(script, new Scope(null, this));
      script.scriptBindings.applyTo(script.abc.domain, this);
      script.loaded = true;
    }
    Global.prototype.toString = function () {
      return '[object global]';
    };
    Global.prototype.isExecuted = function () {
      return this.scriptInfo.executed;
    };
    Global.prototype.isExecuting = function () {
      return this.scriptInfo.executing;
    };
    Global.prototype.ensureExecuted = function () {
      ensureScriptIsExecuted(this.scriptInfo);
    };
    defineNonEnumerableProperty(Global.prototype, Multiname.getPublicQualifiedName('toString'), function () {
      return this.toString();
    });
    return Global;
  }();
function canCompile(mi) {
  if (!mi.hasBody) {
    return false;
  }
  if (mi.hasExceptions() && !compilerEnableExceptions.value) {
    return false;
  } else if (mi.code.length > compilerMaximumMethodSize.value) {
    return false;
  }
  return true;
}
function shouldCompile(mi) {
  if (!canCompile(mi)) {
    return false;
  }
  if (mi.isClassInitializer || mi.isScriptInitializer) {
    return false;
  }
  return true;
}
function forceCompile(mi) {
  if (mi.hasExceptions()) {
    return false;
  }
  var holder = mi.holder;
  if (holder instanceof ClassInfo) {
    holder = holder.instanceInfo;
  }
  if (holder instanceof InstanceInfo) {
    var packageName = holder.name.namespaces[0].originalURI;
    switch (packageName) {
    case 'flash.geom':
    case 'flash.events':
      return true;
    default:
      break;
    }
    var className = holder.name.getOriginalName();
    switch (className) {
    case 'com.google.youtube.model.VideoData':
      return true;
    }
  }
  return false;
}
function createInterpretedFunction(methodInfo, scope, hasDynamicScope) {
  var mi = methodInfo;
  var hasDefaults = false;
  var defaults = mi.parameters.map(function (p) {
      if (p.value !== undefined) {
        hasDefaults = true;
      }
      return p.value;
    });
  var fn;
  if (hasDynamicScope) {
    fn = function (scope) {
      var global = this === jsGlobal ? scope.global.object : this;
      var args = sliceArguments(arguments, 1);
      if (hasDefaults && args.length < defaults.length) {
        args = args.concat(defaults.slice(args.length - defaults.length));
      }
      return Interpreter.interpretMethod(global, methodInfo, scope, args);
    };
  } else {
    fn = function () {
      var global = this === jsGlobal ? scope.global.object : this;
      var args = sliceArguments(arguments);
      if (hasDefaults && args.length < defaults.length) {
        args = args.concat(defaults.slice(arguments.length - defaults.length));
      }
      return Interpreter.interpretMethod(global, methodInfo, scope, args);
    };
  }
  fn.instanceConstructor = fn;
  fn.debugName = 'Interpreter Function #' + vmNextInterpreterFunctionId++;
  return fn;
}
var totalFunctionCount = 0;
var compiledFunctionCount = 0;
function debugName(value) {
  if (isFunction(value)) {
    return value.debugName;
  }
  return value;
}
function createCompiledFunctionTrampoline(methodInfo, scope, hasDynamicScope, breakpoint) {
  var mi = methodInfo;
  return function trampolineContext() {
    var fn;
    return function () {
      if (!fn) {
        fn = mi.freeMethod = createCompiledFunction(mi, scope, hasDynamicScope, breakpoint);
        mi.freeMethod.methodInfo = mi;
      }
      return fn.apply(this, arguments);
    };
  }();
}
function createCompiledFunction(methodInfo, scope, hasDynamicScope, breakpoint, deferCompilation) {
  var mi = methodInfo;
  if (false && deferCompilation) {
    return createCompiledFunctionTrampoline(methodInfo, scope, hasDynamicScope, breakpoint);
  }
  $M.push(mi);
  var result = Compiler.compileMethod(mi, scope, hasDynamicScope);
  var parameters = result.parameters;
  var body = result.body;
  var fnName = mi.name ? Multiname.getQualifiedName(mi.name) : 'fn' + compiledFunctionCount;
  if (mi.holder) {
    var fnNamePrefix = '';
    if (mi.holder instanceof ClassInfo) {
      fnNamePrefix = 'static$' + mi.holder.instanceInfo.name.getName();
    } else if (mi.holder instanceof InstanceInfo) {
      fnNamePrefix = mi.holder.name.getName();
    } else if (mi.holder instanceof ScriptInfo) {
      fnNamePrefix = 'script';
    }
    fnName = fnNamePrefix + '$' + fnName;
  }
  fnName = escapeString(fnName);
  if (mi.verified) {
    fnName += '$V';
  }
  if (compiledFunctionCount == functionBreak.value || breakpoint) {
    body = '{ debugger; \n' + body + '}';
  }
  var fnSource = 'function ' + fnName + ' (' + parameters.join(', ') + ') ' + body;
  if (traceLevel.value > 1) {
    mi.trace(new IndentingWriter(), mi.abc);
  }
  mi.debugTrace = function (abc) {
    return function () {
      mi.trace(new IndentingWriter(), abc);
    };
  }(this.abc);
  if (traceLevel.value > 0) {
    print(fnSource);
  }
  var fn = new Function('return ' + fnSource)();
  fn.debugName = 'Compiled Function #' + vmNextCompiledFunctionId++;
  return fn;
}
function checkMethodOverrides(methodInfo) {
  if (methodInfo.name) {
    var key;
    if (methodInfo.holder instanceof ClassInfo) {
      key = 'static ' + methodInfo.holder.instanceInfo.name.getOriginalName() + '::' + methodInfo.name.getOriginalName();
    } else if (methodInfo.holder instanceof InstanceInfo) {
      key = methodInfo.holder.name.getOriginalName() + '::' + methodInfo.name.getOriginalName();
    } else {
      key = methodInfo.name.getOriginalName();
    }
    if (key in VM_METHOD_OVERRIDES) {
      warning('Overriding Method: ' + key);
      return VM_METHOD_OVERRIDES[key];
    }
  }
}
function makeTrampoline(forward, parameterLength, description) {
  true;
  return function trampolineContext() {
    var target = null;
    var trampoline = function execute() {
      if (traceExecution.value >= 3) {
        print('Trampolining');
      }
      Counter.count('Executing Trampoline');
      traceCallExecution.value > 1 && callWriter.writeLn('Trampoline: ' + description);
      if (!target) {
        target = forward(trampoline);
        true;
      }
      return target.apply(this, arguments);
    };
    trampoline.trigger = function trigger() {
      Counter.count('Triggering Trampoline');
      if (!target) {
        target = forward(trampoline);
        true;
      }
    };
    trampoline.isTrampoline = true;
    trampoline.debugName = 'Trampoline #' + vmNextTrampolineId++;
    defineReadOnlyProperty(trampoline, VM_LENGTH, parameterLength);
    return trampoline;
  }();
}
function makeMemoizer(qn, target) {
  function memoizer() {
    Counter.count('Runtime: Memoizing');
    if (traceExecution.value >= 3) {
      print('Memoizing: ' + qn);
    }
    traceCallExecution.value > 1 && callWriter.writeLn('Memoizing: ' + qn);
    if (isNativePrototype(this)) {
      Counter.count('Runtime: Method Closures');
      return bindSafely(target.value, this);
    }
    if (isTrampoline(target.value)) {
      target.value.trigger();
    }
    true;
    var mc = null;
    if (isClass(this)) {
      Counter.count('Runtime: Static Method Closures');
      mc = bindSafely(target.value, this);
      defineReadOnlyProperty(this, qn, mc);
      return mc;
    }
    if (Object.prototype.hasOwnProperty.call(this, qn)) {
      var pd = Object.getOwnPropertyDescriptor(this, qn);
      if (pd.get) {
        Counter.count('Runtime: Method Closures');
        return bindSafely(target.value, this);
      }
      Counter.count('Runtime: Unpatched Memoizer');
      return this[qn];
    }
    mc = bindSafely(target.value, this);
    mc.methodInfo = target.value.methodInfo;
    defineReadOnlyProperty(mc, Multiname.getPublicQualifiedName('prototype'), null);
    defineReadOnlyProperty(this, qn, mc);
    return mc;
  }
  Counter.count('Runtime: Memoizers');
  memoizer.isMemoizer = true;
  memoizer.debugName = 'Memoizer #' + vmNextMemoizerId++;
  return memoizer;
}
function createFunction(mi, scope, hasDynamicScope, breakpoint) {
  true;
  if (mi.freeMethod) {
    if (hasDynamicScope) {
      return bindFreeMethodScope(mi, scope);
    }
    return mi.freeMethod;
  }
  var fn;
  if (fn = checkMethodOverrides(mi)) {
    true;
    return fn;
  }
  ensureFunctionIsInitialized(mi);
  totalFunctionCount++;
  var useInterpreter = false;
  if ((mi.abc.domain.mode === EXECUTION_MODE.INTERPRET || !shouldCompile(mi)) && !forceCompile(mi)) {
    useInterpreter = true;
  }
  if (compileOnly.value >= 0) {
    if (Number(compileOnly.value) !== totalFunctionCount) {
      print('Compile Only Skipping ' + totalFunctionCount);
      useInterpreter = true;
    }
  }
  if (compileUntil.value >= 0) {
    if (totalFunctionCount > 1000) {
      print(backtrace());
      print(AVM2.getStackTrace());
    }
    if (totalFunctionCount > compileUntil.value) {
      print('Compile Until Skipping ' + totalFunctionCount);
      useInterpreter = true;
    }
  }
  if (useInterpreter) {
    mi.freeMethod = createInterpretedFunction(mi, scope, hasDynamicScope);
  } else {
    compiledFunctionCount++;
    console.info('Compiling: ' + mi + ' count: ' + compiledFunctionCount);
    if (compileOnly.value >= 0 || compileUntil.value >= 0) {
      print('Compiling ' + totalFunctionCount);
    }
    mi.freeMethod = createCompiledFunction(mi, scope, hasDynamicScope, breakpoint, mi.isInstanceInitializer);
  }
  mi.freeMethod.methodInfo = mi;
  if (hasDynamicScope) {
    return bindFreeMethodScope(mi, scope);
  }
  return mi.freeMethod;
}
function ensureFunctionIsInitialized(methodInfo) {
  var mi = methodInfo;
  if (!mi.analysis) {
    mi.analysis = new Analysis(mi);
    if (mi.needsActivation()) {
      mi.activationPrototype = new Activation(mi);
      new ActivationBindings(mi).applyTo(mi.abc.domain, mi.activationPrototype);
    }
    var exceptions = mi.exceptions;
    for (var i = 0, j = exceptions.length; i < j; i++) {
      var handler = exceptions[i];
      if (handler.varName) {
        var varTrait = Object.create(Trait.prototype);
        varTrait.kind = TRAIT_Slot;
        varTrait.name = handler.varName;
        varTrait.typeName = handler.typeName;
        varTrait.holder = mi;
        handler.scopeObject = new CatchScopeObject(mi.abc.domain, varTrait);
      } else {
        handler.scopeObject = new CatchScopeObject();
      }
    }
  }
}
function getTraitFunction(trait, scope, natives) {
  true;
  true;
  var mi = trait.methodInfo;
  var fn;
  if (mi.isNative()) {
    var md = trait.metadata;
    if (md && md.native) {
      var nativeName = md.native.value[0].value;
      var makeNativeFunction = getNative(nativeName);
      fn = makeNativeFunction && makeNativeFunction(null, scope);
    } else if (md && md.unsafeJSNative) {
      fn = getNative(md.unsafeJSNative.value[0].value);
    } else if (natives) {
      var k = Multiname.getName(mi.name);
      if (trait.isGetter()) {
        fn = natives[k] ? natives[k].get : undefined;
      } else if (trait.isSetter()) {
        fn = natives[k] ? natives[k].set : undefined;
      } else {
        fn = natives[k];
      }
    }
    if (!fn) {
      warning('No native method for: ' + trait.kindName() + ' ' + mi.holder.name + '::' + Multiname.getQualifiedName(mi.name));
      return function (mi) {
        return function () {
          warning('Calling undefined native method: ' + trait.kindName() + ' ' + mi.holder.name + '::' + Multiname.getQualifiedName(mi.name));
        };
      }(mi);
    }
  } else {
    if (traceExecution.value >= 2) {
      print('Creating Function For Trait: ' + trait.holder + ' ' + trait);
    }
    fn = createFunction(mi, scope);
    true;
  }
  if (traceExecution.value >= 3) {
    print('Made Function: ' + Multiname.getQualifiedName(mi.name));
  }
  return fn;
}
function makeQualifiedNameTraitMap(traits) {
  var map = createEmptyObject();
  for (var i = 0; i < traits.length; i++) {
    map[Multiname.getQualifiedName(traits[i].name)] = traits[i];
  }
  return map;
}
function createClass(classInfo, baseClass, scope) {
  true;
  var ci = classInfo;
  var ii = ci.instanceInfo;
  var domain = ci.abc.domain;
  var className = Multiname.getName(ii.name);
  if (traceExecution.value) {
    print('Creating ' + (ii.isInterface() ? 'Interface' : 'Class') + ': ' + className + (ci.native ? ' replaced with native ' + ci.native.cls : ''));
  }
  var cls;
  if (ii.isInterface()) {
    cls = Interface.createInterface(classInfo);
  } else {
    cls = Class.createClass(classInfo, baseClass, scope);
  }
  if (traceClasses.value) {
    domain.loadedClasses.push(cls);
    domain.traceLoadedClasses(true);
  }
  if (ii.isInterface()) {
    return cls;
  }
  domain.onMessage.notify1('classCreated', cls);
  if (cls.instanceConstructor && cls !== Class) {
    cls.verify();
  }
  if (baseClass && (Multiname.getQualifiedName(baseClass.classInfo.instanceInfo.name.name) === 'Proxy' || baseClass.isProxy)) {
    installProxyClassWrapper(cls);
    cls.isProxy = true;
  }
  createFunction(classInfo.init, scope).call(cls);
  if (sealConstTraits) {
    this.sealConstantTraits(cls, ci.traits);
  }
  return cls;
}
function sealConstantTraits(object, traits) {
  for (var i = 0, j = traits.length; i < j; i++) {
    var trait = traits[i];
    if (trait.isConst()) {
      var qn = Multiname.getQualifiedName(trait.name);
      var value = object[qn];
      (function (qn, value) {
        Object.defineProperty(object, qn, {
          configurable: false,
          enumerable: false,
          get: function () {
            return value;
          },
          set: function () {
            throwErrorFromVM(AVM2.currentDomain(), 'ReferenceError', 'Illegal write to read-only property ' + qn + '.');
          }
        });
      }(qn, value));
    }
  }
}
function applyType(domain, factory, types) {
  var factoryClassName = factory.classInfo.instanceInfo.name.name;
  if (factoryClassName === 'Vector') {
    true;
    var type = types[0];
    var typeClassName;
    if (!isNullOrUndefined(type)) {
      typeClassName = type.classInfo.instanceInfo.name.name.toLowerCase();
      switch (typeClassName) {
      case 'int':
      case 'uint':
      case 'double':
      case 'object':
        return domain.getClass('packageInternal __AS3__.vec.Vector$' + typeClassName);
      }
    }
    return domain.getClass('packageInternal __AS3__.vec.Vector$object').applyType(type);
  } else {
    return notImplemented(factoryClassName);
  }
}
function throwErrorFromVM(domain, errorClass, message, id) {
  throw new (domain.getClass(errorClass)).instanceConstructor(message, id);
}
function translateError(domain, error) {
  if (error instanceof Error) {
    var type = domain.getClass(error.name);
    if (type) {
      return new type.instanceConstructor(translateErrorMessage(error));
    }
    unexpected('Can\'t translate error: ' + error);
  }
  return error;
}
function asIsInstanceOf(type, value) {
  return type.isInstanceOf(value);
}
function asIsType(type, value) {
  return type.isInstance(value);
}
function asAsType(type, value) {
  return asIsType(type, value) ? value : null;
}
function asCoerceByMultiname(domain, multiname, value) {
  true;
  switch (Multiname.getQualifiedName(multiname)) {
  case Multiname.Int:
    return asCoerceInt(value);
  case Multiname.Uint:
    return asCoerceUint(value);
  case Multiname.String:
    return asCoerceString(value);
  case Multiname.Number:
    return asCoerceNumber(value);
  case Multiname.Boolean:
    return asCoerceBoolean(value);
  case Multiname.Object:
    return asCoerceObject(value);
  }
  return asCoerce(domain.getType(multiname), value);
}
function asCoerce(type, value) {
  if (type.coerce) {
    return type.coerce(value);
  }
  if (isNullOrUndefined(value)) {
    return null;
  }
  if (type.isInstance(value)) {
    return value;
  } else {
    true;
  }
}
function asCoerceString(x) {
  if (typeof x === 'string') {
    return x;
  } else if (x == undefined) {
    return null;
  }
  return x + '';
}
function asCoerceInt(x) {
  return x | 0;
}
function asCoerceUint(x) {
  return x >>> 0;
}
function asCoerceNumber(x) {
  return +x;
}
function asCoerceBoolean(x) {
  return !(!x);
}
function asCoerceObject(x) {
  if (x == undefined) {
    return null;
  }
  if (typeof x === 'string' || typeof x === 'number') {
    return x;
  }
  return Object(x);
}
function asDefaultCompareFunction(a, b) {
  return String(a).localeCompare(String(b));
}
function asCompare(a, b, options, compareFunction) {
  true;
  true;
  true;
  var result = 0;
  if (!compareFunction) {
    compareFunction = asDefaultCompareFunction;
  }
  if (options & SORT_NUMERIC) {
    a = toNumber(a);
    b = toNumber(b);
    result = a < b ? -1 : a > b ? 1 : 0;
  } else {
    result = compareFunction(a, b);
  }
  if (options & SORT_DESCENDING) {
    result *= -1;
  }
  return result;
}
function asAdd(l, r) {
  if (typeof l === 'string' || typeof r === 'string') {
    return String(l) + String(r);
  }
  return l + r;
}
var GlobalMultinameResolver = function () {
    var hasNonDynamicNamespaces = createEmptyObject();
    var wasResolved = createEmptyObject();
    function updateTraits(traits) {
      for (var i = 0; i < traits.length; i++) {
        var trait = traits[i];
        var name = trait.name.name;
        var namespace = trait.name.getNamespace();
        if (!namespace.isDynamic()) {
          hasNonDynamicNamespaces[name] = true;
          if (wasResolved[name]) {
            notImplemented('We have to the undo the optimization, ' + name + ' can now bind to ' + namespace);
          }
        }
      }
    }
    return {
      loadAbc: function loadAbc(abc) {
        if (!globalMultinameAnalysis.value) {
          return;
        }
        var scripts = abc.scripts;
        var classes = abc.classes;
        var methods = abc.methods;
        for (var i = 0; i < scripts.length; i++) {
          updateTraits(scripts[i].traits);
        }
        for (var i = 0; i < classes.length; i++) {
          updateTraits(classes[i].traits);
          updateTraits(classes[i].instanceInfo.traits);
        }
        for (var i = 0; i < methods.length; i++) {
          if (methods[i].traits) {
            updateTraits(methods[i].traits);
          }
        }
      },
      resolveMultiname: function resolveMultiname(multiname) {
        var name = multiname.name;
        if (hasNonDynamicNamespaces[name]) {
          return;
        }
        wasResolved[name] = true;
        return new Multiname([
          ShumwayNamespace.PUBLIC
        ], multiname.name);
      }
    };
  }();
VM_METHOD_OVERRIDES['static mochi.as3.MochiServices::connect'] = function () {
  return;
};
VM_METHOD_OVERRIDES['static MochiBot::track'] = function () {
  return;
};
VM_METHOD_OVERRIDES['com.midasplayer.debug.DebugLog::trace'] = function (msg) {
  console.log(msg);
};
VM_METHOD_OVERRIDES['com.midasplayer.engine.comm.DebugGameComm::getGameData'] = function () {
  return '<gamedata randomseed="554884453" version="1">\n<musicOn>true</musicOn>\n<soundOn>true</soundOn>\n<isShortGame>false</isShortGame>\n<booster_1>0</booster_1>\n<booster_2>0</booster_2>\n<booster_3>0</booster_3>\n<booster_4>0</booster_4>\n<booster_5>0</booster_5>\n<bestScore>0</bestScore>\n<bestChain>0</bestChain>\n<bestLevel>0</bestLevel>\n<bestCrushed>0</bestCrushed>\n<bestMixed>0</bestMixed>\n<text id="outro.crushed">Candy crushed</text>\n<text id="outro.bestever">best ever</text>\n<text id="outro.trophy.two">scored {0} in one game</text>\n<text id="outro.combo_color_color">All Clear Created</text>\n<text id="outro.trophy.one">crushed {0} candy in one game</text>\n<text id="outro.score">Score</text>\n<text id="outro.opengame">Please register to play the full game</text>\n<text id="outro.chain">Longest chain</text>\n<text id="outro.time">Game ends in {0} seconds</text>\n<text id="outro.combo_color_line">Super Stripes Created</text>\n<text id="game.nomoves">No more moves!</text>\n<text id="outro.combo_wrapper_line">Mega-Candy Created</text>\n<text id="intro.time">Game starts in {0} seconds</text>\n<text id="outro.now">now</text>\n<text id="outro.level">Level reached</text>\n<text id="outro.title">Game Over</text>\n<text id="intro.info1">Match 3 Candy of the same colour to crush them. Matching 4 or 5 in different formations generates special sweets that are extra tasty.</text>\n<text id="intro.info2">You can also combine the special sweets for additional effects by switching them with each other. Try these combinations for a taste you will not forget: </text>\n<text id="outro.combo_color_wrapper">Double Colour Bombs Created</text>\n<text id="outro.trophy.three">made {0} combined candy in one game</text>\n<text id="intro.title">Play like this:</text>\n</gamedata>';
};
var TypedArrayVector = function () {
    var EXTRA_CAPACITY = 4;
    var INITIAL_CAPACITY = 10;
    function vector(length, fixed) {
      length = length | 0;
      this.fixed = !(!fixed);
      this.buffer = new Int32Array(Math.max(INITIAL_CAPACITY, length + EXTRA_CAPACITY));
      this.offset = 0;
      this._length = length;
      this.defaultValue = 0;
    }
    vector.callable = function (object) {
      if (object instanceof vector) {
        return object;
      }
      var length = object.asGetProperty(undefined, 'length');
      if (length !== undefined) {
        var v = new vector(length, false);
        for (var i = 0; i < length; i++) {
          v.asSetNumericProperty(i, object.asGetPublicProperty(i));
        }
        return v;
      }
      unexpected();
    };
    vector.prototype.internalToString = function () {
      var str = '';
      var start = this.offset;
      var end = start + this._length;
      for (var i = 0; i < this.buffer.length; i++) {
        if (i === start) {
          str += '[';
        }
        if (i === end) {
          str += ']';
        }
        str += this.buffer[i];
        if (i < this.buffer.length - 1) {
          str += ',';
        }
      }
      if (this.offset + this._length === this.buffer.length) {
        str += ']';
      }
      return str + ': offset: ' + this.offset + ', length: ' + this._length + ', capacity: ' + this.buffer.length;
    };
    vector.prototype.toString = function () {
      var str = '';
      for (var i = 0; i < this._length; i++) {
        str += this.buffer[this.offset + i];
        if (i < this._length - 1) {
          str += ',';
        }
      }
      return str;
    };
    vector.prototype._view = function () {
      return this.buffer.subarray(this.offset, this.offset + this._length);
    };
    vector.prototype._ensureCapacity = function (length) {
      var minCapacity = this.offset + length;
      if (minCapacity < this.buffer.length) {
        return;
      }
      if (length <= this.buffer.length) {
        var offset = this.buffer.length - length >> 2;
        this.buffer.set(this._view(), offset);
        this.offset = offset;
        return;
      }
      var oldCapacity = this.buffer.length;
      var newCapacity = oldCapacity * 3 >> 2;
      if (newCapacity < minCapacity) {
        newCapacity = minCapacity;
      }
      var buffer = new Int32Array(newCapacity);
      buffer.set(this.buffer, 0);
      this.buffer = buffer;
    };
    vector.prototype.concat = function () {
      notImplemented('TypedArrayVector.concat');
    };
    vector.prototype.every = function (callback, thisObject) {
      for (var i = 0; i < this._length; i++) {
        if (!callback.call(thisObject, this.asGetNumericProperty(i), i, this)) {
          return false;
        }
      }
      return true;
    };
    vector.prototype.filter = function (callback, thisObject) {
      var v = new vector();
      for (var i = 0; i < this._length; i++) {
        if (callback.call(thisObject, this.asGetNumericProperty(i), i, this)) {
          v.push(this.asGetNumericProperty(i));
        }
      }
      return v;
    };
    vector.prototype.forEach = function (callback, thisObject) {
      for (var i = 0; i < this._length; i++) {
        callback.call(thisObject, this.asGetNumericProperty(i), i, this);
      }
    };
    vector.prototype.join = function (sep) {
      notImplemented('TypedArrayVector.join');
    };
    vector.prototype.indexOf = function (searchElement, fromIndex) {
      notImplemented('TypedArrayVector.indexOf');
    };
    vector.prototype.lastIndexOf = function (searchElement, fromIndex) {
      notImplemented('TypedArrayVector.lastIndexOf');
    };
    vector.prototype.map = function (callback, thisObject) {
      notImplemented('TypedArrayVector.map');
    };
    vector.prototype.push = function () {
      this._ensureCapacity(this._length + arguments.length);
      for (var i = 0; i < arguments.length; i++) {
        this.buffer[this.offset + this._length++] = arguments[i];
      }
    };
    vector.prototype.pop = function () {
      this._checkFixed();
      if (this._length === 0) {
        return this.defaultValue;
      }
      this._length--;
      return this.buffer[this.offset + this._length];
    };
    vector.prototype.reverse = function () {
      var l = this.offset;
      var r = this.offset + this._length - 1;
      var b = this.buffer;
      while (l < r) {
        var t = b[l];
        b[l] = b[r];
        b[r] = t;
        l++;
        r--;
      }
    };
    vector.CASEINSENSITIVE = 1;
    vector.DESCENDING = 2;
    vector.UNIQUESORT = 4;
    vector.RETURNINDEXEDARRAY = 8;
    vector.NUMERIC = 16;
    function defaultCompareFunction(a, b) {
      return String(a).localeCompare(String(b));
    }
    function compare(a, b, options, compareFunction) {
      assertNotImplemented(!(options & vector.CASEINSENSITIVE), 'CASEINSENSITIVE');
      assertNotImplemented(!(options & vector.UNIQUESORT), 'UNIQUESORT');
      assertNotImplemented(!(options & vector.RETURNINDEXEDARRAY), 'RETURNINDEXEDARRAY');
      var result = 0;
      if (!compareFunction) {
        compareFunction = defaultCompareFunction;
      }
      if (options & vector.NUMERIC) {
        a = toNumber(a);
        b = toNumber(b);
        result = a < b ? -1 : a > b ? 1 : 0;
      } else {
        result = compareFunction(a, b);
      }
      if (options & vector.DESCENDING) {
        result *= -1;
      }
      return result;
    }
    function _sort(a) {
      var stack = [];
      var sp = -1;
      var l = 0;
      var r = a.length - 1;
      var i, j, swap, temp;
      while (true) {
        if (r - l <= 100) {
          for (j = l + 1; j <= r; j++) {
            swap = a[j];
            i = j - 1;
            while (i >= l && a[i] > swap) {
              a[i + 1] = a[i--];
            }
            a[i + 1] = swap;
          }
          if (sp == -1) {
            break;
          }
          r = stack[sp--];
          l = stack[sp--];
        } else {
          var median = l + r >> 1;
          i = l + 1;
          j = r;
          swap = a[median];
          a[median] = a[i];
          a[i] = swap;
          if (a[l] > a[r]) {
            swap = a[l];
            a[l] = a[r];
            a[r] = swap;
          }
          if (a[i] > a[r]) {
            swap = a[i];
            a[i] = a[r];
            a[r] = swap;
          }
          if (a[l] > a[i]) {
            swap = a[l];
            a[l] = a[i];
            a[i] = swap;
          }
          temp = a[i];
          while (true) {
            do {
              i++;
            } while (a[i] < temp);
            do {
              j--;
            } while (a[j] > temp);
            if (j < i) {
              break;
            }
            swap = a[i];
            a[i] = a[j];
            a[j] = swap;
          }
          a[l + 1] = a[j];
          a[j] = temp;
          if (r - i + 1 >= j - l) {
            stack[++sp] = i;
            stack[++sp] = r;
            r = j - 1;
          } else {
            stack[++sp] = l;
            stack[++sp] = j - 1;
            l = i;
          }
        }
      }
      return a;
    }
    vector.prototype._sortNumeric = function (descending) {
      _sort(this._view());
      if (descending) {
        this.reverse();
      }
    };
    vector.prototype.sort = function () {
      if (arguments.length === 0) {
        return Array.prototype.sort.call(this._view());
      }
      var compareFunction, options = 0;
      if (arguments[0] instanceof Function) {
        compareFunction = arguments[0];
      } else if (isNumber(arguments[0])) {
        options = arguments[0];
      }
      if (isNumber(arguments[1])) {
        options = arguments[1];
      }
      if (options & TypedArrayVector.NUMERIC) {
        return this._sortNumeric(options & vector.DESCENDING);
      }
      Array.prototype.sort.call(this._view(), function (a, b) {
        return compare(a, b, options, compareFunction);
      });
    };
    vector.prototype.asGetNumericProperty = function (i) {
      return this.buffer[this.offset + i];
    };
    vector.prototype.asSetNumericProperty = function (i, v) {
      if (i === this._length) {
        this._ensureCapacity(this._length + 1);
        this._length++;
      }
      this.buffer[this.offset + i] = v;
    };
    vector.prototype.shift = function () {
      this._checkFixed();
      if (this._length === 0) {
        return undefined;
      }
      this._length--;
      return this.buffer[this.offset++];
    };
    vector.prototype._checkFixed = function () {
      if (this.fixed) {
        var error = Errors.VectorFixedError;
        throwErrorFromVM(AVM2.currentDomain(), 'RangeError', getErrorMessage(error.code), error.code);
      }
    };
    vector.prototype._slide = function (distance) {
      this.buffer.set(this._view(), this.offset + distance);
      this.offset += distance;
    };
    vector.prototype.unshift = function () {
      this._checkFixed();
      this._slide(arguments.length);
      this.offset -= arguments.length;
      this.length += arguments.length;
      for (var i = 0; i < arguments.length; i++) {
        this.buffer[this.offset + i] = arguments[i];
      }
    };
    vector.prototype.asGetEnumerableKeys = function () {
      if (vector.prototype === this) {
        return Object.prototype.asGetEnumerableKeys.call(this);
      }
      var keys = [];
      for (var i = 0; i < this.length; i++) {
        keys.push(i);
      }
      return keys;
    };
    vector.prototype.asHasProperty = function (namespaces, name, flags) {
      if (vector.prototype === this || !isNumeric(name)) {
        return Object.prototype.asHasProperty.call(this, namespaces, name, flags);
      }
      var index = toNumber(name);
      return index >= 0 && index < this._length;
    };
    Object.defineProperty(vector.prototype, 'length', {
      get: function () {
        return this._length;
      },
      set: function (length) {
        length = length >>> 0;
        if (length > this._length) {
          this._ensureCapacity(length);
          for (var i = this.offset + this._length, j = this.offset + length; i < j; i++) {
            this.buffer[i] = this.defaultValue;
          }
        }
        this._length = length;
      }
    });
    vector.prototype._spliceHelper = function (index, insertCount, deleteCount, args, offset) {
      insertCount = clamp(insertCount, 0, args.length - offset);
      deleteCount = clamp(deleteCount, 0, this._length - index);
      this._ensureCapacity(this._length - deleteCount + insertCount);
      var right = this.offset + index + deleteCount;
      var slice = this.buffer.subarray(right, right + this._length - index - deleteCount);
      this.buffer.set(slice, this.offset + index + insertCount);
      this._length += insertCount - deleteCount;
      for (var i = 0; i < insertCount; i++) {
        this.buffer[this.offset + index + i] = args.asGetNumericProperty(offset + i);
      }
    };
    vector.prototype.asGetEnumerableKeys = function () {
      if (vector.prototype === this) {
        return Object.prototype.asGetEnumerableKeys.call(this);
      }
      var keys = [];
      for (var i = 0; i < this._length; i++) {
        keys.push(i);
      }
      return keys;
    };
    return vector;
  }();
var typedArrayVectorTemplate = 'var EXTRA_CAPACITY=4,INITIAL_CAPACITY=10;function vector(a,b){a|=0;this.fixed=!!b;this.buffer=new Int32Array(Math.max(INITIAL_CAPACITY,a+EXTRA_CAPACITY));this.offset=0;this._length=a;this.defaultValue=0}vector.callable=function(a){if(a instanceof vector)return a;var b=a.asGetProperty(void 0,"length");if(void 0!==b){for(var c=new vector(b,!1),d=0;d<b;d++)c.asSetNumericProperty(d,a.asGetPublicProperty(d));return c}unexpected()}; vector.prototype.internalToString=function(){for(var a="",b=this.offset,c=b+this._length,d=0;d<this.buffer.length;d++)d===b&&(a+="["),d===c&&(a+="]"),a+=this.buffer[d],d<this.buffer.length-1&&(a+=",");this.offset+this._length===this.buffer.length&&(a+="]");return a+": offset: "+this.offset+", length: "+this._length+", capacity: "+this.buffer.length};vector.prototype.toString=function(){for(var a="",b=0;b<this._length;b++)a+=this.buffer[this.offset+b],b<this._length-1&&(a+=",");return a}; vector.prototype._view=function(){return this.buffer.subarray(this.offset,this.offset+this._length)};vector.prototype._ensureCapacity=function(a){var b=this.offset+a;b<this.buffer.length||(a<=this.buffer.length?(b=this.buffer.length-a>>2,this.buffer.set(this._view(),b),this.offset=b):(a=3*this.buffer.length>>2,a<b&&(a=b),b=new Int32Array(a),b.set(this.buffer,0),this.buffer=b))};vector.prototype.concat=function(){notImplemented("TypedArrayVector.concat")}; vector.prototype.every=function(a,b){for(var c=0;c<this._length;c++)if(!a.call(b,this.asGetNumericProperty(c),c,this))return!1;return!0};vector.prototype.filter=function(a,b){for(var c=new vector,d=0;d<this._length;d++)a.call(b,this.asGetNumericProperty(d),d,this)&&c.push(this.asGetNumericProperty(d));return c};vector.prototype.forEach=function(a,b){for(var c=0;c<this._length;c++)a.call(b,this.asGetNumericProperty(c),c,this)};vector.prototype.join=function(a){notImplemented("TypedArrayVector.join")}; vector.prototype.indexOf=function(a,b){notImplemented("TypedArrayVector.indexOf")};vector.prototype.lastIndexOf=function(a,b){notImplemented("TypedArrayVector.lastIndexOf")};vector.prototype.map=function(a,b){notImplemented("TypedArrayVector.map")};vector.prototype.push=function(){this._ensureCapacity(this._length+arguments.length);for(var a=0;a<arguments.length;a++)this.buffer[this.offset+this._length++]=arguments[a]}; vector.prototype.pop=function(){this._checkFixed();if(0===this._length)return this.defaultValue;this._length--;return this.buffer[this.offset+this._length]};vector.prototype.reverse=function(){for(var a=this.offset,b=this.offset+this._length-1,c=this.buffer;a<b;){var d=c[a];c[a]=c[b];c[b]=d;a++;b--}};vector.CASEINSENSITIVE=1;vector.DESCENDING=2;vector.UNIQUESORT=4;vector.RETURNINDEXEDARRAY=8;vector.NUMERIC=16;function defaultCompareFunction(a,b){return String(a).localeCompare(String(b))} function compare(a,b,c,d){assertNotImplemented(!(c&vector.CASEINSENSITIVE),"CASEINSENSITIVE");assertNotImplemented(!(c&vector.UNIQUESORT),"UNIQUESORT");assertNotImplemented(!(c&vector.RETURNINDEXEDARRAY),"RETURNINDEXEDARRAY");var f=0;d||(d=defaultCompareFunction);c&vector.NUMERIC?(a=toNumber(a),b=toNumber(b),f=a<b?-1:a>b?1:0):f=d(a,b);c&vector.DESCENDING&&(f*=-1);return f} function _sort(a){for(var b=[],c=-1,d=0,f=a.length-1,e,g,h,k;;)if(100>=f-d){for(g=d+1;g<=f;g++){h=a[g];for(e=g-1;e>=d&&a[e]>h;)a[e+1]=a[e--];a[e+1]=h}if(-1==c)break;f=b[c--];d=b[c--]}else{k=d+f>>1;e=d+1;g=f;h=a[k];a[k]=a[e];a[e]=h;a[d]>a[f]&&(h=a[d],a[d]=a[f],a[f]=h);a[e]>a[f]&&(h=a[e],a[e]=a[f],a[f]=h);a[d]>a[e]&&(h=a[d],a[d]=a[e],a[e]=h);for(k=a[e];;){do e++;while(a[e]<k);do g--;while(a[g]>k);if(g<e)break;h=a[e];a[e]=a[g];a[g]=h}a[d+1]=a[g];a[g]=k;f-e+1>=g-d?(b[++c]=e,b[++c]=f,f=g-1):(b[++c]=d, b[++c]=g-1,d=e)}return a}vector.prototype._sortNumeric=function(a){_sort(this._view());a&&this.reverse()};vector.prototype.sort=function(){if(0===arguments.length)return Array.prototype.sort.call(this._view());var a,b=0;arguments[0]instanceof Function?a=arguments[0]:isNumber(arguments[0])&&(b=arguments[0]);isNumber(arguments[1])&&(b=arguments[1]);if(b&TypedArrayVector.NUMERIC)return this._sortNumeric(b&vector.DESCENDING);Array.prototype.sort.call(this._view(),function(c,d){return compare(c,d,b,a)})}; vector.prototype.asGetNumericProperty=function(a){return this.buffer[this.offset+a]};vector.prototype.asSetNumericProperty=function(a,b){a===this._length&&(this._ensureCapacity(this._length+1),this._length++);this.buffer[this.offset+a]=b};vector.prototype.shift=function(){this._checkFixed();if(0!==this._length)return this._length--,this.buffer[this.offset++]}; vector.prototype._checkFixed=function(){if(this.fixed){var a=Errors.VectorFixedError;throwErrorFromVM(AVM2.currentDomain(),"RangeError",getErrorMessage(a.code),a.code)}};vector.prototype._slide=function(a){this.buffer.set(this._view(),this.offset+a);this.offset+=a};vector.prototype.unshift=function(){this._checkFixed();this._slide(arguments.length);this.offset-=arguments.length;this.length+=arguments.length;for(var a=0;a<arguments.length;a++)this.buffer[this.offset+a]=arguments[a]}; vector.prototype.asGetEnumerableKeys=function(){if(vector.prototype===this)return Object.prototype.asGetEnumerableKeys.call(this);for(var a=[],b=0;b<this.length;b++)a.push(b);return a};vector.prototype.asHasProperty=function(a,b,c){if(vector.prototype===this||!isNumeric(b))return Object.prototype.asHasProperty.call(this,a,b,c);a=toNumber(b);return 0<=a&&a<this._length}; Object.defineProperty(vector.prototype,"length",{get:function(){return this._length},set:function(a){a>>>=0;if(a>this._length){this._ensureCapacity(a);for(var b=this.offset+this._length,c=this.offset+a;b<c;b++)this.buffer[b]=this.defaultValue}this._length=a}}); vector.prototype._spliceHelper=function(a,b,c,d,f){b=clamp(b,0,d.length-f);c=clamp(c,0,this._length-a);this._ensureCapacity(this._length-c+b);var e=this.offset+a+c,e=this.buffer.subarray(e,e+this._length-a-c);this.buffer.set(e,this.offset+a+b);this._length+=b-c;for(c=0;c<b;c++)this.buffer[this.offset+a+c]=d.asGetNumericProperty(f+c)}; vector.prototype.asGetEnumerableKeys=function(){if(vector.prototype===this)return Object.prototype.asGetEnumerableKeys.call(this);for(var a=[],b=0;b<this._length;b++)a.push(b);return a};';
var Int32Vector = new Function(typedArrayVectorTemplate.replace(/Int32Array/g, 'Int32Array') + ' return vector;')();
var Uint32Vector = new Function(typedArrayVectorTemplate.replace(/Int32Array/g, 'Uint32Array') + ' return vector;')();
var Float64Vector = new Function(typedArrayVectorTemplate.replace(/Int32Array/g, 'Float64Array') + ' return vector;')();
var GenericVector = function () {
    function vector(length, fixed, type) {
      length = length | 0;
      this.fixed = !(!fixed);
      this.buffer = new Array(length);
      this.type = type;
      this.defaultValue = type ? type.defaultValue : null;
      this._fill(0, length, this.defaultValue);
    }
    vector.applyType = function applyType(type) {
      function parameterizedVector(length, fixed) {
        vector.call(this, length, fixed, type);
      }
      parameterizedVector.prototype = Object.create(vector.prototype);
      parameterizedVector.callable = vector.callable;
      return parameterizedVector;
    };
    vector.callable = function (object) {
      if (object instanceof vector) {
        return object;
      }
      var length = object.asGetProperty(undefined, 'length');
      if (length !== undefined) {
        var v = new vector(length, false);
        for (var i = 0; i < length; i++) {
          v.asSetNumericProperty(i, object.asGetPublicProperty(i));
        }
        return v;
      }
      unexpected();
    };
    vector.prototype._fill = function (index, length, value) {
      for (var i = 0; i < length; i++) {
        this.buffer[index + i] = value;
      }
    };
    vector.prototype.toString = function () {
      var str = '';
      for (var i = 0; i < this.buffer.length; i++) {
        str += this.buffer[i];
        if (i < this.buffer.length - 1) {
          str += ',';
        }
      }
      return str;
    };
    vector.prototype.every = function (callback, thisObject) {
      for (var i = 0; i < this.buffer.length; i++) {
        if (!callback.call(thisObject, this.asGetNumericProperty(i), i, this)) {
          return false;
        }
      }
      return true;
    };
    vector.prototype.filter = function (callback, thisObject) {
      var v = new vector();
      for (var i = 0; i < this.buffer.length; i++) {
        if (callback.call(thisObject, this.asGetNumericProperty(i), i, this)) {
          v.push(this.asGetNumericProperty(i));
        }
      }
      return v;
    };
    vector.prototype.forEach = function (callback, thisObject) {
      for (var i = 0; i < this.buffer.length; i++) {
        callback.call(thisObject, this.asGetNumericProperty(i), i, this);
      }
    };
    vector.prototype.push = function () {
      this._checkFixed();
      for (var i = 0; i < arguments.length; i++) {
        this.buffer.push(this._coerce(arguments[i]));
      }
    };
    vector.prototype.pop = function () {
      this._checkFixed();
      if (this.buffer.length === 0) {
        return undefined;
      }
      return this.buffer.pop();
    };
    vector.prototype.reverse = function () {
      this.buffer.reverse();
    };
    vector.CASEINSENSITIVE = 1;
    vector.DESCENDING = 2;
    vector.UNIQUESORT = 4;
    vector.RETURNINDEXEDARRAY = 8;
    vector.NUMERIC = 16;
    function defaultCompareFunction(a, b) {
      return String(a).localeCompare(String(b));
    }
    function compare(a, b, options, compareFunction) {
      assertNotImplemented(!(options & CASEINSENSITIVE), 'CASEINSENSITIVE');
      assertNotImplemented(!(options & UNIQUESORT), 'UNIQUESORT');
      assertNotImplemented(!(options & RETURNINDEXEDARRAY), 'RETURNINDEXEDARRAY');
      var result = 0;
      if (!compareFunction) {
        compareFunction = defaultCompareFunction;
      }
      if (options & NUMERIC) {
        a = toNumber(a);
        b = toNumber(b);
        result = a < b ? -1 : a > b ? 1 : 0;
      } else {
        result = compareFunction(a, b);
      }
      if (options & DESCENDING) {
        result *= -1;
      }
      return result;
    }
    vector.prototype.sort = function () {
      if (arguments.length === 0) {
        return this.buffer.sort();
      }
      var compareFunction, options = 0;
      if (arguments[0] instanceof Function) {
        compareFunction = arguments[0];
      } else if (isNumber(arguments[0])) {
        options = arguments[0];
      }
      if (isNumber(arguments[1])) {
        options = arguments[1];
      }
      if (options & TypedArrayVector.NUMERIC) {
        return this._sortNumeric(options & vector.DESCENDING);
      }
      Array.prototype.sort.call(this.buffer, function (a, b) {
        return compare(a, b, options, compareFunction);
      });
    };
    vector.prototype.asGetNumericProperty = function (i) {
      return this.buffer[i];
    };
    vector.prototype._coerce = function (v) {
      if (this.type) {
        return this.type.coerce(v);
      } else if (v === undefined) {
        return null;
      }
      return v;
    };
    vector.prototype.asSetNumericProperty = function (i, v) {
      this.buffer[i] = this._coerce(v);
    };
    vector.prototype.shift = function () {
      this._checkFixed();
      if (this.buffer.length === 0) {
        return undefined;
      }
      return this.buffer.shift();
    };
    vector.prototype._checkFixed = function () {
      if (this.fixed) {
        var error = Errors.VectorFixedError;
        throwErrorFromVM(AVM2.currentDomain(), 'RangeError', getErrorMessage(error.code), error.code);
      }
    };
    vector.prototype.unshift = function () {
      this._checkFixed();
      var items = [];
      for (var i = 0; i < arguments.length; i++) {
        items.push(this._coerce(arguments[i]));
      }
      this.buffer.unshift.apply(this.buffer, items);
    };
    Object.defineProperty(vector.prototype, 'length', {
      get: function () {
        return this.buffer.length;
      },
      set: function (length) {
        length = length >>> 0;
        if (length > this.buffer.length) {
          for (var i = this.buffer.length; i < length; i++) {
            this.buffer[i] = this.defaultValue;
          }
        } else {
          this.buffer.length = length;
        }
        true;
      }
    });
    vector.prototype._spliceHelper = function (index, insertCount, deleteCount, args, offset) {
      insertCount = clamp(insertCount, 0, args.length - offset);
      deleteCount = clamp(deleteCount, 0, this.buffer.length - index);
      var items = [];
      for (var i = 0; i < insertCount; i++) {
        items.push(this._coerce(args.asGetNumericProperty(offset + i)));
      }
      this.buffer.splice.apply(this.buffer, [
        index,
        deleteCount
      ].concat(items));
    };
    vector.prototype.asGetEnumerableKeys = function () {
      if (vector.prototype === this) {
        return Object.prototype.asGetEnumerableKeys.call(this);
      }
      var keys = [];
      for (var i = 0; i < this.buffer.length; i++) {
        keys.push(i);
      }
      return keys;
    };
    vector.prototype.asHasProperty = function (namespaces, name, flags) {
      if (vector.prototype === this || !isNumeric(name)) {
        return Object.prototype.asHasProperty.call(this, namespaces, name, flags);
      }
      var index = toNumber(name);
      return index >= 0 && index < this.buffer.length;
    };
    return vector;
  }();
Int32Vector.prototype.asGetProperty = function (namespaces, name, flags) {
  if (typeof name === 'number') {
    return this.asGetNumericProperty(name);
  }
  return asGetProperty.call(this, namespaces, name, flags);
};
Int32Vector.prototype.asSetProperty = function (namespaces, name, flags, value) {
  if (typeof name === 'number') {
    this.asSetNumericProperty(name, value);
    return;
  }
  return asSetProperty.call(this, namespaces, name, flags, value);
};
Uint32Vector.prototype.asGetProperty = function (namespaces, name, flags) {
  if (typeof name === 'number') {
    return this.asGetNumericProperty(name);
  }
  return asGetProperty.call(this, namespaces, name, flags);
};
Uint32Vector.prototype.asSetProperty = function (namespaces, name, flags, value) {
  if (typeof name === 'number') {
    this.asSetNumericProperty(name, value);
    return;
  }
  return asSetProperty.call(this, namespaces, name, flags, value);
};
Float64Vector.prototype.asGetProperty = function (namespaces, name, flags) {
  if (typeof name === 'number') {
    return this.asGetNumericProperty(name);
  }
  return asGetProperty.call(this, namespaces, name, flags);
};
Float64Vector.prototype.asSetProperty = function (namespaces, name, flags, value) {
  if (typeof name === 'number') {
    this.asSetNumericProperty(name, value);
    return;
  }
  return asSetProperty.call(this, namespaces, name, flags, value);
};
GenericVector.prototype.asGetProperty = function (namespaces, name, flags) {
  if (typeof name === 'number') {
    return this.asGetNumericProperty(name);
  }
  return asGetProperty.call(this, namespaces, name, flags);
};
GenericVector.prototype.asSetProperty = function (namespaces, name, flags, value) {
  if (typeof name === 'number') {
    this.asSetNumericProperty(name, value);
    return;
  }
  return asSetProperty.call(this, namespaces, name, flags, value);
};
var XMLClass, XMLListClass, QNameClass, ASXML, XML, ASXMLList, XMLList;
var isXMLType, isXMLName, XMLParser;
(function () {
  function XMLEncoder(ancestorNamespaces, indentLevel, prettyPrinting) {
    var indent = '\n  ';
    function visit(node, encode) {
      if (node.isXML) {
        switch (node.kind) {
        case 'element':
          return encode.element(node);
        case 'attribute':
          return encode.attribute(node);
        case 'text':
          return encode.text(node);
        case 'cdata':
          return encode.cdata(node);
        case 'comment':
          return encode.comment(node);
        case 'processing-instruction':
          return encode.pi(node);
        }
      } else if (node.isXMLList) {
        return encode.list(node);
      } else {
        throw 'Not implemented';
      }
    }
    function encode(node, encoder) {
      return visit(node, {
        element: function (n) {
          var s, a;
          var ns = n.name.mn.namespaces[0];
          var prefix = ns.prefix ? ns.prefix + ':' : '';
          s = '<' + prefix + n.name.localName;
          var namespaceDeclarations = [];
          if (ns.prefix || ns.originalURI) {
            namespaceDeclarations.push(ns);
          }
          if (prefix) {
            namespaceDeclarations[ns.prefix] = true;
          }
          var t = n;
          while (t) {
            for (var i = 0; i < t.inScopeNamespaces.length; i++) {
              ns = t.inScopeNamespaces[i];
              if (!namespaceDeclarations[ns.prefix]) {
                namespaceDeclarations.push(ns);
                namespaceDeclarations[ns.prefix] = true;
              }
            }
            t = t.parent;
          }
          for (var i = 0; i < namespaceDeclarations.length; i++) {
            a = namespaceDeclarations[i];
            if (a.prefix) {
              s += ' xmlns:' + a.prefix + '="' + a.originalURI + '"';
            } else {
              s += ' xmlns="' + a.originalURI + '"';
            }
          }
          for (var i = 0; i < n.attributes.length; i++) {
            a = n.attributes[i];
            var ns = n.name.uri;
            var prefix = n.prefix ? ns.prefix + ':' : '';
            var name = prefix + a.name.localName;
            s += ' ' + name + '="' + a.value + '"';
          }
          if (n.children.length) {
            s += '>';
            for (var i = 0; i < n.children.length; i++) {
              s += '\n';
              s += visit(n.children[i], this);
            }
            s += '</' + prefix + n.name.mn.name + '>';
          } else {
            s += '/>';
          }
          return s;
        },
        text: function (text) {
          return text.value.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
        },
        attribute: function (n) {
          return escapeAttributeValue(n.value);
        },
        cdata: function (n) {
        },
        comment: function (n) {
        },
        pi: function (n) {
        },
        doctype: function (n) {
        },
        list: function (n) {
          var s = '';
          for (var i = 0; i < n.children.length; i++) {
            if (i > 0) {
              s += '\n';
            }
            s += toXMLString(n.children[i], []);
          }
          return s;
        }
      });
    }
    this.encode = encode;
  }
  function escapeAttributeValue(v) {
    return v.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
  }
  XMLParser = function XMLParser() {
    function parseXml(s, sink) {
      var i = 0, scopes = [
          {
            space: 'default',
            xmlns: '',
            namespaces: {
              'xmlns': 'http://www.w3.org/2000/xmlns/',
              'xml': 'http://www.w3.org/XML/1998/namespace'
            }
          }
        ];
      function trim(s) {
        return s.replace(/^\s+/, '').replace(/\s+$/, '');
      }
      function resolveEntities(s) {
        return s.replace(/&([^;]+);/g, function (all, entity) {
          if (entity.substring(0, 2) === '#x') {
            return String.fromCharCode(parseInt(entity.substring(2), 16));
          } else if (entity.substring(0, 1) === '#') {
            return String.fromCharCode(parseInt(entity.substring(1), 10));
          }
          switch (entity) {
          case 'lt':
            return '<';
          case 'gt':
            return '>';
          case 'amp':
            return '&';
          }
          throw 'Unknown entity: ' + entity;
        });
      }
      function isWhitespacePreserved() {
        for (var j = scopes.length - 1; j >= 0; --j) {
          if (scopes[j].space === 'preserve') {
            return true;
          }
        }
        return false;
      }
      function lookupDefaultNs() {
        for (var j = scopes.length - 1; j >= 0; --j) {
          if (scopes[j].hasOwnProperty('xmlns')) {
            return scopes[j].xmlns;
          }
        }
      }
      function lookupNs(prefix) {
        for (var j = scopes.length - 1; j >= 0; --j) {
          if (scopes[j].namespaces.hasOwnProperty(prefix)) {
            return scopes[j].namespaces[prefix];
          }
        }
        throw 'Unknown namespace: ' + prefix;
      }
      function getName(name, resolveDefaultNs) {
        var j = name.indexOf(':');
        if (j >= 0) {
          var namespace = lookupNs(name.substring(0, j));
          var prefix = name.substring(0, j);
          var localName = name.substring(j + 1);
          return {
            name: namespace + '::' + localName,
            localName: localName,
            prefix: prefix,
            namespace: namespace
          };
        } else if (resolveDefaultNs) {
          return {
            name: name,
            localName: name,
            prefix: '',
            namespace: lookupDefaultNs()
          };
        } else {
          return {
            name: name,
            localName: name,
            prefix: '',
            namespace: ''
          };
        }
      }
      function isWhitespace(s, index) {
        var ch = s.charCodeAt(index);
        return ch == 10 || ch == 13 || ch == 9 || ch == 32;
      }
      function parseContent(s, start) {
        var pos = start, name, attributes = [];
        function skipWs() {
          while (pos < s.length && isWhitespace(s, pos)) {
            ++pos;
          }
        }
        while (pos < s.length && !isWhitespace(s, pos) && s.charAt(pos) !== '>' && s.charAt(pos) !== '/') {
          ++pos;
        }
        name = s.substring(start, pos);
        skipWs();
        while (pos < s.length && s.charAt(pos) !== '>' && s.charAt(pos) !== '/' && s.charAt(pos) !== '?') {
          skipWs();
          var attrName = '', attrValue = '';
          while (pos < s.length && !isWhitespace(s, pos) && s.charAt(pos) !== '=') {
            attrName += s.charAt(pos);
            ++pos;
          }
          skipWs();
          if (s.charAt(pos) !== '=')
            throw '\'=\' expected';
          ++pos;
          skipWs();
          var attrEndChar = s.charAt(pos);
          if (attrEndChar !== '"' && attrEndChar !== '\'')
            throw 'Quote expected';
          var attrEndIndex = s.indexOf(attrEndChar, ++pos);
          if (attrEndIndex < 0)
            throw new 'Unexpected EOF[6]'();
          attrValue = s.substring(pos, attrEndIndex);
          attributes.push({
            name: attrName,
            value: resolveEntities(attrValue)
          });
          pos = attrEndIndex + 1;
          skipWs();
        }
        return {
          name: name,
          attributes: attributes,
          parsed: pos - start
        };
      }
      while (i < s.length) {
        var ch = s.charAt(i);
        var j = i;
        if (ch === '<') {
          ++j;
          var ch2 = s.charAt(j), q, name;
          switch (ch2) {
          case '/':
            ++j;
            q = s.indexOf('>', j);
            if (q < 0) {
              throw 'Unexpected EOF[1]';
            }
            name = getName(s.substring(j, q), true);
            sink.endElement(name);
            scopes.pop();
            j = q + 1;
            break;
          case '?':
            ++j;
            var content = parseContent(s, j);
            if (s.substring(j + content.parsed, j + content.parsed + 2) != '?>') {
              throw 'Unexpected EOF[2]';
            }
            sink.pi(content.name, content.attributes);
            j += content.parsed + 2;
            break;
          case '!':
            if (s.substring(j + 1, j + 3) === '--') {
              q = s.indexOf('-->', j + 3);
              if (q < 0) {
                throw 'Unexpected EOF[3]';
              }
              sink.comment(s.substring(j + 3, q));
              j = q + 3;
            } else if (s.substring(j + 1, j + 8) === '[CDATA[') {
              q = s.indexOf(']]>', j + 8);
              if (q < 0) {
                throw 'Unexpected EOF[4]';
              }
              sink.cdata(s.substring(j + 8, q));
              j = q + 3;
            } else if (s.substring(j + 1, j + 8) === 'DOCTYPE') {
              var q2 = s.indexOf('[', j + 8), complexDoctype = false;
              q = s.indexOf('>', j + 8);
              if (q < 0) {
                throw 'Unexpected EOF[5]';
              }
              if (q2 > 0 && q > q2) {
                q = s.indexOf(']>', j + 8);
                if (q < 0) {
                  throw 'Unexpected EOF[7]';
                }
                complexDoctype = true;
              }
              var doctypeContent = s.substring(j + 8, q + (complexDoctype ? 1 : 0));
              sink.doctype(doctypeContent);
              j = q + (complexDoctype ? 2 : 1);
            } else {
              throw 'Unknown !tag';
            }
            break;
          default:
            var content = parseContent(s, j);
            var isClosed = false;
            if (s.substring(j + content.parsed, j + content.parsed + 2) === '/>') {
              isClosed = true;
            } else if (s.substring(j + content.parsed, j + content.parsed + 1) !== '>') {
              throw 'Unexpected EOF[2]';
            }
            var scope = {
                namespaces: []
              };
            for (q = 0; q < content.attributes.length; ++q) {
              if (content.attributes[q].name.substring(0, 6) === 'xmlns:') {
                var prefix = content.attributes[q].name.substring(6);
                var uri = content.attributes[q].value;
                scope.namespaces[prefix] = trim(uri);
                scope.namespaces.push({
                  uri: uri,
                  prefix: prefix
                });
                delete content.attributes[q];
              } else if (content.attributes[q].name === 'xmlns') {
                var prefix = '';
                var uri = content.attributes[q].value;
                scope.namespaces['xmlns'] = trim(uri);
                scope.namespaces.push({
                  uri: uri,
                  prefix: prefix
                });
                delete content.attributes[q];
              } else if (content.attributes[q].name.substring(0, 4) === 'xml:') {
                scope[content.attributes[q].name.substring(4)] = trim(content.attributes[q].value);
              } else if (content.attributes[q].name.substring(0, 3) === 'xml') {
                throw 'Invalid xml attribute';
              } else {
              }
            }
            scopes.push(scope);
            var attributes = [];
            for (q = 0; q < content.attributes.length; ++q) {
              if (content.attributes[q]) {
                attributes.push({
                  name: getName(content.attributes[q].name, false),
                  value: content.attributes[q].value
                });
              }
            }
            sink.beginElement(getName(content.name, true), attributes, scope, isClosed);
            j += content.parsed + (isClosed ? 2 : 1);
            if (isClosed)
              scopes.pop();
            break;
          }
        } else {
          do {
            if (++j >= s.length)
              break;
          } while (s.charAt(j) !== '<');
          var text = s.substring(i, j);
          var isWs = text.replace(/^\s+/, '').length === 0;
          if (!isWs || isWhitespacePreserved()) {
            sink.text(resolveEntities(text), isWs);
          }
        }
        i = j;
      }
    }
    this.parseFromString = function (s, mimeType) {
      var currentElement = new XML('element');
      var elementsStack = [];
      parseXml(s, {
        beginElement: function (name, attrs, scope, isEmpty) {
          var parent = currentElement;
          elementsStack.push(parent);
          currentElement = createNode('element', name.namespace, name.localName, name.prefix);
          for (var i = 0; i < attrs.length; ++i) {
            var attr = createNode('attribute', attrs[i].name.namespace, attrs[i].name.localName, attrs[i].name.prefix);
            attr.value = attrs[i].value;
            currentElement.attributes.push(attr);
          }
          var namespaces = scope.namespaces;
          for (var i = 0; i < namespaces.length; ++i) {
            var ns = ShumwayNamespace.createNamespace(namespaces[i].uri, namespaces[i].prefix);
            currentElement.inScopeNamespaces.push(ns);
          }
          parent.insert(parent.length(), currentElement);
          if (isEmpty) {
            currentElement = elementsStack.pop();
          }
        },
        endElement: function (name) {
          currentElement = elementsStack.pop();
        },
        text: function (text, isWhitespace) {
          var node = createNode('text', '', '');
          node.value = text;
          currentElement.insert(currentElement.length(), node);
        },
        cdata: function (text) {
          var node = createNode('text', '', '');
          node.value = text;
          currentElement.insert(currentElement.length(), node);
        },
        comment: function (text) {
        },
        pi: function (name, attrs) {
        },
        doctype: function (text) {
        }
      });
      return currentElement;
    };
    function createNode(kind, uri, name, prefix) {
      return new XML(kind, uri, name, prefix);
    }
  };
  var xmlParser = new XMLParser();
  isXMLType = function isXMLType(val) {
    return val.isXML || val.isXMLList;
  };
  function toString(node) {
    if (typeof node === 'object' && node !== null) {
      switch (node.kind) {
      case 'text':
      case 'attribute':
        return node.value;
      default:
        if (node.hasSimpleContent()) {
          var str = '';
          node.children.forEach(function (v, i) {
            str += toString(v);
          });
          return str;
        }
        return toXMLString(node);
      }
    } else {
      return String(node);
    }
  }
  function toXMLString(node, ancestorNamespaces, indentLevel) {
    return new XMLEncoder(ancestorNamespaces, indentLevel, true).encode(node);
  }
  function toXML(v) {
    if (v === null) {
      throw new TypeError(formatErrorMessage(Errors.ConvertNullToObjectError));
    } else if (v === undefined) {
      throw new TypeError(formatErrorMessage(Errors.ConvertUndefinedToObjectError));
    } else if (v.isXML) {
      return v;
    } else if (v.isXMLList) {
      if (v.length() === 1) {
        return v.children[0];
      }
      throw new TypeError(formatErrorMessage(Errors.XMLMarkupMustBeWellFormed));
    } else {
      var x = xmlParser.parseFromString(String(v));
      if (x.length() === 0) {
        var x = new XML('text');
        return x;
      } else if (x.length() === 1) {
        x.children[0].parent = null;
        return x.children[0];
      }
      throw 'SyntaxError in ToXML';
    }
  }
  var defaultNamespace = '';
  function toXMLList(value) {
    if (value === null) {
      throw new TypeError(formatErrorMessage(Errors.ConvertNullToObjectError));
    } else if (value === undefined) {
      throw new TypeError(formatErrorMessage(Errors.ConvertUndefinedToObjectError));
    } else if (value instanceof XML) {
      var xl = new XMLList(value.parent, value.name);
      xl.append(value);
      return xl;
    } else if (value instanceof XMLList) {
      return value;
    } else {
      var s = '<parent xmlns=\'' + defaultNamespace + '\'>' + String(value) + '</parent>';
      var x = new ASXML(s);
      var xl = new XMLList();
      for (var i = 0; i < x.length(); i++) {
        var v = x.children[i];
        v.parent = null;
        xl.append(v);
      }
      return xl;
    }
  }
  function toAttributeName(v) {
    if (v === undefined || v === null || typeof v === 'boolean' || typeof v === 'number') {
      throw 'TypeError: invalid operand to ToAttributeName()';
    } else if (isXMLType(v)) {
      v = toString(v);
    } else if (v instanceof Object && v !== null) {
      if (v instanceof QName) {
        return new QName(v.uri, v.localName, true);
      }
      v = toString(v);
    }
    if (typeof v === 'string') {
      var ns = new ASNamespace();
      var qn = new QName(ns, v, true);
    } else {
    }
    return qn;
  }
  function toXMLName(mn) {
    return new QName(mn);
  }
  function getDefaultNamespace(scope) {
    while (scope) {
      var obj = scope.object;
      if (obj.defaultNamepsace !== undefined) {
        return obj.defaultNamespace;
      }
      scope = scope.parent;
    }
    var ns = ShumwayNamespace.createNamespace('', '');
    return ns;
  }
  isXMLName = function isXMLName(v) {
    try {
      var qn = new QName(v);
    } catch (e) {
      return false;
    }
    return true;
  };
  function asGetProperty(namespaces, name, flags, isMethod) {
    var mn = isNumeric(name) ? toNumber(name) : name instanceof QName ? name.mn : new Multiname(namespaces ? namespaces : [
        ShumwayNamespace.PUBLIC
      ], name, flags);
    return this.getProperty(mn, isMethod);
  }
  function asSetProperty(namespaces, name, flags, value) {
    var mn = isNumeric(name) ? toNumber(name) : name instanceof QName ? name.mn : new Multiname(namespaces ? namespaces : [
        ShumwayNamespace.PUBLIC
      ], name, flags);
    this.setProperty(mn, value);
  }
  function asHasProperty(namespaces, name, flags) {
    var mn = isNumeric(name) ? toNumber(name) : name instanceof QName ? name.mn : new Multiname(namespaces ? namespaces : [
        ShumwayNamespace.PUBLIC
      ], name, flags);
    return this.hasProperty(mn);
  }
  function asCallProperty(namespaces, name, flags, isLex, args) {
    var receiver = isLex ? null : this;
    var property = this.asGetProperty(namespaces, name, flags, true);
    if (!property) {
      return this.toString().asCallProperty(namespaces ? namespaces : [
        ShumwayNamespace.PUBLIC
      ], name, flags, isLex, args);
    }
    return property.apply(receiver, args);
  }
  var ATTR_NAME = 1;
  var ELEM_NAME = 2;
  var ANY_NAME = 4;
  var ANY_NAMESPACE = 8;
  function nameKind(mn) {
    var flags = 0;
    if (mn.isAttribute()) {
      flags |= ATTR_NAME;
    } else {
      flags |= ELEM_NAME;
    }
    if (mn.isAnyName()) {
      flags |= ANY_NAME;
    }
    if (mn.isAnyNamespace()) {
      flags |= ANY_NAMESPACE;
    }
    return flags;
  }
  XMLClass = function XMLClass(runtime, scope, instanceConstructor, baseClass) {
    var FLAG_IGNORE_COMMENTS = 1;
    var FLAG_IGNORE_PROCESSING_INSTRUCTIONS = 2;
    var FLAG_IGNORE_WHITESPACE = 4;
    var FLAG_PRETTY_PRINTING = 8;
    ASXML = function (value) {
      if (!(this instanceof ASXML)) {
        if (value instanceof ASXML) {
          return value;
        }
        return new ASXML(value);
      }
      if (value === null || value === undefined) {
        value = '';
      }
      var x = toXML(value);
      if (isXMLType(value)) {
        x = x.deepCopy();
      }
      return x;
    };
    XML = function (kind, uri, name, prefix) {
      if (kind === undefined) {
        kind = 'text';
      }
      if (uri === undefined) {
        uri = '';
      }
      if (name === undefined) {
        name = '';
      }
      this.init(kind, uri, name, prefix);
    };
    var c = new Class('XML', ASXML, Domain.passthroughCallable(ASXML));
    c.flags = FLAG_IGNORE_COMMENTS | FLAG_IGNORE_PROCESSING_INSTRUCTIONS | FLAG_IGNORE_WHITESPACE | FLAG_PRETTY_PRINTING;
    c.prettyIndent = 2;
    c.extend(baseClass);
    var Xp = XML.prototype = ASXML.prototype;
    Xp.init = function init(kind, uri, name, prefix) {
      this.name = new QName(new Multiname([
        new ASNamespace(prefix, uri)
      ], name));
      this.kind = kind;
      this.parent = null;
      this.inScopeNamespaces = [];
      switch (kind) {
      case 'element':
        this.attributes = [];
        this.children = [];
        break;
      case 'attribute':
      case 'text':
        this.value = '';
        break;
      default:
        break;
      }
      return this;
    };
    Xp.length = function () {
      if (!this.children) {
        return 0;
      }
      return this.children.length;
    };
    Xp.canHandleProperties = true;
    Xp.deepCopy = function () {
      return new ASXML(toXMLString(this));
    };
    Xp.resolveValue = function resolveValue() {
      return this;
    };
    Xp.hasSimpleContent = function hasSimpleContent() {
      if (this.kind === 'comment' || this.kind === 'processing-instruction') {
        return false;
      }
      var result = true;
      if (this.children) {
        this.children.forEach(function (v) {
          if (v.kind === 'element') {
            result = false;
          }
        });
      }
      return result;
    };
    Xp.asGetEnumerableKeys = function asGetEnumerableKeys() {
      if (Xp === this) {
        return Object.prototype.asGetEnumerableKeys.call(this);
      }
      var keys = [];
      this.children.forEach(function (v, i) {
        keys.push(v.name);
      });
      return keys;
    };
    function setAttribute(node, name, value) {
      if (node.nodeType === Node.DOCUMENT_NODE) {
        node.childNodes[0].setAttribute(name, value);
      } else if (node.nodeType === Node.ELEMENT_NODE) {
        node.setAttribute(name, value);
      } else {
        throw 'error or unhandled case in setAttribute';
      }
    }
    Xp.setProperty = function (p, v) {
      var x, i, c, n;
      x = this;
      if (p === p >>> 0) {
        throw 'TypeError in XML.prototype.setProperty(): invalid property name ' + p;
      }
      if (x.kind === 'text' || x.kind === 'comment' || x.kind === 'processing-instruction' || x.kind === 'attribute') {
        return;
      }
      if (!v || !v.isXML && !v.isXMLList || v.kind === 'text' || v.kind === 'attribute') {
        c = toString(v);
      } else {
        c = v.deepCopy();
      }
      n = toXMLName(p);
      if (n.isAttr) {
        if (!this.attributes) {
          return;
        }
        this.attributes.forEach(function (v, i, o) {
          if (v.name === n.localName) {
            delete o[i];
          }
        });
        var a = new XML('attribute', n.uri, n.localName);
        a.value = v;
        a.parent = this;
        this.attributes.push(a);
        return;
      }
      var isValidName = isXMLName(n);
      if (!isValidName && n.localName !== '*') {
        return;
      }
      var i = undefined;
      var primitiveAssign = !isXMLType(c) && n.localName !== '*';
      for (var k = x.length() - 1; k >= 0; k--) {
        if ((n.isAny || x.children[k].kind === 'element' && x.children[k].name.localName === n.localName) && (n.uri === null || x.children[k].kind === 'element' && x.children[k].name.uri === n.uri)) {
          if (i !== undefined) {
            x.deleteByIndex(String(i));
          }
          i = k;
        }
      }
      if (i === undefined) {
        i = x.length();
        if (primitiveAssign) {
          if (n.uri === null) {
            var name = new QName(getDefaultNamespace(scope), n);
          } else {
            var name = new QName(n);
          }
          var y = new XML('element', name.uri, name.localName, name.prefix);
          y.parent = x;
          var ns = name.getNamespace();
          x.replace(String(i), y);
          y.addInScopeNamespace(ns);
        }
      }
      if (primitiveAssign) {
        x.children[i].children = [];
        var s = toString(c);
        if (s !== '') {
          x.children[i].replace('0', s);
        }
      } else {
        x.replace(String(i), c);
      }
      return;
    };
    Xp.asGetProperty = asGetProperty;
    Xp.asGetResolvedStringProperty = asGetResolvedStringPropertyFallback;
    Xp.asSetProperty = asSetProperty;
    Xp.asHasProperty = asHasProperty;
    Xp.asCallProperty = asCallProperty;
    Xp.getProperty = function (mn, isMethod) {
      if (isMethod) {
        var resolved = Multiname.isQName(mn) ? mn : resolveMultiname(this, mn);
        return this[Multiname.getQualifiedName(resolved)];
      }
      if (isNumeric(mn)) {
        if (Number(0) === 0) {
          return this;
        }
        return null;
      }
      var x = this;
      var name = toXMLName(mn);
      var xl = new XMLList(x, name);
      var flags = nameKind(name.mn);
      var anyName = flags & ANY_NAME;
      var anyNamespace = flags & ANY_NAMESPACE;
      if (flags & ATTR_NAME) {
        if (x.attributes) {
          x.attributes.forEach(function (v, i) {
            if ((anyName || v.name.localName === name.localName) && (anyNamespace || v.name.uri === name.uri)) {
              xl.append(v);
            }
          });
        }
      } else {
        x.children.forEach(function (v, i) {
          if ((anyName || v.kind === 'element' && v.name.localName === name.localName) && (anyNamespace || v.kind === 'element' && v.name.uri === name.uri)) {
            xl.append(v);
          }
        });
      }
      return xl;
    };
    Xp.hasProperty = function (mn, isMethod) {
      if (isMethod) {
        var resolved = Multiname.isQName(mn) ? mn : resolveMultiname(this, mn);
        return !(!this[Multiname.getQualifiedName(resolved)]);
      }
      if (isNumeric(mn)) {
        if (Number(0) === 0) {
          return true;
        }
        return false;
      }
      var name = toXMLName(mn);
      var flags = nameKind(name.mn);
      var anyName = flags & ANY_NAME;
      var anyNamespace = flags & ANY_NAMESPACE;
      if (flags & ATTR_NAME) {
        return this.attributes.some(function (v, i) {
          if ((anyName || v.name.localName === name.localName) && (anyNamespace || v.name.uri === name.uri)) {
            return true;
          }
        });
        if (x.attributes) {
          x.attributes.forEach(function (v, i) {
            if ((anyName || v.name.localName === name.localName) && (anyNamespace || v.name.uri === name.uri)) {
              xl.append(v);
            }
          });
        }
      } else {
        return this.children.some(function (v, i) {
          if ((anyName || v.kind === 'element' && v.name.localName === name.localName) && (anyNamespace || v.kind === 'element' && v.name.uri === name.uri)) {
            return true;
          }
        });
      }
    };
    Xp.delete = function (key, isMethod) {
      notImplemented('XML.[[Delete]]');
    };
    Xp.deleteByIndex = function (p) {
      var x = this;
      var i = p >>> 0;
      if (String(i) !== String(p)) {
        throw 'TypeError in XML.prototype.deleteByIndex(): invalid index ' + p;
      }
      if (p < x.length()) {
        if (x.children[p]) {
          x.children[p].parent = null;
          delete x.children[p];
          for (q = i + 1; q < x.length(); q++) {
            x.children[q - 1] = x.children[q];
          }
          x.children.length = x.children.length - 1;
        }
      }
    };
    Xp.isXML = true;
    Xp.insert = function insert(p, v) {
      var x, s, i, n;
      x = this;
      if (x.kind === 'text' || x.kind === 'comment' || x.kind === 'processing-instruction' || x.kind === 'attribute') {
        return;
      }
      i = p >>> 0;
      if (String(p) !== String(i)) {
        throw 'TypeError in XML.prototype.insert(): invalid property name ' + p;
      }
      if (x.kind === 'element') {
        var a = x;
        while (a) {
          if (a === v) {
            throw 'Error in XML.prototype.insert()';
          }
          a = a.parent;
        }
      }
      if (x.isXMLList) {
        n = x.length();
        if (n === 0) {
          return;
        }
      } else {
        n = 1;
      }
      for (var j = x.length() - 1; j >= i; j--) {
        x[j + n] = x[j];
      }
      if (x.isXMLList) {
        n = v.length();
        for (var j = 0; j < n; j++) {
          v.children[j].parent = x;
          x[i + j] = v[j];
        }
      } else {
        v.parent = x;
        x.children[i] = v;
      }
    };
    Xp.replace = function (p, v) {
      var x, s;
      x = this;
      if (x.kind === 'text' || x.kind === 'comment' || x.kind === 'processing-instruction' || x.kind === 'attribute') {
        return;
      }
      var i = p >>> 0;
      if (String(p) !== String(i)) {
        throw 'TypeError in XML.prototype.replace(): invalid name ' + p;
      }
      if (i >= x.length()) {
        p = String(x.length());
      }
      if (v.kind === 'element') {
        var a = x;
        while (a) {
          if (a === v) {
            throw 'Error in XML.prototype.replace()';
          }
          a = a.parent;
        }
      }
      if (v.kind === 'element' || v.kind === 'text' || v.kind === 'comment' || v.kind === 'processing-instruction') {
        v.parent = x;
        if (x[p]) {
          x.children[p].parent = null;
        }
        x.children[p] = v;
      } else if (x.isXMLList) {
        x.deleteByIndex(p);
        x.insert(p, v);
      } else {
        s = toString(v);
        t = new XML();
        t.parent = x;
        t.value = s;
        if (x[p]) {
          x.children[p].parent = null;
        }
        x.children[p] = t;
      }
    };
    Xp.addInScopeNamespace = function (ns) {
      var x, s;
      x = this;
      if (x.kind === 'text' || x.kind === 'comment' || x.kind === 'processing-instruction' || x.kind === 'attribute') {
        return;
      }
      if (ns.prefix !== undefined) {
        if (ns.prefix === '' && x.name.uri === '') {
          return;
        }
        var match = null;
        x.inScopeNamespaces.forEach(function (v, i) {
          if (v.prefix === ns.prefix) {
            match = v;
          }
        });
        if (match !== null && match.uri !== ns.uri) {
          x.inScopeNamespaces.forEach(function (v, i) {
            if (v.prefix === match.prefix) {
              x.inScopeNamespaces[i] = ns;
            }
          });
        }
        if (x.name.prefix === ns.prefix) {
          x.name.prefix = undefined;
        }
        x.attributes.forEach(function (v, i) {
          if (v.name.prefix === ns.name.prefix) {
            v.name.prefix = undefined;
          }
        });
      }
    };
    Xp.descendants = function (name) {
      name = toXMLName(name);
      var x = this;
      var xl = new XMLList();
      if (x.kind !== 'element') {
        return xl;
      }
      if (name.isAttr) {
        this.attributes.forEach(function (v, i) {
          if (name.isAny || name.localName === v.name.localName) {
            xl.append(v);
          }
        });
      } else {
        this.children.forEach(function (v, i) {
          if (name.isAny || name.localName === v.name.localName) {
            xl.append(v);
          }
        });
      }
      this.children.forEach(function (v, i) {
        xl.append(v.descendants(name));
      });
      return xl;
    };
    Xp.comments = function () {
      var x = this;
      var xl = new XMLList(x, null);
      x.children.forEach(function (v, i) {
        if (v.kind === 'comment') {
          xl.append(v);
        }
      });
      return xl;
    };
    Xp.text = function () {
      var x = this;
      var xl = new XMLList(x, null);
      x.children.forEach(function (v, i) {
        if (v.kind === 'text') {
          xl.append(v);
        }
      });
      return xl;
    };
    c.native = {
      static: {
        ignoreComments: {
          get: function ignoreComments() {
            return getBitFlags(c.flags, FLAG_IGNORE_COMMENTS);
          },
          set: function ignoreComments(newIgnore) {
            c.flags = setBitFlags(c.flags, FLAG_IGNORE_COMMENTS, newIgnore);
          }
        },
        ignoreProcessingInstructions: {
          get: function ignoreProcessingInstructions() {
            return getBitFlags(c.flags, FLAG_IGNORE_PROCESSING_INSTRUCTIONS);
          },
          set: function ignoreProcessingInstructions(newIgnore) {
            c.flags = setBitFlags(c.flags, FLAG_IGNORE_PROCESSING_INSTRUCTIONS, newIgnore);
          }
        },
        ignoreWhitespace: {
          get: function ignoreWhitespace() {
            return getBitFlags(c.flags, FLAG_IGNORE_WHITESPACE);
          },
          set: function ignoreWhitespace(newIgnore) {
            c.flags = setBitFlags(c.flags, FLAG_IGNORE_WHITESPACE, newIgnore);
          }
        },
        prettyPrinting: {
          get: function prettyPrinting() {
            return getBitFlags(c.flags, FLAG_PRETTY_PRINTING);
          },
          set: function prettyPrinting(newPretty) {
            c.flags = setBitFlags(c.flags, FLAG_PRETTY_PRINTING, newPretty);
          }
        },
        prettyIndent: {
          get: function prettyIndent() {
            return c.prettyIndent;
          },
          set: function prettyIndent(newIndent) {
            c.prettyIndent = newIndent;
          }
        }
      },
      instance: {
        toString: function () {
          return toString(this);
        },
        hasOwnProperty: function hasOwnProperty(P) {
          notImplemented('XML.hasOwnProperty');
        },
        propertyIsEnumerable: function propertyIsEnumerable(P) {
          notImplemented('XML.propertyIsEnumerable');
        },
        addNamespace: function addNamespace(ns) {
          notImplemented('XML.addNamespace');
        },
        appendChild: function appendChild(child) {
          var children = this.getProperty('*');
          children.setProperty(children.length(), child);
          return this;
        },
        attribute: function attribute(name) {
          return this.getProperty(toAttributeName(name));
        },
        attributes: function attributes() {
          return this.getProperty(toAttributeName('*'));
        },
        child: function child(name) {
          return this.getProperty(name);
        },
        childIndex: function childIndex() {
          notImplemented('XML.childIndex');
        },
        children: function children() {
          var list = new XMLList();
          Array.prototype.push.apply(list.children, this.children);
          return list;
        },
        comments: function comments() {
          return this.comments();
        },
        contains: function contains(value) {
          notImplemented('XML.contains');
        },
        copy: function copy() {
          return this.deepCopy();
        },
        descendants: function descendants(name) {
          if (name === undefined) {
            name = '*';
          }
          return this.descendants(name);
        },
        elements: function elements(name) {
          var x = this;
          var any = false;
          if (name === undefined) {
            name = '*';
            any = true;
          }
          var name = toXMLName(name);
          var xl = new XMLList(this.parent, name);
          x.children.forEach(function (v, i) {
            if (v.kind === 'element' && (any || v.name.localName === name.localName) && (name.uri === null || v.kind === 'element' && v.name.uri === name.uri)) {
              xl.append(v);
            }
          });
          return xl;
        },
        hasComplexContent: function hasComplexContent() {
          notImplemented('XML.hasComplexContent');
        },
        hasSimpleContent: function hasSimpleContent() {
          return this.hasSimpleContent();
        },
        inScopeNamespaces: function inScopeNamespaces() {
          notImplemented('XML.inScopeNamespaces');
        },
        insertChildAfter: function insertChildAfter(child1, child2) {
          notImplemented('XML.insertChildAfter');
        },
        insertChildBefore: function insertChildBefore(child1, child2) {
          notImplemented('XML.insertChildBefore');
        },
        localName: function localName() {
          notImplemented('XML.localName');
        },
        name: function name() {
          return this.name;
        },
        _namespace: function _namespace(prefix, argc) {
          somewhatImplemented('XML._namespace()');
          return this.name.uri;
        },
        namespaceDeclarations: function namespaceDeclarations() {
          return new XMLList();
        },
        nodeKind: function nodeKind() {
          return this.kind;
        },
        normalize: function normalize() {
          notImplemented('XML.normalize');
        },
        parent: function parent() {
          notImplemented('XML.parent');
        },
        processingInstructions: function processingInstructions(name) {
          notImplemented('XML.processingInstructions');
        },
        prependChild: function prependChild(value) {
          notImplemented('XML.prependChild');
        },
        removeNamespace: function removeNamespace(ns) {
          notImplemented('XML.removeNamespace');
        },
        replace: function replace(propertyName, value) {
          var c, x, s, i;
          x = this;
          if (x.kind === 'text' || x.kind === 'comment' || x.kind === 'processing-instruction' || x.kind === 'attribute') {
            return x;
          }
          if (!isXMLType(value)) {
            c = value.toString();
          } else {
            c = value.deepCopy();
          }
          var i = propertyName >>> 0;
          if (String(propertyName) === String(i)) {
            x.replace(propertyName, c);
            return x;
          }
          n = new QName(propertyName);
          i = undefined;
          for (k = x.length() - 1; k >= 0; k--) {
            var v = x.children[k];
            if (n.isAny || v.kind === 'element' && v.name.localName === n.localName && (n.uri === null || v.kind === 'element' && v.name.uri === n.uri)) {
              if (i !== undefined) {
                x.deleteByIndex(String(i));
              }
              i = k;
            }
          }
          if (i !== undefined) {
            x.replace(i.toString(), c);
          }
          return x;
        },
        setChildren: function setChildren(value) {
          notImplemented('XML.setChildren');
        },
        setLocalName: function setLocalName(name) {
          notImplemented('XML.setLocalName');
        },
        setName: function setName(name) {
          notImplemented('XML.setName');
        },
        setNamespace: function setNamespace(ns) {
          notImplemented('XML.setNamespace');
        },
        text: function text() {
          return this.text();
        },
        toXMLString: function () {
          return toXMLString(this);
        },
        notification: function notification() {
          notImplemented('XML.notification');
        },
        setNotification: function setNotification(f) {
          notImplemented('XML.setNotification');
        }
      }
    };
    return c;
  };
  XMLListClass = function XMLListClass(runtime, scope, instanceConstructor, baseClass) {
    ASXMLList = function (value) {
      if (!(this instanceof ASXMLList)) {
        return callXMLList(value);
      }
      return constructXMLList(value);
    };
    function callXMLList(v) {
      if (v === null || v === undefined) {
        v = '';
      }
      return toXMLList(v);
    }
    function constructXMLList(val) {
      if (val === null || val === undefined) {
        val = '';
      }
      if (val.isXMLList) {
        var xl = new XMLList();
        xl.append(val);
        return xl;
      }
      return toXMLList(val);
    }
    XMLList = function (targetObject, targetProperty) {
      this.targetObject = targetObject ? targetObject : null;
      this.targetProperty = targetProperty ? targetProperty : null;
      this.children = [];
    };
    var c = new Class('XMLList', ASXMLList, Domain.passthroughCallable(ASXMLList));
    c.extend(baseClass);
    var XLp = XMLList.prototype = ASXMLList.prototype;
    XLp.canHandleProperties = true;
    XLp.hasSimpleContent = function hasSimpleContent() {
      if (this.length() === 0) {
        return true;
      } else if (this.length() === 1) {
        return toXML(this).hasSimpleContent();
      }
      var result = true;
      this.children.forEach(function (v) {
        if (v.kind === 'element') {
          result = false;
        }
      });
      return result;
    };
    XLp.asGetProperty = asGetProperty;
    XLp.asGetResolvedStringProperty = asGetResolvedStringPropertyFallback;
    XLp.asSetProperty = asSetProperty;
    XLp.asHasProperty = asHasProperty;
    XLp.asCallProperty = asCallProperty;
    XLp.setProperty = function (mn, v, isMethod) {
      var x, i, r;
      x = this;
      i = mn >>> 0;
      if (String(mn) === String(i)) {
        var targetObject = this.targetObject;
        var targetProperty = this.targetProperty;
        if (targetObject !== null) {
          r = targetObject.resolveValue();
          if (r === null) {
            return;
          }
        } else {
          r = null;
        }
        if (i >= x.length()) {
          if (r && r.isXMLList) {
            if (r.length !== 1) {
              return;
            } else {
              r = r.children[0];
            }
          }
          if (r && r.kind !== 'element') {
            return;
          }
          var y = new XML();
          y.parent = r;
          y.name = x.targetProperty;
          if (targetProperty === null || targetProperty.localName === '*') {
            y.name = null;
            y.kind = 'text';
          } else if (targetProperty.isAttr) {
            var attributeExists = r.getProperty(y.name);
            if (attributeExists.length() > 0) {
              return;
            }
            r.kind = 'attribute';
          } else {
            y.kind = 'element';
          }
          i = x.length();
          if (y.kind !== 'attribute') {
            if (r !== null) {
              if (i > 0) {
                var j = 0;
                while (j < r.length() - 1 && r.children[j] !== x.children[i - 1]) {
                  j++;
                }
              } else {
                var j = r.length() - 1;
              }
              r.insert(String(j + 1), y);
            }
            if (v.isXML) {
              y.name = v.name;
            } else if (v.isXMLList) {
              y.name = v.targetProperty;
            }
          }
          x.append(y);
        }
        if (!v.isXML && !v.isXMLList || v.kind === 'text' || v.kind === 'attribute') {
          v = toString(v);
        }
        if (x.children[i].kind === 'attribute') {
          var z = toAttributeName(x.children[i].name);
          x.children[i].parent.setProperty(z, v);
          var attr = x.children[i].parent.getProperty(z);
          x.children[i] = attr.children[0];
        } else if (v.isXMLList) {
          var c = v.deepCopy();
          var parent = x.children[i].parent;
          if (parent !== null) {
            var q;
            parent.children.some(function (v, p) {
              if (v == x.children[i]) {
                q = p;
                return true;
              }
            });
            parent.replace(q, c);
            c.children.forEach(function (v, j) {
              c.children[j] = parent.children[q >>> 0 + j];
            });
          }
          if (c.length() === 0) {
            for (var j = x + 1; j < x.length() - 1; j++) {
              x.children[String(j - 1)] = x.children[j];
            }
          } else {
            for (var j = x.length() - 1; j >= i + 1; j--) {
              x.children[String(j + c.length() - 1)] = x.children[j];
            }
          }
          for (var j = 0; j < c.length(); j++) {
            x.children[i + j] = c.children[j];
          }
        } else if (v.isXML || (k = x.children[i].kind) === 'text' || k === 'comment' || k === 'processing-instruction') {
          var parent = x.children[i].parent;
          if (parent !== null) {
            var q;
            parent.children.some(function (v, p) {
              if (v == x.children[i]) {
                q = p;
                return true;
              }
            });
            parent.replace(q, v);
            var v = parent.children[q];
          }
          if (typeof v === 'string') {
            var t = new XML('text');
            t.parent = x;
            t.value = v;
            x.children[i] = t;
          } else {
            x.children[i] = v;
          }
        } else {
          x.children[i].setProperty('*', v);
        }
      } else if (x.length() <= 1) {
        if (x.length() === 0) {
          r = x.resolveValue();
          if (r === null || r.length() !== 1) {
            return;
          }
          x.append(r);
        }
        x.children[0].setProperty(mn, v);
      }
    };
    XLp.getProperty = function (mn, isMethod) {
      if (isMethod) {
        var resolved = Multiname.isQName(mn) ? mn : resolveMultiname(this, mn);
        return this[Multiname.getQualifiedName(resolved)];
      }
      var x = this;
      var i = mn >>> 0;
      if (String(mn) === String(i)) {
        return x.children[mn];
      }
      var name = toXMLName(mn);
      var xl = new XMLList(this, name);
      x.children.forEach(function (v, i) {
        var xl2;
        if (v.kind === 'element') {
          xl2 = v.getProperty(mn);
          if (xl2.length() > 0) {
            xl.append(xl2);
          }
        }
      });
      return xl;
    };
    XLp.hasProperty = function (mn, isMethod) {
      if (isMethod) {
        var resolved = Multiname.isQName(mn) ? mn : resolveMultiname(this, mn);
        return !(!this[Multiname.getQualifiedName(resolved)]);
      }
      var x = this;
      var i = mn >>> 0;
      if (String(mn) === String(i)) {
        return !(!x.children[mn]);
      }
      var name = toXMLName(mn);
      return this.children.some(function (v, i) {
        var xl2 = v.getProperty(mn);
        if (xl2.length() > 0) {
          return true;
        }
      });
    };
    XLp.delete = function (key, isMethod) {
    };
    XLp.append = function (val) {
      if (val.isXMLList) {
        this.targetObject = val.targetObject;
        this.targetProperty = val.targetProperty;
        if (val.length() === 0) {
          return;
        }
        for (var i = 0; i < val.length(); i++) {
          this.children.push(val.children[i]);
        }
      } else if (val.isXML) {
        this.children.push(val);
      }
    };
    XLp.length = function () {
      return this.children.length;
    };
    XLp.resolve = function () {
      var base = this.targetObject.resolveValue();
      if (base === null) {
        return null;
      }
      var target = this.targetObject.getProperty(this.targetProperty);
      if (base.length === 0) {
        notImplemented('XMLList.resolve');
        base.setProperty(this.targetProperty, '');
        target = base.getProperty(this.targetProperty);
        return target;
      }
    };
    XLp.deepCopy = function () {
      var xl = new XMLList();
      this.children.forEach(function (v, i) {
        xl.children[i] = v.deepCopy();
      });
      return xl;
    };
    XLp.descendants = function (name) {
      var xl = new XMLList(null);
      this.children.forEach(function (v, i) {
        if (v.kind === 'element') {
          xl.append(v.descendants(name));
        }
      });
      return xl;
    };
    XLp.resolveValue = function resolveValue() {
      if (this.length() > 0) {
        return this;
      }
      var x = this;
      var name = x.name;
      var targetObject = x.targetObject;
      var targetProperty = x.targetProperty;
      if (targetObject === null || targetProperty === null || name.isAttr || name.isAny) {
        return null;
      }
      var base = targetObject.resolveValue();
      if (base === null) {
        return null;
      }
      var target = base.getProperty(targetProperty);
      if (target.length() === 0) {
        if (base.isXMLList && base.length() > 1) {
          return null;
        }
        base.setProperty(targetProperty, '');
        target = base.getProperty(targetProperty);
      }
      return target;
    };
    XLp.asGetEnumerableKeys = function asGetEnumerableKeys() {
      if (XLp === this) {
        return Object.prototype.asGetEnumerableKeys.call(this);
      }
      var keys = [];
      this.children.forEach(function (v, i) {
        keys.push(i);
      });
      return keys;
    };
    c.native = {
      instance: {
        init: function () {
        }
      }
    };
    XLp.isXMLList = true;
    c.native = {
      static: {},
      instance: {
        toString: function () {
          return toString(this);
        },
        hasOwnProperty: function hasOwnProperty(P) {
          notImplemented('XMLList.hasOwnProperty');
        },
        propertyIsEnumerable: function propertyIsEnumerable(P) {
          notImplemented('XMLList.propertyIsEnumerable');
        },
        attribute: function attribute(name) {
          return this.getProperty(toAttributeName(name));
        },
        attributes: function attributes() {
          return this.getProperty(toAttributeName('*'));
        },
        child: function child(propertyName) {
          notImplemented('XMLList.child');
        },
        children: function children() {
          var list = new XMLList();
          for (var i = 0; i < this.children.length; i++) {
            var child = this.children[i];
            Array.prototype.push.apply(list.children, child.children);
          }
          return list;
        },
        comments: function comments() {
          var x = this;
          var xl = new XMLList(x, null);
          x.children.forEach(function (v, i) {
            if (v.kind === 'element') {
              xl.append(v.comments());
            }
          });
          return xl;
        },
        contains: function contains(value) {
          for (var i = 0; i < this.children.length; i++) {
            if (this.children[i] === value) {
              return true;
            }
          }
          return false;
        },
        copy: function copy() {
          return this.deepCopy();
        },
        descendants: function descendants(name) {
          return this.descendants(name === undefined ? '*' : name);
        },
        elements: function elements(name) {
          var x = this;
          var any = false;
          if (name === undefined) {
            name = '*';
            any = true;
          }
          var name = toXMLName(name);
          var xl = new XMLList(x, name);
          x.children.forEach(function (v, i) {
            if (v.kind === 'element') {
              xl.append(v.comments());
            }
          });
          return xl;
        },
        hasComplexContent: function hasComplexContent() {
          notImplemented('XMLList.hasComplexContent');
        },
        hasSimpleContent: function hasSimpleContent() {
          return this.hasSimpleContent();
        },
        length: function length() {
          return this.children.length;
        },
        name: function name() {
          return toXML(this).name;
        },
        normalize: function normalize() {
          notImplemented('XMLList.normalize');
        },
        parent: function parent() {
          notImplemented('XMLList.parent');
        },
        processingInstructions: function processingInstructions(name) {
          notImplemented('XMLList.processingInstructions');
        },
        text: function text() {
          var x = this;
          var xl = new XMLList(x, null);
          x.children.forEach(function (v, i) {
            if (v.kind === 'text' || v.kind === 'element') {
              xl.append(v.text());
            }
          });
          return xl;
        },
        toXMLString: function () {
          return toXMLString(this);
        },
        addNamespace: function addNamespace(ns) {
          notImplemented('XMLList.addNamespace');
        },
        appendChild: function appendChild(child) {
          toXML(this).appendChild(child);
          return this;
        },
        childIndex: function childIndex() {
          notImplemented('XMLList.childIndex');
        },
        inScopeNamespaces: function inScopeNamespaces() {
          notImplemented('XMLList.inScopeNamespaces');
        },
        insertChildAfter: function insertChildAfter(child1, child2) {
          notImplemented('XMLList.insertChildAfter');
        },
        insertChildBefore: function insertChildBefore(child1, child2) {
          notImplemented('XMLList.insertChildBefore');
        },
        nodeKind: function nodeKind() {
          return toXML(this).kind;
        },
        _namespace: function _namespace(prefix, argc) {
          notImplemented('XMLList._namespace');
        },
        localName: function localName() {
          notImplemented('XMLList.localName');
        },
        namespaceDeclarations: function namespaceDeclarations() {
          somewhatImplemented('XMLList.prototype.namespaceDeclarations()');
          return new XMLList();
        },
        prependChild: function prependChild(value) {
          notImplemented('XMLList.prependChild');
        },
        removeNamespace: function removeNamespace(ns) {
          notImplemented('XMLList.removeNamespace');
        },
        replace: function replace(propertyName, value) {
          toXML(this).replace(propertyName, value);
          return this;
        },
        setChildren: function setChildren(value) {
          notImplemented('XMLList.setChildren');
        },
        setLocalName: function setLocalName(name) {
          notImplemented('XMLList.setLocalName');
        },
        setName: function setName(name) {
          notImplemented('XMLList.setName');
        },
        setNamespace: function setNamespace(ns) {
          notImplemented('XMLList.setNamespace');
        }
      }
    };
    return c;
  };
  QNameClass = function QNameClass(runtime, scope, instanceConstructor, baseClass) {
    QName = function QName(ns, name, isAttr) {
      if (!(this instanceof QName)) {
        if (name === undefined && ns instanceof QName) {
          return ns;
        } else {
          return new QName(ns, name);
        }
      }
      if (name === undefined) {
        name = ns;
        ns = undefined;
      }
      if (typeof ns === 'string' || ns instanceof QName) {
        ns = new ASNamespace(ns);
      }
      var mn;
      if (name instanceof QName) {
        if (ns === undefined) {
          mn = name.mn;
        } else {
          mn = new Multiname([
            ns
          ], name.mn.getName());
        }
      } else if (name instanceof Multiname) {
        if (ns === undefined) {
          if (name.isQName() || name.isAnyName() || name.isAnyNamespace()) {
            mn = name;
          } else {
            mn = new Multiname([
              getDefaultNamespace(scope)
            ], name.getName(), name.flags);
          }
        } else {
          mn = new Multiname([
            ns
          ], name.getName(), name.flags);
        }
      } else if (name === '*') {
        mn = new Multiname([], null, isAttr ? Multiname.ATTRIBUTE : 0);
      } else if (name === '@*') {
        mn = new Multiname([], null, Multiname.ATTRIBUTE);
      } else {
        ns = ns === undefined ? getDefaultNamespace(scope) : ns;
        if (name === undefined) {
          mn = new Multiname([
            ns
          ], '');
        } else {
          mn = new Multiname([
            ns
          ], toString(name), isAttr ? Multiname.ATTRIBUTE : 0);
        }
      }
      this.mn = mn;
      this.isAny = mn.isAnyName();
      this.isAnyNamespace = mn.isAnyNamespace();
      this.isAttr = mn.isAttribute();
    };
    var c = new Class('QName', QName, Domain.passthroughCallable(QName));
    c.extend(baseClass);
    QNp = QName.prototype;
    defineNonEnumerableGetter(QNp, 'localName', function () {
      if (!this._localName) {
        this._localName = this.isAny ? '*' : this.mn.getName();
      }
      return this._localName;
    });
    defineNonEnumerableGetter(QNp, 'uri', function () {
      if (!this._uri) {
        var ns = this.mn.namespaces[0];
        this._uri = ns && ns.originalURI ? ns.originalURI : this.isAny || this.isAnyNamespace ? null : '';
      }
      return this._uri;
    });
    defineNonEnumerableGetter(QNp, 'prefix', function () {
      return this.mn.namespaces[0].prefix;
    });
    defineNonEnumerableSetter(QNp, 'prefix', function (prefix) {
      this.mn.namespaces[0].prefix = prefix;
    });
    QNp.getNamespace = function (isns) {
      if (this.uri === null) {
        throw 'TypeError in QName.prototype.getNamespace()';
      }
      if (!isns) {
        isns = [];
      }
      var ns;
      for (var i = 0; i < isns.length; i++) {
        if (this.uri === isns[i].uri) {
          ns = isns[i];
        }
      }
      if (!ns) {
        ns = ShumwayNamespace.createNamespace(this.uri);
      }
      return ns;
    };
    c.native = {
      static: {},
      instance: {
        localName: {
          get: function localName() {
            return this.localName;
          }
        },
        uri: {
          get: function uri() {
            return this.uri;
          }
        }
      }
    };
    return c;
  };
}());
var JSON;
JSON || (JSON = {});
(function () {
  function k(a) {
    return a < 10 ? '0' + a : a;
  }
  function o(a) {
    p.lastIndex = 0;
    return p.test(a) ? '"' + a.replace(p, function (a) {
      var c = r[a];
      return typeof c === 'string' ? c : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
    }) + '"' : '"' + a + '"';
  }
  function l(a, j) {
    var c, d, h, m, g = e, f, b = j[a];
    b && typeof b === 'object' && typeof b.toJSON === 'function' && (b = b.toJSON(a));
    typeof i === 'function' && (b = i.call(j, a, b));
    switch (typeof b) {
    case 'string':
      return o(b);
    case 'number':
      return isFinite(b) ? String(b) : 'null';
    case 'boolean':
    case 'null':
      return String(b);
    case 'object':
      if (!b)
        return 'null';
      e += n;
      f = [];
      if (Object.prototype.toString.apply(b) === '[object Array]') {
        m = b.length;
        for (c = 0; c < m; c += 1)
          f[c] = l(c, b) || 'null';
        h = f.length === 0 ? '[]' : e ? '[\n' + e + f.join(',\n' + e) + '\n' + g + ']' : '[' + f.join(',') + ']';
        e = g;
        return h;
      }
      if (i && typeof i === 'object') {
        m = i.length;
        for (c = 0; c < m; c += 1)
          typeof i[c] === 'string' && (d = i[c], (h = l(d, b)) && f.push(o(d) + (e ? ': ' : ':') + h));
      } else
        for (d in b)
          Object.prototype.hasOwnProperty.call(b, d) && (h = l(d, b)) && f.push(o(d) + (e ? ': ' : ':') + h);
      h = f.length === 0 ? '{}' : e ? '{\n' + e + f.join(',\n' + e) + '\n' + g + '}' : '{' + f.join(',') + '}';
      e = g;
      return h;
    }
  }
  if (typeof Date.prototype.toJSON !== 'function')
    Date.prototype.toJSON = function () {
      return isFinite(this.valueOf()) ? this.getUTCFullYear() + '-' + k(this.getUTCMonth() + 1) + '-' + k(this.getUTCDate()) + 'T' + k(this.getUTCHours()) + ':' + k(this.getUTCMinutes()) + ':' + k(this.getUTCSeconds()) + 'Z' : null;
    }, String.prototype.toJSON = Number.prototype.toJSON = Boolean.prototype.toJSON = function () {
      return this.valueOf();
    };
  var q = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g, p = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g, e, n, r = {
      '\b': '\\b',
      '\t': '\\t',
      '\n': '\\n',
      '\f': '\\f',
      '\r': '\\r',
      '"': '\\"',
      '\\': '\\\\'
    }, i;
  if (typeof JSON.stringify !== 'function')
    JSON.stringify = function (a, j, c) {
      var d;
      n = e = '';
      if (typeof c === 'number')
        for (d = 0; d < c; d += 1)
          n += ' ';
      else
        typeof c === 'string' && (n = c);
      if ((i = j) && typeof j !== 'function' && (typeof j !== 'object' || typeof j.length !== 'number'))
        throw Error('JSON.stringify');
      return l('', {
        '': a
      });
    };
  if (typeof JSON.parse !== 'function')
    JSON.parse = function (a, e) {
      function c(a, d) {
        var g, f, b = a[d];
        if (b && typeof b === 'object')
          for (g in b)
            Object.prototype.hasOwnProperty.call(b, g) && (f = c(b, g), f !== void 0 ? b[g] = f : delete b[g]);
        return e.call(a, d, b);
      }
      var d, a = String(a);
      q.lastIndex = 0;
      q.test(a) && (a = a.replace(q, function (a) {
        return '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
      }));
      if (/^[\],:{}\s]*$/.test(a.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@').replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']').replace(/(?:^|:|,)(?:\s*\[)+/g, '')))
        return d = eval('(' + a + ')'), typeof e === 'function' ? c({
          '': d
        }, '') : d;
      throw new SyntaxError('JSON.parse');
    };
}());
var AMFUtils = function AMFUtilsClosure() {
    var AMF0_NUMBER_MARKER = 0;
    var AMF0_BOOLEAN_MARKER = 1;
    var AMF0_STRING_MARKER = 2;
    var AMF0_OBJECT_MARKER = 3;
    var AMF0_NULL_MARKER = 5;
    var AMF0_UNDEFINED_MARKER = 6;
    var AMF0_REFERENCE_MARKER = 7;
    var AMF0_ECMA_ARRAY_MARKER = 8;
    var AMF0_OBJECT_END_MARKER = 9;
    var AMF0_STRICT_ARRAY_MARKER = 10;
    var AMF0_DATE_MARKER = 11;
    var AMF0_LONG_STRING_MARKER = 12;
    var AMF0_XML_MARKER = 15;
    var AMF0_TYPED_OBJECT_MARKER = 16;
    var AMF0_AVMPLUS_MARKER = 17;
    function writeString(ba, s) {
      if (s.length > 65535) {
        throw 'AMF short string exceeded';
      }
      if (!s.length) {
        ba.writeByte(0);
        ba.writeByte(0);
        return;
      }
      var bytes = utf8decode(s);
      ba.writeByte(bytes.length >> 8 & 255);
      ba.writeByte(bytes.length & 255);
      for (var i = 0; i < bytes.length; i++) {
        ba.writeByte(bytes[i]);
      }
    }
    function readString(ba) {
      var byteLength = ba.readByte() << 8 | ba.readByte();
      if (!byteLength) {
        return '';
      }
      var buffer = new Uint8Array(byteLength);
      for (var i = 0; i < byteLength; i++) {
        buffer[i] = ba.readByte();
      }
      return utf8encode(buffer);
    }
    function writeDouble(ba, value) {
      var buffer = new ArrayBuffer(8);
      var view = new DataView(buffer);
      view.setFloat64(0, value, false);
      for (var i = 0; i < buffer.byteLength; i++) {
        ba.writeByte(view.getUint8(i));
      }
    }
    function readDouble(ba) {
      var buffer = new ArrayBuffer(8);
      var view = new DataView(buffer);
      for (var i = 0; i < buffer.byteLength; i++) {
        view.setUint8(i, ba.readByte());
      }
      return view.getFloat64(0, false);
    }
    function setAvmProperty(obj, propertyName, value) {
      obj.asSetPublicProperty(propertyName, value);
    }
    var amf0 = {
        write: function (ba, obj) {
          switch (typeof obj) {
          case 'boolean':
            ba.writeByte(AMF0_BOOLEAN_MARKER);
            ba.writeByte(obj ? 1 : 0);
            break;
          case 'number':
            ba.writeByte(AMF0_NUMBER_MARKER);
            writeDouble(ba, obj);
            break;
          case 'undefined':
            ba.writeByte(AMF0_UNDEFINED_MARKER);
            break;
          case 'string':
            ba.writeByte(AMF0_STRING_MARKER);
            writeString(ba, obj);
            break;
          case 'object':
            if (obj === null) {
              ba.writeByte(AMF0_NULL_MARKER);
            } else if (Array.isArray(obj)) {
              ba.writeByte(AMF0_ECMA_ARRAY_MARKER);
              ba.writeByte(obj.length >>> 24 & 255);
              ba.writeByte(obj.length >> 16 & 255);
              ba.writeByte(obj.length >> 8 & 255);
              ba.writeByte(obj.length & 255);
              forEachPublicProperty(obj, function (key, value) {
                writeString(ba, key);
                this.write(ba, value);
              }, this);
              ba.writeByte(0);
              ba.writeByte(0);
              ba.writeByte(AMF0_OBJECT_END_MARKER);
            } else {
              ba.writeByte(AMF0_OBJECT_MARKER);
              forEachPublicProperty(obj, function (key, value) {
                writeString(ba, key);
                this.write(ba, value);
              }, this);
              ba.writeByte(0);
              ba.writeByte(0);
              ba.writeByte(AMF0_OBJECT_END_MARKER);
            }
            return;
          }
        },
        read: function (ba) {
          var marker = ba.readByte();
          switch (marker) {
          case AMF0_NUMBER_MARKER:
            return readDouble(ba);
          case AMF0_BOOLEAN_MARKER:
            return !(!ba.readByte());
          case AMF0_STRING_MARKER:
            return readString(ba);
          case AMF0_OBJECT_MARKER:
            var obj = {};
            while (true) {
              var key = readString(ba);
              if (!key.length)
                break;
              setAvmProperty(obj, key, this.read(ba));
            }
            if (ba.readByte() !== AMF0_OBJECT_END_MARKER) {
              throw 'AMF0 End marker is not found';
            }
            return obj;
          case AMF0_NULL_MARKER:
            return null;
          case AMF0_UNDEFINED_MARKER:
            return undefined;
          case AMF0_ECMA_ARRAY_MARKER:
            var obj = [];
            obj.length = ba.readByte() << 24 | ba.readByte() << 16 | ba.readByte() << 8 | ba.readByte();
            while (true) {
              var key = readString(ba);
              if (!key.length)
                break;
              setAvmProperty(obj, key, this.read(ba));
            }
            if (ba.readByte() !== AMF0_OBJECT_END_MARKER) {
              throw 'AMF0 End marker is not found';
            }
            return obj;
          case AMF0_STRICT_ARRAY_MARKER:
            var obj = [];
            obj.length = ba.readByte() << 24 | ba.readByte() << 16 | ba.readByte() << 8 | ba.readByte();
            for (var i = 0; i < obj.length; i++) {
              obj[i] = this.read(ba);
            }
            return obj;
          case AMF0_AVMPLUS_MARKER:
            return readAmf3Data(ba, {});
          default:
            throw 'AMF0 Unknown marker ' + marker;
          }
        }
      };
    var AMF3_UNDEFINED_MARKER = 0;
    var AMF3_NULL_MARKER = 1;
    var AMF3_FALSE_MARKER = 2;
    var AMF3_TRUE_MARKER = 3;
    var AMF3_INTEGER_MARKER = 4;
    var AMF3_DOUBLE_MARKER = 5;
    var AMF3_STRING_MARKER = 6;
    var AMF3_XML_DOC_MARKER = 7;
    var AMF3_DATE_MARKER = 8;
    var AMF3_ARRAY_MARKER = 9;
    var AMF3_OBJECT_MARKER = 10;
    var AMF3_XML_MARKER = 11;
    var AMF3_BYTEARRAY_MARKER = 12;
    var AMF3_VECTOR_INT_MARKER = 13;
    var AMF3_VECTOR_UINT_MARKER = 14;
    var AMF3_VECTOR_DOUBLE_MARKER = 15;
    var AMF3_VECTOR_OBJECT_MARKER = 16;
    var AMF3_DICTIONARY_MARKER = 17;
    function readU29(ba) {
      var b1 = ba.readByte();
      if ((b1 & 128) === 0) {
        return b1;
      }
      var b2 = ba.readByte();
      if ((b2 & 128) === 0) {
        return (b1 & 127) << 7 | b2;
      }
      var b3 = ba.readByte();
      if ((b3 & 128) === 0) {
        return (b1 & 127) << 14 | (b2 & 127) << 7 | b3;
      }
      var b4 = ba.readByte();
      return (b1 & 127) << 22 | (b2 & 127) << 15 | (b3 & 127) << 8 | b4;
    }
    function writeU29(ba, value) {
      if ((value & 4294967168) === 0) {
        ba.writeByte(value & 127);
      } else if ((value & 4294950912) === 0) {
        ba.writeByte(128 | value >> 7 & 127);
        ba.writeByte(value & 127);
      } else if ((value & 4292870144) === 0) {
        ba.writeByte(128 | value >> 14 & 127);
        ba.writeByte(128 | value >> 7 & 127);
        ba.writeByte(value & 127);
      } else if ((value & 3221225472) === 0) {
        ba.writeByte(128 | value >> 22 & 127);
        ba.writeByte(128 | value >> 15 & 127);
        ba.writeByte(128 | value >> 8 & 127);
        ba.writeByte(value & 255);
      } else {
        throw 'AMF3 U29 range';
      }
    }
    function readUTF8vr(ba, caches) {
      var u29s = readU29(ba);
      if (u29s === 1) {
        return '';
      }
      var stringsCache = caches.stringsCache || (caches.stringsCache = []);
      if ((u29s & 1) === 0) {
        return stringsCache[u29s >> 1];
      }
      var byteLength = u29s >> 1;
      var buffer = new Uint8Array(byteLength);
      for (var i = 0; i < byteLength; i++) {
        buffer[i] = ba.readByte();
      }
      var value = utf8encode(buffer);
      stringsCache.push(value);
      return value;
    }
    function writeUTF8vr(ba, value, caches) {
      if (value === '') {
        ba.writeByte(1);
        return;
      }
      var stringsCache = caches.stringsCache || (caches.stringsCache = []);
      var index = stringsCache.indexOf(value);
      if (index >= 0) {
        writeU29(ba, index << 1);
        return;
      }
      stringsCache.push(value);
      var bytes = utf8decode(value);
      writeU29(ba, 1 | bytes.length << 1);
      for (var i = 0; i < bytes.length; i++) {
        ba.writeByte(bytes[i]);
      }
    }
    function readAmf3Data(ba, caches) {
      var marker = ba.readByte();
      switch (marker) {
      case AMF3_NULL_MARKER:
        return null;
      case AMF3_UNDEFINED_MARKER:
        return undefined;
      case AMF3_FALSE_MARKER:
        return false;
      case AMF3_TRUE_MARKER:
        return true;
      case AMF3_INTEGER_MARKER:
        return readU29(ba);
      case AMF3_DOUBLE_MARKER:
        return readDouble(ba);
      case AMF3_STRING_MARKER:
        return readUTF8vr(ba, caches);
      case AMF3_DATE_MARKER:
        return new Date(readDouble(ba));
      case AMF3_OBJECT_MARKER:
        var u29o = readU29(ba);
        if ((u29o & 1) === 0) {
          return caches.objectsCache[u29o >> 1];
        }
        if ((u29o & 4) !== 0) {
          throw 'AMF3 Traits-Ext is not supported';
        }
        var traits, objectClass;
        if ((u29o & 2) === 0) {
          traits = caches.traitsCache[u29o >> 2];
          objectClass = traits.class;
        } else {
          traits = {};
          var aliasName = readUTF8vr(ba, caches);
          traits.className = aliasName;
          objectClass = aliasName && aliasesCache.names[aliasName];
          traits.class = objectClass;
          traits.isDynamic = (u29o & 8) !== 0;
          traits.members = [];
          var slots = objectClass && objectClass.instanceBindings.slots;
          for (var i = 0, j = u29o >> 4; i < j; i++) {
            var traitName = readUTF8vr(ba, caches);
            var slot = null;
            for (var j = 1; slots && j < slots.length; j++) {
              if (slots[j].name.name === traitName) {
                slot = slots[j];
                break;
              }
            }
            traits.members.push(slot ? Multiname.getQualifiedName(slot.name) : Multiname.getPublicQualifiedName(traitName));
          }
          (caches.traitsCache || (caches.traitsCache = [])).push(traits);
        }
        var obj = objectClass ? objectClass.createInstance() : {};
        (caches.objectsCache || (caches.objectsCache = [])).push(obj);
        for (var i = 0; i < traits.members.length; i++) {
          var value = readAmf3Data(ba, caches);
          obj[traits.members[i]] = value;
        }
        if (traits.isDynamic) {
          while (true) {
            var key = readUTF8vr(ba, caches);
            if (!key.length)
              break;
            var value = readAmf3Data(ba, caches);
            setAvmProperty(obj, key, value);
          }
        }
        return obj;
      case AMF3_ARRAY_MARKER:
        var u29o = readU29(ba);
        if ((u29o & 1) === 0) {
          return caches.objectsCache[u29o >> 1];
        }
        var obj = [];
        (caches.objectsCache || (caches.objectsCache = [])).push(obj);
        var densePortionLength = u29o >> 1;
        while (true) {
          var key = readUTF8vr(ba, caches);
          if (!key.length)
            break;
          var value = readAmf3Data(ba, caches);
          setAvmProperty(obj, key, value);
        }
        for (var i = 0; i < densePortionLength; i++) {
          var value = readAmf3Data(ba, caches);
          setAvmProperty(obj, i, value);
        }
        return obj;
      default:
        throw 'AMF3 Unknown marker ' + marker;
      }
    }
    function writeCachedReference(ba, obj, caches) {
      var objectsCache = caches.objectsCache || (caches.objectsCache = []);
      var index = objectsCache.indexOf(obj);
      if (index < 0) {
        objectsCache.push(obj);
        return false;
      }
      writeU29(ba, index << 1);
      return true;
    }
    function writeAmf3Data(ba, obj, caches) {
      switch (typeof obj) {
      case 'boolean':
        ba.writeByte(obj ? AMF3_TRUE_MARKER : AMF3_FALSE_MARKER);
        break;
      case 'number':
        if (obj === (obj | 0)) {
          ba.writeByte(AMF3_INTEGER_MARKER);
          writeU29(ba, obj);
        } else {
          ba.writeByte(AMF3_DOUBLE_MARKER);
          writeDouble(ba, obj);
        }
        break;
      case 'undefined':
        ba.writeByte(AMF3_UNDEFINED_MARKER);
        break;
      case 'string':
        ba.writeByte(AMF3_STRING_MARKER);
        writeUTF8vr(ba, obj, caches);
        break;
      case 'object':
        if (obj === null) {
          ba.writeByte(AMF3_NULL_MARKER);
        } else if (Array.isArray(obj)) {
          ba.writeByte(AMF3_ARRAY_MARKER);
          if (writeCachedReference(ba, obj, caches))
            break;
          var densePortionLength = 0;
          while (densePortionLength in obj) {
            ++densePortionLength;
          }
          writeU29(ba, densePortionLength << 1 | 1);
          forEachPublicProperty(obj, function (i, value) {
            if (isNumeric(i) && i >= 0 && i < densePortionLength) {
              return;
            }
            writeUTF8vr(ba, i, caches);
            writeAmf3Data(ba, value, caches);
          });
          writeUTF8vr(ba, '', caches);
          for (var j = 0; j < densePortionLength; j++) {
            writeAmf3Data(ba, obj[j], caches);
          }
        } else if (obj instanceof Date) {
          ba.writeByte(AMF3_DATE_MARKER);
          if (writeCachedReference(ba, obj, caches))
            break;
          writeU29(ba, 1);
          writeDouble(ba, obj.valueOf());
        } else {
          ba.writeByte(AMF3_OBJECT_MARKER);
          if (writeCachedReference(ba, obj, caches))
            break;
          var isDynamic = true;
          var objectClass = obj.class;
          if (objectClass) {
            isDynamic = !objectClass.classInfo.instanceInfo.isSealed();
            var aliasName = aliasesCache.classes.get(objectClass) || '';
            var traits, traitsCount;
            var traitsCache = caches.traitsCache || (caches.traitsCache = []);
            var traitsInfos = caches.traitsInfos || (caches.traitsInfos = []);
            var traitsRef = traitsCache.indexOf(objectClass);
            if (traitsRef < 0) {
              var slots = objectClass.instanceBindings.slots;
              traits = [];
              var traitsNames = [];
              for (var i = 1; i < slots.length; i++) {
                var slot = slots[i];
                if (!slot.name.getNamespace().isPublic()) {
                  continue;
                }
                traits.push(Multiname.getQualifiedName(slot.name));
                traitsNames.push(slot.name.name);
              }
              traitsCache.push(objectClass);
              traitsInfos.push(traits);
              traitsCount = traitsNames.length;
              writeU29(ba, (isDynamic ? 11 : 3) + (traitsCount << 4));
              writeUTF8vr(ba, aliasName, caches);
              for (var i = 0; i < traitsCount; i++) {
                writeUTF8vr(ba, traitsNames[i], caches);
              }
            } else {
              traits = traitsInfos[traitsRef];
              traitsCount = traits.length;
              writeU29(ba, 1 + (traitsRef << 2));
            }
            for (var i = 0; i < traitsCount; i++) {
              writeAmf3Data(ba, obj[traits[i]], caches);
            }
          } else {
            writeU29(ba, 11);
            writeUTF8vr(ba, '', caches);
          }
          if (isDynamic) {
            forEachPublicProperty(obj, function (i, value) {
              writeUTF8vr(ba, i, caches);
              writeAmf3Data(ba, value, caches);
            });
            writeUTF8vr(ba, '', caches);
          }
        }
        return;
      }
    }
    var aliasesCache = {
        classes: new WeakMap(),
        names: Object.create(null)
      };
    var amf3 = {
        write: function (ba, obj) {
          writeAmf3Data(ba, obj, {});
        },
        read: function (ba) {
          return readAmf3Data(ba, {});
        }
      };
    return {
      encodings: [
        amf0,
        null,
        null,
        amf3
      ],
      aliasesCache: aliasesCache
    };
  }();
function ProxyClass(runtime, scope, instanceConstructor, baseClass) {
  function ProxyConstructor() {
    somewhatImplemented('Proxy');
  }
  var c = new Class('Proxy', ProxyConstructor, Domain.coerceCallable(ProxyConstructor));
  c.extendBuiltin(baseClass);
  return c;
}
var proxyTrapQns = {
    'getProperty': null,
    'setProperty': null,
    'hasProperty': null,
    'callProperty': null
  };
for (var name in proxyTrapQns) {
  proxyTrapQns[name] = VM_OPEN_METHOD_PREFIX + Multiname.getQualifiedName(new Multiname([
    ShumwayNamespace.PROXY
  ], name));
}
var VM_IS_PROXY = 'vm is proxy';
var VM_CALL_PROXY = 'vm call proxy';
function isProxyObject(obj) {
  return obj[VM_IS_PROXY];
}
function nameFromQualifiedName(qn) {
  if (isNumeric(qn)) {
    return qn;
  }
  var mn = Multiname.fromQualifiedName(qn);
  if (mn === undefined) {
    return undefined;
  }
  return mn.name;
}
function hasNonProxyingCaller() {
  var caller = arguments.callee;
  var maxDepth = 5;
  var domain;
  for (var i = 0; i < maxDepth && caller; i++) {
    if (caller === nonProxyingHasProperty) {
      return true;
    }
    caller = caller.caller;
  }
  return false;
}
function installProxyClassWrapper(cls) {
  var TRACE_PROXY = false;
  if (TRACE_PROXY) {
    print('proxy wrapping, class: ' + cls);
  }
  var instanceConstructor = cls.instanceConstructor;
  function construct() {
    if (TRACE_PROXY) {
      print('proxy create, class: ' + cls);
    }
    var target = Object.create(instanceConstructor.prototype);
    var proxy = Proxy.create({
        get: function (o, qn) {
          if (qn === VM_IS_PROXY) {
            TRACE_PROXY && print('proxy check');
            return true;
          }
          if (qn === VM_CALL_PROXY) {
            TRACE_PROXY && print('proxy get caller');
            return function apply(mn, receiver, args) {
              receiver = receiver ? target : null;
              if (TRACE_PROXY) {
                print('proxy call, class: ' + target.class + ', mn: ' + mn + 'hasNonProxyingCallerr: ' + hasNonProxyingCaller());
              }
              var resolved = Multiname.isQName(mn) ? mn : resolveMultiname(target, mn);
              var qn = resolved ? Multiname.getQualifiedName(resolved) : Multiname.getPublicQualifiedName(mn.name);
              if (!nameInTraits(target, qn)) {
                return target[proxyTrapQns.callProperty](mn.name, args);
              }
              if (TRACE_PROXY) {
                TRACE_PROXY && print('> proxy pass through ' + resolved);
              }
              if (target[VM_OPEN_METHODS] && target[VM_OPEN_METHODS][qn]) {
                return target[VM_OPEN_METHODS][qn].apply(o, args);
              }
              return undefined;
            };
          }
          if (TRACE_PROXY) {
            print('proxy get, class: ' + target.class + ', qn: ' + qn + 'hasNonProxyingCallerr: ' + hasNonProxyingCaller());
          }
          if (!hasNonProxyingCaller()) {
            var name = nameFromQualifiedName(qn);
            if (name !== undefined && !nameInTraits(target, qn)) {
              return target[proxyTrapQns.getProperty](name);
            }
          }
          if (target[VM_OPEN_METHODS] && target[VM_OPEN_METHODS][qn]) {
            return bindSafely(target[VM_OPEN_METHODS][qn], o);
          }
          TRACE_PROXY && print('> proxy pass through ' + qn);
          return target[qn];
        },
        set: function (o, qn, value) {
          if (TRACE_PROXY) {
            print('proxy set, class: ' + target.class + ', qn: ' + qn + 'hasNonProxyingCallerr: ' + hasNonProxyingCaller());
          }
          if (!hasNonProxyingCaller()) {
            var name = nameFromQualifiedName(qn);
            if (name !== undefined && !nameInTraits(target, qn)) {
              target[proxyTrapQns.setProperty](name, value);
              return;
            }
          }
          TRACE_PROXY && print('> proxy pass through ' + qn);
          target[qn] = value;
        },
        has: function (qn) {
          if (TRACE_PROXY) {
            print('proxy has, class: ' + target.class + ', qn: ' + qn + 'hasNonProxyingCallerr: ' + hasNonProxyingCaller());
          }
          if (!hasNonProxyingCaller()) {
            var name = nameFromQualifiedName(qn);
            if (name !== undefined && !nameInTraits(target, qn)) {
              return target[proxyTrapQns.hasProperty](name);
            }
          }
          return qn in target;
        },
        hasOwn: function (qn) {
          if (TRACE_PROXY) {
            print('proxy hasOwn, class: ' + target.class + ', qn: ' + qn + 'hasNonProxyingCallerr: ' + hasNonProxyingCaller());
          }
          if (!hasNonProxyingCaller()) {
            var name = nameFromQualifiedName(qn);
            if (name !== undefined && !nameInTraits(target, qn)) {
              return target[proxyTrapQns.hasProperty](name);
            }
          }
          TRACE_PROXY && print('> proxy pass through ' + qn);
          return !(!Object.getOwnPropertyDescriptor(target, qn));
        },
        enumerate: function () {
          notImplemented('enumerate');
        },
        keys: function () {
          notImplemented('keys');
        }
      }, instanceConstructor.prototype);
    instanceConstructor.apply(proxy, sliceArguments(arguments, 0));
    return proxy;
  }
  cls.instanceConstructor = construct;
}
function DictionaryClass(domain, scope, instanceConstructor, baseClass) {
  function ASDictionary(weakKeys) {
    this.weakKeys = weakKeys;
    this.map = new WeakMap();
    if (!weakKeys) {
      this.keys = [];
    }
    this.primitiveMap = createEmptyObject();
  }
  var c = new Class('Dictionary', ASDictionary, Domain.passthroughCallable(ASDictionary));
  c.extendNative(baseClass, ASDictionary);
  function makePrimitiveKey(key) {
    if (typeof key === 'string' || typeof key === 'number') {
      return key;
    }
    return undefined;
  }
  var prototype = ASDictionary.prototype;
  defineNonEnumerableProperty(prototype, 'asGetProperty', function asGetProperty(namespaces, name, flags, isMethod) {
    var key = makePrimitiveKey(name);
    if (key !== undefined) {
      return this.primitiveMap[key];
    }
    return this.map.get(Object(name));
  });
  defineNonEnumerableProperty(prototype, 'asGetResolvedStringProperty', asGetResolvedStringPropertyFallback);
  defineNonEnumerableProperty(prototype, 'asSetProperty', function asSetProperty(namespaces, name, flags, value) {
    var key = makePrimitiveKey(name);
    if (key !== undefined) {
      this.primitiveMap[key] = value;
      return;
    }
    this.map.set(Object(name), value);
    if (!this.weakKeys && this.keys.indexOf(name) < 0) {
      this.keys.push(name);
    }
  });
  defineNonEnumerableProperty(prototype, 'asCallProperty', function asCallProperty(namespaces, name, flags, isLex, args) {
    notImplemented('asCallProperty');
  });
  defineNonEnumerableProperty(prototype, 'asHasProperty', function asHasProperty(namespaces, name, flags, nonProxy) {
    var key = makePrimitiveKey(name);
    if (key !== undefined) {
      return key in this.primitiveMap;
    }
    return this.map.has(Object(name));
  });
  defineNonEnumerableProperty(prototype, 'asDeleteProperty', function asDeleteProperty(namespaces, name, flags) {
    var key = makePrimitiveKey(name);
    if (key !== undefined) {
      delete this.primitiveMap[key];
    }
    this.map.delete(Object(name));
    var i;
    if (!this.weakKeys && (i = this.keys.indexOf(name)) >= 0) {
      this.keys.splice(i, 1);
    }
    return true;
  });
  defineNonEnumerableProperty(prototype, 'asGetEnumerableKeys', function () {
    if (prototype === this) {
      return Object.prototype.asGetEnumerableKeys.call(this);
    }
    var primitiveMapKeys = [];
    for (var k in this.primitiveMap) {
      primitiveMapKeys.push(k);
    }
    return primitiveMapKeys.concat(this.keys);
  });
  c.native = {
    instance: {
      init: function () {
      }
    }
  };
  return c;
}
function debugBreak(message) {
  debugger;
  print('\x1b[91mdebugBreak: ' + message + '\x1b[0m');
}
var ASNamespace;
var natives = function () {
    var C = Domain.passthroughCallable;
    var CC = Domain.constructingCallable;
    function ObjectClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('Object', Object, C(Object));
      c.native = {
        instance: {
          length: {
            get: function () {
              return this.length;
            },
            set: function (l) {
              this.length = l;
            }
          },
          isPrototypeOf: Object.prototype.isPrototypeOf,
          hasOwnProperty: function (name) {
            if (name === undefined) {
              return false;
            }
            name = Multiname.getPublicQualifiedName(name);
            if (Object.prototype.hasOwnProperty.call(this, name)) {
              return true;
            }
            return Object.getPrototypeOf(this).hasOwnProperty(name);
          },
          propertyIsEnumerable: function (name) {
            if (name === undefined) {
              return false;
            }
            name = Multiname.getPublicQualifiedName(name);
            return Object.prototype.propertyIsEnumerable.call(this, name);
          }
        },
        static: {
          _setPropertyIsEnumerable: function _setPropertyIsEnumerable(obj, name, isEnum) {
            name = Multiname.getPublicQualifiedName(name);
            var descriptor = Object.getOwnPropertyDescriptor(obj, name);
            descriptor.enumerable = false;
            Object.defineProperty(obj, name, descriptor);
          }
        }
      };
      c.dynamicPrototype = c.traitsPrototype = Object.prototype;
      c.setDefaultProperties();
      c.defaultValue = null;
      c.coerce = function (value) {
        return asCoerceObject(value);
      };
      c.isInstanceOf = function (value) {
        if (value === null) {
          return false;
        }
        return true;
      };
      c.isInstance = function (value) {
        if (value === null || value === undefined) {
          return false;
        }
        return true;
      };
      return c;
    }
    function ClassClass(runtime, scope, instanceConstructor, baseClass) {
      var c = Class;
      c.debugName = 'Class';
      c.prototype.extendBuiltin.call(c, baseClass);
      c.coerce = function (value) {
        return value;
      };
      c.isInstanceOf = function (value) {
        return true;
      };
      c.isInstance = function (value) {
        return value instanceof c.instanceConstructor;
      };
      return c;
    }
    function BooleanClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('Boolean', Boolean, C(Boolean));
      c.extendBuiltin(baseClass);
      c.native = {
        instance: {
          toString: Boolean.prototype.toString,
          valueOf: Boolean.prototype.valueOf
        }
      };
      c.coerce = Boolean;
      c.isInstanceOf = function (value) {
        return typeof value === 'boolean' || value instanceof Boolean;
      };
      c.isInstance = function (value) {
        if (typeof value === 'boolean' || value instanceof Boolean) {
          return true;
        }
        return false;
      };
      return c;
    }
    function FunctionClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('Function', Function, C(Function));
      c.extendBuiltin(baseClass);
      c.native = {
        instance: {
          prototype: {
            get: function () {
              return this.prototype;
            },
            set: function (p) {
              this.prototype = p;
            }
          },
          length: {
            get: function () {
              if (this.hasOwnProperty(VM_LENGTH)) {
                return this[VM_LENGTH];
              }
              return this.length;
            }
          },
          call: Function.prototype.call,
          apply: Function.prototype.apply
        }
      };
      c.coerce = function (value) {
        return value;
      };
      c.isInstanceOf = function (value) {
        return typeof value === 'function';
      };
      c.isInstance = function (value) {
        return typeof value === 'function';
      };
      return c;
    }
    function MethodClosureClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('MethodClosure', MethodClosure);
      c.extendBuiltin(baseClass);
      return c;
    }
    function StringClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('String', String, C(String));
      c.extendBuiltin(baseClass);
      var Sp = String.prototype;
      c.native = {
        instance: {
          length: {
            get: function () {
              return this.length;
            }
          },
          indexOf: Sp.indexOf,
          lastIndexOf: Sp.lastIndexOf,
          charAt: Sp.charAt,
          charCodeAt: Sp.charCodeAt,
          concat: Sp.concat,
          localeCompare: Sp.localeCompare,
          match: function (re) {
            if (re === void 0) {
              return null;
            } else {
              return this.match(re);
            }
          },
          replace: Sp.replace,
          search: function (re) {
            if (re === void 0) {
              return -1;
            } else {
              return this.search(re);
            }
          },
          slice: Sp.slice,
          split: Sp.split,
          substr: Sp.substr,
          substring: Sp.substring,
          toLowerCase: Sp.toLowerCase,
          toLocaleLowerCase: Sp.toLocaleLowerCase,
          toUpperCase: function () {
            var str = Sp.toUpperCase.apply(this);
            var str = str.replace(/\u039C/g, String.fromCharCode(181));
            return str;
          },
          toLocaleUpperCase: function () {
            var str = Sp.toLocaleUpperCase.apply(this);
            var str = str.replace(/\u039C/g, String.fromCharCode(181));
            return str;
          },
          toString: Sp.toString,
          valueOf: Sp.valueOf
        },
        static: String
      };
      c.isInstance = function (value) {
        return value !== null && value !== undefined && typeof value.valueOf() === 'string';
      };
      c.coerce = function (value) {
        if (value === null || value === undefined) {
          return null;
        }
        return String(value);
      };
      c.isInstanceOf = function (value) {
        return Object(value) instanceof String;
      };
      c.isInstance = function (value) {
        return Object(value) instanceof String;
      };
      return c;
    }
    function ArrayClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('Array', Array, C(Array));
      c.extendBuiltin(baseClass);
      var Ap = Array.prototype;
      var CACHE_NUMERIC_COMPARATORS = true;
      var numericComparatorCache = createEmptyObject();
      c.native = {
        instance: {
          length: {
            get: function () {
              return this.length;
            },
            set: function (l) {
              this.length = l;
            }
          },
          join: Ap.join,
          pop: Ap.pop,
          push: Ap.push,
          reverse: Ap.reverse,
          concat: Ap.concat,
          shift: Ap.shift,
          slice: Ap.slice,
          unshift: Ap.unshift,
          splice: Ap.splice,
          indexOf: Ap.indexOf,
          lastIndexOf: Ap.lastIndexOf,
          every: Ap.every,
          filter: Ap.filter,
          forEach: Ap.forEach,
          map: Ap.map,
          some: Ap.some
        },
        static: {
          _sortOn: function (o, names, options) {
            if (isString(names)) {
              names = [
                names
              ];
            }
            if (isNumber(options)) {
              options = [
                options
              ];
            }
            for (var i = names.length - 1; i >= 0; i--) {
              var key = Multiname.getPublicQualifiedName(names[i]);
              if (CACHE_NUMERIC_COMPARATORS && options[i] & SORT_NUMERIC) {
                var str = 'var x = toNumber(a.' + key + '), y = toNumber(b.' + key + ');';
                if (options[i] & SORT_DESCENDING) {
                  str += 'return x < y ? 1 : (x > y ? -1 : 0);';
                } else {
                  str += 'return x < y ? -1 : (x > y ? 1 : 0);';
                }
                var numericComparator = numericComparatorCache[str];
                if (!numericComparator) {
                  numericComparator = numericComparatorCache[str] = new Function('a', 'b', str);
                }
                o.sort(numericComparator);
              } else {
                o.sort(function (a, b) {
                  return asCompare(a[key], b[key], options[i] | 0);
                });
              }
            }
            return o;
          },
          _sort: function (o, args) {
            if (args.length === 0) {
              return o.sort();
            }
            var compareFunction, options = 0;
            if (args[0] instanceof Function) {
              compareFunction = args[0];
            } else if (isNumber(args[0])) {
              options = args[0];
            }
            if (isNumber(args[1])) {
              options = args[1];
            }
            o.sort(function (a, b) {
              return asCompare(a, b, options, compareFunction);
            });
            return o;
          }
        }
      };
      c.coerce = function (value) {
        return value;
      };
      c.isInstanceOf = function (value) {
        return true;
      };
      return c;
    }
    function VectorClass(domain, scope, instanceConstructor, baseClass) {
      return createVectorClass(undefined, baseClass);
    }
    function ObjectVectorClass(domain, scope, instanceConstructor, baseClass) {
      return createVectorClass(domain.getClass('Object'), baseClass);
    }
    function IntVectorClass(domain, scope, instanceConstructor, baseClass) {
      return createVectorClass(domain.getClass('int'), baseClass);
    }
    function UIntVectorClass(domain, scope, instanceConstructor, baseClass) {
      return createVectorClass(domain.getClass('uint'), baseClass);
    }
    function DoubleVectorClass(domain, scope, instanceConstructor, baseClass) {
      return createVectorClass(domain.getClass('Number'), baseClass);
    }
    function createVectorClass(type, baseClass) {
      var V;
      if (type) {
        var className = 'Vector$' + type.classInfo.instanceInfo.name.name;
        switch (className) {
        case 'Vector$int':
          V = Int32Vector;
          break;
        case 'Vector$uint':
          V = Uint32Vector;
          break;
        case 'Vector$Number':
          V = Float64Vector;
          break;
        case 'Vector$Object':
          V = GenericVector;
          break;
        default:
          unexpected();
          break;
        }
      } else {
        V = GenericVector.applyType(null);
      }
      var Vp = V.prototype;
      var cls = new Class(className, V, C(V.callable));
      if (V === GenericVector) {
        cls.applyType = function (type) {
          return cls;
        };
      }
      cls.extendWrapper(baseClass, V);
      cls.native = {
        instance: {
          fixed: {
            get: function () {
              return this.fixed;
            },
            set: function (v) {
              this.fixed = v;
            }
          },
          length: {
            get: function () {
              return this.length;
            },
            set: function setLength(length) {
              this.length = length;
            }
          },
          push: Vp.push,
          pop: Vp.pop,
          shift: Vp.shift,
          unshift: Vp.unshift,
          _reverse: Vp.reverse,
          _every: Vp.every,
          _filter: Vp.filter,
          _forEach: Vp.forEach,
          _map: Vp.map,
          _some: Vp.some,
          _sort: Vp.sort,
          newThisType: function newThisType() {
            return new cls.instanceConstructor();
          },
          _spliceHelper: function _spliceHelper(insertPoint, insertCount, deleteCount, args, offset) {
            return this._spliceHelper(insertPoint, insertCount, deleteCount, args, offset);
          }
        },
        static: {
          _every: function (o, callback, thisObject) {
            return o.every(callback, thisObject);
          },
          _forEach: function (o, callback, thisObject) {
            return o.forEach(callback, thisObject);
          }
        }
      };
      cls.vectorType = type;
      cls.coerce = function (value) {
        return value;
      };
      cls.isInstanceOf = function (value) {
        return true;
      };
      cls.isInstance = function (value) {
        if (value === null || typeof value !== 'object') {
          return false;
        }
        if (!this.instanceConstructor.vectorType && value.class.vectorType) {
          return true;
        }
        return this.instanceConstructor.prototype.isPrototypeOf(value);
      };
      return cls;
    }
    function NumberClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('Number', Number, C(Number));
      c.extendBuiltin(baseClass);
      c.native = {
        instance: Number.prototype
      };
      c.defaultValue = Number(0);
      c.isInstance = function (value) {
        return value !== null && value !== undefined && typeof value.valueOf() === 'number';
      };
      c.coerce = Number;
      c.isInstanceOf = function (value) {
        return Object(value) instanceof Number;
      };
      c.isInstance = function (value) {
        return Object(value) instanceof Number;
      };
      return c;
    }
    function Int(x) {
      return x | 0;
    }
    function boxedInt(x) {
      return Object(x | 0);
    }
    function intClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('int', boxedInt, C(Int));
      c.extendBuiltin(baseClass);
      c.defaultValue = 0;
      c.coerce = Int;
      c.isInstanceOf = function (value) {
        return false;
      };
      c.isInstance = function (value) {
        if (value instanceof Number) {
          value = value.valueOf();
        }
        return (value | 0) === value;
      };
      return c;
    }
    function Uint(x) {
      return x >>> 0;
    }
    function boxedUint(x) {
      return Object(x >>> 0);
    }
    function uintClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('uint', boxedUint, C(Uint));
      c.extend(baseClass);
      c.defaultValue = 0;
      c.isInstanceOf = function (value) {
        return false;
      };
      c.isInstance = function (value) {
        if (value instanceof Number) {
          value = value.valueOf();
        }
        return value >>> 0 === value;
      };
      c.coerce = Uint;
      return c;
    }
    function MathClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('Math');
      c.native = {
        static: Math
      };
      return c;
    }
    function DateClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('Date', Date, C(Date));
      c.extendBuiltin(baseClass);
      c.native = {
        instance: Date.prototype,
        static: Date
      };
      return c;
    }
    function makeErrorClass(name) {
      var ErrorDefinition = {
          __glue__: {
            script: {
              instance: {
                message: 'public message',
                name: 'public name'
              }
            },
            native: {
              instance: {
                getStackTrace: function () {
                  somewhatImplemented('Error.getStackTrace()');
                  return AVM2.getStackTrace();
                }
              },
              static: {
                getErrorMessage: getErrorMessage
              }
            }
          }
        };
      return function (runtime, scope, instanceConstructor, baseClass) {
        var c = new Class(name, instanceConstructor);
        c.extend(baseClass);
        if (name === 'Error') {
          c.link(ErrorDefinition);
          c.linkNatives(ErrorDefinition);
        }
        return c;
      };
    }
    function RegExpClass(runtime, scope, instanceConstructor, baseClass) {
      var c = new Class('RegExp', XRegExp, C(XRegExp));
      c.extendBuiltin(baseClass);
      RegExpClass.exec = function exec() {
        var result = this.exec.apply(this, arguments);
        if (!result) {
          return result;
        }
        var keys = Object.keys(result);
        for (var i = 0; i < keys.length; i++) {
          var k = keys[i];
          if (!isNumeric(k)) {
            if (result[k] === undefined) {
              result[k] = '';
            }
          }
        }
        publicizeProperties(result);
        return result;
      };
      RegExpClass.test = function test() {
        return this.exec.apply(this, arguments) !== null;
      };
      c.native = {
        instance: {
          global: {
            get: function () {
              return this.global;
            }
          },
          source: {
            get: function () {
              return this.source;
            }
          },
          ignoreCase: {
            get: function () {
              return this.ignoreCase;
            }
          },
          multiline: {
            get: function () {
              return this.multiline;
            }
          },
          lastIndex: {
            get: function () {
              return this.lastIndex;
            },
            set: function (i) {
              this.lastIndex = i;
            }
          },
          dotall: {
            get: function () {
              return this.dotall;
            }
          },
          extended: {
            get: function () {
              return this.extended;
            }
          },
          exec: RegExpClass.exec,
          test: RegExpClass.test
        }
      };
      return c;
    }
    function NamespaceClass(runtime, scope, instanceConstructor, baseClass) {
      ASNamespace = function ASNamespace(prefixValue, uriValue) {
        if (uriValue === undefined) {
          uriValue = prefixValue;
          prefixValue = undefined;
        }
        var prefix, uri;
        if (prefixValue === undefined) {
          if (uriValue === undefined) {
            prefix = '';
            uri = '';
          } else if (typeof uriValue === 'object') {
            prefix = uriValue.prefix;
            if (uriValue instanceof ShumwayNamespace) {
              uri = uriValue.originalURI;
            } else if (uriValue instanceof QName) {
              uri = uriValue.uri;
            }
          } else {
            uri = uriValue + '';
            if (uri === '') {
              prefix = '';
            } else {
              prefix = undefined;
            }
          }
        } else {
          if (typeof uriValue === 'object' && uriValue instanceof QName && uriValue.uri !== null) {
            uri = uriValue.uri;
          } else {
            uri = uriValue + '';
          }
          if (uri === '') {
            if (prefixValue === undefined || prefixValue + '' === '') {
              prefix = '';
            } else {
              throw 'type error';
            }
          } else if (prefixValue === undefined || prefixValue === '') {
            prefix = undefined;
          } else if (false && !isXMLName(prefixValue)) {
            prefix = undefined;
          } else {
            prefix = prefixValue + '';
          }
        }
        return ShumwayNamespace.createNamespace(uri, prefix);
      };
      var c = new Class('Namespace', ASNamespace, C(ASNamespace));
      c.extendNative(baseClass, ShumwayNamespace);
      var Np = ShumwayNamespace.prototype;
      c.native = {
        instance: {
          prefix: {
            get: Np.getPrefix
          },
          uri: {
            get: Np.getURI
          }
        }
      };
      return c;
    }
    function JSONClass(runtime, scope, instanceConstructor, baseClass) {
      function transformJSValueToAS(value) {
        if (typeof value !== 'object') {
          return value;
        }
        var keys = Object.keys(value);
        var result = value instanceof Array ? [] : {};
        for (var i = 0; i < keys.length; i++) {
          result.asSetPublicProperty(keys[i], transformJSValueToAS(value[keys[i]]));
        }
        return result;
      }
      function transformASValueToJS(value) {
        if (typeof value !== 'object') {
          return value;
        }
        var keys = Object.keys(value);
        var result = value instanceof Array ? [] : {};
        for (var i = 0; i < keys.length; i++) {
          var key = keys[i];
          var jsKey = key;
          if (!isNumeric(key)) {
            jsKey = fromResolvedName(key);
          }
          result[jsKey] = transformASValueToJS(value[key]);
        }
        return result;
      }
      function ASJSON() {
      }
      var c = new Class('JSON', ASJSON, C(ASJSON));
      c.extend(baseClass);
      c.native = {
        static: {
          parseCore: function parseCore(text) {
            return transformJSValueToAS(JSON.parse(text));
          },
          stringifySpecializedToString: function stringifySpecializedToString(value, replacerArray, replacerFunction, gap) {
            return JSON.stringify(transformASValueToJS(value), replacerFunction, gap);
          }
        }
      };
      return c;
    }
    function CapabilitiesClass(runtime, scope, instanceConstructor, baseClass) {
      function Capabilities() {
      }
      var c = new Class('Capabilities', Capabilities, C(Capabilities));
      c.extend(baseClass);
      c.native = {
        static: {
          playerType: {
            get: function () {
              return 'AVMPlus';
            }
          }
        }
      };
      return c;
    }
    function FileClass(runtime, scope, instanceConstructor, baseClass) {
      function File() {
      }
      var c = new Class('File', File, C(File));
      c.extend(baseClass);
      c.native = {
        static: {
          exists: function (filename) {
            notImplemented('File.exists');
            return false;
          },
          read: function (filename) {
            return snarf(filename);
          },
          write: function (filename, data) {
            notImplemented('File.write');
            return true;
          },
          readByteArray: function (filename) {
            var ByteArrayClass = AVM2.currentDomain().getClass('flash.utils.ByteArray');
            var data = ByteArrayClass.createInstance();
            data.writeRawBytes(snarf(filename, 'binary'));
            return data;
          },
          writeByteArray: function (filename, bytes) {
            write('bin/' + filename, bytes.getBytes());
            return true;
          }
        }
      };
      return c;
    }
    function ShumwayClass(runtime, scope, instanceConstructor, baseClass) {
      function Shumway() {
      }
      var c = new Class('Shumway', Shumway, C(Shumway));
      c.extend(baseClass);
      c.native = {
        static: {
          info: function (x) {
            console.info(x);
          },
          json: function (x) {
            return JSON.stringify(x);
          },
          eval: function (x) {
            return eval(x);
          },
          debugger: function (x) {
            debugger;
          }
        }
      };
      return c;
    }
    function constant(x) {
      return function () {
        return x;
      };
    }
    function ByteArrayClass(runtime, scope, instanceConstructor, baseClass) {
      var INITIAL_SIZE = 128;
      var defaultObjectEncoding = 3;
      function ByteArray(bytes) {
        var initData = bytes || this.symbol && this.symbol.data;
        if (initData) {
          this.a = new ArrayBuffer(initData.length);
          this.length = initData.length;
          new Uint8Array(this.a).set(initData);
        } else {
          this.a = new ArrayBuffer(INITIAL_SIZE);
          this.length = 0;
        }
        this.position = 0;
        this.cacheViews();
        this.nativele = new Int8Array(new Int32Array([]).buffer)[0] === 1;
        this.le = this.nativele;
        this.objectEncoding = defaultObjectEncoding;
      }
      function throwEOFError() {
        runtime.throwErrorFromVM('flash.errors.EOFError', 'End of file was encountered.');
      }
      function throwRangeError() {
        var error = Errors.ParamRangeError;
        runtime.throwErrorFromVM('RangeError', getErrorMessage(error.code), error.code);
      }
      function checkRange(x, min, max) {
        if (x !== clamp(x, min, max)) {
          throwRangeError();
        }
      }
      function get(b, m, size) {
        if (b.position + size > b.length) {
          throwEOFError();
        }
        var v = b.view[m](b.position, b.le);
        b.position += size;
        return v;
      }
      function set(b, m, size, v) {
        var len = b.position + size;
        b.ensureCapacity(len);
        b.view[m](b.position, v, b.le);
        b.position = len;
        if (len > b.length) {
          b.length = len;
        }
      }
      var c = new Class('ByteArray', ByteArray, C(ByteArray));
      c.extendBuiltin(baseClass);
      var BAp = ByteArray.prototype;
      BAp.asGetNumericProperty = function (i) {
        if (i >= this.length) {
          return undefined;
        }
        return this.uint8v[i];
      };
      BAp.asSetNumericProperty = function (i, v) {
        var len = i + 1;
        this.ensureCapacity(len);
        this.uint8v[i] = v;
        if (len > this.length) {
          this.length = len;
        }
      };
      BAp.cacheViews = function cacheViews() {
        var a = this.a;
        this.int8v = new Int8Array(a);
        this.uint8v = new Uint8Array(a);
        this.view = new DataView(a);
      };
      BAp.getBytes = function getBytes() {
        return new Uint8Array(this.a, 0, this.length);
      };
      BAp.ensureCapacity = function ensureCapacity(size) {
        var origa = this.a;
        if (origa.byteLength < size) {
          var newSize = origa.byteLength;
          while (newSize < size) {
            newSize *= 2;
          }
          var copya = new ArrayBuffer(newSize);
          var origv = this.int8v;
          this.a = copya;
          this.cacheViews();
          this.int8v.set(origv);
        }
      };
      BAp.clear = function clear() {
        this.length = 0;
        this.position = 0;
      };
      BAp.readBoolean = function readBoolean() {
        if (this.position + 1 > this.length) {
          throwEOFError();
        }
        return this.int8v[this.position++] !== 0;
      };
      BAp.readByte = function readByte() {
        if (this.position + 1 > this.length) {
          throwEOFError();
        }
        return th